/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.exception.GreqlException;
import de.uni_koblenz.jgralab.greql.funlib.AcceptsUndefinedArguments;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.greql.funlib.NeedsEvaluatorArgument;
import de.uni_koblenz.jgralab.greql.funlib.NeedsGraphArgument;
import de.uni_koblenz.jgralab.greql.funlib.artithmetics.Abs;
import de.uni_koblenz.jgralab.greql.funlib.artithmetics.Add;
import de.uni_koblenz.jgralab.greql.funlib.artithmetics.Ceil;
import de.uni_koblenz.jgralab.greql.funlib.artithmetics.Cos;
import de.uni_koblenz.jgralab.greql.funlib.artithmetics.Div;
import de.uni_koblenz.jgralab.greql.funlib.artithmetics.Exp;
import de.uni_koblenz.jgralab.greql.funlib.artithmetics.Floor;
import de.uni_koblenz.jgralab.greql.funlib.artithmetics.Ln;
import de.uni_koblenz.jgralab.greql.funlib.artithmetics.Mod;
import de.uni_koblenz.jgralab.greql.funlib.artithmetics.Mul;
import de.uni_koblenz.jgralab.greql.funlib.artithmetics.Neg;
import de.uni_koblenz.jgralab.greql.funlib.artithmetics.Round;
import de.uni_koblenz.jgralab.greql.funlib.artithmetics.Sin;
import de.uni_koblenz.jgralab.greql.funlib.artithmetics.Sqrt;
import de.uni_koblenz.jgralab.greql.funlib.artithmetics.Sub;
import de.uni_koblenz.jgralab.greql.funlib.artithmetics.Tan;
import de.uni_koblenz.jgralab.greql.funlib.artithmetics.ToDouble;
import de.uni_koblenz.jgralab.greql.funlib.artithmetics.ToInteger;
import de.uni_koblenz.jgralab.greql.funlib.artithmetics.ToLong;
import de.uni_koblenz.jgralab.greql.funlib.bitops.BitAnd;
import de.uni_koblenz.jgralab.greql.funlib.bitops.BitNot;
import de.uni_koblenz.jgralab.greql.funlib.bitops.BitOr;
import de.uni_koblenz.jgralab.greql.funlib.bitops.BitShl;
import de.uni_koblenz.jgralab.greql.funlib.bitops.BitShr;
import de.uni_koblenz.jgralab.greql.funlib.bitops.BitUnsignedShr;
import de.uni_koblenz.jgralab.greql.funlib.bitops.BitXor;
import de.uni_koblenz.jgralab.greql.funlib.collections.Contains;
import de.uni_koblenz.jgralab.greql.funlib.collections.ContainsKey;
import de.uni_koblenz.jgralab.greql.funlib.collections.ContainsValue;
import de.uni_koblenz.jgralab.greql.funlib.collections.Difference;
import de.uni_koblenz.jgralab.greql.funlib.collections.EntrySet;
import de.uni_koblenz.jgralab.greql.funlib.collections.Get;
import de.uni_koblenz.jgralab.greql.funlib.collections.IndexOf;
import de.uni_koblenz.jgralab.greql.funlib.collections.Intersection;
import de.uni_koblenz.jgralab.greql.funlib.collections.IsEmpty;
import de.uni_koblenz.jgralab.greql.funlib.collections.IsSubSet;
import de.uni_koblenz.jgralab.greql.funlib.collections.KeySet;
import de.uni_koblenz.jgralab.greql.funlib.collections.Pos;
import de.uni_koblenz.jgralab.greql.funlib.collections.Sort;
import de.uni_koblenz.jgralab.greql.funlib.collections.SortByColumn;
import de.uni_koblenz.jgralab.greql.funlib.collections.SubCollection;
import de.uni_koblenz.jgralab.greql.funlib.collections.TheElement;
import de.uni_koblenz.jgralab.greql.funlib.collections.ToList;
import de.uni_koblenz.jgralab.greql.funlib.collections.ToSet;
import de.uni_koblenz.jgralab.greql.funlib.collections.Union;
import de.uni_koblenz.jgralab.greql.funlib.collections.Values;
import de.uni_koblenz.jgralab.greql.funlib.graph.Alpha;
import de.uni_koblenz.jgralab.greql.funlib.graph.AlphaIncidenceIndex;
import de.uni_koblenz.jgralab.greql.funlib.graph.Degree;
import de.uni_koblenz.jgralab.greql.funlib.graph.Depth;
import de.uni_koblenz.jgralab.greql.funlib.graph.Describe;
import de.uni_koblenz.jgralab.greql.funlib.graph.Distance;
import de.uni_koblenz.jgralab.greql.funlib.graph.EdgeSetSubgraph;
import de.uni_koblenz.jgralab.greql.funlib.graph.EdgeTrace;
import de.uni_koblenz.jgralab.greql.funlib.graph.EdgeTypeSubgraph;
import de.uni_koblenz.jgralab.greql.funlib.graph.Edges;
import de.uni_koblenz.jgralab.greql.funlib.graph.EdgesConnected;
import de.uni_koblenz.jgralab.greql.funlib.graph.EdgesFrom;
import de.uni_koblenz.jgralab.greql.funlib.graph.EdgesTo;
import de.uni_koblenz.jgralab.greql.funlib.graph.ElementSetSubgraph;
import de.uni_koblenz.jgralab.greql.funlib.graph.EndVertex;
import de.uni_koblenz.jgralab.greql.funlib.graph.ExtractPaths;
import de.uni_koblenz.jgralab.greql.funlib.graph.First;
import de.uni_koblenz.jgralab.greql.funlib.graph.FirstEdge;
import de.uni_koblenz.jgralab.greql.funlib.graph.FirstIn;
import de.uni_koblenz.jgralab.greql.funlib.graph.FirstOut;
import de.uni_koblenz.jgralab.greql.funlib.graph.FirstVertex;
import de.uni_koblenz.jgralab.greql.funlib.graph.GetEdge;
import de.uni_koblenz.jgralab.greql.funlib.graph.GetValue;
import de.uni_koblenz.jgralab.greql.funlib.graph.GetVertex;
import de.uni_koblenz.jgralab.greql.funlib.graph.Id;
import de.uni_koblenz.jgralab.greql.funlib.graph.InDegree;
import de.uni_koblenz.jgralab.greql.funlib.graph.InIncidences;
import de.uni_koblenz.jgralab.greql.funlib.graph.IncidenceIndex;
import de.uni_koblenz.jgralab.greql.funlib.graph.Incidences;
import de.uni_koblenz.jgralab.greql.funlib.graph.InverseEdge;
import de.uni_koblenz.jgralab.greql.funlib.graph.IsAcyclic;
import de.uni_koblenz.jgralab.greql.funlib.graph.IsIsolated;
import de.uni_koblenz.jgralab.greql.funlib.graph.IsLoop;
import de.uni_koblenz.jgralab.greql.funlib.graph.IsReachable;
import de.uni_koblenz.jgralab.greql.funlib.graph.Last;
import de.uni_koblenz.jgralab.greql.funlib.graph.LastIn;
import de.uni_koblenz.jgralab.greql.funlib.graph.LastOut;
import de.uni_koblenz.jgralab.greql.funlib.graph.Leaves;
import de.uni_koblenz.jgralab.greql.funlib.graph.Next;
import de.uni_koblenz.jgralab.greql.funlib.graph.NextGraphElement;
import de.uni_koblenz.jgralab.greql.funlib.graph.NextIn;
import de.uni_koblenz.jgralab.greql.funlib.graph.NextOut;
import de.uni_koblenz.jgralab.greql.funlib.graph.NormalEdge;
import de.uni_koblenz.jgralab.greql.funlib.graph.Omega;
import de.uni_koblenz.jgralab.greql.funlib.graph.OmegaIncidenceIndex;
import de.uni_koblenz.jgralab.greql.funlib.graph.OutDegree;
import de.uni_koblenz.jgralab.greql.funlib.graph.OutIncidences;
import de.uni_koblenz.jgralab.greql.funlib.graph.Path;
import de.uni_koblenz.jgralab.greql.funlib.graph.PathLength;
import de.uni_koblenz.jgralab.greql.funlib.graph.PathSystem;
import de.uni_koblenz.jgralab.greql.funlib.graph.ReachableVertices;
import de.uni_koblenz.jgralab.greql.funlib.graph.ReversedEdge;
import de.uni_koblenz.jgralab.greql.funlib.graph.Slice;
import de.uni_koblenz.jgralab.greql.funlib.graph.StartVertex;
import de.uni_koblenz.jgralab.greql.funlib.graph.That;
import de.uni_koblenz.jgralab.greql.funlib.graph.ThatIncidenceIndex;
import de.uni_koblenz.jgralab.greql.funlib.graph.This;
import de.uni_koblenz.jgralab.greql.funlib.graph.ThisIncidenceIndex;
import de.uni_koblenz.jgralab.greql.funlib.graph.TopologicalSort;
import de.uni_koblenz.jgralab.greql.funlib.graph.VertexSetSubgraph;
import de.uni_koblenz.jgralab.greql.funlib.graph.VertexTrace;
import de.uni_koblenz.jgralab.greql.funlib.graph.VertexTypeSubgraph;
import de.uni_koblenz.jgralab.greql.funlib.graph.Vertices;
import de.uni_koblenz.jgralab.greql.funlib.graph.base.DegreeFunction;
import de.uni_koblenz.jgralab.greql.funlib.logics.And;
import de.uni_koblenz.jgralab.greql.funlib.logics.Not;
import de.uni_koblenz.jgralab.greql.funlib.logics.Or;
import de.uni_koblenz.jgralab.greql.funlib.logics.Xor;
import de.uni_koblenz.jgralab.greql.funlib.misc.GreqlQueryFunction;
import de.uni_koblenz.jgralab.greql.funlib.misc.GreqlQueryFunctionWithGraphArgument;
import de.uni_koblenz.jgralab.greql.funlib.misc.IsDefined;
import de.uni_koblenz.jgralab.greql.funlib.misc.IsUndefined;
import de.uni_koblenz.jgralab.greql.funlib.misc.Log;
import de.uni_koblenz.jgralab.greql.funlib.misc.ValueType;
import de.uni_koblenz.jgralab.greql.funlib.relations.Equals;
import de.uni_koblenz.jgralab.greql.funlib.relations.GrEqual;
import de.uni_koblenz.jgralab.greql.funlib.relations.GrThan;
import de.uni_koblenz.jgralab.greql.funlib.relations.LeEqual;
import de.uni_koblenz.jgralab.greql.funlib.relations.LeThan;
import de.uni_koblenz.jgralab.greql.funlib.relations.Nequals;
import de.uni_koblenz.jgralab.greql.funlib.schema.AttributeNames;
import de.uni_koblenz.jgralab.greql.funlib.schema.Attributes;
import de.uni_koblenz.jgralab.greql.funlib.schema.HasAttribute;
import de.uni_koblenz.jgralab.greql.funlib.schema.HasComponent;
import de.uni_koblenz.jgralab.greql.funlib.schema.HasType;
import de.uni_koblenz.jgralab.greql.funlib.schema.Type;
import de.uni_koblenz.jgralab.greql.funlib.schema.TypeName;
import de.uni_koblenz.jgralab.greql.funlib.statistics.Count;
import de.uni_koblenz.jgralab.greql.funlib.statistics.Max;
import de.uni_koblenz.jgralab.greql.funlib.statistics.Mean;
import de.uni_koblenz.jgralab.greql.funlib.statistics.Min;
import de.uni_koblenz.jgralab.greql.funlib.statistics.Sdev;
import de.uni_koblenz.jgralab.greql.funlib.statistics.Sum;
import de.uni_koblenz.jgralab.greql.funlib.statistics.Variance;
import de.uni_koblenz.jgralab.greql.funlib.strings.CapitalizeFirst;
import de.uni_koblenz.jgralab.greql.funlib.strings.Concat;
import de.uni_koblenz.jgralab.greql.funlib.strings.EndsWith;
import de.uni_koblenz.jgralab.greql.funlib.strings.Join;
import de.uni_koblenz.jgralab.greql.funlib.strings.Length;
import de.uni_koblenz.jgralab.greql.funlib.strings.LowerCase;
import de.uni_koblenz.jgralab.greql.funlib.strings.ReMatch;
import de.uni_koblenz.jgralab.greql.funlib.strings.Replace;
import de.uni_koblenz.jgralab.greql.funlib.strings.Split;
import de.uni_koblenz.jgralab.greql.funlib.strings.StartsWith;
import de.uni_koblenz.jgralab.greql.funlib.strings.Substring;
import de.uni_koblenz.jgralab.greql.funlib.strings.ToString;
import de.uni_koblenz.jgralab.greql.funlib.strings.UpperCase;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;
import de.uni_koblenz.jgralab.greql.types.Types;
import de.uni_koblenz.jgralab.greql.types.Undefined;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;

public class FunLib {
    private static final Map<String, FunctionInfo> functions;
    private static final TreeSet<String> functionNames;
    private static final Logger logger;

    private FunLib() {
    }

    public static final boolean contains(String name) {
        return functions.containsKey(name);
    }

    private static final String getFunctionName(String className) {
        return Character.toLowerCase(className.charAt(0)) + className.substring(1);
    }

    private static final String getFunctionName(Class<? extends Function> cls) {
        return FunLib.getFunctionName(cls.getSimpleName());
    }

    public static final String getArgumentAsString(Object arg) {
        if (arg == null) {
            arg = Undefined.UNDEFINED;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Types.getGreqlTypeName(arg));
        if (arg instanceof String) {
            sb.append(": ").append('\"').append(arg.toString().replace("\"", "\\\"")).append('\"');
        } else if (!(arg instanceof Graph) && !(arg instanceof Undefined)) {
            sb.append(": ").append(arg);
        }
        return sb.toString();
    }

    public static final Object apply(PrintStream os, String name, Object ... args) {
        assert (name != null && name.length() >= 1);
        assert (args != null);
        assert (FunLib.validArgumentTypes(args));
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        if (args.length == 0) {
            sb.append("()");
        } else {
            String delim = "(";
            for (Object arg : args) {
                sb.append(delim).append(FunLib.getArgumentAsString(arg));
                delim = ", ";
            }
            sb.append(")");
        }
        os.print(sb);
        Object result = FunLib.apply(name, args);
        os.println(" -> " + FunLib.getArgumentAsString(result));
        return result;
    }

    public static final Object apply(FunctionInfo fi, Object ... args) {
        assert (fi != null);
        if (!fi.acceptsUndefinedValues) {
            for (Object arg : args) {
                if (arg != null && arg != Undefined.UNDEFINED) continue;
                return Undefined.UNDEFINED;
            }
        }
        for (Signature sig : fi.signatures) {
            if (!sig.matches(args)) continue;
            try {
                Object result = sig.evaluateMethod.invoke((Object)fi.function, args);
                assert (Types.isValidGreqlValue(result));
                return result == null ? Undefined.UNDEFINED : result;
            }
            catch (IllegalArgumentException e) {
                if (e.getCause() instanceof GreqlException) {
                    throw (GreqlException)e.getCause();
                }
                throw new GreqlException(e.getMessage(), e.getCause());
            }
            catch (IllegalAccessException e) {
                if (e.getCause() instanceof GreqlException) {
                    throw (GreqlException)e.getCause();
                }
                throw new GreqlException(e.getMessage(), e.getCause());
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof GreqlException) {
                    throw (GreqlException)e.getCause();
                }
                throw new GreqlException(e.getMessage(), e.getCause());
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Function '").append(fi.name).append("' not defined for argument types (");
        String delim = "";
        for (Object arg : args) {
            sb.append(delim).append(Types.getGreqlTypeName(arg));
            delim = ", ";
        }
        sb.append(")");
        throw new GreqlException(sb.toString());
    }

    public static final Object apply(String name, Object ... args) {
        assert (name != null && name.length() >= 1);
        assert (args != null);
        assert (FunLib.validArgumentTypes(args));
        FunctionInfo fi = FunLib.getFunctionInfo(name);
        if (fi == null) {
            throw new GreqlException("Call to unknown function '" + name + "'");
        }
        return FunLib.apply(fi, args);
    }

    private static final boolean validArgumentTypes(Object[] args) {
        for (Object arg : args) {
            if (Types.isValidGreqlValue(arg)) continue;
            throw new GreqlException("Type unknown to GReQL: " + arg.getClass().getName() + ", value: " + arg);
        }
        return true;
    }

    public static final void register(String className) throws ClassNotFoundException {
        Class<?> cls = Class.forName(className);
        FunLib.register(cls.asSubclass(Function.class));
    }

    public static final void register(Class<? extends Function> cls) {
        int mods = cls.getModifiers();
        if (Modifier.isAbstract(mods) || Modifier.isInterface(mods) || !Modifier.isPublic(mods)) {
            return;
        }
        String name = FunLib.getFunctionName(cls);
        FunctionInfo fn = functions.get(name);
        if (fn != null) {
            if (fn.functionClass == cls) {
                return;
            }
            throw new GreqlException("Duplicate function name '" + name + "'");
        }
        logger.fine("Registering " + cls.getName() + " as '" + name + "'");
        functions.put(name, new FunctionInfo(name, cls));
        functionNames.add(name);
    }

    public static final void registerGreqlQueryFunction(GreqlQuery query, boolean needsGraphArgument, long costs, long cardinality, double selectivity) {
        String name = query.getName();
        if (name == null) {
            throw new GreqlException("The name of a GReQL function must not be null!");
        }
        if (!name.matches("^\\w+$")) {
            throw new GreqlException("Invalid GReQL function name '" + name + "'. Only word characters are allowed.");
        }
        FunctionInfo fn = FunLib.getFunctionInfo(name);
        if (fn != null) {
            throw new GreqlException("Duplicate function name '" + name + "'");
        }
        logger.fine("Registering GReQL function as '" + name + "'");
        GreqlQueryFunction greqlFunction = needsGraphArgument ? new GreqlQueryFunctionWithGraphArgument(query, costs, cardinality, selectivity) : new GreqlQueryFunction(query, costs, cardinality, selectivity);
        functions.put(name, new FunctionInfo(name, greqlFunction));
        functionNames.add(name);
    }

    public static final void removeGreqlQueryFunction(String name) {
        FunctionInfo fn = FunLib.getFunctionInfo(name);
        if (!(fn.getFunction() instanceof GreqlQueryFunction)) {
            throw new IllegalArgumentException("Function " + name + " is not a GreqlQueryFunction.");
        }
        functions.remove(name);
        functionNames.remove(name);
    }

    public static final Set<String> getFunctionNames() {
        return Collections.unmodifiableSet(functionNames);
    }

    public static final FunctionInfo getFunctionInfo(String functionName) {
        return functions.get(functionName);
    }

    public static void generateLaTeXFunctionDocs(String fileName) throws IOException {
        LaTeXFunctionDocsGenerator docGen = new LaTeXFunctionDocsGenerator(fileName, functions);
        docGen.generate();
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("Generate a LaTeX documentation for all known GReQL functions.");
            System.out.println("Usage: java FunLib /path/to/fundocs.tex");
        } else {
            FunLib.generateLaTeXFunctionDocs(args[0]);
        }
    }

    static {
        logger = JGraLab.getLogger(FunLib.class);
        functions = new HashMap<String, FunctionInfo>();
        functionNames = new TreeSet();
        logger.fine("Registering builtin functions");
        FunLib.register(Abs.class);
        FunLib.register(Add.class);
        FunLib.register(Ceil.class);
        FunLib.register(Cos.class);
        FunLib.register(Div.class);
        FunLib.register(Exp.class);
        FunLib.register(Floor.class);
        FunLib.register(Ln.class);
        FunLib.register(Mod.class);
        FunLib.register(Mul.class);
        FunLib.register(Neg.class);
        FunLib.register(Round.class);
        FunLib.register(Sin.class);
        FunLib.register(Sqrt.class);
        FunLib.register(Sub.class);
        FunLib.register(Tan.class);
        FunLib.register(ToDouble.class);
        FunLib.register(ToInteger.class);
        FunLib.register(ToLong.class);
        FunLib.register(BitAnd.class);
        FunLib.register(BitNot.class);
        FunLib.register(BitOr.class);
        FunLib.register(BitShl.class);
        FunLib.register(BitShr.class);
        FunLib.register(BitUnsignedShr.class);
        FunLib.register(BitXor.class);
        FunLib.register(Contains.class);
        FunLib.register(ContainsKey.class);
        FunLib.register(ContainsValue.class);
        FunLib.register(Difference.class);
        FunLib.register(EntrySet.class);
        FunLib.register(Get.class);
        FunLib.register(IndexOf.class);
        FunLib.register(Intersection.class);
        FunLib.register(IsEmpty.class);
        FunLib.register(IsSubSet.class);
        FunLib.register(KeySet.class);
        FunLib.register(Pos.class);
        FunLib.register(Sort.class);
        FunLib.register(SortByColumn.class);
        FunLib.register(SubCollection.class);
        FunLib.register(TheElement.class);
        FunLib.register(ToList.class);
        FunLib.register(ToSet.class);
        FunLib.register(Union.class);
        FunLib.register(Values.class);
        FunLib.register(Alpha.class);
        FunLib.register(AlphaIncidenceIndex.class);
        FunLib.register(Degree.class);
        FunLib.register(DegreeFunction.class);
        FunLib.register(Depth.class);
        FunLib.register(Describe.class);
        FunLib.register(Distance.class);
        FunLib.register(Edges.class);
        FunLib.register(EdgesConnected.class);
        FunLib.register(EdgesFrom.class);
        FunLib.register(EdgesTo.class);
        FunLib.register(EdgeTrace.class);
        FunLib.register(EdgeTypeSubgraph.class);
        FunLib.register(EdgeSetSubgraph.class);
        FunLib.register(ElementSetSubgraph.class);
        FunLib.register(EndVertex.class);
        FunLib.register(ExtractPaths.class);
        FunLib.register(First.class);
        FunLib.register(FirstEdge.class);
        FunLib.register(FirstIn.class);
        FunLib.register(FirstOut.class);
        FunLib.register(FirstVertex.class);
        FunLib.register(GetEdge.class);
        FunLib.register(GetValue.class);
        FunLib.register(GetVertex.class);
        FunLib.register(Id.class);
        FunLib.register(InDegree.class);
        FunLib.register(Incidences.class);
        FunLib.register(IncidenceIndex.class);
        FunLib.register(InverseEdge.class);
        FunLib.register(InIncidences.class);
        FunLib.register(IsAcyclic.class);
        FunLib.register(IsIsolated.class);
        FunLib.register(IsLoop.class);
        FunLib.register(IsReachable.class);
        FunLib.register(Last.class);
        FunLib.register(LastIn.class);
        FunLib.register(LastOut.class);
        FunLib.register(Leaves.class);
        FunLib.register(Next.class);
        FunLib.register(NextGraphElement.class);
        FunLib.register(NextIn.class);
        FunLib.register(NextOut.class);
        FunLib.register(NormalEdge.class);
        FunLib.register(Omega.class);
        FunLib.register(OmegaIncidenceIndex.class);
        FunLib.register(OutDegree.class);
        FunLib.register(OutIncidences.class);
        FunLib.register(PathLength.class);
        FunLib.register(Path.class);
        FunLib.register(PathSystem.class);
        FunLib.register(ReachableVertices.class);
        FunLib.register(ReversedEdge.class);
        FunLib.register(Slice.class);
        FunLib.register(StartVertex.class);
        FunLib.register(This.class);
        FunLib.register(ThisIncidenceIndex.class);
        FunLib.register(That.class);
        FunLib.register(ThatIncidenceIndex.class);
        FunLib.register(TopologicalSort.class);
        FunLib.register(VertexTrace.class);
        FunLib.register(Vertices.class);
        FunLib.register(VertexTypeSubgraph.class);
        FunLib.register(VertexSetSubgraph.class);
        FunLib.register(And.class);
        FunLib.register(Not.class);
        FunLib.register(Or.class);
        FunLib.register(Xor.class);
        FunLib.register(IsDefined.class);
        FunLib.register(IsUndefined.class);
        FunLib.register(Log.class);
        FunLib.register(ValueType.class);
        FunLib.register(Equals.class);
        FunLib.register(GrEqual.class);
        FunLib.register(GrThan.class);
        FunLib.register(LeEqual.class);
        FunLib.register(LeThan.class);
        FunLib.register(Nequals.class);
        FunLib.register(AttributeNames.class);
        FunLib.register(Attributes.class);
        FunLib.register(HasAttribute.class);
        FunLib.register(HasComponent.class);
        FunLib.register(HasType.class);
        FunLib.register(Type.class);
        FunLib.register(TypeName.class);
        FunLib.register(Count.class);
        FunLib.register(Max.class);
        FunLib.register(Mean.class);
        FunLib.register(Min.class);
        FunLib.register(Sdev.class);
        FunLib.register(Sum.class);
        FunLib.register(Variance.class);
        FunLib.register(CapitalizeFirst.class);
        FunLib.register(Concat.class);
        FunLib.register(EndsWith.class);
        FunLib.register(Join.class);
        FunLib.register(Length.class);
        FunLib.register(LowerCase.class);
        FunLib.register(ReMatch.class);
        FunLib.register(Replace.class);
        FunLib.register(Split.class);
        FunLib.register(StartsWith.class);
        FunLib.register(Substring.class);
        FunLib.register(ToString.class);
        FunLib.register(UpperCase.class);
    }

    private static class LaTeXFunctionDocsGenerator {
        private final BufferedWriter bw;
        private final Map<Function.Category, SortedMap<String, AnnotationInfo>> cat2funs = new HashMap<Function.Category, SortedMap<String, AnnotationInfo>>();
        private final boolean STANDALONE = false;

        LaTeXFunctionDocsGenerator(String fileName, Map<String, FunctionInfo> funs) throws IOException {
            this.bw = new BufferedWriter(new FileWriter(fileName));
            this.fillCat2Funs(funs);
        }

        private void fillCat2Funs(Map<String, FunctionInfo> funs) {
            for (Map.Entry<String, FunctionInfo> e : funs.entrySet()) {
                Class<?> funClass = e.getValue().getFunction().getClass();
                assert (funClass.getConstructors().length == 1);
                Constructor<?> cons = funClass.getConstructors()[0];
                String name = e.getKey();
                String constructorDescription = null;
                Description consAnno = cons.getAnnotation(Description.class);
                if (consAnno != null) {
                    constructorDescription = consAnno.description();
                }
                HashMap<Function.Category, ArrayList<SignatureInfo>> cat2sig = new HashMap<Function.Category, ArrayList<SignatureInfo>>();
                int methodCount = e.getValue().signatures.length;
                for (int i = 0; i < methodCount; ++i) {
                    this.createSigInfo(e, consAnno, cat2sig, i);
                }
                for (Function.Category cat : cat2sig.keySet()) {
                    SortedMap<String, AnnotationInfo> m = this.cat2funs.get((Object)cat);
                    if (m == null) {
                        m = new TreeMap<String, AnnotationInfo>();
                        this.cat2funs.put(cat, m);
                    }
                    AnnotationInfo aninfo = new AnnotationInfo();
                    aninfo.name = name;
                    aninfo.constructorDescription = constructorDescription;
                    aninfo.signatureInfos = cat2sig.get((Object)cat).toArray(new SignatureInfo[0]);
                    m.put(aninfo.name, aninfo);
                    this.cat2funs.put(cat, m);
                }
            }
        }

        private void createSigInfo(Map.Entry<String, FunctionInfo> e, Description consAnno, HashMap<Function.Category, ArrayList<SignatureInfo>> cat2sig, int i) {
            SignatureInfo si = new SignatureInfo();
            si.signature = e.getValue().signatures[i];
            Method m = si.signature.evaluateMethod;
            Description des = m.getAnnotation(Description.class);
            if (des == null || des.params() == null) {
                si.params = consAnno.params();
            } else {
                si.description = des.description();
                si.params = des.params();
            }
            if (e.getValue().needsEvaluatorArgument()) {
                assert (si.params[0].equals("internal"));
                si.params = Arrays.copyOfRange(si.params, 1, si.params.length);
            }
            if (des != null && des.categories() != null) {
                for (Function.Category cat : des.categories()) {
                    if (!cat2sig.containsKey((Object)cat)) {
                        cat2sig.put(cat, new ArrayList());
                    }
                    cat2sig.get((Object)cat).add(si);
                }
            } else {
                for (Function.Category cat : consAnno.categories()) {
                    if (!cat2sig.containsKey((Object)cat)) {
                        cat2sig.put(cat, new ArrayList());
                    }
                    cat2sig.get((Object)cat).add(si);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void generate() throws IOException {
            try {
                this.write("\\twocolumn");
                this.newLine();
                this.newLine();
                for (Function.Category cat : Function.Category.values()) {
                    if (this.cat2funs.get((Object)cat) == null) continue;
                    this.generateCategoryDocs(cat);
                }
            }
            finally {
                this.bw.close();
            }
        }

        private void write(String ... strings) throws IOException {
            for (String s : strings) {
                this.bw.write(s);
            }
        }

        private void newLine() throws IOException {
            this.bw.newLine();
        }

        private void generateCategoryDocs(Function.Category cat) throws IOException {
            String heading = cat.toString().toLowerCase().replace('_', ' ');
            heading = heading.substring(0, 1).toUpperCase().concat(heading.substring(1));
            this.newLine();
            this.write("\\subsection{" + heading + "}");
            this.newLine();
            SortedMap<String, AnnotationInfo> funs = this.cat2funs.get((Object)cat);
            for (AnnotationInfo e : funs.values()) {
                this.generateFunctionDocs(e);
            }
        }

        private void generateFunctionDocs(AnnotationInfo info) throws IOException {
            this.newLine();
            this.write("\\paragraph*{" + info.name + ".}");
            if (info.constructorDescription != null) {
                this.write(info.constructorDescription);
            }
            this.newLine();
            System.out.println("Generating docs for function: " + info.name);
            this.generateSignatures(info);
            this.newLine();
        }

        private void generateSignatures(AnnotationInfo info) throws IOException {
            this.write("\\begin{description}");
            for (SignatureInfo sig : info.signatureInfos) {
                this.write("\n\\item [$" + info.name + ":$ ] $");
                String delim = "";
                int correction = 0;
                for (int i = 0; i < sig.signature.parameterTypes.length; ++i) {
                    if (sig.signature.parameterTypes[i] == InternalGreqlEvaluator.class) {
                        ++correction;
                        continue;
                    }
                    this.write(delim);
                    this.write(Types.getGreqlTypeName(sig.signature.parameterTypes[i]));
                    this.write("\\; ");
                    this.write(sig.params[i - correction]);
                    delim = " \\times ";
                }
                this.write(" \\longrightarrow ");
                this.write(Types.getGreqlTypeName(sig.signature.evaluateMethod.getReturnType()));
                this.write("$");
                if (sig.description == null) continue;
                this.write("\\\\\n\t");
                this.write(sig.description);
            }
            this.write("\n\\end{description}");
        }

        private class SignatureInfo {
            String description;
            String[] params;
            Signature signature;

            private SignatureInfo() {
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("### SignatureInfo ###\n");
                sb.append(this.signature.toString());
                sb.append('\n');
                if (this.params != null) {
                    sb.append(Arrays.toString(this.params));
                }
                sb.append('\n');
                sb.append(this.description);
                return sb.toString();
            }
        }

        private class AnnotationInfo {
            String name;
            String constructorDescription;
            SignatureInfo[] signatureInfos;

            private AnnotationInfo() {
            }
        }
    }

    public static class FunctionInfo {
        String name;
        Class<? extends Function> functionClass;
        Function function;
        Signature[] signatures;
        boolean needsGraphArgument;
        boolean acceptsUndefinedValues;
        boolean needsEvaluatorArgument;

        FunctionInfo(String name, Class<? extends Function> cls) {
            this.name = name;
            this.functionClass = cls;
            ArrayList<Signature> functionSignatures = new ArrayList<Signature>();
            try {
                this.function = cls.newInstance();
            }
            catch (InstantiationException e) {
                throw new GreqlException("Could not instantiate '" + cls.getName() + "'", e);
            }
            catch (IllegalAccessException e) {
                throw new GreqlException("Could not instantiate '" + cls.getName() + "' (class must be public and needs public default constructor)", e);
            }
            this.needsGraphArgument = cls.isAnnotationPresent(NeedsGraphArgument.class);
            this.acceptsUndefinedValues = cls.isAnnotationPresent(AcceptsUndefinedArguments.class);
            this.needsEvaluatorArgument = cls.isAnnotationPresent(NeedsEvaluatorArgument.class);
            this.registerSignatures(functionSignatures, cls);
            this.signatures = new Signature[functionSignatures.size()];
            functionSignatures.toArray(this.signatures);
            Arrays.sort(this.signatures, new SignatureComparator());
        }

        FunctionInfo(String name, Function func) {
            this.name = name;
            this.functionClass = func.getClass();
            ArrayList<Signature> functionSignatures = new ArrayList<Signature>();
            this.function = func;
            this.needsGraphArgument = this.functionClass.isAnnotationPresent(NeedsGraphArgument.class);
            this.acceptsUndefinedValues = this.functionClass.isAnnotationPresent(AcceptsUndefinedArguments.class);
            this.needsEvaluatorArgument = this.functionClass.isAnnotationPresent(NeedsEvaluatorArgument.class);
            this.registerSignatures(functionSignatures, this.functionClass);
            this.signatures = new Signature[functionSignatures.size()];
            functionSignatures.toArray(this.signatures);
            Arrays.sort(this.signatures, new SignatureComparator());
        }

        void registerSignatures(ArrayList<Signature> signatures, Class<? extends Function> cls) {
            for (Method m : cls.getMethods()) {
                if (!Modifier.isPublic(m.getModifiers()) || Modifier.isAbstract(m.getModifiers()) || !m.getName().equals("evaluate")) continue;
                logger.finest("\t" + m);
                Signature sig = new Signature();
                sig.evaluateMethod = m;
                sig.parameterTypes = m.getParameterTypes();
                signatures.add(sig);
            }
        }

        public final Function getFunction() {
            return this.function;
        }

        public final boolean needsGraphArgument() {
            return this.needsGraphArgument;
        }

        public final boolean acceptsUndefinedValues() {
            return this.acceptsUndefinedValues;
        }

        public final boolean needsEvaluatorArgument() {
            return this.needsEvaluatorArgument;
        }

        public final Set<Class<?>> getReturnTypes() {
            HashSet returnTypes = new HashSet();
            for (Signature signatur : this.signatures) {
                returnTypes.add(signatur.evaluateMethod.getReturnType());
            }
            return returnTypes;
        }

        public final String getHtmlDescription() {
            StringBuilder sb = new StringBuilder();
            sb.append("<html><body><p>GReQL function <font color=\"blue\"><strong>").append(this.name).append("</strong></font></p><dl>");
            assert (this.functionClass.getConstructors().length == 1);
            Constructor<?> cons = this.functionClass.getConstructors()[0];
            Description consDesc = cons.getAnnotation(Description.class);
            for (Signature sig : this.signatures) {
                Description funDesc = sig.evaluateMethod.getAnnotation(Description.class);
                if (funDesc == null) {
                    funDesc = consDesc;
                }
                if (funDesc == null) continue;
                Class<?> ret = sig.evaluateMethod.getReturnType();
                String returnType = Types.getGreqlTypeName(ret);
                boolean acceptsType = sig.parameterTypes[sig.parameterTypes.length - 1] == TypeCollection.class;
                sb.append("<dt><strong><font color=\"purple\">").append(returnType).append(" <font color=\"blue\">").append(this.name).append("</font></strong>");
                if (acceptsType) {
                    sb.append(" { <font color=\"#008000\">types...</font> } ");
                }
                sb.append("(");
                String delim = "";
                int i = 0;
                for (String p : funDesc.params()) {
                    if (i == 0 && this.needsGraphArgument) {
                        ++i;
                        continue;
                    }
                    if (i == 0 && this.needsEvaluatorArgument) {
                        ++i;
                        continue;
                    }
                    if (i == sig.parameterTypes.length - 1 && acceptsType) {
                        ++i;
                        continue;
                    }
                    Class<?> cls = sig.parameterTypes[i++];
                    String type = Types.getGreqlTypeName(cls);
                    sb.append(delim).append("<strong><font color=\"purple\">").append(type).append("</font></strong> ").append(p);
                    delim = ", ";
                }
                sb.append(")</dt><dd>").append(funDesc.description()).append("</dd>");
            }
            sb.append("</dl></body></html>");
            return sb.toString();
        }
    }

    private static class Signature {
        Class<?>[] parameterTypes;
        Method evaluateMethod;

        private Signature() {
        }

        final boolean matches(Object[] params) {
            if (params.length != this.parameterTypes.length) {
                return false;
            }
            for (int i = 0; i < params.length; ++i) {
                if (this.parameterTypes[i].isInstance(params[i])) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.evaluateMethod.getName());
            sb.append("(");
            boolean first = true;
            for (Class<?> pt : this.parameterTypes) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(pt.getName());
            }
            sb.append(")");
            return sb.toString();
        }
    }

    private static class SignatureComparator
    implements Comparator<Signature> {
        private SignatureComparator() {
        }

        private static int checkSpecialCase(Class<?>[] s1, Class<?>[] s2) {
            if (s1.length == 2 && s2.length == 2 && s1[0] == Number.class && s1[1] == Number.class && s2[1] == Comparable.class && s2[0] == Comparable.class) {
                return -1;
            }
            if (s1.length == 2 && s2.length == 2 && s2[0] == Number.class && s2[1] == Number.class && s1[1] == Comparable.class && s1[0] == Comparable.class) {
                return 1;
            }
            return 0;
        }

        @Override
        public int compare(Signature s1, Signature s2) {
            int x = SignatureComparator.checkSpecialCase(s1.parameterTypes, s2.parameterTypes);
            if (x != 0) {
                return x;
            }
            for (int i = 0; i < Math.min(s1.parameterTypes.length, s2.parameterTypes.length); ++i) {
                Class<?> ps1 = s1.parameterTypes[i];
                Class<?> ps2 = s2.parameterTypes[i];
                if (ps1 == ps2) continue;
                if (ps1.isAssignableFrom(ps2)) {
                    return 1;
                }
                if (!ps2.isAssignableFrom(ps1)) continue;
                return -1;
            }
            return 0;
        }
    }
}

