/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.executable;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.graphmarker.GraphMarker;
import de.uni_koblenz.jgralab.graphmarker.SubGraphMarker;
import de.uni_koblenz.jgralab.greql.executable.PathSystemMarkerEntry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExecutableSliceHelper {
    public static boolean isMarked(List<GraphMarker<Map<Edge, PathSystemMarkerEntry>>> marker, Vertex v, int state) {
        GraphMarker<Map<Edge, PathSystemMarkerEntry>> currentMarker = marker.get(state);
        Map map = (Map)currentMarker.getMark(v);
        return map != null;
    }

    public static boolean isMarked(List<GraphMarker<Map<Edge, PathSystemMarkerEntry>>> marker, Vertex v, int state, Edge parentEdge) {
        GraphMarker<Map<Edge, PathSystemMarkerEntry>> currentMarker = marker.get(state);
        Map map = (Map)currentMarker.getMark(v);
        if (map != null) {
            return map.containsKey(parentEdge);
        }
        return false;
    }

    public static boolean markVertex(List<GraphMarker<Map<Edge, PathSystemMarkerEntry>>> marker, Vertex v, int state, boolean isFinal, Vertex parentVertex, Edge e, int parentState, int d) {
        PathSystemMarkerEntry entry;
        PathSystemMarkerEntry m = new PathSystemMarkerEntry(v, parentVertex, e, state, isFinal, parentState, d);
        GraphMarker<Map<Edge, PathSystemMarkerEntry>> currentMarker = marker.get(state);
        HashMap<Edge, PathSystemMarkerEntry> map = (HashMap<Edge, PathSystemMarkerEntry>)currentMarker.getMark(v);
        if (map == null) {
            map = new HashMap<Edge, PathSystemMarkerEntry>();
            currentMarker.mark(v, map);
        }
        if ((entry = (PathSystemMarkerEntry)map.get(e)) == null) {
            map.put(e, m);
            return true;
        }
        return false;
    }

    public static SubGraphMarker createSliceFromMarkings(Graph graph, Set<Vertex> sliCritVertices, List<Vertex> leaves, List<GraphMarker<Map<Edge, PathSystemMarkerEntry>>> marker) {
        SubGraphMarker sliceSubGraph = new SubGraphMarker(graph);
        for (Vertex v : sliCritVertices) {
            sliceSubGraph.mark(v);
        }
        LinkedList<Vertex> queue = new LinkedList<Vertex>();
        int parentState = -1;
        GraphMarker<Set<Integer>> stateMarker = new GraphMarker<Set<Integer>>(graph);
        GraphMarker<Integer> currentStateMarker = new GraphMarker<Integer>(graph);
        for (Vertex leaf : leaves) {
            for (GraphMarker<Map<Edge, PathSystemMarkerEntry>> currentGraphMarker : marker) {
                if (currentGraphMarker.getMark(leaf) == null) continue;
                for (PathSystemMarkerEntry currentMarker : ((Map)currentGraphMarker.getMark(leaf)).values()) {
                    if (!currentMarker.stateIsFinal || ExecutableSliceHelper.isVertexMarkedWithState(leaf, currentMarker.stateNumber, stateMarker)) continue;
                    ExecutableSliceHelper.markVertexWithState(leaf, currentMarker.stateNumber, stateMarker);
                    currentStateMarker.mark(leaf, currentMarker.stateNumber);
                    queue.add(leaf);
                    while (!queue.isEmpty()) {
                        Vertex currentVertex = (Vertex)queue.poll();
                        for (PathSystemMarkerEntry mark : ExecutableSliceHelper.getMarkersWithState(currentVertex, (Integer)currentStateMarker.getMark(currentVertex), marker).values()) {
                            Vertex parentVertex;
                            parentState = mark.parentStateNumber;
                            sliceSubGraph.mark(currentVertex);
                            if (mark.edgeToParentVertex != null) {
                                sliceSubGraph.mark(mark.edgeToParentVertex);
                            }
                            if ((parentVertex = mark.parentVertex) == null || ExecutableSliceHelper.isVertexMarkedWithState(parentVertex, parentState, stateMarker)) continue;
                            ExecutableSliceHelper.markVertexWithState(parentVertex, parentState, stateMarker);
                            currentStateMarker.mark(parentVertex, parentState);
                            queue.add(parentVertex);
                        }
                    }
                }
            }
        }
        return sliceSubGraph;
    }

    private static boolean isVertexMarkedWithState(Vertex v, Integer state, GraphMarker<Set<Integer>> stateMarker) {
        if (stateMarker.getMark(v) == null) {
            return false;
        }
        return ((Set)stateMarker.getMark(v)).contains(state);
    }

    private static void markVertexWithState(Vertex v, Integer state, GraphMarker<Set<Integer>> stateMarker) {
        if (stateMarker.getMark(v) == null) {
            stateMarker.mark(v, new HashSet());
        }
        ((Set)stateMarker.getMark(v)).add(state);
    }

    private static Map<Edge, PathSystemMarkerEntry> getMarkersWithState(Vertex v, Integer state, List<GraphMarker<Map<Edge, PathSystemMarkerEntry>>> marker) {
        if (v == null) {
            return null;
        }
        GraphMarker<Map<Edge, PathSystemMarkerEntry>> currentMarker = marker.get(state);
        return (Map)currentMarker.getMark(v);
    }
}

