/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.executable;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.graphmarker.GraphMarker;
import de.uni_koblenz.jgralab.greql.executable.PathSystemMarkerEntry;
import de.uni_koblenz.jgralab.greql.types.PathSystem;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class ExecutablePathSystemHelper {
    public static PathSystem createPathSystemFromMarkings(GraphMarker<PathSystemMarkerEntry>[] marker, Vertex rootVertex, Set<PathSystemMarkerEntry> leafEntries) {
        PathSystem pathSystem = new PathSystem();
        HashMap<Vertex, PathSystem.PathSystemNode[]> vertex2state2node = new HashMap<Vertex, PathSystem.PathSystemNode[]>();
        HashMap<Vertex, PathSystemMarkerEntry[]> vertex2state2marker = new HashMap<Vertex, PathSystemMarkerEntry[]>();
        LinkedList<PathSystem.PathSystemNode> nodesWithoutParentEdge = new LinkedList<PathSystem.PathSystemNode>();
        PathSystemMarkerEntry rootMarker = (PathSystemMarkerEntry)marker[0].getMark(rootVertex);
        PathSystem.PathSystemNode root = pathSystem.setRootVertex(rootVertex, rootMarker.stateNumber, rootMarker.stateIsFinal);
        PathSystem.PathSystemNode[] currentState2node = new PathSystem.PathSystemNode[marker.length];
        currentState2node[rootMarker.stateNumber] = root;
        vertex2state2node.put(rootVertex, currentState2node);
        for (PathSystemMarkerEntry currentMarker : leafEntries) {
            Vertex currentVertex = currentMarker.vertex;
            while (currentVertex != null) {
                PathSystem.PathSystemNode childNode = ExecutablePathSystemHelper.addVertexToPathSystem(pathSystem, vertex2state2node, marker.length, currentVertex, currentMarker.stateNumber, currentMarker.stateIsFinal);
                if (currentMarker.edgeToParentVertex != null) {
                    PathSystem.PathSystemNode parentNode = ExecutablePathSystemHelper.addVertexToPathSystem(pathSystem, vertex2state2node, marker.length, currentMarker.parentVertex, currentMarker.parentStateNumber, false);
                    pathSystem.addEdge(childNode, parentNode, currentMarker.edgeToParentVertex);
                } else if (!(currentVertex == pathSystem.getRootVertex() && currentMarker.distanceToRoot == 0 || nodesWithoutParentEdge.contains(childNode))) {
                    nodesWithoutParentEdge.add(childNode);
                    PathSystemMarkerEntry[] currentMarkerEntry = (PathSystemMarkerEntry[])vertex2state2marker.get(currentVertex);
                    if (currentMarkerEntry == null) {
                        currentMarkerEntry = new PathSystemMarkerEntry[marker.length];
                        vertex2state2marker.put(currentVertex, currentMarkerEntry);
                    }
                    assert (currentMarkerEntry[currentMarker.stateNumber] == null) : "already exiting:" + currentMarkerEntry[currentMarker.stateNumber] + " new: " + currentMarker;
                    currentMarkerEntry[currentMarker.stateNumber] = currentMarker;
                }
                currentVertex = currentMarker.parentVertex;
                currentMarker = ExecutablePathSystemHelper.getMarkerWithState(marker, currentVertex, currentMarker.parentStateNumber);
            }
        }
        ExecutablePathSystemHelper.completePathSystem(pathSystem, nodesWithoutParentEdge, vertex2state2marker, vertex2state2node);
        pathSystem.finish();
        return pathSystem;
    }

    private static PathSystem.PathSystemNode addVertexToPathSystem(PathSystem pathSystem, Map<Vertex, PathSystem.PathSystemNode[]> vertex2state2node, int numberOfStates, Vertex currentVertex, int state, boolean isFinal) {
        PathSystem.PathSystemNode currentNode;
        PathSystem.PathSystemNode[] currentState2node = vertex2state2node.get(currentVertex);
        if (currentState2node == null) {
            currentState2node = new PathSystem.PathSystemNode[numberOfStates];
            vertex2state2node.put(currentVertex, currentState2node);
        } else {
            currentNode = currentState2node[state];
            if (currentNode != null) {
                if (isFinal) {
                    pathSystem.addLeaf(currentNode);
                }
                return currentNode;
            }
        }
        currentState2node[state] = currentNode = pathSystem.addVertex(currentVertex, state, isFinal);
        return currentNode;
    }

    private static void completePathSystem(PathSystem pathSystem, Queue<PathSystem.PathSystemNode> nodesWithoutParentEdge, Map<Vertex, PathSystemMarkerEntry[]> vertex2state2marker, Map<Vertex, PathSystem.PathSystemNode[]> vertex2state2node) {
        while (!nodesWithoutParentEdge.isEmpty()) {
            PathSystem.PathSystemNode te = nodesWithoutParentEdge.poll();
            PathSystem.PathSystemNode pe = null;
            PathSystemMarkerEntry[] teMarker = vertex2state2marker.get(te.currentVertex);
            assert (teMarker != null);
            pe = teMarker[te.state] != null ? vertex2state2node.get(teMarker[te.state].parentVertex)[teMarker[te.state].parentStateNumber] : pathSystem.getRoot();
            if (pe == null) continue;
            Set<PathSystem.PathSystemNode> parents = pathSystem.getParents(pe);
            assert (parents.size() <= 1);
            for (PathSystem.PathSystemNode parent : parents) {
                pathSystem.addEdge(te, parent, pe.edge2parent);
            }
        }
    }

    private static PathSystemMarkerEntry getMarkerWithState(GraphMarker<PathSystemMarkerEntry>[] marker, Vertex v, int stateNumber) {
        if (v == null) {
            return null;
        }
        GraphMarker<PathSystemMarkerEntry> currentMarker = marker[stateNumber];
        PathSystemMarkerEntry entry = (PathSystemMarkerEntry)currentMarker.getMark(v);
        return entry;
    }

    public static PathSystemMarkerEntry markVertex(GraphMarker<PathSystemMarkerEntry>[] marker, Vertex v, int stateNumber, boolean stateIsFinal, Vertex parentVertex, Edge e, int parentStateNumber, int d) {
        PathSystemMarkerEntry m = new PathSystemMarkerEntry(v, parentVertex, e, stateNumber, stateIsFinal, parentStateNumber, d);
        GraphMarker<PathSystemMarkerEntry> currentMarker = marker[stateNumber];
        currentMarker.mark(v, m);
        return m;
    }

    public static boolean isMarked(GraphMarker<PathSystemMarkerEntry>[] marker, Vertex v, int stateNumber) {
        GraphMarker<PathSystemMarkerEntry> currentMarker = marker[stateNumber];
        return currentMarker.isMarked(v);
    }
}

