/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.ElementSetExpressionEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.TypeIdEvaluator;
import de.uni_koblenz.jgralab.greql.schema.IsTypeRestrOfExpression;
import de.uni_koblenz.jgralab.greql.schema.VertexSetExpression;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;
import org.pcollections.PSet;

public class VertexSetExpressionEvaluator
extends ElementSetExpressionEvaluator<VertexSetExpression> {
    public VertexSetExpressionEvaluator(VertexSetExpression vertex, GreqlQueryImpl query) {
        super(vertex, query);
    }

    @Override
    public Object evaluate(InternalGreqlEvaluator evaluator) {
        TypeCollection tc = this.getTypeCollection(evaluator);
        PSet<Object> resultSet = null;
        if (resultSet == null) {
            resultSet = JGraLab.set();
            for (Vertex currentVertex = evaluator.getGraph().getFirstVertex(); currentVertex != null; currentVertex = currentVertex.getNextVertex()) {
                if (!tc.acceptsType(currentVertex.getAttributedElementClass())) continue;
                resultSet = resultSet.plus(currentVertex);
            }
        }
        evaluator.progress(this.getOwnEvaluationCosts());
        return resultSet;
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        VertexSetExpression vse = (VertexSetExpression)this.getVertex();
        long typeRestrCosts = 0L;
        for (IsTypeRestrOfExpression inc = vse.getFirstIsTypeRestrOfExpressionIncidence(); inc != null; inc = inc.getNextIsTypeRestrOfExpressionIncidence()) {
            TypeIdEvaluator tideval = (TypeIdEvaluator)this.query.getVertexEvaluator(inc.getAlpha());
            typeRestrCosts += tideval.getCurrentSubtreeEvaluationCosts();
        }
        long ownCosts = this.query.getOptimizer().getOptimizerInfo().getAverageVertexCount();
        return new VertexCosts(ownCosts, ownCosts, typeRestrCosts + ownCosts);
    }

    @Override
    public long calculateEstimatedCardinality() {
        long card;
        if (this.typeCollection != null) {
            card = this.typeCollection.getEstimatedGraphElementCount(this.query.getOptimizer().getOptimizerInfo());
        } else {
            VertexSetExpression exp = (VertexSetExpression)this.getVertex();
            IsTypeRestrOfExpression inc = exp.getFirstIsTypeRestrOfExpressionIncidence();
            double selectivity = 1.0;
            if (inc != null) {
                TypeIdEvaluator typeIdEval = (TypeIdEvaluator)this.query.getVertexEvaluator(inc.getAlpha());
                selectivity = typeIdEval.getEstimatedSelectivity();
            }
            card = Math.round((double)this.query.getOptimizer().getOptimizerInfo().getAverageVertexCount() * selectivity);
        }
        logger.fine("VertexSet estimated cardinality " + this.typeCollection + ": " + card);
        return card;
    }
}

