/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Record;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.RecordElementEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.schema.IsPartOf;
import de.uni_koblenz.jgralab.greql.schema.IsRecordElementOf;
import de.uni_koblenz.jgralab.greql.schema.RecordConstruction;
import de.uni_koblenz.jgralab.greql.schema.RecordElement;
import de.uni_koblenz.jgralab.impl.RecordImpl;

public class RecordConstructionEvaluator
extends VertexEvaluator<RecordConstruction> {
    protected static final int addToRecordCosts = 10;

    public RecordConstructionEvaluator(RecordConstruction vertex, GreqlQueryImpl query) {
        super(vertex, query);
    }

    @Override
    public Record evaluate(InternalGreqlEvaluator evaluator) {
        evaluator.progress(this.getOwnEvaluationCosts());
        RecordImpl resultRecord = RecordImpl.empty();
        for (IsRecordElementOf inc = ((RecordConstruction)this.vertex).getFirstIsRecordElementOfIncidence(EdgeDirection.IN); inc != null; inc = inc.getNextIsRecordElementOfIncidence(EdgeDirection.IN)) {
            RecordElement currentElement = inc.getAlpha();
            RecordElementEvaluator vertexEval = (RecordElementEvaluator)this.query.getVertexEvaluator(currentElement);
            resultRecord = resultRecord.plus(vertexEval.getId(), vertexEval.getResult(evaluator));
        }
        return resultRecord;
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        RecordConstruction recCons = (RecordConstruction)this.getVertex();
        long recElems = 0L;
        long recElemCosts = 0L;
        for (IsPartOf inc = recCons.getFirstIsPartOfIncidence(EdgeDirection.IN); inc != null; inc = inc.getNextIsPartOfIncidence(EdgeDirection.IN)) {
            RecordElement recElem = (RecordElement)((Object)inc.getAlpha());
            VertexEvaluator<RecordElement> veval = this.query.getVertexEvaluator(recElem);
            recElemCosts += veval.getCurrentSubtreeEvaluationCosts();
            ++recElems;
        }
        long ownCosts = recElems * 10L + 2L;
        long iteratedCosts = ownCosts * this.getVariableCombinations();
        long subtreeCosts = iteratedCosts + recElemCosts;
        return new VertexCosts(ownCosts, iteratedCosts, subtreeCosts);
    }

    @Override
    public long calculateEstimatedCardinality() {
        RecordConstruction recCons = (RecordConstruction)this.getVertex();
        long parts = 0L;
        for (IsRecordElementOf inc = recCons.getFirstIsRecordElementOfIncidence(EdgeDirection.IN); inc != null; inc = inc.getNextIsRecordElementOfIncidence(EdgeDirection.IN)) {
            ++parts;
        }
        return parts;
    }
}

