/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VariableDeclarationLayer;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.DeclarationEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.schema.Declaration;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.QuantificationType;
import de.uni_koblenz.jgralab.greql.schema.QuantifiedExpression;
import de.uni_koblenz.jgralab.greql.schema.Quantifier;

public class QuantifiedExpressionEvaluator
extends VertexEvaluator<QuantifiedExpression> {
    private QuantificationType quantificationType = null;
    private boolean initialized = false;
    private VertexEvaluator<? extends Expression> predicateEvaluator = null;

    public QuantifiedExpressionEvaluator(QuantifiedExpression vertex, GreqlQueryImpl query) {
        super(vertex, query);
    }

    private void initialize(InternalGreqlEvaluator evaluator) {
        Quantifier quantifier = ((QuantifiedExpression)this.vertex).getFirstIsQuantifierOfIncidence(EdgeDirection.IN).getAlpha();
        this.quantificationType = quantifier.get_type();
        Expression b = ((QuantifiedExpression)this.vertex).getFirstIsBoundExprOfIncidence(EdgeDirection.IN).getAlpha();
        this.predicateEvaluator = this.query.getVertexEvaluator(b);
        this.initialized = true;
    }

    @Override
    public Boolean evaluate(InternalGreqlEvaluator evaluator) {
        if (!this.initialized) {
            this.initialize(evaluator);
        }
        evaluator.progress(this.getOwnEvaluationCosts());
        boolean foundTrue = false;
        Declaration d = ((QuantifiedExpression)this.vertex).getFirstIsQuantifiedDeclOfIncidence(EdgeDirection.IN).getAlpha();
        DeclarationEvaluator declEval = (DeclarationEvaluator)this.query.getVertexEvaluator(d);
        VariableDeclarationLayer declarationLayer = (VariableDeclarationLayer)declEval.getResult(evaluator);
        declarationLayer.reset();
        switch (this.quantificationType) {
            case EXISTS: {
                while (declarationLayer.iterate(evaluator)) {
                    Object tempResult = this.predicateEvaluator.getResult(evaluator);
                    if (tempResult instanceof Boolean) {
                        if (!((Boolean)tempResult).booleanValue()) continue;
                        return Boolean.TRUE;
                    }
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case EXISTSONE: {
                while (declarationLayer.iterate(evaluator)) {
                    Object tempResult = this.predicateEvaluator.getResult(evaluator);
                    if (tempResult instanceof Boolean) {
                        if (!((Boolean)tempResult).booleanValue()) continue;
                        if (foundTrue) {
                            return Boolean.FALSE;
                        }
                        foundTrue = true;
                        continue;
                    }
                    if (foundTrue) {
                        return Boolean.FALSE;
                    }
                    foundTrue = true;
                }
                if (foundTrue) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case FORALL: {
                while (declarationLayer.iterate(evaluator)) {
                    Object tempResult = this.predicateEvaluator.getResult(evaluator);
                    if (!(tempResult instanceof Boolean) || ((Boolean)tempResult).booleanValue()) continue;
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        }
        throw new RuntimeException("FIXME: Unhandled quantification type " + (Object)((Object)this.quantificationType));
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        QuantifiedExpression quantifiedExpr = (QuantifiedExpression)this.getVertex();
        VertexEvaluator<Declaration> declEval = this.query.getVertexEvaluator(quantifiedExpr.getFirstIsQuantifiedDeclOfIncidence().getAlpha());
        long declCosts = declEval.getCurrentSubtreeEvaluationCosts();
        VertexEvaluator<Expression> boundExprEval = this.query.getVertexEvaluator(quantifiedExpr.getFirstIsBoundExprOfQuantifiedExpressionIncidence().getAlpha());
        long boundExprCosts = boundExprEval.getCurrentSubtreeEvaluationCosts();
        long ownCosts = 20L;
        long iteratedCosts = ownCosts * this.getVariableCombinations();
        long subtreeCosts = iteratedCosts + declCosts + boundExprCosts;
        return new VertexCosts(ownCosts, iteratedCosts, subtreeCosts);
    }
}

