/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.IntLiteralEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.ListRangeConstruction;
import org.pcollections.PVector;

public class ListRangeConstructionEvaluator
extends VertexEvaluator<ListRangeConstruction> {
    protected static final int defaultListRangeSize = 50;
    private VertexEvaluator<? extends Expression> firstElementEvaluator = null;
    private VertexEvaluator<? extends Expression> lastElementEvaluator = null;

    public ListRangeConstructionEvaluator(ListRangeConstruction vertex, GreqlQueryImpl query) {
        super(vertex, query);
    }

    private void getEvals() {
        Expression firstElementExpression = ((ListRangeConstruction)this.vertex).getFirstIsFirstValueOfIncidence(EdgeDirection.IN).getAlpha();
        Expression lastElementExpression = ((ListRangeConstruction)this.vertex).getFirstIsLastValueOfIncidence(EdgeDirection.IN).getAlpha();
        this.firstElementEvaluator = this.query.getVertexEvaluator(firstElementExpression);
        this.lastElementEvaluator = this.query.getVertexEvaluator(lastElementExpression);
    }

    @Override
    public PVector<Integer> evaluate(InternalGreqlEvaluator evaluator) {
        PVector<Integer> resultList;
        block7: {
            int lastInt;
            evaluator.progress(this.getOwnEvaluationCosts());
            resultList = JGraLab.vector();
            if (this.firstElementEvaluator == null) {
                this.getEvals();
            }
            Object firstElement = this.firstElementEvaluator.getResult(evaluator);
            Object lastElement = this.lastElementEvaluator.getResult(evaluator);
            if (!(firstElement instanceof Integer) || !(lastElement instanceof Integer)) break block7;
            int firstInt = (Integer)firstElement;
            if (firstInt == (lastInt = ((Integer)lastElement).intValue())) {
                resultList = resultList.plus(firstInt);
            } else if (firstInt < lastInt) {
                for (int i = firstInt; i <= lastInt; ++i) {
                    resultList = resultList.plus(i);
                }
            } else {
                for (int i = firstInt; i >= lastInt; --i) {
                    resultList = resultList.plus(i);
                }
            }
        }
        return resultList;
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        ListRangeConstruction exp = (ListRangeConstruction)this.getVertex();
        VertexEvaluator<Expression> startExpEval = this.query.getVertexEvaluator(exp.getFirstIsFirstValueOfIncidence().getAlpha());
        VertexEvaluator<Expression> targetExpEval = this.query.getVertexEvaluator(exp.getFirstIsLastValueOfIncidence().getAlpha());
        long startCosts = startExpEval.getCurrentSubtreeEvaluationCosts();
        long targetCosts = targetExpEval.getCurrentSubtreeEvaluationCosts();
        long range = 0L;
        if (startExpEval instanceof IntLiteralEvaluator && targetExpEval instanceof IntLiteralEvaluator) {
            try {
                range = ((Number)targetExpEval.getResult(null)).longValue() - ((Number)startExpEval.getResult(null)).longValue() + 1L;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (range <= 0L) {
            range = 50L;
        }
        long ownCosts = 5L * range;
        long iteratedCosts = ownCosts * this.getVariableCombinations();
        long subtreeCosts = iteratedCosts + startCosts + targetCosts;
        return new VertexCosts(ownCosts, iteratedCosts, subtreeCosts);
    }

    @Override
    public long calculateEstimatedCardinality() {
        ListRangeConstruction exp = (ListRangeConstruction)this.getVertex();
        VertexEvaluator<Expression> startExpEval = this.query.getVertexEvaluator(exp.getFirstIsFirstValueOfIncidence(EdgeDirection.IN).getAlpha());
        VertexEvaluator<Expression> targetExpEval = this.query.getVertexEvaluator(exp.getFirstIsLastValueOfIncidence(EdgeDirection.IN).getAlpha());
        long range = 0L;
        if (startExpEval instanceof IntLiteralEvaluator && targetExpEval instanceof IntLiteralEvaluator) {
            try {
                range = ((Number)targetExpEval.getResult(null)).longValue() - ((Number)startExpEval.getResult(null)).longValue() + 1L;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (range > 0L) {
            return range;
        }
        return 50L;
    }
}

