/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.greql.evaluator.EvaluatorUtilities;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VariableEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.exception.UndefinedVariableException;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.GreqlExpression;
import de.uni_koblenz.jgralab.greql.schema.Identifier;
import de.uni_koblenz.jgralab.greql.schema.IsBoundVarOf;
import de.uni_koblenz.jgralab.greql.schema.IsIdOfStoreClause;
import de.uni_koblenz.jgralab.greql.schema.Variable;

public class GreqlExpressionEvaluator
extends VertexEvaluator<GreqlExpression> {
    protected static final int greql2ExpressionCostsFactor = 3;

    private void initializeBoundVariables(InternalGreqlEvaluator evaluator) {
        for (IsBoundVarOf inc = ((GreqlExpression)this.vertex).getFirstIsBoundVarOfIncidence(EdgeDirection.IN); inc != null; inc = inc.getNextIsBoundVarOfIncidence(EdgeDirection.IN)) {
            Variable currentBoundVariable = inc.getAlpha();
            Object variableValue = evaluator.getVariable(currentBoundVariable.get_name());
            if (variableValue == null) {
                throw new UndefinedVariableException(currentBoundVariable, this.createSourcePositions(inc));
            }
            VariableEvaluator variableEval = (VariableEvaluator)this.query.getVertexEvaluator(currentBoundVariable);
            variableEval.setValue(variableValue, evaluator);
        }
    }

    public GreqlExpressionEvaluator(GreqlExpression vertex, GreqlQueryImpl query) {
        super(vertex, query);
    }

    @Override
    public Object evaluate(InternalGreqlEvaluator evaluator) {
        EvaluatorUtilities.checkImports((GreqlExpression)this.vertex, evaluator.getSchema());
        this.initializeBoundVariables(evaluator);
        Expression boundExpression = ((GreqlExpression)this.vertex).getFirstIsQueryExprOfIncidence(EdgeDirection.IN).getAlpha();
        VertexEvaluator<Expression> eval = this.query.getVertexEvaluator(boundExpression);
        Object result = eval.getResult(evaluator);
        IsIdOfStoreClause storeInc = ((GreqlExpression)this.vertex).getFirstIsIdOfStoreClauseIncidence(EdgeDirection.IN);
        if (storeInc != null) {
            VertexEvaluator<Identifier> storeEval = this.query.getVertexEvaluator(storeInc.getAlpha());
            String varName = storeEval.getResult(evaluator).toString();
            evaluator.setVariable(varName, result);
        }
        evaluator.progress(this.getOwnEvaluationCosts());
        return result;
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        long ownCosts;
        GreqlExpression greqlExp = (GreqlExpression)this.getVertex();
        VertexEvaluator<Expression> queryExpEval = this.query.getVertexEvaluator(greqlExp.getFirstIsQueryExprOfIncidence().getAlpha());
        long queryCosts = queryExpEval.getCurrentSubtreeEvaluationCosts();
        int boundVars = 0;
        for (IsBoundVarOf boundVarInc = greqlExp.getFirstIsBoundVarOfIncidence(); boundVarInc != null; boundVarInc = boundVarInc.getNextIsBoundVarOfIncidence()) {
            ++boundVars;
        }
        long iteratedCosts = ownCosts = (long)(boundVars * 3);
        long subtreeCosts = ownCosts + queryCosts;
        return new VertexCosts(ownCosts, iteratedCosts, subtreeCosts);
    }
}

