/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.fa.NFA;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.IntLiteralEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.PathDescriptionEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.exception.GreqlException;
import de.uni_koblenz.jgralab.greql.schema.ExponentiatedPathDescription;
import de.uni_koblenz.jgralab.greql.schema.IntLiteral;
import de.uni_koblenz.jgralab.greql.schema.PathDescription;

public class ExponentiatedPathDescriptionEvaluator
extends PathDescriptionEvaluator<ExponentiatedPathDescription> {
    protected static final int defaultExponent = 3;

    public ExponentiatedPathDescriptionEvaluator(ExponentiatedPathDescription vertex, GreqlQueryImpl query) {
        super(vertex, query);
    }

    @Override
    public NFA evaluate(InternalGreqlEvaluator evaluator) {
        evaluator.progress(this.getOwnEvaluationCosts());
        PathDescription p = ((ExponentiatedPathDescription)this.vertex).getFirstIsExponentiatedPathOfIncidence().getAlpha();
        PathDescriptionEvaluator pathEval = (PathDescriptionEvaluator)this.query.getVertexEvaluator(p);
        VertexEvaluator<IntLiteral> exponentEvaluator = this.query.getVertexEvaluator(((ExponentiatedPathDescription)this.vertex).getFirstIsExponentOfIncidence(EdgeDirection.IN).getAlpha());
        Object exponentValue = exponentEvaluator.getResult(evaluator);
        int exponent = 0;
        if (!(exponentValue instanceof Integer)) {
            throw new GreqlException("Exponent of ExponentiatedPathDescription is not convertable to integer value");
        }
        exponent = (Integer)exponentValue;
        if (exponent <= 0) {
            throw new GreqlException("Exponent of ExponentiatedPathDescription is " + exponent + " but must be >=1.");
        }
        return NFA.createExponentiatedPathDescriptionNFA(pathEval.getNFA(evaluator), exponent);
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        ExponentiatedPathDescription p = (ExponentiatedPathDescription)this.getVertex();
        long exponent = 3L;
        VertexEvaluator<IntLiteral> expEval = this.query.getVertexEvaluator(p.getFirstIsExponentOfIncidence(EdgeDirection.IN).getAlpha());
        if (expEval instanceof IntLiteralEvaluator) {
            try {
                exponent = ((Number)expEval.getResult(null)).longValue();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        long exponentCosts = expEval.getCurrentSubtreeEvaluationCosts();
        VertexEvaluator<PathDescription> pathEval = this.query.getVertexEvaluator(p.getFirstIsExponentiatedPathOfIncidence(EdgeDirection.IN).getAlpha());
        long pathCosts = pathEval.getCurrentSubtreeEvaluationCosts();
        long ownCosts = pathCosts * exponent * 1L / 3L;
        long subtreeCosts = pathCosts + ownCosts + exponentCosts;
        return new VertexCosts(ownCosts, ownCosts, subtreeCosts);
    }
}

