/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.ElementSetExpressionEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.TypeIdEvaluator;
import de.uni_koblenz.jgralab.greql.schema.EdgeSetExpression;
import de.uni_koblenz.jgralab.greql.schema.IsTypeRestrOfExpression;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import org.pcollections.PSet;

public class EdgeSetExpressionEvaluator
extends ElementSetExpressionEvaluator<EdgeSetExpression> {
    public EdgeSetExpressionEvaluator(EdgeSetExpression vertex, GreqlQueryImpl query) {
        super(vertex, query);
    }

    @Override
    public PSet<Edge> evaluate(InternalGreqlEvaluator evaluator) {
        TypeCollection tc = this.getTypeCollection(evaluator);
        PSet<Edge> resultSet = JGraLab.set();
        for (Edge currentEdge = evaluator.getGraph().getFirstEdge(); currentEdge != null; currentEdge = currentEdge.getNextEdge()) {
            EdgeClass edgeClass = currentEdge.getAttributedElementClass();
            if (!tc.acceptsType(edgeClass)) continue;
            resultSet = resultSet.plus(currentEdge);
        }
        evaluator.progress(this.getOwnEvaluationCosts());
        return resultSet;
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        EdgeSetExpression ese = (EdgeSetExpression)this.getVertex();
        long typeRestrCosts = 0L;
        for (IsTypeRestrOfExpression inc = ese.getFirstIsTypeRestrOfExpressionIncidence(); inc != null; inc = inc.getNextIsTypeRestrOfExpressionIncidence()) {
            TypeIdEvaluator tideval = (TypeIdEvaluator)this.query.getVertexEvaluator(inc.getAlpha());
            typeRestrCosts += tideval.getCurrentSubtreeEvaluationCosts();
        }
        long ownCosts = this.query.getOptimizer().getOptimizerInfo().getAverageEdgeCount();
        return new VertexCosts(ownCosts, ownCosts, typeRestrCosts + ownCosts);
    }

    @Override
    public long calculateEstimatedCardinality() {
        long card;
        if (this.typeCollection != null) {
            card = this.typeCollection.getEstimatedGraphElementCount(this.query.getOptimizer().getOptimizerInfo());
        } else {
            EdgeSetExpression exp = (EdgeSetExpression)this.getVertex();
            IsTypeRestrOfExpression inc = exp.getFirstIsTypeRestrOfExpressionIncidence();
            double selectivity = 1.0;
            if (inc != null) {
                TypeIdEvaluator typeIdEval = (TypeIdEvaluator)this.query.getVertexEvaluator(inc.getAlpha());
                selectivity = typeIdEval.getEstimatedSelectivity();
            }
            card = Math.round((double)this.query.getOptimizer().getOptimizerInfo().getAverageEdgeCount() * selectivity);
        }
        logger.fine("EdgeSet estimated cardinality " + this.typeCollection + ": " + card);
        return card;
    }
}

