/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VariableDeclarationLayer;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.DeclarationEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.schema.Comprehension;
import de.uni_koblenz.jgralab.greql.schema.Declaration;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import org.pcollections.PCollection;

public abstract class ComprehensionEvaluator<V extends Comprehension>
extends VertexEvaluator<V> {
    private VertexEvaluator<? extends Expression> resultDefinitionEvaluator = null;
    protected long maxCount = Long.MAX_VALUE;

    public ComprehensionEvaluator(V vertex, GreqlQueryImpl query) {
        super(vertex, query);
    }

    protected abstract PCollection<Object> getResultDatastructure(InternalGreqlEvaluator var1);

    protected final VertexEvaluator<? extends Expression> getResultDefinitionEvaluator() {
        if (this.resultDefinitionEvaluator == null) {
            Expression resultDefinition = ((Comprehension)this.getVertex()).getFirstIsCompResultDefOfIncidence(EdgeDirection.IN).getAlpha();
            this.resultDefinitionEvaluator = this.query.getVertexEvaluator(resultDefinition);
        }
        return this.resultDefinitionEvaluator;
    }

    protected final VariableDeclarationLayer getVariableDeclationLayer(InternalGreqlEvaluator evaluator) {
        Declaration d = ((Comprehension)this.getVertex()).getFirstIsCompDeclOfIncidence(EdgeDirection.IN).getAlpha();
        DeclarationEvaluator declEval = (DeclarationEvaluator)this.query.getVertexEvaluator(d);
        return (VariableDeclarationLayer)declEval.getResult(evaluator);
    }

    protected final void initializeMaxCount(InternalGreqlEvaluator evaluator) {
        if (((Comprehension)this.getVertex()).get_maxCount() != null) {
            VertexEvaluator<Expression> maxCountEval = this.query.getVertexEvaluator(((Comprehension)this.getVertex()).get_maxCount());
            this.maxCount = ((Number)maxCountEval.getResult(evaluator)).longValue();
        }
    }

    @Override
    public Object evaluate(InternalGreqlEvaluator evaluator) {
        evaluator.progress(this.getOwnEvaluationCosts());
        this.initializeMaxCount(evaluator);
        VariableDeclarationLayer declLayer = this.getVariableDeclationLayer(evaluator);
        VertexEvaluator<Expression> resultDefEval = this.getResultDefinitionEvaluator();
        PCollection<Object> resultCollection = this.getResultDatastructure(evaluator);
        declLayer.reset();
        while (declLayer.iterate(evaluator) && (long)resultCollection.size() < this.maxCount) {
            Object localResult = resultDefEval.getResult(evaluator);
            resultCollection = resultCollection.plus(localResult);
        }
        return resultCollection;
    }
}

