/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.fa;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.fa.State;
import de.uni_koblenz.jgralab.greql.evaluator.fa.Transition;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.ThisEdgeEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.GReQLDirection;
import de.uni_koblenz.jgralab.greql.schema.ThisEdge;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import java.util.Set;

public class SimpleTransition
extends Transition {
    protected VertexEvaluator<? extends Expression> predicateEvaluator;
    protected ThisEdgeEvaluator thisEdgeEvaluator;
    protected TypeCollection typeCollection;
    protected Set<String> validToEdgeRoles;
    protected Set<String> validFromEdgeRoles;
    protected GReQLDirection validDirection;

    public VertexEvaluator<? extends Expression> getPredicateEvaluator() {
        return this.predicateEvaluator;
    }

    public TypeCollection getTypeCollection() {
        return this.typeCollection;
    }

    public Set<String> getValidToRoles() {
        return this.validToEdgeRoles;
    }

    public Set<String> getValidFromRoles() {
        return this.validFromEdgeRoles;
    }

    public GReQLDirection getAllowedDirection() {
        return this.validDirection;
    }

    @Override
    public String edgeString() {
        String desc = "SimpleTransition (Dir:" + this.validDirection.toString();
        if (this.typeCollection != null) {
            desc = desc + "\n " + this.typeCollection.toString() + "\n ";
        }
        desc = desc + ")";
        return desc;
    }

    @Override
    public boolean equalSymbol(Transition t) {
        if (!(t instanceof SimpleTransition)) {
            return false;
        }
        SimpleTransition et = (SimpleTransition)t;
        if (!this.typeCollection.equals(et.typeCollection)) {
            return false;
        }
        if (!this.validDirection.equals((Object)et.validDirection)) {
            return false;
        }
        if (this.validToEdgeRoles != null) {
            if (et.validToEdgeRoles == null) {
                return false;
            }
            if (!this.validToEdgeRoles.equals(et.validToEdgeRoles)) {
                return false;
            }
        } else if (et.validToEdgeRoles != null) {
            return false;
        }
        if (this.validFromEdgeRoles == null) {
            if (et.validFromEdgeRoles != null) {
                return false;
            }
        } else {
            if (et.validFromEdgeRoles == null) {
                return false;
            }
            if (!this.validFromEdgeRoles.equals(et.validFromEdgeRoles)) {
                return false;
            }
        }
        if (this.predicateEvaluator != null) {
            if (et.predicateEvaluator == null) {
                return false;
            }
            if (!this.predicateEvaluator.equals(et.predicateEvaluator)) {
                return false;
            }
        } else if (et.predicateEvaluator != null) {
            return false;
        }
        return true;
    }

    protected SimpleTransition(SimpleTransition t, boolean addToStates) {
        super(t, addToStates);
        this.validDirection = t.validDirection;
        this.typeCollection = t.typeCollection;
        this.predicateEvaluator = t.predicateEvaluator;
        this.thisEdgeEvaluator = t.thisEdgeEvaluator;
        this.validToEdgeRoles = t.validToEdgeRoles;
        this.validFromEdgeRoles = t.validFromEdgeRoles;
    }

    @Override
    public Transition copy(boolean addToStates) {
        return new SimpleTransition(this, addToStates);
    }

    public SimpleTransition(State start, State end, GReQLDirection dir) {
        super(start, end);
        this.validDirection = dir;
        this.typeCollection = TypeCollection.empty();
    }

    public SimpleTransition(State start, State end, GReQLDirection dir, TypeCollection typeCollection, Set<String> roles, VertexEvaluator<? extends Expression> predicateEvaluator, GreqlQueryImpl query) {
        super(start, end);
        this.validDirection = dir;
        this.validToEdgeRoles = roles;
        this.validFromEdgeRoles = null;
        this.typeCollection = typeCollection;
        this.predicateEvaluator = predicateEvaluator;
        ThisEdge v = (ThisEdge)query.getQueryGraph().getFirstVertex(ThisEdge.VC);
        if (v != null) {
            this.thisEdgeEvaluator = (ThisEdgeEvaluator)query.getVertexEvaluator(v);
        }
    }

    @Override
    public void reverse() {
        super.reverse();
        if (this.validDirection == GReQLDirection.IN) {
            this.validDirection = GReQLDirection.OUT;
        } else if (this.validDirection == GReQLDirection.OUT) {
            this.validDirection = GReQLDirection.IN;
        }
        Set<String> tempSet = this.validFromEdgeRoles;
        this.validFromEdgeRoles = this.validToEdgeRoles;
        this.validToEdgeRoles = tempSet;
    }

    @Override
    public boolean isEpsilon() {
        return false;
    }

    @Override
    public boolean accepts(Vertex v, Edge e, InternalGreqlEvaluator evaluator) {
        EdgeClass edgeClass;
        if (e == null) {
            return false;
        }
        if (this.validDirection == GReQLDirection.OUT ? !e.isNormal() : this.validDirection == GReQLDirection.IN && e.isNormal()) {
            return false;
        }
        Set<String> validEdgeRoles = this.validToEdgeRoles;
        boolean checkToEdgeRoles = true;
        if (validEdgeRoles == null) {
            validEdgeRoles = this.validFromEdgeRoles;
            checkToEdgeRoles = false;
        }
        boolean rolesOnly = validEdgeRoles != null && this.typeCollection.isEmpty();
        boolean acceptedByRole = false;
        if (validEdgeRoles != null) {
            EdgeClass ec = e.getAttributedElementClass();
            Set<String> roles = null;
            roles = e.isNormal() == checkToEdgeRoles ? ec.getTo().getAllRoles() : ec.getFrom().getAllRoles();
            for (String role : roles) {
                if (!validEdgeRoles.contains(role)) continue;
                acceptedByRole = true;
                break;
            }
        }
        if (rolesOnly ? !acceptedByRole : !acceptedByRole && !this.typeCollection.acceptsType(edgeClass = e.getAttributedElementClass())) {
            return false;
        }
        if (this.predicateEvaluator != null) {
            Object res;
            if (this.thisEdgeEvaluator != null) {
                this.thisEdgeEvaluator.setValue(e, evaluator);
            }
            if ((res = this.predicateEvaluator.getResult(evaluator)) instanceof Boolean) {
                return (Boolean)res;
            }
            return false;
        }
        return true;
    }

    @Override
    public Vertex getNextVertex(Vertex v, Edge e) {
        return e.getThat();
    }

    @Override
    public String prettyPrint() {
        String symbol = "<->";
        if (this.validDirection == GReQLDirection.IN) {
            symbol = "<--";
        } else if (this.validDirection == GReQLDirection.OUT) {
            symbol = "-->";
        }
        return symbol + this.typeCollection.toString();
    }

    @Override
    public boolean consumesEdge() {
        return true;
    }
}

