/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.graphmarker;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.graphmarker.ArrayGraphMarkerIterator;
import de.uni_koblenz.jgralab.graphmarker.IntegerGraphMarker;
import de.uni_koblenz.jgralab.impl.InternalGraph;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IntegerVertexMarker
extends IntegerGraphMarker<Vertex> {
    public IntegerVertexMarker(Graph graph) {
        super(graph, ((InternalGraph)graph).getMaxVCount() + 1);
    }

    @Override
    public void edgeDeleted(Edge e) {
    }

    @Override
    public void maxEdgeCountIncreased(int newValue) {
    }

    @Override
    public void maxVertexCountIncreased(int newValue) {
        if (++newValue > this.temporaryAttributes.length) {
            this.expand(newValue);
        }
    }

    @Override
    public void vertexDeleted(Vertex v) {
        this.removeMark(v);
    }

    @Override
    public Iterable<Vertex> getMarkedElements() {
        return new Iterable<Vertex>(){

            @Override
            public Iterator<Vertex> iterator() {
                return new ArrayGraphMarkerIterator<Vertex>(IntegerVertexMarker.this.version){

                    @Override
                    public boolean hasNext() {
                        return this.index < IntegerVertexMarker.this.temporaryAttributes.length;
                    }

                    @Override
                    protected void moveIndex() {
                        int length = IntegerVertexMarker.this.temporaryAttributes.length;
                        while (this.index < length && IntegerVertexMarker.this.temporaryAttributes[this.index] == IntegerVertexMarker.this.unmarkedValue) {
                            ++this.index;
                        }
                    }

                    @Override
                    public Vertex next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException(NO_MORE_ELEMENTS_ERROR_MESSAGE);
                        }
                        if (this.version != IntegerVertexMarker.this.version) {
                            throw new ConcurrentModificationException(MODIFIED_ERROR_MESSAGE);
                        }
                        Vertex next = IntegerVertexMarker.this.graph.getVertex(this.index++);
                        this.moveIndex();
                        return next;
                    }
                };
            }
        };
    }
}

