/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.graphmarker;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.functions.entries.FunctionEntry;
import de.uni_koblenz.jgralab.graphmarker.MapGraphMarker;
import java.util.Iterator;

public class DirectedGraphMarker<O>
extends MapGraphMarker<AttributedElement<?, ?>, O> {
    public DirectedGraphMarker(Graph g) {
        super(g);
    }

    @Override
    public O getMark(AttributedElement<?, ?> elem) {
        if (elem == null) {
            return null;
        }
        assert (elem instanceof GraphElement && ((GraphElement)elem).getGraph() == this.graph || elem == this.graph);
        return (O)this.tempAttributeMap.get(elem);
    }

    @Override
    public O mark(AttributedElement<?, ?> elem, O value) {
        assert (elem instanceof GraphElement && ((GraphElement)elem).getGraph() == this.graph || elem == this.graph);
        return this.tempAttributeMap.put(elem, value);
    }

    @Override
    public void edgeDeleted(Edge e) {
        this.tempAttributeMap.remove(e);
        this.tempAttributeMap.remove(e.getReversedEdge());
    }

    @Override
    public boolean isMarked(AttributedElement<?, ?> elem) {
        assert (elem instanceof GraphElement && ((GraphElement)elem).getGraph() == this.graph || elem == this.graph);
        return this.tempAttributeMap.containsKey(elem);
    }

    @Override
    public boolean removeMark(AttributedElement<?, ?> elem) {
        assert (elem instanceof GraphElement && ((GraphElement)elem).getGraph() == this.graph || elem == this.graph);
        return this.tempAttributeMap.remove(elem) != null;
    }

    @Override
    public void vertexDeleted(Vertex v) {
        this.tempAttributeMap.remove(v);
    }

    @Override
    public Iterable<AttributedElement<?, ?>> getDomainElements() {
        return this.getMarkedElements();
    }

    @Override
    public Iterator<FunctionEntry<AttributedElement<?, ?>, O>> iterator() {
        final Iterator markedElements = this.getMarkedElements().iterator();
        return new Iterator<FunctionEntry<AttributedElement<?, ?>, O>>(){

            @Override
            public boolean hasNext() {
                return markedElements.hasNext();
            }

            @Override
            public FunctionEntry<AttributedElement<?, ?>, O> next() {
                AttributedElement currentElement = (AttributedElement)markedElements.next();
                return new FunctionEntry(currentElement, DirectedGraphMarker.this.get(currentElement));
            }

            @Override
            public void remove() {
                markedElements.remove();
            }
        };
    }
}

