/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.algolib.util;

import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Queue;

public class PriorityQueue<T> {
    private Queue<ValuePair<T>> queue;
    private Comparator<ValuePair<T>> comparator = new Comparator<ValuePair<T>>(){

        @Override
        public int compare(ValuePair<T> o1, ValuePair<T> o2) {
            return Double.compare(o1.value, o2.value);
        }
    };

    public PriorityQueue() {
        this.queue = new java.util.PriorityQueue<ValuePair<T>>(31, this.comparator);
    }

    public T getNext() {
        ValuePair<T> next = this.queue.poll();
        if (next == null) {
            throw new NoSuchElementException("Priority queue is empty.");
        }
        return next.element;
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public void put(T element, double value) {
        ValuePair<T> newElement = new ValuePair<T>(element, value);
        this.queue.add(newElement);
    }

    public int size() {
        return this.queue.size();
    }

    public PriorityQueue<T> clear() {
        this.queue.clear();
        return this;
    }

    private static class ValuePair<T> {
        public T element;
        public double value;

        public ValuePair(T element, double value) {
            this.set(element, value);
        }

        public ValuePair<T> set(T element, double value) {
            this.element = element;
            this.value = value;
            return this;
        }
    }
}

