/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.algolib.algorithms.search;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.TraversalContext;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmTerminatedException;
import de.uni_koblenz.jgralab.algolib.algorithms.search.DepthFirstSearch;
import de.uni_koblenz.jgralab.algolib.functions.BooleanFunction;

public class RecursiveDepthFirstSearch
extends DepthFirstSearch {
    public RecursiveDepthFirstSearch(Graph graph, BooleanFunction<Edge> navigable) {
        super(graph, navigable);
    }

    public RecursiveDepthFirstSearch(Graph graph) {
        this(graph, null);
    }

    @Override
    public RecursiveDepthFirstSearch execute(Vertex root) throws AlgorithmTerminatedException {
        TraversalContext subgraph = this.graph.getTraversalContext();
        if (subgraph != null && !subgraph.containsVertex(root) || this.visitedVertices.get(root)) {
            return this;
        }
        this.startRunning();
        if (this.level != null) {
            this.level.set(root, 0);
        }
        this.number.set(root, this.num);
        this.visitors.visitRoot(root);
        this.dfs(root);
        this.done();
        return this;
    }

    private void dfs(Vertex currentVertex) throws AlgorithmTerminatedException {
        this.vertexOrder[this.num] = currentVertex;
        this.number.set(currentVertex, this.num);
        this.visitors.visitVertex(currentVertex);
        this.visitedVertices.set(currentVertex, true);
        ++this.num;
        for (Edge currentEdge : currentVertex.incidences(this.traversalDirection)) {
            if (this.visitedEdges.get(currentEdge) || this.navigable != null && !this.navigable.get(currentEdge)) continue;
            Vertex nextVertex = currentEdge.getThat();
            this.edgeOrder[this.eNum] = currentEdge;
            if (this.enumber != null) {
                this.enumber.set(currentEdge, this.eNum);
            }
            this.visitors.visitEdge(currentEdge);
            this.visitedEdges.set(currentEdge, true);
            ++this.eNum;
            if (!this.visitedVertices.get(nextVertex)) {
                if (this.level != null) {
                    this.level.set(nextVertex, this.level.get(currentVertex) + 1);
                }
                if (this.parent != null) {
                    this.parent.set(currentEdge.getThat(), currentEdge);
                }
                this.visitors.visitTreeEdge(currentEdge);
                this.cancelIfInterrupted();
                this.dfs(nextVertex);
                this.visitors.leaveTreeEdge(currentEdge);
                continue;
            }
            this.visitors.visitFrond(currentEdge);
            if (!this.rnumber.isDefined(nextVertex)) {
                this.visitors.visitBackwardArc(currentEdge);
                continue;
            }
            if (this.number.get(currentVertex) < this.number.get(nextVertex)) {
                this.visitors.visitForwardArc(currentEdge);
                continue;
            }
            this.visitors.visitCrosslink(currentEdge);
        }
        this.rnumber.set(currentVertex, this.rNum);
        if (this.rorder != null) {
            this.rorder[this.rNum] = currentVertex;
        }
        this.visitors.leaveVertex(currentVertex);
        ++this.rNum;
    }

    @Override
    public RecursiveDepthFirstSearch execute() throws AlgorithmTerminatedException {
        super.execute();
        return this;
    }
}

