/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.algolib.algorithms.search;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.TraversalContext;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmTerminatedException;
import de.uni_koblenz.jgralab.algolib.algorithms.search.SearchAlgorithm;
import de.uni_koblenz.jgralab.algolib.algorithms.search.visitors.SearchVisitorList;
import de.uni_koblenz.jgralab.algolib.functions.BooleanFunction;
import de.uni_koblenz.jgralab.algolib.problems.TraversalFromVertexSolver;
import de.uni_koblenz.jgralab.algolib.visitors.Visitor;

public class BreadthFirstSearch
extends SearchAlgorithm
implements TraversalFromVertexSolver {
    private SearchVisitorList visitors;
    private int firstV;

    public BreadthFirstSearch(Graph graph, BooleanFunction<Edge> navigable) {
        super(graph, navigable);
    }

    public BreadthFirstSearch(Graph graph) {
        this(graph, null);
    }

    @Override
    public BreadthFirstSearch withLevel() {
        super.withLevel();
        return this;
    }

    @Override
    public BreadthFirstSearch withNumber() {
        super.withNumber();
        return this;
    }

    @Override
    public BreadthFirstSearch withENumber() {
        super.withENumber();
        return this;
    }

    @Override
    public BreadthFirstSearch withParent() {
        super.withParent();
        return this;
    }

    @Override
    public BreadthFirstSearch withoutLevel() {
        super.withoutLevel();
        return this;
    }

    @Override
    public BreadthFirstSearch withoutNumber() {
        super.withoutNumber();
        return this;
    }

    @Override
    public BreadthFirstSearch withoutENumber() {
        super.withoutENumber();
        return this;
    }

    @Override
    public BreadthFirstSearch withoutParent() {
        super.withoutParent();
        return this;
    }

    @Override
    public BreadthFirstSearch normal() {
        super.normal();
        return this;
    }

    @Override
    public BreadthFirstSearch reversed() {
        super.reversed();
        return this;
    }

    @Override
    public BreadthFirstSearch undirected() {
        super.undirected();
        return this;
    }

    @Override
    public void reset() {
        super.reset();
        this.firstV = 1;
        this.visitors.reset();
    }

    @Override
    public void resetParameters() {
        super.resetParameters();
        this.visitors = new SearchVisitorList();
    }

    public int getFirstV() {
        return this.firstV;
    }

    @Override
    public void addVisitor(Visitor visitor) {
        this.checkStateForSettingVisitors();
        visitor.setAlgorithm(this);
        this.visitors.addVisitor(visitor);
    }

    @Override
    public void removeVisitor(Visitor visitor) {
        this.checkStateForSettingVisitors();
        this.visitors.removeVisitor(visitor);
    }

    @Override
    public BreadthFirstSearch execute(Vertex root) throws AlgorithmTerminatedException {
        TraversalContext subgraph = this.graph.getTraversalContext();
        if (subgraph != null && !subgraph.containsVertex(root) || this.visitedVertices.get(root)) {
            return this;
        }
        this.startRunning();
        this.vertexOrder[this.num] = root;
        if (this.level != null) {
            this.level.set(root, 0);
        }
        this.visitors.visitRoot(root);
        if (this.number != null) {
            this.number.set(root, this.num);
        }
        this.visitors.visitVertex(root);
        this.visitedVertices.set(root, true);
        ++this.num;
        while (this.firstV < this.num && this.vertexOrder[this.firstV] != null) {
            Vertex currentVertex = this.vertexOrder[this.firstV++];
            for (Edge currentEdge : currentVertex.incidences(this.traversalDirection)) {
                this.cancelIfInterrupted();
                if (this.visitedEdges.get(currentEdge) || this.navigable != null && !this.navigable.get(currentEdge)) continue;
                Vertex nextVertex = currentEdge.getThat();
                this.edgeOrder[this.eNum] = currentEdge;
                if (this.enumber != null) {
                    this.enumber.set(currentEdge, this.eNum);
                }
                this.visitors.visitEdge(currentEdge);
                this.visitedEdges.set(currentEdge, true);
                ++this.eNum;
                if (this.visitedVertices.get(nextVertex)) {
                    this.visitors.visitFrond(currentEdge);
                    continue;
                }
                this.visitors.visitTreeEdge(currentEdge);
                this.vertexOrder[this.num] = nextVertex;
                if (this.level != null) {
                    this.level.set(nextVertex, this.level.get(currentVertex) + 1);
                }
                if (this.parent != null) {
                    this.parent.set(currentEdge.getThat(), currentEdge);
                }
                if (this.number != null) {
                    this.number.set(nextVertex, this.num);
                }
                this.visitors.visitVertex(nextVertex);
                this.visitedVertices.set(nextVertex, true);
                ++this.num;
            }
        }
        this.done();
        return this;
    }

    @Override
    public BreadthFirstSearch execute() throws AlgorithmTerminatedException {
        super.execute();
        return this;
    }
}

