/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.algolib.algorithms.reachability;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmStates;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmTerminatedException;
import de.uni_koblenz.jgralab.algolib.algorithms.StructureOrientedAlgorithm;
import de.uni_koblenz.jgralab.algolib.algorithms.search.BreadthFirstSearch;
import de.uni_koblenz.jgralab.algolib.algorithms.search.SearchAlgorithm;
import de.uni_koblenz.jgralab.algolib.functions.ArrayBinaryFunction;
import de.uni_koblenz.jgralab.algolib.functions.ArrayRelation;
import de.uni_koblenz.jgralab.algolib.functions.BinaryFunction;
import de.uni_koblenz.jgralab.algolib.functions.BooleanFunction;
import de.uni_koblenz.jgralab.algolib.functions.IntFunction;
import de.uni_koblenz.jgralab.algolib.functions.Permutation;
import de.uni_koblenz.jgralab.algolib.functions.Relation;
import de.uni_koblenz.jgralab.algolib.problems.ReachabilitySolver;
import de.uni_koblenz.jgralab.algolib.problems.SimplePathsSolver;
import de.uni_koblenz.jgralab.algolib.visitors.Visitor;

public class WarshallAlgorithm
extends StructureOrientedAlgorithm
implements ReachabilitySolver,
SimplePathsSolver {
    private IntFunction<Vertex> indexMapping;
    private Permutation<Vertex> vertexOrder;
    private int vertexCount;
    private boolean[][] reachable;
    private Edge[][] successor;

    public WarshallAlgorithm(Graph graph) {
        this(graph, null);
    }

    public WarshallAlgorithm(Graph graph, BooleanFunction<Edge> navigable) {
        super(graph, navigable);
    }

    @Override
    public void addVisitor(Visitor visitor) {
        this.checkStateForSettingVisitors();
        throw new UnsupportedOperationException("This algorithm does not support any visitors.");
    }

    @Override
    public void disableOptionalResults() {
    }

    @Override
    protected void done() {
        this.state = AlgorithmStates.FINISHED;
    }

    @Override
    public WarshallAlgorithm normal() {
        super.normal();
        return this;
    }

    @Override
    public WarshallAlgorithm reversed() {
        super.reversed();
        return this;
    }

    @Override
    public WarshallAlgorithm undirected() {
        super.undirected();
        return this;
    }

    @Override
    public boolean isHybrid() {
        return true;
    }

    @Override
    public void removeVisitor(Visitor visitor) {
        this.checkStateForSettingVisitors();
        throw new UnsupportedOperationException("This algorithm does not support any visitors.");
    }

    @Override
    public void reset() {
        super.reset();
        BreadthFirstSearch search = new BreadthFirstSearch(this.graph, null).withNumber();
        search.setTraversalDirection(this.traversalDirection);
        try {
            ((SearchAlgorithm)search).execute();
        }
        catch (AlgorithmTerminatedException algorithmTerminatedException) {
            // empty catch block
        }
        assert (search.getState() == AlgorithmStates.FINISHED);
        this.indexMapping = search.getNumber();
        this.vertexOrder = search.getVertexOrder();
        this.vertexCount = this.graph.getVCount();
        this.reachable = new boolean[this.vertexCount + 1][this.vertexCount + 1];
        this.successor = new Edge[this.vertexCount + 1][this.vertexCount + 1];
    }

    @Override
    public void resetParameters() {
        super.resetParameters();
        this.traversalDirection = EdgeDirection.OUT;
    }

    @Override
    public WarshallAlgorithm execute() throws AlgorithmTerminatedException {
        this.startRunning();
        int length = this.vertexCount + 1;
        for (int vId = 1; vId < length; ++vId) {
            for (int wId = 1; wId < length; ++wId) {
                this.successor[vId][wId] = null;
            }
            this.reachable[vId][vId] = true;
        }
        for (Edge e : this.graph.edges()) {
            if (this.navigable != null && !this.navigable.get(e)) continue;
            int vId = this.indexMapping.get(e.getAlpha());
            int wId = this.indexMapping.get(e.getOmega());
            switch (this.traversalDirection) {
                case OUT: {
                    this.reachable[vId][wId] = true;
                    this.successor[vId][wId] = e;
                    break;
                }
                case INOUT: {
                    this.reachable[vId][wId] = true;
                    this.reachable[wId][vId] = true;
                    this.successor[vId][wId] = e;
                    this.successor[wId][vId] = e.getReversedEdge();
                    break;
                }
                case IN: {
                    this.reachable[wId][vId] = true;
                    this.successor[wId][vId] = e.getReversedEdge();
                }
            }
        }
        for (int vId = 1; vId <= this.vertexCount; ++vId) {
            for (int uId = 1; uId <= this.vertexCount; ++uId) {
                for (int wId = 1; wId <= this.vertexCount; ++wId) {
                    if (!this.reachable[uId][vId] || !this.reachable[vId][wId] || this.reachable[uId][wId]) continue;
                    this.cancelIfInterrupted();
                    this.reachable[uId][wId] = true;
                    this.successor[uId][wId] = this.successor[uId][vId];
                }
            }
        }
        this.done();
        return this;
    }

    @Override
    public Relation<Vertex, Vertex> getReachable() {
        this.checkStateForResult();
        return new ArrayRelation<Vertex>(this.reachable, this.indexMapping);
    }

    @Override
    public BinaryFunction<Vertex, Vertex, Edge> getSuccessor() {
        return new ArrayBinaryFunction<Vertex, Edge>(this.successor, this.indexMapping);
    }

    public Permutation<Vertex> getVertexOrder() {
        return this.vertexOrder;
    }

    public IntFunction<Vertex> getIndexMapping() {
        return this.indexMapping;
    }

    public boolean[][] getInternalReachable() {
        return this.reachable;
    }

    public Edge[][] getInternalSuccessor() {
        return this.successor;
    }
}

