/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab;

import de.uni_koblenz.jgralab.EclipseAdapter;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.pcollections.ArrayPMap;
import org.pcollections.ArrayPSet;
import org.pcollections.ArrayPVector;
import org.pcollections.PMap;
import org.pcollections.PSet;
import org.pcollections.PVector;

public class JGraLab {
    private static EclipseAdapter eclipseAdapter;
    private static String version;
    private static String codename;
    private static final String[] versionInfo;
    private static final String[] copyrightInfo;
    private static HashMap<String, Logger> loggerMap;
    private static Logger rootLogger;

    private static void readVersionFromManifest() {
        codename = "unknown";
        version = "unknown";
        if (eclipseAdapter != null) {
            version = eclipseAdapter.getJGraLabVersion();
            codename = eclipseAdapter.getJGraLabCodename();
        } else {
            try {
                Enumeration<URL> resources = JGraLab.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
                JGraLab.extractVersionInfo(resources);
                if (version.equals("unknown") || codename.equals("unknown")) {
                    resources = JGraLab.class.getClassLoader().getResources("MANIFEST.MF");
                    JGraLab.extractVersionInfo(resources);
                    if (version.equals("unknown") || codename.equals("unknown")) {
                        JGraLab.getRootLogger().warning("MANIFEST.MF not found.");
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void extractVersionInfo(Enumeration<URL> resources) throws IOException {
        while (resources.hasMoreElements()) {
            String implTitle;
            URL url = resources.nextElement();
            Manifest manifest = new Manifest(url.openStream());
            Map<String, Attributes> entries = manifest.getEntries();
            Attributes info = entries.get("de/uni_koblenz/jgralab/");
            if (info == null || !(implTitle = info.getValue("Implementation-Title")).equals("JGraLab")) continue;
            String[] versionString = info.getValue("Implementation-Version").split("@");
            version = versionString[0];
            codename = versionString[1];
        }
    }

    private static String getVersion() {
        if (version == null) {
            JGraLab.readVersionFromManifest();
        }
        return version;
    }

    private static String getCodename() {
        if (codename == null) {
            JGraLab.readVersionFromManifest();
        }
        return codename;
    }

    public static Level setLogLevel(Level level) {
        Level old = JGraLab.getRootLogger().getLevel();
        JGraLab.getRootLogger().setLevel(level);
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getRootLogger() {
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            if (rootLogger == null) {
                rootLogger = Logger.getLogger("");
                loggerMap.put("", rootLogger);
                rootLogger.setUseParentHandlers(false);
                ConsoleHandler consoleHandler = new ConsoleHandler();
                consoleHandler.setLevel(Level.ALL);
                consoleHandler.setFormatter(new Formatter(){

                    @Override
                    public String format(LogRecord record) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(record.getLevel()).append(" ").append(record.getSourceClassName()).append(".").append(record.getSourceMethodName()).append(": ").append(record.getMessage()).append('\n');
                        return sb.toString();
                    }
                });
                JGraLab.removeHandlers(rootLogger);
                rootLogger.addHandler(consoleHandler);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return rootLogger;
        }
    }

    private static void removeHandlers(Logger l) {
        for (Handler h : l.getHandlers()) {
            l.removeHandler(h);
        }
    }

    public static Logger getLogger(String packageName) {
        if (packageName.equals("")) {
            return JGraLab.getRootLogger();
        }
        Logger l = loggerMap.get(packageName);
        if (l != null) {
            return l;
        }
        l = Logger.getLogger(packageName, null);
        l.setParent(JGraLab.getParentLogger(packageName));
        l.setLevel(null);
        l.setUseParentHandlers(true);
        loggerMap.put(packageName, l);
        return l;
    }

    public static Logger getLogger(Class<?> cls) {
        return JGraLab.getLogger(cls.getPackage().getName());
    }

    private static Logger getParentLogger(String childPkgName) {
        if (!childPkgName.contains(".")) {
            return JGraLab.getRootLogger();
        }
        int lastDot = childPkgName.lastIndexOf(46);
        String parentPkgName = childPkgName.substring(0, lastDot);
        return JGraLab.getLogger(parentPkgName);
    }

    public static void main(String[] args) {
        System.out.println(JGraLab.getInfo(false));
    }

    private static String addInfo(String inputLine) {
        return inputLine.replace("$ver", JGraLab.getVersion()).replace("$codename", JGraLab.getCodename());
    }

    public static String getVersionInfo(boolean asTGComment) {
        return JGraLab.getInfoString(versionInfo, asTGComment);
    }

    public static String getInfo(boolean asTGComment) {
        String[] lines = new String[versionInfo.length + copyrightInfo.length];
        System.arraycopy(versionInfo, 0, lines, 0, versionInfo.length);
        System.arraycopy(copyrightInfo, 0, lines, versionInfo.length, copyrightInfo.length);
        return JGraLab.getInfoString(lines, asTGComment);
    }

    private static String getInfoString(String[] lines, boolean asTGComment) {
        StringBuilder output = new StringBuilder();
        for (String line : lines) {
            if (asTGComment) {
                output.append("// ");
            } else {
                output.append(' ');
            }
            output.append(JGraLab.addInfo(line));
            output.append('\n');
        }
        output.append('\n');
        return output.toString();
    }

    public static final <T> PVector<T> vector() {
        return ArrayPVector.empty();
    }

    public static final <T> PSet<T> set() {
        return ArrayPSet.empty();
    }

    public static final <K, V> PMap<K, V> map() {
        return ArrayPMap.empty();
    }

    public static void setEclipseAdapter(EclipseAdapter eclipseAdapter) {
        JGraLab.eclipseAdapter = eclipseAdapter;
    }

    public static EclipseAdapter getEclipseAdapter() {
        return eclipseAdapter;
    }

    static {
        versionInfo = new String[]{"JGraLab - The Java graph laboratory", "  Version : $ver", "  Codename: $codename"};
        copyrightInfo = new String[]{"Copyright (C) 2006-2013 Institute for Software Technology", "                        University of Koblenz-Landau, Germany", "                        ist@uni-koblenz.de", "", "For bug reports, documentation and further information, visit", "", "                        https://github.com/jgralab/jgralab", "", "This program is free software; you can redistribute it and/or modify it", "under the terms of the GNU General Public License as published by the", "Free Software Foundation; either version 3 of the License, or (at your", "option) any later version.", "", "This program is distributed in the hope that it will be useful, but", "WITHOUT ANY WARRANTY; without even the implied warranty of", "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General", "Public License for more details.", "", "You should have received a copy of the GNU General Public License along", "with this program; if not, see <http://www.gnu.org/licenses>.", "", "Additional permission under GNU GPL version 3 section 7", "", "If you modify this Program, or any covered work, by linking or combining", "it with Eclipse (or a modified version of that program or an Eclipse", "plugin), containing parts covered by the terms of the Eclipse Public", "License (EPL), the licensors of this Program grant you additional", "permission to convey the resulting work.  Corresponding Source for a", "non-source form of such a combination shall include the source code for", "the parts of JGraLab used as well as that of the covered work.", "", "This software uses:", "", "Apache Commons CLI 1.2", "Copyright 2001-2009 The Apache Software Foundation"};
        loggerMap = new HashMap();
        rootLogger = JGraLab.getRootLogger();
    }
}

