/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.ist.utilities.plist;

import de.uni_koblenz.ist.utilities.plist.PListDict;
import de.uni_koblenz.ist.utilities.plist.PListException;
import de.uni_koblenz.ist.utilities.plist.PListProcessor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class PList {
    static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private PListDict dict;
    private String filename;

    public PList() {
        this.dict = new PListDict();
    }

    public PList(String filename) throws PListException {
        this.filename = filename;
        try {
            this.dict = this.loadFrom(filename);
        }
        catch (PListException e) {
            if (e.getCause() instanceof FileNotFoundException) {
                this.dict = new PListDict();
            }
            throw e;
        }
    }

    public void store() throws PListException {
        this.storeTo(this.filename);
    }

    public void store(boolean makeBackup) throws PListException {
        this.storeTo(this.filename, makeBackup);
    }

    public PListDict loadFrom(String filename) throws PListException {
        try {
            PListProcessor parser = new PListProcessor();
            parser.process(filename);
            return parser.getDict();
        }
        catch (Exception e) {
            throw new PListException("Error reading property list '" + filename + "'", e);
        }
    }

    public void storeTo(String filename) throws PListException {
        this.storeTo(new File(filename), false);
    }

    public void storeTo(String filename, boolean makeBackup) throws PListException {
        this.storeTo(new File(filename), makeBackup);
    }

    public void storeTo(File file, boolean makeBackup) throws PListException {
        XMLStreamWriter writer = null;
        try {
            if (makeBackup && file.exists()) {
                File backupFile = new File(file.getCanonicalPath() + "~");
                if (backupFile.exists() && !backupFile.delete()) {
                    throw new PListException("Can't delete old backup " + backupFile.getCanonicalPath());
                }
                if (!file.renameTo(backupFile)) {
                    throw new PListException("Can't rename " + file.getCanonicalPath() + " to " + backupFile.getCanonicalPath());
                }
            }
            writer = XMLOutputFactory.newInstance().createXMLStreamWriter(new BufferedOutputStream(new FileOutputStream(file)), "UTF-8");
            this.print(writer);
            writer.close();
        }
        catch (Exception e) {
            throw new PListException("Error writing property list '" + this.filename + "'", e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (XMLStreamException e) {
                    throw new PListException("Error writing property list '" + this.filename + "'", e);
                }
            }
        }
    }

    public void print(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartDocument();
        writer.writeDTD("\n<!DOCTYPE plist PUBLIC \"-//Apple Computer//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n");
        writer.writeStartElement("plist");
        writer.writeAttribute("version", "1.0");
        this.print(writer, this.dict);
        writer.writeEndElement();
        writer.writeEndDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void print(XMLStreamWriter writer, Object o) throws XMLStreamException {
        if (o instanceof PListDict) {
            Set<Map.Entry<String, Object>> entries = ((PListDict)o).entrySet();
            if (entries.size() == 0) {
                writer.writeEmptyElement("dict");
            } else {
                writer.writeStartElement("dict");
                for (Map.Entry<String, Object> entry : entries) {
                    writer.writeStartElement("key");
                    writer.writeCharacters(entry.getKey().toString());
                    writer.writeEndElement();
                    this.print(writer, entry.getValue());
                }
                writer.writeEndElement();
            }
        } else if (o instanceof List) {
            List l = (List)o;
            if (l.size() == 0) {
                writer.writeEmptyElement("array");
            } else {
                writer.writeStartElement("array");
                for (Object element : l) {
                    this.print(writer, element);
                }
                writer.writeEndElement();
            }
        } else if (o instanceof Integer) {
            writer.writeStartElement("integer");
            writer.writeCharacters(o.toString());
            writer.writeEndElement();
        } else if (o instanceof String) {
            writer.writeStartElement("string");
            writer.writeCharacters(o.toString());
            writer.writeEndElement();
        } else if (o instanceof Double) {
            writer.writeStartElement("real");
            writer.writeCharacters(o.toString());
            writer.writeEndElement();
        } else if (o instanceof Boolean) {
            writer.writeEmptyElement(o.toString());
        } else if (o instanceof Date) {
            String s;
            DateFormat dateFormat = PList.dateFormat;
            synchronized (dateFormat) {
                s = PList.dateFormat.format((Date)o);
            }
            writer.writeStartElement("date");
            writer.writeCharacters(s);
            writer.writeEndElement();
        }
    }

    public PListDict getDict() {
        return this.dict;
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

