/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.ist.utilities.option_handler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class OptionHandler {
    private List<Option> optionList;
    private List<OptionGroup> optionGroupList;
    private Options options = new Options();
    private Set<Option> requiredOptions;
    private Set<OptionGroup> requiredOptionGroups;
    private String usageString;
    private String toolString;
    private String versionString;
    private HelpFormatter helpFormatter;
    private int argumentCount;
    private String argumentName;
    private boolean optionalArgument;
    private ParserType parserType;

    public OptionHandler(String toolString, String versionString) {
        this.optionList = new ArrayList<Option>();
        this.optionGroupList = new ArrayList<OptionGroup>();
        this.requiredOptions = new HashSet<Option>();
        this.requiredOptionGroups = new HashSet<OptionGroup>();
        this.helpFormatter = new HelpFormatter();
        this.parserType = ParserType.GNU;
        this.toolString = toolString;
        this.versionString = versionString;
        Option help = new Option("h", "help", false, "(optional): print this help message.");
        help.setRequired(false);
        this.addOption(help);
        Option version = new Option("v", "version", false, "(optional): print version information");
        version.setRequired(false);
        this.addOption(version);
        OptionGroup mainOptions = new OptionGroup();
        mainOptions.setRequired(false);
        mainOptions.addOption(help);
        mainOptions.addOption(version);
        this.options.addOptionGroup(mainOptions);
        this.argumentCount = 0;
        this.argumentName = "parameter";
        this.optionalArgument = false;
    }

    public void addOption(Option o) {
        if (o.isRequired()) {
            this.requiredOptions.add(o);
            o.setRequired(false);
        }
        this.optionList.add(o);
        this.options.addOption(o);
    }

    public void addOptionGroup(OptionGroup og) {
        if (og.isRequired()) {
            this.requiredOptionGroups.add(og);
            og.setRequired(false);
        }
        this.optionGroupList.add(og);
        this.options.addOptionGroup(og);
    }

    public Options getOptions() {
        return this.options;
    }

    public void printVersionAndExit(int exitCode) {
        System.out.println(this.versionString);
        System.exit(exitCode);
    }

    public void printHelpAndExit(int exitCode) {
        this.helpFormatter.printHelp(this.getUsageString(), this.options);
        System.exit(exitCode);
    }

    private String getUsageString() {
        if (this.usageString == null) {
            StringBuilder out = new StringBuilder(this.toolString);
            for (Option current : this.optionList) {
                out.append(" ");
                if (this.isOptionRequired(current)) {
                    this.appendOption(out, current);
                    continue;
                }
                out.append("[");
                this.appendOption(out, current);
                out.append("]");
            }
            this.appendAdditionalArguments(out);
            this.usageString = out.toString();
        }
        return this.usageString;
    }

    private void appendAdditionalArguments(StringBuilder out) {
        if (this.argumentCount != 0) {
            out.append(" (");
            if (this.optionalArgument) {
                out.append("[");
            }
            if (this.argumentCount == -2) {
                this.appendArgument(out);
                out.append(" ");
                out.append("{");
                this.appendArgument(out);
                out.append("}");
            } else {
                for (int i = 0; i < this.argumentCount; ++i) {
                    this.appendArgument(out);
                }
            }
            if (this.optionalArgument) {
                out.append("]");
            }
            out.append(")");
        }
    }

    private void appendArgument(StringBuilder out) {
        out.append("<");
        out.append(this.argumentName);
        out.append(">");
    }

    public boolean isOptionRequired(Option o) {
        return this.requiredOptions.contains(o);
    }

    public boolean containsAllRequiredOptions(CommandLine comLine) {
        boolean ok = true;
        Option[] setOptions = comLine.getOptions();
        HashSet<Option> setOptionsSet = new HashSet<Option>();
        for (Option current : setOptions) {
            setOptionsSet.add(current);
        }
        for (Option current : this.optionList) {
            if (this.isOptionRequired(current) && !(ok &= setOptionsSet.contains(current))) break;
        }
        return ok && !this.requiredOptionGroups.isEmpty() ? ok && this.containsAllRequiredOptionGroups(setOptions) : ok;
    }

    private boolean containsAllRequiredOptionGroups(Option[] setOptions) {
        boolean allContained = true;
        for (OptionGroup currentRequiredOptionGroup : this.requiredOptionGroups) {
            boolean currentContained = false;
            for (Option currentOption : setOptions) {
                if (currentContained |= currentRequiredOptionGroup.getOptions().contains(currentOption)) break;
            }
            if (allContained &= currentContained) continue;
            break;
        }
        return allContained;
    }

    private void appendOption(StringBuilder out, Option current) {
        out.append("-");
        out.append(current.getOpt());
        int numberOfArgs = current.getArgs();
        out.append(" ");
        if (current.hasOptionalArg()) {
            out.append("[");
        }
        if (numberOfArgs == -2) {
            this.appendArgName(out, current);
            out.append("{");
            out.append(current.getValueSeparator());
            this.appendArgName(out, current);
            out.append("}");
        }
        if (numberOfArgs >= 1) {
            this.appendArgName(out, current);
            for (int i = 1; i < numberOfArgs; ++i) {
                out.append(current.getValueSeparator());
                this.appendArgName(out, current);
            }
        }
        if (current.hasOptionalArg()) {
            out.append("]");
        }
    }

    private void appendArgName(StringBuilder out, Option current) {
        out.append("<").append(current.getArgName()).append(">");
    }

    public CommandLine parse(String[] args) {
        try {
            CommandLineParser parser = this.getParser();
            CommandLine comLine = parser.parse(this.getOptions(), args);
            if (comLine.hasOption("h")) {
                this.printHelpAndExit(0);
            } else if (comLine.hasOption("v")) {
                this.printVersionAndExit(0);
            } else if (!this.containsAllRequiredOptions(comLine)) {
                System.err.println("Required options are missing.");
                this.printHelpAndExit(1);
            }
            return comLine;
        }
        catch (ParseException e) {
            System.err.println(OptionHandler.parseErrorMessage(e.getMessage()));
            this.printHelpAndExit(1);
            return null;
        }
    }

    private static String parseErrorMessage(String error) {
        StringBuilder sb = new StringBuilder(error.length());
        int begin = 0;
        int end = error.indexOf(91);
        if (end == -1) {
            return error;
        }
        sb.append(error.substring(begin, end));
        sb.append("\n\t");
        begin = end + 1;
        while ((end = error.indexOf(44, begin)) != -1) {
            sb.append(error.substring(begin, end + 1).trim());
            sb.append("\n\t");
            begin = end + 1;
        }
        sb.append(error.substring(begin, error.length() - 1).trim());
        return sb.toString();
    }

    public void setArgumentCount(int argumentCount) {
        this.argumentCount = argumentCount;
    }

    public void setArgumentName(String argumentName) {
        this.argumentName = argumentName;
    }

    public void setOptionalArgument(boolean optionalArgument) {
        this.optionalArgument = optionalArgument;
    }

    public OptionHandler withPosixParser() {
        this.parserType = ParserType.POSIX;
        return this;
    }

    public OptionHandler withBasicParser() {
        this.parserType = ParserType.BASIC;
        return this;
    }

    public OptionHandler withGnuParser() {
        this.parserType = ParserType.GNU;
        return this;
    }

    private CommandLineParser getParser() {
        switch (this.parserType) {
            case GNU: {
                return new GnuParser();
            }
            case POSIX: {
                return new PosixParser();
            }
            case BASIC: {
                return new BasicParser();
            }
        }
        return null;
    }

    public static enum ParserType {
        BASIC,
        GNU,
        POSIX;

    }
}

