/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.ist.utilities.license_header;

import de.uni_koblenz.ist.utilities.option_handler.OptionHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class LicenseHeader {
    private static final String XML_ENCODING_PREFIX = "<?xml";
    private static final String INDENT = "    ";
    private static final String JAVA_FIRST_LINE = "/*";
    private static final String JAVA_PREFIX = " * ";
    private static final String JAVA_EMPTY_LINE = " *";
    private static final String JAVA_LAST_LINE = " */";
    private static final String XML_START = "<!-- ";
    private static final String XML_END = " -->";
    private static final String TG_PREFIX = "// ";
    private static final String TG_EMPTY_LINE = "//";
    private File input;
    private File licence;
    private boolean fullyRecursive;
    private boolean verbose;
    private int newlyAdded;
    private int replaced;
    private List<String> javaHeaderLines;
    private List<String> xmlHeaderLines;
    private List<String> tgHeaderLines;

    public static void main(String[] args) {
        CommandLine cl = LicenseHeader.processCommandLineOptions(args);
        assert (cl.hasOption('i'));
        assert (cl.hasOption('l'));
        LicenseHeader lh = new LicenseHeader(cl.getOptionValue('i'), cl.getOptionValue('l'), cl.hasOption('r'), cl.hasOption('V'));
        try {
            lh.process();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static CommandLine processCommandLineOptions(String[] args) {
        OptionHandler oh = new OptionHandler("java " + LicenseHeader.class.getName(), "1.0");
        Option input = new Option("i", "input", true, "(required): The file or directory to process.");
        input.setRequired(true);
        input.setArgName("fileOrDirectory");
        oh.addOption(input);
        Option licenceHeader = new Option("l", "licence", true, "(required): The file containing the licence header in the correct format. This file should be in plain text without any language specific syntax for comments.");
        licenceHeader.setRequired(true);
        licenceHeader.setArgName("licenseFile");
        oh.addOption(licenceHeader);
        Option recursive = new Option("r", "recursive", false, "(optional): This flag tells the program to process the given directory fully recursively. If only a file is given, this option is ignored. If this flag is not set, only the given directory is processed, without subdirectories.");
        recursive.setRequired(false);
        oh.addOption(recursive);
        Option verbose = new Option("V", "verbose", false, "(optional): This flag tells the program to be more verbose while processing the files. If it is not set, only a summary will be given in the end.");
        verbose.setRequired(false);
        oh.addOption(verbose);
        return oh.parse(args);
    }

    public LicenseHeader(String input, String licence, boolean fullyRecursive, boolean verbose) {
        this.input = new File(input);
        this.licence = new File(licence);
        this.fullyRecursive = fullyRecursive;
        this.verbose = verbose;
        this.newlyAdded = 0;
        this.replaced = 0;
    }

    private void printIndent(int level) {
        for (int i = 0; i < level; ++i) {
            System.out.print(INDENT);
        }
    }

    public void process() throws IOException {
        if (!this.input.exists()) {
            throw new FileNotFoundException("The given input file/directory \"" + this.input.getAbsolutePath() + "\" does not exist.");
        }
        if (!this.licence.exists()) {
            throw new FileNotFoundException("The given licence file \"" + this.licence.getAbsolutePath() + "\" does not exist.");
        }
        if (this.licence.isDirectory()) {
            throw new IllegalArgumentException("The given licence file \"" + this.licence.getAbsolutePath() + "\" is a directory");
        }
        if (this.input.isDirectory()) {
            System.out.println("Adding license headers to directory " + this.input.getAbsolutePath() + (this.fullyRecursive ? " and all subdirectories." : " ignoring subdirectories."));
            this.processDirectory(this.input, 0);
        } else {
            System.out.println("Adding license header to file " + this.input.getAbsolutePath());
            this.processJavaFile(this.input, 0, JAVA_FIRST_LINE, JAVA_PREFIX, JAVA_LAST_LINE);
        }
        int processed = this.replaced + this.newlyAdded;
        System.out.println();
        System.out.println("Summary:");
        System.out.println("Processed " + processed + " files.");
        System.out.println(this.newlyAdded + "/" + processed + " files didn't have a license header.");
        System.out.println(this.replaced + "/" + processed + " files' headers were replaced by the new one.");
        System.out.println();
    }

    private void processDirectory(final File toProcess, int level) throws IOException {
        File[] directories = toProcess.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && !pathname.getName().equals(".svn");
            }
        });
        File[] javaFilesToProcess = toProcess.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return dir.getAbsolutePath().equals(toProcess.getAbsolutePath()) && name.toLowerCase().endsWith(".java");
            }
        });
        File[] xmlFilesToProcess = toProcess.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String lowerCaseName = name.toLowerCase();
                return dir.getAbsolutePath().equals(toProcess.getAbsolutePath()) && (lowerCaseName.endsWith(".xml") || lowerCaseName.endsWith(".xmi"));
            }
        });
        File[] tgFilesToProcess = toProcess.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return dir.getAbsolutePath().equals(toProcess.getAbsolutePath()) && name.toLowerCase().endsWith(".tg");
            }
        });
        if (this.fullyRecursive) {
            for (File currentSubdirectory : directories) {
                if (this.verbose) {
                    this.printIndent(level);
                    System.out.println("Entering directory " + currentSubdirectory.getName());
                }
                this.processDirectory(currentSubdirectory, level + 1);
                if (!this.verbose) continue;
                this.printIndent(level);
                System.out.println("Leaving directory " + currentSubdirectory.getName());
            }
        }
        for (File currentJavaFile : javaFilesToProcess) {
            this.processJavaFile(currentJavaFile, level, JAVA_FIRST_LINE, JAVA_PREFIX, JAVA_LAST_LINE);
        }
        for (File currentXMLFile : xmlFilesToProcess) {
            this.processXMLFile(currentXMLFile, level, 72);
        }
        for (File currentTGFile : tgFilesToProcess) {
            this.processTGFile(currentTGFile, level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processXMLFile(File toProcess, int level, int length) throws FileNotFoundException, IOException {
        if (this.verbose) {
            this.printIndent(level);
            System.out.println("Processing file " + toProcess.getName());
        }
        if (this.xmlHeaderLines == null) {
            this.cacheXMLHeader(length);
        }
        LinkedList<String> outputLines = new LinkedList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(toProcess));){
            ParseState state = ParseState.BEFORE_HEADER;
            int skippedLines = 0;
            String currentLine = null;
            do {
                if ((currentLine = reader.readLine()) == null) continue;
                String trimmedLine = currentLine.trim();
                switch (state) {
                    case BEFORE_HEADER: {
                        if (trimmedLine.length() == 0) {
                            ++skippedLines;
                            break;
                        }
                        if (trimmedLine.startsWith(XML_START.trim())) {
                            state = trimmedLine.endsWith(XML_END.trim()) ? ParseState.BEFORE_HEADER : ParseState.IN_HEADER;
                            ++skippedLines;
                            break;
                        }
                        if (trimmedLine.toLowerCase().startsWith(XML_ENCODING_PREFIX)) {
                            outputLines.add(currentLine);
                            break;
                        }
                        assert (trimmedLine.startsWith("<"));
                        state = ParseState.AFTER_HEADERS;
                        outputLines.add(currentLine);
                        break;
                    }
                    case IN_HEADER: {
                        ++skippedLines;
                        if (!trimmedLine.endsWith(XML_END.trim())) break;
                        state = ParseState.BEFORE_HEADER;
                        break;
                    }
                    case AFTER_HEADERS: {
                        outputLines.add(currentLine);
                    }
                }
            } while (currentLine != null);
            if (skippedLines > 0) {
                if (this.verbose) {
                    this.printIndent(level + 1);
                    System.out.println("Skipped " + skippedLines + " lines and replaced " + (skippedLines == 1 ? "it" : "them") + " with new header.");
                }
                ++this.replaced;
            } else {
                if (this.verbose) {
                    this.printIndent(level + 1);
                    System.out.println("Added header.");
                }
                ++this.newlyAdded;
            }
        }
        try (PrintWriter writer = new PrintWriter(toProcess);){
            String firstLine = (String)outputLines.get(0);
            if (firstLine.trim().startsWith(XML_ENCODING_PREFIX)) {
                writer.println(firstLine);
                outputLines.remove(0);
            }
            for (String currentOutputLine : this.xmlHeaderLines) {
                writer.println(currentOutputLine);
            }
            for (String currentOutputLine : outputLines) {
                writer.println(currentOutputLine);
            }
            writer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTGFile(File toProcess, int level) throws FileNotFoundException, IOException {
        if (this.verbose) {
            this.printIndent(level);
            System.out.println("Processing file " + toProcess.getName());
        }
        if (this.tgHeaderLines == null) {
            this.cacheTGHeader();
        }
        LinkedList<String> outputLines = new LinkedList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(toProcess));){
            ParseState state = ParseState.IN_HEADER;
            int skippedLines = 0;
            String currentLine = null;
            do {
                if ((currentLine = reader.readLine()) == null) continue;
                String trimmedLine = currentLine.trim();
                switch (state) {
                    case BEFORE_HEADER: {
                        break;
                    }
                    case IN_HEADER: {
                        if (trimmedLine.length() == 0) {
                            ++skippedLines;
                            break;
                        }
                        if (trimmedLine.startsWith(TG_EMPTY_LINE)) {
                            if (currentLine.contains("Version :")) {
                                state = ParseState.AFTER_HEADERS;
                                outputLines.add(currentLine);
                            }
                            ++skippedLines;
                            break;
                        }
                        assert (trimmedLine.startsWith("TGraph2"));
                        state = ParseState.AFTER_HEADERS;
                        outputLines.add(currentLine);
                        break;
                    }
                    case AFTER_HEADERS: {
                        outputLines.add(currentLine);
                    }
                }
            } while (currentLine != null);
            if (skippedLines > 0) {
                if (this.verbose) {
                    this.printIndent(level + 1);
                    System.out.println("Skipped " + skippedLines + " lines and replaced " + (skippedLines == 1 ? "it" : "them") + " with new header.");
                }
                ++this.replaced;
            } else {
                if (this.verbose) {
                    this.printIndent(level + 1);
                    System.out.println("Added header.");
                }
                ++this.newlyAdded;
            }
        }
        try (PrintWriter writer = new PrintWriter(toProcess);){
            for (String currentOutputLine : this.tgHeaderLines) {
                writer.println(currentOutputLine);
            }
            for (String currentOutputLine : outputLines) {
                writer.println(currentOutputLine);
            }
            writer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJavaFile(File toProcess, int level, String firstLine, String prefix, String lastLine) throws IOException {
        if (this.verbose) {
            this.printIndent(level);
            System.out.println("Processing file " + toProcess.getName());
        }
        if (this.javaHeaderLines == null) {
            this.cacheJavaHeader(firstLine, lastLine);
        }
        LinkedList<String> outputLines = new LinkedList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(toProcess));){
            ParseState state = ParseState.BEFORE_HEADER;
            int skippedHeaders = 0;
            String currentLine = null;
            do {
                if ((currentLine = reader.readLine()) == null) continue;
                switch (state) {
                    case BEFORE_HEADER: {
                        if (currentLine.trim().startsWith(firstLine.trim()) && !currentLine.trim().startsWith("/**")) {
                            state = ParseState.IN_HEADER;
                            ++skippedHeaders;
                            break;
                        }
                        if (currentLine.contains("package") || currentLine.contains("import") || currentLine.contains("class")) {
                            state = ParseState.AFTER_HEADERS;
                        }
                        outputLines.add(currentLine);
                        break;
                    }
                    case IN_HEADER: {
                        if (!currentLine.trim().endsWith(lastLine.trim())) break;
                        state = ParseState.BEFORE_HEADER;
                        break;
                    }
                    case AFTER_HEADERS: {
                        outputLines.add(currentLine);
                    }
                }
            } while (currentLine != null);
            if (skippedHeaders > 0) {
                if (this.verbose) {
                    this.printIndent(level + 1);
                    System.out.println("Skipped " + skippedHeaders + " headers and replaced " + (skippedHeaders == 1 ? "it" : "them") + " with new header.");
                }
                ++this.replaced;
            } else {
                if (this.verbose) {
                    this.printIndent(level + 1);
                    System.out.println("Added header.");
                }
                ++this.newlyAdded;
            }
        }
        try (PrintWriter writer = new PrintWriter(toProcess);){
            for (String currentOutputLine : this.javaHeaderLines) {
                writer.println(currentOutputLine);
            }
            for (String currentOutputLine : outputLines) {
                writer.println(currentOutputLine);
            }
            writer.flush();
        }
    }

    private void cacheJavaHeader(String firstLine, String lastLine) throws FileNotFoundException, IOException {
        if (this.verbose) {
            System.out.println("Caching license header for Java...");
        }
        this.javaHeaderLines = new LinkedList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(this.licence));
        this.javaHeaderLines.add(firstLine);
        String currentLine = null;
        do {
            if ((currentLine = reader.readLine()) == null) continue;
            this.javaHeaderLines.add(currentLine.isEmpty() ? JAVA_EMPTY_LINE : JAVA_PREFIX + currentLine);
        } while (currentLine != null);
        this.javaHeaderLines.add(lastLine);
        reader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheXMLHeader(int length) throws FileNotFoundException, IOException {
        if (this.verbose) {
            System.out.println("Caching license header for XML...");
        }
        this.xmlHeaderLines = new LinkedList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(this.licence));){
            String currentLine = "";
            do {
                if ((currentLine = reader.readLine()) == null) continue;
                this.xmlHeaderLines.add(this.createXMLHeaderLine(length, currentLine));
            } while (currentLine != null);
            this.xmlHeaderLines.add("");
        }
    }

    private String createXMLHeaderLine(int length, String content) {
        StringBuilder out = new StringBuilder();
        out.append(XML_START);
        out.append(content);
        int space = length - content.length();
        for (int i = 0; i < space; ++i) {
            out.append(" ");
        }
        out.append(XML_END);
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheTGHeader() throws FileNotFoundException, IOException {
        if (this.verbose) {
            System.out.println("Caching license header for TG...");
        }
        this.tgHeaderLines = new LinkedList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(this.licence));){
            String currentLine = "";
            do {
                if ((currentLine = reader.readLine()) == null) continue;
                this.tgHeaderLines.add((TG_PREFIX + currentLine).trim());
            } while (currentLine != null);
            this.tgHeaderLines.add("");
        }
    }

    private static enum ParseState {
        BEFORE_HEADER,
        IN_HEADER,
        AFTER_HEADERS;

    }
}

