/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.ist.utilities.gui;

import de.uni_koblenz.ist.utilities.gui.StringListPreferences;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public abstract class RecentFilesList
extends StringListPreferences {
    private int maxEntries;
    private JMenu menu;
    private int initialItemCount;

    public RecentFilesList(Preferences prefs, String key, int maxEntries, JMenu menu) {
        super(prefs, key);
        this.maxEntries = maxEntries;
        this.menu = menu;
        this.initialItemCount = menu.getItemCount();
        this.load(maxEntries);
        this.updateMenu();
    }

    public void rememberFile(File f) {
        if (f == null) {
            return;
        }
        try {
            String name = f.getCanonicalPath();
            int i = this.entries.indexOf(name);
            if (i == 0) {
                return;
            }
            if (i > 0) {
                this.entries.remove(i);
            }
            while (this.entries.size() >= this.maxEntries) {
                this.entries.remove(this.size() - 1);
            }
            this.entries.add(0, name);
            this.updateMenu();
            this.save();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void updateMenu() {
        while (this.menu.getItemCount() > this.initialItemCount) {
            this.menu.remove(this.menu.getItem(0));
        }
        for (int n = 0; n < this.entries.size(); ++n) {
            this.menu.add((Component)new RecentMenuItem((String)this.entries.get(n)), n);
        }
    }

    public abstract void openRecentFile(File var1);

    private class RecentMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 6317371073043983226L;
        String filename;

        public RecentMenuItem(String n) {
            super(n);
            this.filename = n;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RecentFilesList.this.openRecentFile(new File(RecentMenuItem.this.filename));
                }
            });
        }
    }
}

