/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.ist.utilities.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class MergeManifest
extends Task {
    private String metaDir = "META-INF";
    private String dest;
    private File manifestFile;

    public void setDest(String dest) {
        this.dest = dest;
    }

    public void setManifest(File manifestFile) {
        this.manifestFile = manifestFile;
    }

    public void execute() {
        try {
            File targetMetaDir = new File(this.dest + File.separator + this.metaDir);
            if (!targetMetaDir.exists()) {
                System.err.println("No " + this.metaDir + " directory. Skipping...");
                return;
            }
            File[] content = targetMetaDir.listFiles();
            LinkedList<File> manifests = new LinkedList<File>();
            for (File currentContent : content) {
                String manifestFileName;
                File currentManifestFile;
                if (!currentContent.isDirectory() || !(currentManifestFile = new File(manifestFileName = currentContent.getAbsolutePath() + File.separator + this.metaDir + File.separator + "MANIFEST.MF")).exists()) continue;
                manifests.add(currentManifestFile);
            }
            int size = manifests.size();
            System.out.println("Found " + size + " manifest files from other jars.");
            if (size > 0) {
                String currentLine;
                StringWriter manifestString = new StringWriter();
                PrintWriter targetManifest = new PrintWriter(manifestString);
                BufferedReader reader = new BufferedReader(new FileReader(this.manifestFile));
                while ((currentLine = reader.readLine()) != null) {
                    targetManifest.println(currentLine);
                }
                reader.close();
                for (File currentManifest : manifests) {
                    String currentLine2;
                    reader = new BufferedReader(new FileReader(currentManifest));
                    boolean copy = false;
                    while ((currentLine2 = reader.readLine()) != null) {
                        if (!copy && currentLine2.startsWith("Name: ")) {
                            System.out.println("Found name section in " + currentManifest.getAbsolutePath());
                            copy = true;
                            targetManifest.println();
                        }
                        if (!copy) continue;
                        targetManifest.println(currentLine2);
                    }
                    reader.close();
                }
                PrintWriter out = new PrintWriter(this.manifestFile);
                targetManifest.close();
                out.println(manifestString.toString());
                out.close();
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }
}

