/*
 * Decompiled with CFR 0.152.
 */
package org.pcollections;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.pcollections.IntTreePMap;
import org.pcollections.PVector;

public class TreePVector<E>
extends AbstractList<E>
implements PVector<E> {
    private static final TreePVector<Object> EMPTY = new TreePVector(IntTreePMap.empty());
    private final IntTreePMap<E> map;

    public static <E> TreePVector<E> empty() {
        return EMPTY;
    }

    public static <E> TreePVector<E> singleton(E e) {
        return TreePVector.empty().plus((Object)e);
    }

    public static <E> TreePVector<E> from(Collection<? extends E> collection) {
        if (collection instanceof TreePVector) {
            return (TreePVector)collection;
        }
        return TreePVector.empty().plusAll((Collection)collection);
    }

    private TreePVector(IntTreePMap<E> intTreePMap) {
        this.map = intTreePMap;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public E get(int n) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.map.get(n);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.values().iterator();
    }

    @Override
    public TreePVector<E> subList(int n, int n2) {
        int n3 = this.size();
        if (n < 0 || n2 > n3 || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n == n2) {
            return TreePVector.empty();
        }
        if (n == 0) {
            if (n2 == n3) {
                return this;
            }
            return ((TreePVector)this.minus(n3 - 1)).subList(n, n2);
        }
        return ((TreePVector)this.minus(0)).subList(n - 1, n2 - 1);
    }

    @Override
    public TreePVector<E> plus(E e) {
        return new TreePVector<E>(this.map.plus(this.size(), e));
    }

    @Override
    public TreePVector<E> plus(int n, E e) {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return new TreePVector<E>(this.map.withKeysChangedAbove(n, 1).plus(n, e));
    }

    @Override
    public TreePVector<E> minus(Object object) {
        for (Map.Entry<Integer, E> entry : this.map.entrySet()) {
            if (!entry.getValue().equals(object)) continue;
            return this.minus(entry.getKey());
        }
        return this;
    }

    @Override
    public TreePVector<E> minus(int n) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return new TreePVector(((IntTreePMap)this.map.minus(n)).withKeysChangedAbove(n, -1));
    }

    @Override
    public TreePVector<E> plusAll(Collection<? extends E> collection) {
        PVector<E> pVector = this;
        for (E e : collection) {
            pVector = pVector.plus((Object)e);
        }
        return pVector;
    }

    @Override
    public TreePVector<E> minusAll(Collection<?> collection) {
        PVector<E> pVector = this;
        for (Object obj : collection) {
            pVector = pVector.minus(obj);
        }
        return pVector;
    }

    @Override
    public TreePVector<E> plusAll(int n, Collection<? extends E> collection) {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (collection.size() == 0) {
            return this;
        }
        IntTreePMap<E> intTreePMap = this.map.withKeysChangedAbove(n, collection.size());
        for (E e : collection) {
            intTreePMap = intTreePMap.plus(n++, e);
        }
        return new TreePVector<E>(intTreePMap);
    }

    @Override
    public PVector<E> with(int n, E e) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        IntTreePMap<E> intTreePMap = this.map.plus(n, e);
        if (intTreePMap == this.map) {
            return this;
        }
        return new TreePVector<E>(intTreePMap);
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int n, E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }
}

