/*
 * Decompiled with CFR 0.152.
 */
package org.pcollections;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.pcollections.ArrayPVector;
import org.pcollections.OrderedPSet;
import org.pcollections.POrderedSet;
import org.pcollections.PVector;

public final class ArrayPSet<E>
implements POrderedSet<E>,
Serializable {
    private static final long serialVersionUID = 5643294766821496614L;
    static final int SIZELIMIT = 16;
    private PVector<E> entries;
    private int hashCode;
    private static ArrayPSet<?> empty = new ArrayPSet(ArrayPVector.empty());

    private ArrayPSet(PVector<E> pVector) {
        this.entries = pVector;
    }

    public static <T> ArrayPSet<T> empty() {
        return empty;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0 && this.size() > 0) {
            for (Object e : this.entries) {
                this.hashCode += e.hashCode();
            }
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof Set)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        Set set = (Set)object;
        if (set.size() != this.entries.size()) {
            return false;
        }
        for (E e : this) {
            if (set.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Object object) {
        return this.entries.contains(object);
    }

    @Override
    public POrderedSet<E> plus(E e) {
        if (this.contains(e)) {
            return this;
        }
        if (this.entries.size() >= 16) {
            OrderedPSet<E> orderedPSet = OrderedPSet.empty();
            return orderedPSet.plusAll(this.entries).plus(e);
        }
        return new ArrayPSet<E>(this.entries.plus(e));
    }

    POrderedSet<E> plusWithoutCheck(E e) {
        return new ArrayPSet<E>(this.entries.plus(e));
    }

    @Override
    public POrderedSet<E> plusAll(Collection<? extends E> collection) {
        if (collection.isEmpty()) {
            return this;
        }
        POrderedSet<E> pOrderedSet = this;
        for (E e : collection) {
            pOrderedSet = pOrderedSet.plus(e);
        }
        return pOrderedSet;
    }

    @Override
    public POrderedSet<E> minus(Object object) {
        return this.contains(object) ? new ArrayPSet<E>(this.entries.minus(object)) : this;
    }

    @Override
    @Deprecated
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean addAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.entries.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.entries.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.entries.toArray(TArray);
    }

    public PVector<E> toPVector() {
        return this.entries;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public POrderedSet<E> minusAll(Collection<?> collection) {
        if (collection.isEmpty()) {
            return this;
        }
        POrderedSet<E> pOrderedSet = this;
        for (Object obj : collection) {
            pOrderedSet = pOrderedSet.minus(obj);
        }
        return pOrderedSet;
    }

    @Override
    public E get(int n) {
        return this.entries.get(n);
    }

    @Override
    public int indexOf(Object object) {
        return this.entries.indexOf(object);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = "{";
        for (Object e : this.entries) {
            stringBuilder.append(string).append(e);
            string = ", ";
        }
        return stringBuilder.append("}").toString();
    }
}

