/*
 * Decompiled with CFR 0.152.
 */
package org.pcollections;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.pcollections.ArrayPSet;
import org.pcollections.ArrayPVector;
import org.pcollections.PMap;
import org.pcollections.POrderedMap;
import org.pcollections.PSet;
import org.pcollections.PVector;

public final class ArrayPMap<K, V>
implements POrderedMap<K, V>,
Iterable<AbstractMap.SimpleImmutableEntry<K, V>>,
Serializable {
    private static final long serialVersionUID = -7101801297307300984L;
    private ArrayPSet<K> keys;
    private ArrayPVector<V> values;
    private int hashCode = 0;
    private static ArrayPMap<?, ?> empty = new ArrayPMap(ArrayPSet.empty(), ArrayPVector.empty());

    private ArrayPMap(PSet<K> pSet, PVector<V> pVector) {
        this.keys = (ArrayPSet)pSet;
        this.values = (ArrayPVector)pVector;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0 && this.size() > 0) {
            for (Map.Entry<K, V> entry : this.entrySet()) {
                this.hashCode += entry.hashCode();
            }
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof Map)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        Map map = (Map)object;
        if (map.size() != this.keys.size()) {
            return false;
        }
        Iterator<V> iterator = this.values.iterator();
        for (K k : this.keys) {
            V v = iterator.next();
            if (v.equals(map.get(k))) continue;
            return false;
        }
        return true;
    }

    public static <T, U> ArrayPMap<T, U> empty() {
        return empty;
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.keys.contains(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.values.contains(object);
    }

    @Override
    public V get(Object object) {
        int n = this.keys.toPVector().indexOf(object);
        return n >= 0 ? (V)this.values.get(n) : null;
    }

    @Override
    @Deprecated
    public V put(K k, V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public V remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        return this.keys;
    }

    @Override
    public Collection<V> values() {
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        PSet<Map.Entry<K, V>> pSet = ArrayPSet.empty();
        Iterator<V> iterator = this.values.iterator();
        for (K k : this.keys) {
            pSet = pSet.plus(new AbstractMap.SimpleImmutableEntry<K, V>(k, iterator.next()));
        }
        return pSet;
    }

    @Override
    public ArrayPMap<K, V> minus(Object object) {
        int n = this.keys.toPVector().indexOf(object);
        return n < 0 ? this : new ArrayPMap<K, V>(this.keys.minus(object), this.values.minus(n));
    }

    @Override
    public ArrayPMap<K, V> minusAll(Collection<?> collection) {
        if (collection.isEmpty()) {
            return this;
        }
        PMap<K, V> pMap = this;
        for (Object obj : collection) {
            pMap = pMap.minus(obj);
        }
        return pMap;
    }

    @Override
    public ArrayPMap<K, V> plus(K k, V v) {
        int n = this.keys.toPVector().indexOf(k);
        if (n >= 0) {
            return new ArrayPMap<K, V>(this.keys, this.values.with(n, (Object)v));
        }
        return new ArrayPMap<K, V>(this.keys.plusWithoutCheck(k), this.values.plus((Object)v));
    }

    @Override
    public ArrayPMap<K, V> plusAll(Map<? extends K, ? extends V> map) {
        if (map.isEmpty()) {
            return this;
        }
        PMap<K, V> pMap = this;
        if (map instanceof ArrayPMap) {
            ArrayPMap arrayPMap = (ArrayPMap)map;
            Iterator<V> iterator = arrayPMap.values.iterator();
            for (K k : arrayPMap.keys) {
                pMap = pMap.plus((Object)k, (Object)iterator.next());
            }
        } else {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                pMap = pMap.plus((Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        return pMap;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "<>";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<V> iterator = this.values.iterator();
        String string = "<";
        for (K k : this.keys) {
            stringBuilder.append(string).append(k).append("=").append(iterator.next());
            string = ", ";
        }
        return stringBuilder.append(">").toString();
    }

    @Override
    public Iterator<AbstractMap.SimpleImmutableEntry<K, V>> iterator() {
        return new ArrayPMapIterator();
    }

    @Override
    public K keyAt(int n) {
        return this.keys.get(n);
    }

    @Override
    public V valueAt(int n) {
        return this.values.get(n);
    }

    @Override
    public Map.Entry<K, V> entryAt(int n) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(this.keyAt(n), this.valueAt(n));
    }

    private final class ArrayPMapIterator
    implements Iterator<AbstractMap.SimpleImmutableEntry<K, V>> {
        Iterator<K> ki;
        Iterator<V> vi;

        private ArrayPMapIterator() {
            this.ki = ArrayPMap.this.keys.iterator();
            this.vi = ArrayPMap.this.values.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.ki.hasNext();
        }

        @Override
        public AbstractMap.SimpleImmutableEntry<K, V> next() {
            return new AbstractMap.SimpleImmutableEntry(this.ki.next(), this.vi.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

