/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.xml2tg.schema.impl.std;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.exception.NoSuchAttributeException;
import de.uni_koblenz.jgralab.impl.IncidenceIterable;
import de.uni_koblenz.jgralab.impl.std.VertexImpl;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.Element;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.HasContent;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.HasText;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.Node;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.Text;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.XMLGraph;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TextImpl
extends VertexImpl
implements Node,
Text,
Vertex {
    protected String _content;

    public TextImpl(int n, Graph graph) {
        super(n, graph);
    }

    @Override
    public final VertexClass getAttributedElementClass() {
        return Text.VC;
    }

    @Override
    public final Class<? extends Vertex> getSchemaClass() {
        return Text.class;
    }

    @Override
    public <T> T getAttribute(String string) {
        if (string.equals("content")) {
            return (T)this.get_content();
        }
        throw new NoSuchAttributeException("Text doesn't contain an attribute " + string);
    }

    @Override
    public <T> void setAttribute(String string, T t) {
        if (string.equals("content")) {
            this.set_content((String)t);
            return;
        }
        throw new NoSuchAttributeException("Text doesn't contain an attribute " + string);
    }

    @Override
    public String get_content() {
        return this._content;
    }

    @Override
    public void set_content(String string) {
        this.ecaAttributeChanging("content", this._content, string);
        String string2 = this._content;
        this._content = string;
        this.graphModified();
        this.ecaAttributeChanged("content", string2, string);
    }

    @Override
    public void readAttributeValues(GraphIO graphIO) throws GraphIOException {
        this._content = graphIO.matchUtfString();
        this.set_content(this._content);
    }

    @Override
    public void readAttributeValueFromString(String string, String string2) throws GraphIOException {
        if (string.equals("content")) {
            GraphIO graphIO = GraphIO.createStringReader(string2, this.getSchema());
            this._content = graphIO.matchUtfString();
            this.set_content(this._content);
            return;
        }
        throw new NoSuchAttributeException("Text doesn't contain an attribute " + string);
    }

    @Override
    public void writeAttributeValues(GraphIO graphIO) throws GraphIOException, IOException {
        graphIO.space();
        graphIO.writeUtfString(this._content);
    }

    @Override
    public String writeAttributeValueToString(String string) throws IOException, GraphIOException {
        if (string.equals("content")) {
            GraphIO graphIO = GraphIO.createStringWriter(this.getSchema());
            graphIO.writeUtfString(this._content);
            return graphIO.getStringWriterResult();
        }
        throw new NoSuchAttributeException("Text doesn't contain an attribute " + string);
    }

    @Override
    public Node getNextNode() {
        return (Node)this.getNextVertex(Node.VC);
    }

    @Override
    public Text getNextText() {
        return (Text)this.getNextVertex(Text.VC);
    }

    @Override
    public HasText getFirstHasTextIncidence() {
        return (HasText)this.getFirstIncidence(HasText.EC);
    }

    @Override
    public HasText getFirstHasTextIncidence(EdgeDirection edgeDirection) {
        return (HasText)this.getFirstIncidence(HasText.EC, edgeDirection);
    }

    @Override
    public HasContent getFirstHasContentIncidence() {
        return (HasContent)this.getFirstIncidence(HasContent.EC);
    }

    @Override
    public HasContent getFirstHasContentIncidence(EdgeDirection edgeDirection) {
        return (HasContent)this.getFirstIncidence(HasContent.EC, edgeDirection);
    }

    @Override
    public HasContent add_parent(Element element) {
        return (HasContent)((XMLGraph)this.getGraph()).createEdge(HasContent.EC, element, this);
    }

    @Override
    public List<? extends Element> remove_parent() {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        HasContent hasContent = (HasContent)this.getFirstIncidence(HasContent.EC, EdgeDirection.IN);
        while (hasContent != null) {
            HasContent hasContent2 = (HasContent)hasContent.getNextIncidence(HasContent.EC, EdgeDirection.IN);
            arrayList.add((Element)hasContent.getThat());
            hasContent.delete();
            hasContent = hasContent2;
        }
        return arrayList;
    }

    @Override
    public boolean remove_parent(Element element) {
        boolean bl = false;
        HasContent hasContent = (HasContent)this.getFirstIncidence(HasContent.EC, EdgeDirection.IN);
        while (hasContent != null) {
            HasContent hasContent2 = (HasContent)hasContent.getNextIncidence(HasContent.EC, EdgeDirection.IN);
            if (hasContent.getThat().equals(element)) {
                hasContent.delete();
                bl = true;
            }
            hasContent = hasContent2;
        }
        return bl;
    }

    @Override
    public Element get_parent() {
        HasContent hasContent = (HasContent)this.getFirstIncidence(HasContent.EC, EdgeDirection.IN);
        if (hasContent != null) {
            return (Element)hasContent.getThat();
        }
        return null;
    }

    @Override
    public Iterable<HasText> getHasTextIncidences() {
        return new IncidenceIterable<HasText>((Vertex)this, HasText.EC);
    }

    @Override
    public Iterable<HasText> getHasTextIncidences(EdgeDirection edgeDirection) {
        return new IncidenceIterable<HasText>(this, HasText.EC, edgeDirection);
    }

    @Override
    public Iterable<HasContent> getHasContentIncidences() {
        return new IncidenceIterable<HasContent>((Vertex)this, HasContent.EC);
    }

    @Override
    public Iterable<HasContent> getHasContentIncidences(EdgeDirection edgeDirection) {
        return new IncidenceIterable<HasContent>(this, HasContent.EC, edgeDirection);
    }
}

