/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tgraphbrowser;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.ProgressFunction;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlEnvironmentAdapter;
import de.uni_koblenz.jgralab.greql.exception.GreqlException;
import de.uni_koblenz.jgralab.greql.types.Types;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.utilities.tgraphbrowser.RequestThread;
import de.uni_koblenz.jgralab.utilities.tgraphbrowser.SchemaVisualizer;
import de.uni_koblenz.jgralab.utilities.tgraphbrowser.TGraphBrowserServer;
import de.uni_koblenz.jgralab.utilities.tgraphbrowser.TabularVisualizer;
import de.uni_koblenz.jgralab.utilities.tgraphbrowser.TwoDVisualizer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pcollections.PCollection;
import org.pcollections.PSet;

public class StateRepository {
    private static final int NUMBER_OF_ELEMENTS_IN_BREADCRUMBBAR = 10;
    private static final int NUMBER_OF_ELEMENTS_IN_A_SET_IN_BREADCRUMBBAR = 3;
    private static ArrayList<State> sessions = new ArrayList();
    private static int nextSessionId = 0;
    public static String dot;
    public static HashMap<String, Method> definedMethods;
    public static ConcurrentHashMap<String, GraphWrapper> usedGraphs;
    private final File workspace;
    private final RequestThread currentThread;

    public StateRepository(File file, RequestThread requestThread) {
        this.workspace = file;
        this.currentThread = requestThread;
    }

    public StringBuilder computeGReQLQuery(Integer n, Boolean bl, Boolean bl2, Integer n2, Integer n3, String string) {
        StringBuilder stringBuilder = new StringBuilder("function(){\n");
        State state = StateRepository.getSession(n, stringBuilder, "computeGReQLQuery", bl.toString(), bl2.toString(), n2.toString(), n3.toString(), string);
        if (state != null) {
            try {
                Object object = StateRepository.evaluateGReQL(string, state.getGraph(), null);
                boolean bl3 = false;
                PSet<Object> pSet = JGraLab.set();
                if (object instanceof PCollection) {
                    pSet = pSet.plusAll((Collection)object);
                    boolean bl4 = true;
                    for (Object e : pSet) {
                        if (e instanceof GraphElement) {
                            pSet = pSet.plus((GraphElement)e);
                            continue;
                        }
                        bl4 = false;
                        break;
                    }
                    if (bl4) {
                        this.displayJValueSet(n, bl, bl2, n2, n3, state, pSet, stringBuilder);
                        bl3 = true;
                    } else if (pSet.isEmpty()) {
                        stringBuilder.append("var h3error = document.getElementById(\"h3GReQLError\");\n");
                        stringBuilder.append("h3error.innerHTML = \"The query has an empty set as result.\";\n");
                    } else {
                        stringBuilder.append("var h3error = document.getElementById(\"h3GReQLError\");\n");
                        stringBuilder.append("h3error.innerHTML = \"Only VERTEX, EDGE or COLLECTION of vertices or edges is supported.\";\n");
                    }
                } else if (object instanceof GraphElement) {
                    pSet = pSet.plus((GraphElement)object);
                    this.displayJValueSet(n, bl, bl2, n2, n3, state, pSet, stringBuilder);
                    bl3 = true;
                } else {
                    stringBuilder.append("var h3error = document.getElementById(\"h3GReQLError\");\n");
                    stringBuilder.append("h3error.innerHTML = \"The result is of type ").append(Types.getGreqlTypeName(object)).append(".<br />Only Vertex, Edge or a Collection of vertices or edges are supported.\";\n");
                }
                if (bl3) {
                    stringBuilder.append("cancelGReQL();");
                }
            }
            catch (GreqlException greqlException) {
                stringBuilder.append("var h3error = document.getElementById(\"h3GReQLError\");\n");
                String string2 = greqlException.getCause() != null ? greqlException.getMessage() + "\n" + greqlException.getCause().getMessage() : greqlException.getMessage();
                string2 = string2.replaceAll("\"", "'");
                string2 = string2.replaceAll("<", "&lt;");
                string2 = string2.replaceAll(">", "&gt;");
                string2 = string2.replaceAll("\n", "<br />");
                string2 = string2.replaceAll("\r", "");
                stringBuilder.append("h3error.innerHTML = \"").append("<br />").append(string2).append("\";\n");
            }
            state.lastAccess = System.currentTimeMillis();
            stringBuilder.append("timestamp = ").append(state.lastAccess).append(";\n");
        }
        return stringBuilder.append("}");
    }

    static synchronized Object evaluateGReQL(String string, Graph graph, HashMap<String, Object> hashMap) {
        GreqlEnvironmentAdapter greqlEnvironmentAdapter = new GreqlEnvironmentAdapter(hashMap);
        return GreqlQuery.createQuery(string).evaluate(graph, greqlEnvironmentAdapter);
    }

    public StringBuilder showTypedElements(Integer n, Boolean bl, Boolean bl2, Integer n2, Integer n3, String string) {
        StringBuilder stringBuilder = new StringBuilder("function(){\n");
        State state = StateRepository.getSession(n, stringBuilder, "showTypedElements", bl.toString(), bl2.toString(), n2.toString(), n3.toString(), string);
        if (state != null) {
            PSet<GraphElement<?, ?>> pSet = JGraLab.set();
            StringBuilder stringBuilder2 = new StringBuilder();
            for (String string2 : string.split(",")) {
                GraphElement<VertexClass, Vertex> graphElement;
                if (string2.startsWith("v")) {
                    graphElement = state.getGraph().getVertex(Integer.parseInt(string2.substring(1)));
                    if (graphElement != null) {
                        pSet = pSet.plus(graphElement);
                        continue;
                    }
                    stringBuilder2.append((stringBuilder2.length() == 0 ? "" : ", ") + string2);
                    continue;
                }
                graphElement = state.getGraph().getEdge(Integer.parseInt(string2.substring(1)));
                if (graphElement != null) {
                    pSet = pSet.plus(graphElement);
                    continue;
                }
                stringBuilder2.append((stringBuilder2.length() == 0 ? "" : ", ") + string2);
            }
            if (!pSet.isEmpty()) {
                if (pSet.size() > 1) {
                    this.displayJValueSet(n, bl, bl2, n2, n3, state, pSet, stringBuilder);
                } else {
                    GraphElement graphElement = (GraphElement)pSet.iterator().next();
                    this.addToBreadcrumbBar(stringBuilder, state, graphElement, true);
                    if (bl.booleanValue()) {
                        stringBuilder.append("if((areVerticesShown()&&").append(graphElement instanceof Edge).append(")||(!areVerticesShown()&&").append(graphElement instanceof Vertex).append(")){\n");
                        stringBuilder.append("switchTable();\n");
                        stringBuilder.append("}\n");
                        new TabularVisualizer().visualizeElements(stringBuilder, state, n2, bl2, (graphElement instanceof Vertex ? "v" : "e") + graphElement.getId(), true, true);
                    } else {
                        new TwoDVisualizer().visualizeElements(stringBuilder, state, n, this.workspace.toString(), graphElement, bl2, n3, this.currentThread);
                    }
                }
            }
            if (stringBuilder2.length() > 0) {
                stringBuilder.append("alert(\"");
                stringBuilder.append("Following elements do not exist:\\n").append((CharSequence)stringBuilder2);
                stringBuilder.append("\");\n");
            }
            state.lastAccess = System.currentTimeMillis();
            stringBuilder.append("timestamp = ").append(state.lastAccess).append(";\n");
        }
        return stringBuilder.append("}");
    }

    private void displayJValueSet(Integer n, Boolean bl, Boolean bl2, Integer n2, Integer n3, State state, PSet<GraphElement<?, ?>> pSet, StringBuilder stringBuilder) {
        state.currentExplicitlyDefinedSet = pSet;
        this.addToBreadcrumbBar(stringBuilder, state, pSet, true);
        if (bl.booleanValue()) {
            TabularVisualizer tabularVisualizer = new TabularVisualizer();
            tabularVisualizer.calculateVertexListAndEdgeList(state, pSet);
            tabularVisualizer.visualizeElements(stringBuilder, state, n2, bl2, "v" + (state.verticesOfTableView != null ? Integer.valueOf(state.verticesOfTableView[0].getId()) : ""), false, false);
            tabularVisualizer.visualizeElements(stringBuilder, state, n2, bl2, "e" + (state.edgesOfTableView != null && state.edgesOfTableView.length > 0 ? Integer.valueOf(state.edgesOfTableView[0].getId()) : ""), false, false);
            if (state.verticesOfTableView != null) {
                this.showCorrectTable(stringBuilder, state.verticesOfTableView[0]);
            } else if (state.edgesOfTableView != null) {
                this.showCorrectTable(stringBuilder, state.edgesOfTableView[0]);
            }
        } else {
            new TwoDVisualizer().visualizeElements(stringBuilder, state, n, this.workspace.toString(), pSet, bl2, n3, this.currentThread);
        }
    }

    public StringBuilder refresh2D(Integer n, Integer n2, Boolean bl, Integer n3) {
        StringBuilder stringBuilder = new StringBuilder("function(){\n");
        State state = StateRepository.getSession(n, stringBuilder, "refresh2D", n2.toString(), bl.toString(), n3.toString());
        if (state != null) {
            TwoDVisualizer twoDVisualizer = new TwoDVisualizer();
            twoDVisualizer.visualizeElements(stringBuilder, state, n, this.workspace.toString(), state.navigationHistory.get(n3), bl, n2, this.currentThread);
            state.lastAccess = System.currentTimeMillis();
            stringBuilder.append("timestamp = ").append(state.lastAccess).append(";\n");
        }
        return stringBuilder.append("}");
    }

    public StringBuilder showElementsAs2D(Integer n, Integer n2, Boolean bl, String string) {
        StringBuilder stringBuilder = new StringBuilder("function(){\n");
        State state = StateRepository.getSession(n, stringBuilder, "showElementsAs2D", n2.toString(), bl.toString(), string);
        if (state != null) {
            int n3 = Integer.parseInt(string.substring(1));
            GraphElement<VertexClass, Vertex> graphElement = null;
            graphElement = string.charAt(0) == 'v' ? state.getGraph().getVertex(n3) : state.getGraph().getEdge(n3);
            new TwoDVisualizer().visualizeElements(stringBuilder, state, n, this.workspace.toString(), graphElement, bl, n2, this.currentThread);
            this.addToBreadcrumbBar(stringBuilder, state, graphElement, true);
            state.lastAccess = System.currentTimeMillis();
            stringBuilder.append("timestamp = ").append(state.lastAccess).append(";\n");
        }
        return stringBuilder.append("}");
    }

    public StringBuilder changeView(Integer n, Boolean bl, Boolean bl2, Integer n2, Integer n3, Integer n4) {
        StringBuilder stringBuilder = new StringBuilder("function(){\n");
        State state = StateRepository.getSession(n, stringBuilder, "changeView", bl.toString(), bl2.toString(), n2.toString(), n3.toString(), n4.toString());
        if (state != null) {
            if (bl.booleanValue()) {
                stringBuilder.append("document.getElementById(\"h3HowManyElements\").style.display = \"none\";\n");
                TabularVisualizer tabularVisualizer = new TabularVisualizer();
                if (state.navigationHistory.get(n4) instanceof Vertex) {
                    tabularVisualizer.calculateVertexListAndEdgeList(state);
                    Vertex vertex = (Vertex)state.navigationHistory.get(n4);
                    this.showCorrectTable(stringBuilder, vertex);
                    tabularVisualizer.visualizeElements(stringBuilder, state, n2, bl2, "v" + vertex.getId(), true, true);
                    Edge edge = null;
                    for (int i = state.navigationHistory.size() - 1; i >= 0; --i) {
                        if (!(state.navigationHistory.get(i) instanceof Edge)) continue;
                        edge = (Edge)state.navigationHistory.get(i);
                        break;
                    }
                    if (edge == null) {
                        edge = state.getGraph().getFirstEdge();
                    }
                    tabularVisualizer.visualizeElements(stringBuilder, state, 20, false, "e" + (edge != null ? Integer.valueOf(edge.getId()) : ""), false, true);
                    stringBuilder.append("document.getElementById(\"h3HowManyVertices\").style.display = \"block\";\n");
                    stringBuilder.append("document.getElementById(\"h3HowManyEdges\").style.display = \"none\";\n");
                } else if (state.navigationHistory.get(n4) instanceof Edge) {
                    tabularVisualizer.calculateVertexListAndEdgeList(state);
                    Edge edge = (Edge)state.navigationHistory.get(n4);
                    this.showCorrectTable(stringBuilder, edge);
                    tabularVisualizer.visualizeElements(stringBuilder, state, n2, bl2, "e" + edge.getId(), true, true);
                    Vertex vertex = null;
                    for (int i = state.navigationHistory.size() - 1; i >= 0; --i) {
                        if (!(state.navigationHistory.get(i) instanceof Vertex)) continue;
                        vertex = (Vertex)state.navigationHistory.get(i);
                        break;
                    }
                    tabularVisualizer.visualizeElements(stringBuilder, state, 20, false, "v" + (vertex != null ? Integer.valueOf(vertex.getId()) : ""), false, true);
                    stringBuilder.append("document.getElementById(\"h3HowManyEdges\").style.display = \"block\";\n");
                    stringBuilder.append("document.getElementById(\"h3HowManyVertices\").style.display = \"none\";\n");
                } else {
                    PSet pSet;
                    state.currentExplicitlyDefinedSet = pSet = (PSet)state.navigationHistory.get(n4);
                    tabularVisualizer.calculateVertexListAndEdgeList(state, pSet);
                    tabularVisualizer.visualizeElements(stringBuilder, state, n2, bl2, "v" + (state.verticesOfTableView != null ? Integer.valueOf(state.verticesOfTableView[0].getId()) : ""), false, false);
                    tabularVisualizer.visualizeElements(stringBuilder, state, n2, bl2, "e" + (state.edgesOfTableView != null && state.edgesOfTableView.length > 0 ? Integer.valueOf(state.edgesOfTableView[0].getId()) : ""), false, false);
                    if (state.verticesOfTableView != null) {
                        this.showCorrectTable(stringBuilder, state.verticesOfTableView[0]);
                    } else if (state.edgesOfTableView != null) {
                        this.showCorrectTable(stringBuilder, state.edgesOfTableView[0]);
                    }
                }
            } else {
                stringBuilder.append("document.getElementById(\"h3HowManyElements\").style.display = \"block\";\n");
                stringBuilder.append("document.getElementById(\"h3HowManyVertices\").style.display = \"none\";\n");
                stringBuilder.append("document.getElementById(\"h3HowManyEdges\").style.display = \"none\";\n");
                TwoDVisualizer twoDVisualizer = new TwoDVisualizer();
                twoDVisualizer.visualizeElements(stringBuilder, state, n, this.workspace.toString(), state.navigationHistory.get(n4), bl2, n3, this.currentThread);
            }
            state.lastAccess = System.currentTimeMillis();
            stringBuilder.append("timestamp = ").append(state.lastAccess).append(";\n");
        }
        stringBuilder.append("resize();\n");
        stringBuilder.append("resize();\n");
        return stringBuilder.append("}");
    }

    private void showCorrectTable(StringBuilder stringBuilder, GraphElement<?, ?> graphElement) {
        String string = "";
        if (graphElement instanceof Vertex) {
            string = "Vertices";
        } else if (graphElement instanceof Edge) {
            string = "Edges";
        }
        stringBuilder.append("var aShow = document.getElementById(\"aShow").append(string).append("\");\n");
        stringBuilder.append("if(aShow.hasAttribute){\n");
        stringBuilder.append("if(aShow.getAttribute(\"class\")!=\"geklickt\"){\n");
        stringBuilder.append("switchTable();\n}\n");
        stringBuilder.append("}else{\n");
        stringBuilder.append("if(aShow.getAttribute(\"className\")!=\"geklickt\"){\n");
        stringBuilder.append("switchTable();\n}\n");
        stringBuilder.append("}\n");
    }

    /*
     * WARNING - void declaration
     */
    public StringBuilder refreshViewAfterTypeSubmit(Integer n, Boolean bl, String string, String string2, Boolean bl2, Integer n2, Integer n3, String string3, String string4, Integer n4) {
        StringBuilder stringBuilder = new StringBuilder("function(){\n");
        State state = StateRepository.getSession(n, stringBuilder, "refreshViewAfterTypeSubmit", bl.toString(), string, string2, bl2.toString(), n2.toString(), n3.toString(), string3, string4, n4.toString());
        if (state != null) {
            for (VertexClass object2 : state.selectedVertexClasses.keySet()) {
                state.selectedVertexClasses.put(object2, !string.contains("#" + object2.getQualifiedName() + "#"));
            }
            for (EdgeClass edgeClass : state.selectedEdgeClasses.keySet()) {
                state.selectedEdgeClasses.put(edgeClass, !string2.contains("#" + edgeClass.getQualifiedName() + "#"));
            }
            Object object3 = string3;
            String string5 = string4;
            if (state.currentExplicitlyDefinedSet != null) {
                new TabularVisualizer().calculateVertexListAndEdgeList(state, state.currentExplicitlyDefinedSet);
                object3 = "v" + (state.verticesOfTableView != null ? Integer.valueOf(state.verticesOfTableView[0].getId()) : "");
                String string6 = "e" + (state.edgesOfTableView != null ? Integer.valueOf(state.edgesOfTableView[0].getId()) : "");
            } else {
                new TabularVisualizer().calculateVertexListAndEdgeList(state);
            }
            if (!state.navigationHistory.isEmpty()) {
                if (bl.booleanValue()) {
                    void var14_19;
                    new TabularVisualizer().visualizeElements(stringBuilder, state, n2, bl2, (String)object3, false, state.currentExplicitlyDefinedSet == null);
                    new TabularVisualizer().visualizeElements(stringBuilder, state, n2, bl2, (String)var14_19, false, state.currentExplicitlyDefinedSet == null);
                } else {
                    new TwoDVisualizer().visualizeElements(stringBuilder, state, n, this.workspace.toString(), state.navigationHistory.get(n4), bl2, n3, this.currentThread);
                }
            }
            state.lastAccess = System.currentTimeMillis();
            stringBuilder.append("timestamp = ").append(state.lastAccess).append(";\n");
        }
        return stringBuilder.append("}");
    }

    public StringBuilder goBackToElement(Integer n, Integer n2, Boolean bl, Boolean bl2, Integer n3, Integer n4) {
        StringBuilder stringBuilder = new StringBuilder("function(){\n");
        State state = StateRepository.getSession(n, stringBuilder, "goBackToElement", n2.toString(), bl.toString(), bl2.toString(), n3.toString(), n4.toString());
        if (state != null) {
            Object object = state.navigationHistory.get(n2);
            boolean bl3 = false;
            if (state.currentExplicitlyDefinedSet != null) {
                new TabularVisualizer().calculateVertexListAndEdgeList(state);
                state.currentExplicitlyDefinedSet = null;
                bl3 = true;
            }
            if (object instanceof PSet) {
                state.currentExplicitlyDefinedSet = (PSet)object;
                new TabularVisualizer().calculateVertexListAndEdgeList(state, state.currentExplicitlyDefinedSet);
                if (bl.booleanValue()) {
                    object = state.currentExplicitlyDefinedSet.iterator().next();
                }
                bl3 = true;
            }
            state.insertPosition = n2 + 1;
            if (bl.booleanValue()) {
                boolean bl4 = object instanceof Vertex;
                stringBuilder.append("if(").append(bl4 ? "!" : "").append("areVerticesShown()){\n");
                stringBuilder.append("switchTable();\n");
                stringBuilder.append("}\n");
                new TabularVisualizer().visualizeElements(stringBuilder, state, n3, bl2, bl4 ? "v" + ((Vertex)object).getId() : "e" + ((Edge)object).getId(), true, state.currentExplicitlyDefinedSet == null);
                if (bl3) {
                    new TabularVisualizer().visualizeElements(stringBuilder, state, n3, bl2, !bl4 ? "v" + state.getGraph().getFirstVertex().getId() : "e" + (state.getGraph().getFirstEdge() != null ? Integer.valueOf(state.getGraph().getFirstEdge().getId()) : ""), true, state.currentExplicitlyDefinedSet == null);
                }
                if (!(object instanceof GraphElement)) {
                    stringBuilder.append("changeBackgroundColor(\"").append(bl4 ? "v" + ((Vertex)object).getId() : "e" + ((Edge)object).getId()).append("\");");
                }
            } else {
                new TwoDVisualizer().visualizeElements(stringBuilder, state, n, this.workspace.toString(), object, bl2, n4, this.currentThread);
            }
            this.addToBreadcrumbBar(stringBuilder, state, null, false);
            state.lastAccess = System.currentTimeMillis();
            stringBuilder.append("timestamp = ").append(state.lastAccess).append(";\n");
        }
        return stringBuilder.append("}");
    }

    public StringBuilder showIncidencesPage(Integer n, Integer n2, String string) {
        StringBuilder stringBuilder = new StringBuilder("function (){\n");
        State state = StateRepository.getSession(n, stringBuilder, "showIncidencesPage", n2.toString(), string);
        if (state != null) {
            new TabularVisualizer().createIncidentEdges(stringBuilder, state.getGraph().getVertex(Integer.parseInt(string.split("v")[1])), state.selectedEdgeClasses, state.selectedVertexClasses, n2, string);
            state.lastAccess = System.currentTimeMillis();
            stringBuilder.append("timestamp = ").append(state.lastAccess).append(";\n");
        }
        return stringBuilder.append("}");
    }

    public StringBuilder showPageInTable(Integer n, Integer n2, Boolean bl, Integer n3, Boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder("function (){\n");
        State state = StateRepository.getSession(n, stringBuilder, "showPageInTable", n2.toString(), bl.toString(), n3.toString(), bl2.toString());
        if (state != null) {
            String string = (bl2 != false ? "v" : "e") + (bl2 != false ? state.verticesOfTableView : state.edgesOfTableView)[n2 == -1 ? 0 : (n3 - 1) * n2].getId();
            new TabularVisualizer().visualizeElements(stringBuilder, state, n2, bl, string, false, state.currentExplicitlyDefinedSet == null);
            stringBuilder.append("timestamp = ").append(state.lastAccess).append(";\n");
        }
        return stringBuilder.append("}");
    }

    public StringBuilder showElementsAsTable(Integer n, Integer n2, Boolean bl, String string) {
        StringBuilder stringBuilder = new StringBuilder("function(){\n");
        State state = StateRepository.getSession(n, stringBuilder, "showElementsAsTable", n2.toString(), bl.toString(), string);
        if (state != null) {
            boolean bl2;
            boolean bl3 = false;
            boolean bl4 = bl2 = state.currentExplicitlyDefinedSet == null;
            if (!bl2) {
                new TabularVisualizer().calculateVertexListAndEdgeList(state);
                state.currentExplicitlyDefinedSet = null;
                bl3 = true;
            }
            new TabularVisualizer().visualizeElements(stringBuilder, state, n2, bl, string, true, bl2);
            if (bl3) {
                new TabularVisualizer().visualizeElements(stringBuilder, state, n2, bl, string.charAt(0) == 'e' ? "v" + state.getGraph().getFirstVertex().getId() : "e" + (state.getGraph().getFirstEdge() != null ? Integer.valueOf(state.getGraph().getFirstEdge().getId()) : ""), true, bl2);
            }
            if (string.startsWith("v")) {
                Vertex vertex = state.getGraph().getVertex(Integer.parseInt(string.substring(1)));
                this.addToBreadcrumbBar(stringBuilder, state, vertex, true);
            } else {
                Edge edge = state.getGraph().getEdge(Integer.parseInt(string.substring(1)));
                this.addToBreadcrumbBar(stringBuilder, state, edge, true);
            }
            stringBuilder.append("changeBackgroundColor(\"").append(string).append("\");");
            stringBuilder.append("timestamp = ").append(state.lastAccess).append(";\n");
        }
        return stringBuilder.append("}");
    }

    public StringBuilder refreshTable(Integer n, Integer n2, Boolean bl, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder("function(){\n");
        State state = StateRepository.getSession(n, stringBuilder, "refreshTable", n2.toString(), bl.toString(), string, string2);
        if (state != null) {
            new TabularVisualizer().visualizeElements(stringBuilder, state, n2, bl, string, false, state.currentExplicitlyDefinedSet == null);
            new TabularVisualizer().visualizeElements(stringBuilder, state, n2, bl, string2, false, state.currentExplicitlyDefinedSet == null);
        }
        return stringBuilder.append("}");
    }

    public StringBuilder initializeGraphView(Integer n) {
        StringBuilder stringBuilder = new StringBuilder("function(){\n");
        State state = StateRepository.getSession(n, stringBuilder, "initializeGraphView", new String[0]);
        if (state != null) {
            stringBuilder.append("document.getElementById(\"divLoadBar\").style.display = \"none\";\n");
            stringBuilder.append("document.getElementById(\"checkShowAttributes\").style.visibility = \"visible\";\n");
            stringBuilder.append("document.getElementById(\"pAttributes\").style.visibility = \"visible\";\n");
            stringBuilder.append("document.getElementById(\"divTextVis\").style.visibility = \"visible\";\n");
            stringBuilder.append("document.getElementById(\"aChangeView\").style.visibility = \"visible\";\n");
            stringBuilder.append("document.getElementById(\"rightOption\").style.visibility = \"visible\";\n");
            if (dot == null || dot.isEmpty() || state.getGraph().getVCount() == 0) {
                stringBuilder.append("document.getElementById(\"aChangeView\").style.visibility = \"hidden\";\n");
            }
            stringBuilder.append("document.getElementById(\"divRight\").style.display = \"block\";\n");
            stringBuilder.append("document.getElementById(\"divFilterWindow\").style.display = \"block\";\n");
            new SchemaVisualizer().createSchemaRepresentation(stringBuilder, state);
            Vertex vertex = state.getGraph().getFirstVertex();
            if (vertex != null) {
                this.addToBreadcrumbBar(stringBuilder, state, vertex, true);
            }
            TabularVisualizer tabularVisualizer = new TabularVisualizer();
            tabularVisualizer.calculateVertexListAndEdgeList(state);
            tabularVisualizer.visualizeElements(stringBuilder, state, 20, false, "v" + (vertex != null ? Integer.valueOf(vertex.getId()) : ""), false, state.currentExplicitlyDefinedSet == null);
            stringBuilder.append("changeBackgroundColor(\"v").append(vertex != null ? Integer.valueOf(vertex.getId()) : "").append("\");\n");
            tabularVisualizer.visualizeElements(stringBuilder, state, 20, false, "e" + (state.getGraph().getFirstEdge() != null ? Integer.valueOf(state.getGraph().getFirstEdge().getId()) : ""), false, state.currentExplicitlyDefinedSet == null);
            stringBuilder.append("timestamp = ").append(state.lastAccess).append(";\n");
            stringBuilder.append("resize();\n");
            stringBuilder.append("resize();\n");
        }
        return stringBuilder.append("}");
    }

    public StringBuilder refreshBreadcrumbBar(Integer n, String string, Boolean bl, Boolean bl2) {
        State state = sessions.get(n);
        GraphElement<VertexClass, Vertex> graphElement = null;
        StringBuilder stringBuilder = new StringBuilder("function() {\n");
        if (string.startsWith("v")) {
            graphElement = state.getGraph().getVertex(Integer.parseInt(string.substring(1)));
            this.addToBreadcrumbBar(stringBuilder, state, graphElement, bl2);
        } else if (string.startsWith("e")) {
            graphElement = state.getGraph().getEdge(Integer.parseInt(string.substring(1)));
            this.addToBreadcrumbBar(stringBuilder, state, graphElement, bl2);
        } else {
            int n2 = Integer.parseInt(string);
            Object object = state.navigationHistory.get(n2);
            state.insertPosition = n2 + 1;
            boolean bl3 = object instanceof Vertex;
            if (bl.booleanValue()) {
                stringBuilder.append("if(").append(bl3 ? "!" : "").append("areVerticesShown()){\n");
                stringBuilder.append("switchTable();\n");
                stringBuilder.append("}\n");
            }
            this.addToBreadcrumbBar(stringBuilder, state, null, bl2);
            stringBuilder.append("current").append(bl3 ? "Vertex" : "Edge").append(" = \"").append(bl3 ? "v" + ((Vertex)object).getId() : "e" + Math.abs(((Edge)object).getId())).append("\";\n");
        }
        stringBuilder.append("timestamp = ").append(state.lastAccess).append(";\n");
        return stringBuilder.append("}");
    }

    private StringBuilder addToBreadcrumbBar(StringBuilder stringBuilder, State state, Object object, Boolean bl) {
        if (this.isNewElement(state, object)) {
            int n;
            int n2 = 0;
            stringBuilder.append("var divBreadcrumbBar = document.getElementById(\"divBreadcrumbBar\");\n");
            stringBuilder.append("divBreadcrumbBar.innerHTML = \"\";\n");
            stringBuilder.append("var breadcrumbBar = document.createElement(\"p\");\n");
            stringBuilder.append("breadcrumbBar.id = \"pBreadcrumbContent0\";\n");
            stringBuilder.append("breadcrumbBar.style.display = \"none\";\n");
            stringBuilder.append("divBreadcrumbBar.appendChild(breadcrumbBar);\n");
            stringBuilder.append("var newEntry;\n");
            if (object != null) {
                state.navigationHistory.add(state.insertPosition++, object);
                if (state.insertPosition < state.navigationHistory.size() && bl.booleanValue()) {
                    for (n = state.navigationHistory.size() - 1; n >= state.insertPosition; --n) {
                        state.navigationHistory.remove(n);
                    }
                }
            }
            if (state.navigationHistory.size() <= 10) {
                for (n = 0; n < state.navigationHistory.size(); ++n) {
                    if (n > 0) {
                        stringBuilder.append("var raquo = document.createTextNode(String.fromCharCode(187));\n");
                        stringBuilder.append("breadcrumbBar.appendChild(raquo);\n");
                    }
                    this.createBreadcrumbEntry(stringBuilder, state, n, n < state.insertPosition ? "white" : "gray");
                }
            } else {
                n = state.navigationHistory.size() % 10;
                int n3 = 0;
                for (int i = 0; i < state.navigationHistory.size(); ++i) {
                    if (i != 0 && i % 10 == n) {
                        stringBuilder.append("breadcrumbBar = document.createElement(\"p\");\n");
                        stringBuilder.append("breadcrumbBar.id = \"pBreadcrumbContent").append(++n3).append("\";\n");
                        stringBuilder.append("divBreadcrumbBar.appendChild(breadcrumbBar);\n");
                        stringBuilder.append("breadcrumbBar.style.display = \"none\";\n");
                        stringBuilder.append("var aBack = document.createElement(\"a\");\n");
                        stringBuilder.append("aBack.innerHTML = \"...\";\n");
                        stringBuilder.append("aBack.href = \"javascript:switchBreadcrumbPage('pBreadcrumbContent").append(n3).append("','pBreadcrumbContent").append(n3 - 1).append("');\";\n");
                        stringBuilder.append("breadcrumbBar.appendChild(aBack);\n");
                        stringBuilder.append("var raquo = document.createTextNode(String.fromCharCode(187));\n");
                        stringBuilder.append("breadcrumbBar.appendChild(raquo);\n");
                    }
                    if (i == state.insertPosition - 1) {
                        n2 = n3;
                    }
                    this.createBreadcrumbEntry(stringBuilder, state, i, i < state.insertPosition ? "white" : "gray");
                    if (i == state.navigationHistory.size() - 1) continue;
                    stringBuilder.append("var raquo = document.createTextNode(String.fromCharCode(187));\n");
                    stringBuilder.append("breadcrumbBar.appendChild(raquo);\n");
                    if (i % 10 != (n - 1 + 10) % 10) continue;
                    stringBuilder.append("var aBack = document.createElement(\"a\");\n");
                    stringBuilder.append("aBack.innerHTML = \"...\";\n");
                    stringBuilder.append("aBack.href = \"javascript:switchBreadcrumbPage('pBreadcrumbContent").append(n3).append("','pBreadcrumbContent").append(n3 + 1).append("');\";\n");
                    stringBuilder.append("breadcrumbBar.appendChild(aBack);\n");
                }
            }
            stringBuilder.append("document.getElementById(\"pBreadcrumbContent").append(n2).append("\").style.display = \"inline\";\n");
        }
        return stringBuilder;
    }

    private boolean isNewElement(State state, Object object) {
        return state.navigationHistory.isEmpty() || state.navigationHistory.get(state.insertPosition - 1) != object;
    }

    private void createBreadcrumbEntry(StringBuilder stringBuilder, State state, int n, String string) {
        StringBuilder stringBuilder2 = new StringBuilder();
        Object object = state.navigationHistory.get(n);
        if (object instanceof Vertex) {
            stringBuilder2.append("v").append(((Vertex)object).getId());
        } else if (object instanceof Edge) {
            stringBuilder2.append("e").append(((Edge)object).getId());
        } else {
            stringBuilder2.append("{");
            boolean bl = true;
            int n2 = 0;
            PSet pSet = (PSet)object;
            for (GraphElement graphElement : pSet) {
                if (!bl) {
                    stringBuilder2.append(", ");
                    if (n2 >= 3) {
                        stringBuilder2.append("...");
                        break;
                    }
                }
                if (graphElement instanceof Vertex) {
                    stringBuilder2.append("v").append(((Vertex)graphElement).getId());
                } else {
                    stringBuilder2.append("e").append(((Edge)graphElement).getId());
                }
                bl = false;
                ++n2;
            }
            stringBuilder2.append("}");
        }
        stringBuilder.append("newEntry = document.createElement(\"a\");\n");
        stringBuilder.append("newEntry.href = \"javascript:goBackToElement(").append(n).append(",'").append((CharSequence)stringBuilder2).append("');\";\n");
        stringBuilder.append("newEntry.innerHTML = \"").append((CharSequence)stringBuilder2).append("\";\n");
        stringBuilder.append("newEntry.style.color = \"").append(string).append("\";\n");
        stringBuilder.append("breadcrumbBar.appendChild(newEntry);\n");
    }

    public StringBuilder initializeBrowser(Integer n) {
        State state = sessions.get(n);
        StringBuilder stringBuilder = new StringBuilder("function(){\n");
        stringBuilder.append("var optgroup = document.getElementById(\"OptgroupServersideGraph\");\n");
        stringBuilder.append("var oldOpt = optgroup.getElementsByTagName(\"option\");\n");
        stringBuilder.append("for(var i=0; i<oldOpt.length; i++ ){\n");
        stringBuilder.append("optgroup.removeChild(oldOpt[i]);\n");
        stringBuilder.append("}\n");
        stringBuilder.append("var childOpt;\n");
        stringBuilder.append("var optValue;\n");
        stringBuilder.append("var optText;\n");
        this.createOptionForGraphs(stringBuilder, this.workspace);
        try {
            stringBuilder.append("findPositionOf(\"").append(this.getEncodedFileName(new File(state.getGraphWrapper().graphPath), false)).append("\");\n");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        stringBuilder.append("document.getElementById(\"selectGraph\").selectedIndex = selectedGraphIndex;\n");
        stringBuilder.append("document.getElementById(\"checkShowAttributes\").style.visibility = \"hidden\";\n");
        stringBuilder.append("document.getElementById(\"pAttributes\").style.visibility = \"hidden\";\n");
        stringBuilder.append("document.getElementById(\"divTextVis\").style.visibility = \"hidden\";\n");
        stringBuilder.append("document.getElementById(\"aChangeView\").style.visibility = \"hidden\";\n");
        stringBuilder.append("document.getElementById(\"rightOption\").style.visibility = \"hidden\";\n");
        stringBuilder.append("document.getElementById(\"checkShowAttributes\").checked = \"\";\n");
        stringBuilder.append("document.getElementById(\"checkShowAttributes\").style.visible = \"hidden\";\n");
        stringBuilder.append("document.getElementById(\"divTextVis\").style.display = \"inline\";\n");
        stringBuilder.append("document.getElementById(\"div2DVis\").style.display = \"none\";\n");
        stringBuilder.append("document.getElementById(\"divTextGraph\").style.display = \"block\";\n");
        stringBuilder.append("document.getElementById(\"div2DGraph\").style.display = \"none\";\n");
        stringBuilder.append("document.getElementById(\"selectElementsPerPage\").selectedIndex = 1;\n");
        stringBuilder.append("document.getElementById(\"textPathLength\").value = \"1\";\n");
        stringBuilder.append("document.getElementById(\"h3HowManyVertices\").innerHTML = \"\";\n");
        stringBuilder.append("document.getElementById(\"h3HowManyVertices\").style.display = \"block\";\n");
        stringBuilder.append("document.getElementById(\"h3HowManyEdges\").innerHTML = \"\";\n");
        stringBuilder.append("document.getElementById(\"h3HowManyEdges\").style.display = \"none\";\n");
        stringBuilder.append("document.getElementById(\"h3HowManyElements\").innerHTML = \"\";\n");
        stringBuilder.append("document.getElementById(\"h3HowManyElements\").style.display = \"none\";\n");
        stringBuilder.append("changeFilterView('divVertexClass','aVertex');\n");
        stringBuilder.append("document.getElementById(\"divVertexClass\").innerHTML = \"\";\n");
        stringBuilder.append("document.getElementById(\"divEdgeClass\").innerHTML = \"\";\n");
        stringBuilder.append("document.getElementById(\"checkSelectAll\").checked = \"checked\";\n");
        stringBuilder.append("document.getElementById(\"inputRegEx\").value = \"<a case insensitive regular expression>\";\n");
        stringBuilder.append("cancelGReQL('aGReQL');\n");
        stringBuilder.append("document.getElementById(\"textElem\").value = \"\";\n");
        stringBuilder.append("document.getElementById(\"pBreadcrumbContent0\").innerHTML = \"\";\n");
        stringBuilder.append("document.getElementById(\"divTextVertex\").innerHTML = \"\";\n");
        stringBuilder.append("document.getElementById(\"divTextEdge\").innerHTML = \"\";\n");
        stringBuilder.append("var divTextVertex = document.getElementById(\"divTextVertex\");\n");
        stringBuilder.append("var divTextEdge = document.getElementById(\"divTextEdge\");\n");
        stringBuilder.append("var aShowVertices = document.getElementById(\"aShowVertices\");\n");
        stringBuilder.append("var aShowEdges = document.getElementById(\"aShowEdges\");\n");
        stringBuilder.append("if(divTextVertex.hasAttribute){\n");
        stringBuilder.append("divTextEdge.style.display = \"none\";\n");
        stringBuilder.append("divTextVertex.style.display = \"block\";\n");
        stringBuilder.append("aShowVertices.setAttribute(\"class\",\"geklickt\");\n");
        stringBuilder.append("aShowEdges.setAttribute(\"class\",\"\");\n");
        stringBuilder.append("}else{\n");
        stringBuilder.append("divTextEdge.style.display = \"none\";\n");
        stringBuilder.append("divTextVertex.style.display = \"block\";\n");
        stringBuilder.append("aShowVertices.setAttribute(\"className\",\"geklickt\");\n");
        stringBuilder.append("aShowEdges.setAttribute(\"className\",\"\");\n");
        stringBuilder.append("}\n");
        stringBuilder.append("document.getElementById(\"div2DGraph\").innerHTML = \"\";\n");
        stringBuilder.append("document.getElementById(\"divLoadBar\").style.display = \"block\";\n");
        stringBuilder.append("document.getElementById(\"loadBarForeground\").style.width = \"0px\";\n");
        stringBuilder.append("document.getElementById(\"loadBarNumber\").innerHTML = \"0 %\";\n");
        state.lastAccess = System.currentTimeMillis();
        stringBuilder.append("timestamp = ").append(state.lastAccess).append(";\n");
        stringBuilder.append("loadId = window.setTimeout(\"checkLoad()\", 100);\n");
        return stringBuilder.append("}");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StringBuilder checkLoading(Integer n) {
        State state = sessions.get(n);
        GraphWrapper graphWrapper = state.getGraphWrapper();
        StringBuilder stringBuilder = new StringBuilder("function(){\n");
        if (graphWrapper.workingCallable == null) {
            return this.initializeGraphView(n);
        }
        try {
            if (graphWrapper.workingCallable.isDone()) {
                graphWrapper.workingCallable.get();
                if (graphWrapper.excOfWorkingCallable != null) {
                    Exception exception = graphWrapper.excOfWorkingCallable;
                    stringBuilder.append("document.getElementById(\"loadError\").innerHTML += \"ERROR:<br />").append(exception.toString()).append("\";\n");
                    exception.printStackTrace();
                    return stringBuilder.append("}");
                }
                if (graphWrapper.graph == null) {
                    stringBuilder.append("document.getElementById(\"loadError\").innerHTML += \"ERROR:<br />The graph couldn't be loaded!<br />Probably an OutOfMemoryError occured.\";\n");
                    return stringBuilder.append("}");
                }
                graphWrapper.workingCallable = null;
                return this.initializeGraphView(n);
            }
            if (graphWrapper.workingCallable.isCancelled()) {
                stringBuilder.append("document.getElementById(\"loadError\").innerHTML += \"ERROR:<br />The loading of the graph was canceled!\";\n");
                return stringBuilder.append("}");
            }
            stringBuilder.append("document.getElementById(\"loadBarForeground\").style.width = \"").append(graphWrapper.progress).append("px\";\n");
            stringBuilder.append("document.getElementById(\"loadBarNumber\").innerHTML = \"").append(graphWrapper.progress / 4).append(" %\";\n");
            stringBuilder.append("loadId = window.setTimeout(\"checkLoad()\", 1000);\n");
            state.lastAccess = System.currentTimeMillis();
            stringBuilder.append("timestamp = ").append(state.lastAccess).append(";\n");
            return stringBuilder.append("}");
        }
        catch (Exception exception) {
            stringBuilder.append("document.getElementById(\"loadError\").innerHTML += \"ERROR:<br />").append(exception.toString()).append("\";\n");
            exception.printStackTrace();
        }
        return stringBuilder.append("}");
    }

    private void createOptionForGraphs(StringBuilder stringBuilder, File file) {
        for (File file2 : file.listFiles()) {
            if (file2.exists() && file2.isFile() && (file2.toString().endsWith(".tg") || file2.toString().endsWith(".gz"))) {
                stringBuilder.append("childOpt = document.createElement(\"option\");\n");
                stringBuilder.append("childOpt.setAttribute(\"value\",\"");
                try {
                    stringBuilder.append(this.getEncodedFileName(file2, false));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
                stringBuilder.append("\");\n");
                stringBuilder.append("optText = document.createTextNode(\"").append(file2.toString().replace(this.workspace.toString(), "").replace("\\", "/").substring(1)).append("\");\n");
                stringBuilder.append("childOpt.appendChild(optText);\n");
                stringBuilder.append("insertSortedIntoOption(childOpt,1,optgroup.childNodes.length-1);\n");
                continue;
            }
            if (!file2.exists() || !file2.isDirectory()) continue;
            this.createOptionForGraphs(stringBuilder, file2);
        }
    }

    public StringBuilder closeSession(Integer n) {
        State state = StateRepository.getSession(n);
        if (state != null) {
            state.delete();
        }
        return new StringBuilder("function(){}");
    }

    public StringBuilder deleteGraph(String string) {
        String string2 = "";
        try {
            string2 = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return this.returnError(unsupportedEncodingException.toString());
        }
        if (!string2.startsWith(this.workspace.toString().replace("\\", "/"))) {
            return this.returnError(string2 + " is not in the workspace!" + this.workspace.toString().replace("\\", "/"));
        }
        if (!string2.endsWith(".tg") && !string2.endsWith(".gz")) {
            return this.returnError(string2 + " is not a graph!");
        }
        File file = new File(string2);
        if (file.delete()) {
            return this.showGraphsOfServer();
        }
        return this.returnError(string2 + " could not be deleted.");
    }

    public StringBuilder showGraphsOfServer() {
        if (this.workspace != null) {
            StringBuilder stringBuilder = new StringBuilder("function() {\n");
            stringBuilder.append("var div=document.getElementById(\"divserver\");\n");
            stringBuilder.append("div.innerHTML = \"\";\n");
            stringBuilder.append("div.appendChild(document.createElement(\"br\"));\n");
            StringBuilder stringBuilder2 = new StringBuilder();
            if (!this.createListOfGraphs(stringBuilder2, this.workspace)) {
                stringBuilder.append("var h2 = document.createElement(\"h2\");\n");
                stringBuilder.append("h2.innerHTML = \"There are no graphs on the server.\";\n");
                stringBuilder.append("div.appendChild(h2);\n");
            } else {
                stringBuilder.append("var h3 = document.createElement(\"h3\");\n");
                stringBuilder.append("h3.innerHTML = \"Choose a graph from the server:\";\n");
                stringBuilder.append("div.appendChild(h3);\n");
                stringBuilder.append("div.appendChild(document.createElement(\"br\"));\n");
                stringBuilder.append("var parentUl = document.createElement(\"ul\");\n");
                stringBuilder.append("div.appendChild(parentUl);\n");
                stringBuilder.append("parentUl.id = \"parentUl\";");
                stringBuilder.append((CharSequence)stringBuilder2);
            }
            return stringBuilder.append("}");
        }
        return this.returnError("This server doesn't allow to load graphs of it.");
    }

    public StringBuilder loadGraphFromServer(String string) {
        return new StringBuilder(Integer.toString(StateRepository.createNewSession(string)));
    }

    public StringBuilder loadGraphFromURI(Boolean bl, String string) {
        int n;
        if (!string.toLowerCase().endsWith(".tg") && !string.toLowerCase().endsWith(".gz")) {
            return this.returnError(string + "isn't a graph.");
        }
        boolean bl2 = string.toLowerCase().endsWith(".gz");
        String[] stringArray = string.split("/");
        String string2 = stringArray[stringArray.length - 1];
        string2 = this.workspace.toString() + "/" + string2.substring(0, string2.length() - 3);
        File file = new File(string2 + (bl2 ? ".gz" : ".tg"));
        if (!bl.booleanValue()) {
            n = 0;
            while (file.exists()) {
                file = new File(string2 + n++ + (bl2 ? ".gz" : ".tg"));
            }
        }
        n = 1;
        try {
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.connect();
            long l = uRLConnection.getContentLength();
            boolean bl3 = RequestThread.isSizeOk(l);
            n = bl3 ? 1 : 0;
            if (bl3) {
                int n2;
                Object object = uRLConnection.getContent();
                if (!(object instanceof InputStream)) {
                    if (uRLConnection instanceof HttpURLConnection) {
                        ((HttpURLConnection)uRLConnection).disconnect();
                    }
                    return this.returnError("This file isn't plain text.");
                }
                InputStream inputStream = (InputStream)object;
                byte[] byArray = new byte[4096];
                if (!file.createNewFile()) {
                    TGraphBrowserServer.logger.info(file.toString() + " overwrites an existing file or could not be created.");
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                while ((n2 = inputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n2);
                    fileOutputStream.flush();
                }
                fileOutputStream.close();
                inputStream.close();
            }
            if (uRLConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)uRLConnection).disconnect();
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return this.returnError(malformedURLException.toString());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return this.returnError(iOException.toString());
        }
        return new StringBuilder(n == 0 ? "-1" : Integer.toString(StateRepository.createNewSession(file.getAbsolutePath())));
    }

    private StringBuilder returnError(String string) {
        StringBuilder stringBuilder = new StringBuilder("function() {\n");
        stringBuilder.append("document.getElementById('divError').style.display = \"block\";\n");
        stringBuilder.append("document.getElementById('h2ErrorMessage').innerHTML = \"ERROR: ").append(string).append("\";\n");
        stringBuilder.append("document.getElementById('divNonError').style.display = \"none\";\n");
        return stringBuilder.append("}");
    }

    private boolean createListOfGraphs(StringBuilder stringBuilder, File file) {
        assert (file.exists() && file.isDirectory());
        boolean bl = false;
        for (File file2 : file.listFiles()) {
            if (!file2.exists()) continue;
            if (file2.isDirectory()) {
                bl |= this.createListOfGraphs(stringBuilder, file2);
                continue;
            }
            if (!file2.toString().toLowerCase().endsWith(".tg") && !file2.toString().toLowerCase().endsWith(".gz")) continue;
            bl = true;
            stringBuilder.append("var li = document.createElement(\"li\");\n");
            stringBuilder.append("var a = document.createElement(\"a\");\n");
            stringBuilder.append("a.innerHTML = \"").append(Pattern.compile(Matcher.quoteReplacement("\\")).matcher(file2.toString().substring(this.workspace.toString().length() + 1)).replaceAll("/")).append("\";\n");
            try {
                stringBuilder.append("a.href = \"javascript:document.location = 'loadGraphFromServer?path='+'").append(this.getEncodedFileName(file2, true)).append("';\";\n");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            stringBuilder.append("li.appendChild(a);\n");
            stringBuilder.append("li.appendChild(document.createTextNode(String.fromCharCode(160)));\n");
            stringBuilder.append("var deleteA = document.createElement(\"a\");\n");
            stringBuilder.append("deleteA.innerHTML = \"X\";\n");
            stringBuilder.append("deleteA.href = \"javascript:deleteGraph('").append(Pattern.compile(Matcher.quoteReplacement("\\")).matcher(file2.toString()).replaceAll("/")).append("');\";\n");
            stringBuilder.append("deleteA.style.textDecoration = \"none\";\n");
            stringBuilder.append("deleteA.style.color = \"red\";\n");
            stringBuilder.append("deleteA.style.fontWeight = \"bold\";\n");
            stringBuilder.append("li.appendChild(deleteA);\n");
            stringBuilder.append("insertSorted(li, parentUl, 0, parentUl.childNodes.length-1);\n");
        }
        return bl;
    }

    private String getEncodedFileName(File file, boolean bl) throws UnsupportedEncodingException {
        String string = URLEncoder.encode(file.toString(), "UTF-8");
        if (bl) {
            return URLEncoder.encode(string, "UTF-8");
        }
        return string;
    }

    public StringBuilder reloadGraph(Integer n) {
        State state = StateRepository.getSession(n);
        GraphWrapper graphWrapper = state.getGraphWrapper();
        String string = graphWrapper.graphPath;
        graphWrapper.delete();
        state.initializeState(string);
        return this.initializeBrowser(n);
    }

    public StringBuilder keepOldGraph(Integer n, String string) {
        State state = StateRepository.getSession(n);
        state.ignoreNewGraphVersions = true;
        StringBuilder stringBuilder = new StringBuilder("function() {");
        stringBuilder.append(string).append("\n}");
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int createNewSession(String string) {
        State state = new State(string);
        ArrayList<State> arrayList = sessions;
        synchronized (arrayList) {
            while (sessions.size() < nextSessionId) {
                sessions.add(null);
            }
            sessions.add(state);
            TGraphBrowserServer.logger.info("Session " + nextSessionId + " created");
            assert (sessions.indexOf(state) == nextSessionId);
        }
        return nextSessionId++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllUnusedSessions(long l) {
        ArrayList<State> arrayList = sessions;
        synchronized (arrayList) {
            for (int i = 0; i < sessions.size(); ++i) {
                State state = sessions.get(i);
                if (state == null || state.lastAccess + l >= System.currentTimeMillis()) continue;
                state.deleteUnsynchronized();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static State getSession(int n) {
        State state;
        ArrayList<State> arrayList = sessions;
        synchronized (arrayList) {
            assert (n < sessions.size());
            state = sessions.get(n);
            state.lastAccess = System.currentTimeMillis();
        }
        return state;
    }

    public static State getSession(int n, StringBuilder stringBuilder, String string, String ... stringArray) {
        State state = StateRepository.getSession(n);
        GraphWrapper graphWrapper = state.getGraphWrapper();
        File file = new File(graphWrapper.graphPath);
        if (!state.ignoreNewGraphVersions && file.exists() && file.lastModified() > graphWrapper.lastModified) {
            stringBuilder.append("var reload = confirm(\"The tg-file of the currently loaded graph has changed.\\n").append("Do you want to load the modified graph?\");\n");
            stringBuilder.append("if(reload){\n");
            stringBuilder.append("sendPostRequest(\"reloadGraph\");\n");
            stringBuilder.append("}else{\n");
            stringBuilder.append("sendPostRequest(\"keepOldGraph\",\"sendPostRequest(\\\"").append(string).append("\\\"");
            for (int i = 0; i < stringArray.length; ++i) {
                if (i == 0) {
                    stringBuilder.append(",\\\"");
                } else {
                    stringBuilder.append("\\\\n");
                }
                stringBuilder.append(stringArray[i]);
            }
            stringBuilder.append("\\\",true);\");\n");
            stringBuilder.append("}\n");
            return null;
        }
        return state;
    }

    static {
        definedMethods = new HashMap();
        for (Method method : StateRepository.class.getMethods()) {
            definedMethods.put(method.getName(), method);
        }
        usedGraphs = new ConcurrentHashMap();
    }

    public static class LoadGraphCallable
    implements Callable<Void> {
        private GraphWrapper currentGraph;

        public LoadGraphCallable(GraphWrapper graphWrapper) {
            this.currentGraph = graphWrapper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            try {
                Class<GraphIO> clazz = GraphIO.class;
                synchronized (GraphIO.class) {
                    this.currentGraph.progress = 0;
                    this.currentGraph.graph = GraphIO.loadGraphFromFile(this.currentGraph.graphPath, ImplementationType.GENERIC, (ProgressFunction)new MyProgressFunction(this.currentGraph));
                    assert (this.currentGraph.graph != null) : "The graph wasn't loaded correctly.";
                    this.currentGraph = null;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            }
            catch (Exception exception) {
                this.currentGraph.excOfWorkingCallable = exception;
                exception.printStackTrace();
                this.currentGraph = null;
            }
            {
                return null;
            }
        }

        private static class MyProgressFunction
        implements ProgressFunction {
            private long totalElements;
            private static final long length = 400L;
            private int currentChar;
            private GraphWrapper currentGraph;

            public MyProgressFunction(GraphWrapper graphWrapper) {
                this.currentGraph = graphWrapper;
            }

            @Override
            public void finished() {
                try {
                    for (long i = (long)this.currentChar; i < 400L; ++i) {
                        ++this.currentGraph.progress;
                    }
                    this.currentGraph = null;
                }
                catch (Exception exception) {
                    this.currentGraph.excOfWorkingCallable = exception;
                    exception.printStackTrace();
                }
            }

            @Override
            public long getUpdateInterval() {
                try {
                    return 400L > this.totalElements ? 1L : this.totalElements / 400L;
                }
                catch (Exception exception) {
                    this.currentGraph.excOfWorkingCallable = exception;
                    exception.printStackTrace();
                    return 0L;
                }
            }

            @Override
            public void init(long l) {
                this.currentChar = 0;
                this.totalElements = l;
            }

            @Override
            public void progress(long l) {
                try {
                    if ((long)this.currentChar < 400L) {
                        ++this.currentGraph.progress;
                        ++this.currentChar;
                    }
                }
                catch (Exception exception) {
                    this.currentGraph.excOfWorkingCallable = exception;
                    exception.printStackTrace();
                }
            }
        }
    }

    public static class GraphWrapper {
        public Graph graph;
        public String graphPath;
        public long lastModified;
        public int numberOfUsers = 1;
        public FutureTask<?> workingCallable;
        public Exception excOfWorkingCallable;
        public String graphIdentifier;
        public int progress;

        public GraphWrapper(String string, String string2, long l) {
            this.graphIdentifier = string;
            this.graphPath = string2;
            this.lastModified = l;
            this.workingCallable = (FutureTask)Executors.newCachedThreadPool().submit(new LoadGraphCallable(this));
        }

        public synchronized void delete() {
            --this.numberOfUsers;
            if (this.numberOfUsers == 0) {
                if (this.workingCallable != null && !this.workingCallable.isDone() && !this.workingCallable.isCancelled()) {
                    this.workingCallable.cancel(true);
                }
                this.graph = null;
                this.workingCallable = null;
                this.excOfWorkingCallable = null;
                usedGraphs.remove(this.graphIdentifier);
            }
        }
    }

    static class State {
        public long lastAccess;
        public boolean ignoreNewGraphVersions;
        public String graphIdentifier;
        public HashMap<VertexClass, Boolean> selectedVertexClasses;
        public HashMap<EdgeClass, Boolean> selectedEdgeClasses;
        public ArrayList<Object> navigationHistory;
        public int insertPosition;
        public Vertex[] verticesOfTableView;
        public Edge[] edgesOfTableView;
        public PSet<GraphElement<?, ?>> currentExplicitlyDefinedSet;

        public State(String string) {
            this.initializeState(string);
        }

        public void initializeState(String string) {
            this.lastAccess = System.currentTimeMillis();
            this.setGraphIdentifier(string, new File(string).lastModified());
            this.navigationHistory = new ArrayList();
            this.selectedVertexClasses = new HashMap();
            this.selectedEdgeClasses = new HashMap();
            this.insertPosition = 0;
            this.setGraph(string, new File(string).lastModified());
        }

        public Graph getGraph() {
            return StateRepository.usedGraphs.get((Object)this.graphIdentifier).graph;
        }

        public GraphWrapper getGraphWrapper() {
            return usedGraphs.get(this.graphIdentifier);
        }

        public void setGraph(String string, long l) {
            this.setGraphIdentifier(string, l);
            if (!usedGraphs.containsKey(this.graphIdentifier)) {
                usedGraphs.put(this.graphIdentifier, new GraphWrapper(this.graphIdentifier, string, l));
            } else {
                ++StateRepository.usedGraphs.get((Object)this.graphIdentifier).numberOfUsers;
            }
        }

        private void setGraphIdentifier(String string, long l) {
            this.graphIdentifier = string + "_" + l;
        }

        public synchronized StringBuilder getVertexTypeSet() {
            return this.convertToSet(this.selectedVertexClasses);
        }

        public synchronized StringBuilder getEdgeTypeSet() {
            return this.convertToSet(this.selectedEdgeClasses);
        }

        private synchronized StringBuilder convertToSet(HashMap<? extends GraphElementClass<?, ?>, Boolean> hashMap) {
            StringBuilder stringBuilder = new StringBuilder("{");
            String string = "";
            for (GraphElementClass<?, ?> graphElementClass : hashMap.keySet()) {
                stringBuilder.append(string).append(hashMap.get(graphElementClass) != false ? "" : "^").append(graphElementClass.getQualifiedName()).append("!");
                string = ", ";
            }
            stringBuilder.append("}");
            return stringBuilder;
        }

        public synchronized void deleteUnsynchronized() {
            int n = sessions.indexOf(this);
            sessions.set(n, null);
            this.getGraphWrapper().delete();
            this.graphIdentifier = null;
            this.edgesOfTableView = null;
            this.verticesOfTableView = null;
            this.navigationHistory = null;
            this.selectedEdgeClasses = null;
            this.selectedVertexClasses = null;
            TGraphBrowserServer.logger.info("Session " + n + " deleted");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delete() {
            ArrayList arrayList = sessions;
            synchronized (arrayList) {
                this.deleteUnsynchronized();
            }
        }
    }
}

