/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tg2schemagraph;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.grumlschema.GrumlSchema;
import de.uni_koblenz.jgralab.grumlschema.SchemaGraph;
import de.uni_koblenz.jgralab.grumlschema.domains.CollectionDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.Domain;
import de.uni_koblenz.jgralab.grumlschema.domains.EnumDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.HasBaseDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.HasRecordDomainComponent;
import de.uni_koblenz.jgralab.grumlschema.domains.MapDomain;
import de.uni_koblenz.jgralab.grumlschema.structure.AggregationKind;
import de.uni_koblenz.jgralab.grumlschema.structure.Annotates;
import de.uni_koblenz.jgralab.grumlschema.structure.AttributedElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.ComesFrom;
import de.uni_koblenz.jgralab.grumlschema.structure.Comment;
import de.uni_koblenz.jgralab.grumlschema.structure.Constraint;
import de.uni_koblenz.jgralab.grumlschema.structure.ContainsDefaultPackage;
import de.uni_koblenz.jgralab.grumlschema.structure.ContainsDomain;
import de.uni_koblenz.jgralab.grumlschema.structure.ContainsGraphElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.ContainsSubPackage;
import de.uni_koblenz.jgralab.grumlschema.structure.EndsAt;
import de.uni_koblenz.jgralab.grumlschema.structure.GoesTo;
import de.uni_koblenz.jgralab.grumlschema.structure.HasAttribute;
import de.uni_koblenz.jgralab.grumlschema.structure.HasConstraint;
import de.uni_koblenz.jgralab.grumlschema.structure.HasDomain;
import de.uni_koblenz.jgralab.grumlschema.structure.NamedElement;
import de.uni_koblenz.jgralab.grumlschema.structure.Schema;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.BooleanDomain;
import de.uni_koblenz.jgralab.schema.DoubleDomain;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.IncidenceClass;
import de.uni_koblenz.jgralab.schema.IntegerDomain;
import de.uni_koblenz.jgralab.schema.ListDomain;
import de.uni_koblenz.jgralab.schema.LongDomain;
import de.uni_koblenz.jgralab.schema.Package;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import de.uni_koblenz.jgralab.schema.StringDomain;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.util.HashMap;
import java.util.Map;

public class Schema2SchemaGraph {
    private de.uni_koblenz.jgralab.schema.Schema schema;
    private de.uni_koblenz.jgralab.grumlschema.structure.Package gDefaultPackage;
    private Package defaultPackage;
    private Map<Package, de.uni_koblenz.jgralab.grumlschema.structure.Package> packageMap;
    private Map<de.uni_koblenz.jgralab.schema.AttributedElementClass<?, ?>, AttributedElementClass> attributedElementClassMap;
    private Map<VertexClass, de.uni_koblenz.jgralab.grumlschema.structure.VertexClass> vertexClassMap;
    private Map<EdgeClass, de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass> edgeClassMap;
    private Map<IncidenceClass, de.uni_koblenz.jgralab.grumlschema.structure.IncidenceClass> incidenceClassMap;
    private Map<de.uni_koblenz.jgralab.schema.Domain, Domain> domainMap;
    private SchemaGraph schemaGraph;

    private void setUp() {
        this.packageMap = new HashMap<Package, de.uni_koblenz.jgralab.grumlschema.structure.Package>();
        this.attributedElementClassMap = new HashMap();
        this.domainMap = new HashMap<de.uni_koblenz.jgralab.schema.Domain, Domain>();
        this.vertexClassMap = new HashMap<VertexClass, de.uni_koblenz.jgralab.grumlschema.structure.VertexClass>();
        this.edgeClassMap = new HashMap<EdgeClass, de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass>();
        this.incidenceClassMap = new HashMap<IncidenceClass, de.uni_koblenz.jgralab.grumlschema.structure.IncidenceClass>();
        this.schemaGraph = GrumlSchema.instance().createSchemaGraph(ImplementationType.STANDARD);
    }

    private void tearDown() {
        this.packageMap = null;
        this.attributedElementClassMap = null;
        this.domainMap = null;
        this.vertexClassMap = null;
        this.edgeClassMap = null;
        this.incidenceClassMap = null;
        this.defaultPackage = null;
        this.gDefaultPackage = null;
        this.schemaGraph = null;
    }

    public synchronized SchemaGraph convert2SchemaGraph(de.uni_koblenz.jgralab.schema.Schema schema) {
        this.setUp();
        if (schema == null) {
            throw new IllegalArgumentException("Schema is a NullReference.");
        }
        this.schema = schema;
        assert (this.checkSchemaAndSchemaGraph());
        this.createSchema();
        this.createGraphClass();
        this.createPackages();
        this.createDomains();
        this.createVertexClasses();
        this.createEdgeClasses();
        this.createSpecializations();
        this.createAttributes();
        this.createConstraints();
        this.createIncidenceClasses();
        SchemaGraph schemaGraph = this.schemaGraph;
        this.tearDown();
        return schemaGraph;
    }

    private void createSchema() {
        assert (this.checkSchemaAndSchemaGraph());
        Schema schema = this.schemaGraph.createSchema();
        assert (schema != null) : "FIXME! No Schema has been created";
        assert (this.schema.getName() != null) : "FIXME! Schema name of a Schema shouldn't be null.";
        assert (this.schema.getPackagePrefix() != null) : "FIXME! Package prefix should exist.";
        schema.set_name(this.schema.getName());
        schema.set_packagePrefix(this.schema.getPackagePrefix());
    }

    private boolean checkSchemaAndSchemaGraph() {
        assert (this.schemaGraph != null) : "SchemaGraph has not been created.";
        assert (this.schema != null) : "Given Schema is null";
        return true;
    }

    private void createGraphClass() {
        assert (this.checkSchemaAndSchemaGraph());
        Schema schema = this.schemaGraph.getFirstSchema();
        assert (schema != null) : "FIXME! No Schema has been created!";
        de.uni_koblenz.jgralab.grumlschema.structure.GraphClass graphClass = this.schemaGraph.createGraphClass();
        assert (graphClass != null) : "FIXME! No GraphClass has been created!";
        GraphClass graphClass2 = this.schema.getGraphClass();
        assert (this.attributedElementClassMap != null);
        this.attributedElementClassMap.put(graphClass2, graphClass);
        assert (graphClass2.getQualifiedName() != null) : "FIXME! GraphClass is broken. No QualifiedName is set.";
        graphClass.set_qualifiedName(graphClass2.getQualifiedName());
        this.schemaGraph.createDefinesGraphClass(schema, graphClass);
        if (graphClass2.getComments() != null) {
            this.createComments(graphClass2, graphClass);
        }
    }

    private void createComments(de.uni_koblenz.jgralab.schema.NamedElement namedElement, NamedElement namedElement2) {
        assert (this.checkSchemaAndSchemaGraph());
        for (String string : namedElement.getComments()) {
            Comment comment = this.schemaGraph.createComment();
            assert (comment != null) : "FIXEME! No Comment has been created!";
            comment.set_text(string);
            Annotates annotates = this.schemaGraph.createAnnotates(comment, namedElement2);
            assert (annotates != null) : "FIXME! No Annotates link has been created.";
        }
    }

    private void createPackages() {
        this.createDefaultPackage();
        this.createSubPackages(this.defaultPackage, this.gDefaultPackage);
    }

    private void createDefaultPackage() {
        assert (this.checkSchemaAndSchemaGraph());
        this.gDefaultPackage = this.schemaGraph.createPackage();
        this.defaultPackage = this.schema.getDefaultPackage();
        assert (this.gDefaultPackage != null) : "FIXEME! No DefaultPackage has been created!";
        assert (this.defaultPackage != null) : "FIXME! No DefaultPackage is defined in the given Schema.";
        assert (this.defaultPackage.getQualifiedName() != null) : "FIXME! Package has not QualifiedName defined.";
        this.gDefaultPackage.set_qualifiedName(this.defaultPackage.getQualifiedName());
        this.packageMap.put(this.defaultPackage, this.gDefaultPackage);
        ContainsDefaultPackage containsDefaultPackage = this.schemaGraph.createContainsDefaultPackage(this.schemaGraph.getFirstSchema(), this.gDefaultPackage);
        assert (containsDefaultPackage != null) : "FIXME! No ContainsDefaultPackage link has been created.";
        if (this.defaultPackage.getComments() != null) {
            this.createComments(this.defaultPackage, this.gDefaultPackage);
        }
    }

    private void createSubPackages(Package package_, de.uni_koblenz.jgralab.grumlschema.structure.Package package_2) {
        assert (this.checkSchemaAndSchemaGraph());
        for (Package package_3 : package_.getSubPackages()) {
            assert (package_3 != null && package_3.getQualifiedName() != null) : "FIXME! This Package has no QualifiedName defined!";
            de.uni_koblenz.jgralab.grumlschema.structure.Package package_4 = this.schemaGraph.createPackage();
            assert (package_4 != null) : "FIXME! A Package wasn't created.";
            package_4.set_qualifiedName(package_3.getQualifiedName());
            this.packageMap.put(package_3, package_4);
            ContainsSubPackage containsSubPackage = this.schemaGraph.createContainsSubPackage(package_2, package_4);
            assert (containsSubPackage != null) : "FIXME! Link ContainsSubPackage has not been created!";
            if (package_3.getComments() != null) {
                this.createComments(package_3, package_4);
            }
            this.createSubPackages(package_3, package_4);
        }
    }

    private void createDomains() {
        for (Map.Entry<Package, de.uni_koblenz.jgralab.grumlschema.structure.Package> entry : this.packageMap.entrySet()) {
            for (de.uni_koblenz.jgralab.schema.Domain domain : entry.getKey().getDomains()) {
                this.createDomain(domain);
            }
        }
    }

    private Domain createDomain(de.uni_koblenz.jgralab.schema.Domain domain) {
        assert (this.checkSchemaAndSchemaGraph());
        assert (domain != null) : "FIXME! Domain is not set.";
        Domain domain2 = null;
        if (this.domainMap.containsKey(domain)) {
            domain2 = this.domainMap.get(domain);
        } else {
            if (domain instanceof BooleanDomain) {
                domain2 = this.schemaGraph.createBooleanDomain();
            } else if (domain instanceof IntegerDomain) {
                domain2 = this.schemaGraph.createIntegerDomain();
            } else if (domain instanceof LongDomain) {
                domain2 = this.schemaGraph.createLongDomain();
            } else if (domain instanceof DoubleDomain) {
                domain2 = this.schemaGraph.createDoubleDomain();
            } else if (domain instanceof StringDomain) {
                domain2 = this.schemaGraph.createStringDomain();
            } else if (domain instanceof de.uni_koblenz.jgralab.schema.CollectionDomain) {
                domain2 = this.createCollectionDomain((de.uni_koblenz.jgralab.schema.CollectionDomain)domain);
            } else if (domain instanceof de.uni_koblenz.jgralab.schema.MapDomain) {
                domain2 = this.createMapDomain((de.uni_koblenz.jgralab.schema.MapDomain)domain);
            } else if (domain instanceof RecordDomain) {
                domain2 = this.createRecordDomain((RecordDomain)domain);
            } else if (domain instanceof de.uni_koblenz.jgralab.schema.EnumDomain) {
                domain2 = this.createEnumDomain((de.uni_koblenz.jgralab.schema.EnumDomain)domain);
            } else {
                throw new RuntimeException("FIXME: Unforseen domain occured! " + domain);
            }
            assert (domain.getQualifiedName() != null) : "FIXME! QualifiedName is not defined";
            domain2.set_qualifiedName(domain.getQualifiedName());
            de.uni_koblenz.jgralab.grumlschema.structure.Package package_ = this.packageMap.get(domain.getPackage());
            ContainsDomain containsDomain = this.schemaGraph.createContainsDomain(package_, domain2);
            assert (containsDomain != null) : "FIXME! No link ContainsDomain has been created!";
            this.domainMap.put(domain, domain2);
            if (domain.getComments() != null) {
                this.createComments(domain, domain2);
            }
        }
        assert (domain2 != null);
        return domain2;
    }

    private MapDomain createMapDomain(de.uni_koblenz.jgralab.schema.MapDomain mapDomain) {
        assert (this.checkSchemaAndSchemaGraph());
        MapDomain mapDomain2 = this.schemaGraph.createMapDomain();
        this.domainMap.put(mapDomain, mapDomain2);
        this.schemaGraph.createHasKeyDomain(mapDomain2, this.queryGDomain(mapDomain.getKeyDomain()));
        this.schemaGraph.createHasValueDomain(mapDomain2, this.queryGDomain(mapDomain.getValueDomain()));
        return mapDomain2;
    }

    private EnumDomain createEnumDomain(de.uni_koblenz.jgralab.schema.EnumDomain enumDomain) {
        assert (this.checkSchemaAndSchemaGraph());
        EnumDomain enumDomain2 = this.schemaGraph.createEnumDomain();
        assert (enumDomain2 != null) : "FIXME! No EnumDomain has been created!";
        assert (enumDomain.getConsts() != null) : "FIXME! No consts defined.";
        enumDomain2.set_enumConstants(enumDomain.getConsts());
        return enumDomain2;
    }

    private CollectionDomain createCollectionDomain(de.uni_koblenz.jgralab.schema.CollectionDomain collectionDomain) {
        CollectionDomain collectionDomain2;
        assert (this.checkSchemaAndSchemaGraph());
        CollectionDomain collectionDomain3 = collectionDomain2 = collectionDomain instanceof ListDomain ? this.schemaGraph.createListDomain() : this.schemaGraph.createSetDomain();
        assert (collectionDomain2 != null) : "FIXME! No Domain has been created!";
        this.domainMap.put(collectionDomain, collectionDomain2);
        HasBaseDomain hasBaseDomain = this.schemaGraph.createHasBaseDomain(collectionDomain2, this.queryGDomain(collectionDomain.getBaseDomain()));
        assert (hasBaseDomain != null) : "FIXME! No link has been created!";
        return collectionDomain2;
    }

    private de.uni_koblenz.jgralab.grumlschema.domains.RecordDomain createRecordDomain(RecordDomain recordDomain) {
        assert (this.checkSchemaAndSchemaGraph());
        de.uni_koblenz.jgralab.grumlschema.domains.RecordDomain recordDomain2 = this.schemaGraph.createRecordDomain();
        assert (recordDomain2 != null) : "FIXME! No RecordDomain has been created!";
        this.domainMap.put(recordDomain, recordDomain2);
        for (RecordDomain.RecordComponent recordComponent : recordDomain.getComponents()) {
            HasRecordDomainComponent hasRecordDomainComponent = this.schemaGraph.createHasRecordDomainComponent(recordDomain2, this.queryGDomain(recordComponent.getDomain()));
            assert (hasRecordDomainComponent != null) : "FIXME! No link HasRecordDomainComponent has been created!";
            assert (recordComponent.getName() != null) : "FIXME! No name defined!";
            hasRecordDomainComponent.set_name(recordComponent.getName());
        }
        return recordDomain2;
    }

    private void createVertexClasses() {
        for (Map.Entry<Package, de.uni_koblenz.jgralab.grumlschema.structure.Package> entry : this.packageMap.entrySet()) {
            this.createVertexClasses(entry.getKey(), entry.getValue());
        }
    }

    private void createVertexClasses(Package package_, de.uni_koblenz.jgralab.grumlschema.structure.Package package_2) {
        assert (this.checkSchemaAndSchemaGraph());
        for (VertexClass vertexClass : package_.getVertexClasses()) {
            assert (vertexClass != null && vertexClass.getQualifiedName() != null) : "FIXME! No QualifiedName for this VertexClass defined!";
            de.uni_koblenz.jgralab.grumlschema.structure.VertexClass vertexClass2 = this.schemaGraph.createVertexClass();
            assert (vertexClass2 != null) : "FIXME! No VertexClass has been created!";
            vertexClass2.set_abstract(vertexClass.isAbstract());
            vertexClass2.set_qualifiedName(vertexClass.getQualifiedName());
            this.attributedElementClassMap.put(vertexClass, vertexClass2);
            this.vertexClassMap.put(vertexClass, vertexClass2);
            ContainsGraphElementClass containsGraphElementClass = this.schemaGraph.createContainsGraphElementClass(package_2, vertexClass2);
            assert (containsGraphElementClass != null) : "FIXME! No link ContainsGraphElementClass has been created!";
            if (vertexClass.getComments() == null) continue;
            this.createComments(vertexClass, vertexClass2);
        }
    }

    private void createEdgeClasses() {
        for (Map.Entry<Package, de.uni_koblenz.jgralab.grumlschema.structure.Package> entry : this.packageMap.entrySet()) {
            this.createEdgeClasses(entry.getKey(), entry.getValue());
        }
    }

    private void createEdgeClasses(Package package_, de.uni_koblenz.jgralab.grumlschema.structure.Package package_2) {
        assert (this.checkSchemaAndSchemaGraph());
        for (EdgeClass edgeClass : package_.getEdgeClasses()) {
            assert (edgeClass != null && edgeClass.getQualifiedName() != null) : "FIXME! No QualifiedName for this EdgeClass defined!";
            de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass edgeClass2 = this.createEdgeClass(edgeClass);
            this.attributedElementClassMap.put(edgeClass, edgeClass2);
            this.edgeClassMap.put(edgeClass, edgeClass2);
            ContainsGraphElementClass containsGraphElementClass = this.schemaGraph.createContainsGraphElementClass(package_2, edgeClass2);
            assert (containsGraphElementClass != null) : "FIXME! No link ContainsGraphElementClass has been created!";
            if (edgeClass.getComments() == null) continue;
            this.createComments(edgeClass, edgeClass2);
        }
    }

    private de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass createEdgeClass(EdgeClass edgeClass) {
        assert (this.checkSchemaAndSchemaGraph());
        assert (edgeClass != null && edgeClass.getQualifiedName() != null) : "FIXME! No QualifiedName for this EdgeClass defined!";
        de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass edgeClass2 = this.schemaGraph.createEdgeClass();
        assert (edgeClass2 != null) : "FIXME! No EdgeClass has been created!";
        edgeClass2.set_abstract(edgeClass.isAbstract());
        edgeClass2.set_qualifiedName(edgeClass.getQualifiedName());
        return edgeClass2;
    }

    private void createSpecializations() {
        Edge edge;
        assert (this.checkSchemaAndSchemaGraph());
        for (Map.Entry<VertexClass, de.uni_koblenz.jgralab.grumlschema.structure.VertexClass> entry : this.vertexClassMap.entrySet()) {
            for (de.uni_koblenz.jgralab.schema.AttributedElementClass attributedElementClass : entry.getKey().getDirectSuperClasses()) {
                edge = this.schemaGraph.createSpecializesVertexClass(entry.getValue(), this.vertexClassMap.get(attributedElementClass));
                assert (edge != null) : "FIXME! No link SpecializesVertexClass has been created!";
            }
        }
        for (Map.Entry<GraphElementClass<VertexClass, Vertex>, de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass> entry : this.edgeClassMap.entrySet()) {
            for (de.uni_koblenz.jgralab.schema.AttributedElementClass attributedElementClass : ((EdgeClass)entry.getKey()).getDirectSuperClasses()) {
                edge = this.schemaGraph.createSpecializesEdgeClass((de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass)entry.getValue(), this.edgeClassMap.get(attributedElementClass));
                assert (edge != null) : "FIXME! No link SpecializesEdgeClass has been created!";
            }
        }
    }

    private void createAttributes() {
        for (Map.Entry<de.uni_koblenz.jgralab.schema.AttributedElementClass<?, ?>, AttributedElementClass> entry : this.attributedElementClassMap.entrySet()) {
            this.createAttributes(entry.getKey(), entry.getValue());
        }
    }

    private void createAttributes(de.uni_koblenz.jgralab.schema.AttributedElementClass<?, ?> attributedElementClass, AttributedElementClass attributedElementClass2) {
        assert (this.checkSchemaAndSchemaGraph());
        for (Attribute attribute : attributedElementClass.getOwnAttributeList()) {
            assert (attribute != null && attribute.getName() != null) : "FIXME! No name for this Attribute is defined!";
            de.uni_koblenz.jgralab.grumlschema.structure.Attribute attribute2 = this.schemaGraph.createAttribute();
            assert (attribute2 != null) : "FIXME! No Attribute has been created!";
            attribute2.set_name(attribute.getName());
            attribute2.set_defaultValue(attribute.getDefaultValueAsString());
            assert (attribute.getDomain() != null) : "FIXME! No Domain has been defined!";
            Domain domain = this.domainMap.get(attribute.getDomain());
            assert (domain != null) : "FIXME! Given Schema malformed, because the requested Domain is not registered in its Package";
            HasAttribute hasAttribute = this.schemaGraph.createHasAttribute(attributedElementClass2, attribute2);
            HasDomain hasDomain = this.schemaGraph.createHasDomain(attribute2, domain);
            assert (hasAttribute != null && hasDomain != null) : "FIXME! No link HasAttribute or HasDomain have been created!";
        }
    }

    private void createConstraints() {
        for (Map.Entry<de.uni_koblenz.jgralab.schema.AttributedElementClass<?, ?>, AttributedElementClass> entry : this.attributedElementClassMap.entrySet()) {
            this.createConstraints(entry.getKey(), entry.getValue());
        }
    }

    private void createConstraints(de.uni_koblenz.jgralab.schema.AttributedElementClass<?, ?> attributedElementClass, AttributedElementClass attributedElementClass2) {
        assert (this.checkSchemaAndSchemaGraph());
        assert (attributedElementClass != null) : "FIXME! AttributedElement is null!";
        assert (attributedElementClass2 != null) : "FIXME! AttributedElement is null!";
        assert (attributedElementClass.getConstraints() != null) : "FIXME! AttributedElement has no Constraints defined!";
        for (de.uni_koblenz.jgralab.schema.Constraint constraint : attributedElementClass.getConstraints()) {
            assert (constraint != null && constraint.getMessage() != null && constraint.getPredicate() != null) : "FIXME! Constraint isn't wellformed.";
            Constraint constraint2 = this.schemaGraph.createConstraint();
            constraint2.set_message(constraint.getMessage());
            constraint2.set_predicateQuery(constraint.getPredicate());
            constraint2.set_offendingElementsQuery(constraint.getOffendingElementsQuery());
            HasConstraint hasConstraint = this.schemaGraph.createHasConstraint(attributedElementClass2, constraint2);
            assert (hasConstraint != null) : "FIXME! No link HasConstraint has been created!";
        }
    }

    private void createIncidenceClasses() {
        for (Map.Entry<EdgeClass, de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass> entry : this.edgeClassMap.entrySet()) {
            this.createIncidenceClass(entry.getKey(), entry.getValue());
        }
    }

    private void createIncidenceClass(EdgeClass edgeClass, de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass edgeClass2) {
        assert (edgeClass != null) : "FIXME! EdgeClass is null!";
        assert (edgeClass.getFrom() != null) : "FIXME! No from IncidenceClass defined!";
        de.uni_koblenz.jgralab.grumlschema.structure.IncidenceClass incidenceClass = this.createIncidenceClass(edgeClass.getFrom());
        this.incidenceClassMap.put(edgeClass.getFrom(), incidenceClass);
        ComesFrom comesFrom = this.schemaGraph.createComesFrom(edgeClass2, incidenceClass);
        assert (comesFrom != null) : "FIXME! No link ComesFrom has been created!";
        assert (edgeClass.getTo() != null) : "FIXME! No to IncidenceClass defined!";
        incidenceClass = this.createIncidenceClass(edgeClass.getTo());
        this.incidenceClassMap.put(edgeClass.getTo(), incidenceClass);
        GoesTo goesTo = this.schemaGraph.createGoesTo(edgeClass2, incidenceClass);
        assert (goesTo != null) : "FIXME! No link GoesTo has been created!";
        assert (this.checkSchemaAndSchemaGraph());
    }

    private de.uni_koblenz.jgralab.grumlschema.structure.IncidenceClass createIncidenceClass(IncidenceClass incidenceClass) {
        assert (this.checkSchemaAndSchemaGraph());
        assert (incidenceClass != null && incidenceClass.getAggregationKind() != null) : "FIXME! No AggregationKind for this IncidenceClass defined!";
        assert (incidenceClass != null && incidenceClass.getDirection() != null) : "FIXME! No Direction for this IncidenceClass defined!";
        de.uni_koblenz.jgralab.grumlschema.structure.IncidenceClass incidenceClass2 = this.schemaGraph.createIncidenceClass();
        assert (incidenceClass2 != null) : "FIXME! No IncidenceClass has been created!";
        incidenceClass2.set_aggregation(AggregationKind.valueOf(incidenceClass.getAggregationKind().toString()));
        incidenceClass2.set_max(incidenceClass.getMax());
        incidenceClass2.set_min(incidenceClass.getMin());
        incidenceClass2.set_roleName(incidenceClass.getRolename());
        de.uni_koblenz.jgralab.grumlschema.structure.VertexClass vertexClass = this.vertexClassMap.get(incidenceClass.getVertexClass());
        assert (vertexClass != null) : "The to vertex class '" + incidenceClass.getVertexClass().getQualifiedName() + "' was not in vertexClassMap!";
        EndsAt endsAt = this.schemaGraph.createEndsAt(incidenceClass2, vertexClass);
        assert (endsAt != null) : "FIXME! No link EndsAt has been created!";
        return incidenceClass2;
    }

    private Domain queryGDomain(de.uni_koblenz.jgralab.schema.Domain domain) {
        assert (this.domainMap != null) : "Relation map from original Domain to SchemaGraph Domain hasn't been created.";
        Domain domain2 = this.domainMap.get(domain);
        if (domain2 == null) {
            domain2 = this.createDomain(domain);
        }
        assert (domain2 != null) : "FIXME! Something is wrong!";
        return domain2;
    }
}

