/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.schema.BasicDomain;
import de.uni_koblenz.jgralab.schema.CollectionDomain;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.MapDomain;
import de.uni_koblenz.jgralab.schema.NamedElement;
import de.uni_koblenz.jgralab.schema.Package;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import de.uni_koblenz.jgralab.schema.impl.PackageImpl;
import de.uni_koblenz.jgralab.schema.impl.SchemaImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public abstract class NamedElementImpl
implements NamedElement {
    protected final SchemaImpl schema;
    protected PackageImpl parentPackage;
    protected String qualifiedName;
    protected String simpleName;
    private static final Pattern COLLECTION_OR_MAPDOMAIN_NAME_PATTERN = Pattern.compile("[.]?\\p{Upper}\\w*<[<>., _\\w]+>$");
    static final Pattern PACKAGE_NAME_PATTERN = Pattern.compile("\\p{Lower}\\w*");
    static final Pattern ATTRELEM_OR_NOCOLLDOMAIN_PATTERN = Pattern.compile("\\p{Upper}\\w*?");
    protected List<String> comments;

    protected NamedElementImpl(String string, PackageImpl packageImpl, SchemaImpl schemaImpl) {
        if (schemaImpl == null) {
            throw new SchemaException("Cannot create the element '" + string + "' because no containing schema was specified.");
        }
        this.schema = schemaImpl;
        if (packageImpl == null) {
            if (string.equals("") && this instanceof PackageImpl && schemaImpl.getDefaultPackage() == null) {
                this.qualifiedName = "";
                this.parentPackage = null;
                this.simpleName = "";
                this.comments = new ArrayList<String>();
                return;
            }
            throw new SchemaException("Cannot create the element '" + string + "' cause no parent package was given.");
        }
        this.parentPackage = packageImpl;
        if (this instanceof CollectionDomain || this instanceof MapDomain) {
            if (!COLLECTION_OR_MAPDOMAIN_NAME_PATTERN.matcher(string).matches()) {
                throw new SchemaException("Invalid simpleName for Collection- or MapDomain '" + string + "': The simple name must not be empty. " + "The simple name must start with a uppercase letter. " + "Any following character must be alphanumeric or a '_' character (List-/Map-/Set-Domain simple names may also have '.<>,' characters).");
            }
        } else if (this instanceof Package) {
            if (!PACKAGE_NAME_PATTERN.matcher(string).matches()) {
                throw new SchemaException("Invalid simpleName for Package '" + string + "': The simple name must start with a small letter. " + "Any following character must be alphanumeric and/or a '_' character. " + "The simple name must end with an alphanumeric character.");
            }
        } else if (!ATTRELEM_OR_NOCOLLDOMAIN_PATTERN.matcher(string).matches()) {
            throw new SchemaException("Invalid simpleName for AttributedElementClass or Domain '" + string + "': The simple name must not be empty. " + "The simple name must start with a letter. " + "Any following character must be alphanumeric and/or a '_' character. " + "The simple name must end with an alphanumeric character.");
        }
        if (Schema.RESERVED_JAVA_WORDS.contains(string)) {
            throw new SchemaException("Invalid simpleName '" + string + "': The simple name must not be a reserved Java word.");
        }
        this.simpleName = string;
        this.qualifiedName = (packageImpl == null || packageImpl.getQualifiedName().equals("") ? "" : packageImpl.getQualifiedName() + ".") + string;
        if ((this instanceof BasicDomain || this instanceof CollectionDomain || this instanceof MapDomain || this instanceof GraphClass) && !this.parentPackage.isDefaultPackage()) {
            throw new SchemaException("Invalid parent package '" + packageImpl.getQualifiedName() + "'.\n" + "The parent package for BasicDomains (Boolean, Double, Integer, Long, String),\n" + "CollectionDomains (List, Set) and GraphClasses must be the DefaultPackage.");
        }
        if (schemaImpl.knows(this.qualifiedName)) {
            throw new SchemaException("The Schema already contains a named element with qualified name '" + this.qualifiedName + "'.");
        }
        schemaImpl.addNamedElement(this);
        this.comments = new ArrayList<String>();
    }

    @Override
    public String toString() {
        return this.getQualifiedName();
    }

    @Override
    public int compareTo(NamedElement namedElement) {
        return this.qualifiedName.compareTo(namedElement.getQualifiedName());
    }

    @Override
    public final String getFileName() {
        return this.qualifiedName.replace('.', File.separatorChar);
    }

    @Override
    public final Package getPackage() {
        return this.parentPackage;
    }

    @Override
    public final String getPackageName() {
        return this.parentPackage != null ? this.parentPackage.getQualifiedName() : null;
    }

    @Override
    public final String getPathName() {
        return this.parentPackage != null ? this.getPackageName().replace('.', File.separatorChar) : null;
    }

    @Override
    public final String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public final String getQualifiedName(Package package_) {
        if (this.parentPackage == package_) {
            return this.simpleName;
        }
        if (this.parentPackage.isDefaultPackage()) {
            return "." + this.simpleName;
        }
        return this.qualifiedName;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public final String getSimpleName() {
        return this.simpleName;
    }

    @Override
    public String getUniqueName() {
        for (NamedElement namedElement : this.schema.namedElements.values()) {
            if (!namedElement.getSimpleName().equals(this.simpleName) || namedElement == this) continue;
            return NamedElementImpl.toUniqueNameNotation(this.qualifiedName);
        }
        return this.simpleName;
    }

    public final int hashCode() {
        return this.qualifiedName.hashCode() + this.schema.hashCode();
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof NamedElement)) {
            return false;
        }
        NamedElementImpl namedElementImpl = (NamedElementImpl)object;
        return this.schema.equals(namedElementImpl.schema) && this.qualifiedName.equals(namedElementImpl.qualifiedName);
    }

    public static String toUniqueNameNotation(String string) {
        return string.replace('.', '$');
    }

    @Override
    public List<String> getComments() {
        return Collections.unmodifiableList(this.comments);
    }

    @Override
    public void addComment(String string) {
        this.schema.assertNotFinished();
        if (string == null) {
            return;
        }
        if ((string = string.trim()).length() > 0) {
            if (this.comments == null) {
                this.comments = new ArrayList<String>();
            }
            this.comments.add(string);
        }
    }

    @Override
    public void setQualifiedName(String string) {
        throw new UnsupportedOperationException("Renaming not allowed for " + this.getClass().getName());
    }

    protected void register() {
        this.schema.namedElements.put(this.qualifiedName, this);
    }

    protected void unregister() {
        this.schema.namedElements.remove(this.qualifiedName);
    }
}

