/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.exception.TemporaryGraphElementException;
import de.uni_koblenz.jgralab.impl.GraphBaseImpl;
import de.uni_koblenz.jgralab.impl.InternalGraphElement;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.Schema;

public abstract class GraphElementImpl<SC extends GraphElementClass<SC, IC>, IC extends GraphElement<SC, IC>>
implements InternalGraphElement<SC, IC> {
    protected int id;
    protected GraphBaseImpl graph;

    protected GraphElementImpl(Graph graph) {
        assert (graph != null);
        this.graph = (GraphBaseImpl)graph;
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public GraphClass getGraphClass() {
        return this.graph.getAttributedElementClass();
    }

    @Override
    public Schema getSchema() {
        return this.graph.getSchema();
    }

    @Override
    public void graphModified() {
        this.graph.graphModified();
    }

    public void ecaAttributeChanging(String string, Object object, Object object2) {
        if (!this.graph.isLoading() && this.graph.hasECARuleManager()) {
            this.graph.getECARuleManager().fireBeforeChangeAttributeEvents(this, string, object, object2);
        }
    }

    public void ecaAttributeChanged(String string, Object object, Object object2) {
        if (!this.graph.isLoading() && this.graph.hasECARuleManager()) {
            this.graph.getECARuleManager().fireAfterChangeAttributeEvents(this, string, object, object2);
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void initializeAttributesWithDefaultValues() {
        for (Attribute attribute : ((GraphElementClass)this.getAttributedElementClass()).getAttributeList()) {
            if (attribute.getDefaultValueAsString() == null) continue;
            try {
                this.internalSetDefaultValue(attribute);
            }
            catch (GraphIOException graphIOException) {
                graphIOException.printStackTrace();
            }
        }
    }

    @Override
    public void internalSetDefaultValue(Attribute attribute) throws GraphIOException {
        attribute.setDefaultValue(this);
    }

    @Override
    public boolean isInstanceOf(SC SC) {
        return SC.getSchemaClass().isInstance(this);
    }

    @Override
    public boolean isTemporary() {
        return false;
    }

    @Override
    public IC bless() {
        return (IC)this;
    }

    @Override
    public IC bless(SC SC) {
        if (((GraphElementClass)this.getAttributedElementClass()).equals(SC)) {
            return (IC)this;
        }
        throw new TemporaryGraphElementException("The graph element " + this + " is not a TemporaryElement and can not be blessed to " + SC + ".");
    }
}

