/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphFactory;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.GraphStructureChangedListener;
import de.uni_koblenz.jgralab.GraphStructureChangedListenerWithAutoRemove;
import de.uni_koblenz.jgralab.ProgressFunction;
import de.uni_koblenz.jgralab.Record;
import de.uni_koblenz.jgralab.TraversalContext;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.VertexFilter;
import de.uni_koblenz.jgralab.eca.ECARuleManagerInterface;
import de.uni_koblenz.jgralab.exception.GraphException;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.graphmarker.SubGraphMarker;
import de.uni_koblenz.jgralab.impl.EdgeBaseImpl;
import de.uni_koblenz.jgralab.impl.EdgeIterable;
import de.uni_koblenz.jgralab.impl.FreeIndexList;
import de.uni_koblenz.jgralab.impl.InternalEdge;
import de.uni_koblenz.jgralab.impl.InternalGraph;
import de.uni_koblenz.jgralab.impl.InternalVertex;
import de.uni_koblenz.jgralab.impl.RandomIdGenerator;
import de.uni_koblenz.jgralab.impl.ReversedEdgeBaseImpl;
import de.uni_koblenz.jgralab.impl.VertexBaseImpl;
import de.uni_koblenz.jgralab.impl.VertexIterable;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.EnumDomain;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.io.DataOutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public abstract class GraphBaseImpl
implements Graph,
InternalGraph {
    private String id;
    private final Schema schema;
    protected GraphFactory graphFactory;
    private long graphVersion;
    private boolean loading;
    protected int vMax;
    protected FreeIndexList freeVertexList;
    protected int eMax;
    protected FreeIndexList freeEdgeList;
    private ThreadLocal<TraversalContext> tc = new ThreadLocal();
    private ECARuleManagerInterface ecaRuleManager;
    protected List<WeakReference<GraphStructureChangedListener>> graphStructureChangedListenersWithAutoRemoval = null;
    protected List<GraphStructureChangedListener> graphStructureChangedListeners = new ArrayList<GraphStructureChangedListener>();

    protected GraphBaseImpl(String string, GraphClass graphClass) {
        this(string, graphClass, 1000, 1000);
    }

    @Override
    public void initializeAttributesWithDefaultValues() {
        for (Attribute attribute : this.getAttributedElementClass().getAttributeList()) {
            try {
                if (attribute.getDefaultValueAsString() == null || attribute.getDefaultValueAsString().isEmpty()) continue;
                this.internalSetDefaultValue(attribute);
            }
            catch (GraphIOException graphIOException) {
                graphIOException.printStackTrace();
            }
        }
    }

    @Override
    public void internalSetDefaultValue(Attribute attribute) throws GraphIOException {
        attribute.setDefaultValue(this);
    }

    protected GraphBaseImpl(String string, GraphClass graphClass, int n, int n2) {
        if (n < 1) {
            throw new GraphException("vMax must not be less than 1", null);
        }
        if (n2 < 1) {
            throw new GraphException("eMax must not be less than 1", null);
        }
        this.schema = graphClass.getSchema();
        this.setId(string == null ? RandomIdGenerator.generateId() : string);
        this.graphVersion = -1L;
        this.setGraphVersion(0L);
        this.expandVertexArray(n);
        this.setFirstVertex(null);
        this.setLastVertex(null);
        this.setVCount(0);
        this.setDeleteVertexList(new LinkedList<InternalVertex>());
        this.expandEdgeArray(n2);
        this.setFirstEdgeInGraph(null);
        this.setLastEdgeInGraph(null);
        this.setECount(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void addEdge(Edge edge, Vertex vertex, Vertex vertex2) {
        assert (edge != null);
        assert (vertex != null && vertex.isValid() && this.vSeqContainsVertex(vertex)) : "Alpha vertex is invalid";
        assert (vertex2 != null && vertex2.isValid() && this.vSeqContainsVertex(vertex2)) : "Omega vertex is invalid";
        assert (edge.isNormal()) : "Can't add reversed edge";
        assert (vertex.getSchema() == vertex2.getSchema() && vertex.getSchema() == this.schema && edge.getSchema() == this.schema) : "The schemas of alpha, omega, newEdge and this graph don't match!";
        assert (vertex.getGraph() == vertex2.getGraph() && vertex.getGraph() == this && edge.getGraph() == this) : "The graph of alpha, omega, newEdge and this graph don't match!";
        EdgeBaseImpl edgeBaseImpl = (EdgeBaseImpl)edge;
        InternalVertex internalVertex = (InternalVertex)vertex;
        InternalVertex internalVertex2 = (InternalVertex)vertex2;
        EdgeClass edgeClass = edge.getAttributedElementClass();
        VertexClass vertexClass = internalVertex.getAttributedElementClass();
        if (!vertexClass.isValidFromFor(edgeClass)) {
            throw new GraphException("Edges of class " + edgeClass.getQualifiedName() + " may not start at vertices of class " + vertexClass.getQualifiedName());
        }
        VertexClass vertexClass2 = internalVertex2.getAttributedElementClass();
        if (!vertexClass2.isValidToFor(edgeClass)) {
            throw new GraphException("Edges of class " + edgeClass.getQualifiedName() + " may not end at vertices of class " + vertexClass2.getQualifiedName());
        }
        int n = edgeBaseImpl.getId();
        if (this.isLoading()) {
            if (n <= 0) throw new GraphException("can not load an edge with id <= 0");
            if (this.containsEdgeId(n)) {
                throw new GraphException("edge with id " + edgeBaseImpl.getId() + " already exists");
            }
            if (n > this.eMax) {
                throw new GraphException("edge id " + edgeBaseImpl.getId() + " is bigger than eSize");
            }
        } else {
            if (!this.canAddGraphElement(n)) {
                throw new GraphException("can not add an edge with id != 0");
            }
            n = this.allocateEdgeIndex(n);
            assert (n != 0);
            edgeBaseImpl.setId(n);
            internalVertex.appendIncidenceToISeq(edgeBaseImpl);
            internalVertex2.appendIncidenceToISeq(edgeBaseImpl.reversedEdge);
        }
        this.appendEdgeToESeq(edgeBaseImpl);
        if (this.isLoading()) return;
        internalVertex.incidenceListModified();
        internalVertex2.incidenceListModified();
        this.edgeListModified();
        this.internalEdgeAdded(edgeBaseImpl);
    }

    @Override
    public final void internalEdgeAdded(InternalEdge internalEdge) {
        this.notifyEdgeAdded(internalEdge);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void addVertex(Vertex vertex) {
        InternalVertex internalVertex = (InternalVertex)vertex;
        int n = internalVertex.getId();
        if (this.isLoading()) {
            if (n <= 0) throw new GraphException("can not load a vertex with id <= 0");
            if (this.containsVertexId(n)) {
                throw new GraphException("vertex with id " + n + " already exists");
            }
            if (n > this.vMax) {
                throw new GraphException("vertex id " + n + " is bigger than vSize");
            }
        } else {
            if (!this.canAddGraphElement(n)) {
                throw new GraphException("can not add a vertex with vId " + n);
            }
            n = this.allocateVertexIndex(n);
            assert (n != 0);
            internalVertex.setId(n);
        }
        this.appendVertexToVSeq(internalVertex);
        if (this.isLoading()) return;
        this.vertexListModified();
        this.internalVertexAdded(internalVertex);
    }

    private final boolean canAddGraphElement(int n) {
        return n == 0;
    }

    @Override
    public void internalVertexAdded(InternalVertex internalVertex) {
        this.notifyVertexAdded(internalVertex);
    }

    @Override
    public final void appendEdgeToESeq(InternalEdge internalEdge) {
        this.getEdge()[((EdgeBaseImpl)internalEdge).id] = internalEdge;
        this.getRevEdge()[((EdgeBaseImpl)internalEdge).id] = ((EdgeBaseImpl)internalEdge).reversedEdge;
        this.setECount(this.getECountInESeq() + 1);
        if (this.getFirstEdgeInESeq() == null) {
            this.setFirstEdgeInGraph(internalEdge);
        }
        if (this.getLastEdgeInESeq() != null) {
            this.getLastEdgeInESeq().setNextEdgeInGraph(internalEdge);
            internalEdge.setPrevEdgeInGraph(this.getLastEdgeInESeq());
        }
        this.setLastEdgeInGraph(internalEdge);
    }

    @Override
    public final void appendVertexToVSeq(InternalVertex internalVertex) {
        this.getVertex()[((VertexBaseImpl)internalVertex).id] = internalVertex;
        this.setVCount(this.getVCountInVSeq() + 1);
        if (this.getFirstVertexInVSeq() == null) {
            this.setFirstVertex(internalVertex);
        }
        if (this.getLastVertexInVSeq() != null) {
            this.getLastVertexInVSeq().setNextVertex(internalVertex);
            internalVertex.setPrevVertex(this.getLastVertexInVSeq());
        }
        this.setLastVertex(internalVertex);
    }

    @Override
    public final int getExpandedVertexCount() {
        return this.computeNewSize(this.vMax);
    }

    private final int computeNewSize(int n) {
        return n >= 0x100000 ? n + 131072 : (n >= 262144 ? n + 262144 : n + n);
    }

    @Override
    public final int getExpandedEdgeCount() {
        return this.computeNewSize(this.eMax);
    }

    @Override
    public final int compareTo(AttributedElement<GraphClass, Graph> attributedElement) {
        if (attributedElement == this) {
            return 0;
        }
        if (attributedElement instanceof Graph) {
            Graph graph = (Graph)attributedElement;
            int n = this.hashCode() - graph.hashCode();
            if (n == 0) {
                return this.id.compareTo(graph.getId());
            }
            return n;
        }
        return -1;
    }

    @Override
    public final boolean containsEdge(Edge edge) {
        return this.getTraversalContext() == null ? this.eSeqContainsEdge(edge) : this.eSeqContainsEdge(edge) && this.getTraversalContext().containsEdge(edge);
    }

    @Override
    public final boolean eSeqContainsEdge(Edge edge) {
        return edge != null && edge.getGraph() == this && this.containsEdgeId(((EdgeBaseImpl)edge.getNormalEdge()).id) && this.getEdge(((EdgeBaseImpl)edge.getNormalEdge()).id) == edge.getNormalEdge();
    }

    private final boolean containsEdgeId(int n) {
        if (n < 0) {
            n = -n;
        }
        return n > 0 && n <= this.eMax && this.getEdge()[n] != null && this.getRevEdge()[n] != null;
    }

    @Override
    public final boolean containsVertex(Vertex vertex) {
        return this.getTraversalContext() == null ? this.vSeqContainsVertex(vertex) : this.vSeqContainsVertex(vertex) && this.getTraversalContext().containsVertex(vertex);
    }

    @Override
    public final boolean vSeqContainsVertex(Vertex vertex) {
        return vertex != null && vertex.getGraph() == this && this.containsVertexId(((VertexBaseImpl)vertex).id) && this.getVertex()[((VertexBaseImpl)vertex).id] == vertex;
    }

    private final boolean containsVertexId(int n) {
        return n > 0 && n <= this.vMax && this.getVertex()[n] != null;
    }

    @Override
    public <T extends Edge> T createEdge(EdgeClass edgeClass, Vertex vertex, Vertex vertex2) {
        try {
            return (T)this.graphFactory.createEdge(edgeClass, 0, this, vertex, vertex2);
        }
        catch (Exception exception) {
            if (exception instanceof GraphException) {
                throw (GraphException)exception;
            }
            throw new GraphException("Error creating edge of class " + edgeClass.getQualifiedName(), exception);
        }
    }

    @Override
    public <T extends Vertex> T createVertex(VertexClass vertexClass) {
        try {
            return (T)this.graphFactory.createVertex(vertexClass, 0, this);
        }
        catch (Exception exception) {
            if (exception instanceof GraphException) {
                throw (GraphException)exception;
            }
            throw new GraphException("Error creating vertex of class " + vertexClass.getQualifiedName(), exception);
        }
    }

    @Override
    public final void deleteEdge(Edge edge) {
        assert (edge != null && edge.isValid() && this.eSeqContainsEdge(edge));
        this.internalDeleteEdge(edge);
        this.edgeListModified();
    }

    @Override
    public final void deleteVertex(Vertex vertex) {
        assert (vertex != null && vertex.isValid() && this.vSeqContainsVertex(vertex));
        this.getDeleteVertexList().add((InternalVertex)vertex);
        this.internalDeleteVertex();
    }

    @Override
    public final void edgeListModified() {
        this.setEdgeListVersion(this.getEdgeListVersion() + 1L);
        this.setGraphVersion(this.getGraphVersion() + 1L);
    }

    @Override
    public final Iterable<Edge> edges() {
        return new EdgeIterable<Edge>(this);
    }

    @Override
    public final Iterable<Edge> edges(EdgeClass edgeClass) {
        return new EdgeIterable<Edge>(this, edgeClass);
    }

    @Override
    public final void expandEdgeArray(int n) {
        if (n <= this.eMax) {
            throw new GraphException("newSize must be > eSize: eSize=" + this.eMax + ", newSize=" + n);
        }
        InternalEdge[] internalEdgeArray = new InternalEdge[n + 1];
        if (this.getEdge() != null) {
            System.arraycopy(this.getEdge(), 0, internalEdgeArray, 0, this.getEdge().length);
        }
        this.setEdge(internalEdgeArray);
        InternalEdge[] internalEdgeArray2 = new ReversedEdgeBaseImpl[n + 1];
        if (this.getRevEdge() != null) {
            System.arraycopy(this.getRevEdge(), 0, internalEdgeArray2, 0, this.getRevEdge().length);
        }
        this.setRevEdge(internalEdgeArray2);
        if (this.getFreeEdgeList() == null) {
            this.freeEdgeList = new FreeIndexList(n);
        } else {
            this.getFreeEdgeList().expandBy(n - this.eMax);
        }
        this.eMax = n;
        this.notifyMaxEdgeCountIncreased(n);
    }

    @Override
    public final void expandVertexArray(int n) {
        if (n <= this.vMax) {
            throw new GraphException("newSize must > vSize: vSize=" + this.vMax + ", newSize=" + n);
        }
        InternalVertex[] internalVertexArray = new InternalVertex[n + 1];
        if (this.getVertex() != null) {
            System.arraycopy(this.getVertex(), 0, internalVertexArray, 0, this.getVertex().length);
        }
        if (this.getFreeVertexList() == null) {
            this.freeVertexList = new FreeIndexList(n);
        } else {
            this.getFreeVertexList().expandBy(n - this.vMax);
        }
        this.setVertex(internalVertexArray);
        this.vMax = n;
        this.notifyMaxVertexCountIncreased(n);
    }

    @Override
    public final int getECount() {
        TraversalContext traversalContext = this.getTraversalContext();
        if (traversalContext == null) {
            return this.getECountInESeq();
        }
        if (traversalContext instanceof SubGraphMarker) {
            return ((SubGraphMarker)traversalContext).getECount();
        }
        int n = 0;
        for (Edge edge = this.getFirstEdge(); edge != null; edge = edge.getNextEdge()) {
            ++n;
        }
        return n;
    }

    @Override
    public final Edge getEdge(int n) {
        assert (n != 0) : "The edge id must be != 0, given was " + n;
        try {
            return n < 0 ? this.getRevEdge()[-n] : this.getEdge()[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public final Edge getFirstEdge() {
        TraversalContext traversalContext = this.getTraversalContext();
        Edge edge = this.getFirstEdgeInESeq();
        if (traversalContext != null && edge != null && !traversalContext.containsEdge(edge)) {
            edge = edge.getNextEdge();
        }
        return edge;
    }

    @Override
    public final Edge getLastEdge() {
        TraversalContext traversalContext = this.getTraversalContext();
        Edge edge = this.getLastEdgeInESeq();
        if (traversalContext != null && edge != null && !traversalContext.containsEdge(edge)) {
            edge = edge.getPrevEdge();
        }
        return edge;
    }

    @Override
    public final Edge getFirstEdge(EdgeClass edgeClass) {
        assert (edgeClass != null);
        Edge edge = this.getFirstEdge();
        if (edge == null) {
            return null;
        }
        if (edge.isInstanceOf(edgeClass)) {
            return edge;
        }
        return edge.getNextEdge(edgeClass);
    }

    @Override
    public final Vertex getFirstVertex() {
        TraversalContext traversalContext = this.getTraversalContext();
        Vertex vertex = this.getFirstVertexInVSeq();
        if (traversalContext != null && vertex != null && !traversalContext.containsVertex(vertex)) {
            vertex = vertex.getNextVertex();
        }
        return vertex;
    }

    @Override
    public final Vertex getLastVertex() {
        TraversalContext traversalContext = this.getTraversalContext();
        Vertex vertex = this.getLastVertexInVSeq();
        if (traversalContext != null && vertex != null && !traversalContext.containsVertex(vertex)) {
            vertex = vertex.getPrevVertex();
        }
        return vertex;
    }

    @Override
    public final Vertex getFirstVertex(VertexClass vertexClass) {
        assert (vertexClass != null);
        Vertex vertex = this.getFirstVertex();
        if (vertex == null) {
            return null;
        }
        if (vertex.isInstanceOf(vertexClass)) {
            return vertex;
        }
        return vertex.getNextVertex(vertexClass);
    }

    @Override
    public final GraphClass getGraphClass() {
        return this.getAttributedElementClass();
    }

    @Override
    public long getGraphVersion() {
        return this.graphVersion;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getMaxECount() {
        return this.eMax;
    }

    @Override
    public int getMaxVCount() {
        return this.vMax;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public int getVCount() {
        TraversalContext traversalContext = this.getTraversalContext();
        if (traversalContext == null) {
            return this.getVCountInVSeq();
        }
        if (traversalContext instanceof SubGraphMarker) {
            return ((SubGraphMarker)traversalContext).getVCount();
        }
        int n = 0;
        for (Vertex vertex = this.getFirstVertex(); vertex != null; vertex = vertex.getNextVertex()) {
            ++n;
        }
        return n;
    }

    @Override
    public Vertex getVertex(int n) {
        assert (n > 0) : "The vertex id must be > 0, given was " + n;
        try {
            return this.getVertex()[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public void graphModified() {
        this.setGraphVersion(this.getGraphVersion() + 1L);
    }

    @Override
    public final void ecaAttributeChanging(String string, Object object, Object object2) {
        if (!this.isLoading()) {
            this.getECARuleManager().fireBeforeChangeAttributeEvents(this, string, object, object2);
        }
    }

    @Override
    public final void ecaAttributeChanged(String string, Object object, Object object2) {
        if (!this.isLoading()) {
            this.getECARuleManager().fireAfterChangeAttributeEvents(this, string, object, object2);
        }
    }

    private final void internalDeleteEdge(Edge edge) {
        assert (edge != null && edge.isValid() && this.eSeqContainsEdge(edge));
        if (this.hasECARuleManager()) {
            this.getECARuleManager().fireBeforeDeleteEdgeEvents(edge);
        }
        InternalEdge internalEdge = (InternalEdge)edge.getNormalEdge();
        if (this.hasECARuleManager()) {
            this.getECARuleManager().fireBeforeDeleteEdgeEvents(edge);
        }
        internalEdge = (InternalEdge)edge.getNormalEdge();
        this.internalEdgeDeleted(internalEdge);
        InternalVertex internalVertex = internalEdge.getIncidentVertex();
        internalVertex.removeIncidenceFromISeq(internalEdge);
        internalVertex.incidenceListModified();
        InternalVertex internalVertex2 = ((EdgeBaseImpl)internalEdge).reversedEdge.getIncidentVertex();
        internalVertex2.removeIncidenceFromISeq(((EdgeBaseImpl)internalEdge).reversedEdge);
        internalVertex2.incidenceListModified();
        this.removeEdgeFromESeq(internalEdge);
        this.edgeListModified();
        if (this.hasECARuleManager()) {
            this.getECARuleManager().fireAfterDeleteEdgeEvents(internalEdge.getAttributedElementClass(), internalVertex, internalVertex2);
        }
    }

    @Override
    public final void internalEdgeDeleted(InternalEdge internalEdge) {
        assert (internalEdge != null);
        this.notifyEdgeDeleted(internalEdge);
    }

    private final void internalDeleteVertex() {
        while (!this.getDeleteVertexList().isEmpty()) {
            InternalVertex internalVertex = this.getDeleteVertexList().remove(0);
            assert (internalVertex != null && internalVertex.isValid() && this.vSeqContainsVertex(internalVertex));
            if (this.hasECARuleManager()) {
                this.getECARuleManager().fireBeforeDeleteVertexEvents(internalVertex);
            }
            this.internalVertexDeleted(internalVertex);
            Edge edge = internalVertex.getFirstIncidence();
            while (edge != null) {
                InternalVertex internalVertex2;
                assert (edge.isValid() && this.eSeqContainsEdge(edge));
                if (edge.getThatAggregationKind() == AggregationKind.COMPOSITE && (internalVertex2 = (InternalVertex)edge.getThat()) != internalVertex && this.vSeqContainsVertex(internalVertex2) && !this.getDeleteVertexList().contains(internalVertex2)) {
                    this.getDeleteVertexList().add(internalVertex2);
                }
                this.deleteEdge(edge);
                edge = internalVertex.getFirstIncidence();
            }
            this.removeVertexFromVSeq(internalVertex);
            this.vertexListModified();
            if (!this.hasECARuleManager()) continue;
            this.getECARuleManager().fireAfterDeleteVertexEvents(internalVertex.getAttributedElementClass());
        }
    }

    @Override
    public final void internalVertexDeleted(InternalVertex internalVertex) {
        assert (internalVertex != null);
        this.notifyVertexDeleted(internalVertex);
    }

    @Override
    public final void removeVertexFromVSeq(InternalVertex internalVertex) {
        assert (internalVertex != null);
        if (internalVertex == this.getFirstVertexInVSeq()) {
            this.setFirstVertex(internalVertex.getNextVertexInVSeq());
            if (this.getFirstVertexInVSeq() != null) {
                this.getFirstVertexInVSeq().setPrevVertex(null);
            }
            if (internalVertex == this.getLastVertexInVSeq()) {
                this.setLastVertex(null);
            }
        } else if (internalVertex == this.getLastVertexInVSeq()) {
            this.setLastVertex(internalVertex.getPrevVertexInVSeq());
            if (this.getLastVertexInVSeq() != null) {
                this.getLastVertexInVSeq().setNextVertex(null);
            }
        } else {
            internalVertex.getPrevVertexInVSeq().setNextVertex(internalVertex.getNextVertexInVSeq());
            internalVertex.getNextVertexInVSeq().setPrevVertex(internalVertex.getPrevVertexInVSeq());
        }
        this.freeVertexIndex(internalVertex.getId());
        this.getVertex()[internalVertex.getId()] = null;
        internalVertex.setPrevVertex(null);
        internalVertex.setNextVertex(null);
        internalVertex.setId(0);
        this.setVCount(this.getVCountInVSeq() - 1);
    }

    @Override
    public final void removeEdgeFromESeq(InternalEdge internalEdge) {
        assert (internalEdge != null);
        this.removeEdgeFromESeqWithoutDeletingIt(internalEdge);
        this.freeEdgeIndex(internalEdge.getId());
        this.getEdge()[internalEdge.getId()] = null;
        this.getRevEdge()[internalEdge.getId()] = null;
        internalEdge.setPrevEdgeInGraph(null);
        internalEdge.setNextEdgeInGraph(null);
        internalEdge.setId(0);
        this.setECount(this.getECountInESeq() - 1);
    }

    private final void removeEdgeFromESeqWithoutDeletingIt(InternalEdge internalEdge) {
        if (internalEdge == this.getFirstEdgeInESeq()) {
            this.setFirstEdgeInGraph(internalEdge.getNextEdgeInESeq());
            if (this.getFirstEdgeInESeq() != null) {
                this.getFirstEdgeInESeq().setPrevEdgeInGraph(null);
            }
            if (internalEdge == this.getLastEdgeInESeq()) {
                this.setLastEdgeInGraph(null);
            }
        } else if (internalEdge == this.getLastEdgeInESeq()) {
            this.setLastEdgeInGraph(internalEdge.getPrevEdgeInESeq());
            if (this.getLastEdgeInESeq() != null) {
                this.getLastEdgeInESeq().setNextEdgeInGraph(null);
            }
        } else {
            internalEdge.getPrevEdgeInESeq().setNextEdgeInGraph(internalEdge.getNextEdgeInESeq());
            internalEdge.getNextEdgeInESeq().setPrevEdgeInGraph(internalEdge.getPrevEdgeInESeq());
        }
    }

    @Override
    public final boolean isEdgeListModified(long l) {
        return this.getEdgeListVersion() != l;
    }

    @Override
    public final boolean isGraphModified(long l) {
        return this.getGraphVersion() != l;
    }

    @Override
    public final boolean isLoading() {
        return this.loading;
    }

    @Override
    public final boolean isVertexListModified(long l) {
        return this.getVertexListVersion() != l;
    }

    @Override
    public final void internalLoadingCompleted(int[] nArray, int[] nArray2) {
        this.getFreeVertexList().reinitialize(this.getVertex());
        this.getFreeEdgeList().reinitialize(this.getEdge());
        for (int i = 1; i < this.getVertex().length; ++i) {
            InternalVertex internalVertex = this.getVertex()[i];
            if (internalVertex == null) continue;
            int n = nArray[i];
            while (n != 0) {
                internalVertex.appendIncidenceToISeq(n < 0 ? this.getRevEdge()[-n] : this.getEdge()[n]);
                n = nArray2[this.eMax + n];
            }
        }
    }

    @Override
    public final void putEdgeAfterInGraph(InternalEdge internalEdge, InternalEdge internalEdge2) {
        assert (internalEdge != null && internalEdge.isValid() && this.eSeqContainsEdge(internalEdge));
        assert (internalEdge2 != null && internalEdge2.isValid() && this.eSeqContainsEdge(internalEdge2));
        assert (internalEdge != internalEdge2);
        if (internalEdge == internalEdge2 || internalEdge.getNextEdgeInESeq() == internalEdge2) {
            return;
        }
        assert (this.getFirstEdgeInESeq() != this.getLastEdgeInESeq());
        if (internalEdge2 == this.getFirstEdgeInESeq()) {
            this.setFirstEdgeInGraph(internalEdge2.getNextEdgeInESeq());
            internalEdge2.getNextEdgeInESeq().setPrevEdgeInGraph(null);
        } else if (internalEdge2 == this.getLastEdgeInESeq()) {
            this.setLastEdgeInGraph(internalEdge2.getPrevEdgeInESeq());
            internalEdge2.getPrevEdgeInESeq().setNextEdgeInGraph(null);
        } else {
            internalEdge2.getPrevEdgeInESeq().setNextEdgeInGraph(internalEdge2.getNextEdgeInESeq());
            internalEdge2.getNextEdgeInESeq().setPrevEdgeInGraph(internalEdge2.getPrevEdgeInESeq());
        }
        if (internalEdge == this.getLastEdgeInESeq()) {
            this.setLastEdgeInGraph(internalEdge2);
            internalEdge2.setNextEdgeInGraph(null);
        } else {
            internalEdge.getNextEdgeInESeq().setPrevEdgeInGraph(internalEdge2);
            internalEdge2.setNextEdgeInGraph(internalEdge.getNextEdgeInESeq());
        }
        internalEdge2.setPrevEdgeInGraph(internalEdge);
        internalEdge.setNextEdgeInGraph(internalEdge2);
        this.edgeListModified();
    }

    @Override
    public final void putVertexAfter(InternalVertex internalVertex, InternalVertex internalVertex2) {
        assert (internalVertex != null && internalVertex.isValid() && this.vSeqContainsVertex(internalVertex));
        assert (internalVertex2 != null && internalVertex2.isValid() && this.vSeqContainsVertex(internalVertex2));
        assert (internalVertex != internalVertex2);
        InternalVertex internalVertex3 = internalVertex.getNextVertexInVSeq();
        if (internalVertex == internalVertex2 || internalVertex3 == internalVertex2) {
            return;
        }
        assert (this.getFirstVertexInVSeq() != this.getLastVertexInVSeq());
        if (internalVertex2 == this.getFirstVertexInVSeq()) {
            InternalVertex internalVertex4 = internalVertex2.getNextVertexInVSeq();
            this.setFirstVertex(internalVertex4);
            internalVertex4.setPrevVertex(null);
        } else if (internalVertex2 == this.getLastVertexInVSeq()) {
            this.setLastVertex(internalVertex2.getPrevVertexInVSeq());
            internalVertex2.getPrevVertexInVSeq().setNextVertex(null);
        } else {
            internalVertex2.getPrevVertexInVSeq().setNextVertex(internalVertex2.getNextVertexInVSeq());
            internalVertex2.getNextVertexInVSeq().setPrevVertex(internalVertex2.getPrevVertexInVSeq());
        }
        if (internalVertex == this.getLastVertexInVSeq()) {
            this.setLastVertex(internalVertex2);
            internalVertex2.setNextVertex(null);
        } else {
            internalVertex.getNextVertexInVSeq().setPrevVertex(internalVertex2);
            internalVertex2.setNextVertex(internalVertex.getNextVertexInVSeq());
        }
        internalVertex2.setPrevVertex(internalVertex);
        internalVertex.setNextVertex(internalVertex2);
        this.vertexListModified();
    }

    @Override
    public final void putEdgeBeforeInGraph(InternalEdge internalEdge, InternalEdge internalEdge2) {
        assert (internalEdge != null && internalEdge.isValid() && this.eSeqContainsEdge(internalEdge));
        assert (internalEdge2 != null && internalEdge2.isValid() && this.eSeqContainsEdge(internalEdge2));
        assert (internalEdge != internalEdge2);
        if (internalEdge == internalEdge2 || internalEdge.getPrevEdgeInESeq() == internalEdge2) {
            return;
        }
        assert (this.getFirstEdgeInESeq() != this.getLastEdgeInESeq());
        this.removeEdgeFromESeqWithoutDeletingIt(internalEdge2);
        if (internalEdge == this.getFirstEdgeInESeq()) {
            this.setFirstEdgeInGraph(internalEdge2);
            internalEdge2.setPrevEdgeInGraph(null);
        } else {
            InternalEdge internalEdge3 = internalEdge.getPrevEdgeInESeq();
            internalEdge3.setNextEdgeInGraph(internalEdge2);
            internalEdge2.setPrevEdgeInGraph(internalEdge3);
        }
        internalEdge2.setNextEdgeInGraph(internalEdge);
        internalEdge.setPrevEdgeInGraph(internalEdge2);
        this.edgeListModified();
    }

    @Override
    public final void putVertexBefore(InternalVertex internalVertex, InternalVertex internalVertex2) {
        assert (internalVertex != null && internalVertex.isValid() && this.vSeqContainsVertex(internalVertex));
        assert (internalVertex2 != null && internalVertex2.isValid() && this.vSeqContainsVertex(internalVertex2));
        assert (internalVertex != internalVertex2);
        InternalVertex internalVertex3 = internalVertex.getPrevVertexInVSeq();
        if (internalVertex == internalVertex2 || internalVertex3 == internalVertex2) {
            return;
        }
        assert (this.getFirstVertexInVSeq() != this.getLastVertexInVSeq());
        if (internalVertex2 == this.getFirstVertexInVSeq()) {
            this.setFirstVertex(internalVertex2.getNextVertexInVSeq());
            internalVertex2.getNextVertexInVSeq().setPrevVertex(null);
        } else if (internalVertex2 == this.getLastVertexInVSeq()) {
            this.setLastVertex(internalVertex2.getPrevVertexInVSeq());
            internalVertex2.getPrevVertexInVSeq().setNextVertex(null);
        } else {
            internalVertex2.getPrevVertexInVSeq().setNextVertex(internalVertex2.getNextVertexInVSeq());
            internalVertex2.getNextVertexInVSeq().setPrevVertex(internalVertex2.getPrevVertexInVSeq());
        }
        if (internalVertex == this.getFirstVertexInVSeq()) {
            this.setFirstVertex(internalVertex2);
            internalVertex2.setPrevVertex(null);
        } else {
            InternalVertex internalVertex4 = internalVertex.getPrevVertexInVSeq();
            internalVertex4.setNextVertex(internalVertex2);
            internalVertex2.setPrevVertex(internalVertex4);
        }
        internalVertex2.setNextVertex(internalVertex);
        internalVertex.setPrevVertex(internalVertex2);
        this.vertexListModified();
    }

    @Override
    public final void setGraphVersion(long l) {
        this.graphVersion = l;
    }

    @Override
    public final void setId(String string) {
        this.id = string;
    }

    @Override
    public final void setLoading(boolean bl) {
        this.loading = bl;
    }

    @Override
    public final void vertexListModified() {
        this.setVertexListVersion(this.getVertexListVersion() + 1L);
        this.setGraphVersion(this.getGraphVersion() + 1L);
    }

    @Override
    public final Iterable<Vertex> vertices() {
        return new VertexIterable<Vertex>(this, null, null);
    }

    @Override
    public final Iterable<Vertex> vertices(VertexFilter<Vertex> vertexFilter) {
        return new VertexIterable<Vertex>(this, null, vertexFilter);
    }

    @Override
    public final Iterable<Vertex> vertices(VertexClass vertexClass) {
        return new VertexIterable<Vertex>(this, vertexClass, null);
    }

    @Override
    public final Iterable<Vertex> vertices(VertexClass vertexClass, VertexFilter<Vertex> vertexFilter) {
        return new VertexIterable<Vertex>(this, vertexClass, vertexFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void defragment() {
        TraversalContext traversalContext = this.setTraversalContext(null);
        try {
            InternalVertex[] internalVertexArray;
            int n;
            if (this.getVCountInVSeq() < this.vMax) {
                if (this.getVCountInVSeq() > 0) {
                    n = this.vMax;
                    while (this.getFreeVertexList().isFragmented()) {
                        while (n >= 1 && this.getVertex()[n] == null) {
                            --n;
                        }
                        assert (n >= 1);
                        internalVertexArray = this.getVertex()[n];
                        this.getVertex()[n] = null;
                        this.getFreeVertexList().freeIndex(n);
                        int n2 = this.allocateVertexIndex(n);
                        assert (n2 < n);
                        internalVertexArray.setId(n2);
                        this.getVertex()[n2] = internalVertexArray;
                        --n;
                    }
                }
                int n3 = n = this.getVCountInVSeq() == 0 ? 1 : this.getVCountInVSeq();
                if (n != this.vMax) {
                    this.vMax = n;
                    internalVertexArray = new InternalVertex[this.vMax + 1];
                    System.arraycopy(this.getVertex(), 0, internalVertexArray, 0, internalVertexArray.length);
                    this.setVertex(internalVertexArray);
                }
                this.graphModified();
            }
            if (this.getECountInESeq() < this.eMax) {
                if (this.getECountInESeq() > 0) {
                    n = this.eMax;
                    while (this.getFreeEdgeList().isFragmented()) {
                        while (n >= 1 && this.getEdge()[n] == null) {
                            --n;
                        }
                        assert (n >= 1);
                        internalVertexArray = this.getEdge()[n];
                        this.getEdge()[n] = null;
                        InternalEdge internalEdge = this.getRevEdge()[n];
                        this.getRevEdge()[n] = null;
                        this.getFreeEdgeList().freeIndex(n);
                        int n4 = this.allocateEdgeIndex(n);
                        assert (n4 < n);
                        internalVertexArray.setId(n4);
                        this.getEdge()[n4] = internalVertexArray;
                        this.getRevEdge()[n4] = internalEdge;
                        --n;
                    }
                }
                int n5 = n = this.getECountInESeq() == 0 ? 1 : this.getECountInESeq();
                if (n != this.eMax) {
                    this.eMax = n;
                    internalVertexArray = new InternalEdge[this.eMax + 1];
                    System.arraycopy(this.getEdge(), 0, internalVertexArray, 0, internalVertexArray.length);
                    this.setEdge((InternalEdge[])internalVertexArray);
                }
                this.graphModified();
            }
        }
        finally {
            this.setTraversalContext(traversalContext);
        }
    }

    @Override
    public final void sortVertices(Comparator<Vertex> comparator) {
        Object object;
        if (this.getFirstVertexInVSeq() == null) {
            return;
        }
        final class VertexList {
            InternalVertex first;
            InternalVertex last;

            VertexList() {
            }

            public void add(InternalVertex internalVertex) {
                if (this.first == null) {
                    this.first = internalVertex;
                    assert (this.last == null);
                    this.last = internalVertex;
                } else {
                    internalVertex.setPrevVertex(this.last);
                    this.last.setNextVertex(internalVertex);
                    this.last = internalVertex;
                }
                internalVertex.setNextVertex(null);
            }

            public InternalVertex remove() {
                if (this.first == null) {
                    throw new NoSuchElementException();
                }
                if (this.first == this.last) {
                    InternalVertex internalVertex = this.first;
                    this.first = null;
                    this.last = null;
                    return internalVertex;
                }
                InternalVertex internalVertex = this.first;
                this.first = internalVertex.getNextVertexInVSeq();
                this.first.setPrevVertex(null);
                return internalVertex;
            }

            public boolean isEmpty() {
                assert (this.first == null == (this.last == null));
                return this.first == null;
            }
        }
        Object object2 = new VertexList();
        VertexList vertexList = new VertexList();
        Object object3 = object2;
        VertexList vertexList2 = new VertexList();
        vertexList2.first = this.getFirstVertexInVSeq();
        vertexList2.last = this.getLastVertexInVSeq();
        InternalVertex internalVertex = vertexList2.remove();
        ((VertexList)object3).add(internalVertex);
        while (!vertexList2.isEmpty()) {
            object = vertexList2.remove();
            if (comparator.compare((Vertex)object, internalVertex) < 0) {
                object3 = object3 == object2 ? vertexList : object2;
            }
            ((VertexList)object3).add((InternalVertex)object);
            internalVertex = object;
        }
        if (((VertexList)object2).isEmpty() || vertexList.isEmpty()) {
            object3 = ((VertexList)object2).isEmpty() ? vertexList : object2;
            this.setFirstVertex(((VertexList)object3).first);
            this.setLastVertex(((VertexList)object3).last);
            return;
        }
        while (true) {
            if (((VertexList)object2).isEmpty() || vertexList.isEmpty()) {
                object3 = ((VertexList)object2).isEmpty() ? vertexList : object2;
                this.setFirstVertex(((VertexList)object3).first);
                this.setLastVertex(((VertexList)object3).last);
                this.edgeListModified();
                return;
            }
            object = new VertexList();
            VertexList vertexList3 = new VertexList();
            object3 = object;
            internalVertex = null;
            while (!((VertexList)object2).isEmpty() && !vertexList.isEmpty()) {
                int n;
                int n2 = internalVertex != null ? comparator.compare(((VertexList)object2).first, internalVertex) : 0;
                int n3 = n = internalVertex != null ? comparator.compare(vertexList.first, internalVertex) : 0;
                if (n2 >= 0 && n >= 0) {
                    if (comparator.compare(((VertexList)object2).first, vertexList.first) <= 0) {
                        internalVertex = ((VertexList)object2).remove();
                        ((VertexList)object3).add(internalVertex);
                        continue;
                    }
                    internalVertex = vertexList.remove();
                    ((VertexList)object3).add(internalVertex);
                    continue;
                }
                if (n2 < 0 && n < 0) {
                    object3 = object3 == object ? vertexList3 : object;
                    internalVertex = null;
                    continue;
                }
                if (n2 < 0 && n >= 0) {
                    internalVertex = vertexList.remove();
                    ((VertexList)object3).add(internalVertex);
                    continue;
                }
                internalVertex = ((VertexList)object2).remove();
                ((VertexList)object3).add(internalVertex);
            }
            while (!((VertexList)object2).isEmpty()) {
                InternalVertex internalVertex2 = ((VertexList)object2).remove();
                if (comparator.compare(internalVertex2, internalVertex) < 0) {
                    object3 = object3 == object ? vertexList3 : object;
                }
                ((VertexList)object3).add(internalVertex2);
                internalVertex = internalVertex2;
            }
            while (!vertexList.isEmpty()) {
                InternalVertex internalVertex3 = vertexList.remove();
                if (comparator.compare(internalVertex3, internalVertex) < 0) {
                    object3 = object3 == object ? vertexList3 : object;
                }
                ((VertexList)object3).add(internalVertex3);
                internalVertex = internalVertex3;
            }
            object2 = object;
            vertexList = vertexList3;
        }
    }

    @Override
    public Object getEnumConstant(EnumDomain enumDomain, String string) {
        Class<? extends Object> clazz = enumDomain.getSchemaClass();
        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
        for (int i = 0; i < enumArray.length; ++i) {
            Enum enum_ = enumArray[i];
            if (!enum_.name().equals(string)) continue;
            return enum_;
        }
        throw new GraphException("No such enum constant '" + string + "' in EnumDomain " + enumDomain);
    }

    @Override
    public Record createRecord(RecordDomain recordDomain, Map<String, Object> map) {
        Class<? extends Object> clazz = recordDomain.getSchemaClass();
        try {
            Constructor<? extends Object> constructor = clazz.getConstructor(Map.class);
            return (Record)constructor.newInstance(map);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new GraphException(exception);
        }
    }

    @Override
    public final void sortEdges(Comparator<Edge> comparator) {
        Object object;
        if (this.getFirstEdgeInESeq() == null) {
            return;
        }
        final class EdgeList {
            InternalEdge first;
            InternalEdge last;

            EdgeList() {
            }

            public void add(InternalEdge internalEdge) {
                if (this.first == null) {
                    this.first = internalEdge;
                    assert (this.last == null);
                    this.last = internalEdge;
                } else {
                    internalEdge.setPrevEdgeInGraph(this.last);
                    this.last.setNextEdgeInGraph(internalEdge);
                    this.last = internalEdge;
                }
                internalEdge.setNextEdgeInGraph(null);
            }

            public InternalEdge remove() {
                if (this.first == null) {
                    throw new NoSuchElementException();
                }
                if (this.first == this.last) {
                    InternalEdge internalEdge = this.first;
                    this.first = null;
                    this.last = null;
                    return internalEdge;
                }
                InternalEdge internalEdge = this.first;
                this.first = internalEdge.getNextEdgeInESeq();
                this.first.setPrevEdgeInGraph(null);
                return internalEdge;
            }

            public boolean isEmpty() {
                assert (this.first == null == (this.last == null));
                return this.first == null;
            }
        }
        Object object2 = new EdgeList();
        EdgeList edgeList = new EdgeList();
        Object object3 = object2;
        EdgeList edgeList2 = new EdgeList();
        edgeList2.first = this.getFirstEdgeInESeq();
        edgeList2.last = this.getLastEdgeInESeq();
        InternalEdge internalEdge = edgeList2.remove();
        ((EdgeList)object3).add(internalEdge);
        while (!edgeList2.isEmpty()) {
            object = edgeList2.remove();
            if (comparator.compare((Edge)object, internalEdge) < 0) {
                object3 = object3 == object2 ? edgeList : object2;
            }
            ((EdgeList)object3).add((InternalEdge)object);
            internalEdge = object;
        }
        if (((EdgeList)object2).isEmpty() || edgeList.isEmpty()) {
            object3 = ((EdgeList)object2).isEmpty() ? edgeList : object2;
            this.setFirstEdgeInGraph(((EdgeList)object3).first);
            this.setLastEdgeInGraph(((EdgeList)object3).last);
            return;
        }
        while (true) {
            if (((EdgeList)object2).isEmpty() || edgeList.isEmpty()) {
                object3 = ((EdgeList)object2).isEmpty() ? edgeList : object2;
                this.setFirstEdgeInGraph(((EdgeList)object3).first);
                this.setLastEdgeInGraph(((EdgeList)object3).last);
                this.edgeListModified();
                return;
            }
            object = new EdgeList();
            EdgeList edgeList3 = new EdgeList();
            object3 = object;
            internalEdge = null;
            while (!((EdgeList)object2).isEmpty() && !edgeList.isEmpty()) {
                int n;
                int n2 = internalEdge != null ? comparator.compare(((EdgeList)object2).first, internalEdge) : 0;
                int n3 = n = internalEdge != null ? comparator.compare(edgeList.first, internalEdge) : 0;
                if (n2 >= 0 && n >= 0) {
                    if (comparator.compare(((EdgeList)object2).first, edgeList.first) <= 0) {
                        internalEdge = ((EdgeList)object2).remove();
                        ((EdgeList)object3).add(internalEdge);
                        continue;
                    }
                    internalEdge = edgeList.remove();
                    ((EdgeList)object3).add(internalEdge);
                    continue;
                }
                if (n2 < 0 && n < 0) {
                    object3 = object3 == object ? edgeList3 : object;
                    internalEdge = null;
                    continue;
                }
                if (n2 < 0 && n >= 0) {
                    internalEdge = edgeList.remove();
                    ((EdgeList)object3).add(internalEdge);
                    continue;
                }
                internalEdge = ((EdgeList)object2).remove();
                ((EdgeList)object3).add(internalEdge);
            }
            while (!((EdgeList)object2).isEmpty()) {
                InternalEdge internalEdge2 = ((EdgeList)object2).remove();
                if (comparator.compare(internalEdge2, internalEdge) < 0) {
                    object3 = object3 == object ? edgeList3 : object;
                }
                ((EdgeList)object3).add(internalEdge2);
                internalEdge = internalEdge2;
            }
            while (!edgeList.isEmpty()) {
                InternalEdge internalEdge3 = edgeList.remove();
                if (comparator.compare(internalEdge3, internalEdge) < 0) {
                    object3 = object3 == object ? edgeList3 : object;
                }
                ((EdgeList)object3).add(internalEdge3);
                internalEdge = internalEdge3;
            }
            object2 = object;
            edgeList = edgeList3;
        }
    }

    @Override
    public final ECARuleManagerInterface getECARuleManager() {
        if (this.ecaRuleManager == null) {
            try {
                Constructor<?> constructor = Class.forName("de.uni_koblenz.jgralab.eca.ECARuleManager").getConstructor(Graph.class);
                this.ecaRuleManager = (ECARuleManagerInterface)constructor.newInstance(this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            assert (this.ecaRuleManager != null);
        }
        return this.ecaRuleManager;
    }

    @Override
    public final boolean hasECARuleManager() {
        return this.ecaRuleManager != null;
    }

    private final void lazyCreateGraphStructureChangedListenersWithAutoRemoval() {
        if (this.graphStructureChangedListenersWithAutoRemoval == null) {
            this.graphStructureChangedListenersWithAutoRemoval = new LinkedList<WeakReference<GraphStructureChangedListener>>();
        }
    }

    @Override
    public void addGraphStructureChangedListener(GraphStructureChangedListener graphStructureChangedListener) {
        assert (graphStructureChangedListener != null);
        if (graphStructureChangedListener instanceof GraphStructureChangedListenerWithAutoRemove) {
            this.lazyCreateGraphStructureChangedListenersWithAutoRemoval();
            this.graphStructureChangedListenersWithAutoRemoval.add(new WeakReference<GraphStructureChangedListener>(graphStructureChangedListener));
        } else {
            this.graphStructureChangedListeners.add(graphStructureChangedListener);
        }
    }

    @Override
    public final void removeGraphStructureChangedListener(GraphStructureChangedListener graphStructureChangedListener) {
        assert (graphStructureChangedListener != null);
        if (graphStructureChangedListener instanceof GraphStructureChangedListenerWithAutoRemove) {
            Iterator<WeakReference<GraphStructureChangedListener>> iterator = this.getListenerListIteratorForAutoRemove();
            while (iterator != null && iterator.hasNext()) {
                GraphStructureChangedListener graphStructureChangedListener2 = (GraphStructureChangedListener)iterator.next().get();
                if (graphStructureChangedListener2 != null && graphStructureChangedListener2 != graphStructureChangedListener) continue;
                iterator.remove();
            }
        } else {
            Iterator<GraphStructureChangedListener> iterator = this.getListenerListIterator();
            while (iterator != null && iterator.hasNext()) {
                GraphStructureChangedListener graphStructureChangedListener3 = iterator.next();
                if (graphStructureChangedListener3 != graphStructureChangedListener) continue;
                iterator.remove();
            }
        }
    }

    private final void setAutoListenerListToNullIfEmpty() {
        if (this.graphStructureChangedListenersWithAutoRemoval.isEmpty()) {
            this.graphStructureChangedListenersWithAutoRemoval = null;
        }
    }

    @Override
    public final void removeAllGraphStructureChangedListeners() {
        this.graphStructureChangedListenersWithAutoRemoval = null;
        this.graphStructureChangedListeners.clear();
    }

    @Override
    public final int getGraphStructureChangedListenerCount() {
        return this.graphStructureChangedListenersWithAutoRemoval == null ? this.graphStructureChangedListeners.size() : this.graphStructureChangedListenersWithAutoRemoval.size() + this.graphStructureChangedListeners.size();
    }

    private final Iterator<WeakReference<GraphStructureChangedListener>> getListenerListIteratorForAutoRemove() {
        return this.graphStructureChangedListenersWithAutoRemoval != null ? this.graphStructureChangedListenersWithAutoRemoval.iterator() : null;
    }

    private final Iterator<GraphStructureChangedListener> getListenerListIterator() {
        return this.graphStructureChangedListeners != null ? this.graphStructureChangedListeners.iterator() : null;
    }

    @Override
    public final void notifyVertexDeleted(Vertex vertex) {
        assert (vertex != null && vertex.isValid() && this.vSeqContainsVertex(vertex));
        if (this.graphStructureChangedListenersWithAutoRemoval != null) {
            Iterator<WeakReference<GraphStructureChangedListener>> iterator = this.getListenerListIteratorForAutoRemove();
            while (iterator.hasNext()) {
                GraphStructureChangedListener graphStructureChangedListener = (GraphStructureChangedListener)iterator.next().get();
                if (graphStructureChangedListener == null) {
                    iterator.remove();
                    continue;
                }
                graphStructureChangedListener.vertexDeleted(vertex);
            }
            this.setAutoListenerListToNullIfEmpty();
        }
        int n = this.graphStructureChangedListeners.size();
        for (int i = 0; i < n; ++i) {
            this.graphStructureChangedListeners.get(i).vertexDeleted(vertex);
        }
    }

    @Override
    public final void notifyVertexAdded(Vertex vertex) {
        assert (vertex != null && vertex.isValid() && this.vSeqContainsVertex(vertex));
        if (this.graphStructureChangedListenersWithAutoRemoval != null) {
            Iterator<WeakReference<GraphStructureChangedListener>> iterator = this.getListenerListIteratorForAutoRemove();
            while (iterator.hasNext()) {
                GraphStructureChangedListener graphStructureChangedListener = (GraphStructureChangedListener)iterator.next().get();
                if (graphStructureChangedListener == null) {
                    iterator.remove();
                    continue;
                }
                graphStructureChangedListener.vertexAdded(vertex);
            }
            this.setAutoListenerListToNullIfEmpty();
        }
        int n = this.graphStructureChangedListeners.size();
        for (int i = 0; i < n; ++i) {
            this.graphStructureChangedListeners.get(i).vertexAdded(vertex);
        }
    }

    @Override
    public final void notifyEdgeDeleted(Edge edge) {
        assert (edge != null && edge.isValid() && edge.isNormal() && this.eSeqContainsEdge(edge));
        if (this.graphStructureChangedListenersWithAutoRemoval != null) {
            Iterator<WeakReference<GraphStructureChangedListener>> iterator = this.getListenerListIteratorForAutoRemove();
            while (iterator.hasNext()) {
                GraphStructureChangedListener graphStructureChangedListener = (GraphStructureChangedListener)iterator.next().get();
                if (graphStructureChangedListener == null) {
                    iterator.remove();
                    continue;
                }
                graphStructureChangedListener.edgeDeleted(edge);
            }
            this.setAutoListenerListToNullIfEmpty();
        }
        int n = this.graphStructureChangedListeners.size();
        for (int i = 0; i < n; ++i) {
            this.graphStructureChangedListeners.get(i).edgeDeleted(edge);
        }
    }

    @Override
    public final void notifyEdgeAdded(Edge edge) {
        assert (edge != null && edge.isValid() && edge.isNormal() && this.eSeqContainsEdge(edge));
        if (this.graphStructureChangedListenersWithAutoRemoval != null) {
            Iterator<WeakReference<GraphStructureChangedListener>> iterator = this.getListenerListIteratorForAutoRemove();
            while (iterator.hasNext()) {
                GraphStructureChangedListener graphStructureChangedListener = (GraphStructureChangedListener)iterator.next().get();
                if (graphStructureChangedListener == null) {
                    iterator.remove();
                    continue;
                }
                graphStructureChangedListener.edgeAdded(edge);
            }
            this.setAutoListenerListToNullIfEmpty();
        }
        int n = this.graphStructureChangedListeners.size();
        for (int i = 0; i < n; ++i) {
            this.graphStructureChangedListeners.get(i).edgeAdded(edge);
        }
    }

    @Override
    public final void notifyMaxVertexCountIncreased(int n) {
        if (this.graphStructureChangedListenersWithAutoRemoval != null) {
            Iterator<WeakReference<GraphStructureChangedListener>> iterator = this.getListenerListIteratorForAutoRemove();
            while (iterator.hasNext()) {
                GraphStructureChangedListener graphStructureChangedListener = (GraphStructureChangedListener)iterator.next().get();
                if (graphStructureChangedListener == null) {
                    iterator.remove();
                    continue;
                }
                graphStructureChangedListener.maxVertexCountIncreased(n);
            }
            this.setAutoListenerListToNullIfEmpty();
        }
        int n2 = this.graphStructureChangedListeners.size();
        for (int i = 0; i < n2; ++i) {
            this.graphStructureChangedListeners.get(i).maxVertexCountIncreased(n);
        }
    }

    @Override
    public final void notifyMaxEdgeCountIncreased(int n) {
        if (this.graphStructureChangedListenersWithAutoRemoval != null) {
            Iterator<WeakReference<GraphStructureChangedListener>> iterator = this.getListenerListIteratorForAutoRemove();
            while (iterator.hasNext()) {
                GraphStructureChangedListener graphStructureChangedListener = (GraphStructureChangedListener)iterator.next().get();
                if (graphStructureChangedListener == null) {
                    iterator.remove();
                    continue;
                }
                graphStructureChangedListener.maxEdgeCountIncreased(n);
            }
            this.setAutoListenerListToNullIfEmpty();
        }
        int n2 = this.graphStructureChangedListeners.size();
        for (int i = 0; i < n2; ++i) {
            this.graphStructureChangedListeners.get(i).maxEdgeCountIncreased(n);
        }
    }

    @Override
    public final void save(String string) throws GraphIOException {
        this.save(string, null);
    }

    @Override
    public final void save(String string, ProgressFunction progressFunction) throws GraphIOException {
        GraphIO.saveGraphToFile(this, string, progressFunction);
    }

    @Override
    public final void save(DataOutputStream dataOutputStream) throws GraphIOException {
        this.save(dataOutputStream, null);
    }

    @Override
    public final void save(DataOutputStream dataOutputStream, ProgressFunction progressFunction) throws GraphIOException {
        GraphIO.saveGraphToStream(this, dataOutputStream, progressFunction);
    }

    @Override
    public final GraphFactory getGraphFactory() {
        return this.graphFactory;
    }

    @Override
    public final void setGraphFactory(GraphFactory graphFactory) {
        this.graphFactory = graphFactory;
    }

    @Override
    public boolean isInstanceOf(GraphClass graphClass) {
        return graphClass.getSchemaClass().isInstance(this);
    }

    @Override
    public final TraversalContext getTraversalContext() {
        return this.tc.get();
    }

    @Override
    public final TraversalContext setTraversalContext(TraversalContext traversalContext) {
        TraversalContext traversalContext2 = this.tc.get();
        this.tc.set(traversalContext);
        return traversalContext2;
    }

    @Override
    public void loadingCompleted() {
    }
}

