/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.impl.InternalGraph;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class EdgeIterable<E extends Edge>
implements Iterable<E> {
    private Graph g;
    private EdgeClass ec;

    public EdgeIterable(Graph graph) {
        this(graph, null);
    }

    public EdgeIterable(Graph graph, EdgeClass edgeClass) {
        assert (graph != null);
        this.g = graph;
        this.ec = edgeClass;
    }

    @Override
    public Iterator<E> iterator() {
        return new EdgeIterator((InternalGraph)this.g, this.ec);
    }

    class EdgeIterator
    implements Iterator<E> {
        protected E current = null;
        protected InternalGraph graph = null;
        protected EdgeClass schemaEc;
        protected long edgeListVersion;

        EdgeIterator(InternalGraph internalGraph, EdgeClass edgeClass) {
            this.graph = internalGraph;
            this.schemaEc = edgeClass;
            this.edgeListVersion = internalGraph.getEdgeListVersion();
            this.current = this.schemaEc == null ? this.graph.getFirstEdge() : this.graph.getFirstEdge(this.schemaEc);
        }

        @Override
        public E next() {
            if (this.graph.isEdgeListModified(this.edgeListVersion)) {
                throw new ConcurrentModificationException("The edge list of the graph has been modified - the iterator is not longer valid");
            }
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            Object e = this.current;
            this.current = this.schemaEc == null ? this.current.getNextEdge() : this.current.getNextEdge(this.schemaEc);
            return e;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("It is not allowed to remove edges during iteration.");
        }
    }
}

