/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.serialising;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Record;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.graphmarker.SubGraphMarker;
import de.uni_koblenz.jgralab.greql.evaluator.fa.DFA;
import de.uni_koblenz.jgralab.greql.evaluator.fa.NFA;
import de.uni_koblenz.jgralab.greql.evaluator.fa.State;
import de.uni_koblenz.jgralab.greql.evaluator.fa.Transition;
import de.uni_koblenz.jgralab.greql.exception.SerialisingException;
import de.uni_koblenz.jgralab.greql.schema.Declaration;
import de.uni_koblenz.jgralab.greql.types.Path;
import de.uni_koblenz.jgralab.greql.types.PathSystem;
import de.uni_koblenz.jgralab.greql.types.Table;
import de.uni_koblenz.jgralab.greql.types.Tuple;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;
import de.uni_koblenz.jgralab.greql.types.Undefined;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import java.util.Iterator;
import java.util.Map;
import org.pcollections.PMap;
import org.pcollections.PSet;
import org.pcollections.PVector;

public abstract class DefaultWriter {
    private Graph graph;
    protected Object rootValue;

    public DefaultWriter(Graph graph) {
        this.graph = graph;
    }

    protected void writeValue(Object object) throws Exception {
        this.rootValue = object;
        this.head();
        this.write(object);
        this.foot();
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    protected void writePSet(PSet<?> pSet) throws Exception {
        Iterator iterator = pSet.iterator();
        boolean bl = true;
        this.pre();
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                this.inter();
            }
            this.write(iterator.next());
        }
        this.post();
    }

    protected void writePVector(PVector<?> pVector) throws Exception {
        Iterator iterator = pVector.iterator();
        boolean bl = true;
        this.pre();
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                this.inter();
            }
            this.write(iterator.next());
        }
        this.post();
    }

    protected void writePMap(PMap<?, ?> pMap) throws Exception {
        boolean bl = true;
        this.pre();
        for (Map.Entry entry : pMap.entrySet()) {
            if (bl) {
                bl = false;
            } else {
                this.inter();
            }
            Tuple tuple = Tuple.empty();
            tuple = tuple.plus(entry.getKey());
            tuple = tuple.plus(entry.getValue());
            this.writeTuple(tuple);
        }
        this.post();
    }

    protected void writeTable(Table<?> table) throws Exception {
        this.writePVector(table.getTitles());
        this.writePVector(table.toPVector());
    }

    protected void writeTuple(Tuple tuple) throws Exception {
        Iterator<Object> iterator = tuple.iterator();
        boolean bl = true;
        this.pre();
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                this.inter();
            }
            this.write(iterator.next());
        }
        this.post();
    }

    protected void writeRecord(Record record) throws Exception {
        boolean bl = true;
        this.pre();
        for (String string : record.getComponentNames()) {
            if (bl) {
                bl = false;
            } else {
                this.inter();
            }
            this.write(string);
            this.write(record.getComponent(string));
        }
        this.post();
    }

    protected void writePath(Path path) throws Exception {
        this.cantWrite(path);
    }

    protected void writePathSystem(PathSystem pathSystem) throws Exception {
        this.cantWrite(pathSystem);
    }

    protected void writeVertex(Vertex vertex) throws Exception {
        this.cantWrite(vertex);
    }

    protected void writeUndefined() throws Exception {
        this.cantWrite((Object)Undefined.UNDEFINED);
    }

    protected void writeEdge(Edge edge) throws Exception {
        this.cantWrite(edge);
    }

    protected void writeInteger(Integer n) throws Exception {
        this.cantWrite(n);
    }

    protected void writeLong(Long l) throws Exception {
        this.cantWrite(l);
    }

    protected void writeDouble(Double d) throws Exception {
        this.cantWrite(d);
    }

    protected void writeString(String string) throws Exception {
        this.cantWrite(string);
    }

    protected void writeEnum(Enum<?> enum_) throws Exception {
        this.cantWrite(enum_);
    }

    protected void writeGraph(Graph graph) throws Exception {
        this.cantWrite(graph);
    }

    protected void writeSubGraphMarker(SubGraphMarker subGraphMarker) throws Exception {
        this.cantWrite(subGraphMarker);
    }

    protected void writeDFA(DFA dFA) throws Exception {
        this.cantWrite(dFA);
    }

    protected void writeNFA(NFA nFA) throws Exception {
        this.cantWrite(nFA);
    }

    protected void writeBoolean(Boolean bl) throws Exception {
        this.cantWrite(bl);
    }

    protected void writeAttributedElementClass(AttributedElementClass<?, ?> attributedElementClass) throws Exception {
        this.cantWrite(attributedElementClass);
    }

    protected void writeTypeCollection(TypeCollection typeCollection) throws Exception {
        this.cantWrite(typeCollection);
    }

    protected void writeState(State state) throws Exception {
        this.cantWrite(state);
    }

    protected void writeTransition(Transition transition) throws Exception {
        this.cantWrite(transition);
    }

    protected void writeDeclaration(Declaration declaration) throws Exception {
        this.cantWrite(declaration);
    }

    protected void writeDefaultObject(Object object) throws Exception {
        this.cantWrite(object);
    }

    protected void write(Object object) throws Exception {
        if (object instanceof PSet) {
            this.writePSet((PSet)object);
        } else if (object instanceof Table) {
            this.writeTable((Table)object);
        } else if (object instanceof PVector) {
            this.writePVector((PVector)object);
        } else if (object instanceof PMap) {
            this.writePMap((PMap)object);
        } else if (object instanceof Tuple) {
            this.writeTuple((Tuple)object);
        } else if (object instanceof Record) {
            this.writeRecord((Record)object);
        } else if (object instanceof Path) {
            this.writePath((Path)object);
        } else if (object instanceof PathSystem) {
            this.writePathSystem((PathSystem)object);
        } else if (object instanceof Vertex) {
            this.writeVertex((Vertex)object);
        } else if (object instanceof Edge) {
            this.writeEdge((Edge)object);
        } else if (object instanceof Integer) {
            this.writeInteger((Integer)object);
        } else if (object instanceof Long) {
            this.writeLong((Long)object);
        } else if (object instanceof Double) {
            this.writeDouble((Double)object);
        } else if (object instanceof String) {
            this.writeString((String)object);
        } else if (object instanceof Enum) {
            this.writeEnum((Enum)object);
        } else if (object instanceof Graph) {
            this.writeGraph((Graph)object);
        } else if (object instanceof SubGraphMarker) {
            this.writeSubGraphMarker((SubGraphMarker)object);
        } else if (object instanceof DFA) {
            this.writeDFA((DFA)object);
        } else if (object instanceof NFA) {
            this.writeNFA((NFA)object);
        } else if (object instanceof TypeCollection) {
            this.writeTypeCollection((TypeCollection)object);
        } else if (object instanceof Boolean) {
            this.writeBoolean((Boolean)object);
        } else if (object instanceof AttributedElementClass) {
            this.writeAttributedElementClass((AttributedElementClass)object);
        } else if (object instanceof Transition) {
            this.writeTransition((Transition)object);
        } else if (object instanceof Declaration) {
            this.writeDeclaration((Declaration)object);
        } else if (object instanceof State) {
            this.writeState((State)object);
        } else if (object instanceof Undefined) {
            this.writeUndefined();
        } else {
            this.writeDefaultObject(object);
        }
    }

    protected void post() throws Exception {
    }

    protected void pre() throws Exception {
    }

    protected void inter() throws Exception {
    }

    protected void head() throws Exception {
    }

    protected void foot() throws Exception {
    }

    protected void cantWrite(Object object) {
        throw new SerialisingException(this.getClass().getSimpleName() + " can not handle " + object.getClass(), object);
    }
}

