/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.OptimizerInfo;
import de.uni_koblenz.jgralab.greql.exception.OptimizerException;
import de.uni_koblenz.jgralab.greql.optimizer.Optimizer;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerUtility;
import de.uni_koblenz.jgralab.greql.schema.Declaration;
import de.uni_koblenz.jgralab.greql.schema.GreqlExpression;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.greql.schema.IsBoundVarOf;
import de.uni_koblenz.jgralab.greql.schema.IsDeclaredVarOf;
import de.uni_koblenz.jgralab.greql.schema.IsSimpleDeclOf;
import de.uni_koblenz.jgralab.greql.schema.SimpleDeclaration;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import java.util.HashSet;
import java.util.Set;

public abstract class OptimizerBase
implements Optimizer {
    protected OptimizerInfo optimizerInfo;

    protected OptimizerBase(OptimizerInfo optimizerInfo) {
        this.optimizerInfo = optimizerInfo;
    }

    @Override
    public OptimizerInfo getOptimizerInfo() {
        return this.optimizerInfo;
    }

    protected String optimizerHeaderString() {
        return "*** " + this.getClass().getSimpleName() + ": ";
    }

    protected void relink(Vertex vertex, Vertex vertex2) {
        Edge edge;
        assert (vertex != null && vertex2 != null) : "Relinking null!";
        assert (vertex != vertex2) : "Relinking from itself!";
        assert (vertex.getSchemaClass() == vertex2.getSchemaClass()) : "Relinking different classes! from is " + vertex + ", to is " + vertex2;
        assert (vertex.isValid() && vertex2.isValid()) : "Relinking invalid vertices!";
        Edge edge2 = vertex.getFirstIncidence(EdgeDirection.IN);
        while (edge2 != null) {
            edge = edge2.getNextIncidence(EdgeDirection.IN);
            edge2.setOmega(vertex2);
            edge2 = edge;
        }
        edge2 = vertex.getFirstIncidence(EdgeDirection.OUT);
        while (edge2 != null) {
            edge = edge2.getNextIncidence(EdgeDirection.OUT);
            edge2.setAlpha(vertex2);
            edge2 = edge;
        }
    }

    protected boolean isDeclaredBefore(Variable variable, Variable variable2) {
        SimpleDeclaration simpleDeclaration;
        Declaration declaration;
        if (variable == variable2) {
            return false;
        }
        IsBoundVarOf isBoundVarOf = variable.getFirstIsBoundVarOfIncidence();
        IsBoundVarOf isBoundVarOf2 = variable2.getFirstIsBoundVarOfIncidence();
        if (isBoundVarOf != null) {
            if (isBoundVarOf2 == null) {
                return true;
            }
            GreqlExpression greqlExpression = isBoundVarOf.getOmega();
            for (IsBoundVarOf isBoundVarOf3 : greqlExpression.getIsBoundVarOfIncidences()) {
                if ((isBoundVarOf3 = (IsBoundVarOf)isBoundVarOf3.getNormalEdge()) == isBoundVarOf) {
                    return true;
                }
                if (isBoundVarOf3 != isBoundVarOf2) continue;
                return false;
            }
            throw new OptimizerException("You must never come here...");
        }
        if (isBoundVarOf2 != null) {
            return false;
        }
        SimpleDeclaration simpleDeclaration2 = variable.getFirstIsDeclaredVarOfIncidence(EdgeDirection.OUT).getOmega();
        Declaration declaration2 = simpleDeclaration2.getFirstIsSimpleDeclOfIncidence(EdgeDirection.OUT).getOmega();
        if (declaration2 == (declaration = (simpleDeclaration = variable2.getFirstIsDeclaredVarOfIncidence(EdgeDirection.OUT).getOmega()).getFirstIsSimpleDeclOfIncidence(EdgeDirection.OUT).getOmega())) {
            if (simpleDeclaration2 == simpleDeclaration) {
                for (IsDeclaredVarOf isDeclaredVarOf = simpleDeclaration2.getFirstIsDeclaredVarOfIncidence(EdgeDirection.IN); isDeclaredVarOf != null; isDeclaredVarOf = isDeclaredVarOf.getNextIsDeclaredVarOfIncidence(EdgeDirection.IN)) {
                    if (isDeclaredVarOf.getAlpha() == variable) {
                        return true;
                    }
                    if (isDeclaredVarOf.getAlpha() != variable2) continue;
                    return false;
                }
            } else {
                for (IsSimpleDeclOf isSimpleDeclOf = declaration2.getFirstIsSimpleDeclOfIncidence(EdgeDirection.IN); isSimpleDeclOf != null; isSimpleDeclOf = isSimpleDeclOf.getNextIsSimpleDeclOfIncidence(EdgeDirection.IN)) {
                    if (isSimpleDeclOf.getAlpha() == simpleDeclaration2) {
                        return true;
                    }
                    if (isSimpleDeclOf.getAlpha() != simpleDeclaration) continue;
                    return false;
                }
            }
        } else {
            Vertex vertex;
            Vertex vertex2 = declaration2.getFirstIncidence(EdgeDirection.OUT).getOmega();
            return OptimizerUtility.isAbove(vertex2, vertex = declaration.getFirstIncidence(EdgeDirection.OUT).getOmega());
        }
        throw new OptimizerException("No case matched in isDeclaredBefore(Variable, Variable). That must not happen!");
    }

    protected Declaration findNearestDeclarationAbove(Vertex vertex) {
        if (vertex instanceof Declaration) {
            return (Declaration)vertex;
        }
        Declaration declaration = null;
        for (Edge edge = vertex.getFirstIncidence(EdgeDirection.OUT); edge != null; edge = edge.getNextIncidence(EdgeDirection.OUT)) {
            declaration = this.findNearestDeclarationAbove(edge.getOmega());
            if (declaration == null) continue;
            return declaration;
        }
        return null;
    }

    protected SimpleDeclaration splitSimpleDeclaration(SimpleDeclaration simpleDeclaration, Set<Variable> set) {
        GreqlGraph greqlGraph = (GreqlGraph)simpleDeclaration.getGraph();
        Set<Variable> set2 = OptimizerUtility.collectVariablesDeclaredBy(simpleDeclaration);
        if (set2.size() == set.size()) {
            return simpleDeclaration;
        }
        Declaration declaration = simpleDeclaration.getFirstIsSimpleDeclOfIncidence(EdgeDirection.OUT).getOmega();
        IsSimpleDeclOf isSimpleDeclOf = simpleDeclaration.getFirstIsSimpleDeclOfIncidence();
        SimpleDeclaration simpleDeclaration2 = greqlGraph.createSimpleDeclaration();
        IsSimpleDeclOf isSimpleDeclOf2 = greqlGraph.createIsSimpleDeclOf(simpleDeclaration2, declaration);
        greqlGraph.createIsTypeExprOfDeclaration(simpleDeclaration.getFirstIsTypeExprOfDeclarationIncidence(EdgeDirection.IN).getAlpha(), simpleDeclaration2);
        isSimpleDeclOf2.getReversedEdge().putIncidenceAfter(isSimpleDeclOf.getReversedEdge());
        for (Variable variable : set) {
            HashSet<IsDeclaredVarOf> hashSet = new HashSet<IsDeclaredVarOf>();
            for (IsDeclaredVarOf isDeclaredVarOf = simpleDeclaration.getFirstIsDeclaredVarOfIncidence(EdgeDirection.IN); isDeclaredVarOf != null; isDeclaredVarOf = isDeclaredVarOf.getNextIsDeclaredVarOfIncidence(EdgeDirection.IN)) {
                if (isDeclaredVarOf.getAlpha() != variable) continue;
                hashSet.add(isDeclaredVarOf);
            }
            for (IsDeclaredVarOf isDeclaredVarOf : hashSet) {
                isDeclaredVarOf.setOmega(simpleDeclaration2);
            }
        }
        return simpleDeclaration2;
    }
}

