/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer;

import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.OptimizerInfo;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.exception.OptimizerException;
import de.uni_koblenz.jgralab.greql.optimizer.CommonSubgraphOptimizer;
import de.uni_koblenz.jgralab.greql.optimizer.ConditionalExpressionOptimizer;
import de.uni_koblenz.jgralab.greql.optimizer.EarlySelectionOptimizer;
import de.uni_koblenz.jgralab.greql.optimizer.MergeConstraintsOptimizer;
import de.uni_koblenz.jgralab.greql.optimizer.MergeSimpleDeclarationsOptimizer;
import de.uni_koblenz.jgralab.greql.optimizer.Optimizer;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerBase;
import de.uni_koblenz.jgralab.greql.optimizer.PathExistenceOptimizer;
import de.uni_koblenz.jgralab.greql.optimizer.PathExistenceToDirectedPathExpressionOptimizer;
import de.uni_koblenz.jgralab.greql.optimizer.TransformXorFunctionApplicationOptimizer;
import de.uni_koblenz.jgralab.greql.optimizer.TypeCollectionEvaluator;
import de.uni_koblenz.jgralab.greql.optimizer.VariableDeclarationOrderOptimizer;
import de.uni_koblenz.jgralab.greql.schema.GreqlExpression;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.greql.schema.GreqlVertex;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import java.util.Set;
import java.util.logging.Logger;

public class DefaultOptimizer
extends OptimizerBase {
    private static Logger logger = JGraLab.getLogger(DefaultOptimizer.class);

    public DefaultOptimizer(OptimizerInfo optimizerInfo) {
        super(optimizerInfo);
    }

    @Override
    protected String optimizerHeaderString() {
        return "### " + this.getClass().getSimpleName() + ": ";
    }

    @Override
    public boolean isEquivalent(Optimizer optimizer) {
        return optimizer instanceof DefaultOptimizer;
    }

    @Override
    public boolean optimize(GreqlQuery greqlQuery) throws OptimizerException {
        if (greqlQuery.getQueryGraph().getVCount() <= 1) {
            return false;
        }
        logger.fine(this.optimizerHeaderString() + "Starting optimization.  Fasten your seatbelts!");
        CommonSubgraphOptimizer commonSubgraphOptimizer = new CommonSubgraphOptimizer(this.optimizerInfo);
        PathExistenceToDirectedPathExpressionOptimizer pathExistenceToDirectedPathExpressionOptimizer = new PathExistenceToDirectedPathExpressionOptimizer(this.optimizerInfo);
        EarlySelectionOptimizer earlySelectionOptimizer = new EarlySelectionOptimizer(this.optimizerInfo);
        PathExistenceOptimizer pathExistenceOptimizer = new PathExistenceOptimizer(this.optimizerInfo);
        VariableDeclarationOrderOptimizer variableDeclarationOrderOptimizer = new VariableDeclarationOrderOptimizer(this.optimizerInfo);
        ConditionalExpressionOptimizer conditionalExpressionOptimizer = new ConditionalExpressionOptimizer(this.optimizerInfo);
        TransformXorFunctionApplicationOptimizer transformXorFunctionApplicationOptimizer = new TransformXorFunctionApplicationOptimizer(this.optimizerInfo);
        MergeConstraintsOptimizer mergeConstraintsOptimizer = new MergeConstraintsOptimizer(this.optimizerInfo);
        MergeSimpleDeclarationsOptimizer mergeSimpleDeclarationsOptimizer = new MergeSimpleDeclarationsOptimizer(this.optimizerInfo);
        boolean bl = false;
        int n = 1;
        if (this.optimizerInfo.getSchema() != null) {
            TypeCollectionEvaluator typeCollectionEvaluator = new TypeCollectionEvaluator((GreqlQueryImpl)greqlQuery);
            typeCollectionEvaluator.execute();
        }
        while (commonSubgraphOptimizer.optimize(greqlQuery) | transformXorFunctionApplicationOptimizer.optimize(greqlQuery) | commonSubgraphOptimizer.optimize(greqlQuery) | mergeConstraintsOptimizer.optimize(greqlQuery) | pathExistenceToDirectedPathExpressionOptimizer.optimize(greqlQuery) | earlySelectionOptimizer.optimize(greqlQuery) | commonSubgraphOptimizer.optimize(greqlQuery) | variableDeclarationOrderOptimizer.optimize(greqlQuery) | commonSubgraphOptimizer.optimize(greqlQuery) | pathExistenceOptimizer.optimize(greqlQuery) | conditionalExpressionOptimizer.optimize(greqlQuery) | commonSubgraphOptimizer.optimize(greqlQuery) | mergeSimpleDeclarationsOptimizer.optimize(greqlQuery)) {
            bl = true;
            if (++n > 10) {
                logger.warning("Optimizer didn't finish after 10 runs. Stopping here.");
                break;
            }
            logger.fine(this.optimizerHeaderString() + "starts a new iteration (" + n + ")...");
        }
        logger.fine(this.optimizerHeaderString() + " finished after " + n + " iterations.");
        return bl;
    }

    protected void printCosts(GreqlQuery greqlQuery) {
        GreqlGraph greqlGraph = greqlQuery.getQueryGraph();
        logger.fine("Optimizer: Optimizing " + greqlGraph.getId() + ".\n" + "This syntaxgraph has " + greqlGraph.getECount() + " edges and " + greqlGraph.getVCount() + " vertexes.");
        GreqlExpression greqlExpression = greqlGraph.getFirstGreqlExpression();
        VertexEvaluator<GreqlExpression> vertexEvaluator = ((GreqlQueryImpl)greqlQuery).getVertexEvaluator(greqlExpression);
        vertexEvaluator.getInitialSubtreeEvaluationCosts();
        vertexEvaluator.getEstimatedCardinality();
        vertexEvaluator.calculateEstimatedSelectivity();
        logger.fine("=========================================================");
        for (GreqlVertex greqlVertex = greqlGraph.getFirstGreqlVertex(); greqlVertex != null; greqlVertex = greqlVertex.getNextGreqlVertex()) {
            logger.fine("Current Node: " + greqlVertex);
            VertexEvaluator<GreqlVertex> vertexEvaluator2 = ((GreqlQueryImpl)greqlQuery).getVertexEvaluator(greqlVertex);
            if (vertexEvaluator2 != null) {
                long l = vertexEvaluator2.getInitialSubtreeEvaluationCosts();
                long l2 = vertexEvaluator2.getEstimatedCardinality();
                Set<Variable> set = vertexEvaluator2.getNeededVariables();
                Set<Variable> set2 = vertexEvaluator2.getDefinedVariables();
                long l3 = vertexEvaluator2.getVariableCombinations();
                double d = vertexEvaluator2.getEstimatedSelectivity();
                logger.fine("Costs for subtree evaluation: " + l + "\n" + "Estimated cardinality: " + l2 + "\n" + "Estimated selectivity: " + d + "\n" + "Needed Vars: " + set + "\n" + "Defined Vars: " + set2 + "\n" + "Variable Combinations: " + l3);
            }
            logger.fine("=========================================================");
        }
        VertexEvaluator<GreqlExpression> vertexEvaluator3 = ((GreqlQueryImpl)greqlQuery).getVertexEvaluator(greqlGraph.getFirstGreqlExpression());
        vertexEvaluator3.resetSubtreeToInitialState(null);
        long l = vertexEvaluator3.getCurrentSubtreeEvaluationCosts();
        logger.fine("Costs for the whole query: " + l);
    }
}

