/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.fa;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.fa.State;
import de.uni_koblenz.jgralab.greql.evaluator.fa.Transition;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.ThisEdgeEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.GReQLDirection;
import de.uni_koblenz.jgralab.greql.schema.ThisEdge;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import java.util.Set;

public class SimpleTransition
extends Transition {
    protected VertexEvaluator<? extends Expression> predicateEvaluator;
    protected ThisEdgeEvaluator thisEdgeEvaluator;
    protected TypeCollection typeCollection;
    protected Set<String> validToEdgeRoles;
    protected Set<String> validFromEdgeRoles;
    protected GReQLDirection validDirection;

    public VertexEvaluator<? extends Expression> getPredicateEvaluator() {
        return this.predicateEvaluator;
    }

    public TypeCollection getTypeCollection() {
        return this.typeCollection;
    }

    public Set<String> getValidToRoles() {
        return this.validToEdgeRoles;
    }

    public Set<String> getValidFromRoles() {
        return this.validFromEdgeRoles;
    }

    public GReQLDirection getAllowedDirection() {
        return this.validDirection;
    }

    @Override
    public String edgeString() {
        String string = "SimpleTransition (Dir:" + this.validDirection.toString();
        if (this.typeCollection != null) {
            string = string + "\n " + this.typeCollection.toString() + "\n ";
        }
        string = string + ")";
        return string;
    }

    @Override
    public boolean equalSymbol(Transition transition) {
        if (!(transition instanceof SimpleTransition)) {
            return false;
        }
        SimpleTransition simpleTransition = (SimpleTransition)transition;
        if (!this.typeCollection.equals(simpleTransition.typeCollection)) {
            return false;
        }
        if (!this.validDirection.equals((Object)simpleTransition.validDirection)) {
            return false;
        }
        if (this.validToEdgeRoles != null) {
            if (simpleTransition.validToEdgeRoles == null) {
                return false;
            }
            if (!this.validToEdgeRoles.equals(simpleTransition.validToEdgeRoles)) {
                return false;
            }
        } else if (simpleTransition.validToEdgeRoles != null) {
            return false;
        }
        if (this.validFromEdgeRoles == null) {
            if (simpleTransition.validFromEdgeRoles != null) {
                return false;
            }
        } else {
            if (simpleTransition.validFromEdgeRoles == null) {
                return false;
            }
            if (!this.validFromEdgeRoles.equals(simpleTransition.validFromEdgeRoles)) {
                return false;
            }
        }
        if (this.predicateEvaluator != null) {
            if (simpleTransition.predicateEvaluator == null) {
                return false;
            }
            if (!this.predicateEvaluator.equals(simpleTransition.predicateEvaluator)) {
                return false;
            }
        } else if (simpleTransition.predicateEvaluator != null) {
            return false;
        }
        return true;
    }

    protected SimpleTransition(SimpleTransition simpleTransition, boolean bl) {
        super(simpleTransition, bl);
        this.validDirection = simpleTransition.validDirection;
        this.typeCollection = simpleTransition.typeCollection;
        this.predicateEvaluator = simpleTransition.predicateEvaluator;
        this.thisEdgeEvaluator = simpleTransition.thisEdgeEvaluator;
        this.validToEdgeRoles = simpleTransition.validToEdgeRoles;
        this.validFromEdgeRoles = simpleTransition.validFromEdgeRoles;
    }

    @Override
    public Transition copy(boolean bl) {
        return new SimpleTransition(this, bl);
    }

    public SimpleTransition(State state, State state2, GReQLDirection gReQLDirection) {
        super(state, state2);
        this.validDirection = gReQLDirection;
        this.typeCollection = TypeCollection.empty();
    }

    public SimpleTransition(State state, State state2, GReQLDirection gReQLDirection, TypeCollection typeCollection, Set<String> set, VertexEvaluator<? extends Expression> vertexEvaluator, GreqlQueryImpl greqlQueryImpl) {
        super(state, state2);
        this.validDirection = gReQLDirection;
        this.validToEdgeRoles = set;
        this.validFromEdgeRoles = null;
        this.typeCollection = typeCollection;
        this.predicateEvaluator = vertexEvaluator;
        ThisEdge thisEdge = (ThisEdge)greqlQueryImpl.getQueryGraph().getFirstVertex(ThisEdge.VC);
        if (thisEdge != null) {
            this.thisEdgeEvaluator = (ThisEdgeEvaluator)greqlQueryImpl.getVertexEvaluator(thisEdge);
        }
    }

    @Override
    public void reverse() {
        super.reverse();
        if (this.validDirection == GReQLDirection.IN) {
            this.validDirection = GReQLDirection.OUT;
        } else if (this.validDirection == GReQLDirection.OUT) {
            this.validDirection = GReQLDirection.IN;
        }
        Set<String> set = this.validFromEdgeRoles;
        this.validFromEdgeRoles = this.validToEdgeRoles;
        this.validToEdgeRoles = set;
    }

    @Override
    public boolean isEpsilon() {
        return false;
    }

    @Override
    public boolean accepts(Vertex vertex, Edge edge, InternalGreqlEvaluator internalGreqlEvaluator) {
        Object object;
        if (edge == null) {
            return false;
        }
        if (this.validDirection == GReQLDirection.OUT ? !edge.isNormal() : this.validDirection == GReQLDirection.IN && edge.isNormal()) {
            return false;
        }
        Set<String> set = this.validToEdgeRoles;
        boolean bl = true;
        if (set == null) {
            set = this.validFromEdgeRoles;
            bl = false;
        }
        boolean bl2 = set != null && this.typeCollection.isEmpty();
        boolean bl3 = false;
        if (set != null) {
            object = edge.getAttributedElementClass();
            Set<String> set2 = null;
            set2 = edge.isNormal() == bl ? object.getTo().getAllRoles() : object.getFrom().getAllRoles();
            for (String string : set2) {
                if (!set.contains(string)) continue;
                bl3 = true;
                break;
            }
        }
        if (bl2 ? !bl3 : !bl3 && !this.typeCollection.acceptsType((GraphElementClass<?, ?>)(object = edge.getAttributedElementClass()))) {
            return false;
        }
        if (this.predicateEvaluator != null) {
            if (this.thisEdgeEvaluator != null) {
                this.thisEdgeEvaluator.setValue(edge, internalGreqlEvaluator);
            }
            if ((object = this.predicateEvaluator.getResult(internalGreqlEvaluator)) instanceof Boolean) {
                return (Boolean)object;
            }
            return false;
        }
        return true;
    }

    @Override
    public Vertex getNextVertex(Vertex vertex, Edge edge) {
        return edge.getThat();
    }

    @Override
    public String prettyPrint() {
        String string = "<->";
        if (this.validDirection == GReQLDirection.IN) {
            string = "<--";
        } else if (this.validDirection == GReQLDirection.OUT) {
            string = "-->";
        }
        return string + this.typeCollection.toString();
    }

    @Override
    public boolean consumesEdge() {
        return true;
    }
}

