/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.graphvalidator;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.graphvalidator.BrokenGReQLConstraintViolation;
import de.uni_koblenz.jgralab.graphvalidator.ConstraintViolation;
import de.uni_koblenz.jgralab.graphvalidator.GReQLConstraintViolation;
import de.uni_koblenz.jgralab.graphvalidator.MultiplicityConstraintViolation;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.exception.GreqlException;
import de.uni_koblenz.jgralab.impl.ConsoleProgressFunction;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.Constraint;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class GraphValidator {
    private final Graph graph;

    public GraphValidator(Graph graph) {
        this.graph = graph;
    }

    public static void main(String[] stringArray) throws GraphIOException, IOException {
        if (stringArray.length != 1) {
            System.err.println("Usage: java GraphValidator <graph.tg>");
            System.exit(1);
        }
        Graph graph = GraphIO.loadGraphFromFile(stringArray[0], new ConsoleProgressFunction("Loading"));
        GraphValidator graphValidator = new GraphValidator(graph);
        graphValidator.createValidationReport("__validation_report.html");
    }

    public SortedSet<MultiplicityConstraintViolation> validateMultiplicities(EdgeClass edgeClass) {
        TreeSet<MultiplicityConstraintViolation> treeSet = new TreeSet<MultiplicityConstraintViolation>();
        int n = edgeClass.getTo().getMin();
        int n2 = edgeClass.getTo().getMax();
        HashMap hashMap = new HashMap();
        for (Vertex vertex : this.graph.vertices(edgeClass.getFrom().getVertexClass())) {
            int n3 = vertex.getDegree(edgeClass, EdgeDirection.OUT);
            if (n3 >= n && n3 <= n2) continue;
            hashMap.put(vertex, n3);
        }
        if (!hashMap.isEmpty()) {
            treeSet.add(new MultiplicityConstraintViolation(edgeClass, "Invalid number of outgoing edges, allowed are (" + n + "," + (n2 == Integer.MAX_VALUE ? "*" : Integer.valueOf(n2)) + ").", hashMap));
        }
        int n4 = edgeClass.getFrom().getMin();
        int n5 = edgeClass.getFrom().getMax();
        HashMap hashMap2 = new HashMap();
        for (Vertex vertex : this.graph.vertices(edgeClass.getTo().getVertexClass())) {
            int n6 = vertex.getDegree(edgeClass, EdgeDirection.IN);
            if (n6 >= n4 && n6 <= n5) continue;
            hashMap2.put(vertex, n6);
        }
        if (!hashMap2.isEmpty()) {
            treeSet.add(new MultiplicityConstraintViolation(edgeClass, "Invalid number of incoming edges, allowed are (" + n4 + "," + (n5 == Integer.MAX_VALUE ? "*" : Integer.valueOf(n5)) + ").", hashMap2));
        }
        return treeSet;
    }

    public SortedSet<ConstraintViolation> validate() {
        TreeSet<ConstraintViolation> treeSet = new TreeSet<ConstraintViolation>();
        for (EdgeClass object2 : this.graph.getGraphClass().getEdgeClasses()) {
            treeSet.addAll(this.validateMultiplicities(object2));
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(this.graph.getSchema().getGraphClass());
        arrayList.addAll(this.graph.getSchema().getGraphClass().getVertexClasses());
        arrayList.addAll(this.graph.getSchema().getGraphClass().getEdgeClasses());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            AttributedElementClass attributedElementClass = (AttributedElementClass)iterator.next();
            treeSet.addAll(this.validateConstraints(attributedElementClass));
        }
        return treeSet;
    }

    public SortedSet<ConstraintViolation> validateConstraints(AttributedElementClass<?, ?> attributedElementClass) {
        TreeSet<ConstraintViolation> treeSet = new TreeSet<ConstraintViolation>();
        for (Constraint constraint : attributedElementClass.getConstraints()) {
            String string = constraint.getPredicate();
            try {
                if (((Boolean)GreqlQuery.createQuery(string).evaluate(this.graph)).booleanValue()) continue;
                if (constraint.getOffendingElementsQuery() != null) {
                    string = constraint.getOffendingElementsQuery();
                    Set set = (Set)GreqlQuery.createQuery(string).evaluate(this.graph);
                    treeSet.add(new GReQLConstraintViolation(attributedElementClass, constraint, set));
                    continue;
                }
                treeSet.add(new GReQLConstraintViolation(attributedElementClass, constraint, null));
            }
            catch (GreqlException greqlException) {
                treeSet.add(new BrokenGReQLConstraintViolation(attributedElementClass, constraint, string));
            }
        }
        return treeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<ConstraintViolation> createValidationReport(String string) throws IOException {
        SortedSet<ConstraintViolation> sortedSet = this.validate();
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(string)));
            bufferedWriter.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\"\n\"http://www.w3.org/TR/html4/strict.dtd\">\n<html>");
            bufferedWriter.append("<head>");
            bufferedWriter.append("<style type=\"text/css\">");
            bufferedWriter.append("th {");
            bufferedWriter.append("\tfont: bold 11px sans-serif;");
            bufferedWriter.append("\tcolor: MidnightBlue;");
            bufferedWriter.append("\tborder-right: 1px solid #C1DAD7;");
            bufferedWriter.append("\tborder-bottom: 1px solid #C1DAD7;");
            bufferedWriter.append("\tborder-top: 1px solid #C1DAD7;");
            bufferedWriter.append("\tletter-spacing: 2px;");
            bufferedWriter.append("\ttext-align: left;");
            bufferedWriter.append(" padding: 6px 6px 6px 12px;");
            bufferedWriter.append("\tbackground: #CAE8EA;");
            bufferedWriter.append("}");
            bufferedWriter.append("td {");
            bufferedWriter.append(" border-right: 1px solid #C1DAD7;");
            bufferedWriter.append("\tborder-bottom: 1px solid #C1DAD7;");
            bufferedWriter.append("\tbackground: #fff;");
            bufferedWriter.append("\tpadding: 6px 6px 6px 12px;");
            bufferedWriter.append("\tcolor: DimGrey;");
            bufferedWriter.append("}");
            bufferedWriter.append("td.other {");
            bufferedWriter.append(" border-right: 1px solid #C1DAD7;");
            bufferedWriter.append("\tborder-bottom: 1px solid #C1DAD7;");
            bufferedWriter.append("\tbackground: AliceBlue;");
            bufferedWriter.append("\tpadding: 6px 6px 6px 12px;");
            bufferedWriter.append("\tcolor: DimGrey;");
            bufferedWriter.append("}");
            bufferedWriter.append("</style>");
            bufferedWriter.append("<title>");
            bufferedWriter.append("Validation Report for the " + this.graph.getSchemaClass().getSimpleName() + " with id " + this.graph.getId() + ".");
            bufferedWriter.append("</title>");
            bufferedWriter.append("</head>");
            bufferedWriter.append("<body>");
            if (sortedSet.size() == 0) {
                bufferedWriter.append("<p><b>The graph is valid!</b></p>");
            } else {
                bufferedWriter.append("<p><b>The " + this.graph.getSchemaClass().getSimpleName() + " violates " + sortedSet.size() + " constraints.</b></p>");
                bufferedWriter.append("<table border=\"1\">");
                bufferedWriter.append("<tr>");
                bufferedWriter.append("<th>#</th>");
                bufferedWriter.append("<th>ConstraintType</th>");
                bufferedWriter.append("<th>AttributedElementClass</th>");
                bufferedWriter.append("<th>Message</th>");
                bufferedWriter.append("<th>Broken Elements</th>");
                bufferedWriter.append("</tr>");
                int n = 1;
                String string2 = "";
                for (ConstraintViolation constraintViolation : sortedSet) {
                    string2 = n % 2 == 0 ? "other" : "";
                    bufferedWriter.append("<tr>");
                    bufferedWriter.append("<td class=\"" + string2 + "\">");
                    bufferedWriter.append(Integer.valueOf(n++).toString());
                    bufferedWriter.append("</td>");
                    bufferedWriter.append("<td class=\"" + string2 + "\">");
                    bufferedWriter.append(constraintViolation.getClass().getSimpleName());
                    bufferedWriter.append("</td>");
                    bufferedWriter.append("<td class=\"" + string2 + "\">");
                    bufferedWriter.append(constraintViolation.getAttributedElementClass().getQualifiedName());
                    bufferedWriter.append("</td>");
                    bufferedWriter.append("<td class=\"" + string2 + "\">");
                    bufferedWriter.append(constraintViolation.getMessage());
                    bufferedWriter.append("</td>");
                    bufferedWriter.append("<td class=\"" + string2 + "\">");
                    if (constraintViolation.getOffendingElements() != null) {
                        for (AttributedElement<?, ?> attributedElement : constraintViolation.getOffendingElements()) {
                            bufferedWriter.append(attributedElement.toString());
                            if (constraintViolation instanceof MultiplicityConstraintViolation) {
                                bufferedWriter.append(", degree=").append(Integer.toString(((MultiplicityConstraintViolation)constraintViolation).getDegree(attributedElement)));
                            }
                            bufferedWriter.append("<br/>");
                        }
                    }
                    bufferedWriter.append("</td>");
                    bufferedWriter.append("</tr>");
                }
                bufferedWriter.append("</table>");
            }
            bufferedWriter.append("</body></html>");
            bufferedWriter.flush();
        }
        finally {
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException("An Exception occurred while closing the stream.", iOException);
            }
        }
        return sortedSet;
    }
}

