/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.eca;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.eca.Action;
import de.uni_koblenz.jgralab.eca.Condition;
import de.uni_koblenz.jgralab.eca.ECAException;
import de.uni_koblenz.jgralab.eca.ECARule;
import de.uni_koblenz.jgralab.eca.ECARuleManagerInterface;
import de.uni_koblenz.jgralab.eca.events.ChangeAttributeEventDescription;
import de.uni_koblenz.jgralab.eca.events.ChangeEdgeEventDescription;
import de.uni_koblenz.jgralab.eca.events.CreateEdgeEventDescription;
import de.uni_koblenz.jgralab.eca.events.CreateVertexEventDescription;
import de.uni_koblenz.jgralab.eca.events.DeleteEdgeEventDescription;
import de.uni_koblenz.jgralab.eca.events.DeleteVertexEventDescription;
import de.uni_koblenz.jgralab.eca.events.EventDescription;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ECARuleManager
implements ECARuleManagerInterface {
    private Graph graph;
    private List<ECARule<?>> rules;
    private int nestedTriggerCalls = 0;
    private int maxNestedTriggerCalls = 30;
    private boolean blocked = false;
    private List<CreateVertexEventDescription> beforeCreateVertexEvents;
    private List<CreateVertexEventDescription> afterCreateVertexEvents;
    private List<DeleteVertexEventDescription> beforeDeleteVertexEvents;
    private List<DeleteVertexEventDescription> afterDeleteVertexEvents;
    private List<CreateEdgeEventDescription> beforeCreateEdgeEvents;
    private List<CreateEdgeEventDescription> afterCreateEdgeEvents;
    private List<DeleteEdgeEventDescription> beforeDeleteEdgeEvents;
    private List<DeleteEdgeEventDescription> afterDeleteEdgeEvents;
    private List<ChangeEdgeEventDescription> beforeChangeAlphaOfEdgeEvents;
    private List<ChangeEdgeEventDescription> afterChangeAlphaOfEdgeEvents;
    private List<ChangeEdgeEventDescription> beforeChangeOmegaOfEdgeEvents;
    private List<ChangeEdgeEventDescription> afterChangeOmegaOfEdgeEvents;
    private List<ChangeAttributeEventDescription<?>> beforeChangeAttributeEvents;
    private List<ChangeAttributeEventDescription<?>> afterChangeAttributeEvents;

    public static ECARuleManager getECARuleManagerForGraph(Graph graph) {
        return (ECARuleManager)graph.getECARuleManager();
    }

    public ECARuleManager(Graph graph) {
        this.graph = graph;
        this.rules = new ArrayList();
    }

    private void createBeforeCreateVertexEventsLazily() {
        if (this.beforeCreateVertexEvents == null) {
            this.beforeCreateVertexEvents = new ArrayList<CreateVertexEventDescription>();
        }
    }

    private void createAfterCreateVertexEventsLazily() {
        if (this.afterCreateVertexEvents == null) {
            this.afterCreateVertexEvents = new ArrayList<CreateVertexEventDescription>();
        }
    }

    private void createBeforeDeleteVertexEventsLazily() {
        if (this.beforeDeleteVertexEvents == null) {
            this.beforeDeleteVertexEvents = new ArrayList<DeleteVertexEventDescription>();
        }
    }

    private void createAfterDeleteVertexEventsLazily() {
        if (this.afterDeleteVertexEvents == null) {
            this.afterDeleteVertexEvents = new ArrayList<DeleteVertexEventDescription>();
        }
    }

    private void createBeforeCreateEdgeEventsLazily() {
        if (this.beforeCreateEdgeEvents == null) {
            this.beforeCreateEdgeEvents = new ArrayList<CreateEdgeEventDescription>();
        }
    }

    private void createAfterCreateEdgeEventsLazily() {
        if (this.afterCreateEdgeEvents == null) {
            this.afterCreateEdgeEvents = new ArrayList<CreateEdgeEventDescription>();
        }
    }

    private void createBeforeDeleteEdgeEventsLazily() {
        if (this.beforeDeleteEdgeEvents == null) {
            this.beforeDeleteEdgeEvents = new ArrayList<DeleteEdgeEventDescription>();
        }
    }

    private void createAfterDeleteEdgeEventsLazily() {
        if (this.afterDeleteEdgeEvents == null) {
            this.afterDeleteEdgeEvents = new ArrayList<DeleteEdgeEventDescription>();
        }
    }

    private void createBeforeChangeAlphaOfEdgeEventsLazily() {
        if (this.beforeChangeAlphaOfEdgeEvents == null) {
            this.beforeChangeAlphaOfEdgeEvents = new ArrayList<ChangeEdgeEventDescription>();
        }
    }

    private void createAfterChangeAlphaOfEdgeEventsLazily() {
        if (this.afterChangeAlphaOfEdgeEvents == null) {
            this.afterChangeAlphaOfEdgeEvents = new ArrayList<ChangeEdgeEventDescription>();
        }
    }

    private void createBeforeChangeOmegaOfEdgeEventsLazily() {
        if (this.beforeChangeOmegaOfEdgeEvents == null) {
            this.beforeChangeOmegaOfEdgeEvents = new ArrayList<ChangeEdgeEventDescription>();
        }
    }

    private void createAfterChangeOmegaOfEdgeEventsLazily() {
        if (this.afterChangeOmegaOfEdgeEvents == null) {
            this.afterChangeOmegaOfEdgeEvents = new ArrayList<ChangeEdgeEventDescription>();
        }
    }

    private void createBeforeChangeAttributeEventsLazily() {
        if (this.beforeChangeAttributeEvents == null) {
            this.beforeChangeAttributeEvents = new ArrayList();
        }
    }

    private void createAfterChangeAttributeEventsLazily() {
        if (this.afterChangeAttributeEvents == null) {
            this.afterChangeAttributeEvents = new ArrayList();
        }
    }

    @Override
    public void fireBeforeCreateVertexEvents(VertexClass vertexClass) {
        if (this.beforeCreateVertexEvents == null) {
            return;
        }
        if (this.increaseAndTestOnMaximumNestedCalls()) {
            return;
        }
        int n = this.beforeCreateVertexEvents.size();
        for (int i = 0; i < n; ++i) {
            this.beforeCreateVertexEvents.get(i).fire(vertexClass);
        }
        --this.nestedTriggerCalls;
    }

    @Override
    public void fireAfterCreateVertexEvents(Vertex vertex) {
        if (this.afterCreateVertexEvents == null) {
            return;
        }
        if (this.increaseAndTestOnMaximumNestedCalls()) {
            return;
        }
        int n = this.afterCreateVertexEvents.size();
        for (int i = 0; i < n; ++i) {
            this.afterCreateVertexEvents.get(i).fire(vertex);
        }
        --this.nestedTriggerCalls;
    }

    @Override
    public void fireBeforeDeleteVertexEvents(Vertex vertex) {
        if (this.beforeDeleteVertexEvents == null) {
            return;
        }
        if (this.increaseAndTestOnMaximumNestedCalls()) {
            return;
        }
        int n = this.beforeDeleteVertexEvents.size();
        for (int i = 0; i < n; ++i) {
            this.beforeDeleteVertexEvents.get(i).fire(vertex);
        }
        --this.nestedTriggerCalls;
    }

    @Override
    public void fireAfterDeleteVertexEvents(VertexClass vertexClass) {
        if (this.afterDeleteVertexEvents == null) {
            return;
        }
        if (this.increaseAndTestOnMaximumNestedCalls()) {
            return;
        }
        int n = this.afterDeleteVertexEvents.size();
        for (int i = 0; i < n; ++i) {
            this.afterDeleteVertexEvents.get(i).fire(vertexClass);
        }
        --this.nestedTriggerCalls;
    }

    @Override
    public void fireBeforeCreateEdgeEvents(EdgeClass edgeClass) {
        if (this.beforeCreateEdgeEvents == null) {
            return;
        }
        if (this.increaseAndTestOnMaximumNestedCalls()) {
            return;
        }
        int n = this.beforeCreateEdgeEvents.size();
        for (int i = 0; i < n; ++i) {
            this.beforeCreateEdgeEvents.get(i).fire(edgeClass);
        }
        --this.nestedTriggerCalls;
    }

    @Override
    public void fireAfterCreateEdgeEvents(Edge edge) {
        if (this.afterCreateEdgeEvents == null) {
            return;
        }
        if (this.increaseAndTestOnMaximumNestedCalls()) {
            return;
        }
        int n = this.afterCreateEdgeEvents.size();
        for (int i = 0; i < n; ++i) {
            this.afterCreateEdgeEvents.get(i).fire(edge);
        }
        --this.nestedTriggerCalls;
    }

    @Override
    public void fireBeforeDeleteEdgeEvents(Edge edge) {
        if (this.beforeDeleteEdgeEvents == null) {
            return;
        }
        if (this.increaseAndTestOnMaximumNestedCalls()) {
            return;
        }
        int n = this.beforeDeleteEdgeEvents.size();
        for (int i = 0; i < n; ++i) {
            this.beforeDeleteEdgeEvents.get(i).fire(edge);
        }
        --this.nestedTriggerCalls;
    }

    @Override
    public void fireAfterDeleteEdgeEvents(EdgeClass edgeClass, Vertex vertex, Vertex vertex2) {
        if (this.afterDeleteEdgeEvents == null) {
            return;
        }
        if (this.increaseAndTestOnMaximumNestedCalls()) {
            return;
        }
        int n = this.afterDeleteEdgeEvents.size();
        for (int i = 0; i < n; ++i) {
            this.afterDeleteEdgeEvents.get(i).fire(edgeClass, vertex, vertex2);
        }
        --this.nestedTriggerCalls;
    }

    @Override
    public void fireBeforeChangeAlphaOfEdgeEvents(Edge edge, Vertex vertex, Vertex vertex2) {
        if (this.beforeChangeAlphaOfEdgeEvents == null) {
            return;
        }
        if (this.increaseAndTestOnMaximumNestedCalls()) {
            return;
        }
        int n = this.beforeChangeAlphaOfEdgeEvents.size();
        for (int i = 0; i < n; ++i) {
            this.beforeChangeAlphaOfEdgeEvents.get(i).fire(edge, vertex, vertex2, ChangeEdgeEventDescription.EdgeEnd.ALPHA);
        }
        --this.nestedTriggerCalls;
    }

    @Override
    public void fireAfterChangeAlphaOfEdgeEvents(Edge edge, Vertex vertex, Vertex vertex2) {
        if (this.afterChangeAlphaOfEdgeEvents == null) {
            return;
        }
        if (this.increaseAndTestOnMaximumNestedCalls()) {
            return;
        }
        int n = this.afterChangeAlphaOfEdgeEvents.size();
        for (int i = 0; i < n; ++i) {
            this.afterChangeAlphaOfEdgeEvents.get(i).fire(edge, vertex, vertex2, ChangeEdgeEventDescription.EdgeEnd.ALPHA);
        }
        --this.nestedTriggerCalls;
    }

    @Override
    public void fireBeforeChangeOmegaOfEdgeEvents(Edge edge, Vertex vertex, Vertex vertex2) {
        if (this.beforeChangeOmegaOfEdgeEvents == null) {
            return;
        }
        if (this.increaseAndTestOnMaximumNestedCalls()) {
            return;
        }
        int n = this.beforeChangeOmegaOfEdgeEvents.size();
        for (int i = 0; i < n; ++i) {
            this.beforeChangeOmegaOfEdgeEvents.get(i).fire(edge, vertex, vertex2, ChangeEdgeEventDescription.EdgeEnd.OMEGA);
        }
        --this.nestedTriggerCalls;
    }

    @Override
    public void fireAfterChangeOmegaOfEdgeEvents(Edge edge, Vertex vertex, Vertex vertex2) {
        if (this.afterChangeOmegaOfEdgeEvents == null) {
            return;
        }
        if (this.increaseAndTestOnMaximumNestedCalls()) {
            return;
        }
        int n = this.afterChangeOmegaOfEdgeEvents.size();
        for (int i = 0; i < n; ++i) {
            this.afterChangeOmegaOfEdgeEvents.get(i).fire(edge, vertex, vertex2, ChangeEdgeEventDescription.EdgeEnd.OMEGA);
        }
        --this.nestedTriggerCalls;
    }

    @Override
    public <AEC extends AttributedElementClass<AEC, ?>> void fireBeforeChangeAttributeEvents(AttributedElement<AEC, ?> attributedElement, String string, Object object, Object object2) {
        if (this.beforeChangeAttributeEvents == null) {
            return;
        }
        if (this.increaseAndTestOnMaximumNestedCalls()) {
            return;
        }
        int n = this.beforeChangeAttributeEvents.size();
        for (int i = 0; i < n; ++i) {
            ChangeAttributeEventDescription<?> changeAttributeEventDescription = this.beforeChangeAttributeEvents.get(i);
            changeAttributeEventDescription.fire(attributedElement, string, object, object2);
        }
        --this.nestedTriggerCalls;
    }

    @Override
    public <AEC extends AttributedElementClass<AEC, ?>> void fireAfterChangeAttributeEvents(AttributedElement<AEC, ?> attributedElement, String string, Object object, Object object2) {
        if (this.afterChangeAttributeEvents == null) {
            return;
        }
        if (this.increaseAndTestOnMaximumNestedCalls()) {
            return;
        }
        int n = this.afterChangeAttributeEvents.size();
        for (int i = 0; i < n; ++i) {
            ChangeAttributeEventDescription<?> changeAttributeEventDescription = this.afterChangeAttributeEvents.get(i);
            changeAttributeEventDescription.fire(attributedElement, string, object, object2);
        }
        --this.nestedTriggerCalls;
    }

    private boolean increaseAndTestOnMaximumNestedCalls() {
        if (this.nestedTriggerCalls == 0) {
            this.blocked = false;
        }
        if (this.blocked) {
            return true;
        }
        ++this.nestedTriggerCalls;
        if (this.nestedTriggerCalls >= this.maxNestedTriggerCalls) {
            this.blocked = true;
            System.err.println("CAUTION: Maximum nested Trigger Calls arrived, Rule evaluation aborted. Stack will become cleaned up.");
            --this.nestedTriggerCalls;
            return true;
        }
        return false;
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    public List<ECARule<?>> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    @Override
    public int getMaxNestedTriggerCalls() {
        return this.maxNestedTriggerCalls;
    }

    @Override
    public void setMaxNestedTriggerCalls(int n) {
        this.maxNestedTriggerCalls = n;
    }

    @Override
    public int getNestedTriggerCalls() {
        return this.nestedTriggerCalls;
    }

    public <AEC extends AttributedElementClass<AEC, ?>> void addECARule(EventDescription<AEC> eventDescription, Action<AEC> action) {
        ECARule<AEC> eCARule = new ECARule<AEC>(eventDescription, action);
        this.addECARule(eCARule);
    }

    public <AEC extends AttributedElementClass<AEC, ?>> void addECARule(EventDescription<AEC> eventDescription, Condition<AEC> condition, Action<AEC> action) {
        ECARule<AEC> eCARule = new ECARule<AEC>(eventDescription, condition, action);
        this.addECARule(eCARule);
    }

    public void addECARule(ECARule<?> eCARule) {
        if (eCARule.getECARuleManager() != null) {
            throw new ECAException("ERROR: Tried to add an ECARule to an ECARulemanager, but the ECARule has already a manager.");
        }
        EventDescription<?> eventDescription = eCARule.getEventDescription();
        for (ECARule<?> eCARule2 : eventDescription.getActiveECARules()) {
            if (eCARule2.getECARuleManager() == this) continue;
            throw new ECAException("ERROR: Tried to add an ECARule to an ECARulemanager, but the Event part monitors already another Graph.");
        }
        this.rules.add(eCARule);
        eCARule.setECARuleManager(this);
        eventDescription.addActiveRule(eCARule);
        if (eventDescription instanceof CreateVertexEventDescription) {
            this.addEventToList((CreateVertexEventDescription)eventDescription);
        }
        if (eventDescription instanceof DeleteVertexEventDescription) {
            this.addEventToList((DeleteVertexEventDescription)eventDescription);
        }
        if (eventDescription instanceof CreateEdgeEventDescription) {
            this.addEventToList((CreateEdgeEventDescription)eventDescription);
        }
        if (eventDescription instanceof DeleteEdgeEventDescription) {
            this.addEventToList((DeleteEdgeEventDescription)eventDescription);
        }
        if (eventDescription instanceof ChangeEdgeEventDescription) {
            this.addEventToList((ChangeEdgeEventDescription)eventDescription);
        }
        if (eventDescription instanceof ChangeAttributeEventDescription) {
            this.addEventToList((ChangeAttributeEventDescription)eventDescription);
        }
    }

    public void deleteECARule(ECARule<?> eCARule) {
        this.rules.remove(eCARule);
        eCARule.setECARuleManager(null);
        EventDescription<?> eventDescription = eCARule.getEventDescription();
        eventDescription.getActiveECARules().remove(eCARule);
        if (eventDescription.getActiveECARules().isEmpty()) {
            if (eventDescription instanceof CreateVertexEventDescription) {
                this.removeEventFromList((CreateVertexEventDescription)eventDescription);
            }
            if (eventDescription instanceof DeleteVertexEventDescription) {
                this.removeEventFromList((DeleteVertexEventDescription)eventDescription);
            }
            if (eventDescription instanceof CreateEdgeEventDescription) {
                this.removeEventFromList((CreateEdgeEventDescription)eventDescription);
            }
            if (eventDescription instanceof DeleteEdgeEventDescription) {
                this.removeEventFromList((DeleteEdgeEventDescription)eventDescription);
            }
            if (eventDescription instanceof ChangeEdgeEventDescription) {
                this.removeEventFromList((ChangeEdgeEventDescription)eventDescription);
            }
            if (eventDescription instanceof ChangeAttributeEventDescription) {
                this.removeEventFromList((ChangeAttributeEventDescription)eventDescription);
            }
        }
    }

    private void addEventToList(CreateVertexEventDescription createVertexEventDescription) {
        if (createVertexEventDescription.getTime().equals((Object)EventDescription.EventTime.BEFORE)) {
            this.createBeforeCreateVertexEventsLazily();
            if (!this.beforeCreateVertexEvents.contains(createVertexEventDescription)) {
                this.beforeCreateVertexEvents.add(createVertexEventDescription);
            }
        } else {
            this.createAfterCreateVertexEventsLazily();
            if (!this.afterCreateVertexEvents.contains(createVertexEventDescription)) {
                this.afterCreateVertexEvents.add(createVertexEventDescription);
            }
        }
    }

    private void addEventToList(DeleteVertexEventDescription deleteVertexEventDescription) {
        if (deleteVertexEventDescription.getTime().equals((Object)EventDescription.EventTime.BEFORE)) {
            this.createBeforeDeleteVertexEventsLazily();
            if (!this.beforeDeleteVertexEvents.contains(deleteVertexEventDescription)) {
                this.beforeDeleteVertexEvents.add(deleteVertexEventDescription);
            }
        } else {
            this.createAfterDeleteVertexEventsLazily();
            if (!this.afterDeleteVertexEvents.contains(deleteVertexEventDescription)) {
                this.afterDeleteVertexEvents.add(deleteVertexEventDescription);
            }
        }
    }

    private void addEventToList(CreateEdgeEventDescription createEdgeEventDescription) {
        if (createEdgeEventDescription.getTime().equals((Object)EventDescription.EventTime.BEFORE)) {
            this.createBeforeCreateEdgeEventsLazily();
            if (!this.beforeCreateEdgeEvents.contains(createEdgeEventDescription)) {
                this.beforeCreateEdgeEvents.add(createEdgeEventDescription);
            }
        } else {
            this.createAfterCreateEdgeEventsLazily();
            if (!this.afterCreateEdgeEvents.contains(createEdgeEventDescription)) {
                this.afterCreateEdgeEvents.add(createEdgeEventDescription);
            }
        }
    }

    private void addEventToList(DeleteEdgeEventDescription deleteEdgeEventDescription) {
        if (deleteEdgeEventDescription.getTime().equals((Object)EventDescription.EventTime.BEFORE)) {
            this.createBeforeDeleteEdgeEventsLazily();
            if (!this.beforeDeleteEdgeEvents.contains(deleteEdgeEventDescription)) {
                this.beforeDeleteEdgeEvents.add(deleteEdgeEventDescription);
            }
        } else {
            this.createAfterDeleteEdgeEventsLazily();
            if (!this.afterDeleteEdgeEvents.contains(deleteEdgeEventDescription)) {
                this.afterDeleteEdgeEvents.add(deleteEdgeEventDescription);
            }
        }
    }

    private void addEventToList(ChangeEdgeEventDescription changeEdgeEventDescription) {
        if (changeEdgeEventDescription.getTime().equals((Object)EventDescription.EventTime.BEFORE)) {
            if (changeEdgeEventDescription.getEdgeEnd().equals((Object)ChangeEdgeEventDescription.EdgeEnd.ALPHA)) {
                this.createBeforeChangeAlphaOfEdgeEventsLazily();
                if (!this.beforeChangeAlphaOfEdgeEvents.contains(changeEdgeEventDescription)) {
                    this.beforeChangeAlphaOfEdgeEvents.add(changeEdgeEventDescription);
                }
            } else if (changeEdgeEventDescription.getEdgeEnd().equals((Object)ChangeEdgeEventDescription.EdgeEnd.OMEGA)) {
                this.createBeforeChangeOmegaOfEdgeEventsLazily();
                if (!this.beforeChangeOmegaOfEdgeEvents.contains(changeEdgeEventDescription)) {
                    this.beforeChangeOmegaOfEdgeEvents.add(changeEdgeEventDescription);
                }
            } else {
                this.createBeforeChangeAlphaOfEdgeEventsLazily();
                this.createBeforeChangeOmegaOfEdgeEventsLazily();
                if (!this.beforeChangeAlphaOfEdgeEvents.contains(changeEdgeEventDescription)) {
                    this.beforeChangeAlphaOfEdgeEvents.add(changeEdgeEventDescription);
                }
                if (!this.beforeChangeOmegaOfEdgeEvents.contains(changeEdgeEventDescription)) {
                    this.beforeChangeOmegaOfEdgeEvents.add(changeEdgeEventDescription);
                }
            }
        } else if (changeEdgeEventDescription.getEdgeEnd().equals((Object)ChangeEdgeEventDescription.EdgeEnd.ALPHA)) {
            this.createAfterChangeAlphaOfEdgeEventsLazily();
            if (!this.afterChangeAlphaOfEdgeEvents.contains(changeEdgeEventDescription)) {
                this.afterChangeAlphaOfEdgeEvents.add(changeEdgeEventDescription);
            }
        } else if (changeEdgeEventDescription.getEdgeEnd().equals((Object)ChangeEdgeEventDescription.EdgeEnd.OMEGA)) {
            this.createAfterChangeOmegaOfEdgeEventsLazily();
            if (!this.afterChangeOmegaOfEdgeEvents.contains(changeEdgeEventDescription)) {
                this.afterChangeOmegaOfEdgeEvents.add(changeEdgeEventDescription);
            }
        } else {
            this.createAfterChangeAlphaOfEdgeEventsLazily();
            this.createAfterChangeOmegaOfEdgeEventsLazily();
            if (!this.afterChangeAlphaOfEdgeEvents.contains(changeEdgeEventDescription)) {
                this.afterChangeAlphaOfEdgeEvents.add(changeEdgeEventDescription);
            }
            if (!this.afterChangeOmegaOfEdgeEvents.contains(changeEdgeEventDescription)) {
                this.afterChangeOmegaOfEdgeEvents.add(changeEdgeEventDescription);
            }
        }
    }

    private <AEC extends AttributedElementClass<AEC, ?>> void addEventToList(ChangeAttributeEventDescription<AEC> changeAttributeEventDescription) {
        if (changeAttributeEventDescription.getTime().equals((Object)EventDescription.EventTime.BEFORE)) {
            this.createBeforeChangeAttributeEventsLazily();
            if (!this.beforeChangeAttributeEvents.contains(changeAttributeEventDescription)) {
                this.beforeChangeAttributeEvents.add(changeAttributeEventDescription);
            }
        } else {
            this.createAfterChangeAttributeEventsLazily();
            if (!this.afterChangeAttributeEvents.contains(changeAttributeEventDescription)) {
                this.afterChangeAttributeEvents.add(changeAttributeEventDescription);
            }
        }
    }

    private void removeEventFromList(CreateVertexEventDescription createVertexEventDescription) {
        if (createVertexEventDescription.getTime().equals((Object)EventDescription.EventTime.BEFORE)) {
            this.beforeCreateVertexEvents.remove(createVertexEventDescription);
        } else {
            this.afterCreateVertexEvents.remove(createVertexEventDescription);
        }
    }

    private void removeEventFromList(DeleteVertexEventDescription deleteVertexEventDescription) {
        if (deleteVertexEventDescription.getTime().equals((Object)EventDescription.EventTime.BEFORE)) {
            this.beforeDeleteVertexEvents.remove(deleteVertexEventDescription);
        } else {
            this.afterDeleteVertexEvents.remove(deleteVertexEventDescription);
        }
    }

    private void removeEventFromList(CreateEdgeEventDescription createEdgeEventDescription) {
        if (createEdgeEventDescription.getTime().equals((Object)EventDescription.EventTime.BEFORE)) {
            this.beforeCreateEdgeEvents.remove(createEdgeEventDescription);
        } else {
            this.afterCreateEdgeEvents.remove(createEdgeEventDescription);
        }
    }

    private void removeEventFromList(DeleteEdgeEventDescription deleteEdgeEventDescription) {
        if (deleteEdgeEventDescription.getTime().equals((Object)EventDescription.EventTime.BEFORE)) {
            this.beforeDeleteEdgeEvents.remove(deleteEdgeEventDescription);
        } else {
            this.afterDeleteEdgeEvents.remove(deleteEdgeEventDescription);
        }
    }

    private void removeEventFromList(ChangeEdgeEventDescription changeEdgeEventDescription) {
        if (changeEdgeEventDescription.getTime().equals((Object)EventDescription.EventTime.BEFORE)) {
            this.beforeChangeAlphaOfEdgeEvents.remove(changeEdgeEventDescription);
            this.beforeChangeOmegaOfEdgeEvents.remove(changeEdgeEventDescription);
        } else {
            this.afterChangeAlphaOfEdgeEvents.remove(changeEdgeEventDescription);
            this.afterChangeOmegaOfEdgeEvents.remove(changeEdgeEventDescription);
        }
    }

    private <AEC extends AttributedElementClass<AEC, ?>> void removeEventFromList(ChangeAttributeEventDescription<AEC> changeAttributeEventDescription) {
        if (changeAttributeEventDescription.getTime().equals((Object)EventDescription.EventTime.BEFORE)) {
            this.beforeChangeAttributeEvents.remove(changeAttributeEventDescription);
        } else {
            this.afterChangeAttributeEvents.remove(changeAttributeEventDescription);
        }
    }
}

