/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.algolib.algorithms.topological_order;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmTerminatedException;
import de.uni_koblenz.jgralab.algolib.algorithms.StructureOrientedAlgorithm;
import de.uni_koblenz.jgralab.algolib.algorithms.search.DepthFirstSearch;
import de.uni_koblenz.jgralab.algolib.algorithms.search.visitors.DFSVisitorAdapter;
import de.uni_koblenz.jgralab.algolib.algorithms.topological_order.visitors.TopologicalOrderVisitor;
import de.uni_koblenz.jgralab.algolib.algorithms.topological_order.visitors.TopologicalOrderVisitorList;
import de.uni_koblenz.jgralab.algolib.functions.BooleanFunction;
import de.uni_koblenz.jgralab.algolib.functions.Permutation;
import de.uni_koblenz.jgralab.algolib.problems.AcyclicitySolver;
import de.uni_koblenz.jgralab.algolib.problems.TopologicalOrderSolver;
import de.uni_koblenz.jgralab.algolib.visitors.Visitor;

public class TopologicalOrderWithDFS
extends StructureOrientedAlgorithm
implements AcyclicitySolver,
TopologicalOrderSolver {
    private DepthFirstSearch dfs;
    private DFSVisitorAdapter torderVisitorAdapter;
    private boolean acyclic;
    private TopologicalOrderVisitorList visitors;

    public TopologicalOrderWithDFS(Graph graph, DepthFirstSearch depthFirstSearch, BooleanFunction<Edge> booleanFunction) {
        super(graph, booleanFunction);
        this.dfs = depthFirstSearch;
    }

    public TopologicalOrderWithDFS(Graph graph, DepthFirstSearch depthFirstSearch) {
        this(graph, depthFirstSearch, null);
    }

    @Override
    public void addVisitor(Visitor visitor) {
        this.checkStateForSettingVisitors();
        if (visitor instanceof TopologicalOrderVisitor) {
            visitor.setAlgorithm(this);
            this.visitors.addVisitor(visitor);
        } else {
            this.dfs.addVisitor(visitor);
        }
    }

    @Override
    public void removeVisitor(Visitor visitor) {
        this.checkStateForSettingVisitors();
        if (visitor instanceof TopologicalOrderVisitor) {
            this.visitors.removeVisitor(visitor);
        } else {
            this.dfs.removeVisitor(visitor);
        }
    }

    @Override
    public void disableOptionalResults() {
    }

    @Override
    public StructureOrientedAlgorithm normal() {
        super.normal();
        return this;
    }

    @Override
    public StructureOrientedAlgorithm reversed() {
        super.reversed();
        return this;
    }

    @Override
    public boolean isHybrid() {
        return false;
    }

    @Override
    public void resetParameters() {
        super.resetParameters();
        this.visitors = new TopologicalOrderVisitorList();
        this.torderVisitorAdapter = new DFSVisitorAdapter(){

            @Override
            public void visitBackwardArc(Edge edge) throws AlgorithmTerminatedException {
                TopologicalOrderWithDFS.this.acyclic = false;
                TopologicalOrderWithDFS.this.dfs.terminate();
            }

            @Override
            public void leaveVertex(Vertex vertex) throws AlgorithmTerminatedException {
                TopologicalOrderWithDFS.this.visitors.visitVertexInTopologicalOrder(vertex);
            }
        };
        this.normal();
    }

    @Override
    public void reset() {
        super.reset();
        this.acyclic = true;
    }

    @Override
    public TopologicalOrderWithDFS execute() throws AlgorithmTerminatedException {
        this.dfs.reset();
        this.dfs.setGraph(this.graph);
        this.dfs.setNavigable(this.navigable);
        if (this.traversalDirection == EdgeDirection.OUT) {
            this.dfs.reversed();
        } else {
            assert (this.traversalDirection == EdgeDirection.IN);
            this.dfs.normal();
        }
        this.dfs.addVisitor(this.torderVisitorAdapter);
        this.startRunning();
        try {
            this.dfs.withRorder().execute();
        }
        catch (AlgorithmTerminatedException algorithmTerminatedException) {
            // empty catch block
        }
        this.done();
        this.dfs.removeVisitor(this.torderVisitorAdapter);
        return this;
    }

    @Override
    protected void done() {
        this.state = this.dfs.getState();
    }

    @Override
    public Permutation<Vertex> getTopologicalOrder() {
        this.checkStateForResult();
        return this.dfs.getRorder();
    }

    @Override
    public boolean isAcyclic() {
        this.checkStateForResult();
        return this.acyclic;
    }
}

