/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.ist.utilities.gui;

import de.uni_koblenz.ist.utilities.gui.OSXAdapter;
import de.uni_koblenz.ist.utilities.gui.RecentFilesList;
import de.uni_koblenz.ist.utilities.gui.StatusBar;
import de.uni_koblenz.ist.utilities.gui.UnifiedToolbarPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;

public abstract class SwingApplication
extends JFrame {
    public static boolean RUNS_ON_WINDOWS = System.getProperty("os.name").toLowerCase().startsWith("windows");
    public static boolean RUNS_ON_LINUX = System.getProperty("os.name").toLowerCase().startsWith("linux");
    public static boolean RUNS_ON_MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    protected JMenu fileMenu;
    protected JMenu recentFilesMenu;
    protected Action fileClearRecentFilesList;
    protected Action fileNewAction;
    protected Action fileOpenAction;
    protected Action fileSaveAction;
    protected Action fileSaveAsAction;
    protected Action fileCloseAction;
    protected Action filePrintAction;
    protected Action fileExitAction;
    protected JMenu editMenu;
    protected Action editUndoAction;
    protected Action editRedoAction;
    protected Action editCopyAction;
    protected Action editCutAction;
    protected Action editPasteAction;
    protected Action editPreferencesAction;
    protected JMenu helpMenu;
    protected Action helpAboutAction;
    private boolean modified;
    private JMenuBar menuBar;
    protected JPanel toolBar;
    private JPanel contentPanel;
    private StatusBar statusBar;
    protected int menuEventMask;
    private ResourceBundle messages;

    public SwingApplication(ResourceBundle resourceBundle) {
        super(resourceBundle.getString("Application.mainwindow.title"));
        this.messages = resourceBundle;
    }

    public String getMessage(String string) {
        try {
            return this.messages.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println(string);
            return '!' + string + '!';
        }
    }

    public String getMessage(String string, String string2) {
        try {
            return this.messages.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println(string);
            return string2;
        }
    }

    public void initializeApplication() {
        this.setDefaultCloseOperation(0);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (RUNS_ON_MAC_OS_X) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        this.menuEventMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.createActions();
        this.setJMenuBar(this.createMenuBar());
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BorderLayout());
        this.toolBar = this.createToolBar();
        this.contentPanel.add((Component)this.toolBar, "North");
        this.statusBar = this.createStatusBar();
        this.contentPanel.add((Component)this.statusBar, "South");
        Component component = this.createContent();
        this.contentPanel.add(component, "Center");
        this.getContentPane().add(this.contentPanel);
        this.updateActions();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SwingApplication.this.fileExit();
            }
        });
        this.pack();
    }

    protected JPanel createToolBar() {
        JPanel jPanel = RUNS_ON_MAC_OS_X ? new UnifiedToolbarPanel() : new JPanel();
        return jPanel;
    }

    public int getMenuEventMask() {
        return this.menuEventMask;
    }

    protected void createActions() {
        this.fileClearRecentFilesList = new AbstractAction(this.getMessage("Application.Action.File.ClearRecentFiles", "Clear list")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingApplication.this.fileClearRecentFiles();
            }
        };
        this.fileNewAction = new AbstractAction(this.getMessage("Application.Action.File.New", "New")){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, SwingApplication.this.menuEventMask));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingApplication.this.fileNew();
            }
        };
        this.fileOpenAction = new AbstractAction(this.getMessage("Application.Action.File.Open", "Open ...")){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, SwingApplication.this.menuEventMask));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingApplication.this.fileOpen();
            }
        };
        this.fileSaveAction = new AbstractAction(this.getMessage("Application.Action.File.Save", "Save")){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, SwingApplication.this.menuEventMask));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingApplication.this.fileSave();
            }
        };
        this.fileSaveAsAction = new AbstractAction(this.getMessage("Application.Action.File.SaveAs", "Save as ...")){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 0x40 | SwingApplication.this.menuEventMask));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingApplication.this.fileSaveAs();
            }
        };
        this.fileCloseAction = new AbstractAction(this.getMessage("Application.Action.File.Close", "Close ...")){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(87, SwingApplication.this.menuEventMask));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingApplication.this.fileClose();
            }
        };
        this.filePrintAction = new AbstractAction(this.getMessage("Application.Action.File.Print", "Print ...")){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, SwingApplication.this.menuEventMask));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingApplication.this.filePrint();
            }
        };
        this.fileExitAction = new AbstractAction(this.getMessage("Application.Action.File.Exit", "Exit")){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(81, SwingApplication.this.menuEventMask));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingApplication.this.fileExit();
            }
        };
        this.editUndoAction = new AbstractAction(this.getMessage("Application.Action.Edit.Undo", "Undo")){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, SwingApplication.this.menuEventMask));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingApplication.this.editUndo();
            }
        };
        this.editRedoAction = new AbstractAction(this.getMessage("Application.Action.Edit.Redo", "Redo")){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, 0x40 | SwingApplication.this.menuEventMask));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingApplication.this.editRedo();
            }
        };
        this.editCutAction = new AbstractAction(this.getMessage("Application.Action.Edit.Cut", "Cut")){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, SwingApplication.this.menuEventMask));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingApplication.this.editCut();
            }
        };
        this.editCopyAction = new AbstractAction(this.getMessage("Application.Action.Edit.Copy", "Copy")){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, SwingApplication.this.menuEventMask));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingApplication.this.editCopy();
            }
        };
        this.editPasteAction = new AbstractAction(this.getMessage("Application.Action.Edit.Paste", "Paste")){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, SwingApplication.this.menuEventMask));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingApplication.this.editPaste();
            }
        };
        this.editPreferencesAction = new AbstractAction(this.getMessage("Application.Action.Edit.Settings", "Settings")){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(44, SwingApplication.this.menuEventMask));
                this.setEnabled(true);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingApplication.this.editPreferences();
            }
        };
        this.helpAboutAction = new AbstractAction(MessageFormat.format(this.getMessage("Application.Action.Help.About", "About {0} ..."), this.getTitle())){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingApplication.this.helpAbout();
            }
        };
    }

    protected JMenuBar createMenuBar() {
        this.recentFilesMenu = new JMenu(this.getMessage("Application.Menu.File.RecentFiles", "Recent files"));
        this.recentFilesMenu.addSeparator();
        this.recentFilesMenu.add(this.fileClearRecentFilesList);
        this.fileMenu = new JMenu(this.getMessage(RUNS_ON_MAC_OS_X ? "Application.Menu.File.MacOS" : "Application.Menu.File", "File"));
        this.fileMenu.add(this.fileNewAction);
        this.fileMenu.add(this.fileOpenAction);
        this.fileMenu.add(this.recentFilesMenu);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.fileCloseAction);
        this.fileMenu.add(this.fileSaveAction);
        this.fileMenu.add(this.fileSaveAsAction);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.filePrintAction);
        if (RUNS_ON_MAC_OS_X) {
            try {
                OSXAdapter.setPreferencesHandler(this, SwingApplication.class.getDeclaredMethod("editPreferences", new Class[0]));
                OSXAdapter.setQuitHandler(this, SwingApplication.class.getDeclaredMethod("fileExit", new Class[0]));
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
        } else {
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.fileExitAction);
        }
        this.editMenu = new JMenu(this.getMessage("Application.Menu.Edit", "Edit"));
        this.editMenu.add(this.editUndoAction);
        this.editMenu.add(this.editRedoAction);
        this.editMenu.addSeparator();
        this.editMenu.add(this.editCutAction);
        this.editMenu.add(this.editCopyAction);
        this.editMenu.add(this.editPasteAction);
        if (!RUNS_ON_MAC_OS_X) {
            this.editMenu.addSeparator();
            this.editMenu.add(this.editPreferencesAction);
        }
        this.helpMenu = new JMenu(this.getMessage("Application.Menu.Help", "Help"));
        if (RUNS_ON_MAC_OS_X) {
            try {
                OSXAdapter.setAboutHandler(this, SwingApplication.class.getDeclaredMethod("helpAbout", new Class[0]));
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
        } else {
            this.helpMenu.add(this.helpAboutAction);
        }
        this.menuBar = new JMenuBar();
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.editMenu);
        this.menuBar.add(this.helpMenu);
        return this.menuBar;
    }

    protected ImageIcon getApplicationIcon() {
        return null;
    }

    public String getApplicationName() {
        return this.getMessage("Application.name");
    }

    protected StatusBar createStatusBar() {
        return new StatusBar(this);
    }

    protected void updateActions() {
    }

    protected void fileClearRecentFiles() {
    }

    protected void fileNew() {
    }

    protected void fileOpen() {
    }

    public void fileOpenRecent(RecentFilesList recentFilesList, String string) {
    }

    protected void fileSave() {
    }

    protected boolean fileSaveAs() {
        return false;
    }

    protected void fileClose() {
    }

    protected void filePrint() {
    }

    protected void editUndo() {
    }

    protected void editRedo() {
    }

    protected void editCut() {
    }

    protected void editCopy() {
    }

    protected void editPaste() {
    }

    protected void editPreferences() {
    }

    protected boolean fileExit() {
        if (this.confirmExit()) {
            System.exit(0);
        }
        return false;
    }

    protected void helpAbout() {
    }

    protected abstract Component createContent();

    protected boolean confirmExit() {
        return false;
    }

    protected boolean confirmClose() {
        return false;
    }

    public abstract String getVersion();

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean bl) {
        if (this.modified == bl) {
            return;
        }
        if (RUNS_ON_MAC_OS_X) {
            this.getRootPane().putClientProperty("Window.documentModified", bl);
        }
        this.modified = bl;
    }

    public static void invokeAndWait(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }

    public static void invokeLater(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    protected String getKeyStrokeAsString(KeyStroke keyStroke) {
        String string = "";
        if ((keyStroke.getModifiers() & 0x40) != 0) {
            string = string + (RUNS_ON_MAC_OS_X ? "\u21e7" : this.getMessage("Application.Key.Shift", "Shift"));
        }
        if ((keyStroke.getModifiers() & 0x80) != 0) {
            string = string + (RUNS_ON_MAC_OS_X ? "\u2303" : (string.length() > 0 ? "+" : "") + this.getMessage("Application.Key.Ctrl", "Ctrl"));
        }
        if ((keyStroke.getModifiers() & 0x200) != 0) {
            string = string + (RUNS_ON_MAC_OS_X ? "\u2325" : (string.length() > 0 ? "+" : "") + this.getMessage("Application.Key.Alt", "Alt"));
        }
        if ((keyStroke.getModifiers() & 0x2000) != 0) {
            string = string + (string.length() > 0 ? "+" : "") + this.getMessage("Application.Key.AltGr", "AltGr");
        }
        if ((keyStroke.getModifiers() & 0x100) != 0) {
            string = string + (RUNS_ON_MAC_OS_X ? "\u2318" : (string.length() > 0 ? "+" : "") + this.getMessage("Application.Key.Meta", "Meta"));
        }
        string = RUNS_ON_MAC_OS_X ? string + (char)keyStroke.getKeyCode() : string + (string.length() > 0 ? "+" : "") + (char)keyStroke.getKeyCode();
        return string;
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.updateActions();
        }
    }

    public class FileDialog {
        private File lastDir;
        private String appName;

        public FileDialog(String string) {
            this.appName = string;
        }

        public void setDirectory(File file) {
            if (file.exists() && file.isDirectory() && file.canRead()) {
                this.lastDir = file;
            }
        }

        public File showFileOpenDialog(JFrame jFrame, String string, final String string2, final String string3) {
            File file = null;
            if (RUNS_ON_MAC_OS_X) {
                java.awt.FileDialog fileDialog = new java.awt.FileDialog((Frame)jFrame, string, 0);
                if (this.lastDir != null) {
                    fileDialog.setDirectory(this.lastDir.getAbsolutePath());
                }
                fileDialog.setFilenameFilter(new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String string) {
                        File file2 = new File(file, string);
                        return file2.canRead() && string.endsWith(string2);
                    }
                });
                fileDialog.setModal(true);
                if (RUNS_ON_MAC_OS_X) {
                    SwingApplication.this.menuBar.setEnabled(false);
                }
                fileDialog.setVisible(true);
                if (RUNS_ON_MAC_OS_X) {
                    SwingApplication.this.menuBar.setEnabled(true);
                }
                if (fileDialog.getFile() != null) {
                    String string4 = fileDialog.getDirectory() + fileDialog.getFile();
                    file = new File(string4);
                }
            } else {
                File file2;
                JFileChooser jFileChooser = new JFileChooser(this.lastDir);
                jFileChooser.setDialogTitle(string);
                jFileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return string3;
                    }

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory() || file.canRead() && file.isFile() && file.getAbsolutePath().endsWith(string2);
                    }
                });
                if (jFileChooser.showOpenDialog(jFrame) == 0 && (file2 = jFileChooser.getSelectedFile()).isFile()) {
                    file = file2;
                }
                this.lastDir = jFileChooser.getCurrentDirectory();
            }
            return file;
        }

        public File showFileSaveAsDialog(JFrame jFrame, String string, final String string2, File file) {
            java.awt.FileDialog fileDialog = new java.awt.FileDialog((Frame)jFrame, string, 1);
            fileDialog.setFilenameFilter(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    File file2 = new File(file, string);
                    return file2.canRead() && file2.canWrite() && string.endsWith(string2);
                }
            });
            fileDialog.setModal(true);
            if (RUNS_ON_MAC_OS_X) {
                SwingApplication.this.menuBar.setEnabled(false);
            }
            fileDialog.setVisible(true);
            if (RUNS_ON_MAC_OS_X) {
                SwingApplication.this.menuBar.setEnabled(true);
            }
            if (fileDialog.getFile() != null) {
                String string3 = fileDialog.getDirectory() + fileDialog.getFile();
                if (!string3.endsWith(string2)) {
                    string3 = string3 + string2;
                }
                File file2 = new File(string3);
                System.out.println(file2);
                if (file2.exists() ? JOptionPane.showConfirmDialog(jFrame, MessageFormat.format(SwingApplication.this.getMessage("Application.FileDialog.Overwrite", "File {0} exists. Overwrite?"), file2.getName()), this.appName, 1, 3) == 0 : !file2.exists() && file2.getParentFile().canWrite()) {
                    return file2;
                }
            }
            return null;
        }
    }
}

