/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.ist.utilities.gui;

import de.uni_koblenz.ist.utilities.gui.SwingApplication;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontSelectionDialog
extends JDialog {
    private static final long serialVersionUID = 8838643052145525312L;
    private final JList familyList;
    private final JLabel previewLabel;
    private final JList styleList;
    private String family;
    private int style;
    private Font selectedFont;
    private final JList sizeList;
    private final BoundedRangeModel fontSize;
    private final JLabel fontNameLabel;
    private final JTextField sizeField;
    private SwingApplication app;

    public static Font selectFont(SwingApplication swingApplication, String string, Font font, boolean bl) {
        FontSelectionDialog fontSelectionDialog = new FontSelectionDialog(swingApplication, string, font, bl);
        fontSelectionDialog.setVisible(true);
        return fontSelectionDialog.getSelectedFont();
    }

    private FontSelectionDialog(SwingApplication swingApplication, String string, Font font, boolean bl) {
        super((Frame)swingApplication, string != null ? string : swingApplication.getMessage("FontSelectionDialog.Title"));
        Object object;
        Object object2;
        Integer[] integerArray;
        Serializable serializable;
        Object object32;
        Object object4;
        Serializable serializable2;
        this.app = swingApplication;
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                super.windowClosing(windowEvent);
                FontSelectionDialog.this.selectedFont = null;
            }
        });
        Object[] objectArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        Arrays.sort(objectArray);
        if (bl) {
            serializable2 = new ArrayList();
            object4 = new FontRenderContext(AffineTransform.getTranslateInstance(0.0, 0.0), false, false);
            for (Object object32 : objectArray) {
                serializable = new Font((String)object32, 0, 10);
                integerArray = ((Font)serializable).getStringBounds("i", (FontRenderContext)object4);
                object2 = ((Font)serializable).getStringBounds("m", (FontRenderContext)object4);
                if (integerArray.getWidth() != ((RectangularShape)object2).getWidth()) continue;
                ((ArrayList)serializable2).add(object32);
            }
            objectArray = new String[((ArrayList)serializable2).size()];
            int n = 0;
            object = ((ArrayList)serializable2).iterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                objectArray[n++] = string2;
            }
        }
        serializable2 = new Font("SansSerif", 0, 11);
        this.familyList = new JList<Object>(objectArray);
        this.familyList.setFont((Font)serializable2);
        this.familyList.setSelectionMode(0);
        this.familyList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = FontSelectionDialog.this.familyList.getSelectedIndex();
                if (n >= 0) {
                    FontSelectionDialog.this.setFamily((String)FontSelectionDialog.this.familyList.getModel().getElementAt(n));
                }
            }
        });
        object4 = new JPanel();
        ((Container)object4).setLayout(new BorderLayout(0, 4));
        JLabel jLabel = new JLabel(this.app.getMessage("FontSelectionDialog.FamilyLabel"), 2);
        jLabel.setFont((Font)serializable2);
        ((Container)object4).add((Component)jLabel, "North");
        object = new JScrollPane(this.familyList);
        ((Container)object4).add((Component)object, "Center");
        String[] stringArray = new String[]{this.app.getMessage("FontSelectionDialog.PlainStyle"), this.app.getMessage("FontSelectionDialog.BoldStyle"), this.app.getMessage("FontSelectionDialog.ItalicStyle"), this.app.getMessage("FontSelectionDialog.BoldItalicStyle")};
        this.styleList = new JList<String>(stringArray);
        this.styleList.setSelectionMode(0);
        this.styleList.setFont((Font)serializable2);
        this.styleList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = FontSelectionDialog.this.styleList.getSelectedIndex();
                if (n >= 0) {
                    switch (n) {
                        case 0: {
                            FontSelectionDialog.this.setStyle(0);
                            break;
                        }
                        case 1: {
                            FontSelectionDialog.this.setStyle(1);
                            break;
                        }
                        case 2: {
                            FontSelectionDialog.this.setStyle(2);
                            break;
                        }
                        case 3: {
                            FontSelectionDialog.this.setStyle(3);
                        }
                    }
                }
            }
        });
        object32 = new JPanel();
        ((Container)object32).setLayout(new BorderLayout(0, 4));
        jLabel = new JLabel(this.app.getMessage("FontSelectionDialog.StyleLabel"), 2);
        jLabel.setFont((Font)serializable2);
        ((Container)object32).add((Component)jLabel, "North");
        object = new JScrollPane(this.styleList);
        ((Container)object32).add((Component)object, "Center");
        this.fontSize = new DefaultBoundedRangeModel(12, 0, 9, 288);
        this.fontSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                FontSelectionDialog.this.setSelectedFont();
                if (changeEvent.getSource() != FontSelectionDialog.this.sizeField) {
                    FontSelectionDialog.this.sizeField.setText(Integer.toString(FontSelectionDialog.this.fontSize.getValue()));
                }
                if (changeEvent.getSource() != FontSelectionDialog.this.sizeList) {
                    for (int i = 0; i < FontSelectionDialog.this.sizeList.getModel().getSize(); ++i) {
                        if (((Integer)FontSelectionDialog.this.sizeList.getModel().getElementAt(i)).intValue() != FontSelectionDialog.this.fontSize.getValue()) continue;
                        FontSelectionDialog.this.sizeList.setSelectedIndex(i);
                        FontSelectionDialog.this.sizeList.ensureIndexIsVisible(i);
                        return;
                    }
                    FontSelectionDialog.this.sizeList.clearSelection();
                }
            }
        });
        serializable = new JSlider(this.fontSize);
        ((JSlider)serializable).setOrientation(1);
        integerArray = new Integer[]{9, 10, 11, 12, 13, 14, 18, 24, 36, 48, 64, 72, 96, 144, 288};
        this.sizeList = new JList<Integer>(integerArray);
        this.sizeList.setFont((Font)serializable2);
        this.sizeList.setSelectionMode(0);
        this.sizeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = FontSelectionDialog.this.sizeList.getSelectedIndex();
                if (n >= 0) {
                    int n2 = (Integer)FontSelectionDialog.this.sizeList.getModel().getElementAt(n);
                    FontSelectionDialog.this.fontSize.setValue(n2);
                }
            }
        });
        object2 = new JPanel();
        ((Container)object2).setLayout(new BorderLayout(0, 0));
        jLabel = new JLabel(this.app.getMessage("FontSelectionDialog.SizeLabel"), 2);
        jLabel.setFont((Font)serializable2);
        ((Container)object2).add((Component)jLabel, "North");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.sizeField = new JTextField("13");
        this.sizeField.setHorizontalAlignment(0);
        this.sizeField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent jComponent) {
                try {
                    Integer.parseInt(FontSelectionDialog.this.sizeField.getText().trim());
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
        });
        jPanel.add((Component)this.sizeField, "North");
        this.sizeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (FontSelectionDialog.this.sizeField.getInputVerifier().verify(FontSelectionDialog.this.sizeField)) {
                    FontSelectionDialog.this.fontSize.setValue(Integer.parseInt(FontSelectionDialog.this.sizeField.getText().trim()));
                }
            }
        });
        object = new JScrollPane(this.sizeList);
        jPanel.add((Component)object, "West");
        jPanel.add((Component)serializable, "East");
        ((Container)object2).add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(4, 4));
        jPanel2.setBackground(Color.WHITE);
        this.previewLabel = new JLabel(this.app.getMessage("FontSelectionDialog.SampleText"), 0);
        this.previewLabel.setPreferredSize(new Dimension(320, 60));
        this.fontNameLabel = new JLabel(this.app.getMessage("FontSelectionDialog.FontNameLabel"), 0);
        this.fontNameLabel.setForeground(Color.GRAY);
        this.fontNameLabel.setFont((Font)serializable2);
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        jPanel2.add((Component)this.fontNameLabel, "South");
        jPanel2.add((Component)this.previewLabel, "Center");
        jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(4, 0));
        jPanel.add((Component)object4, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(4, 0));
        jPanel3.add((Component)object32, "Center");
        jPanel3.add((Component)object2, "East");
        jPanel.add((Component)jPanel3, "East");
        JPanel jPanel4 = new JPanel();
        JButton jButton = new JButton(this.app.getMessage("FontSelectionDialog.OkButtonText"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontSelectionDialog.this.setVisible(false);
                FontSelectionDialog.this.dispose();
            }
        });
        JButton jButton2 = new JButton(this.app.getMessage("FontSelectionDialog.CancelButtonText"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontSelectionDialog.this.selectedFont = null;
                FontSelectionDialog.this.setVisible(false);
                FontSelectionDialog.this.dispose();
            }
        });
        jPanel4.add(jButton);
        jPanel4.add(jButton2);
        jPanel.add((Component)jPanel4, "South");
        jPanel.setPreferredSize(new Dimension(this.previewLabel.getPreferredSize().width, 180));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(4, 4));
        jPanel5.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel5.add((Component)jPanel2, "Center");
        jPanel5.add((Component)jPanel, "South");
        this.getContentPane().add(jPanel5);
        if (font == null) {
            font = new Font(bl ? "Monospaced" : "SansSerif", 0, 13);
        }
        this.family = font.getFamily();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!this.family.equals(objectArray[i])) continue;
            this.familyList.setSelectedIndex(i);
            this.familyList.ensureIndexIsVisible(i);
            break;
        }
        this.style = font.getStyle();
        switch (this.style) {
            case 0: {
                this.styleList.setSelectedIndex(0);
                break;
            }
            case 1: {
                this.styleList.setSelectedIndex(1);
                break;
            }
            case 2: {
                this.styleList.setSelectedIndex(2);
                break;
            }
            case 3: {
                this.styleList.setSelectedIndex(3);
            }
        }
        this.fontSize.setValue(font.getSize());
        this.pack();
    }

    private void setFamily(String string) {
        if (!this.family.equals(string)) {
            this.family = string;
            this.setSelectedFont();
        }
    }

    private void setStyle(int n) {
        if (this.style != n) {
            this.style = n;
            this.setSelectedFont();
        }
    }

    private String getStyleAsString() {
        switch (this.style) {
            case 0: {
                return this.app.getMessage("FontSelectionDialog.PlainSampleText");
            }
            case 1: {
                return this.app.getMessage("FontSelectionDialog.BoldSampleText");
            }
            case 2: {
                return this.app.getMessage("FontSelectionDialog.ItalicSampleText");
            }
            case 3: {
                return this.app.getMessage("FontSelectionDialog.BoldItalicSampleText");
            }
        }
        return this.app.getMessage("FontSelectionDialog.UnknownExampleText");
    }

    public static String getFontName(SwingApplication swingApplication, Font font) {
        String string = font.getStyle() == 0 ? swingApplication.getMessage("FontSelectionDialog.PlainStyle") : (font.getStyle() == 1 ? swingApplication.getMessage("FontSelectionDialog.BoldStyle") : (font.getStyle() == 2 ? swingApplication.getMessage("FontSelectionDialog.ItalicStyle") : swingApplication.getMessage("FontSelectionDialog.BoldItalicStyle")));
        return font.getFamily() + "-" + string + "-" + font.getSize();
    }

    public static String getInternalFontName(Font font) {
        String string = font.getStyle() == 0 ? "plain" : (font.getStyle() == 1 ? "bold" : (font.getStyle() == 2 ? "italic" : "bolditalic"));
        return font.getFamily() + "-" + string + "-" + font.getSize();
    }

    private int getFontSize() {
        return this.fontSize.getValue();
    }

    private void setSelectedFont() {
        this.selectedFont = new Font(this.family, this.style, this.fontSize.getValue());
        this.previewLabel.setFont(this.selectedFont);
        this.fontNameLabel.setText(MessageFormat.format(this.app.getMessage("FontSelectionDialog.FontNameDisplay"), this.selectedFont.getName(), this.getStyleAsString(), this.getFontSize()));
    }

    private Font getSelectedFont() {
        return this.selectedFont;
    }
}

