package org.riediger.plist;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Map.Entry;

public class PListDict {
	Map<String, Object> map;

	public PListDict() {
		map = new TreeMap<String, Object>();
	}

	public int size() {
		return map.size();
	}

	public Set<Entry<String, Object>> entrySet() {
		return map.entrySet();
	}

	public void put(String key, Object value) {
		map.put(key, value);
	}

	public void remove(String key) {
		map.remove(key);
	}

	public Object get(String key) {
		return map.get(key);
	}

	public boolean containsKey(String key) {
		return map.containsKey(key);
	}

	public boolean getBoolean(String key) {
		return (((Boolean) (map.get(key))).booleanValue());
	}

	public boolean getBoolean(String key, boolean v) {
		return map.containsKey(key) ? (((Boolean) (map.get(key)))
				.booleanValue()) : v;
	}

	public int getInteger(String key) {
		return (((Integer) (map.get(key))).intValue());
	}

	public int getInteger(String key, int v) {
		return map.containsKey(key) ? (((Integer) (map.get(key))).intValue())
				: v;
	}

	public double getDouble(String key) {
		return (((Double) (map.get(key))).doubleValue());
	}

	public double getDouble(String key, double v) {
		return map.containsKey(key) ? (((Double) (map.get(key))).doubleValue())
				: v;
	}

	public Date getDate(String key) {
		return (Date) (map.get(key));
	}

	public Date getDate(String key, Date v) {
		return map.containsKey(key) ? (Date) (map.get(key)) : v;
	}

	public void putBoolean(String key, boolean value) {
		map.put(key, value);
	}

	public void putInteger(String key, int value) {
		map.put(key, value);
	}

	public void putDouble(String key, double value) {
		map.put(key, value);
	}

	public void putDate(String key, Date value) {
		map.put(key, value);
	}

	public void putString(String key, String value) {
		map.put(key, value);
	}

	public PListDict getDict(String key) {
		return (PListDict) (map.get(key));
	}

	public void putDict(String key, PListDict value) {
		map.put(key, value);
	}

	@SuppressWarnings("unchecked")
	public <E> List<E> getArray(String key) {
		return (List<E>) (map.get(key));
	}

	@SuppressWarnings("unchecked")
	public <E> List<E> getArray(String key, List<E> v) {
		return map.containsKey(key) ? (List<E>) (map.get(key)) : v;
	}

	public <E> void putArray(String key, List<E> value) {
		map.put(key, value);
	}

	public String getString(String key) {
		return (String) (map.get(key));
	}

	public String getString(String key, String v) {
		return map.containsKey(key) ? (String) (map.get(key)) : v;
	}

	public Collection<Object> values() {
		return map.values();
	}
}
