package org.riediger.plist;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MinimalSAXParser {
	enum State {
		STATE_INIT, STATE_SKIPTO_GT, STATE_STARTELEMENT, STATE_ENDELEMENT
	};

	private BufferedReader rdr;

	private int la, in;

	void getNext() throws SAXException {
		in = la;
		try {
			la = rdr.read();
		} catch (IOException e) {
			la = -1;
		}
	}

	public void parse(String uri, ContentHandler handler) throws SAXException {
		StringBuffer elementName = new StringBuffer();
		StringBuffer chars = new StringBuffer();
		try {
			rdr = new BufferedReader(new InputStreamReader(new FileInputStream(
					uri), "UTF-8"));
		} catch (FileNotFoundException e) {
			throw new SAXException("Can't parse document", e);
		} catch (UnsupportedEncodingException e) {
			throw new SAXException("Can't parse document", e);
		}
		getNext();
		if (la < 0) {
			return;
		}
		handler.startDocument();
		State state = State.STATE_INIT;
		State oldState = state;
		while (in >= 0) {
			if (oldState != state) {
				if (chars.length() > 0) {
					int p;
					while ((p = chars.indexOf("&lt;")) >= 0) {
						chars.replace(p, p + 4, "<");
					}
					while ((p = chars.indexOf("&gt;")) >= 0) {
						chars.replace(p, p + 4, ">");
					}
					while ((p = chars.indexOf("&apos;")) >= 0) {
						chars.replace(p, p + 6, "'");
					}
					while ((p = chars.indexOf("&quot;")) >= 0) {
						chars.replace(p, p + 6, "\"");
					}
					while ((p = chars.indexOf("&amp;")) >= 0) {
						chars.replace(p, p + 5, "&");
					}
					char[] c = chars.toString().toCharArray();
					handler.characters(c, 0, c.length);
					chars.setLength(0);
				}
				oldState = state;
			}
			getNext();
			switch (state) {
			case STATE_INIT:
				if (in == '<' && (la == '?' || la == '!')) {
					state = State.STATE_SKIPTO_GT;
				} else if (in == '<' && Character.isLetter((char) la)) {
					state = State.STATE_STARTELEMENT;
					elementName.setLength(0);
				} else if (in == '<' && la == '/') {
					state = State.STATE_ENDELEMENT;
					getNext();
					elementName.setLength(0);
				} else {
					chars.append((char) in);
				}
				break;

			case STATE_SKIPTO_GT:
				if (in == '>') {
					state = State.STATE_INIT;
				}
				break;

			case STATE_STARTELEMENT:
				if (in == '/') {
					handler.startElement(uri, "", elementName.toString(), null);
					handler.endElement(uri, "", elementName.toString());
					state = State.STATE_SKIPTO_GT;
				} else if (in == '>') {
					handler.startElement(uri, "", elementName.toString(), null);
					state = State.STATE_INIT;
				} else if (Character.isLetter((char) in)) {
					elementName.append((char) in);
				} else {
					handler.startElement(uri, "", elementName.toString(), null);
					state = State.STATE_SKIPTO_GT;
				}
				break;

			case STATE_ENDELEMENT:
				if (in == '>') {
					handler.endElement(uri, "", elementName.toString());
					state = State.STATE_INIT;
				} else {
					elementName.append((char) in);
				}
				break;
			}
		}
		handler.endDocument();
	}
}
