(ns ^{:long-doc "TODO"}
  de.uni-koblenz.ist.funtg.funrl.generic
  "Generic relations"
  (:refer-clojure :exclude [==])
  (:use [clojure.core.logic])
  (:require [de.uni-koblenz.ist.funtg.core :as core])
  (:require [de.uni-koblenz.ist.funtg.funql :as funql])
  (:import (de.uni_koblenz.jgralab Graph Vertex Edge AttributedElement)))

(defn qmark-symbol?
  "Returns true, if sym is a symbol with name starting with a question mark."
  [sym]
  (and (symbol? sym)
       (= (first (name sym)) \?)))

(defmacro with-fresh
  "Replace all symbols with a leading question mark with fresh lvars.
  In addition, all occurences of `_' are replaced with fresh lvars, one per
  occurence.  That means, that in `forms' all occurences of ?foo will be
  unified, but all occurences of `_' are not."
  [& forms]
  (let [fs (clojure.walk/postwalk #(if (= '_ %) (gensym "?") %) forms)
        qsyms (vec (distinct (filter qmark-symbol? (flatten fs))))]
    `(fresh ~qsyms
       ~@fs)))

(defn fresh?
  "Returns true, if `x' is fresh.
  `x' must have been `walk'ed before!"
  [x]
  (lvar? x))

(defn ground?
  "Returns true, if `x' is ground.
  `x' must have been `walk'ed before!"
  [x]
  (not (lvar? x)))

