/*
 * This code was generated automatically.
 * Do NOT edit this file, changes will be lost.
 * Instead, change and commit the underlying schema.
 */

package de.uni_koblenz.ist.funtg.xmltg;

import de.uni_koblenz.jgralab.impl.db.GraphDatabase;
import de.uni_koblenz.jgralab.impl.db.GraphDatabaseException;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.GraphIOException;
import de.uni_koblenz.jgralab.ProgressFunction;

import de.uni_koblenz.jgralab.schema.impl.SchemaImpl;

import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.VertexClass;

import de.uni_koblenz.ist.funtg.xmltg.XMLSchemaFactory;

import java.lang.ref.WeakReference;

/**
 * The schema XMLSchema is implemented following the singleton pattern.
 * To get the instance, use the static method <code>instance()</code>.
 */
public class XMLSchema extends SchemaImpl {
	public final GraphClass gc_XMLGraph;
	public final VertexClass vc_Node;
	public final VertexClass vc_Attribute;
	public final VertexClass vc_Text;
	public final VertexClass vc_Element;
	public final VertexClass vc_RootElement;
	public final EdgeClass ec_HasAttribute;
	public final EdgeClass ec_References;
	public final EdgeClass ec_HasContent;
	public final EdgeClass ec_HasChild;
	public final EdgeClass ec_HasText;

	/**
	 * the weak reference to the singleton instance
	 */
	static WeakReference<XMLSchema> theInstance = new WeakReference<XMLSchema>(null);
	
	/**
	 * @return the singleton instance of XMLSchema
	 */
	public static XMLSchema instance() {
		XMLSchema s = theInstance.get();
		if (s != null) {
			return s;
		}
		synchronized (XMLSchema.class) {
			s = theInstance.get();
			if (s != null) {
				return s;
			}
			s = new XMLSchema();
			theInstance = new WeakReference<XMLSchema>(s);
		}
		return s;
	}
	
	/**
	 * Creates a XMLSchema and builds its schema classes.
	 * This constructor is private. Use the <code>instance()</code> method
	 * to acess the schema.
	 */
	private XMLSchema() {
		super("XMLSchema", "de.uni_koblenz.ist.funtg.xmltg");

		{
			GraphClass gc = gc_XMLGraph = createGraphClass("XMLGraph");
			gc.setAbstract(false);
			@SuppressWarnings("unused")
			VertexClass vc_Vertex = getDefaultVertexClass();

			{
				VertexClass vc = vc_Node = gc.createVertexClass("Node");
				vc.setAbstract(true);
			}

			{
				VertexClass vc = vc_Attribute = gc.createVertexClass("Attribute");
				vc.setAbstract(false);
				vc.addAttribute(createAttribute("name", getDomain("String"), getAttributedElementClass("Attribute"), null));
				vc.addAttribute(createAttribute("value", getDomain("String"), getAttributedElementClass("Attribute"), null));
			}

			{
				VertexClass vc = vc_Text = gc.createVertexClass("Text");
				vc.setAbstract(false);
				vc.addSuperClass(vc_Node);
				vc.addAttribute(createAttribute("content", getDomain("String"), getAttributedElementClass("Text"), null));
			}

			{
				VertexClass vc = vc_Element = gc.createVertexClass("Element");
				vc.setAbstract(false);
				vc.addSuperClass(vc_Node);
				vc.addAttribute(createAttribute("name", getDomain("String"), getAttributedElementClass("Element"), null));
			}

			{
				VertexClass vc = vc_RootElement = gc.createVertexClass("RootElement");
				vc.setAbstract(false);
				vc.addSuperClass(vc_Element);
			}

			{
				EdgeClass ec = ec_HasAttribute = gc.createEdgeClass("HasAttribute",
					vc_Element, 1, 1, "element", de.uni_koblenz.jgralab.schema.AggregationKind.NONE,
					vc_Attribute, 0, 2147483647, "attributes", de.uni_koblenz.jgralab.schema.AggregationKind.COMPOSITE);
				ec.setAbstract(false);
			}

			{
				EdgeClass ec = ec_References = gc.createEdgeClass("References",
					vc_Attribute, 0, 1, "referent", de.uni_koblenz.jgralab.schema.AggregationKind.NONE,
					vc_Element, 0, 2147483647, "refs", de.uni_koblenz.jgralab.schema.AggregationKind.NONE);
				ec.setAbstract(false);
			}

			{
				EdgeClass ec = ec_HasContent = gc.createEdgeClass("HasContent",
					vc_Element, 0, 1, "parent", de.uni_koblenz.jgralab.schema.AggregationKind.NONE,
					vc_Node, 0, 2147483647, "contents", de.uni_koblenz.jgralab.schema.AggregationKind.COMPOSITE);
				ec.setAbstract(true);
			}

			{
				EdgeClass ec = ec_HasChild = gc.createEdgeClass("HasChild",
					vc_Element, 0, 1, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE,
					vc_Element, 0, 2147483647, "children", de.uni_koblenz.jgralab.schema.AggregationKind.COMPOSITE);
				ec.setAbstract(false);
				ec.addSuperClass(ec_HasContent);
			}

			{
				EdgeClass ec = ec_HasText = gc.createEdgeClass("HasText",
					vc_Element, 0, 1, "", de.uni_koblenz.jgralab.schema.AggregationKind.NONE,
					vc_Text, 0, 2147483647, "texts", de.uni_koblenz.jgralab.schema.AggregationKind.COMPOSITE);
				ec.setAbstract(false);
				ec.addSuperClass(ec_HasContent);
			}
		}

		graphFactory = new XMLSchemaFactory();

	}

	/**
	 * Creates a new XMLGraph graph with initial vertex and edge counts <code>vMax</code>, <code>eMax</code>.
	 *
	 * @param vMax initial vertex count
	 * @param eMax initial edge count
	*/
	public XMLGraph createXMLGraph(int vMax, int eMax) {
		return (XMLGraph) graphFactory.createGraph(XMLGraph.class, null, vMax, eMax);
	}
	
	/**
	 * Creates a new XMLGraph graph with the ID <code>id</code> initial vertex and edge counts <code>vMax</code>, <code>eMax</code>.
	 *
	 * @param id the id name of the new graph
	 * @param vMax initial vertex count
	 * @param eMax initial edge count
	 */
	public XMLGraph createXMLGraph(String id, int vMax, int eMax) {
		return (XMLGraph) graphFactory.createGraph(XMLGraph.class, id, vMax, eMax);
	}
	
	/**
	 * Creates a new XMLGraph graph.
	*/
	public XMLGraph createXMLGraph() {
		return (XMLGraph) graphFactory.createGraph(XMLGraph.class, null);
	}
	
	/**
	 * Creates a new XMLGraph graph with the ID <code>id</code>.
	 *
	 * @param id the id name of the new graph
	 */
	public XMLGraph createXMLGraph(String id) {
		return (XMLGraph) graphFactory.createGraph(XMLGraph.class, id);
	}
	
	/**
	 * Creates a new XMLGraph graph in a database with given <code>id</code>.
	 *
	 * @param id Identifier of new graph
	 * @param graphDatabase Database which should contain graph
	 */
	public XMLGraph createXMLGraphWithDatabaseSupport(String id, GraphDatabase graphDatabase) throws GraphDatabaseException{
		throw new UnsupportedOperationException("No database support compiled.");
	}
	/**
	 * Creates a new XMLGraph graph in a database with given <code>id</code>.
	 *
	 * @param id Identifier of new graph
	 * @param vMax Maximum initial count of vertices that can be held in graph.
	 * @param eMax Maximum initial count of edges that can be held in graph.
	 * @param graphDatabase Database which should contain graph
	 */
	public XMLGraph createXMLGraphWithDatabaseSupport(String id, int vMax, int eMax, GraphDatabase graphDatabase) throws GraphDatabaseException{
		throw new UnsupportedOperationException("No database support compiled.");
	}
	/**
	 * Creates a new XMLGraph graph with transaction support with initial vertex and edge counts <code>vMax</code>, <code>eMax</code>.
	 *
	 * @param vMax initial vertex count
	 * @param eMax initial edge count
	*/
	public XMLGraph createXMLGraphWithTransactionSupport(int vMax, int eMax) {
		throw new UnsupportedOperationException("No Transaction support compiled.");
	}
	
	/**
	 * Creates a new XMLGraph graph with transaction support with the ID <code>id</code> initial vertex and edge counts <code>vMax</code>, <code>eMax</code>.
	 *
	 * @param id the id name of the new graph
	 * @param vMax initial vertex count
	 * @param eMax initial edge count
	 */
	public XMLGraph createXMLGraphWithTransactionSupport(String id, int vMax, int eMax) {
		throw new UnsupportedOperationException("No Transaction support compiled.");
	}
	
	/**
	 * Creates a new XMLGraph graph.
	*/
	public XMLGraph createXMLGraphWithTransactionSupport() {
		throw new UnsupportedOperationException("No Transaction support compiled.");
	}
	
	/**
	 * Creates a new XMLGraph graph with the ID <code>id</code>.
	 *
	 * @param id the id name of the new graph
	 */
	public XMLGraph createXMLGraphWithTransactionSupport(String id) {
		throw new UnsupportedOperationException("No Transaction support compiled.");
	}
	
	/**
	 * Loads a XMLGraph graph from the file <code>filename</code>.
	 *
	 * @param filename the name of the file
	 * @return the loaded XMLGraph
	 * @throws GraphIOException if the graph cannot be loaded
	 */
	public XMLGraph loadXMLGraph(String filename) throws GraphIOException {
		return loadXMLGraph(filename, null);
	}
	
	/**
	 * Loads a XMLGraph graph from the file <code>filename</code>.
	 *
	 * @param filename the name of the file
	 * @param pf a progress function to monitor graph loading
	 * @return the loaded XMLGraph
	 * @throws GraphIOException if the graph cannot be loaded
	 */
	public XMLGraph loadXMLGraph(String filename, ProgressFunction pf) throws GraphIOException {
		Graph graph = GraphIO.loadGraphFromFileWithStandardSupport(filename, this, pf);
	if (!(graph instanceof XMLGraph)) {
		throw new GraphIOException("Graph in file '" + filename + "' is not an instance of GraphClass XMLGraph");
	}	return (XMLGraph) graph;

	}
	
	/**
	 * Loads a XMLGraph graph with transaction support from the file <code>filename</code>.
	 *
	 * @param filename the name of the file
	 * @return the loaded XMLGraph
	 * @throws GraphIOException if the graph cannot be loaded
	 */
	public XMLGraph loadXMLGraphWithTransactionSupport(String filename) throws GraphIOException {
		throw new UnsupportedOperationException("No Transaction support compiled.");
	}
	
	/**
	 * Loads a XMLGraph graph with transaction support from the file <code>filename</code>.
	 *
	 * @param filename the name of the file
	 * @param pf a progress function to monitor graph loading
	 * @return the loaded XMLGraph
	 * @throws GraphIOException if the graph cannot be loaded
	 */
	public XMLGraph loadXMLGraphWithTransactionSupport(String filename, ProgressFunction pf) throws GraphIOException {
		throw new UnsupportedOperationException("No Transaction support compiled.");
	}
	
	@Override
	public boolean equals(Object o) {
		return super.equals(o);
	}
	
	@Override
	public int hashCode() {
		return super.hashCode();
	}
}
