(ns sock.server
  (:require
   [clojure.core.async :as async :refer [<! >! put! close! chan dropping-buffer go-loop]]
   [clojure.edn :as edn]
   [org.httpkit.server :refer :all]))


(defn ws-handler [connection-chan & {:keys [in-gen out-gen log-gen]
                   :or {in-gen  #(chan (dropping-buffer 1024))
                        out-gen #(chan (dropping-buffer 1024))
                        log-gen #(chan (dropping-buffer 1024))}}]
  (fn [request]
    (let [in (in-gen)
          out (out-gen)
          log (log-gen)]
      (with-channel request channel
        (when (websocket? channel)
          (put! log {:event :open
                     :request request})
          (on-close channel (fn [status]
                              (put! log {:event :close
                                         :origin :remote
                                         :status status})
                              (close! in)
                              (close! out)
                              (close! log)))
          (on-receive channel (fn [data]
                                (put! in (edn/read-string data))))
          (go-loop []
            (let [data (<! out)]
              (if data
                (do (send! channel (pr-str data))
                    (recur))
                (do (put! log {:event :close
                               :origin :local})
                    (close channel)))))
          (put! connection-chan {:in in
                                 :out out
                                 :log log}))))))
