;; gorilla-repl.fileformat = 1

;; **
;;; # Utility
;;; 
;;; Uitility segments like progress-bars or sliders.
;; **

;; @@
(ns marmoset.util
  (:require [marmoset.core :as m]
            [clojure.core.async :as a]
            [gorilla-renderable.core :as r]))
;; @@
;; =>
;;; {"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"}
;; <=

;; @@
(m/defsegment segment-progress
  {:preamble ["marmoset/react.js"]
   :externs ["marmoset/react.js"]}
  (ns foo
    [:require marmoset.client
     [cljs.core.async :refer [<!]]
     [om.core :as om :include-macros true]
     [om.dom :as dom :include-macros true]]
    [:require-macros
     [cljs.core.async.macros :refer [go]]])
  
  (enable-console-print!)
  
  (def v (atom (:value marmoset.client/env)))
  
  (go (loop []
        (when-let [m (<! (:in marmoset.client/chan))]
          (reset! v m)
          (recur))))
  
  (defn progress-widget [data owner]
    (reify
      om/IRender
      (render [this]
              (dom/progress
                (clj->js {:value data
                          :max (:max marmoset.client/env)
                          :style {:width "100%"}})))))
  
  (defn main []
    (marmoset.client/autoheight!)
    (om/root progress-widget
             v
             {:target (.item (.getElementsByTagName js/document "body") 0)}))
  
  (set! (.-onload js/window) main))
;; @@
;; =>
;;; {"type":"html","content":"<span class='clj-var'>#&#x27;marmoset.util/segment-progress</span>","value":"#'marmoset.util/segment-progress"}
;; <=

;; @@
(defrecord ProgressView [id value max]
  r/Renderable
  (render [self]
          (let [env  {:value value
                      :max max}
                html (segment-progress id env)]
            {:type :html
             :value (pr-str self)
             :content html})))

(defn progress-view [value max]
  (let [id (java.util.UUID/randomUUID)]
    (if (instance? clojure.lang.IRef value)
      (let [ch (a/chan)]
        (m/register-chan! id ch)
        (let [c (a/chan)
              m (a/mult c)]
          (add-watch value :progress (fn [k r o n] (a/put! c n)))
          (a/go-loop []
                   (when-some [o (:out (a/<! ch))]
                              (a/put! o @value)
                              (a/tap m o)
                              (recur))))
        (->ProgressView id @value max))
      (->ProgressView id value max))))
;; @@
;; =>
;;; {"type":"html","content":"<span class='clj-var'>#&#x27;marmoset.util/progress-view</span>","value":"#'marmoset.util/progress-view"}
;; <=
