;; gorilla-repl.fileformat = 1

;; **
;;; # Marmoset.
;;; 
;;; Below is a simple example on how to use buildin marmoset segments as well as how to define new ones.
;;; 
;;; ##values and updates
;;; 
;;; Gorilla repl is a great tool for visualising data and interactively developing code,
;;; and a lot of its strength comes from its value based rendering model.
;;; 
;;; But for the moment the visualisations it generates are rather static and lack interactivity.
;;; Marmoset tries to improve on this by providing a way to easily create visualisations based on clojurescript.
;;; 
;;; Also sometimes interacting with the rendered data alone is not enough and one wants to monitor things in realtime, or control things by other means than evaluating code.
;;; 
;;; Therefore there are two options of communicating values between gorilla and marmoset:
;;; 
;;; 1. The preferred way to pass data to a segment is as a value which will get compiled into the rendering code and will be available even in an exported notebook. Note that it can therefore only contain data that is serializable as EDN.
;;; 
;;; 2. The less preferred but sometimes unavoidable way is via a websocket connection which will allow for live updates but which will cease to function once the journal is exported.
;;; 
;;; 
;; **

;; @@
(ns marmoset.notebook)
;; @@
;; =>
;;; {"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"}
;; <=

;; **
;;; You'll find some usefull utility segments like progress-bars or sliders in the `marmoset.util` namespace.
;; **

;; @@

  (require '[marmoset.util :as mu])
;; @@
;; =>
;;; {"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"}
;; <=

;; **
;;; Progess bars 
;; **

;; @@
(mu/progress-view 43 78)
;; @@
;; =>
;;; {"type":"html","value":"#marmoset.util.ProgressView{:id #uuid \"497166ea-78c4-4fb9-8cd4-79b48982d14a\", :value 43, :max 78}","content":"<iframe frameborder=\"0\" hspace=\"0\" id=\"497166ea-78c4-4fb9-8cd4-79b48982d14a\" marginheight=\"0\" marginwidth=\"0\" scrolling=\"no\" seamless=\"seamless\" srcdoc=\"&lt;html&gt;&lt;head&gt;&lt;script type=&quot;text/javascript&quot;&gt;var marmoset_payload = &quot;{:id #uuid \\&quot;497166ea-78c4-4fb9-8cd4-79b48982d14a\\&quot;, :env {:value 43, :max 78}}&quot;;\n&lt;/script&gt;&lt;script type=&quot;text/javascript&quot;&gt;/**\n * React v0.9.0\n */\n!function(e){if(&quot;object&quot;==typeof exports)module.exports=e();else if(&quot;function&quot;==typeof define&amp;&amp;define.amd)define(e);else{var f;&quot;undefined&quot;!=typeof window?f=window:&quot;undefined&quot;!=typeof global?f=global:&quot;undefined&quot;!=typeof self&amp;&amp;(f=self),f.React=e()}}(function(){var define,module,exports;return (function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require==&quot;function&quot;&amp;&amp;require;if(!u&amp;&amp;a)return a(o,!0);if(i)return i(o,!0);throw new Error(&quot;Cannot find module &apos;&quot;+o+&quot;&apos;&quot;)}var f=n[o]={exports:{}};t[o][0].call(f.exports,function(e){var n=t[o][1][e];return s(n?n:e)},f,f.exports,e,t,n,r)}return n[o].exports}var i=typeof require==&quot;function&quot;&amp;&amp;require;for(var o=0;o&lt;r.length;o++)s(r[o]);return s})({1:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule AutoFocusMixin\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar AutoFocusMixin = {\n  componentDidMount: function() {\n    if (this.props.autoFocus) {\n      this.getDOMNode().focus();\n    }\n  }\n};\n\nmodule.exports = AutoFocusMixin;\n\n},{}],2:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule CSSProperty\n */\n\n&quot;use strict&quot;;\n\n/**\n * CSS properties which accept numbers but are not in units of &quot;px&quot;.\n */\nvar isUnitlessNumber = {\n  columnCount: true,\n  fillOpacity: true,\n  flex: true,\n  flexGrow: true,\n  flexShrink: true,\n  fontWeight: true,\n  lineClamp: true,\n  lineHeight: true,\n  opacity: true,\n  order: true,\n  orphans: true,\n  widows: true,\n  zIndex: true,\n  zoom: true\n};\n\n/**\n * @param {string} prefix vendor-specific prefix, eg: Webkit\n * @param {string} key style name, eg: transitionDuration\n * @return {string} style name prefixed with `prefix`, properly camelCased, eg:\n * WebkitTransitionDuration\n */\nfunction prefixKey(prefix, key) {\n  return prefix + key.charAt(0).toUpperCase() + key.substring(1);\n}\n\n/**\n * Support style names that may come passed in prefixed by adding permutations\n * of vendor prefixes.\n */\nvar prefixes = [&apos;Webkit&apos;, &apos;ms&apos;, &apos;Moz&apos;, &apos;O&apos;];\n\n// Using Object.keys here, or else the vanilla for-in loop makes IE8 go into an\n// infinite loop, because it iterates over the newly added props too.\nObject.keys(isUnitlessNumber).forEach(function(prop) {\n  prefixes.forEach(function(prefix) {\n    isUnitlessNumber[prefixKey(prefix, prop)] = isUnitlessNumber[prop];\n  });\n});\n\n/**\n * Most style properties can be unset by doing .style[prop] = &apos;&apos; but IE8\n * doesn&apos;t like doing that with shorthand properties so for the properties that\n * IE8 breaks on, which are listed here, we instead unset each of the\n * individual properties. See http://bugs.jquery.com/ticket/12385.\n * The 4-value &apos;clock&apos; properties like margin, padding, border-width seem to\n * behave without any problems. Curiously, list-style works too without any\n * special prodding.\n */\nvar shorthandPropertyExpansions = {\n  background: {\n    backgroundImage: true,\n    backgroundPosition: true,\n    backgroundRepeat: true,\n    backgroundColor: true\n  },\n  border: {\n    borderWidth: true,\n    borderStyle: true,\n    borderColor: true\n  },\n  borderBottom: {\n    borderBottomWidth: true,\n    borderBottomStyle: true,\n    borderBottomColor: true\n  },\n  borderLeft: {\n    borderLeftWidth: true,\n    borderLeftStyle: true,\n    borderLeftColor: true\n  },\n  borderRight: {\n    borderRightWidth: true,\n    borderRightStyle: true,\n    borderRightColor: true\n  },\n  borderTop: {\n    borderTopWidth: true,\n    borderTopStyle: true,\n    borderTopColor: true\n  },\n  font: {\n    fontStyle: true,\n    fontVariant: true,\n    fontWeight: true,\n    fontSize: true,\n    lineHeight: true,\n    fontFamily: true\n  }\n};\n\nvar CSSProperty = {\n  isUnitlessNumber: isUnitlessNumber,\n  shorthandPropertyExpansions: shorthandPropertyExpansions\n};\n\nmodule.exports = CSSProperty;\n\n},{}],3:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule CSSPropertyOperations\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar CSSProperty = require(&quot;./CSSProperty&quot;);\n\nvar dangerousStyleValue = require(&quot;./dangerousStyleValue&quot;);\nvar escapeTextForBrowser = require(&quot;./escapeTextForBrowser&quot;);\nvar hyphenate = require(&quot;./hyphenate&quot;);\nvar memoizeStringOnly = require(&quot;./memoizeStringOnly&quot;);\n\nvar processStyleName = memoizeStringOnly(function(styleName) {\n  return escapeTextForBrowser(hyphenate(styleName));\n});\n\n/**\n * Operations for dealing with CSS properties.\n */\nvar CSSPropertyOperations = {\n\n  /**\n   * Serializes a mapping of style properties for use as inline styles:\n   *\n   *   &gt; createMarkupForStyles({width: &apos;200px&apos;, height: 0})\n   *   &quot;width:200px;height:0;&quot;\n   *\n   * Undefined values are ignored so that declarative programming is easier.\n   *\n   * @param {object} styles\n   * @return {?string}\n   */\n  createMarkupForStyles: function(styles) {\n    var serialized = &apos;&apos;;\n    for (var styleName in styles) {\n      if (!styles.hasOwnProperty(styleName)) {\n        continue;\n      }\n      var styleValue = styles[styleName];\n      if (styleValue != null) {\n        serialized += processStyleName(styleName) + &apos;:&apos;;\n        serialized += dangerousStyleValue(styleName, styleValue) + &apos;;&apos;;\n      }\n    }\n    return serialized || null;\n  },\n\n  /**\n   * Sets the value for multiple styles on a node.  If a value is specified as\n   * &apos;&apos; (empty string), the corresponding style property will be unset.\n   *\n   * @param {DOMElement} node\n   * @param {object} styles\n   */\n  setValueForStyles: function(node, styles) {\n    var style = node.style;\n    for (var styleName in styles) {\n      if (!styles.hasOwnProperty(styleName)) {\n        continue;\n      }\n      var styleValue = dangerousStyleValue(styleName, styles[styleName]);\n      if (styleValue) {\n        style[styleName] = styleValue;\n      } else {\n        var expansion = CSSProperty.shorthandPropertyExpansions[styleName];\n        if (expansion) {\n          // Shorthand property that IE8 won&apos;t like unsetting, so unset each\n          // component to placate it\n          for (var individualStyleName in expansion) {\n            style[individualStyleName] = &apos;&apos;;\n          }\n        } else {\n          style[styleName] = &apos;&apos;;\n        }\n      }\n    }\n  }\n\n};\n\nmodule.exports = CSSPropertyOperations;\n\n},{&quot;./CSSProperty&quot;:2,&quot;./dangerousStyleValue&quot;:94,&quot;./escapeTextForBrowser&quot;:96,&quot;./hyphenate&quot;:107,&quot;./memoizeStringOnly&quot;:116}],4:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ChangeEventPlugin\n */\n\n&quot;use strict&quot;;\n\nvar EventConstants = require(&quot;./EventConstants&quot;);\nvar EventPluginHub = require(&quot;./EventPluginHub&quot;);\nvar EventPropagators = require(&quot;./EventPropagators&quot;);\nvar ExecutionEnvironment = require(&quot;./ExecutionEnvironment&quot;);\nvar ReactUpdates = require(&quot;./ReactUpdates&quot;);\nvar SyntheticEvent = require(&quot;./SyntheticEvent&quot;);\n\nvar isEventSupported = require(&quot;./isEventSupported&quot;);\nvar isTextInputElement = require(&quot;./isTextInputElement&quot;);\nvar keyOf = require(&quot;./keyOf&quot;);\n\nvar topLevelTypes = EventConstants.topLevelTypes;\n\nvar eventTypes = {\n  change: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onChange: null}),\n      captured: keyOf({onChangeCapture: null})\n    },\n    dependencies: [\n      topLevelTypes.topBlur,\n      topLevelTypes.topChange,\n      topLevelTypes.topClick,\n      topLevelTypes.topFocus,\n      topLevelTypes.topInput,\n      topLevelTypes.topKeyDown,\n      topLevelTypes.topKeyUp,\n      topLevelTypes.topSelectionChange\n    ]\n  }\n};\n\n/**\n * For IE shims\n */\nvar activeElement = null;\nvar activeElementID = null;\nvar activeElementValue = null;\nvar activeElementValueProp = null;\n\n/**\n * SECTION: handle `change` event\n */\nfunction shouldUseChangeEvent(elem) {\n  return (\n    elem.nodeName === &apos;SELECT&apos; ||\n    (elem.nodeName === &apos;INPUT&apos; &amp;&amp; elem.type === &apos;file&apos;)\n  );\n}\n\nvar doesChangeEventBubble = false;\nif (ExecutionEnvironment.canUseDOM) {\n  // See `handleChange` comment below\n  doesChangeEventBubble = isEventSupported(&apos;change&apos;) &amp;&amp; (\n    !(&apos;documentMode&apos; in document) || document.documentMode &gt; 8\n  );\n}\n\nfunction manualDispatchChangeEvent(nativeEvent) {\n  var event = SyntheticEvent.getPooled(\n    eventTypes.change,\n    activeElementID,\n    nativeEvent\n  );\n  EventPropagators.accumulateTwoPhaseDispatches(event);\n\n  // If change and propertychange bubbled, we&apos;d just bind to it like all the\n  // other events and have it go through ReactEventTopLevelCallback. Since it\n  // doesn&apos;t, we manually listen for the events and so we have to enqueue and\n  // process the abstract event manually.\n  //\n  // Batching is necessary here in order to ensure that all event handlers run\n  // before the next rerender (including event handlers attached to ancestor\n  // elements instead of directly on the input). Without this, controlled\n  // components don&apos;t work properly in conjunction with event bubbling because\n  // the component is rerendered and the value reverted before all the event\n  // handlers can run. See https://github.com/facebook/react/issues/708.\n  ReactUpdates.batchedUpdates(runEventInBatch, event);\n}\n\nfunction runEventInBatch(event) {\n  EventPluginHub.enqueueEvents(event);\n  EventPluginHub.processEventQueue();\n}\n\nfunction startWatchingForChangeEventIE8(target, targetID) {\n  activeElement = target;\n  activeElementID = targetID;\n  activeElement.attachEvent(&apos;onchange&apos;, manualDispatchChangeEvent);\n}\n\nfunction stopWatchingForChangeEventIE8() {\n  if (!activeElement) {\n    return;\n  }\n  activeElement.detachEvent(&apos;onchange&apos;, manualDispatchChangeEvent);\n  activeElement = null;\n  activeElementID = null;\n}\n\nfunction getTargetIDForChangeEvent(\n    topLevelType,\n    topLevelTarget,\n    topLevelTargetID) {\n  if (topLevelType === topLevelTypes.topChange) {\n    return topLevelTargetID;\n  }\n}\nfunction handleEventsForChangeEventIE8(\n    topLevelType,\n    topLevelTarget,\n    topLevelTargetID) {\n  if (topLevelType === topLevelTypes.topFocus) {\n    // stopWatching() should be a noop here but we call it just in case we\n    // missed a blur event somehow.\n    stopWatchingForChangeEventIE8();\n    startWatchingForChangeEventIE8(topLevelTarget, topLevelTargetID);\n  } else if (topLevelType === topLevelTypes.topBlur) {\n    stopWatchingForChangeEventIE8();\n  }\n}\n\n\n/**\n * SECTION: handle `input` event\n */\nvar isInputEventSupported = false;\nif (ExecutionEnvironment.canUseDOM) {\n  // IE9 claims to support the input event but fails to trigger it when\n  // deleting text, so we ignore its input events\n  isInputEventSupported = isEventSupported(&apos;input&apos;) &amp;&amp; (\n    !(&apos;documentMode&apos; in document) || document.documentMode &gt; 9\n  );\n}\n\n/**\n * (For old IE.) Replacement getter/setter for the `value` property that gets\n * set on the active element.\n */\nvar newValueProp =  {\n  get: function() {\n    return activeElementValueProp.get.call(this);\n  },\n  set: function(val) {\n    // Cast to a string so we can do equality checks.\n    activeElementValue = &apos;&apos; + val;\n    activeElementValueProp.set.call(this, val);\n  }\n};\n\n/**\n * (For old IE.) Starts tracking propertychange events on the passed-in element\n * and override the value property so that we can distinguish user events from\n * value changes in JS.\n */\nfunction startWatchingForValueChange(target, targetID) {\n  activeElement = target;\n  activeElementID = targetID;\n  activeElementValue = target.value;\n  activeElementValueProp = Object.getOwnPropertyDescriptor(\n    target.constructor.prototype,\n    &apos;value&apos;\n  );\n\n  Object.defineProperty(activeElement, &apos;value&apos;, newValueProp);\n  activeElement.attachEvent(&apos;onpropertychange&apos;, handlePropertyChange);\n}\n\n/**\n * (For old IE.) Removes the event listeners from the currently-tracked element,\n * if any exists.\n */\nfunction stopWatchingForValueChange() {\n  if (!activeElement) {\n    return;\n  }\n\n  // delete restores the original property definition\n  delete activeElement.value;\n  activeElement.detachEvent(&apos;onpropertychange&apos;, handlePropertyChange);\n\n  activeElement = null;\n  activeElementID = null;\n  activeElementValue = null;\n  activeElementValueProp = null;\n}\n\n/**\n * (For old IE.) Handles a propertychange event, sending a `change` event if\n * the value of the active element has changed.\n */\nfunction handlePropertyChange(nativeEvent) {\n  if (nativeEvent.propertyName !== &apos;value&apos;) {\n    return;\n  }\n  var value = nativeEvent.srcElement.value;\n  if (value === activeElementValue) {\n    return;\n  }\n  activeElementValue = value;\n\n  manualDispatchChangeEvent(nativeEvent);\n}\n\n/**\n * If a `change` event should be fired, returns the target&apos;s ID.\n */\nfunction getTargetIDForInputEvent(\n    topLevelType,\n    topLevelTarget,\n    topLevelTargetID) {\n  if (topLevelType === topLevelTypes.topInput) {\n    // In modern browsers (i.e., not IE8 or IE9), the input event is exactly\n    // what we want so fall through here and trigger an abstract event\n    return topLevelTargetID;\n  }\n}\n\n// For IE8 and IE9.\nfunction handleEventsForInputEventIE(\n    topLevelType,\n    topLevelTarget,\n    topLevelTargetID) {\n  if (topLevelType === topLevelTypes.topFocus) {\n    // In IE8, we can capture almost all .value changes by adding a\n    // propertychange handler and looking for events with propertyName\n    // equal to &apos;value&apos;\n    // In IE9, propertychange fires for most input events but is buggy and\n    // doesn&apos;t fire when text is deleted, but conveniently, selectionchange\n    // appears to fire in all of the remaining cases so we catch those and\n    // forward the event if the value has changed\n    // In either case, we don&apos;t want to call the event handler if the value\n    // is changed from JS so we redefine a setter for `.value` that updates\n    // our activeElementValue variable, allowing us to ignore those changes\n    //\n    // stopWatching() should be a noop here but we call it just in case we\n    // missed a blur event somehow.\n    stopWatchingForValueChange();\n    startWatchingForValueChange(topLevelTarget, topLevelTargetID);\n  } else if (topLevelType === topLevelTypes.topBlur) {\n    stopWatchingForValueChange();\n  }\n}\n\n// For IE8 and IE9.\nfunction getTargetIDForInputEventIE(\n    topLevelType,\n    topLevelTarget,\n    topLevelTargetID) {\n  if (topLevelType === topLevelTypes.topSelectionChange ||\n      topLevelType === topLevelTypes.topKeyUp ||\n      topLevelType === topLevelTypes.topKeyDown) {\n    // On the selectionchange event, the target is just document which isn&apos;t\n    // helpful for us so just check activeElement instead.\n    //\n    // 99% of the time, keydown and keyup aren&apos;t necessary. IE8 fails to fire\n    // propertychange on the first input event after setting `value` from a\n    // script and fires only keydown, keypress, keyup. Catching keyup usually\n    // gets it and catching keydown lets us fire an event for the first\n    // keystroke if user does a key repeat (it&apos;ll be a little delayed: right\n    // before the second keystroke). Other input methods (e.g., paste) seem to\n    // fire selectionchange normally.\n    if (activeElement &amp;&amp; activeElement.value !== activeElementValue) {\n      activeElementValue = activeElement.value;\n      return activeElementID;\n    }\n  }\n}\n\n\n/**\n * SECTION: handle `click` event\n */\nfunction shouldUseClickEvent(elem) {\n  // Use the `click` event to detect changes to checkbox and radio inputs.\n  // This approach works across all browsers, whereas `change` does not fire\n  // until `blur` in IE8.\n  return (\n    elem.nodeName === &apos;INPUT&apos; &amp;&amp;\n    (elem.type === &apos;checkbox&apos; || elem.type === &apos;radio&apos;)\n  );\n}\n\nfunction getTargetIDForClickEvent(\n    topLevelType,\n    topLevelTarget,\n    topLevelTargetID) {\n  if (topLevelType === topLevelTypes.topClick) {\n    return topLevelTargetID;\n  }\n}\n\n/**\n * This plugin creates an `onChange` event that normalizes change events\n * across form elements. This event fires at a time when it&apos;s possible to\n * change the element&apos;s value without seeing a flicker.\n *\n * Supported elements are:\n * - input (see `isTextInputElement`)\n * - textarea\n * - select\n */\nvar ChangeEventPlugin = {\n\n  eventTypes: eventTypes,\n\n  /**\n   * @param {string} topLevelType Record from `EventConstants`.\n   * @param {DOMEventTarget} topLevelTarget The listening component root node.\n   * @param {string} topLevelTargetID ID of `topLevelTarget`.\n   * @param {object} nativeEvent Native browser event.\n   * @return {*} An accumulation of synthetic events.\n   * @see {EventPluginHub.extractEvents}\n   */\n  extractEvents: function(\n      topLevelType,\n      topLevelTarget,\n      topLevelTargetID,\n      nativeEvent) {\n\n    var getTargetIDFunc, handleEventFunc;\n    if (shouldUseChangeEvent(topLevelTarget)) {\n      if (doesChangeEventBubble) {\n        getTargetIDFunc = getTargetIDForChangeEvent;\n      } else {\n        handleEventFunc = handleEventsForChangeEventIE8;\n      }\n    } else if (isTextInputElement(topLevelTarget)) {\n      if (isInputEventSupported) {\n        getTargetIDFunc = getTargetIDForInputEvent;\n      } else {\n        getTargetIDFunc = getTargetIDForInputEventIE;\n        handleEventFunc = handleEventsForInputEventIE;\n      }\n    } else if (shouldUseClickEvent(topLevelTarget)) {\n      getTargetIDFunc = getTargetIDForClickEvent;\n    }\n\n    if (getTargetIDFunc) {\n      var targetID = getTargetIDFunc(\n        topLevelType,\n        topLevelTarget,\n        topLevelTargetID\n      );\n      if (targetID) {\n        var event = SyntheticEvent.getPooled(\n          eventTypes.change,\n          targetID,\n          nativeEvent\n        );\n        EventPropagators.accumulateTwoPhaseDispatches(event);\n        return event;\n      }\n    }\n\n    if (handleEventFunc) {\n      handleEventFunc(\n        topLevelType,\n        topLevelTarget,\n        topLevelTargetID\n      );\n    }\n  }\n\n};\n\nmodule.exports = ChangeEventPlugin;\n\n},{&quot;./EventConstants&quot;:14,&quot;./EventPluginHub&quot;:16,&quot;./EventPropagators&quot;:19,&quot;./ExecutionEnvironment&quot;:20,&quot;./ReactUpdates&quot;:70,&quot;./SyntheticEvent&quot;:77,&quot;./isEventSupported&quot;:109,&quot;./isTextInputElement&quot;:111,&quot;./keyOf&quot;:115}],5:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ClientReactRootIndex\n * @typechecks\n */\n\n&quot;use strict&quot;;\n\nvar nextReactRootIndex = 0;\n\nvar ClientReactRootIndex = {\n  createReactRootIndex: function() {\n    return nextReactRootIndex++;\n  }\n};\n\nmodule.exports = ClientReactRootIndex;\n\n},{}],6:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule CompositionEventPlugin\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar EventConstants = require(&quot;./EventConstants&quot;);\nvar EventPropagators = require(&quot;./EventPropagators&quot;);\nvar ExecutionEnvironment = require(&quot;./ExecutionEnvironment&quot;);\nvar ReactInputSelection = require(&quot;./ReactInputSelection&quot;);\nvar SyntheticCompositionEvent = require(&quot;./SyntheticCompositionEvent&quot;);\n\nvar getTextContentAccessor = require(&quot;./getTextContentAccessor&quot;);\nvar keyOf = require(&quot;./keyOf&quot;);\n\nvar END_KEYCODES = [9, 13, 27, 32]; // Tab, Return, Esc, Space\nvar START_KEYCODE = 229;\n\nvar useCompositionEvent = (\n  ExecutionEnvironment.canUseDOM &amp;&amp;\n  &apos;CompositionEvent&apos; in window\n);\n\n// In IE9+, we have access to composition events, but the data supplied\n// by the native compositionend event may be incorrect. In Korean, for example,\n// the compositionend event contains only one character regardless of\n// how many characters have been composed since compositionstart.\n// We therefore use the fallback data while still using the native\n// events as triggers.\nvar useFallbackData = (\n  !useCompositionEvent ||\n  &apos;documentMode&apos; in document &amp;&amp; document.documentMode &gt; 8\n);\n\nvar topLevelTypes = EventConstants.topLevelTypes;\nvar currentComposition = null;\n\n// Events and their corresponding property names.\nvar eventTypes = {\n  compositionEnd: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onCompositionEnd: null}),\n      captured: keyOf({onCompositionEndCapture: null})\n    },\n    dependencies: [\n      topLevelTypes.topBlur,\n      topLevelTypes.topCompositionEnd,\n      topLevelTypes.topKeyDown,\n      topLevelTypes.topKeyPress,\n      topLevelTypes.topKeyUp,\n      topLevelTypes.topMouseDown\n    ]\n  },\n  compositionStart: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onCompositionStart: null}),\n      captured: keyOf({onCompositionStartCapture: null})\n    },\n    dependencies: [\n      topLevelTypes.topBlur,\n      topLevelTypes.topCompositionStart,\n      topLevelTypes.topKeyDown,\n      topLevelTypes.topKeyPress,\n      topLevelTypes.topKeyUp,\n      topLevelTypes.topMouseDown\n    ]\n  },\n  compositionUpdate: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onCompositionUpdate: null}),\n      captured: keyOf({onCompositionUpdateCapture: null})\n    },\n    dependencies: [\n      topLevelTypes.topBlur,\n      topLevelTypes.topCompositionUpdate,\n      topLevelTypes.topKeyDown,\n      topLevelTypes.topKeyPress,\n      topLevelTypes.topKeyUp,\n      topLevelTypes.topMouseDown\n    ]\n  }\n};\n\n/**\n * Translate native top level events into event types.\n *\n * @param {string} topLevelType\n * @return {object}\n */\nfunction getCompositionEventType(topLevelType) {\n  switch (topLevelType) {\n    case topLevelTypes.topCompositionStart:\n      return eventTypes.compositionStart;\n    case topLevelTypes.topCompositionEnd:\n      return eventTypes.compositionEnd;\n    case topLevelTypes.topCompositionUpdate:\n      return eventTypes.compositionUpdate;\n  }\n}\n\n/**\n * Does our fallback best-guess model think this event signifies that\n * composition has begun?\n *\n * @param {string} topLevelType\n * @param {object} nativeEvent\n * @return {boolean}\n */\nfunction isFallbackStart(topLevelType, nativeEvent) {\n  return (\n    topLevelType === topLevelTypes.topKeyDown &amp;&amp;\n    nativeEvent.keyCode === START_KEYCODE\n  );\n}\n\n/**\n * Does our fallback mode think that this event is the end of composition?\n *\n * @param {string} topLevelType\n * @param {object} nativeEvent\n * @return {boolean}\n */\nfunction isFallbackEnd(topLevelType, nativeEvent) {\n  switch (topLevelType) {\n    case topLevelTypes.topKeyUp:\n      // Command keys insert or clear IME input.\n      return (END_KEYCODES.indexOf(nativeEvent.keyCode) !== -1);\n    case topLevelTypes.topKeyDown:\n      // Expect IME keyCode on each keydown. If we get any other\n      // code we must have exited earlier.\n      return (nativeEvent.keyCode !== START_KEYCODE);\n    case topLevelTypes.topKeyPress:\n    case topLevelTypes.topMouseDown:\n    case topLevelTypes.topBlur:\n      // Events are not possible without cancelling IME.\n      return true;\n    default:\n      return false;\n  }\n}\n\n/**\n * Helper class stores information about selection and document state\n * so we can figure out what changed at a later date.\n *\n * @param {DOMEventTarget} root\n */\nfunction FallbackCompositionState(root) {\n  this.root = root;\n  this.startSelection = ReactInputSelection.getSelection(root);\n  this.startValue = this.getText();\n}\n\n/**\n * Get current text of input.\n *\n * @return {string}\n */\nFallbackCompositionState.prototype.getText = function() {\n  return this.root.value || this.root[getTextContentAccessor()];\n};\n\n/**\n * Text that has changed since the start of composition.\n *\n * @return {string}\n */\nFallbackCompositionState.prototype.getData = function() {\n  var endValue = this.getText();\n  var prefixLength = this.startSelection.start;\n  var suffixLength = this.startValue.length - this.startSelection.end;\n\n  return endValue.substr(\n    prefixLength,\n    endValue.length - suffixLength - prefixLength\n  );\n};\n\n/**\n * This plugin creates `onCompositionStart`, `onCompositionUpdate` and\n * `onCompositionEnd` events on inputs, textareas and contentEditable\n * nodes.\n */\nvar CompositionEventPlugin = {\n\n  eventTypes: eventTypes,\n\n  /**\n   * @param {string} topLevelType Record from `EventConstants`.\n   * @param {DOMEventTarget} topLevelTarget The listening component root node.\n   * @param {string} topLevelTargetID ID of `topLevelTarget`.\n   * @param {object} nativeEvent Native browser event.\n   * @return {*} An accumulation of synthetic events.\n   * @see {EventPluginHub.extractEvents}\n   */\n  extractEvents: function(\n      topLevelType,\n      topLevelTarget,\n      topLevelTargetID,\n      nativeEvent) {\n\n    var eventType;\n    var data;\n\n    if (useCompositionEvent) {\n      eventType = getCompositionEventType(topLevelType);\n    } else if (!currentComposition) {\n      if (isFallbackStart(topLevelType, nativeEvent)) {\n        eventType = eventTypes.compositionStart;\n      }\n    } else if (isFallbackEnd(topLevelType, nativeEvent)) {\n      eventType = eventTypes.compositionEnd;\n    }\n\n    if (useFallbackData) {\n      // The current composition is stored statically and must not be\n      // overwritten while composition continues.\n      if (!currentComposition &amp;&amp; eventType === eventTypes.compositionStart) {\n        currentComposition = new FallbackCompositionState(topLevelTarget);\n      } else if (eventType === eventTypes.compositionEnd) {\n        if (currentComposition) {\n          data = currentComposition.getData();\n          currentComposition = null;\n        }\n      }\n    }\n\n    if (eventType) {\n      var event = SyntheticCompositionEvent.getPooled(\n        eventType,\n        topLevelTargetID,\n        nativeEvent\n      );\n      if (data) {\n        // Inject data generated from fallback path into the synthetic event.\n        // This matches the property of native CompositionEventInterface.\n        event.data = data;\n      }\n      EventPropagators.accumulateTwoPhaseDispatches(event);\n      return event;\n    }\n  }\n};\n\nmodule.exports = CompositionEventPlugin;\n\n},{&quot;./EventConstants&quot;:14,&quot;./EventPropagators&quot;:19,&quot;./ExecutionEnvironment&quot;:20,&quot;./ReactInputSelection&quot;:52,&quot;./SyntheticCompositionEvent&quot;:75,&quot;./getTextContentAccessor&quot;:105,&quot;./keyOf&quot;:115}],7:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule DOMChildrenOperations\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar Danger = require(&quot;./Danger&quot;);\nvar ReactMultiChildUpdateTypes = require(&quot;./ReactMultiChildUpdateTypes&quot;);\n\nvar getTextContentAccessor = require(&quot;./getTextContentAccessor&quot;);\n\n/**\n * The DOM property to use when setting text content.\n *\n * @type {string}\n * @private\n */\nvar textContentAccessor = getTextContentAccessor();\n\n/**\n * Inserts `childNode` as a child of `parentNode` at the `index`.\n *\n * @param {DOMElement} parentNode Parent node in which to insert.\n * @param {DOMElement} childNode Child node to insert.\n * @param {number} index Index at which to insert the child.\n * @internal\n */\nfunction insertChildAt(parentNode, childNode, index) {\n  var childNodes = parentNode.childNodes;\n  if (childNodes[index] === childNode) {\n    return;\n  }\n  // If `childNode` is already a child of `parentNode`, remove it so that\n  // computing `childNodes[index]` takes into account the removal.\n  if (childNode.parentNode === parentNode) {\n    parentNode.removeChild(childNode);\n  }\n  if (index &gt;= childNodes.length) {\n    parentNode.appendChild(childNode);\n  } else {\n    parentNode.insertBefore(childNode, childNodes[index]);\n  }\n}\n\n/**\n * Sets the text content of `node` to `text`.\n *\n * @param {DOMElement} node Node to change\n * @param {string} text New text content\n */\nvar updateTextContent;\nif (textContentAccessor === &apos;textContent&apos;) {\n  updateTextContent = function(node, text) {\n    node.textContent = text;\n  };\n} else {\n  updateTextContent = function(node, text) {\n    // In order to preserve newlines correctly, we can&apos;t use .innerText to set\n    // the contents (see #1080), so we empty the element then append a text node\n    while (node.firstChild) {\n      node.removeChild(node.firstChild);\n    }\n    if (text) {\n      var doc = node.ownerDocument || document;\n      node.appendChild(doc.createTextNode(text));\n    }\n  };\n}\n\n/**\n * Operations for updating with DOM children.\n */\nvar DOMChildrenOperations = {\n\n  dangerouslyReplaceNodeWithMarkup: Danger.dangerouslyReplaceNodeWithMarkup,\n\n  updateTextContent: updateTextContent,\n\n  /**\n   * Updates a component&apos;s children by processing a series of updates. The\n   * update configurations are each expected to have a `parentNode` property.\n   *\n   * @param {array&lt;object&gt;} updates List of update configurations.\n   * @param {array&lt;string&gt;} markupList List of markup strings.\n   * @internal\n   */\n  processUpdates: function(updates, markupList) {\n    var update;\n    // Mapping from parent IDs to initial child orderings.\n    var initialChildren = null;\n    // List of children that will be moved or removed.\n    var updatedChildren = null;\n\n    for (var i = 0; update = updates[i]; i++) {\n      if (update.type === ReactMultiChildUpdateTypes.MOVE_EXISTING ||\n          update.type === ReactMultiChildUpdateTypes.REMOVE_NODE) {\n        var updatedIndex = update.fromIndex;\n        var updatedChild = update.parentNode.childNodes[updatedIndex];\n        var parentID = update.parentID;\n\n        initialChildren = initialChildren || {};\n        initialChildren[parentID] = initialChildren[parentID] || [];\n        initialChildren[parentID][updatedIndex] = updatedChild;\n\n        updatedChildren = updatedChildren || [];\n        updatedChildren.push(updatedChild);\n      }\n    }\n\n    var renderedMarkup = Danger.dangerouslyRenderMarkup(markupList);\n\n    // Remove updated children first so that `toIndex` is consistent.\n    if (updatedChildren) {\n      for (var j = 0; j &lt; updatedChildren.length; j++) {\n        updatedChildren[j].parentNode.removeChild(updatedChildren[j]);\n      }\n    }\n\n    for (var k = 0; update = updates[k]; k++) {\n      switch (update.type) {\n        case ReactMultiChildUpdateTypes.INSERT_MARKUP:\n          insertChildAt(\n            update.parentNode,\n            renderedMarkup[update.markupIndex],\n            update.toIndex\n          );\n          break;\n        case ReactMultiChildUpdateTypes.MOVE_EXISTING:\n          insertChildAt(\n            update.parentNode,\n            initialChildren[update.parentID][update.fromIndex],\n            update.toIndex\n          );\n          break;\n        case ReactMultiChildUpdateTypes.TEXT_CONTENT:\n          updateTextContent(\n            update.parentNode,\n            update.textContent\n          );\n          break;\n        case ReactMultiChildUpdateTypes.REMOVE_NODE:\n          // Already removed by the for-loop above.\n          break;\n      }\n    }\n  }\n\n};\n\nmodule.exports = DOMChildrenOperations;\n\n},{&quot;./Danger&quot;:10,&quot;./ReactMultiChildUpdateTypes&quot;:58,&quot;./getTextContentAccessor&quot;:105}],8:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule DOMProperty\n * @typechecks static-only\n */\n\n/*jslint bitwise: true */\n\n&quot;use strict&quot;;\n\nvar invariant = require(&quot;./invariant&quot;);\n\nvar DOMPropertyInjection = {\n  /**\n   * Mapping from normalized, camelcased property names to a configuration that\n   * specifies how the associated DOM property should be accessed or rendered.\n   */\n  MUST_USE_ATTRIBUTE: 0x1,\n  MUST_USE_PROPERTY: 0x2,\n  HAS_SIDE_EFFECTS: 0x4,\n  HAS_BOOLEAN_VALUE: 0x8,\n  HAS_POSITIVE_NUMERIC_VALUE: 0x10,\n\n  /**\n   * Inject some specialized knowledge about the DOM. This takes a config object\n   * with the following properties:\n   *\n   * isCustomAttribute: function that given an attribute name will return true\n   * if it can be inserted into the DOM verbatim. Useful for data-* or aria-*\n   * attributes where it&apos;s impossible to enumerate all of the possible\n   * attribute names,\n   *\n   * Properties: object mapping DOM property name to one of the\n   * DOMPropertyInjection constants or null. If your attribute isn&apos;t in here,\n   * it won&apos;t get written to the DOM.\n   *\n   * DOMAttributeNames: object mapping React attribute name to the DOM\n   * attribute name. Attribute names not specified use the **lowercase**\n   * normalized name.\n   *\n   * DOMPropertyNames: similar to DOMAttributeNames but for DOM properties.\n   * Property names not specified use the normalized name.\n   *\n   * DOMMutationMethods: Properties that require special mutation methods. If\n   * `value` is undefined, the mutation method should unset the property.\n   *\n   * @param {object} domPropertyConfig the config as described above.\n   */\n  injectDOMPropertyConfig: function(domPropertyConfig) {\n    var Properties = domPropertyConfig.Properties || {};\n    var DOMAttributeNames = domPropertyConfig.DOMAttributeNames || {};\n    var DOMPropertyNames = domPropertyConfig.DOMPropertyNames || {};\n    var DOMMutationMethods = domPropertyConfig.DOMMutationMethods || {};\n\n    if (domPropertyConfig.isCustomAttribute) {\n      DOMProperty._isCustomAttributeFunctions.push(\n        domPropertyConfig.isCustomAttribute\n      );\n    }\n\n    for (var propName in Properties) {\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        !DOMProperty.isStandardName[propName],\n        &apos;injectDOMPropertyConfig(...): You\\&apos;re trying to inject DOM property &apos; +\n        &apos;\\&apos;%s\\&apos; which has already been injected. You may be accidentally &apos; +\n        &apos;injecting the same DOM property config twice, or you may be &apos; +\n        &apos;injecting two configs that have conflicting property names.&apos;,\n        propName\n      ) : invariant(!DOMProperty.isStandardName[propName]));\n\n      DOMProperty.isStandardName[propName] = true;\n\n      var lowerCased = propName.toLowerCase();\n      DOMProperty.getPossibleStandardName[lowerCased] = propName;\n\n      var attributeName = DOMAttributeNames[propName];\n      if (attributeName) {\n        DOMProperty.getPossibleStandardName[attributeName] = propName;\n      }\n\n      DOMProperty.getAttributeName[propName] = attributeName || lowerCased;\n\n      DOMProperty.getPropertyName[propName] =\n        DOMPropertyNames[propName] || propName;\n\n      var mutationMethod = DOMMutationMethods[propName];\n      if (mutationMethod) {\n        DOMProperty.getMutationMethod[propName] = mutationMethod;\n      }\n\n      var propConfig = Properties[propName];\n      DOMProperty.mustUseAttribute[propName] =\n        propConfig &amp; DOMPropertyInjection.MUST_USE_ATTRIBUTE;\n      DOMProperty.mustUseProperty[propName] =\n        propConfig &amp; DOMPropertyInjection.MUST_USE_PROPERTY;\n      DOMProperty.hasSideEffects[propName] =\n        propConfig &amp; DOMPropertyInjection.HAS_SIDE_EFFECTS;\n      DOMProperty.hasBooleanValue[propName] =\n        propConfig &amp; DOMPropertyInjection.HAS_BOOLEAN_VALUE;\n      DOMProperty.hasPositiveNumericValue[propName] =\n        propConfig &amp; DOMPropertyInjection.HAS_POSITIVE_NUMERIC_VALUE;\n\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        !DOMProperty.mustUseAttribute[propName] ||\n          !DOMProperty.mustUseProperty[propName],\n        &apos;DOMProperty: Cannot require using both attribute and property: %s&apos;,\n        propName\n      ) : invariant(!DOMProperty.mustUseAttribute[propName] ||\n        !DOMProperty.mustUseProperty[propName]));\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        DOMProperty.mustUseProperty[propName] ||\n          !DOMProperty.hasSideEffects[propName],\n        &apos;DOMProperty: Properties that have side effects must use property: %s&apos;,\n        propName\n      ) : invariant(DOMProperty.mustUseProperty[propName] ||\n        !DOMProperty.hasSideEffects[propName]));\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        !DOMProperty.hasBooleanValue[propName] ||\n          !DOMProperty.hasPositiveNumericValue[propName],\n        &apos;DOMProperty: Cannot have both boolean and positive numeric value: %s&apos;,\n        propName\n      ) : invariant(!DOMProperty.hasBooleanValue[propName] ||\n        !DOMProperty.hasPositiveNumericValue[propName]));\n    }\n  }\n};\nvar defaultValueCache = {};\n\n/**\n * DOMProperty exports lookup objects that can be used like functions:\n *\n *   &gt; DOMProperty.isValid[&apos;id&apos;]\n *   true\n *   &gt; DOMProperty.isValid[&apos;foobar&apos;]\n *   undefined\n *\n * Although this may be confusing, it performs better in general.\n *\n * @see http://jsperf.com/key-exists\n * @see http://jsperf.com/key-missing\n */\nvar DOMProperty = {\n\n  ID_ATTRIBUTE_NAME: &apos;data-reactid&apos;,\n\n  /**\n   * Checks whether a property name is a standard property.\n   * @type {Object}\n   */\n  isStandardName: {},\n\n  /**\n   * Mapping from lowercase property names to the properly cased version, used\n   * to warn in the case of missing properties.\n   * @type {Object}\n   */\n  getPossibleStandardName: {},\n\n  /**\n   * Mapping from normalized names to attribute names that differ. Attribute\n   * names are used when rendering markup or with `*Attribute()`.\n   * @type {Object}\n   */\n  getAttributeName: {},\n\n  /**\n   * Mapping from normalized names to properties on DOM node instances.\n   * (This includes properties that mutate due to external factors.)\n   * @type {Object}\n   */\n  getPropertyName: {},\n\n  /**\n   * Mapping from normalized names to mutation methods. This will only exist if\n   * mutation cannot be set simply by the property or `setAttribute()`.\n   * @type {Object}\n   */\n  getMutationMethod: {},\n\n  /**\n   * Whether the property must be accessed and mutated as an object property.\n   * @type {Object}\n   */\n  mustUseAttribute: {},\n\n  /**\n   * Whether the property must be accessed and mutated using `*Attribute()`.\n   * (This includes anything that fails `&lt;propName&gt; in &lt;element&gt;`.)\n   * @type {Object}\n   */\n  mustUseProperty: {},\n\n  /**\n   * Whether or not setting a value causes side effects such as triggering\n   * resources to be loaded or text selection changes. We must ensure that\n   * the value is only set if it has changed.\n   * @type {Object}\n   */\n  hasSideEffects: {},\n\n  /**\n   * Whether the property should be removed when set to a falsey value.\n   * @type {Object}\n   */\n  hasBooleanValue: {},\n\n  /**\n   * Whether the property must be positive numeric or parse as a positive\n   * numeric and should be removed when set to a falsey value.\n   * @type {Object}\n   */\n  hasPositiveNumericValue: {},\n\n  /**\n   * All of the isCustomAttribute() functions that have been injected.\n   */\n  _isCustomAttributeFunctions: [],\n\n  /**\n   * Checks whether a property name is a custom attribute.\n   * @method\n   */\n  isCustomAttribute: function(attributeName) {\n    return DOMProperty._isCustomAttributeFunctions.some(\n      function(isCustomAttributeFn) {\n        return isCustomAttributeFn.call(null, attributeName);\n      }\n    );\n  },\n\n  /**\n   * Returns the default property value for a DOM property (i.e., not an\n   * attribute). Most default values are &apos;&apos; or false, but not all. Worse yet,\n   * some (in particular, `type`) vary depending on the type of element.\n   *\n   * TODO: Is it better to grab all the possible properties when creating an\n   * element to avoid having to create the same element twice?\n   */\n  getDefaultValueForProperty: function(nodeName, prop) {\n    var nodeDefaults = defaultValueCache[nodeName];\n    var testElement;\n    if (!nodeDefaults) {\n      defaultValueCache[nodeName] = nodeDefaults = {};\n    }\n    if (!(prop in nodeDefaults)) {\n      testElement = document.createElement(nodeName);\n      nodeDefaults[prop] = testElement[prop];\n    }\n    return nodeDefaults[prop];\n  },\n\n  injection: DOMPropertyInjection\n};\n\nmodule.exports = DOMProperty;\n\n},{&quot;./invariant&quot;:108}],9:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule DOMPropertyOperations\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar DOMProperty = require(&quot;./DOMProperty&quot;);\n\nvar escapeTextForBrowser = require(&quot;./escapeTextForBrowser&quot;);\nvar memoizeStringOnly = require(&quot;./memoizeStringOnly&quot;);\n\nfunction shouldIgnoreValue(name, value) {\n  return value == null ||\n    DOMProperty.hasBooleanValue[name] &amp;&amp; !value ||\n    DOMProperty.hasPositiveNumericValue[name] &amp;&amp; (isNaN(value) || value &lt; 1);\n}\n\nvar processAttributeNameAndPrefix = memoizeStringOnly(function(name) {\n  return escapeTextForBrowser(name) + &apos;=&quot;&apos;;\n});\n\nif (&quot;production&quot; !== &quot;development&quot;) {\n  var reactProps = {\n    children: true,\n    dangerouslySetInnerHTML: true,\n    key: true,\n    ref: true\n  };\n  var warnedProperties = {};\n\n  var warnUnknownProperty = function(name) {\n    if (reactProps[name] || warnedProperties[name]) {\n      return;\n    }\n\n    warnedProperties[name] = true;\n    var lowerCasedName = name.toLowerCase();\n\n    // data-* attributes should be lowercase; suggest the lowercase version\n    var standardName = DOMProperty.isCustomAttribute(lowerCasedName) ?\n      lowerCasedName : DOMProperty.getPossibleStandardName[lowerCasedName];\n\n    // For now, only warn when we have a suggested correction. This prevents\n    // logging too much when using transferPropsTo.\n    if (standardName != null) {\n      console.warn(\n        &apos;Unknown DOM property &apos; + name + &apos;. Did you mean &apos; + standardName + &apos;?&apos;\n      );\n    }\n\n  };\n}\n\n/**\n * Operations for dealing with DOM properties.\n */\nvar DOMPropertyOperations = {\n\n  /**\n   * Creates markup for the ID property.\n   *\n   * @param {string} id Unescaped ID.\n   * @return {string} Markup string.\n   */\n  createMarkupForID: function(id) {\n    return processAttributeNameAndPrefix(DOMProperty.ID_ATTRIBUTE_NAME) +\n      escapeTextForBrowser(id) + &apos;&quot;&apos;;\n  },\n\n  /**\n   * Creates markup for a property.\n   *\n   * @param {string} name\n   * @param {*} value\n   * @return {?string} Markup string, or null if the property was invalid.\n   */\n  createMarkupForProperty: function(name, value) {\n    if (DOMProperty.isStandardName[name]) {\n      if (shouldIgnoreValue(name, value)) {\n        return &apos;&apos;;\n      }\n      var attributeName = DOMProperty.getAttributeName[name];\n      if (DOMProperty.hasBooleanValue[name]) {\n        return escapeTextForBrowser(attributeName);\n      }\n      return processAttributeNameAndPrefix(attributeName) +\n        escapeTextForBrowser(value) + &apos;&quot;&apos;;\n    } else if (DOMProperty.isCustomAttribute(name)) {\n      if (value == null) {\n        return &apos;&apos;;\n      }\n      return processAttributeNameAndPrefix(name) +\n        escapeTextForBrowser(value) + &apos;&quot;&apos;;\n    } else if (&quot;production&quot; !== &quot;development&quot;) {\n      warnUnknownProperty(name);\n    }\n    return null;\n  },\n\n  /**\n   * Sets the value for a property on a node.\n   *\n   * @param {DOMElement} node\n   * @param {string} name\n   * @param {*} value\n   */\n  setValueForProperty: function(node, name, value) {\n    if (DOMProperty.isStandardName[name]) {\n      var mutationMethod = DOMProperty.getMutationMethod[name];\n      if (mutationMethod) {\n        mutationMethod(node, value);\n      } else if (shouldIgnoreValue(name, value)) {\n        this.deleteValueForProperty(node, name);\n      } else if (DOMProperty.mustUseAttribute[name]) {\n        node.setAttribute(DOMProperty.getAttributeName[name], &apos;&apos; + value);\n      } else {\n        var propName = DOMProperty.getPropertyName[name];\n        if (!DOMProperty.hasSideEffects[name] || node[propName] !== value) {\n          node[propName] = value;\n        }\n      }\n    } else if (DOMProperty.isCustomAttribute(name)) {\n      if (value == null) {\n        node.removeAttribute(DOMProperty.getAttributeName[name]);\n      } else {\n        node.setAttribute(name, &apos;&apos; + value);\n      }\n    } else if (&quot;production&quot; !== &quot;development&quot;) {\n      warnUnknownProperty(name);\n    }\n  },\n\n  /**\n   * Deletes the value for a property on a node.\n   *\n   * @param {DOMElement} node\n   * @param {string} name\n   */\n  deleteValueForProperty: function(node, name) {\n    if (DOMProperty.isStandardName[name]) {\n      var mutationMethod = DOMProperty.getMutationMethod[name];\n      if (mutationMethod) {\n        mutationMethod(node, undefined);\n      } else if (DOMProperty.mustUseAttribute[name]) {\n        node.removeAttribute(DOMProperty.getAttributeName[name]);\n      } else {\n        var propName = DOMProperty.getPropertyName[name];\n        var defaultValue = DOMProperty.getDefaultValueForProperty(\n          node.nodeName,\n          name\n        );\n        if (!DOMProperty.hasSideEffects[name] ||\n            node[propName] !== defaultValue) {\n          node[propName] = defaultValue;\n        }\n      }\n    } else if (DOMProperty.isCustomAttribute(name)) {\n      node.removeAttribute(name);\n    } else if (&quot;production&quot; !== &quot;development&quot;) {\n      warnUnknownProperty(name);\n    }\n  }\n\n};\n\nmodule.exports = DOMPropertyOperations;\n\n},{&quot;./DOMProperty&quot;:8,&quot;./escapeTextForBrowser&quot;:96,&quot;./memoizeStringOnly&quot;:116}],10:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule Danger\n * @typechecks static-only\n */\n\n/*jslint evil: true, sub: true */\n\n&quot;use strict&quot;;\n\nvar ExecutionEnvironment = require(&quot;./ExecutionEnvironment&quot;);\n\nvar createNodesFromMarkup = require(&quot;./createNodesFromMarkup&quot;);\nvar emptyFunction = require(&quot;./emptyFunction&quot;);\nvar getMarkupWrap = require(&quot;./getMarkupWrap&quot;);\nvar invariant = require(&quot;./invariant&quot;);\n\nvar OPEN_TAG_NAME_EXP = /^(&lt;[^ \\/&gt;]+)/;\nvar RESULT_INDEX_ATTR = &apos;data-danger-index&apos;;\n\n/**\n * Extracts the `nodeName` from a string of markup.\n *\n * NOTE: Extracting the `nodeName` does not require a regular expression match\n * because we make assumptions about React-generated markup (i.e. there are no\n * spaces surrounding the opening tag and there is at least one attribute).\n *\n * @param {string} markup String of markup.\n * @return {string} Node name of the supplied markup.\n * @see http://jsperf.com/extract-nodename\n */\nfunction getNodeName(markup) {\n  return markup.substring(1, markup.indexOf(&apos; &apos;));\n}\n\nvar Danger = {\n\n  /**\n   * Renders markup into an array of nodes. The markup is expected to render\n   * into a list of root nodes. Also, the length of `resultList` and\n   * `markupList` should be the same.\n   *\n   * @param {array&lt;string&gt;} markupList List of markup strings to render.\n   * @return {array&lt;DOMElement&gt;} List of rendered nodes.\n   * @internal\n   */\n  dangerouslyRenderMarkup: function(markupList) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      ExecutionEnvironment.canUseDOM,\n      &apos;dangerouslyRenderMarkup(...): Cannot render markup in a Worker &apos; +\n      &apos;thread. This is likely a bug in the framework. Please report &apos; +\n      &apos;immediately.&apos;\n    ) : invariant(ExecutionEnvironment.canUseDOM));\n    var nodeName;\n    var markupByNodeName = {};\n    // Group markup by `nodeName` if a wrap is necessary, else by &apos;*&apos;.\n    for (var i = 0; i &lt; markupList.length; i++) {\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        markupList[i],\n        &apos;dangerouslyRenderMarkup(...): Missing markup.&apos;\n      ) : invariant(markupList[i]));\n      nodeName = getNodeName(markupList[i]);\n      nodeName = getMarkupWrap(nodeName) ? nodeName : &apos;*&apos;;\n      markupByNodeName[nodeName] = markupByNodeName[nodeName] || [];\n      markupByNodeName[nodeName][i] = markupList[i];\n    }\n    var resultList = [];\n    var resultListAssignmentCount = 0;\n    for (nodeName in markupByNodeName) {\n      if (!markupByNodeName.hasOwnProperty(nodeName)) {\n        continue;\n      }\n      var markupListByNodeName = markupByNodeName[nodeName];\n\n      // This for-in loop skips the holes of the sparse array. The order of\n      // iteration should follow the order of assignment, which happens to match\n      // numerical index order, but we don&apos;t rely on that.\n      for (var resultIndex in markupListByNodeName) {\n        if (markupListByNodeName.hasOwnProperty(resultIndex)) {\n          var markup = markupListByNodeName[resultIndex];\n\n          // Push the requested markup with an additional RESULT_INDEX_ATTR\n          // attribute.  If the markup does not start with a &lt; character, it\n          // will be discarded below (with an appropriate console.error).\n          markupListByNodeName[resultIndex] = markup.replace(\n            OPEN_TAG_NAME_EXP,\n            // This index will be parsed back out below.\n            &apos;$1 &apos; + RESULT_INDEX_ATTR + &apos;=&quot;&apos; + resultIndex + &apos;&quot; &apos;\n          );\n        }\n      }\n\n      // Render each group of markup with similar wrapping `nodeName`.\n      var renderNodes = createNodesFromMarkup(\n        markupListByNodeName.join(&apos;&apos;),\n        emptyFunction // Do nothing special with &lt;script&gt; tags.\n      );\n\n      for (i = 0; i &lt; renderNodes.length; ++i) {\n        var renderNode = renderNodes[i];\n        if (renderNode.hasAttribute &amp;&amp;\n            renderNode.hasAttribute(RESULT_INDEX_ATTR)) {\n\n          resultIndex = +renderNode.getAttribute(RESULT_INDEX_ATTR);\n          renderNode.removeAttribute(RESULT_INDEX_ATTR);\n\n          (&quot;production&quot; !== &quot;development&quot; ? invariant(\n            !resultList.hasOwnProperty(resultIndex),\n            &apos;Danger: Assigning to an already-occupied result index.&apos;\n          ) : invariant(!resultList.hasOwnProperty(resultIndex)));\n\n          resultList[resultIndex] = renderNode;\n\n          // This should match resultList.length and markupList.length when\n          // we&apos;re done.\n          resultListAssignmentCount += 1;\n\n        } else if (&quot;production&quot; !== &quot;development&quot;) {\n          console.error(\n            &quot;Danger: Discarding unexpected node:&quot;,\n            renderNode\n          );\n        }\n      }\n    }\n\n    // Although resultList was populated out of order, it should now be a dense\n    // array.\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      resultListAssignmentCount === resultList.length,\n      &apos;Danger: Did not assign to every index of resultList.&apos;\n    ) : invariant(resultListAssignmentCount === resultList.length));\n\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      resultList.length === markupList.length,\n      &apos;Danger: Expected markup to render %s nodes, but rendered %s.&apos;,\n      markupList.length,\n      resultList.length\n    ) : invariant(resultList.length === markupList.length));\n\n    return resultList;\n  },\n\n  /**\n   * Replaces a node with a string of markup at its current position within its\n   * parent. The markup must render into a single root node.\n   *\n   * @param {DOMElement} oldChild Child node to replace.\n   * @param {string} markup Markup to render in place of the child node.\n   * @internal\n   */\n  dangerouslyReplaceNodeWithMarkup: function(oldChild, markup) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      ExecutionEnvironment.canUseDOM,\n      &apos;dangerouslyReplaceNodeWithMarkup(...): Cannot render markup in a &apos; +\n      &apos;worker thread. This is likely a bug in the framework. Please report &apos; +\n      &apos;immediately.&apos;\n    ) : invariant(ExecutionEnvironment.canUseDOM));\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(markup, &apos;dangerouslyReplaceNodeWithMarkup(...): Missing markup.&apos;) : invariant(markup));\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      oldChild.tagName.toLowerCase() !== &apos;html&apos;,\n      &apos;dangerouslyReplaceNodeWithMarkup(...): Cannot replace markup of the &apos; +\n      &apos;&lt;html&gt; node. This is because browser quirks make this unreliable &apos; +\n      &apos;and/or slow. If you want to render to the root you must use &apos; +\n      &apos;server rendering. See renderComponentToString().&apos;\n    ) : invariant(oldChild.tagName.toLowerCase() !== &apos;html&apos;));\n\n    var newChild = createNodesFromMarkup(markup, emptyFunction)[0];\n    oldChild.parentNode.replaceChild(newChild, oldChild);\n  }\n\n};\n\nmodule.exports = Danger;\n\n},{&quot;./ExecutionEnvironment&quot;:20,&quot;./createNodesFromMarkup&quot;:92,&quot;./emptyFunction&quot;:95,&quot;./getMarkupWrap&quot;:102,&quot;./invariant&quot;:108}],11:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule DefaultDOMPropertyConfig\n */\n\n/*jslint bitwise: true*/\n\n&quot;use strict&quot;;\n\nvar DOMProperty = require(&quot;./DOMProperty&quot;);\n\nvar MUST_USE_ATTRIBUTE = DOMProperty.injection.MUST_USE_ATTRIBUTE;\nvar MUST_USE_PROPERTY = DOMProperty.injection.MUST_USE_PROPERTY;\nvar HAS_BOOLEAN_VALUE = DOMProperty.injection.HAS_BOOLEAN_VALUE;\nvar HAS_SIDE_EFFECTS = DOMProperty.injection.HAS_SIDE_EFFECTS;\nvar HAS_POSITIVE_NUMERIC_VALUE =\n  DOMProperty.injection.HAS_POSITIVE_NUMERIC_VALUE;\n\nvar DefaultDOMPropertyConfig = {\n  isCustomAttribute: RegExp.prototype.test.bind(\n    /^(data|aria)-[a-z_][a-z\\d_.\\-]*$/\n  ),\n  Properties: {\n    /**\n     * Standard Properties\n     */\n    accept: null,\n    accessKey: null,\n    action: null,\n    allowFullScreen: MUST_USE_ATTRIBUTE | HAS_BOOLEAN_VALUE,\n    allowTransparency: MUST_USE_ATTRIBUTE,\n    alt: null,\n    async: HAS_BOOLEAN_VALUE,\n    autoComplete: null,\n    // autoFocus is polyfilled/normalized by AutoFocusMixin\n    // autoFocus: HAS_BOOLEAN_VALUE,\n    autoPlay: HAS_BOOLEAN_VALUE,\n    cellPadding: null,\n    cellSpacing: null,\n    charSet: MUST_USE_ATTRIBUTE,\n    checked: MUST_USE_PROPERTY | HAS_BOOLEAN_VALUE,\n    className: MUST_USE_PROPERTY,\n    cols: MUST_USE_ATTRIBUTE | HAS_POSITIVE_NUMERIC_VALUE,\n    colSpan: null,\n    content: null,\n    contentEditable: null,\n    contextMenu: MUST_USE_ATTRIBUTE,\n    controls: MUST_USE_PROPERTY | HAS_BOOLEAN_VALUE,\n    crossOrigin: null,\n    data: null, // For `&lt;object /&gt;` acts as `src`.\n    dateTime: MUST_USE_ATTRIBUTE,\n    defer: HAS_BOOLEAN_VALUE,\n    dir: null,\n    disabled: MUST_USE_ATTRIBUTE | HAS_BOOLEAN_VALUE,\n    download: null,\n    draggable: null,\n    encType: null,\n    form: MUST_USE_ATTRIBUTE,\n    formNoValidate: HAS_BOOLEAN_VALUE,\n    frameBorder: MUST_USE_ATTRIBUTE,\n    height: MUST_USE_ATTRIBUTE,\n    hidden: MUST_USE_ATTRIBUTE | HAS_BOOLEAN_VALUE,\n    href: null,\n    hrefLang: null,\n    htmlFor: null,\n    httpEquiv: null,\n    icon: null,\n    id: MUST_USE_PROPERTY,\n    label: null,\n    lang: null,\n    list: null,\n    loop: MUST_USE_PROPERTY | HAS_BOOLEAN_VALUE,\n    max: null,\n    maxLength: MUST_USE_ATTRIBUTE,\n    mediaGroup: null,\n    method: null,\n    min: null,\n    multiple: MUST_USE_PROPERTY | HAS_BOOLEAN_VALUE,\n    muted: MUST_USE_PROPERTY | HAS_BOOLEAN_VALUE,\n    name: null,\n    noValidate: HAS_BOOLEAN_VALUE,\n    pattern: null,\n    placeholder: null,\n    poster: null,\n    preload: null,\n    radioGroup: null,\n    readOnly: MUST_USE_PROPERTY | HAS_BOOLEAN_VALUE,\n    rel: null,\n    required: HAS_BOOLEAN_VALUE,\n    role: MUST_USE_ATTRIBUTE,\n    rows: MUST_USE_ATTRIBUTE | HAS_POSITIVE_NUMERIC_VALUE,\n    rowSpan: null,\n    sandbox: null,\n    scope: null,\n    scrollLeft: MUST_USE_PROPERTY,\n    scrollTop: MUST_USE_PROPERTY,\n    seamless: MUST_USE_ATTRIBUTE | HAS_BOOLEAN_VALUE,\n    selected: MUST_USE_PROPERTY | HAS_BOOLEAN_VALUE,\n    size: MUST_USE_ATTRIBUTE | HAS_POSITIVE_NUMERIC_VALUE,\n    span: HAS_POSITIVE_NUMERIC_VALUE,\n    spellCheck: null,\n    src: null,\n    srcDoc: MUST_USE_PROPERTY,\n    step: null,\n    style: null,\n    tabIndex: null,\n    target: null,\n    title: null,\n    type: null,\n    value: MUST_USE_PROPERTY | HAS_SIDE_EFFECTS,\n    width: MUST_USE_ATTRIBUTE,\n    wmode: MUST_USE_ATTRIBUTE,\n\n    /**\n     * Non-standard Properties\n     */\n    autoCapitalize: null, // Supported in Mobile Safari for keyboard hints\n    autoCorrect: null, // Supported in Mobile Safari for keyboard hints\n    property: null, // Supports OG in meta tags\n\n    /**\n     * SVG Properties\n     */\n    cx: MUST_USE_ATTRIBUTE,\n    cy: MUST_USE_ATTRIBUTE,\n    d: MUST_USE_ATTRIBUTE,\n    fill: MUST_USE_ATTRIBUTE,\n    fx: MUST_USE_ATTRIBUTE,\n    fy: MUST_USE_ATTRIBUTE,\n    gradientTransform: MUST_USE_ATTRIBUTE,\n    gradientUnits: MUST_USE_ATTRIBUTE,\n    offset: MUST_USE_ATTRIBUTE,\n    points: MUST_USE_ATTRIBUTE,\n    r: MUST_USE_ATTRIBUTE,\n    rx: MUST_USE_ATTRIBUTE,\n    ry: MUST_USE_ATTRIBUTE,\n    spreadMethod: MUST_USE_ATTRIBUTE,\n    stopColor: MUST_USE_ATTRIBUTE,\n    stopOpacity: MUST_USE_ATTRIBUTE,\n    stroke: MUST_USE_ATTRIBUTE,\n    strokeLinecap: MUST_USE_ATTRIBUTE,\n    strokeWidth: MUST_USE_ATTRIBUTE,\n    transform: MUST_USE_ATTRIBUTE,\n    version: MUST_USE_ATTRIBUTE,\n    viewBox: MUST_USE_ATTRIBUTE,\n    x1: MUST_USE_ATTRIBUTE,\n    x2: MUST_USE_ATTRIBUTE,\n    x: MUST_USE_ATTRIBUTE,\n    y1: MUST_USE_ATTRIBUTE,\n    y2: MUST_USE_ATTRIBUTE,\n    y: MUST_USE_ATTRIBUTE\n  },\n  DOMAttributeNames: {\n    className: &apos;class&apos;,\n    gradientTransform: &apos;gradientTransform&apos;,\n    gradientUnits: &apos;gradientUnits&apos;,\n    htmlFor: &apos;for&apos;,\n    spreadMethod: &apos;spreadMethod&apos;,\n    stopColor: &apos;stop-color&apos;,\n    stopOpacity: &apos;stop-opacity&apos;,\n    strokeLinecap: &apos;stroke-linecap&apos;,\n    strokeWidth: &apos;stroke-width&apos;,\n    viewBox: &apos;viewBox&apos;\n  },\n  DOMPropertyNames: {\n    autoCapitalize: &apos;autocapitalize&apos;,\n    autoComplete: &apos;autocomplete&apos;,\n    autoCorrect: &apos;autocorrect&apos;,\n    autoFocus: &apos;autofocus&apos;,\n    autoPlay: &apos;autoplay&apos;,\n    encType: &apos;enctype&apos;,\n    hrefLang: &apos;hreflang&apos;,\n    radioGroup: &apos;radiogroup&apos;,\n    spellCheck: &apos;spellcheck&apos;,\n    srcDoc: &apos;srcdoc&apos;\n  },\n  DOMMutationMethods: {\n    /**\n     * Setting `className` to null may cause it to be set to the string &quot;null&quot;.\n     *\n     * @param {DOMElement} node\n     * @param {*} value\n     */\n    className: function(node, value) {\n      node.className = value || &apos;&apos;;\n    }\n  }\n};\n\nmodule.exports = DefaultDOMPropertyConfig;\n\n},{&quot;./DOMProperty&quot;:8}],12:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule DefaultEventPluginOrder\n */\n\n&quot;use strict&quot;;\n\n var keyOf = require(&quot;./keyOf&quot;);\n\n/**\n * Module that is injectable into `EventPluginHub`, that specifies a\n * deterministic ordering of `EventPlugin`s. A convenient way to reason about\n * plugins, without having to package every one of them. This is better than\n * having plugins be ordered in the same order that they are injected because\n * that ordering would be influenced by the packaging order.\n * `ResponderEventPlugin` must occur before `SimpleEventPlugin` so that\n * preventing default on events is convenient in `SimpleEventPlugin` handlers.\n */\nvar DefaultEventPluginOrder = [\n  keyOf({ResponderEventPlugin: null}),\n  keyOf({SimpleEventPlugin: null}),\n  keyOf({TapEventPlugin: null}),\n  keyOf({EnterLeaveEventPlugin: null}),\n  keyOf({ChangeEventPlugin: null}),\n  keyOf({SelectEventPlugin: null}),\n  keyOf({CompositionEventPlugin: null}),\n  keyOf({AnalyticsEventPlugin: null}),\n  keyOf({MobileSafariClickEventPlugin: null})\n];\n\nmodule.exports = DefaultEventPluginOrder;\n\n},{&quot;./keyOf&quot;:115}],13:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule EnterLeaveEventPlugin\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar EventConstants = require(&quot;./EventConstants&quot;);\nvar EventPropagators = require(&quot;./EventPropagators&quot;);\nvar SyntheticMouseEvent = require(&quot;./SyntheticMouseEvent&quot;);\n\nvar ReactMount = require(&quot;./ReactMount&quot;);\nvar keyOf = require(&quot;./keyOf&quot;);\n\nvar topLevelTypes = EventConstants.topLevelTypes;\nvar getFirstReactDOM = ReactMount.getFirstReactDOM;\n\nvar eventTypes = {\n  mouseEnter: {\n    registrationName: keyOf({onMouseEnter: null}),\n    dependencies: [\n      topLevelTypes.topMouseOut,\n      topLevelTypes.topMouseOver\n    ]\n  },\n  mouseLeave: {\n    registrationName: keyOf({onMouseLeave: null}),\n    dependencies: [\n      topLevelTypes.topMouseOut,\n      topLevelTypes.topMouseOver\n    ]\n  }\n};\n\nvar extractedEvents = [null, null];\n\nvar EnterLeaveEventPlugin = {\n\n  eventTypes: eventTypes,\n\n  /**\n   * For almost every interaction we care about, there will be both a top-level\n   * `mouseover` and `mouseout` event that occurs. Only use `mouseout` so that\n   * we do not extract duplicate events. However, moving the mouse into the\n   * browser from outside will not fire a `mouseout` event. In this case, we use\n   * the `mouseover` top-level event.\n   *\n   * @param {string} topLevelType Record from `EventConstants`.\n   * @param {DOMEventTarget} topLevelTarget The listening component root node.\n   * @param {string} topLevelTargetID ID of `topLevelTarget`.\n   * @param {object} nativeEvent Native browser event.\n   * @return {*} An accumulation of synthetic events.\n   * @see {EventPluginHub.extractEvents}\n   */\n  extractEvents: function(\n      topLevelType,\n      topLevelTarget,\n      topLevelTargetID,\n      nativeEvent) {\n    if (topLevelType === topLevelTypes.topMouseOver &amp;&amp;\n        (nativeEvent.relatedTarget || nativeEvent.fromElement)) {\n      return null;\n    }\n    if (topLevelType !== topLevelTypes.topMouseOut &amp;&amp;\n        topLevelType !== topLevelTypes.topMouseOver) {\n      // Must not be a mouse in or mouse out - ignoring.\n      return null;\n    }\n\n    var win;\n    if (topLevelTarget.window === topLevelTarget) {\n      // `topLevelTarget` is probably a window object.\n      win = topLevelTarget;\n    } else {\n      // TODO: Figure out why `ownerDocument` is sometimes undefined in IE8.\n      var doc = topLevelTarget.ownerDocument;\n      if (doc) {\n        win = doc.defaultView || doc.parentWindow;\n      } else {\n        win = window;\n      }\n    }\n\n    var from, to;\n    if (topLevelType === topLevelTypes.topMouseOut) {\n      from = topLevelTarget;\n      to =\n        getFirstReactDOM(nativeEvent.relatedTarget || nativeEvent.toElement) ||\n        win;\n    } else {\n      from = win;\n      to = topLevelTarget;\n    }\n\n    if (from === to) {\n      // Nothing pertains to our managed components.\n      return null;\n    }\n\n    var fromID = from ? ReactMount.getID(from) : &apos;&apos;;\n    var toID = to ? ReactMount.getID(to) : &apos;&apos;;\n\n    var leave = SyntheticMouseEvent.getPooled(\n      eventTypes.mouseLeave,\n      fromID,\n      nativeEvent\n    );\n    leave.type = &apos;mouseleave&apos;;\n    leave.target = from;\n    leave.relatedTarget = to;\n\n    var enter = SyntheticMouseEvent.getPooled(\n      eventTypes.mouseEnter,\n      toID,\n      nativeEvent\n    );\n    enter.type = &apos;mouseenter&apos;;\n    enter.target = to;\n    enter.relatedTarget = from;\n\n    EventPropagators.accumulateEnterLeaveDispatches(leave, enter, fromID, toID);\n\n    extractedEvents[0] = leave;\n    extractedEvents[1] = enter;\n\n    return extractedEvents;\n  }\n\n};\n\nmodule.exports = EnterLeaveEventPlugin;\n\n},{&quot;./EventConstants&quot;:14,&quot;./EventPropagators&quot;:19,&quot;./ReactMount&quot;:55,&quot;./SyntheticMouseEvent&quot;:80,&quot;./keyOf&quot;:115}],14:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule EventConstants\n */\n\n&quot;use strict&quot;;\n\nvar keyMirror = require(&quot;./keyMirror&quot;);\n\nvar PropagationPhases = keyMirror({bubbled: null, captured: null});\n\n/**\n * Types of raw signals from the browser caught at the top level.\n */\nvar topLevelTypes = keyMirror({\n  topBlur: null,\n  topChange: null,\n  topClick: null,\n  topCompositionEnd: null,\n  topCompositionStart: null,\n  topCompositionUpdate: null,\n  topContextMenu: null,\n  topCopy: null,\n  topCut: null,\n  topDoubleClick: null,\n  topDrag: null,\n  topDragEnd: null,\n  topDragEnter: null,\n  topDragExit: null,\n  topDragLeave: null,\n  topDragOver: null,\n  topDragStart: null,\n  topDrop: null,\n  topError: null,\n  topFocus: null,\n  topInput: null,\n  topKeyDown: null,\n  topKeyPress: null,\n  topKeyUp: null,\n  topLoad: null,\n  topMouseDown: null,\n  topMouseMove: null,\n  topMouseOut: null,\n  topMouseOver: null,\n  topMouseUp: null,\n  topPaste: null,\n  topReset: null,\n  topScroll: null,\n  topSelectionChange: null,\n  topSubmit: null,\n  topTouchCancel: null,\n  topTouchEnd: null,\n  topTouchMove: null,\n  topTouchStart: null,\n  topWheel: null\n});\n\nvar EventConstants = {\n  topLevelTypes: topLevelTypes,\n  PropagationPhases: PropagationPhases\n};\n\nmodule.exports = EventConstants;\n\n},{&quot;./keyMirror&quot;:114}],15:[function(require,module,exports){\n/**\n * @providesModule EventListener\n */\n\nvar emptyFunction = require(&quot;./emptyFunction&quot;);\n\n/**\n * Upstream version of event listener. Does not take into account specific\n * nature of platform.\n */\nvar EventListener = {\n  /**\n   * Listen to DOM events during the bubble phase.\n   *\n   * @param {DOMEventTarget} target DOM element to register listener on.\n   * @param {string} eventType Event type, e.g. &apos;click&apos; or &apos;mouseover&apos;.\n   * @param {function} callback Callback function.\n   * @return {object} Object with a `remove` method.\n   */\n  listen: function(target, eventType, callback) {\n    if (target.addEventListener) {\n      target.addEventListener(eventType, callback, false);\n      return {\n        remove: function() {\n          target.removeEventListener(eventType, callback, false);\n        }\n      };\n    } else if (target.attachEvent) {\n      target.attachEvent(&apos;on&apos; + eventType, callback);\n      return {\n        remove: function() {\n          target.detachEvent(eventType, callback);\n        }\n      };\n    }\n  },\n\n  /**\n   * Listen to DOM events during the capture phase.\n   *\n   * @param {DOMEventTarget} target DOM element to register listener on.\n   * @param {string} eventType Event type, e.g. &apos;click&apos; or &apos;mouseover&apos;.\n   * @param {function} callback Callback function.\n   * @return {object} Object with a `remove` method.\n   */\n  capture: function(target, eventType, callback) {\n    if (!target.addEventListener) {\n      if (&quot;production&quot; !== &quot;development&quot;) {\n        console.error(\n          &apos;Attempted to listen to events during the capture phase on a &apos; +\n          &apos;browser that does not support the capture phase. Your application &apos; +\n          &apos;will not receive some events.&apos;\n        );\n      }\n      return {\n        remove: emptyFunction\n      };\n    } else {\n      target.addEventListener(eventType, callback, true);\n      return {\n        remove: function() {\n          target.removeEventListener(eventType, callback, true);\n        }\n      };\n    }\n  }\n};\n\nmodule.exports = EventListener;\n\n},{&quot;./emptyFunction&quot;:95}],16:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule EventPluginHub\n */\n\n&quot;use strict&quot;;\n\nvar EventPluginRegistry = require(&quot;./EventPluginRegistry&quot;);\nvar EventPluginUtils = require(&quot;./EventPluginUtils&quot;);\nvar ExecutionEnvironment = require(&quot;./ExecutionEnvironment&quot;);\n\nvar accumulate = require(&quot;./accumulate&quot;);\nvar forEachAccumulated = require(&quot;./forEachAccumulated&quot;);\nvar invariant = require(&quot;./invariant&quot;);\nvar isEventSupported = require(&quot;./isEventSupported&quot;);\n\n/**\n * Internal store for event listeners\n */\nvar listenerBank = {};\n\n/**\n * Internal queue of events that have accumulated their dispatches and are\n * waiting to have their dispatches executed.\n */\nvar eventQueue = null;\n\n/**\n * Dispatches an event and releases it back into the pool, unless persistent.\n *\n * @param {?object} event Synthetic event to be dispatched.\n * @private\n */\nvar executeDispatchesAndRelease = function(event) {\n  if (event) {\n    var executeDispatch = EventPluginUtils.executeDispatch;\n    // Plugins can provide custom behavior when dispatching events.\n    var PluginModule = EventPluginRegistry.getPluginModuleForEvent(event);\n    if (PluginModule &amp;&amp; PluginModule.executeDispatch) {\n      executeDispatch = PluginModule.executeDispatch;\n    }\n    EventPluginUtils.executeDispatchesInOrder(event, executeDispatch);\n\n    if (!event.isPersistent()) {\n      event.constructor.release(event);\n    }\n  }\n};\n\n/**\n * - `InstanceHandle`: [required] Module that performs logical traversals of DOM\n *   hierarchy given ids of the logical DOM elements involved.\n */\nvar InstanceHandle = null;\n\nfunction validateInstanceHandle() {\n  var invalid = !InstanceHandle||\n    !InstanceHandle.traverseTwoPhase ||\n    !InstanceHandle.traverseEnterLeave;\n  if (invalid) {\n    throw new Error(&apos;InstanceHandle not injected before use!&apos;);\n  }\n}\n\n/**\n * This is a unified interface for event plugins to be installed and configured.\n *\n * Event plugins can implement the following properties:\n *\n *   `extractEvents` {function(string, DOMEventTarget, string, object): *}\n *     Required. When a top-level event is fired, this method is expected to\n *     extract synthetic events that will in turn be queued and dispatched.\n *\n *   `eventTypes` {object}\n *     Optional, plugins that fire events must publish a mapping of registration\n *     names that are used to register listeners. Values of this mapping must\n *     be objects that contain `registrationName` or `phasedRegistrationNames`.\n *\n *   `executeDispatch` {function(object, function, string)}\n *     Optional, allows plugins to override how an event gets dispatched. By\n *     default, the listener is simply invoked.\n *\n * Each plugin that is injected into `EventsPluginHub` is immediately operable.\n *\n * @public\n */\nvar EventPluginHub = {\n\n  /**\n   * Methods for injecting dependencies.\n   */\n  injection: {\n\n    /**\n     * @param {object} InjectedMount\n     * @public\n     */\n    injectMount: EventPluginUtils.injection.injectMount,\n\n    /**\n     * @param {object} InjectedInstanceHandle\n     * @public\n     */\n    injectInstanceHandle: function(InjectedInstanceHandle) {\n      InstanceHandle = InjectedInstanceHandle;\n      if (&quot;production&quot; !== &quot;development&quot;) {\n        validateInstanceHandle();\n      }\n    },\n\n    getInstanceHandle: function() {\n      if (&quot;production&quot; !== &quot;development&quot;) {\n        validateInstanceHandle();\n      }\n      return InstanceHandle;\n    },\n\n    /**\n     * @param {array} InjectedEventPluginOrder\n     * @public\n     */\n    injectEventPluginOrder: EventPluginRegistry.injectEventPluginOrder,\n\n    /**\n     * @param {object} injectedNamesToPlugins Map from names to plugin modules.\n     */\n    injectEventPluginsByName: EventPluginRegistry.injectEventPluginsByName\n\n  },\n\n  eventNameDispatchConfigs: EventPluginRegistry.eventNameDispatchConfigs,\n\n  registrationNameModules: EventPluginRegistry.registrationNameModules,\n\n  /**\n   * Stores `listener` at `listenerBank[registrationName][id]`. Is idempotent.\n   *\n   * @param {string} id ID of the DOM element.\n   * @param {string} registrationName Name of listener (e.g. `onClick`).\n   * @param {?function} listener The callback to store.\n   */\n  putListener: function(id, registrationName, listener) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      ExecutionEnvironment.canUseDOM,\n      &apos;Cannot call putListener() in a non-DOM environment.&apos;\n    ) : invariant(ExecutionEnvironment.canUseDOM));\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      !listener || typeof listener === &apos;function&apos;,\n      &apos;Expected %s listener to be a function, instead got type %s&apos;,\n      registrationName, typeof listener\n    ) : invariant(!listener || typeof listener === &apos;function&apos;));\n\n    if (&quot;production&quot; !== &quot;development&quot;) {\n      // IE8 has no API for event capturing and the `onScroll` event doesn&apos;t\n      // bubble.\n      if (registrationName === &apos;onScroll&apos; &amp;&amp;\n          !isEventSupported(&apos;scroll&apos;, true)) {\n        console.warn(&apos;This browser doesn\\&apos;t support the `onScroll` event&apos;);\n      }\n    }\n    var bankForRegistrationName =\n      listenerBank[registrationName] || (listenerBank[registrationName] = {});\n    bankForRegistrationName[id] = listener;\n  },\n\n  /**\n   * @param {string} id ID of the DOM element.\n   * @param {string} registrationName Name of listener (e.g. `onClick`).\n   * @return {?function} The stored callback.\n   */\n  getListener: function(id, registrationName) {\n    var bankForRegistrationName = listenerBank[registrationName];\n    return bankForRegistrationName &amp;&amp; bankForRegistrationName[id];\n  },\n\n  /**\n   * Deletes a listener from the registration bank.\n   *\n   * @param {string} id ID of the DOM element.\n   * @param {string} registrationName Name of listener (e.g. `onClick`).\n   */\n  deleteListener: function(id, registrationName) {\n    var bankForRegistrationName = listenerBank[registrationName];\n    if (bankForRegistrationName) {\n      delete bankForRegistrationName[id];\n    }\n  },\n\n  /**\n   * Deletes all listeners for the DOM element with the supplied ID.\n   *\n   * @param {string} id ID of the DOM element.\n   */\n  deleteAllListeners: function(id) {\n    for (var registrationName in listenerBank) {\n      delete listenerBank[registrationName][id];\n    }\n  },\n\n  /**\n   * Allows registered plugins an opportunity to extract events from top-level\n   * native browser events.\n   *\n   * @param {string} topLevelType Record from `EventConstants`.\n   * @param {DOMEventTarget} topLevelTarget The listening component root node.\n   * @param {string} topLevelTargetID ID of `topLevelTarget`.\n   * @param {object} nativeEvent Native browser event.\n   * @return {*} An accumulation of synthetic events.\n   * @internal\n   */\n  extractEvents: function(\n      topLevelType,\n      topLevelTarget,\n      topLevelTargetID,\n      nativeEvent) {\n    var events;\n    var plugins = EventPluginRegistry.plugins;\n    for (var i = 0, l = plugins.length; i &lt; l; i++) {\n      // Not every plugin in the ordering may be loaded at runtime.\n      var possiblePlugin = plugins[i];\n      if (possiblePlugin) {\n        var extractedEvents = possiblePlugin.extractEvents(\n          topLevelType,\n          topLevelTarget,\n          topLevelTargetID,\n          nativeEvent\n        );\n        if (extractedEvents) {\n          events = accumulate(events, extractedEvents);\n        }\n      }\n    }\n    return events;\n  },\n\n  /**\n   * Enqueues a synthetic event that should be dispatched when\n   * `processEventQueue` is invoked.\n   *\n   * @param {*} events An accumulation of synthetic events.\n   * @internal\n   */\n  enqueueEvents: function(events) {\n    if (events) {\n      eventQueue = accumulate(eventQueue, events);\n    }\n  },\n\n  /**\n   * Dispatches all synthetic events on the event queue.\n   *\n   * @internal\n   */\n  processEventQueue: function() {\n    // Set `eventQueue` to null before processing it so that we can tell if more\n    // events get enqueued while processing.\n    var processingEventQueue = eventQueue;\n    eventQueue = null;\n    forEachAccumulated(processingEventQueue, executeDispatchesAndRelease);\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      !eventQueue,\n      &apos;processEventQueue(): Additional events were enqueued while processing &apos; +\n      &apos;an event queue. Support for this has not yet been implemented.&apos;\n    ) : invariant(!eventQueue));\n  },\n\n  /**\n   * These are needed for tests only. Do not use!\n   */\n  __purge: function() {\n    listenerBank = {};\n  },\n\n  __getListenerBank: function() {\n    return listenerBank;\n  }\n\n};\n\nmodule.exports = EventPluginHub;\n\n},{&quot;./EventPluginRegistry&quot;:17,&quot;./EventPluginUtils&quot;:18,&quot;./ExecutionEnvironment&quot;:20,&quot;./accumulate&quot;:86,&quot;./forEachAccumulated&quot;:98,&quot;./invariant&quot;:108,&quot;./isEventSupported&quot;:109}],17:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule EventPluginRegistry\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar invariant = require(&quot;./invariant&quot;);\n\n/**\n * Injectable ordering of event plugins.\n */\nvar EventPluginOrder = null;\n\n/**\n * Injectable mapping from names to event plugin modules.\n */\nvar namesToPlugins = {};\n\n/**\n * Recomputes the plugin list using the injected plugins and plugin ordering.\n *\n * @private\n */\nfunction recomputePluginOrdering() {\n  if (!EventPluginOrder) {\n    // Wait until an `EventPluginOrder` is injected.\n    return;\n  }\n  for (var pluginName in namesToPlugins) {\n    var PluginModule = namesToPlugins[pluginName];\n    var pluginIndex = EventPluginOrder.indexOf(pluginName);\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      pluginIndex &gt; -1,\n      &apos;EventPluginRegistry: Cannot inject event plugins that do not exist in &apos; +\n      &apos;the plugin ordering, `%s`.&apos;,\n      pluginName\n    ) : invariant(pluginIndex &gt; -1));\n    if (EventPluginRegistry.plugins[pluginIndex]) {\n      continue;\n    }\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      PluginModule.extractEvents,\n      &apos;EventPluginRegistry: Event plugins must implement an `extractEvents` &apos; +\n      &apos;method, but `%s` does not.&apos;,\n      pluginName\n    ) : invariant(PluginModule.extractEvents));\n    EventPluginRegistry.plugins[pluginIndex] = PluginModule;\n    var publishedEvents = PluginModule.eventTypes;\n    for (var eventName in publishedEvents) {\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        publishEventForPlugin(\n          publishedEvents[eventName],\n          PluginModule,\n          eventName\n        ),\n        &apos;EventPluginRegistry: Failed to publish event `%s` for plugin `%s`.&apos;,\n        eventName,\n        pluginName\n      ) : invariant(publishEventForPlugin(\n        publishedEvents[eventName],\n        PluginModule,\n        eventName\n      )));\n    }\n  }\n}\n\n/**\n * Publishes an event so that it can be dispatched by the supplied plugin.\n *\n * @param {object} dispatchConfig Dispatch configuration for the event.\n * @param {object} PluginModule Plugin publishing the event.\n * @return {boolean} True if the event was successfully published.\n * @private\n */\nfunction publishEventForPlugin(dispatchConfig, PluginModule, eventName) {\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    !EventPluginRegistry.eventNameDispatchConfigs[eventName],\n    &apos;EventPluginHub: More than one plugin attempted to publish the same &apos; +\n    &apos;event name, `%s`.&apos;,\n    eventName\n  ) : invariant(!EventPluginRegistry.eventNameDispatchConfigs[eventName]));\n  EventPluginRegistry.eventNameDispatchConfigs[eventName] = dispatchConfig;\n\n  var phasedRegistrationNames = dispatchConfig.phasedRegistrationNames;\n  if (phasedRegistrationNames) {\n    for (var phaseName in phasedRegistrationNames) {\n      if (phasedRegistrationNames.hasOwnProperty(phaseName)) {\n        var phasedRegistrationName = phasedRegistrationNames[phaseName];\n        publishRegistrationName(\n          phasedRegistrationName,\n          PluginModule,\n          eventName\n        );\n      }\n    }\n    return true;\n  } else if (dispatchConfig.registrationName) {\n    publishRegistrationName(\n      dispatchConfig.registrationName,\n      PluginModule,\n      eventName\n    );\n    return true;\n  }\n  return false;\n}\n\n/**\n * Publishes a registration name that is used to identify dispatched events and\n * can be used with `EventPluginHub.putListener` to register listeners.\n *\n * @param {string} registrationName Registration name to add.\n * @param {object} PluginModule Plugin publishing the event.\n * @private\n */\nfunction publishRegistrationName(registrationName, PluginModule, eventName) {\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    !EventPluginRegistry.registrationNameModules[registrationName],\n    &apos;EventPluginHub: More than one plugin attempted to publish the same &apos; +\n    &apos;registration name, `%s`.&apos;,\n    registrationName\n  ) : invariant(!EventPluginRegistry.registrationNameModules[registrationName]));\n  EventPluginRegistry.registrationNameModules[registrationName] = PluginModule;\n  EventPluginRegistry.registrationNameDependencies[registrationName] =\n    PluginModule.eventTypes[eventName].dependencies;\n}\n\n/**\n * Registers plugins so that they can extract and dispatch events.\n *\n * @see {EventPluginHub}\n */\nvar EventPluginRegistry = {\n\n  /**\n   * Ordered list of injected plugins.\n   */\n  plugins: [],\n\n  /**\n   * Mapping from event name to dispatch config\n   */\n  eventNameDispatchConfigs: {},\n\n  /**\n   * Mapping from registration name to plugin module\n   */\n  registrationNameModules: {},\n\n  /**\n   * Mapping from registration name to event name\n   */\n  registrationNameDependencies: {},\n\n  /**\n   * Injects an ordering of plugins (by plugin name). This allows the ordering\n   * to be decoupled from injection of the actual plugins so that ordering is\n   * always deterministic regardless of packaging, on-the-fly injection, etc.\n   *\n   * @param {array} InjectedEventPluginOrder\n   * @internal\n   * @see {EventPluginHub.injection.injectEventPluginOrder}\n   */\n  injectEventPluginOrder: function(InjectedEventPluginOrder) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      !EventPluginOrder,\n      &apos;EventPluginRegistry: Cannot inject event plugin ordering more than once.&apos;\n    ) : invariant(!EventPluginOrder));\n    // Clone the ordering so it cannot be dynamically mutated.\n    EventPluginOrder = Array.prototype.slice.call(InjectedEventPluginOrder);\n    recomputePluginOrdering();\n  },\n\n  /**\n   * Injects plugins to be used by `EventPluginHub`. The plugin names must be\n   * in the ordering injected by `injectEventPluginOrder`.\n   *\n   * Plugins can be injected as part of page initialization or on-the-fly.\n   *\n   * @param {object} injectedNamesToPlugins Map from names to plugin modules.\n   * @internal\n   * @see {EventPluginHub.injection.injectEventPluginsByName}\n   */\n  injectEventPluginsByName: function(injectedNamesToPlugins) {\n    var isOrderingDirty = false;\n    for (var pluginName in injectedNamesToPlugins) {\n      if (!injectedNamesToPlugins.hasOwnProperty(pluginName)) {\n        continue;\n      }\n      var PluginModule = injectedNamesToPlugins[pluginName];\n      if (namesToPlugins[pluginName] !== PluginModule) {\n        (&quot;production&quot; !== &quot;development&quot; ? invariant(\n          !namesToPlugins[pluginName],\n          &apos;EventPluginRegistry: Cannot inject two different event plugins &apos; +\n          &apos;using the same name, `%s`.&apos;,\n          pluginName\n        ) : invariant(!namesToPlugins[pluginName]));\n        namesToPlugins[pluginName] = PluginModule;\n        isOrderingDirty = true;\n      }\n    }\n    if (isOrderingDirty) {\n      recomputePluginOrdering();\n    }\n  },\n\n  /**\n   * Looks up the plugin for the supplied event.\n   *\n   * @param {object} event A synthetic event.\n   * @return {?object} The plugin that created the supplied event.\n   * @internal\n   */\n  getPluginModuleForEvent: function(event) {\n    var dispatchConfig = event.dispatchConfig;\n    if (dispatchConfig.registrationName) {\n      return EventPluginRegistry.registrationNameModules[\n        dispatchConfig.registrationName\n      ] || null;\n    }\n    for (var phase in dispatchConfig.phasedRegistrationNames) {\n      if (!dispatchConfig.phasedRegistrationNames.hasOwnProperty(phase)) {\n        continue;\n      }\n      var PluginModule = EventPluginRegistry.registrationNameModules[\n        dispatchConfig.phasedRegistrationNames[phase]\n      ];\n      if (PluginModule) {\n        return PluginModule;\n      }\n    }\n    return null;\n  },\n\n  /**\n   * Exposed for unit testing.\n   * @private\n   */\n  _resetEventPlugins: function() {\n    EventPluginOrder = null;\n    for (var pluginName in namesToPlugins) {\n      if (namesToPlugins.hasOwnProperty(pluginName)) {\n        delete namesToPlugins[pluginName];\n      }\n    }\n    EventPluginRegistry.plugins.length = 0;\n\n    var eventNameDispatchConfigs = EventPluginRegistry.eventNameDispatchConfigs;\n    for (var eventName in eventNameDispatchConfigs) {\n      if (eventNameDispatchConfigs.hasOwnProperty(eventName)) {\n        delete eventNameDispatchConfigs[eventName];\n      }\n    }\n\n    var registrationNameModules = EventPluginRegistry.registrationNameModules;\n    for (var registrationName in registrationNameModules) {\n      if (registrationNameModules.hasOwnProperty(registrationName)) {\n        delete registrationNameModules[registrationName];\n      }\n    }\n  }\n\n};\n\nmodule.exports = EventPluginRegistry;\n\n},{&quot;./invariant&quot;:108}],18:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule EventPluginUtils\n */\n\n&quot;use strict&quot;;\n\nvar EventConstants = require(&quot;./EventConstants&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\n\n/**\n * Injected dependencies:\n */\n\n/**\n * - `Mount`: [required] Module that can convert between React dom IDs and\n *   actual node references.\n */\nvar injection = {\n  Mount: null,\n  injectMount: function(InjectedMount) {\n    injection.Mount = InjectedMount;\n    if (&quot;production&quot; !== &quot;development&quot;) {\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        InjectedMount &amp;&amp; InjectedMount.getNode,\n        &apos;EventPluginUtils.injection.injectMount(...): Injected Mount module &apos; +\n        &apos;is missing getNode.&apos;\n      ) : invariant(InjectedMount &amp;&amp; InjectedMount.getNode));\n    }\n  }\n};\n\nvar topLevelTypes = EventConstants.topLevelTypes;\n\nfunction isEndish(topLevelType) {\n  return topLevelType === topLevelTypes.topMouseUp ||\n         topLevelType === topLevelTypes.topTouchEnd ||\n         topLevelType === topLevelTypes.topTouchCancel;\n}\n\nfunction isMoveish(topLevelType) {\n  return topLevelType === topLevelTypes.topMouseMove ||\n         topLevelType === topLevelTypes.topTouchMove;\n}\nfunction isStartish(topLevelType) {\n  return topLevelType === topLevelTypes.topMouseDown ||\n         topLevelType === topLevelTypes.topTouchStart;\n}\n\n\nvar validateEventDispatches;\nif (&quot;production&quot; !== &quot;development&quot;) {\n  validateEventDispatches = function(event) {\n    var dispatchListeners = event._dispatchListeners;\n    var dispatchIDs = event._dispatchIDs;\n\n    var listenersIsArr = Array.isArray(dispatchListeners);\n    var idsIsArr = Array.isArray(dispatchIDs);\n    var IDsLen = idsIsArr ? dispatchIDs.length : dispatchIDs ? 1 : 0;\n    var listenersLen = listenersIsArr ?\n      dispatchListeners.length :\n      dispatchListeners ? 1 : 0;\n\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      idsIsArr === listenersIsArr &amp;&amp; IDsLen === listenersLen,\n      &apos;EventPluginUtils: Invalid `event`.&apos;\n    ) : invariant(idsIsArr === listenersIsArr &amp;&amp; IDsLen === listenersLen));\n  };\n}\n\n/**\n * Invokes `cb(event, listener, id)`. Avoids using call if no scope is\n * provided. The `(listener,id)` pair effectively forms the &quot;dispatch&quot; but are\n * kept separate to conserve memory.\n */\nfunction forEachEventDispatch(event, cb) {\n  var dispatchListeners = event._dispatchListeners;\n  var dispatchIDs = event._dispatchIDs;\n  if (&quot;production&quot; !== &quot;development&quot;) {\n    validateEventDispatches(event);\n  }\n  if (Array.isArray(dispatchListeners)) {\n    for (var i = 0; i &lt; dispatchListeners.length; i++) {\n      if (event.isPropagationStopped()) {\n        break;\n      }\n      // Listeners and IDs are two parallel arrays that are always in sync.\n      cb(event, dispatchListeners[i], dispatchIDs[i]);\n    }\n  } else if (dispatchListeners) {\n    cb(event, dispatchListeners, dispatchIDs);\n  }\n}\n\n/**\n * Default implementation of PluginModule.executeDispatch().\n * @param {SyntheticEvent} SyntheticEvent to handle\n * @param {function} Application-level callback\n * @param {string} domID DOM id to pass to the callback.\n */\nfunction executeDispatch(event, listener, domID) {\n  event.currentTarget = injection.Mount.getNode(domID);\n  var returnValue = listener(event, domID);\n  event.currentTarget = null;\n  return returnValue;\n}\n\n/**\n * Standard/simple iteration through an event&apos;s collected dispatches.\n */\nfunction executeDispatchesInOrder(event, executeDispatch) {\n  forEachEventDispatch(event, executeDispatch);\n  event._dispatchListeners = null;\n  event._dispatchIDs = null;\n}\n\n/**\n * Standard/simple iteration through an event&apos;s collected dispatches, but stops\n * at the first dispatch execution returning true, and returns that id.\n *\n * @return id of the first dispatch execution who&apos;s listener returns true, or\n * null if no listener returned true.\n */\nfunction executeDispatchesInOrderStopAtTrue(event) {\n  var dispatchListeners = event._dispatchListeners;\n  var dispatchIDs = event._dispatchIDs;\n  if (&quot;production&quot; !== &quot;development&quot;) {\n    validateEventDispatches(event);\n  }\n  if (Array.isArray(dispatchListeners)) {\n    for (var i = 0; i &lt; dispatchListeners.length; i++) {\n      if (event.isPropagationStopped()) {\n        break;\n      }\n      // Listeners and IDs are two parallel arrays that are always in sync.\n      if (dispatchListeners[i](event, dispatchIDs[i])) {\n        return dispatchIDs[i];\n      }\n    }\n  } else if (dispatchListeners) {\n    if (dispatchListeners(event, dispatchIDs)) {\n      return dispatchIDs;\n    }\n  }\n  return null;\n}\n\n/**\n * Execution of a &quot;direct&quot; dispatch - there must be at most one dispatch\n * accumulated on the event or it is considered an error. It doesn&apos;t really make\n * sense for an event with multiple dispatches (bubbled) to keep track of the\n * return values at each dispatch execution, but it does tend to make sense when\n * dealing with &quot;direct&quot; dispatches.\n *\n * @return The return value of executing the single dispatch.\n */\nfunction executeDirectDispatch(event) {\n  if (&quot;production&quot; !== &quot;development&quot;) {\n    validateEventDispatches(event);\n  }\n  var dispatchListener = event._dispatchListeners;\n  var dispatchID = event._dispatchIDs;\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    !Array.isArray(dispatchListener),\n    &apos;executeDirectDispatch(...): Invalid `event`.&apos;\n  ) : invariant(!Array.isArray(dispatchListener)));\n  var res = dispatchListener ?\n    dispatchListener(event, dispatchID) :\n    null;\n  event._dispatchListeners = null;\n  event._dispatchIDs = null;\n  return res;\n}\n\n/**\n * @param {SyntheticEvent} event\n * @return {bool} True iff number of dispatches accumulated is greater than 0.\n */\nfunction hasDispatches(event) {\n  return !!event._dispatchListeners;\n}\n\n/**\n * General utilities that are useful in creating custom Event Plugins.\n */\nvar EventPluginUtils = {\n  isEndish: isEndish,\n  isMoveish: isMoveish,\n  isStartish: isStartish,\n\n  executeDirectDispatch: executeDirectDispatch,\n  executeDispatch: executeDispatch,\n  executeDispatchesInOrder: executeDispatchesInOrder,\n  executeDispatchesInOrderStopAtTrue: executeDispatchesInOrderStopAtTrue,\n  hasDispatches: hasDispatches,\n  injection: injection,\n  useTouchEvents: false\n};\n\nmodule.exports = EventPluginUtils;\n\n},{&quot;./EventConstants&quot;:14,&quot;./invariant&quot;:108}],19:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule EventPropagators\n */\n\n&quot;use strict&quot;;\n\nvar EventConstants = require(&quot;./EventConstants&quot;);\nvar EventPluginHub = require(&quot;./EventPluginHub&quot;);\n\nvar accumulate = require(&quot;./accumulate&quot;);\nvar forEachAccumulated = require(&quot;./forEachAccumulated&quot;);\n\nvar PropagationPhases = EventConstants.PropagationPhases;\nvar getListener = EventPluginHub.getListener;\n\n/**\n * Some event types have a notion of different registration names for different\n * &quot;phases&quot; of propagation. This finds listeners by a given phase.\n */\nfunction listenerAtPhase(id, event, propagationPhase) {\n  var registrationName =\n    event.dispatchConfig.phasedRegistrationNames[propagationPhase];\n  return getListener(id, registrationName);\n}\n\n/**\n * Tags a `SyntheticEvent` with dispatched listeners. Creating this function\n * here, allows us to not have to bind or create functions for each event.\n * Mutating the event&apos;s members allows us to not have to create a wrapping\n * &quot;dispatch&quot; object that pairs the event with the listener.\n */\nfunction accumulateDirectionalDispatches(domID, upwards, event) {\n  if (&quot;production&quot; !== &quot;development&quot;) {\n    if (!domID) {\n      throw new Error(&apos;Dispatching id must not be null&apos;);\n    }\n  }\n  var phase = upwards ? PropagationPhases.bubbled : PropagationPhases.captured;\n  var listener = listenerAtPhase(domID, event, phase);\n  if (listener) {\n    event._dispatchListeners = accumulate(event._dispatchListeners, listener);\n    event._dispatchIDs = accumulate(event._dispatchIDs, domID);\n  }\n}\n\n/**\n * Collect dispatches (must be entirely collected before dispatching - see unit\n * tests). Lazily allocate the array to conserve memory.  We must loop through\n * each event and perform the traversal for each one. We can not perform a\n * single traversal for the entire collection of events because each event may\n * have a different target.\n */\nfunction accumulateTwoPhaseDispatchesSingle(event) {\n  if (event &amp;&amp; event.dispatchConfig.phasedRegistrationNames) {\n    EventPluginHub.injection.getInstanceHandle().traverseTwoPhase(\n      event.dispatchMarker,\n      accumulateDirectionalDispatches,\n      event\n    );\n  }\n}\n\n\n/**\n * Accumulates without regard to direction, does not look for phased\n * registration names. Same as `accumulateDirectDispatchesSingle` but without\n * requiring that the `dispatchMarker` be the same as the dispatched ID.\n */\nfunction accumulateDispatches(id, ignoredDirection, event) {\n  if (event &amp;&amp; event.dispatchConfig.registrationName) {\n    var registrationName = event.dispatchConfig.registrationName;\n    var listener = getListener(id, registrationName);\n    if (listener) {\n      event._dispatchListeners = accumulate(event._dispatchListeners, listener);\n      event._dispatchIDs = accumulate(event._dispatchIDs, id);\n    }\n  }\n}\n\n/**\n * Accumulates dispatches on an `SyntheticEvent`, but only for the\n * `dispatchMarker`.\n * @param {SyntheticEvent} event\n */\nfunction accumulateDirectDispatchesSingle(event) {\n  if (event &amp;&amp; event.dispatchConfig.registrationName) {\n    accumulateDispatches(event.dispatchMarker, null, event);\n  }\n}\n\nfunction accumulateTwoPhaseDispatches(events) {\n  forEachAccumulated(events, accumulateTwoPhaseDispatchesSingle);\n}\n\nfunction accumulateEnterLeaveDispatches(leave, enter, fromID, toID) {\n  EventPluginHub.injection.getInstanceHandle().traverseEnterLeave(\n    fromID,\n    toID,\n    accumulateDispatches,\n    leave,\n    enter\n  );\n}\n\n\nfunction accumulateDirectDispatches(events) {\n  forEachAccumulated(events, accumulateDirectDispatchesSingle);\n}\n\n\n\n/**\n * A small set of propagation patterns, each of which will accept a small amount\n * of information, and generate a set of &quot;dispatch ready event objects&quot; - which\n * are sets of events that have already been annotated with a set of dispatched\n * listener functions/ids. The API is designed this way to discourage these\n * propagation strategies from actually executing the dispatches, since we\n * always want to collect the entire set of dispatches before executing event a\n * single one.\n *\n * @constructor EventPropagators\n */\nvar EventPropagators = {\n  accumulateTwoPhaseDispatches: accumulateTwoPhaseDispatches,\n  accumulateDirectDispatches: accumulateDirectDispatches,\n  accumulateEnterLeaveDispatches: accumulateEnterLeaveDispatches\n};\n\nmodule.exports = EventPropagators;\n\n},{&quot;./EventConstants&quot;:14,&quot;./EventPluginHub&quot;:16,&quot;./accumulate&quot;:86,&quot;./forEachAccumulated&quot;:98}],20:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ExecutionEnvironment\n */\n\n/*jslint evil: true */\n\n&quot;use strict&quot;;\n\nvar canUseDOM = typeof window !== &apos;undefined&apos;;\n\n/**\n * Simple, lightweight module assisting with the detection and context of\n * Worker. Helps avoid circular dependencies and allows code to reason about\n * whether or not they are in a Worker, even if they never include the main\n * `ReactWorker` dependency.\n */\nvar ExecutionEnvironment = {\n\n  canUseDOM: canUseDOM,\n\n  canUseWorkers: typeof Worker !== &apos;undefined&apos;,\n\n  canUseEventListeners:\n    canUseDOM &amp;&amp; (window.addEventListener || window.attachEvent),\n\n  isInWorker: !canUseDOM // For now, this is true - might change in the future.\n\n};\n\nmodule.exports = ExecutionEnvironment;\n\n},{}],21:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule LinkedValueUtils\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar ReactPropTypes = require(&quot;./ReactPropTypes&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\n\nvar hasReadOnlyValue = {\n  &apos;button&apos;: true,\n  &apos;checkbox&apos;: true,\n  &apos;image&apos;: true,\n  &apos;hidden&apos;: true,\n  &apos;radio&apos;: true,\n  &apos;reset&apos;: true,\n  &apos;submit&apos;: true\n};\n\nfunction _assertSingleLink(input) {\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      input.props.checkedLink == null || input.props.valueLink == null,\n      &apos;Cannot provide a checkedLink and a valueLink. If you want to use &apos; +\n      &apos;checkedLink, you probably don\\&apos;t want to use valueLink and vice versa.&apos;\n  ) : invariant(input.props.checkedLink == null || input.props.valueLink == null));\n}\nfunction _assertValueLink(input) {\n  _assertSingleLink(input);\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    input.props.value == null &amp;&amp; input.props.onChange == null,\n    &apos;Cannot provide a valueLink and a value or onChange event. If you want &apos; +\n    &apos;to use value or onChange, you probably don\\&apos;t want to use valueLink.&apos;\n  ) : invariant(input.props.value == null &amp;&amp; input.props.onChange == null));\n}\n\nfunction _assertCheckedLink(input) {\n  _assertSingleLink(input);\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    input.props.checked == null &amp;&amp; input.props.onChange == null,\n    &apos;Cannot provide a checkedLink and a checked property or onChange event. &apos; +\n    &apos;If you want to use checked or onChange, you probably don\\&apos;t want to &apos; +\n    &apos;use checkedLink&apos;\n  ) : invariant(input.props.checked == null &amp;&amp; input.props.onChange == null));\n}\n\n/**\n * @param {SyntheticEvent} e change event to handle\n */\nfunction _handleLinkedValueChange(e) {\n  /*jshint validthis:true */\n  this.props.valueLink.requestChange(e.target.value);\n}\n\n/**\n  * @param {SyntheticEvent} e change event to handle\n  */\nfunction _handleLinkedCheckChange(e) {\n  /*jshint validthis:true */\n  this.props.checkedLink.requestChange(e.target.checked);\n}\n\n/**\n * Provide a linked `value` attribute for controlled forms. You should not use\n * this outside of the ReactDOM controlled form components.\n */\nvar LinkedValueUtils = {\n  Mixin: {\n    propTypes: {\n      value: function(props, propName, componentName) {\n        if (&quot;production&quot; !== &quot;development&quot;) {\n          if (props[propName] &amp;&amp;\n              !hasReadOnlyValue[props.type] &amp;&amp;\n              !props.onChange &amp;&amp;\n              !props.readOnly &amp;&amp;\n              !props.disabled) {\n            console.warn(\n              &apos;You provided a `value` prop to a form field without an &apos; +\n              &apos;`onChange` handler. This will render a read-only field. If &apos; +\n              &apos;the field should be mutable use `defaultValue`. Otherwise, &apos; +\n              &apos;set either `onChange` or `readOnly`.&apos;\n            );\n          }\n        }\n      },\n      checked: function(props, propName, componentName) {\n        if (&quot;production&quot; !== &quot;development&quot;) {\n          if (props[propName] &amp;&amp;\n              !props.onChange &amp;&amp;\n              !props.readOnly &amp;&amp;\n              !props.disabled) {\n            console.warn(\n              &apos;You provided a `checked` prop to a form field without an &apos; +\n              &apos;`onChange` handler. This will render a read-only field. If &apos; +\n              &apos;the field should be mutable use `defaultChecked`. Otherwise, &apos; +\n              &apos;set either `onChange` or `readOnly`.&apos;\n            );\n          }\n        }\n      },\n      onChange: ReactPropTypes.func\n    }\n  },\n\n  /**\n   * @param {ReactComponent} input Form component\n   * @return {*} current value of the input either from value prop or link.\n   */\n  getValue: function(input) {\n    if (input.props.valueLink) {\n      _assertValueLink(input);\n      return input.props.valueLink.value;\n    }\n    return input.props.value;\n  },\n\n  /**\n   * @param {ReactComponent} input Form component\n   * @return {*} current checked status of the input either from checked prop\n   *             or link.\n   */\n  getChecked: function(input) {\n    if (input.props.checkedLink) {\n      _assertCheckedLink(input);\n      return input.props.checkedLink.value;\n    }\n    return input.props.checked;\n  },\n\n  /**\n   * @param {ReactComponent} input Form component\n   * @return {function} change callback either from onChange prop or link.\n   */\n  getOnChange: function(input) {\n    if (input.props.valueLink) {\n      _assertValueLink(input);\n      return _handleLinkedValueChange;\n    } else if (input.props.checkedLink) {\n      _assertCheckedLink(input);\n      return _handleLinkedCheckChange;\n    }\n    return input.props.onChange;\n  }\n};\n\nmodule.exports = LinkedValueUtils;\n\n},{&quot;./ReactPropTypes&quot;:64,&quot;./invariant&quot;:108}],22:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule MobileSafariClickEventPlugin\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar EventConstants = require(&quot;./EventConstants&quot;);\n\nvar emptyFunction = require(&quot;./emptyFunction&quot;);\n\nvar topLevelTypes = EventConstants.topLevelTypes;\n\n/**\n * Mobile Safari does not fire properly bubble click events on non-interactive\n * elements, which means delegated click listeners do not fire. The workaround\n * for this bug involves attaching an empty click listener on the target node.\n *\n * This particular plugin works around the bug by attaching an empty click\n * listener on `touchstart` (which does fire on every element).\n */\nvar MobileSafariClickEventPlugin = {\n\n  eventTypes: null,\n\n  /**\n   * @param {string} topLevelType Record from `EventConstants`.\n   * @param {DOMEventTarget} topLevelTarget The listening component root node.\n   * @param {string} topLevelTargetID ID of `topLevelTarget`.\n   * @param {object} nativeEvent Native browser event.\n   * @return {*} An accumulation of synthetic events.\n   * @see {EventPluginHub.extractEvents}\n   */\n  extractEvents: function(\n      topLevelType,\n      topLevelTarget,\n      topLevelTargetID,\n      nativeEvent) {\n    if (topLevelType === topLevelTypes.topTouchStart) {\n      var target = nativeEvent.target;\n      if (target &amp;&amp; !target.onclick) {\n        target.onclick = emptyFunction;\n      }\n    }\n  }\n\n};\n\nmodule.exports = MobileSafariClickEventPlugin;\n\n},{&quot;./EventConstants&quot;:14,&quot;./emptyFunction&quot;:95}],23:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule PooledClass\n */\n\n&quot;use strict&quot;;\n\nvar invariant = require(&quot;./invariant&quot;);\n\n/**\n * Static poolers. Several custom versions for each potential number of\n * arguments. A completely generic pooler is easy to implement, but would\n * require accessing the `arguments` object. In each of these, `this` refers to\n * the Class itself, not an instance. If any others are needed, simply add them\n * here, or in their own files.\n */\nvar oneArgumentPooler = function(copyFieldsFrom) {\n  var Klass = this;\n  if (Klass.instancePool.length) {\n    var instance = Klass.instancePool.pop();\n    Klass.call(instance, copyFieldsFrom);\n    return instance;\n  } else {\n    return new Klass(copyFieldsFrom);\n  }\n};\n\nvar twoArgumentPooler = function(a1, a2) {\n  var Klass = this;\n  if (Klass.instancePool.length) {\n    var instance = Klass.instancePool.pop();\n    Klass.call(instance, a1, a2);\n    return instance;\n  } else {\n    return new Klass(a1, a2);\n  }\n};\n\nvar threeArgumentPooler = function(a1, a2, a3) {\n  var Klass = this;\n  if (Klass.instancePool.length) {\n    var instance = Klass.instancePool.pop();\n    Klass.call(instance, a1, a2, a3);\n    return instance;\n  } else {\n    return new Klass(a1, a2, a3);\n  }\n};\n\nvar fiveArgumentPooler = function(a1, a2, a3, a4, a5) {\n  var Klass = this;\n  if (Klass.instancePool.length) {\n    var instance = Klass.instancePool.pop();\n    Klass.call(instance, a1, a2, a3, a4, a5);\n    return instance;\n  } else {\n    return new Klass(a1, a2, a3, a4, a5);\n  }\n};\n\nvar standardReleaser = function(instance) {\n  var Klass = this;\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    instance instanceof Klass,\n    &apos;Trying to release an instance into a pool of a different type.&apos;\n  ) : invariant(instance instanceof Klass));\n  if (instance.destructor) {\n    instance.destructor();\n  }\n  if (Klass.instancePool.length &lt; Klass.poolSize) {\n    Klass.instancePool.push(instance);\n  }\n};\n\nvar DEFAULT_POOL_SIZE = 10;\nvar DEFAULT_POOLER = oneArgumentPooler;\n\n/**\n * Augments `CopyConstructor` to be a poolable class, augmenting only the class\n * itself (statically) not adding any prototypical fields. Any CopyConstructor\n * you give this may have a `poolSize` property, and will look for a\n * prototypical `destructor` on instances (optional).\n *\n * @param {Function} CopyConstructor Constructor that can be used to reset.\n * @param {Function} pooler Customizable pooler.\n */\nvar addPoolingTo = function(CopyConstructor, pooler) {\n  var NewKlass = CopyConstructor;\n  NewKlass.instancePool = [];\n  NewKlass.getPooled = pooler || DEFAULT_POOLER;\n  if (!NewKlass.poolSize) {\n    NewKlass.poolSize = DEFAULT_POOL_SIZE;\n  }\n  NewKlass.release = standardReleaser;\n  return NewKlass;\n};\n\nvar PooledClass = {\n  addPoolingTo: addPoolingTo,\n  oneArgumentPooler: oneArgumentPooler,\n  twoArgumentPooler: twoArgumentPooler,\n  threeArgumentPooler: threeArgumentPooler,\n  fiveArgumentPooler: fiveArgumentPooler\n};\n\nmodule.exports = PooledClass;\n\n},{&quot;./invariant&quot;:108}],24:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule React\n */\n\n&quot;use strict&quot;;\n\nvar DOMPropertyOperations = require(&quot;./DOMPropertyOperations&quot;);\nvar EventPluginUtils = require(&quot;./EventPluginUtils&quot;);\nvar ReactChildren = require(&quot;./ReactChildren&quot;);\nvar ReactComponent = require(&quot;./ReactComponent&quot;);\nvar ReactCompositeComponent = require(&quot;./ReactCompositeComponent&quot;);\nvar ReactContext = require(&quot;./ReactContext&quot;);\nvar ReactCurrentOwner = require(&quot;./ReactCurrentOwner&quot;);\nvar ReactDOM = require(&quot;./ReactDOM&quot;);\nvar ReactDOMComponent = require(&quot;./ReactDOMComponent&quot;);\nvar ReactDefaultInjection = require(&quot;./ReactDefaultInjection&quot;);\nvar ReactInstanceHandles = require(&quot;./ReactInstanceHandles&quot;);\nvar ReactMount = require(&quot;./ReactMount&quot;);\nvar ReactMultiChild = require(&quot;./ReactMultiChild&quot;);\nvar ReactPerf = require(&quot;./ReactPerf&quot;);\nvar ReactPropTypes = require(&quot;./ReactPropTypes&quot;);\nvar ReactServerRendering = require(&quot;./ReactServerRendering&quot;);\nvar ReactTextComponent = require(&quot;./ReactTextComponent&quot;);\n\nvar onlyChild = require(&quot;./onlyChild&quot;);\n\nReactDefaultInjection.inject();\n\nvar React = {\n  Children: {\n    map: ReactChildren.map,\n    forEach: ReactChildren.forEach,\n    only: onlyChild\n  },\n  DOM: ReactDOM,\n  PropTypes: ReactPropTypes,\n  initializeTouchEvents: function(shouldUseTouch) {\n    EventPluginUtils.useTouchEvents = shouldUseTouch;\n  },\n  createClass: ReactCompositeComponent.createClass,\n  constructAndRenderComponent: ReactMount.constructAndRenderComponent,\n  constructAndRenderComponentByID: ReactMount.constructAndRenderComponentByID,\n  renderComponent: ReactPerf.measure(\n    &apos;React&apos;,\n    &apos;renderComponent&apos;,\n    ReactMount.renderComponent\n  ),\n  renderComponentToString: ReactServerRendering.renderComponentToString,\n  unmountComponentAtNode: ReactMount.unmountComponentAtNode,\n  isValidClass: ReactCompositeComponent.isValidClass,\n  isValidComponent: ReactComponent.isValidComponent,\n  withContext: ReactContext.withContext,\n  __internals: {\n    Component: ReactComponent,\n    CurrentOwner: ReactCurrentOwner,\n    DOMComponent: ReactDOMComponent,\n    DOMPropertyOperations: DOMPropertyOperations,\n    InstanceHandles: ReactInstanceHandles,\n    Mount: ReactMount,\n    MultiChild: ReactMultiChild,\n    TextComponent: ReactTextComponent\n  }\n};\n\nif (&quot;production&quot; !== &quot;development&quot;) {\n  var ExecutionEnvironment = require(&quot;./ExecutionEnvironment&quot;);\n  if (ExecutionEnvironment.canUseDOM &amp;&amp;\n      window.top === window.self &amp;&amp;\n      navigator.userAgent.indexOf(&apos;Chrome&apos;) &gt; -1) {\n    console.debug(\n      &apos;Download the React DevTools for a better development experience: &apos; +\n      &apos;http://fb.me/react-devtools&apos;\n    );\n  }\n}\n\n// Version exists only in the open-source version of React, not in Facebook&apos;s\n// internal version.\nReact.version = &apos;0.9.0&apos;;\n\nmodule.exports = React;\n\n},{&quot;./DOMPropertyOperations&quot;:9,&quot;./EventPluginUtils&quot;:18,&quot;./ExecutionEnvironment&quot;:20,&quot;./ReactChildren&quot;:25,&quot;./ReactComponent&quot;:26,&quot;./ReactCompositeComponent&quot;:29,&quot;./ReactContext&quot;:30,&quot;./ReactCurrentOwner&quot;:31,&quot;./ReactDOM&quot;:32,&quot;./ReactDOMComponent&quot;:34,&quot;./ReactDefaultInjection&quot;:44,&quot;./ReactInstanceHandles&quot;:53,&quot;./ReactMount&quot;:55,&quot;./ReactMultiChild&quot;:57,&quot;./ReactPerf&quot;:60,&quot;./ReactPropTypes&quot;:64,&quot;./ReactServerRendering&quot;:68,&quot;./ReactTextComponent&quot;:69,&quot;./onlyChild&quot;:123}],25:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactChildren\n */\n\n&quot;use strict&quot;;\n\nvar PooledClass = require(&quot;./PooledClass&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\nvar traverseAllChildren = require(&quot;./traverseAllChildren&quot;);\n\nvar twoArgumentPooler = PooledClass.twoArgumentPooler;\nvar threeArgumentPooler = PooledClass.threeArgumentPooler;\n\n/**\n * PooledClass representing the bookkeeping associated with performing a child\n * traversal. Allows avoiding binding callbacks.\n *\n * @constructor ForEachBookKeeping\n * @param {!function} forEachFunction Function to perform traversal with.\n * @param {?*} forEachContext Context to perform context with.\n */\nfunction ForEachBookKeeping(forEachFunction, forEachContext) {\n  this.forEachFunction = forEachFunction;\n  this.forEachContext = forEachContext;\n}\nPooledClass.addPoolingTo(ForEachBookKeeping, twoArgumentPooler);\n\nfunction forEachSingleChild(traverseContext, child, name, i) {\n  var forEachBookKeeping = traverseContext;\n  forEachBookKeeping.forEachFunction.call(\n    forEachBookKeeping.forEachContext, child, i);\n}\n\n/**\n * Iterates through children that are typically specified as `props.children`.\n *\n * The provided forEachFunc(child, index) will be called for each\n * leaf child.\n *\n * @param {?*} children Children tree container.\n * @param {function(*, int)} forEachFunc.\n * @param {*} forEachContext Context for forEachContext.\n */\nfunction forEachChildren(children, forEachFunc, forEachContext) {\n  if (children == null) {\n    return children;\n  }\n\n  var traverseContext =\n    ForEachBookKeeping.getPooled(forEachFunc, forEachContext);\n  traverseAllChildren(children, forEachSingleChild, traverseContext);\n  ForEachBookKeeping.release(traverseContext);\n}\n\n/**\n * PooledClass representing the bookkeeping associated with performing a child\n * mapping. Allows avoiding binding callbacks.\n *\n * @constructor MapBookKeeping\n * @param {!*} mapResult Object containing the ordered map of results.\n * @param {!function} mapFunction Function to perform mapping with.\n * @param {?*} mapContext Context to perform mapping with.\n */\nfunction MapBookKeeping(mapResult, mapFunction, mapContext) {\n  this.mapResult = mapResult;\n  this.mapFunction = mapFunction;\n  this.mapContext = mapContext;\n}\nPooledClass.addPoolingTo(MapBookKeeping, threeArgumentPooler);\n\nfunction mapSingleChildIntoContext(traverseContext, child, name, i) {\n  var mapBookKeeping = traverseContext;\n  var mapResult = mapBookKeeping.mapResult;\n  var mappedChild =\n    mapBookKeeping.mapFunction.call(mapBookKeeping.mapContext, child, i);\n  // We found a component instance\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    !mapResult.hasOwnProperty(name),\n    &apos;ReactChildren.map(...): Encountered two children with the same key, &apos; +\n    &apos;`%s`. Children keys must be unique.&apos;,\n    name\n  ) : invariant(!mapResult.hasOwnProperty(name)));\n  mapResult[name] = mappedChild;\n}\n\n/**\n * Maps children that are typically specified as `props.children`.\n *\n * The provided mapFunction(child, key, index) will be called for each\n * leaf child.\n *\n * TODO: This may likely break any calls to `ReactChildren.map` that were\n * previously relying on the fact that we guarded against null children.\n *\n * @param {?*} children Children tree container.\n * @param {function(*, int)} mapFunction.\n * @param {*} mapContext Context for mapFunction.\n * @return {object} Object containing the ordered map of results.\n */\nfunction mapChildren(children, func, context) {\n  if (children == null) {\n    return children;\n  }\n\n  var mapResult = {};\n  var traverseContext = MapBookKeeping.getPooled(mapResult, func, context);\n  traverseAllChildren(children, mapSingleChildIntoContext, traverseContext);\n  MapBookKeeping.release(traverseContext);\n  return mapResult;\n}\n\nvar ReactChildren = {\n  forEach: forEachChildren,\n  map: mapChildren\n};\n\nmodule.exports = ReactChildren;\n\n},{&quot;./PooledClass&quot;:23,&quot;./invariant&quot;:108,&quot;./traverseAllChildren&quot;:128}],26:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactComponent\n */\n\n&quot;use strict&quot;;\n\nvar ReactComponentEnvironment = require(&quot;./ReactComponentEnvironment&quot;);\nvar ReactCurrentOwner = require(&quot;./ReactCurrentOwner&quot;);\nvar ReactOwner = require(&quot;./ReactOwner&quot;);\nvar ReactUpdates = require(&quot;./ReactUpdates&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\nvar keyMirror = require(&quot;./keyMirror&quot;);\nvar merge = require(&quot;./merge&quot;);\n\n/**\n * Every React component is in one of these life cycles.\n */\nvar ComponentLifeCycle = keyMirror({\n  /**\n   * Mounted components have a DOM node representation and are capable of\n   * receiving new props.\n   */\n  MOUNTED: null,\n  /**\n   * Unmounted components are inactive and cannot receive new props.\n   */\n  UNMOUNTED: null\n});\n\n/**\n * Warn if there&apos;s no key explicitly set on dynamic arrays of children or\n * object keys are not valid. This allows us to keep track of children between\n * updates.\n */\n\nvar ownerHasExplicitKeyWarning = {};\nvar ownerHasPropertyWarning = {};\n\nvar NUMERIC_PROPERTY_REGEX = /^\\d+$/;\n\n/**\n * Warn if the component doesn&apos;t have an explicit key assigned to it.\n * This component is in an array. The array could grow and shrink or be\n * reordered. All children that haven&apos;t already been validated are required to\n * have a &quot;key&quot; property assigned to it.\n *\n * @internal\n * @param {ReactComponent} component Component that requires a key.\n */\nfunction validateExplicitKey(component) {\n  if (component.__keyValidated__ || component.props.key != null) {\n    return;\n  }\n  component.__keyValidated__ = true;\n\n  // We can&apos;t provide friendly warnings for top level components.\n  if (!ReactCurrentOwner.current) {\n    return;\n  }\n\n  // Name of the component whose render method tried to pass children.\n  var currentName = ReactCurrentOwner.current.constructor.displayName;\n  if (ownerHasExplicitKeyWarning.hasOwnProperty(currentName)) {\n    return;\n  }\n  ownerHasExplicitKeyWarning[currentName] = true;\n\n  var message = &apos;Each child in an array should have a unique &quot;key&quot; prop. &apos; +\n                &apos;Check the render method of &apos; + currentName + &apos;.&apos;;\n  if (!component.isOwnedBy(ReactCurrentOwner.current)) {\n    // Name of the component that originally created this child.\n    var childOwnerName =\n      component._owner &amp;&amp;\n      component._owner.constructor.displayName;\n\n    // Usually the current owner is the offender, but if it accepts\n    // children as a property, it may be the creator of the child that&apos;s\n    // responsible for assigning it a key.\n    message += &apos; It was passed a child from &apos; + childOwnerName + &apos;.&apos;;\n  }\n\n  message += &apos; See http://fb.me/react-warning-keys for more information.&apos;;\n  console.warn(message);\n}\n\n/**\n * Warn if the key is being defined as an object property but has an incorrect\n * value.\n *\n * @internal\n * @param {string} name Property name of the key.\n * @param {ReactComponent} component Component that requires a key.\n */\nfunction validatePropertyKey(name) {\n  if (NUMERIC_PROPERTY_REGEX.test(name)) {\n    // Name of the component whose render method tried to pass children.\n    var currentName = ReactCurrentOwner.current.constructor.displayName;\n    if (ownerHasPropertyWarning.hasOwnProperty(currentName)) {\n      return;\n    }\n    ownerHasPropertyWarning[currentName] = true;\n\n    console.warn(\n      &apos;Child objects should have non-numeric keys so ordering is preserved. &apos; +\n      &apos;Check the render method of &apos; + currentName + &apos;. &apos; +\n      &apos;See http://fb.me/react-warning-keys for more information.&apos;\n    );\n  }\n}\n\n/**\n * Ensure that every component either is passed in a static location, in an\n * array with an explicit keys property defined, or in an object literal\n * with valid key property.\n *\n * @internal\n * @param {*} component Statically passed child of any type.\n * @return {boolean}\n */\nfunction validateChildKeys(component) {\n  if (Array.isArray(component)) {\n    for (var i = 0; i &lt; component.length; i++) {\n      var child = component[i];\n      if (ReactComponent.isValidComponent(child)) {\n        validateExplicitKey(child);\n      }\n    }\n  } else if (ReactComponent.isValidComponent(component)) {\n    // This component was passed in a valid location.\n    component.__keyValidated__ = true;\n  } else if (component &amp;&amp; typeof component === &apos;object&apos;) {\n    for (var name in component) {\n      validatePropertyKey(name, component);\n    }\n  }\n}\n\n/**\n * Components are the basic units of composition in React.\n *\n * Every component accepts a set of keyed input parameters known as &quot;props&quot; that\n * are initialized by the constructor. Once a component is mounted, the props\n * can be mutated using `setProps` or `replaceProps`.\n *\n * Every component is capable of the following operations:\n *\n *   `mountComponent`\n *     Initializes the component, renders markup, and registers event listeners.\n *\n *   `receiveComponent`\n *     Updates the rendered DOM nodes to match the given component.\n *\n *   `unmountComponent`\n *     Releases any resources allocated by this component.\n *\n * Components can also be &quot;owned&quot; by other components. Being owned by another\n * component means being constructed by that component. This is different from\n * being the child of a component, which means having a DOM representation that\n * is a child of the DOM representation of that component.\n *\n * @class ReactComponent\n */\nvar ReactComponent = {\n\n  /**\n   * @param {?object} object\n   * @return {boolean} True if `object` is a valid component.\n   * @final\n   */\n  isValidComponent: function(object) {\n    if (!object || !object.type || !object.type.prototype) {\n      return false;\n    }\n    // This is the safer way of duck checking the type of instance this is.\n    // The object can be a generic descriptor but the type property refers to\n    // the constructor and it&apos;s prototype can be used to inspect the type that\n    // will actually get mounted.\n    var prototype = object.type.prototype;\n    return (\n      typeof prototype.mountComponentIntoNode === &apos;function&apos; &amp;&amp;\n      typeof prototype.receiveComponent === &apos;function&apos;\n    );\n  },\n\n  /**\n   * @internal\n   */\n  LifeCycle: ComponentLifeCycle,\n\n  /**\n   * Injected module that provides ability to mutate individual properties.\n   * Injected into the base class because many different subclasses need access\n   * to this.\n   *\n   * @internal\n   */\n  BackendIDOperations: ReactComponentEnvironment.BackendIDOperations,\n\n  /**\n   * Optionally injectable environment dependent cleanup hook. (server vs.\n   * browser etc). Example: A browser system caches DOM nodes based on component\n   * ID and must remove that cache entry when this instance is unmounted.\n   *\n   * @private\n   */\n  unmountIDFromEnvironment: ReactComponentEnvironment.unmountIDFromEnvironment,\n\n  /**\n   * The &quot;image&quot; of a component tree, is the platform specific (typically\n   * serialized) data that represents a tree of lower level UI building blocks.\n   * On the web, this &quot;image&quot; is HTML markup which describes a construction of\n   * low level `div` and `span` nodes. Other platforms may have different\n   * encoding of this &quot;image&quot;. This must be injected.\n   *\n   * @private\n   */\n  mountImageIntoNode: ReactComponentEnvironment.mountImageIntoNode,\n\n  /**\n   * React references `ReactReconcileTransaction` using this property in order\n   * to allow dependency injection.\n   *\n   * @internal\n   */\n  ReactReconcileTransaction:\n    ReactComponentEnvironment.ReactReconcileTransaction,\n\n  /**\n   * Base functionality for every ReactComponent constructor. Mixed into the\n   * `ReactComponent` prototype, but exposed statically for easy access.\n   *\n   * @lends {ReactComponent.prototype}\n   */\n  Mixin: merge(ReactComponentEnvironment.Mixin, {\n\n    /**\n     * Checks whether or not this component is mounted.\n     *\n     * @return {boolean} True if mounted, false otherwise.\n     * @final\n     * @protected\n     */\n    isMounted: function() {\n      return this._lifeCycleState === ComponentLifeCycle.MOUNTED;\n    },\n\n    /**\n     * Sets a subset of the props.\n     *\n     * @param {object} partialProps Subset of the next props.\n     * @param {?function} callback Called after props are updated.\n     * @final\n     * @public\n     */\n    setProps: function(partialProps, callback) {\n      // Merge with `_pendingProps` if it exists, otherwise with existing props.\n      this.replaceProps(\n        merge(this._pendingProps || this.props, partialProps),\n        callback\n      );\n    },\n\n    /**\n     * Replaces all of the props.\n     *\n     * @param {object} props New props.\n     * @param {?function} callback Called after props are updated.\n     * @final\n     * @public\n     */\n    replaceProps: function(props, callback) {\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        this.isMounted(),\n        &apos;replaceProps(...): Can only update a mounted component.&apos;\n      ) : invariant(this.isMounted()));\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        this._mountDepth === 0,\n        &apos;replaceProps(...): You called `setProps` or `replaceProps` on a &apos; +\n        &apos;component with a parent. This is an anti-pattern since props will &apos; +\n        &apos;get reactively updated when rendered. Instead, change the owner\\&apos;s &apos; +\n        &apos;`render` method to pass the correct value as props to the component &apos; +\n        &apos;where it is created.&apos;\n      ) : invariant(this._mountDepth === 0));\n      this._pendingProps = props;\n      ReactUpdates.enqueueUpdate(this, callback);\n    },\n\n    /**\n     * Base constructor for all React components.\n     *\n     * Subclasses that override this method should make sure to invoke\n     * `ReactComponent.Mixin.construct.call(this, ...)`.\n     *\n     * @param {?object} initialProps\n     * @param {*} children\n     * @internal\n     */\n    construct: function(initialProps, children) {\n      this.props = initialProps || {};\n      // Record the component responsible for creating this component.\n      this._owner = ReactCurrentOwner.current;\n      // All components start unmounted.\n      this._lifeCycleState = ComponentLifeCycle.UNMOUNTED;\n\n      this._pendingProps = null;\n      this._pendingCallbacks = null;\n\n      // Unlike _pendingProps and _pendingCallbacks, we won&apos;t use null to\n      // indicate that nothing is pending because it&apos;s possible for a component\n      // to have a null owner. Instead, an owner change is pending when\n      // this._owner !== this._pendingOwner.\n      this._pendingOwner = this._owner;\n\n      // Children can be more than one argument\n      var childrenLength = arguments.length - 1;\n      if (childrenLength === 1) {\n        if (&quot;production&quot; !== &quot;development&quot;) {\n          validateChildKeys(children);\n        }\n        this.props.children = children;\n      } else if (childrenLength &gt; 1) {\n        var childArray = Array(childrenLength);\n        for (var i = 0; i &lt; childrenLength; i++) {\n          if (&quot;production&quot; !== &quot;development&quot;) {\n            validateChildKeys(arguments[i + 1]);\n          }\n          childArray[i] = arguments[i + 1];\n        }\n        this.props.children = childArray;\n      }\n    },\n\n    /**\n     * Initializes the component, renders markup, and registers event listeners.\n     *\n     * NOTE: This does not insert any nodes into the DOM.\n     *\n     * Subclasses that override this method should make sure to invoke\n     * `ReactComponent.Mixin.mountComponent.call(this, ...)`.\n     *\n     * @param {string} rootID DOM ID of the root node.\n     * @param {ReactReconcileTransaction} transaction\n     * @param {number} mountDepth number of components in the owner hierarchy.\n     * @return {?string} Rendered markup to be inserted into the DOM.\n     * @internal\n     */\n    mountComponent: function(rootID, transaction, mountDepth) {\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        !this.isMounted(),\n        &apos;mountComponent(%s, ...): Can only mount an unmounted component. &apos; +\n        &apos;Make sure to avoid storing components between renders or reusing a &apos; +\n        &apos;single component instance in multiple places.&apos;,\n        rootID\n      ) : invariant(!this.isMounted()));\n      var props = this.props;\n      if (props.ref != null) {\n        ReactOwner.addComponentAsRefTo(this, props.ref, this._owner);\n      }\n      this._rootNodeID = rootID;\n      this._lifeCycleState = ComponentLifeCycle.MOUNTED;\n      this._mountDepth = mountDepth;\n      // Effectively: return &apos;&apos;;\n    },\n\n    /**\n     * Releases any resources allocated by `mountComponent`.\n     *\n     * NOTE: This does not remove any nodes from the DOM.\n     *\n     * Subclasses that override this method should make sure to invoke\n     * `ReactComponent.Mixin.unmountComponent.call(this)`.\n     *\n     * @internal\n     */\n    unmountComponent: function() {\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        this.isMounted(),\n        &apos;unmountComponent(): Can only unmount a mounted component.&apos;\n      ) : invariant(this.isMounted()));\n      var props = this.props;\n      if (props.ref != null) {\n        ReactOwner.removeComponentAsRefFrom(this, props.ref, this._owner);\n      }\n      ReactComponent.unmountIDFromEnvironment(this._rootNodeID);\n      this._rootNodeID = null;\n      this._lifeCycleState = ComponentLifeCycle.UNMOUNTED;\n    },\n\n    /**\n     * Given a new instance of this component, updates the rendered DOM nodes\n     * as if that instance was rendered instead.\n     *\n     * Subclasses that override this method should make sure to invoke\n     * `ReactComponent.Mixin.receiveComponent.call(this, ...)`.\n     *\n     * @param {object} nextComponent Next set of properties.\n     * @param {ReactReconcileTransaction} transaction\n     * @internal\n     */\n    receiveComponent: function(nextComponent, transaction) {\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        this.isMounted(),\n        &apos;receiveComponent(...): Can only update a mounted component.&apos;\n      ) : invariant(this.isMounted()));\n      this._pendingOwner = nextComponent._owner;\n      this._pendingProps = nextComponent.props;\n      this._performUpdateIfNecessary(transaction);\n    },\n\n    /**\n     * Call `_performUpdateIfNecessary` within a new transaction.\n     *\n     * @param {ReactReconcileTransaction} transaction\n     * @internal\n     */\n    performUpdateIfNecessary: function() {\n      var transaction = ReactComponent.ReactReconcileTransaction.getPooled();\n      transaction.perform(this._performUpdateIfNecessary, this, transaction);\n      ReactComponent.ReactReconcileTransaction.release(transaction);\n    },\n\n    /**\n     * If `_pendingProps` is set, update the component.\n     *\n     * @param {ReactReconcileTransaction} transaction\n     * @internal\n     */\n    _performUpdateIfNecessary: function(transaction) {\n      if (this._pendingProps == null) {\n        return;\n      }\n      var prevProps = this.props;\n      var prevOwner = this._owner;\n      this.props = this._pendingProps;\n      this._owner = this._pendingOwner;\n      this._pendingProps = null;\n      this.updateComponent(transaction, prevProps, prevOwner);\n    },\n\n    /**\n     * Updates the component&apos;s currently mounted representation.\n     *\n     * @param {ReactReconcileTransaction} transaction\n     * @param {object} prevProps\n     * @internal\n     */\n    updateComponent: function(transaction, prevProps, prevOwner) {\n      var props = this.props;\n      // If either the owner or a `ref` has changed, make sure the newest owner\n      // has stored a reference to `this`, and the previous owner (if different)\n      // has forgotten the reference to `this`.\n      if (this._owner !== prevOwner || props.ref !== prevProps.ref) {\n        if (prevProps.ref != null) {\n          ReactOwner.removeComponentAsRefFrom(\n            this, prevProps.ref, prevOwner\n          );\n        }\n        // Correct, even if the owner is the same, and only the ref has changed.\n        if (props.ref != null) {\n          ReactOwner.addComponentAsRefTo(this, props.ref, this._owner);\n        }\n      }\n    },\n\n    /**\n     * Mounts this component and inserts it into the DOM.\n     *\n     * @param {string} rootID DOM ID of the root node.\n     * @param {DOMElement} container DOM element to mount into.\n     * @param {boolean} shouldReuseMarkup If true, do not insert markup\n     * @final\n     * @internal\n     * @see {ReactMount.renderComponent}\n     */\n    mountComponentIntoNode: function(rootID, container, shouldReuseMarkup) {\n      var transaction = ReactComponent.ReactReconcileTransaction.getPooled();\n      transaction.perform(\n        this._mountComponentIntoNode,\n        this,\n        rootID,\n        container,\n        transaction,\n        shouldReuseMarkup\n      );\n      ReactComponent.ReactReconcileTransaction.release(transaction);\n    },\n\n    /**\n     * @param {string} rootID DOM ID of the root node.\n     * @param {DOMElement} container DOM element to mount into.\n     * @param {ReactReconcileTransaction} transaction\n     * @param {boolean} shouldReuseMarkup If true, do not insert markup\n     * @final\n     * @private\n     */\n    _mountComponentIntoNode: function(\n        rootID,\n        container,\n        transaction,\n        shouldReuseMarkup) {\n      var markup = this.mountComponent(rootID, transaction, 0);\n      ReactComponent.mountImageIntoNode(markup, container, shouldReuseMarkup);\n    },\n\n    /**\n     * Checks if this component is owned by the supplied `owner` component.\n     *\n     * @param {ReactComponent} owner Component to check.\n     * @return {boolean} True if `owners` owns this component.\n     * @final\n     * @internal\n     */\n    isOwnedBy: function(owner) {\n      return this._owner === owner;\n    },\n\n    /**\n     * Gets another component, that shares the same owner as this one, by ref.\n     *\n     * @param {string} ref of a sibling Component.\n     * @return {?ReactComponent} the actual sibling Component.\n     * @final\n     * @internal\n     */\n    getSiblingByRef: function(ref) {\n      var owner = this._owner;\n      if (!owner || !owner.refs) {\n        return null;\n      }\n      return owner.refs[ref];\n    }\n  })\n};\n\nmodule.exports = ReactComponent;\n\n},{&quot;./ReactComponentEnvironment&quot;:28,&quot;./ReactCurrentOwner&quot;:31,&quot;./ReactOwner&quot;:59,&quot;./ReactUpdates&quot;:70,&quot;./invariant&quot;:108,&quot;./keyMirror&quot;:114,&quot;./merge&quot;:117}],27:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactComponentBrowserEnvironment\n */\n\n/*jslint evil: true */\n\n&quot;use strict&quot;;\n\nvar ReactDOMIDOperations = require(&quot;./ReactDOMIDOperations&quot;);\nvar ReactMarkupChecksum = require(&quot;./ReactMarkupChecksum&quot;);\nvar ReactMount = require(&quot;./ReactMount&quot;);\nvar ReactPerf = require(&quot;./ReactPerf&quot;);\nvar ReactReconcileTransaction = require(&quot;./ReactReconcileTransaction&quot;);\n\nvar getReactRootElementInContainer = require(&quot;./getReactRootElementInContainer&quot;);\nvar invariant = require(&quot;./invariant&quot;);\n\n\nvar ELEMENT_NODE_TYPE = 1;\nvar DOC_NODE_TYPE = 9;\n\n\n/**\n * Abstracts away all functionality of `ReactComponent` requires knowledge of\n * the browser context.\n */\nvar ReactComponentBrowserEnvironment = {\n  /**\n   * Mixed into every component instance.\n   */\n  Mixin: {\n    /**\n     * Returns the DOM node rendered by this component.\n     *\n     * @return {DOMElement} The root node of this component.\n     * @final\n     * @protected\n     */\n    getDOMNode: function() {\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        this.isMounted(),\n        &apos;getDOMNode(): A component must be mounted to have a DOM node.&apos;\n      ) : invariant(this.isMounted()));\n      return ReactMount.getNode(this._rootNodeID);\n    }\n  },\n\n  ReactReconcileTransaction: ReactReconcileTransaction,\n\n  BackendIDOperations: ReactDOMIDOperations,\n\n  /**\n   * If a particular environment requires that some resources be cleaned up,\n   * specify this in the injected Mixin. In the DOM, we would likely want to\n   * purge any cached node ID lookups.\n   *\n   * @private\n   */\n  unmountIDFromEnvironment: function(rootNodeID) {\n    ReactMount.purgeID(rootNodeID);\n  },\n\n  /**\n   * @param {string} markup Markup string to place into the DOM Element.\n   * @param {DOMElement} container DOM Element to insert markup into.\n   * @param {boolean} shouldReuseMarkup Should reuse the existing markup in the\n   * container if possible.\n   */\n  mountImageIntoNode: ReactPerf.measure(\n    &apos;ReactComponentBrowserEnvironment&apos;,\n    &apos;mountImageIntoNode&apos;,\n    function(markup, container, shouldReuseMarkup) {\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        container &amp;&amp; (\n          container.nodeType === ELEMENT_NODE_TYPE ||\n            container.nodeType === DOC_NODE_TYPE\n        ),\n        &apos;mountComponentIntoNode(...): Target container is not valid.&apos;\n      ) : invariant(container &amp;&amp; (\n        container.nodeType === ELEMENT_NODE_TYPE ||\n          container.nodeType === DOC_NODE_TYPE\n      )));\n\n      if (shouldReuseMarkup) {\n        if (ReactMarkupChecksum.canReuseMarkup(\n          markup,\n          getReactRootElementInContainer(container))) {\n          return;\n        } else {\n          (&quot;production&quot; !== &quot;development&quot; ? invariant(\n            container.nodeType !== DOC_NODE_TYPE,\n            &apos;You\\&apos;re trying to render a component to the document using &apos; +\n            &apos;server rendering but the checksum was invalid. This usually &apos; +\n            &apos;means you rendered a different component type or props on &apos; +\n            &apos;the client from the one on the server, or your render() &apos; +\n            &apos;methods are impure. React cannot handle this case due to &apos; +\n            &apos;cross-browser quirks by rendering at the document root. You &apos; +\n            &apos;should look for environment dependent code in your components &apos; +\n            &apos;and ensure the props are the same client and server side.&apos;\n          ) : invariant(container.nodeType !== DOC_NODE_TYPE));\n\n          if (&quot;production&quot; !== &quot;development&quot;) {\n            console.warn(\n              &apos;React attempted to use reuse markup in a container but the &apos; +\n              &apos;checksum was invalid. This generally means that you are &apos; +\n              &apos;using server rendering and the markup generated on the &apos; +\n              &apos;server was not what the client was expecting. React injected&apos; +\n              &apos;new markup to compensate which works but you have lost many &apos; +\n              &apos;of the benefits of server rendering. Instead, figure out &apos; +\n              &apos;why the markup being generated is different on the client &apos; +\n              &apos;or server.&apos;\n            );\n          }\n        }\n      }\n\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        container.nodeType !== DOC_NODE_TYPE,\n        &apos;You\\&apos;re trying to render a component to the document but &apos; +\n          &apos;you didn\\&apos;t use server rendering. We can\\&apos;t do this &apos; +\n          &apos;without using server rendering due to cross-browser quirks. &apos; +\n          &apos;See renderComponentToString() for server rendering.&apos;\n      ) : invariant(container.nodeType !== DOC_NODE_TYPE));\n\n      // Asynchronously inject markup by ensuring that the container is not in\n      // the document when settings its `innerHTML`.\n      var parent = container.parentNode;\n      if (parent) {\n        var next = container.nextSibling;\n        parent.removeChild(container);\n        container.innerHTML = markup;\n        if (next) {\n          parent.insertBefore(container, next);\n        } else {\n          parent.appendChild(container);\n        }\n      } else {\n        container.innerHTML = markup;\n      }\n    }\n  )\n};\n\nmodule.exports = ReactComponentBrowserEnvironment;\n\n},{&quot;./ReactDOMIDOperations&quot;:36,&quot;./ReactMarkupChecksum&quot;:54,&quot;./ReactMount&quot;:55,&quot;./ReactPerf&quot;:60,&quot;./ReactReconcileTransaction&quot;:66,&quot;./getReactRootElementInContainer&quot;:104,&quot;./invariant&quot;:108}],28:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactComponentEnvironment\n */\n\n&quot;use strict&quot;;\n\nvar ReactComponentBrowserEnvironment =\n  require(&quot;./ReactComponentBrowserEnvironment&quot;);\n\nvar ReactComponentEnvironment = ReactComponentBrowserEnvironment;\n\nmodule.exports = ReactComponentEnvironment;\n\n},{&quot;./ReactComponentBrowserEnvironment&quot;:27}],29:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactCompositeComponent\n */\n\n&quot;use strict&quot;;\n\nvar ReactComponent = require(&quot;./ReactComponent&quot;);\nvar ReactContext = require(&quot;./ReactContext&quot;);\nvar ReactCurrentOwner = require(&quot;./ReactCurrentOwner&quot;);\nvar ReactErrorUtils = require(&quot;./ReactErrorUtils&quot;);\nvar ReactOwner = require(&quot;./ReactOwner&quot;);\nvar ReactPerf = require(&quot;./ReactPerf&quot;);\nvar ReactPropTransferer = require(&quot;./ReactPropTransferer&quot;);\nvar ReactPropTypeLocations = require(&quot;./ReactPropTypeLocations&quot;);\nvar ReactPropTypeLocationNames = require(&quot;./ReactPropTypeLocationNames&quot;);\nvar ReactUpdates = require(&quot;./ReactUpdates&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\nvar keyMirror = require(&quot;./keyMirror&quot;);\nvar merge = require(&quot;./merge&quot;);\nvar mixInto = require(&quot;./mixInto&quot;);\nvar objMap = require(&quot;./objMap&quot;);\nvar shouldUpdateReactComponent = require(&quot;./shouldUpdateReactComponent&quot;);\n\n/**\n * Policies that describe methods in `ReactCompositeComponentInterface`.\n */\nvar SpecPolicy = keyMirror({\n  /**\n   * These methods may be defined only once by the class specification or mixin.\n   */\n  DEFINE_ONCE: null,\n  /**\n   * These methods may be defined by both the class specification and mixins.\n   * Subsequent definitions will be chained. These methods must return void.\n   */\n  DEFINE_MANY: null,\n  /**\n   * These methods are overriding the base ReactCompositeComponent class.\n   */\n  OVERRIDE_BASE: null,\n  /**\n   * These methods are similar to DEFINE_MANY, except we assume they return\n   * objects. We try to merge the keys of the return values of all the mixed in\n   * functions. If there is a key conflict we throw.\n   */\n  DEFINE_MANY_MERGED: null\n});\n\n/**\n * Composite components are higher-level components that compose other composite\n * or native components.\n *\n * To create a new type of `ReactCompositeComponent`, pass a specification of\n * your new class to `React.createClass`. The only requirement of your class\n * specification is that you implement a `render` method.\n *\n *   var MyComponent = React.createClass({\n *     render: function() {\n *       return &lt;div&gt;Hello World&lt;/div&gt;;\n *     }\n *   });\n *\n * The class specification supports a specific protocol of methods that have\n * special meaning (e.g. `render`). See `ReactCompositeComponentInterface` for\n * more the comprehensive protocol. Any other properties and methods in the\n * class specification will available on the prototype.\n *\n * @interface ReactCompositeComponentInterface\n * @internal\n */\nvar ReactCompositeComponentInterface = {\n\n  /**\n   * An array of Mixin objects to include when defining your component.\n   *\n   * @type {array}\n   * @optional\n   */\n  mixins: SpecPolicy.DEFINE_MANY,\n\n  /**\n   * An object containing properties and methods that should be defined on\n   * the component&apos;s constructor instead of its prototype (static methods).\n   *\n   * @type {object}\n   * @optional\n   */\n  statics: SpecPolicy.DEFINE_MANY,\n\n  /**\n   * Definition of prop types for this component.\n   *\n   * @type {object}\n   * @optional\n   */\n  propTypes: SpecPolicy.DEFINE_MANY,\n\n  /**\n   * Definition of context types for this component.\n   *\n   * @type {object}\n   * @optional\n   */\n  contextTypes: SpecPolicy.DEFINE_MANY,\n\n  /**\n   * Definition of context types this component sets for its children.\n   *\n   * @type {object}\n   * @optional\n   */\n  childContextTypes: SpecPolicy.DEFINE_MANY,\n\n  // ==== Definition methods ====\n\n  /**\n   * Invoked when the component is mounted. Values in the mapping will be set on\n   * `this.props` if that prop is not specified (i.e. using an `in` check).\n   *\n   * This method is invoked before `getInitialState` and therefore cannot rely\n   * on `this.state` or use `this.setState`.\n   *\n   * @return {object}\n   * @optional\n   */\n  getDefaultProps: SpecPolicy.DEFINE_MANY_MERGED,\n\n  /**\n   * Invoked once before the component is mounted. The return value will be used\n   * as the initial value of `this.state`.\n   *\n   *   getInitialState: function() {\n   *     return {\n   *       isOn: false,\n   *       fooBaz: new BazFoo()\n   *     }\n   *   }\n   *\n   * @return {object}\n   * @optional\n   */\n  getInitialState: SpecPolicy.DEFINE_MANY_MERGED,\n\n  /**\n   * @return {object}\n   * @optional\n   */\n  getChildContext: SpecPolicy.DEFINE_MANY_MERGED,\n\n  /**\n   * Uses props from `this.props` and state from `this.state` to render the\n   * structure of the component.\n   *\n   * No guarantees are made about when or how often this method is invoked, so\n   * it must not have side effects.\n   *\n   *   render: function() {\n   *     var name = this.props.name;\n   *     return &lt;div&gt;Hello, {name}!&lt;/div&gt;;\n   *   }\n   *\n   * @return {ReactComponent}\n   * @nosideeffects\n   * @required\n   */\n  render: SpecPolicy.DEFINE_ONCE,\n\n\n\n  // ==== Delegate methods ====\n\n  /**\n   * Invoked when the component is initially created and about to be mounted.\n   * This may have side effects, but any external subscriptions or data created\n   * by this method must be cleaned up in `componentWillUnmount`.\n   *\n   * @optional\n   */\n  componentWillMount: SpecPolicy.DEFINE_MANY,\n\n  /**\n   * Invoked when the component has been mounted and has a DOM representation.\n   * However, there is no guarantee that the DOM node is in the document.\n   *\n   * Use this as an opportunity to operate on the DOM when the component has\n   * been mounted (initialized and rendered) for the first time.\n   *\n   * @param {DOMElement} rootNode DOM element representing the component.\n   * @optional\n   */\n  componentDidMount: SpecPolicy.DEFINE_MANY,\n\n  /**\n   * Invoked before the component receives new props.\n   *\n   * Use this as an opportunity to react to a prop transition by updating the\n   * state using `this.setState`. Current props are accessed via `this.props`.\n   *\n   *   componentWillReceiveProps: function(nextProps, nextContext) {\n   *     this.setState({\n   *       likesIncreasing: nextProps.likeCount &gt; this.props.likeCount\n   *     });\n   *   }\n   *\n   * NOTE: There is no equivalent `componentWillReceiveState`. An incoming prop\n   * transition may cause a state change, but the opposite is not true. If you\n   * need it, you are probably looking for `componentWillUpdate`.\n   *\n   * @param {object} nextProps\n   * @optional\n   */\n  componentWillReceiveProps: SpecPolicy.DEFINE_MANY,\n\n  /**\n   * Invoked while deciding if the component should be updated as a result of\n   * receiving new props, state and/or context.\n   *\n   * Use this as an opportunity to `return false` when you&apos;re certain that the\n   * transition to the new props/state/context will not require a component\n   * update.\n   *\n   *   shouldComponentUpdate: function(nextProps, nextState, nextContext) {\n   *     return !equal(nextProps, this.props) ||\n   *       !equal(nextState, this.state) ||\n   *       !equal(nextContext, this.context);\n   *   }\n   *\n   * @param {object} nextProps\n   * @param {?object} nextState\n   * @param {?object} nextContext\n   * @return {boolean} True if the component should update.\n   * @optional\n   */\n  shouldComponentUpdate: SpecPolicy.DEFINE_ONCE,\n\n  /**\n   * Invoked when the component is about to update due to a transition from\n   * `this.props`, `this.state` and `this.context` to `nextProps`, `nextState`\n   * and `nextContext`.\n   *\n   * Use this as an opportunity to perform preparation before an update occurs.\n   *\n   * NOTE: You **cannot** use `this.setState()` in this method.\n   *\n   * @param {object} nextProps\n   * @param {?object} nextState\n   * @param {?object} nextContext\n   * @param {ReactReconcileTransaction} transaction\n   * @optional\n   */\n  componentWillUpdate: SpecPolicy.DEFINE_MANY,\n\n  /**\n   * Invoked when the component&apos;s DOM representation has been updated.\n   *\n   * Use this as an opportunity to operate on the DOM when the component has\n   * been updated.\n   *\n   * @param {object} prevProps\n   * @param {?object} prevState\n   * @param {?object} prevContext\n   * @param {DOMElement} rootNode DOM element representing the component.\n   * @optional\n   */\n  componentDidUpdate: SpecPolicy.DEFINE_MANY,\n\n  /**\n   * Invoked when the component is about to be removed from its parent and have\n   * its DOM representation destroyed.\n   *\n   * Use this as an opportunity to deallocate any external resources.\n   *\n   * NOTE: There is no `componentDidUnmount` since your component will have been\n   * destroyed by that point.\n   *\n   * @optional\n   */\n  componentWillUnmount: SpecPolicy.DEFINE_MANY,\n\n\n\n  // ==== Advanced methods ====\n\n  /**\n   * Updates the component&apos;s currently mounted DOM representation.\n   *\n   * By default, this implements React&apos;s rendering and reconciliation algorithm.\n   * Sophisticated clients may wish to override this.\n   *\n   * @param {ReactReconcileTransaction} transaction\n   * @internal\n   * @overridable\n   */\n  updateComponent: SpecPolicy.OVERRIDE_BASE\n\n};\n\n/**\n * Mapping from class specification keys to special processing functions.\n *\n * Although these are declared like instance properties in the specification\n * when defining classes using `React.createClass`, they are actually static\n * and are accessible on the constructor instead of the prototype. Despite\n * being static, they must be defined outside of the &quot;statics&quot; key under\n * which all other static methods are defined.\n */\nvar RESERVED_SPEC_KEYS = {\n  displayName: function(ConvenienceConstructor, displayName) {\n    ConvenienceConstructor.componentConstructor.displayName = displayName;\n  },\n  mixins: function(ConvenienceConstructor, mixins) {\n    if (mixins) {\n      for (var i = 0; i &lt; mixins.length; i++) {\n        mixSpecIntoComponent(ConvenienceConstructor, mixins[i]);\n      }\n    }\n  },\n  childContextTypes: function(ConvenienceConstructor, childContextTypes) {\n    var Constructor = ConvenienceConstructor.componentConstructor;\n    validateTypeDef(\n      Constructor,\n      childContextTypes,\n      ReactPropTypeLocations.childContext\n    );\n    Constructor.childContextTypes = merge(\n      Constructor.childContextTypes,\n      childContextTypes\n    );\n  },\n  contextTypes: function(ConvenienceConstructor, contextTypes) {\n    var Constructor = ConvenienceConstructor.componentConstructor;\n    validateTypeDef(\n      Constructor,\n      contextTypes,\n      ReactPropTypeLocations.context\n    );\n    Constructor.contextTypes = merge(Constructor.contextTypes, contextTypes);\n  },\n  propTypes: function(ConvenienceConstructor, propTypes) {\n    var Constructor = ConvenienceConstructor.componentConstructor;\n    validateTypeDef(\n      Constructor,\n      propTypes,\n      ReactPropTypeLocations.prop\n    );\n    Constructor.propTypes = merge(Constructor.propTypes, propTypes);\n  },\n  statics: function(ConvenienceConstructor, statics) {\n    mixStaticSpecIntoComponent(ConvenienceConstructor, statics);\n  }\n};\n\nfunction validateTypeDef(Constructor, typeDef, location) {\n  for (var propName in typeDef) {\n    if (typeDef.hasOwnProperty(propName)) {\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        typeof typeDef[propName] == &apos;function&apos;,\n        &apos;%s: %s type `%s` is invalid; it must be a function, usually from &apos; +\n        &apos;React.PropTypes.&apos;,\n        Constructor.displayName || &apos;ReactCompositeComponent&apos;,\n        ReactPropTypeLocationNames[location],\n        propName\n      ) : invariant(typeof typeDef[propName] == &apos;function&apos;));\n    }\n  }\n}\n\nfunction validateMethodOverride(proto, name) {\n  var specPolicy = ReactCompositeComponentInterface[name];\n\n  // Disallow overriding of base class methods unless explicitly allowed.\n  if (ReactCompositeComponentMixin.hasOwnProperty(name)) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      specPolicy === SpecPolicy.OVERRIDE_BASE,\n      &apos;ReactCompositeComponentInterface: You are attempting to override &apos; +\n      &apos;`%s` from your class specification. Ensure that your method names &apos; +\n      &apos;do not overlap with React methods.&apos;,\n      name\n    ) : invariant(specPolicy === SpecPolicy.OVERRIDE_BASE));\n  }\n\n  // Disallow defining methods more than once unless explicitly allowed.\n  if (proto.hasOwnProperty(name)) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      specPolicy === SpecPolicy.DEFINE_MANY ||\n      specPolicy === SpecPolicy.DEFINE_MANY_MERGED,\n      &apos;ReactCompositeComponentInterface: You are attempting to define &apos; +\n      &apos;`%s` on your component more than once. This conflict may be due &apos; +\n      &apos;to a mixin.&apos;,\n      name\n    ) : invariant(specPolicy === SpecPolicy.DEFINE_MANY ||\n    specPolicy === SpecPolicy.DEFINE_MANY_MERGED));\n  }\n}\n\nfunction validateLifeCycleOnReplaceState(instance) {\n  var compositeLifeCycleState = instance._compositeLifeCycleState;\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    instance.isMounted() ||\n      compositeLifeCycleState === CompositeLifeCycle.MOUNTING,\n    &apos;replaceState(...): Can only update a mounted or mounting component.&apos;\n  ) : invariant(instance.isMounted() ||\n    compositeLifeCycleState === CompositeLifeCycle.MOUNTING));\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(compositeLifeCycleState !== CompositeLifeCycle.RECEIVING_STATE,\n    &apos;replaceState(...): Cannot update during an existing state transition &apos; +\n    &apos;(such as within `render`). This could potentially cause an infinite &apos; +\n    &apos;loop so it is forbidden.&apos;\n  ) : invariant(compositeLifeCycleState !== CompositeLifeCycle.RECEIVING_STATE));\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(compositeLifeCycleState !== CompositeLifeCycle.UNMOUNTING,\n    &apos;replaceState(...): Cannot update while unmounting component. This &apos; +\n    &apos;usually means you called setState() on an unmounted component.&apos;\n  ) : invariant(compositeLifeCycleState !== CompositeLifeCycle.UNMOUNTING));\n}\n\n/**\n * Custom version of `mixInto` which handles policy validation and reserved\n * specification keys when building `ReactCompositeComponent` classses.\n */\nfunction mixSpecIntoComponent(ConvenienceConstructor, spec) {\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    !isValidClass(spec),\n    &apos;ReactCompositeComponent: You\\&apos;re attempting to &apos; +\n    &apos;use a component class as a mixin. Instead, just use a regular object.&apos;\n  ) : invariant(!isValidClass(spec)));\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    !ReactComponent.isValidComponent(spec),\n    &apos;ReactCompositeComponent: You\\&apos;re attempting to &apos; +\n    &apos;use a component as a mixin. Instead, just use a regular object.&apos;\n  ) : invariant(!ReactComponent.isValidComponent(spec)));\n\n  var Constructor = ConvenienceConstructor.componentConstructor;\n  var proto = Constructor.prototype;\n  for (var name in spec) {\n    var property = spec[name];\n    if (!spec.hasOwnProperty(name)) {\n      continue;\n    }\n\n    validateMethodOverride(proto, name);\n\n    if (RESERVED_SPEC_KEYS.hasOwnProperty(name)) {\n      RESERVED_SPEC_KEYS[name](ConvenienceConstructor, property);\n    } else {\n      // Setup methods on prototype:\n      // The following member methods should not be automatically bound:\n      // 1. Expected ReactCompositeComponent methods (in the &quot;interface&quot;).\n      // 2. Overridden methods (that were mixed in).\n      var isCompositeComponentMethod = name in ReactCompositeComponentInterface;\n      var isInherited = name in proto;\n      var markedDontBind = property &amp;&amp; property.__reactDontBind;\n      var isFunction = typeof property === &apos;function&apos;;\n      var shouldAutoBind =\n        isFunction &amp;&amp;\n        !isCompositeComponentMethod &amp;&amp;\n        !isInherited &amp;&amp;\n        !markedDontBind;\n\n      if (shouldAutoBind) {\n        if (!proto.__reactAutoBindMap) {\n          proto.__reactAutoBindMap = {};\n        }\n        proto.__reactAutoBindMap[name] = property;\n        proto[name] = property;\n      } else {\n        if (isInherited) {\n          // For methods which are defined more than once, call the existing\n          // methods before calling the new property.\n          if (ReactCompositeComponentInterface[name] ===\n              SpecPolicy.DEFINE_MANY_MERGED) {\n            proto[name] = createMergedResultFunction(proto[name], property);\n          } else {\n            proto[name] = createChainedFunction(proto[name], property);\n          }\n        } else {\n          proto[name] = property;\n        }\n      }\n    }\n  }\n}\n\nfunction mixStaticSpecIntoComponent(ConvenienceConstructor, statics) {\n  if (!statics) {\n    return;\n  }\n  for (var name in statics) {\n    var property = statics[name];\n    if (!statics.hasOwnProperty(name) || !property) {\n      return;\n    }\n\n    var isInherited = name in ConvenienceConstructor;\n    var result = property;\n    if (isInherited) {\n      var existingProperty = ConvenienceConstructor[name];\n      var existingType = typeof existingProperty;\n      var propertyType = typeof property;\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        existingType === &apos;function&apos; &amp;&amp; propertyType === &apos;function&apos;,\n        &apos;ReactCompositeComponent: You are attempting to define &apos; +\n        &apos;`%s` on your component more than once, but that is only supported &apos; +\n        &apos;for functions, which are chained together. This conflict may be &apos; +\n        &apos;due to a mixin.&apos;,\n        name\n      ) : invariant(existingType === &apos;function&apos; &amp;&amp; propertyType === &apos;function&apos;));\n      result = createChainedFunction(existingProperty, property);\n    }\n    ConvenienceConstructor[name] = result;\n    ConvenienceConstructor.componentConstructor[name] = result;\n  }\n}\n\n/**\n * Merge two objects, but throw if both contain the same key.\n *\n * @param {object} one The first object, which is mutated.\n * @param {object} two The second object\n * @return {object} one after it has been mutated to contain everything in two.\n */\nfunction mergeObjectsWithNoDuplicateKeys(one, two) {\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    one &amp;&amp; two &amp;&amp; typeof one === &apos;object&apos; &amp;&amp; typeof two === &apos;object&apos;,\n    &apos;mergeObjectsWithNoDuplicateKeys(): Cannot merge non-objects&apos;\n  ) : invariant(one &amp;&amp; two &amp;&amp; typeof one === &apos;object&apos; &amp;&amp; typeof two === &apos;object&apos;));\n\n  objMap(two, function(value, key) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      one[key] === undefined,\n      &apos;mergeObjectsWithNoDuplicateKeys(): &apos; +\n      &apos;Tried to merge two objects with the same key: %s&apos;,\n      key\n    ) : invariant(one[key] === undefined));\n    one[key] = value;\n  });\n  return one;\n}\n\n/**\n * Creates a function that invokes two functions and merges their return values.\n *\n * @param {function} one Function to invoke first.\n * @param {function} two Function to invoke second.\n * @return {function} Function that invokes the two argument functions.\n * @private\n */\nfunction createMergedResultFunction(one, two) {\n  return function mergedResult() {\n    var a = one.apply(this, arguments);\n    var b = two.apply(this, arguments);\n    if (a == null) {\n      return b;\n    } else if (b == null) {\n      return a;\n    }\n    return mergeObjectsWithNoDuplicateKeys(a, b);\n  };\n}\n\n/**\n * Creates a function that invokes two functions and ignores their return vales.\n *\n * @param {function} one Function to invoke first.\n * @param {function} two Function to invoke second.\n * @return {function} Function that invokes the two argument functions.\n * @private\n */\nfunction createChainedFunction(one, two) {\n  return function chainedFunction() {\n    one.apply(this, arguments);\n    two.apply(this, arguments);\n  };\n}\n\nif (&quot;production&quot; !== &quot;development&quot;) {\n\n  var unmountedPropertyWhitelist = {\n    constructor: true,\n    construct: true,\n    isOwnedBy: true, // should be deprecated but can have code mod (internal)\n    mountComponent: true,\n    mountComponentIntoNode: true,\n    props: true,\n    type: true,\n    _checkPropTypes: true,\n    _mountComponentIntoNode: true,\n    _processContext: true\n  };\n\n  var hasWarnedOnComponentType = {};\n\n  var warnIfUnmounted = function(instance, key) {\n    if (instance.__hasBeenMounted) {\n      return;\n    }\n    var name = instance.constructor.displayName || &apos;Unknown&apos;;\n    var owner = ReactCurrentOwner.current;\n    var ownerName = (owner &amp;&amp; owner.constructor.displayName) || &apos;Unknown&apos;;\n    var warningKey = key + &apos;|&apos; + name + &apos;|&apos; + ownerName;\n    if (hasWarnedOnComponentType.hasOwnProperty(warningKey)) {\n      // We have already warned for this combination. Skip it this time.\n      return;\n    }\n    hasWarnedOnComponentType[warningKey] = true;\n\n    var context = owner ? &apos; in &apos; + ownerName + &apos;.&apos; : &apos; at the top level.&apos;;\n    var staticMethodExample = &apos;&lt;&apos; + name + &apos; /&gt;.type.&apos; + key + &apos;(...)&apos;;\n\n    console.warn(\n      &apos;Invalid access to component property &quot;&apos; + key + &apos;&quot; on &apos; + name +\n      context + &apos; See http://fb.me/react-warning-descriptors .&apos; +\n      &apos; Use a static method instead: &apos; + staticMethodExample\n    );\n  };\n\n  var defineMembraneProperty = function(membrane, prototype, key) {\n    Object.defineProperty(membrane, key, {\n\n      configurable: false,\n      enumerable: true,\n\n      get: function() {\n        if (this !== membrane) {\n          // When this is accessed through a prototype chain we need to check if\n          // this component was mounted.\n          warnIfUnmounted(this, key);\n        }\n        return prototype[key];\n      },\n\n      set: function(value) {\n        if (this !== membrane) {\n          // When this is accessed through a prototype chain, we first check if\n          // this component was mounted. Then we define a value on &quot;this&quot;\n          // instance, effectively disabling the membrane on that prototype\n          // chain.\n          warnIfUnmounted(this, key);\n          Object.defineProperty(this, key, {\n            enumerable: true,\n            configurable: true,\n            writable: true,\n            value: value\n          });\n        } else {\n          // Otherwise, this should modify the prototype\n          prototype[key] = value;\n        }\n      }\n\n    });\n  };\n\n  /**\n   * Creates a membrane prototype which wraps the original prototype. If any\n   * property is accessed in an unmounted state, a warning is issued.\n   *\n   * @param {object} prototype Original prototype.\n   * @return {object} The membrane prototype.\n   * @private\n   */\n  var createMountWarningMembrane = function(prototype) {\n    try {\n      var membrane = Object.create(prototype);\n      for (var key in prototype) {\n        if (unmountedPropertyWhitelist.hasOwnProperty(key)) {\n          continue;\n        }\n        defineMembraneProperty(membrane, prototype, key);\n      }\n\n      membrane.mountComponent = function() {\n        this.__hasBeenMounted = true;\n        return prototype.mountComponent.apply(this, arguments);\n      };\n\n      return membrane;\n    } catch(x) {\n      // In IE8 define property will fail on non-DOM objects. If anything in\n      // the membrane creation fails, we&apos;ll bail out and just use the prototype\n      // without warnings.\n      return prototype;\n    }\n  };\n\n}\n\n/**\n * `ReactCompositeComponent` maintains an auxiliary life cycle state in\n * `this._compositeLifeCycleState` (which can be null).\n *\n * This is different from the life cycle state maintained by `ReactComponent` in\n * `this._lifeCycleState`. The following diagram shows how the states overlap in\n * time. There are times when the CompositeLifeCycle is null - at those times it\n * is only meaningful to look at ComponentLifeCycle alone.\n *\n * Top Row: ReactComponent.ComponentLifeCycle\n * Low Row: ReactComponent.CompositeLifeCycle\n *\n * +-------+------------------------------------------------------+--------+\n * |  UN   |                    MOUNTED                           |   UN   |\n * |MOUNTED|                                                      | MOUNTED|\n * +-------+------------------------------------------------------+--------+\n * |       ^--------+   +------+   +------+   +------+   +--------^        |\n * |       |        |   |      |   |      |   |      |   |        |        |\n * |    0--|MOUNTING|-0-|RECEIV|-0-|RECEIV|-0-|RECEIV|-0-|   UN   |---&gt;0   |\n * |       |        |   |PROPS |   | PROPS|   | STATE|   |MOUNTING|        |\n * |       |        |   |      |   |      |   |      |   |        |        |\n * |       |        |   |      |   |      |   |      |   |        |        |\n * |       +--------+   +------+   +------+   +------+   +--------+        |\n * |       |                                                      |        |\n * +-------+------------------------------------------------------+--------+\n */\nvar CompositeLifeCycle = keyMirror({\n  /**\n   * Components in the process of being mounted respond to state changes\n   * differently.\n   */\n  MOUNTING: null,\n  /**\n   * Components in the process of being unmounted are guarded against state\n   * changes.\n   */\n  UNMOUNTING: null,\n  /**\n   * Components that are mounted and receiving new props respond to state\n   * changes differently.\n   */\n  RECEIVING_PROPS: null,\n  /**\n   * Components that are mounted and receiving new state are guarded against\n   * additional state changes.\n   */\n  RECEIVING_STATE: null\n});\n\n/**\n * @lends {ReactCompositeComponent.prototype}\n */\nvar ReactCompositeComponentMixin = {\n\n  /**\n   * Base constructor for all composite component.\n   *\n   * @param {?object} initialProps\n   * @param {*} children\n   * @final\n   * @internal\n   */\n  construct: function(initialProps, children) {\n    // Children can be either an array or more than one argument\n    ReactComponent.Mixin.construct.apply(this, arguments);\n\n    this.state = null;\n    this._pendingState = null;\n\n    this.context = this._processContext(ReactContext.current);\n    this._currentContext = ReactContext.current;\n    this._pendingContext = null;\n\n    this._compositeLifeCycleState = null;\n  },\n\n  /**\n   * Checks whether or not this composite component is mounted.\n   * @return {boolean} True if mounted, false otherwise.\n   * @protected\n   * @final\n   */\n  isMounted: function() {\n    return ReactComponent.Mixin.isMounted.call(this) &amp;&amp;\n      this._compositeLifeCycleState !== CompositeLifeCycle.MOUNTING;\n  },\n\n  /**\n   * Initializes the component, renders markup, and registers event listeners.\n   *\n   * @param {string} rootID DOM ID of the root node.\n   * @param {ReactReconcileTransaction} transaction\n   * @param {number} mountDepth number of components in the owner hierarchy\n   * @return {?string} Rendered markup to be inserted into the DOM.\n   * @final\n   * @internal\n   */\n  mountComponent: ReactPerf.measure(\n    &apos;ReactCompositeComponent&apos;,\n    &apos;mountComponent&apos;,\n    function(rootID, transaction, mountDepth) {\n      ReactComponent.Mixin.mountComponent.call(\n        this,\n        rootID,\n        transaction,\n        mountDepth\n      );\n      this._compositeLifeCycleState = CompositeLifeCycle.MOUNTING;\n\n      this._defaultProps = this.getDefaultProps ? this.getDefaultProps() : null;\n      this.props = this._processProps(this.props);\n\n      if (this.__reactAutoBindMap) {\n        this._bindAutoBindMethods();\n      }\n\n      this.state = this.getInitialState ? this.getInitialState() : null;\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        typeof this.state === &apos;object&apos; &amp;&amp; !Array.isArray(this.state),\n        &apos;%s.getInitialState(): must return an object or null&apos;,\n        this.constructor.displayName || &apos;ReactCompositeComponent&apos;\n      ) : invariant(typeof this.state === &apos;object&apos; &amp;&amp; !Array.isArray(this.state)));\n\n      this._pendingState = null;\n      this._pendingForceUpdate = false;\n\n      if (this.componentWillMount) {\n        this.componentWillMount();\n        // When mounting, calls to `setState` by `componentWillMount` will set\n        // `this._pendingState` without triggering a re-render.\n        if (this._pendingState) {\n          this.state = this._pendingState;\n          this._pendingState = null;\n        }\n      }\n\n      this._renderedComponent = this._renderValidatedComponent();\n\n      // Done with mounting, `setState` will now trigger UI changes.\n      this._compositeLifeCycleState = null;\n      var markup = this._renderedComponent.mountComponent(\n        rootID,\n        transaction,\n        mountDepth + 1\n      );\n      if (this.componentDidMount) {\n        transaction.getReactMountReady().enqueue(this, this.componentDidMount);\n      }\n      return markup;\n    }\n  ),\n\n  /**\n   * Releases any resources allocated by `mountComponent`.\n   *\n   * @final\n   * @internal\n   */\n  unmountComponent: function() {\n    this._compositeLifeCycleState = CompositeLifeCycle.UNMOUNTING;\n    if (this.componentWillUnmount) {\n      this.componentWillUnmount();\n    }\n    this._compositeLifeCycleState = null;\n\n    this._defaultProps = null;\n\n    this._renderedComponent.unmountComponent();\n    this._renderedComponent = null;\n\n    ReactComponent.Mixin.unmountComponent.call(this);\n\n    if (this.refs) {\n      this.refs = null;\n    }\n\n    // Some existing components rely on this.props even after they&apos;ve been\n    // destroyed (in event handlers).\n    // TODO: this.props = null;\n    // TODO: this.state = null;\n  },\n\n  /**\n   * Sets a subset of the state. Always use this or `replaceState` to mutate\n   * state. You should treat `this.state` as immutable.\n   *\n   * There is no guarantee that `this.state` will be immediately updated, so\n   * accessing `this.state` after calling this method may return the old value.\n   *\n   * There is no guarantee that calls to `setState` will run synchronously,\n   * as they may eventually be batched together.  You can provide an optional\n   * callback that will be executed when the call to setState is actually\n   * completed.\n   *\n   * @param {object} partialState Next partial state to be merged with state.\n   * @param {?function} callback Called after state is updated.\n   * @final\n   * @protected\n   */\n  setState: function(partialState, callback) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      typeof partialState === &apos;object&apos; || partialState == null,\n      &apos;setState(...): takes an object of state variables to update.&apos;\n    ) : invariant(typeof partialState === &apos;object&apos; || partialState == null));\n    if (&quot;production&quot; !== &quot;development&quot;) {\n      if (partialState == null) {\n        console.warn(\n          &apos;setState(...): You passed an undefined or null state object; &apos; +\n          &apos;instead, use forceUpdate().&apos;\n        );\n      }\n    }\n    // Merge with `_pendingState` if it exists, otherwise with existing state.\n    this.replaceState(\n      merge(this._pendingState || this.state, partialState),\n      callback\n    );\n  },\n\n  /**\n   * Replaces all of the state. Always use this or `setState` to mutate state.\n   * You should treat `this.state` as immutable.\n   *\n   * There is no guarantee that `this.state` will be immediately updated, so\n   * accessing `this.state` after calling this method may return the old value.\n   *\n   * @param {object} completeState Next state.\n   * @param {?function} callback Called after state is updated.\n   * @final\n   * @protected\n   */\n  replaceState: function(completeState, callback) {\n    validateLifeCycleOnReplaceState(this);\n    this._pendingState = completeState;\n    ReactUpdates.enqueueUpdate(this, callback);\n  },\n\n  /**\n   * Filters the context object to only contain keys specified in\n   * `contextTypes`, and asserts that they are valid.\n   *\n   * @param {object} context\n   * @return {?object}\n   * @private\n   */\n  _processContext: function(context) {\n    var maskedContext = null;\n    var contextTypes = this.constructor.contextTypes;\n    if (contextTypes) {\n      maskedContext = {};\n      for (var contextName in contextTypes) {\n        maskedContext[contextName] = context[contextName];\n      }\n      if (&quot;production&quot; !== &quot;development&quot;) {\n        this._checkPropTypes(\n          contextTypes,\n          maskedContext,\n          ReactPropTypeLocations.context\n        );\n      }\n    }\n    return maskedContext;\n  },\n\n  /**\n   * @param {object} currentContext\n   * @return {object}\n   * @private\n   */\n  _processChildContext: function(currentContext) {\n    var childContext = this.getChildContext &amp;&amp; this.getChildContext();\n    var displayName = this.constructor.displayName || &apos;ReactCompositeComponent&apos;;\n    if (childContext) {\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        typeof this.constructor.childContextTypes === &apos;object&apos;,\n        &apos;%s.getChildContext(): childContextTypes must be defined in order to &apos; +\n        &apos;use getChildContext().&apos;,\n        displayName\n      ) : invariant(typeof this.constructor.childContextTypes === &apos;object&apos;));\n      if (&quot;production&quot; !== &quot;development&quot;) {\n        this._checkPropTypes(\n          this.constructor.childContextTypes,\n          childContext,\n          ReactPropTypeLocations.childContext\n        );\n      }\n      for (var name in childContext) {\n        (&quot;production&quot; !== &quot;development&quot; ? invariant(\n          name in this.constructor.childContextTypes,\n          &apos;%s.getChildContext(): key &quot;%s&quot; is not defined in childContextTypes.&apos;,\n          displayName,\n          name\n        ) : invariant(name in this.constructor.childContextTypes));\n      }\n      return merge(currentContext, childContext);\n    }\n    return currentContext;\n  },\n\n  /**\n   * Processes props by setting default values for unspecified props and\n   * asserting that the props are valid. Does not mutate its argument; returns\n   * a new props object with defaults merged in.\n   *\n   * @param {object} newProps\n   * @return {object}\n   * @private\n   */\n  _processProps: function(newProps) {\n    var props = merge(newProps);\n    var defaultProps = this._defaultProps;\n    for (var propName in defaultProps) {\n      if (typeof props[propName] === &apos;undefined&apos;) {\n        props[propName] = defaultProps[propName];\n      }\n    }\n    if (&quot;production&quot; !== &quot;development&quot;) {\n      var propTypes = this.constructor.propTypes;\n      if (propTypes) {\n        this._checkPropTypes(propTypes, props, ReactPropTypeLocations.prop);\n      }\n    }\n    return props;\n  },\n\n  /**\n   * Assert that the props are valid\n   *\n   * @param {object} propTypes Map of prop name to a ReactPropType\n   * @param {object} props\n   * @param {string} location e.g. &quot;prop&quot;, &quot;context&quot;, &quot;child context&quot;\n   * @private\n   */\n  _checkPropTypes: function(propTypes, props, location) {\n    var componentName = this.constructor.displayName;\n    for (var propName in propTypes) {\n      if (propTypes.hasOwnProperty(propName)) {\n        propTypes[propName](props, propName, componentName, location);\n      }\n    }\n  },\n\n  performUpdateIfNecessary: function() {\n    var compositeLifeCycleState = this._compositeLifeCycleState;\n    // Do not trigger a state transition if we are in the middle of mounting or\n    // receiving props because both of those will already be doing this.\n    if (compositeLifeCycleState === CompositeLifeCycle.MOUNTING ||\n        compositeLifeCycleState === CompositeLifeCycle.RECEIVING_PROPS) {\n      return;\n    }\n    ReactComponent.Mixin.performUpdateIfNecessary.call(this);\n  },\n\n  /**\n   * If any of `_pendingProps`, `_pendingState`, or `_pendingForceUpdate` is\n   * set, update the component.\n   *\n   * @param {ReactReconcileTransaction} transaction\n   * @internal\n   */\n  _performUpdateIfNecessary: function(transaction) {\n    if (this._pendingProps == null &amp;&amp;\n        this._pendingState == null &amp;&amp;\n        this._pendingContext == null &amp;&amp;\n        !this._pendingForceUpdate) {\n      return;\n    }\n\n    var nextFullContext = this._pendingContext || this._currentContext;\n    var nextContext = this._processContext(nextFullContext);\n    this._pendingContext = null;\n\n    var nextProps = this.props;\n    if (this._pendingProps != null) {\n      nextProps = this._processProps(this._pendingProps);\n      this._pendingProps = null;\n\n      this._compositeLifeCycleState = CompositeLifeCycle.RECEIVING_PROPS;\n      if (this.componentWillReceiveProps) {\n        this.componentWillReceiveProps(nextProps, nextContext);\n      }\n    }\n\n    this._compositeLifeCycleState = CompositeLifeCycle.RECEIVING_STATE;\n\n    // Unlike props, state, and context, we specifically don&apos;t want to set\n    // _pendingOwner to null here because it&apos;s possible for a component to have\n    // a null owner, so we instead make `this._owner === this._pendingOwner`\n    // mean that there&apos;s no owner change pending.\n    var nextOwner = this._pendingOwner;\n\n    var nextState = this._pendingState || this.state;\n    this._pendingState = null;\n\n    try {\n      if (this._pendingForceUpdate ||\n          !this.shouldComponentUpdate ||\n          this.shouldComponentUpdate(nextProps, nextState, nextContext)) {\n        this._pendingForceUpdate = false;\n        // Will set `this.props`, `this.state` and `this.context`.\n        this._performComponentUpdate(\n          nextProps,\n          nextOwner,\n          nextState,\n          nextFullContext,\n          nextContext,\n          transaction\n        );\n      } else {\n        // If it&apos;s determined that a component should not update, we still want\n        // to set props and state.\n        this.props = nextProps;\n        this._owner = nextOwner;\n        this.state = nextState;\n        this._currentContext = nextFullContext;\n        this.context = nextContext;\n      }\n    } finally {\n      this._compositeLifeCycleState = null;\n    }\n  },\n\n  /**\n   * Merges new props and state, notifies delegate methods of update and\n   * performs update.\n   *\n   * @param {object} nextProps Next object to set as properties.\n   * @param {?ReactComponent} nextOwner Next component to set as owner\n   * @param {?object} nextState Next object to set as state.\n   * @param {?object} nextFullContext Next object to set as _currentContext.\n   * @param {?object} nextContext Next object to set as context.\n   * @param {ReactReconcileTransaction} transaction\n   * @private\n   */\n  _performComponentUpdate: function(\n    nextProps,\n    nextOwner,\n    nextState,\n    nextFullContext,\n    nextContext,\n    transaction\n  ) {\n    var prevProps = this.props;\n    var prevOwner = this._owner;\n    var prevState = this.state;\n    var prevContext = this.context;\n\n    if (this.componentWillUpdate) {\n      this.componentWillUpdate(nextProps, nextState, nextContext);\n    }\n\n    this.props = nextProps;\n    this._owner = nextOwner;\n    this.state = nextState;\n    this._currentContext = nextFullContext;\n    this.context = nextContext;\n\n    this.updateComponent(\n      transaction,\n      prevProps,\n      prevOwner,\n      prevState,\n      prevContext\n    );\n\n    if (this.componentDidUpdate) {\n      transaction.getReactMountReady().enqueue(\n        this,\n        this.componentDidUpdate.bind(this, prevProps, prevState, prevContext)\n      );\n    }\n  },\n\n  receiveComponent: function(nextComponent, transaction) {\n    if (nextComponent === this) {\n      // Since props and context are immutable after the component is\n      // mounted, we can do a cheap identity compare here to determine\n      // if this is a superfluous reconcile.\n      return;\n    }\n\n    this._pendingContext = nextComponent._currentContext;\n    ReactComponent.Mixin.receiveComponent.call(\n      this,\n      nextComponent,\n      transaction\n    );\n  },\n\n  /**\n   * Updates the component&apos;s currently mounted DOM representation.\n   *\n   * By default, this implements React&apos;s rendering and reconciliation algorithm.\n   * Sophisticated clients may wish to override this.\n   *\n   * @param {ReactReconcileTransaction} transaction\n   * @param {object} prevProps\n   * @param {?ReactComponent} prevOwner\n   * @param {?object} prevState\n   * @param {?object} prevContext\n   * @internal\n   * @overridable\n   */\n  updateComponent: ReactPerf.measure(\n    &apos;ReactCompositeComponent&apos;,\n    &apos;updateComponent&apos;,\n    function(transaction, prevProps, prevOwner, prevState, prevContext) {\n      ReactComponent.Mixin.updateComponent.call(\n        this,\n        transaction,\n        prevProps,\n        prevOwner\n      );\n      var prevComponent = this._renderedComponent;\n      var nextComponent = this._renderValidatedComponent();\n      if (shouldUpdateReactComponent(prevComponent, nextComponent)) {\n        prevComponent.receiveComponent(nextComponent, transaction);\n      } else {\n        // These two IDs are actually the same! But nothing should rely on that.\n        var thisID = this._rootNodeID;\n        var prevComponentID = prevComponent._rootNodeID;\n        prevComponent.unmountComponent();\n        this._renderedComponent = nextComponent;\n        var nextMarkup = nextComponent.mountComponent(\n          thisID,\n          transaction,\n          this._mountDepth + 1\n        );\n        ReactComponent.BackendIDOperations.dangerouslyReplaceNodeWithMarkupByID(\n          prevComponentID,\n          nextMarkup\n        );\n      }\n    }\n  ),\n\n  /**\n   * Forces an update. This should only be invoked when it is known with\n   * certainty that we are **not** in a DOM transaction.\n   *\n   * You may want to call this when you know that some deeper aspect of the\n   * component&apos;s state has changed but `setState` was not called.\n   *\n   * This will not invoke `shouldUpdateComponent`, but it will invoke\n   * `componentWillUpdate` and `componentDidUpdate`.\n   *\n   * @param {?function} callback Called after update is complete.\n   * @final\n   * @protected\n   */\n  forceUpdate: function(callback) {\n    var compositeLifeCycleState = this._compositeLifeCycleState;\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      this.isMounted() ||\n        compositeLifeCycleState === CompositeLifeCycle.MOUNTING,\n      &apos;forceUpdate(...): Can only force an update on mounted or mounting &apos; +\n        &apos;components.&apos;\n    ) : invariant(this.isMounted() ||\n      compositeLifeCycleState === CompositeLifeCycle.MOUNTING));\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      compositeLifeCycleState !== CompositeLifeCycle.RECEIVING_STATE &amp;&amp;\n      compositeLifeCycleState !== CompositeLifeCycle.UNMOUNTING,\n      &apos;forceUpdate(...): Cannot force an update while unmounting component &apos; +\n      &apos;or during an existing state transition (such as within `render`).&apos;\n    ) : invariant(compositeLifeCycleState !== CompositeLifeCycle.RECEIVING_STATE &amp;&amp;\n    compositeLifeCycleState !== CompositeLifeCycle.UNMOUNTING));\n    this._pendingForceUpdate = true;\n    ReactUpdates.enqueueUpdate(this, callback);\n  },\n\n  /**\n   * @private\n   */\n  _renderValidatedComponent: ReactPerf.measure(\n    &apos;ReactCompositeComponent&apos;,\n    &apos;_renderValidatedComponent&apos;,\n    function() {\n      var renderedComponent;\n      var previousContext = ReactContext.current;\n      ReactContext.current = this._processChildContext(this._currentContext);\n      ReactCurrentOwner.current = this;\n      try {\n        renderedComponent = this.render();\n      } finally {\n        ReactContext.current = previousContext;\n        ReactCurrentOwner.current = null;\n      }\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        ReactComponent.isValidComponent(renderedComponent),\n        &apos;%s.render(): A valid ReactComponent must be returned. You may have &apos; +\n          &apos;returned null, undefined, an array, or some other invalid object.&apos;,\n        this.constructor.displayName || &apos;ReactCompositeComponent&apos;\n      ) : invariant(ReactComponent.isValidComponent(renderedComponent)));\n      return renderedComponent;\n    }\n  ),\n\n  /**\n   * @private\n   */\n  _bindAutoBindMethods: function() {\n    for (var autoBindKey in this.__reactAutoBindMap) {\n      if (!this.__reactAutoBindMap.hasOwnProperty(autoBindKey)) {\n        continue;\n      }\n      var method = this.__reactAutoBindMap[autoBindKey];\n      this[autoBindKey] = this._bindAutoBindMethod(ReactErrorUtils.guard(\n        method,\n        this.constructor.displayName + &apos;.&apos; + autoBindKey\n      ));\n    }\n  },\n\n  /**\n   * Binds a method to the component.\n   *\n   * @param {function} method Method to be bound.\n   * @private\n   */\n  _bindAutoBindMethod: function(method) {\n    var component = this;\n    var boundMethod = function() {\n      return method.apply(component, arguments);\n    };\n    if (&quot;production&quot; !== &quot;development&quot;) {\n      boundMethod.__reactBoundContext = component;\n      boundMethod.__reactBoundMethod = method;\n      boundMethod.__reactBoundArguments = null;\n      var componentName = component.constructor.displayName;\n      var _bind = boundMethod.bind;\n      boundMethod.bind = function(newThis ) {var args=Array.prototype.slice.call(arguments,1);\n        // User is trying to bind() an autobound method; we effectively will\n        // ignore the value of &quot;this&quot; that the user is trying to use, so\n        // let&apos;s warn.\n        if (newThis !== component &amp;&amp; newThis !== null) {\n          console.warn(\n            &apos;bind(): React component methods may only be bound to the &apos; +\n            &apos;component instance. See &apos; + componentName\n          );\n        } else if (!args.length) {\n          console.warn(\n            &apos;bind(): You are binding a component method to the component. &apos; +\n            &apos;React does this for you automatically in a high-performance &apos; +\n            &apos;way, so you can safely remove this call. See &apos; + componentName\n          );\n          return boundMethod;\n        }\n        var reboundMethod = _bind.apply(boundMethod, arguments);\n        reboundMethod.__reactBoundContext = component;\n        reboundMethod.__reactBoundMethod = method;\n        reboundMethod.__reactBoundArguments = args;\n        return reboundMethod;\n      };\n    }\n    return boundMethod;\n  }\n};\n\nvar ReactCompositeComponentBase = function() {};\nmixInto(ReactCompositeComponentBase, ReactComponent.Mixin);\nmixInto(ReactCompositeComponentBase, ReactOwner.Mixin);\nmixInto(ReactCompositeComponentBase, ReactPropTransferer.Mixin);\nmixInto(ReactCompositeComponentBase, ReactCompositeComponentMixin);\n\n/**\n * Checks if a value is a valid component constructor.\n *\n * @param {*}\n * @return {boolean}\n * @public\n */\nfunction isValidClass(componentClass) {\n  return componentClass instanceof Function &amp;&amp;\n         &apos;componentConstructor&apos; in componentClass &amp;&amp;\n         componentClass.componentConstructor instanceof Function;\n}\n/**\n * Module for creating composite components.\n *\n * @class ReactCompositeComponent\n * @extends ReactComponent\n * @extends ReactOwner\n * @extends ReactPropTransferer\n */\nvar ReactCompositeComponent = {\n\n  LifeCycle: CompositeLifeCycle,\n\n  Base: ReactCompositeComponentBase,\n\n  /**\n   * Creates a composite component class given a class specification.\n   *\n   * @param {object} spec Class specification (which must define `render`).\n   * @return {function} Component constructor function.\n   * @public\n   */\n  createClass: function(spec) {\n    var Constructor = function() {};\n    Constructor.prototype = new ReactCompositeComponentBase();\n    Constructor.prototype.constructor = Constructor;\n\n    var ConvenienceConstructor = function(props, children) {\n      var instance = new Constructor();\n      instance.construct.apply(instance, arguments);\n      return instance;\n    };\n    ConvenienceConstructor.componentConstructor = Constructor;\n    Constructor.ConvenienceConstructor = ConvenienceConstructor;\n    ConvenienceConstructor.originalSpec = spec;\n\n    mixSpecIntoComponent(ConvenienceConstructor, spec);\n\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      Constructor.prototype.render,\n      &apos;createClass(...): Class specification must implement a `render` method.&apos;\n    ) : invariant(Constructor.prototype.render));\n\n    if (&quot;production&quot; !== &quot;development&quot;) {\n      if (Constructor.prototype.componentShouldUpdate) {\n        console.warn(\n          (spec.displayName || &apos;A component&apos;) + &apos; has a method called &apos; +\n          &apos;componentShouldUpdate(). Did you mean shouldComponentUpdate()? &apos; +\n          &apos;The name is phrased as a question because the function is &apos; +\n          &apos;expected to return a value.&apos;\n         );\n      }\n    }\n\n    // Expose the convience constructor on the prototype so that it can be\n    // easily accessed on descriptors. E.g. &lt;Foo /&gt;.type === Foo.type and for\n    // static methods like &lt;Foo /&gt;.type.staticMethod();\n    // This should not be named constructor since this may not be the function\n    // that created the descriptor, and it may not even be a constructor.\n    ConvenienceConstructor.type = Constructor;\n    Constructor.prototype.type = Constructor;\n\n    // Reduce time spent doing lookups by setting these on the prototype.\n    for (var methodName in ReactCompositeComponentInterface) {\n      if (!Constructor.prototype[methodName]) {\n        Constructor.prototype[methodName] = null;\n      }\n    }\n\n    if (&quot;production&quot; !== &quot;development&quot;) {\n      Constructor.prototype = createMountWarningMembrane(Constructor.prototype);\n    }\n\n    return ConvenienceConstructor;\n  },\n\n  isValidClass: isValidClass\n};\n\nmodule.exports = ReactCompositeComponent;\n\n},{&quot;./ReactComponent&quot;:26,&quot;./ReactContext&quot;:30,&quot;./ReactCurrentOwner&quot;:31,&quot;./ReactErrorUtils&quot;:47,&quot;./ReactOwner&quot;:59,&quot;./ReactPerf&quot;:60,&quot;./ReactPropTransferer&quot;:61,&quot;./ReactPropTypeLocationNames&quot;:62,&quot;./ReactPropTypeLocations&quot;:63,&quot;./ReactUpdates&quot;:70,&quot;./invariant&quot;:108,&quot;./keyMirror&quot;:114,&quot;./merge&quot;:117,&quot;./mixInto&quot;:120,&quot;./objMap&quot;:121,&quot;./shouldUpdateReactComponent&quot;:126}],30:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactContext\n */\n\n&quot;use strict&quot;;\n\nvar merge = require(&quot;./merge&quot;);\n\n/**\n * Keeps track of the current context.\n *\n * The context is automatically passed down the component ownership hierarchy\n * and is accessible via `this.context` on ReactCompositeComponents.\n */\nvar ReactContext = {\n\n  /**\n   * @internal\n   * @type {object}\n   */\n  current: {},\n\n  /**\n   * Temporarily extends the current context while executing scopedCallback.\n   *\n   * A typical use case might look like\n   *\n   *  render: function() {\n   *    var children = ReactContext.withContext({foo: &apos;foo&apos;} () =&gt; (\n   *\n   *    ));\n   *    return &lt;div&gt;{children}&lt;/div&gt;;\n   *  }\n   *\n   * @param {object} newContext New context to merge into the existing context\n   * @param {function} scopedCallback Callback to run with the new context\n   * @return {ReactComponent|array&lt;ReactComponent&gt;}\n   */\n  withContext: function(newContext, scopedCallback) {\n    var result;\n    var previousContext = ReactContext.current;\n    ReactContext.current = merge(previousContext, newContext);\n    try {\n      result = scopedCallback();\n    } finally {\n      ReactContext.current = previousContext;\n    }\n    return result;\n  }\n\n};\n\nmodule.exports = ReactContext;\n\n},{&quot;./merge&quot;:117}],31:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactCurrentOwner\n */\n\n&quot;use strict&quot;;\n\n/**\n * Keeps track of the current owner.\n *\n * The current owner is the component who should own any components that are\n * currently being constructed.\n *\n * The depth indicate how many composite components are above this render level.\n */\nvar ReactCurrentOwner = {\n\n  /**\n   * @internal\n   * @type {ReactComponent}\n   */\n  current: null\n\n};\n\nmodule.exports = ReactCurrentOwner;\n\n},{}],32:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactDOM\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar ReactDOMComponent = require(&quot;./ReactDOMComponent&quot;);\n\nvar mergeInto = require(&quot;./mergeInto&quot;);\nvar objMapKeyVal = require(&quot;./objMapKeyVal&quot;);\n\n/**\n * Creates a new React class that is idempotent and capable of containing other\n * React components. It accepts event listeners and DOM properties that are\n * valid according to `DOMProperty`.\n *\n *  - Event listeners: `onClick`, `onMouseDown`, etc.\n *  - DOM properties: `className`, `name`, `title`, etc.\n *\n * The `style` property functions differently from the DOM API. It accepts an\n * object mapping of style properties to values.\n *\n * @param {string} tag Tag name (e.g. `div`).\n * @param {boolean} omitClose True if the close tag should be omitted.\n * @private\n */\nfunction createDOMComponentClass(tag, omitClose) {\n  var Constructor = function() {};\n  Constructor.prototype = new ReactDOMComponent(tag, omitClose);\n  Constructor.prototype.constructor = Constructor;\n  Constructor.displayName = tag;\n\n  var ConvenienceConstructor = function(props, children) {\n    var instance = new Constructor();\n    instance.construct.apply(instance, arguments);\n    return instance;\n  };\n\n  // Expose the constructor on the ConvenienceConstructor and prototype so that\n  // it can be easily easily accessed on descriptors.\n  // E.g. &lt;div /&gt;.type === div.type\n  ConvenienceConstructor.type = Constructor;\n  Constructor.prototype.type = Constructor;\n\n  Constructor.ConvenienceConstructor = ConvenienceConstructor;\n  ConvenienceConstructor.componentConstructor = Constructor;\n  return ConvenienceConstructor;\n}\n\n/**\n * Creates a mapping from supported HTML tags to `ReactDOMComponent` classes.\n * This is also accessible via `React.DOM`.\n *\n * @public\n */\nvar ReactDOM = objMapKeyVal({\n  a: false,\n  abbr: false,\n  address: false,\n  area: false,\n  article: false,\n  aside: false,\n  audio: false,\n  b: false,\n  base: false,\n  bdi: false,\n  bdo: false,\n  big: false,\n  blockquote: false,\n  body: false,\n  br: true,\n  button: false,\n  canvas: false,\n  caption: false,\n  cite: false,\n  code: false,\n  col: true,\n  colgroup: false,\n  data: false,\n  datalist: false,\n  dd: false,\n  del: false,\n  details: false,\n  dfn: false,\n  div: false,\n  dl: false,\n  dt: false,\n  em: false,\n  embed: true,\n  fieldset: false,\n  figcaption: false,\n  figure: false,\n  footer: false,\n  form: false, // NOTE: Injected, see `ReactDOMForm`.\n  h1: false,\n  h2: false,\n  h3: false,\n  h4: false,\n  h5: false,\n  h6: false,\n  head: false,\n  header: false,\n  hr: true,\n  html: false,\n  i: false,\n  iframe: false,\n  img: true,\n  input: true,\n  ins: false,\n  kbd: false,\n  keygen: true,\n  label: false,\n  legend: false,\n  li: false,\n  link: false,\n  main: false,\n  map: false,\n  mark: false,\n  menu: false,\n  menuitem: false, // NOTE: Close tag should be omitted, but causes problems.\n  meta: true,\n  meter: false,\n  nav: false,\n  noscript: false,\n  object: false,\n  ol: false,\n  optgroup: false,\n  option: false,\n  output: false,\n  p: false,\n  param: true,\n  pre: false,\n  progress: false,\n  q: false,\n  rp: false,\n  rt: false,\n  ruby: false,\n  s: false,\n  samp: false,\n  script: false,\n  section: false,\n  select: false,\n  small: false,\n  source: false,\n  span: false,\n  strong: false,\n  style: false,\n  sub: false,\n  summary: false,\n  sup: false,\n  table: false,\n  tbody: false,\n  td: false,\n  textarea: false, // NOTE: Injected, see `ReactDOMTextarea`.\n  tfoot: false,\n  th: false,\n  thead: false,\n  time: false,\n  title: false,\n  tr: false,\n  track: true,\n  u: false,\n  ul: false,\n  &apos;var&apos;: false,\n  video: false,\n  wbr: false,\n\n  // SVG\n  circle: false,\n  defs: false,\n  g: false,\n  line: false,\n  linearGradient: false,\n  path: false,\n  polygon: false,\n  polyline: false,\n  radialGradient: false,\n  rect: false,\n  stop: false,\n  svg: false,\n  text: false\n}, createDOMComponentClass);\n\nvar injection = {\n  injectComponentClasses: function(componentClasses) {\n    mergeInto(ReactDOM, componentClasses);\n  }\n};\n\nReactDOM.injection = injection;\n\nmodule.exports = ReactDOM;\n\n},{&quot;./ReactDOMComponent&quot;:34,&quot;./mergeInto&quot;:119,&quot;./objMapKeyVal&quot;:122}],33:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactDOMButton\n */\n\n&quot;use strict&quot;;\n\nvar AutoFocusMixin = require(&quot;./AutoFocusMixin&quot;);\nvar ReactCompositeComponent = require(&quot;./ReactCompositeComponent&quot;);\nvar ReactDOM = require(&quot;./ReactDOM&quot;);\n\nvar keyMirror = require(&quot;./keyMirror&quot;);\n\n// Store a reference to the &lt;button&gt; `ReactDOMComponent`.\nvar button = ReactDOM.button;\n\nvar mouseListenerNames = keyMirror({\n  onClick: true,\n  onDoubleClick: true,\n  onMouseDown: true,\n  onMouseMove: true,\n  onMouseUp: true,\n  onClickCapture: true,\n  onDoubleClickCapture: true,\n  onMouseDownCapture: true,\n  onMouseMoveCapture: true,\n  onMouseUpCapture: true\n});\n\n/**\n * Implements a &lt;button&gt; native component that does not receive mouse events\n * when `disabled` is set.\n */\nvar ReactDOMButton = ReactCompositeComponent.createClass({\n  displayName: &apos;ReactDOMButton&apos;,\n\n  mixins: [AutoFocusMixin],\n\n  render: function() {\n    var props = {};\n\n    // Copy the props; except the mouse listeners if we&apos;re disabled\n    for (var key in this.props) {\n      if (this.props.hasOwnProperty(key) &amp;&amp;\n          (!this.props.disabled || !mouseListenerNames[key])) {\n        props[key] = this.props[key];\n      }\n    }\n\n    return button(props, this.props.children);\n  }\n\n});\n\nmodule.exports = ReactDOMButton;\n\n},{&quot;./AutoFocusMixin&quot;:1,&quot;./ReactCompositeComponent&quot;:29,&quot;./ReactDOM&quot;:32,&quot;./keyMirror&quot;:114}],34:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactDOMComponent\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar CSSPropertyOperations = require(&quot;./CSSPropertyOperations&quot;);\nvar DOMProperty = require(&quot;./DOMProperty&quot;);\nvar DOMPropertyOperations = require(&quot;./DOMPropertyOperations&quot;);\nvar ReactComponent = require(&quot;./ReactComponent&quot;);\nvar ReactEventEmitter = require(&quot;./ReactEventEmitter&quot;);\nvar ReactMount = require(&quot;./ReactMount&quot;);\nvar ReactMultiChild = require(&quot;./ReactMultiChild&quot;);\nvar ReactPerf = require(&quot;./ReactPerf&quot;);\n\nvar escapeTextForBrowser = require(&quot;./escapeTextForBrowser&quot;);\nvar invariant = require(&quot;./invariant&quot;);\nvar keyOf = require(&quot;./keyOf&quot;);\nvar merge = require(&quot;./merge&quot;);\nvar mixInto = require(&quot;./mixInto&quot;);\n\nvar deleteListener = ReactEventEmitter.deleteListener;\nvar listenTo = ReactEventEmitter.listenTo;\nvar registrationNameModules = ReactEventEmitter.registrationNameModules;\n\n// For quickly matching children type, to test if can be treated as content.\nvar CONTENT_TYPES = {&apos;string&apos;: true, &apos;number&apos;: true};\n\nvar STYLE = keyOf({style: null});\n\nvar ELEMENT_NODE_TYPE = 1;\n\n/**\n * @param {?object} props\n */\nfunction assertValidProps(props) {\n  if (!props) {\n    return;\n  }\n  // Note the use of `==` which checks for null or undefined.\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    props.children == null || props.dangerouslySetInnerHTML == null,\n    &apos;Can only set one of `children` or `props.dangerouslySetInnerHTML`.&apos;\n  ) : invariant(props.children == null || props.dangerouslySetInnerHTML == null));\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    props.style == null || typeof props.style === &apos;object&apos;,\n    &apos;The `style` prop expects a mapping from style properties to values, &apos; +\n    &apos;not a string.&apos;\n  ) : invariant(props.style == null || typeof props.style === &apos;object&apos;));\n}\n\nfunction putListener(id, registrationName, listener, transaction) {\n  var container = ReactMount.findReactContainerForID(id);\n  if (container) {\n    var doc = container.nodeType === ELEMENT_NODE_TYPE ?\n      container.ownerDocument :\n      container;\n    listenTo(registrationName, doc);\n  }\n  transaction.getPutListenerQueue().enqueuePutListener(\n    id,\n    registrationName,\n    listener\n  );\n}\n\n\n/**\n * @constructor ReactDOMComponent\n * @extends ReactComponent\n * @extends ReactMultiChild\n */\nfunction ReactDOMComponent(tag, omitClose) {\n  this._tagOpen = &apos;&lt;&apos; + tag;\n  this._tagClose = omitClose ? &apos;&apos; : &apos;&lt;/&apos; + tag + &apos;&gt;&apos;;\n  this.tagName = tag.toUpperCase();\n}\n\nReactDOMComponent.Mixin = {\n\n  /**\n   * Generates root tag markup then recurses. This method has side effects and\n   * is not idempotent.\n   *\n   * @internal\n   * @param {string} rootID The root DOM ID for this node.\n   * @param {ReactReconcileTransaction} transaction\n   * @param {number} mountDepth number of components in the owner hierarchy\n   * @return {string} The computed markup.\n   */\n  mountComponent: ReactPerf.measure(\n    &apos;ReactDOMComponent&apos;,\n    &apos;mountComponent&apos;,\n    function(rootID, transaction, mountDepth) {\n      ReactComponent.Mixin.mountComponent.call(\n        this,\n        rootID,\n        transaction,\n        mountDepth\n      );\n      assertValidProps(this.props);\n      return (\n        this._createOpenTagMarkupAndPutListeners(transaction) +\n        this._createContentMarkup(transaction) +\n        this._tagClose\n      );\n    }\n  ),\n\n  /**\n   * Creates markup for the open tag and all attributes.\n   *\n   * This method has side effects because events get registered.\n   *\n   * Iterating over object properties is faster than iterating over arrays.\n   * @see http://jsperf.com/obj-vs-arr-iteration\n   *\n   * @private\n   * @param {ReactReconcileTransaction} transaction\n   * @return {string} Markup of opening tag.\n   */\n  _createOpenTagMarkupAndPutListeners: function(transaction) {\n    var props = this.props;\n    var ret = this._tagOpen;\n\n    for (var propKey in props) {\n      if (!props.hasOwnProperty(propKey)) {\n        continue;\n      }\n      var propValue = props[propKey];\n      if (propValue == null) {\n        continue;\n      }\n      if (registrationNameModules[propKey]) {\n        putListener(this._rootNodeID, propKey, propValue, transaction);\n      } else {\n        if (propKey === STYLE) {\n          if (propValue) {\n            propValue = props.style = merge(props.style);\n          }\n          propValue = CSSPropertyOperations.createMarkupForStyles(propValue);\n        }\n        var markup =\n          DOMPropertyOperations.createMarkupForProperty(propKey, propValue);\n        if (markup) {\n          ret += &apos; &apos; + markup;\n        }\n      }\n    }\n\n    var idMarkup = DOMPropertyOperations.createMarkupForID(this._rootNodeID);\n    return ret + &apos; &apos; + idMarkup + &apos;&gt;&apos;;\n  },\n\n  /**\n   * Creates markup for the content between the tags.\n   *\n   * @private\n   * @param {ReactReconcileTransaction} transaction\n   * @return {string} Content markup.\n   */\n  _createContentMarkup: function(transaction) {\n    // Intentional use of != to avoid catching zero/false.\n    var innerHTML = this.props.dangerouslySetInnerHTML;\n    if (innerHTML != null) {\n      if (innerHTML.__html != null) {\n        return innerHTML.__html;\n      }\n    } else {\n      var contentToUse =\n        CONTENT_TYPES[typeof this.props.children] ? this.props.children : null;\n      var childrenToUse = contentToUse != null ? null : this.props.children;\n      if (contentToUse != null) {\n        return escapeTextForBrowser(contentToUse);\n      } else if (childrenToUse != null) {\n        var mountImages = this.mountChildren(\n          childrenToUse,\n          transaction\n        );\n        return mountImages.join(&apos;&apos;);\n      }\n    }\n    return &apos;&apos;;\n  },\n\n  receiveComponent: function(nextComponent, transaction) {\n    assertValidProps(nextComponent.props);\n    ReactComponent.Mixin.receiveComponent.call(\n      this,\n      nextComponent,\n      transaction\n    );\n  },\n\n  /**\n   * Updates a native DOM component after it has already been allocated and\n   * attached to the DOM. Reconciles the root DOM node, then recurses.\n   *\n   * @param {ReactReconcileTransaction} transaction\n   * @param {object} prevProps\n   * @internal\n   * @overridable\n   */\n  updateComponent: ReactPerf.measure(\n    &apos;ReactDOMComponent&apos;,\n    &apos;updateComponent&apos;,\n    function(transaction, prevProps, prevOwner) {\n      ReactComponent.Mixin.updateComponent.call(\n        this,\n        transaction,\n        prevProps,\n        prevOwner\n      );\n      this._updateDOMProperties(prevProps, transaction);\n      this._updateDOMChildren(prevProps, transaction);\n    }\n  ),\n\n  /**\n   * Reconciles the properties by detecting differences in property values and\n   * updating the DOM as necessary. This function is probably the single most\n   * critical path for performance optimization.\n   *\n   * TODO: Benchmark whether checking for changed values in memory actually\n   *       improves performance (especially statically positioned elements).\n   * TODO: Benchmark the effects of putting this at the top since 99% of props\n   *       do not change for a given reconciliation.\n   * TODO: Benchmark areas that can be improved with caching.\n   *\n   * @private\n   * @param {object} lastProps\n   * @param {ReactReconcileTransaction} transaction\n   */\n  _updateDOMProperties: function(lastProps, transaction) {\n    var nextProps = this.props;\n    var propKey;\n    var styleName;\n    var styleUpdates;\n    for (propKey in lastProps) {\n      if (nextProps.hasOwnProperty(propKey) ||\n         !lastProps.hasOwnProperty(propKey)) {\n        continue;\n      }\n      if (propKey === STYLE) {\n        var lastStyle = lastProps[propKey];\n        for (styleName in lastStyle) {\n          if (lastStyle.hasOwnProperty(styleName)) {\n            styleUpdates = styleUpdates || {};\n            styleUpdates[styleName] = &apos;&apos;;\n          }\n        }\n      } else if (registrationNameModules[propKey]) {\n        deleteListener(this._rootNodeID, propKey);\n      } else if (\n          DOMProperty.isStandardName[propKey] ||\n          DOMProperty.isCustomAttribute(propKey)) {\n        ReactComponent.BackendIDOperations.deletePropertyByID(\n          this._rootNodeID,\n          propKey\n        );\n      }\n    }\n    for (propKey in nextProps) {\n      var nextProp = nextProps[propKey];\n      var lastProp = lastProps[propKey];\n      if (!nextProps.hasOwnProperty(propKey) || nextProp === lastProp) {\n        continue;\n      }\n      if (propKey === STYLE) {\n        if (nextProp) {\n          nextProp = nextProps.style = merge(nextProp);\n        }\n        if (lastProp) {\n          // Unset styles on `lastProp` but not on `nextProp`.\n          for (styleName in lastProp) {\n            if (lastProp.hasOwnProperty(styleName) &amp;&amp;\n                !nextProp.hasOwnProperty(styleName)) {\n              styleUpdates = styleUpdates || {};\n              styleUpdates[styleName] = &apos;&apos;;\n            }\n          }\n          // Update styles that changed since `lastProp`.\n          for (styleName in nextProp) {\n            if (nextProp.hasOwnProperty(styleName) &amp;&amp;\n                lastProp[styleName] !== nextProp[styleName]) {\n              styleUpdates = styleUpdates || {};\n              styleUpdates[styleName] = nextProp[styleName];\n            }\n          }\n        } else {\n          // Relies on `updateStylesByID` not mutating `styleUpdates`.\n          styleUpdates = nextProp;\n        }\n      } else if (registrationNameModules[propKey]) {\n        putListener(this._rootNodeID, propKey, nextProp, transaction);\n      } else if (\n          DOMProperty.isStandardName[propKey] ||\n          DOMProperty.isCustomAttribute(propKey)) {\n        ReactComponent.BackendIDOperations.updatePropertyByID(\n          this._rootNodeID,\n          propKey,\n          nextProp\n        );\n      }\n    }\n    if (styleUpdates) {\n      ReactComponent.BackendIDOperations.updateStylesByID(\n        this._rootNodeID,\n        styleUpdates\n      );\n    }\n  },\n\n  /**\n   * Reconciles the children with the various properties that affect the\n   * children content.\n   *\n   * @param {object} lastProps\n   * @param {ReactReconcileTransaction} transaction\n   */\n  _updateDOMChildren: function(lastProps, transaction) {\n    var nextProps = this.props;\n\n    var lastContent =\n      CONTENT_TYPES[typeof lastProps.children] ? lastProps.children : null;\n    var nextContent =\n      CONTENT_TYPES[typeof nextProps.children] ? nextProps.children : null;\n\n    var lastHtml =\n      lastProps.dangerouslySetInnerHTML &amp;&amp;\n      lastProps.dangerouslySetInnerHTML.__html;\n    var nextHtml =\n      nextProps.dangerouslySetInnerHTML &amp;&amp;\n      nextProps.dangerouslySetInnerHTML.__html;\n\n    // Note the use of `!=` which checks for null or undefined.\n    var lastChildren = lastContent != null ? null : lastProps.children;\n    var nextChildren = nextContent != null ? null : nextProps.children;\n\n    // If we&apos;re switching from children to content/html or vice versa, remove\n    // the old content\n    var lastHasContentOrHtml = lastContent != null || lastHtml != null;\n    var nextHasContentOrHtml = nextContent != null || nextHtml != null;\n    if (lastChildren != null &amp;&amp; nextChildren == null) {\n      this.updateChildren(null, transaction);\n    } else if (lastHasContentOrHtml &amp;&amp; !nextHasContentOrHtml) {\n      this.updateTextContent(&apos;&apos;);\n    }\n\n    if (nextContent != null) {\n      if (lastContent !== nextContent) {\n        this.updateTextContent(&apos;&apos; + nextContent);\n      }\n    } else if (nextHtml != null) {\n      if (lastHtml !== nextHtml) {\n        ReactComponent.BackendIDOperations.updateInnerHTMLByID(\n          this._rootNodeID,\n          nextHtml\n        );\n      }\n    } else if (nextChildren != null) {\n      this.updateChildren(nextChildren, transaction);\n    }\n  },\n\n  /**\n   * Destroys all event registrations for this instance. Does not remove from\n   * the DOM. That must be done by the parent.\n   *\n   * @internal\n   */\n  unmountComponent: function() {\n    this.unmountChildren();\n    ReactEventEmitter.deleteAllListeners(this._rootNodeID);\n    ReactComponent.Mixin.unmountComponent.call(this);\n  }\n\n};\n\nmixInto(ReactDOMComponent, ReactComponent.Mixin);\nmixInto(ReactDOMComponent, ReactDOMComponent.Mixin);\nmixInto(ReactDOMComponent, ReactMultiChild.Mixin);\n\nmodule.exports = ReactDOMComponent;\n\n},{&quot;./CSSPropertyOperations&quot;:3,&quot;./DOMProperty&quot;:8,&quot;./DOMPropertyOperations&quot;:9,&quot;./ReactComponent&quot;:26,&quot;./ReactEventEmitter&quot;:48,&quot;./ReactMount&quot;:55,&quot;./ReactMultiChild&quot;:57,&quot;./ReactPerf&quot;:60,&quot;./escapeTextForBrowser&quot;:96,&quot;./invariant&quot;:108,&quot;./keyOf&quot;:115,&quot;./merge&quot;:117,&quot;./mixInto&quot;:120}],35:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactDOMForm\n */\n\n&quot;use strict&quot;;\n\nvar ReactCompositeComponent = require(&quot;./ReactCompositeComponent&quot;);\nvar ReactDOM = require(&quot;./ReactDOM&quot;);\nvar ReactEventEmitter = require(&quot;./ReactEventEmitter&quot;);\nvar EventConstants = require(&quot;./EventConstants&quot;);\n\n// Store a reference to the &lt;form&gt; `ReactDOMComponent`.\nvar form = ReactDOM.form;\n\n/**\n * Since onSubmit doesn&apos;t bubble OR capture on the top level in IE8, we need\n * to capture it on the &lt;form&gt; element itself. There are lots of hacks we could\n * do to accomplish this, but the most reliable is to make &lt;form&gt; a\n * composite component and use `componentDidMount` to attach the event handlers.\n */\nvar ReactDOMForm = ReactCompositeComponent.createClass({\n  displayName: &apos;ReactDOMForm&apos;,\n\n  render: function() {\n    // TODO: Instead of using `ReactDOM` directly, we should use JSX. However,\n    // `jshint` fails to parse JSX so in order for linting to work in the open\n    // source repo, we need to just use `ReactDOM.form`.\n    return this.transferPropsTo(form(null, this.props.children));\n  },\n\n  componentDidMount: function() {\n    ReactEventEmitter.trapBubbledEvent(\n      EventConstants.topLevelTypes.topReset,\n      &apos;reset&apos;,\n      this.getDOMNode()\n    );\n    ReactEventEmitter.trapBubbledEvent(\n      EventConstants.topLevelTypes.topSubmit,\n      &apos;submit&apos;,\n      this.getDOMNode()\n    );\n  }\n});\n\nmodule.exports = ReactDOMForm;\n\n},{&quot;./EventConstants&quot;:14,&quot;./ReactCompositeComponent&quot;:29,&quot;./ReactDOM&quot;:32,&quot;./ReactEventEmitter&quot;:48}],36:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactDOMIDOperations\n * @typechecks static-only\n */\n\n/*jslint evil: true */\n\n&quot;use strict&quot;;\n\nvar CSSPropertyOperations = require(&quot;./CSSPropertyOperations&quot;);\nvar DOMChildrenOperations = require(&quot;./DOMChildrenOperations&quot;);\nvar DOMPropertyOperations = require(&quot;./DOMPropertyOperations&quot;);\nvar ReactMount = require(&quot;./ReactMount&quot;);\nvar ReactPerf = require(&quot;./ReactPerf&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\n\n/**\n * Errors for properties that should not be updated with `updatePropertyById()`.\n *\n * @type {object}\n * @private\n */\nvar INVALID_PROPERTY_ERRORS = {\n  dangerouslySetInnerHTML:\n    &apos;`dangerouslySetInnerHTML` must be set using `updateInnerHTMLByID()`.&apos;,\n  style: &apos;`style` must be set using `updateStylesByID()`.&apos;\n};\n\nvar useWhitespaceWorkaround;\n\n/**\n * Operations used to process updates to DOM nodes. This is made injectable via\n * `ReactComponent.BackendIDOperations`.\n */\nvar ReactDOMIDOperations = {\n\n  /**\n   * Updates a DOM node with new property values. This should only be used to\n   * update DOM properties in `DOMProperty`.\n   *\n   * @param {string} id ID of the node to update.\n   * @param {string} name A valid property name, see `DOMProperty`.\n   * @param {*} value New value of the property.\n   * @internal\n   */\n  updatePropertyByID: ReactPerf.measure(\n    &apos;ReactDOMIDOperations&apos;,\n    &apos;updatePropertyByID&apos;,\n    function(id, name, value) {\n      var node = ReactMount.getNode(id);\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        !INVALID_PROPERTY_ERRORS.hasOwnProperty(name),\n        &apos;updatePropertyByID(...): %s&apos;,\n        INVALID_PROPERTY_ERRORS[name]\n      ) : invariant(!INVALID_PROPERTY_ERRORS.hasOwnProperty(name)));\n\n      // If we&apos;re updating to null or undefined, we should remove the property\n      // from the DOM node instead of inadvertantly setting to a string. This\n      // brings us in line with the same behavior we have on initial render.\n      if (value != null) {\n        DOMPropertyOperations.setValueForProperty(node, name, value);\n      } else {\n        DOMPropertyOperations.deleteValueForProperty(node, name);\n      }\n    }\n  ),\n\n  /**\n   * Updates a DOM node to remove a property. This should only be used to remove\n   * DOM properties in `DOMProperty`.\n   *\n   * @param {string} id ID of the node to update.\n   * @param {string} name A property name to remove, see `DOMProperty`.\n   * @internal\n   */\n  deletePropertyByID: ReactPerf.measure(\n    &apos;ReactDOMIDOperations&apos;,\n    &apos;deletePropertyByID&apos;,\n    function(id, name, value) {\n      var node = ReactMount.getNode(id);\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        !INVALID_PROPERTY_ERRORS.hasOwnProperty(name),\n        &apos;updatePropertyByID(...): %s&apos;,\n        INVALID_PROPERTY_ERRORS[name]\n      ) : invariant(!INVALID_PROPERTY_ERRORS.hasOwnProperty(name)));\n      DOMPropertyOperations.deleteValueForProperty(node, name, value);\n    }\n  ),\n\n  /**\n   * Updates a DOM node with new style values. If a value is specified as &apos;&apos;,\n   * the corresponding style property will be unset.\n   *\n   * @param {string} id ID of the node to update.\n   * @param {object} styles Mapping from styles to values.\n   * @internal\n   */\n  updateStylesByID: ReactPerf.measure(\n    &apos;ReactDOMIDOperations&apos;,\n    &apos;updateStylesByID&apos;,\n    function(id, styles) {\n      var node = ReactMount.getNode(id);\n      CSSPropertyOperations.setValueForStyles(node, styles);\n    }\n  ),\n\n  /**\n   * Updates a DOM node&apos;s innerHTML.\n   *\n   * @param {string} id ID of the node to update.\n   * @param {string} html An HTML string.\n   * @internal\n   */\n  updateInnerHTMLByID: ReactPerf.measure(\n    &apos;ReactDOMIDOperations&apos;,\n    &apos;updateInnerHTMLByID&apos;,\n    function(id, html) {\n      var node = ReactMount.getNode(id);\n\n      // IE8: When updating a just created node with innerHTML only leading\n      // whitespace is removed. When updating an existing node with innerHTML\n      // whitespace in root TextNodes is also collapsed.\n      // @see quirksmode.org/bugreports/archives/2004/11/innerhtml_and_t.html\n\n      if (useWhitespaceWorkaround === undefined) {\n        // Feature detection; only IE8 is known to behave improperly like this.\n        var temp = document.createElement(&apos;div&apos;);\n        temp.innerHTML = &apos; &apos;;\n        useWhitespaceWorkaround = temp.innerHTML === &apos;&apos;;\n      }\n\n      if (useWhitespaceWorkaround) {\n        // Magic theory: IE8 supposedly differentiates between added and updated\n        // nodes when processing innerHTML, innerHTML on updated nodes suffers\n        // from worse whitespace behavior. Re-adding a node like this triggers\n        // the initial and more favorable whitespace behavior.\n        node.parentNode.replaceChild(node, node);\n      }\n\n      if (useWhitespaceWorkaround &amp;&amp; html.match(/^[ \\r\\n\\t\\f]/)) {\n        // Recover leading whitespace by temporarily prepending any character.\n        // \\uFEFF has the potential advantage of being zero-width/invisible.\n        node.innerHTML = &apos;\\uFEFF&apos; + html;\n        node.firstChild.deleteData(0, 1);\n      } else {\n        node.innerHTML = html;\n      }\n    }\n  ),\n\n  /**\n   * Updates a DOM node&apos;s text content set by `props.content`.\n   *\n   * @param {string} id ID of the node to update.\n   * @param {string} content Text content.\n   * @internal\n   */\n  updateTextContentByID: ReactPerf.measure(\n    &apos;ReactDOMIDOperations&apos;,\n    &apos;updateTextContentByID&apos;,\n    function(id, content) {\n      var node = ReactMount.getNode(id);\n      DOMChildrenOperations.updateTextContent(node, content);\n    }\n  ),\n\n  /**\n   * Replaces a DOM node that exists in the document with markup.\n   *\n   * @param {string} id ID of child to be replaced.\n   * @param {string} markup Dangerous markup to inject in place of child.\n   * @internal\n   * @see {Danger.dangerouslyReplaceNodeWithMarkup}\n   */\n  dangerouslyReplaceNodeWithMarkupByID: ReactPerf.measure(\n    &apos;ReactDOMIDOperations&apos;,\n    &apos;dangerouslyReplaceNodeWithMarkupByID&apos;,\n    function(id, markup) {\n      var node = ReactMount.getNode(id);\n      DOMChildrenOperations.dangerouslyReplaceNodeWithMarkup(node, markup);\n    }\n  ),\n\n  /**\n   * Updates a component&apos;s children by processing a series of updates.\n   *\n   * @param {array&lt;object&gt;} updates List of update configurations.\n   * @param {array&lt;string&gt;} markup List of markup strings.\n   * @internal\n   */\n  dangerouslyProcessChildrenUpdates: ReactPerf.measure(\n    &apos;ReactDOMIDOperations&apos;,\n    &apos;dangerouslyProcessChildrenUpdates&apos;,\n    function(updates, markup) {\n      for (var i = 0; i &lt; updates.length; i++) {\n        updates[i].parentNode = ReactMount.getNode(updates[i].parentID);\n      }\n      DOMChildrenOperations.processUpdates(updates, markup);\n    }\n  )\n};\n\nmodule.exports = ReactDOMIDOperations;\n\n},{&quot;./CSSPropertyOperations&quot;:3,&quot;./DOMChildrenOperations&quot;:7,&quot;./DOMPropertyOperations&quot;:9,&quot;./ReactMount&quot;:55,&quot;./ReactPerf&quot;:60,&quot;./invariant&quot;:108}],37:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactDOMImg\n */\n\n&quot;use strict&quot;;\n\nvar ReactCompositeComponent = require(&quot;./ReactCompositeComponent&quot;);\nvar ReactDOM = require(&quot;./ReactDOM&quot;);\nvar ReactEventEmitter = require(&quot;./ReactEventEmitter&quot;);\nvar EventConstants = require(&quot;./EventConstants&quot;);\n\n// Store a reference to the &lt;img&gt; `ReactDOMComponent`.\nvar img = ReactDOM.img;\n\n/**\n * Since onLoad doesn&apos;t bubble OR capture on the top level in IE8, we need to\n * capture it on the &lt;img&gt; element itself. There are lots of hacks we could do\n * to accomplish this, but the most reliable is to make &lt;img&gt; a composite\n * component and use `componentDidMount` to attach the event handlers.\n */\nvar ReactDOMImg = ReactCompositeComponent.createClass({\n  displayName: &apos;ReactDOMImg&apos;,\n  tagName: &apos;IMG&apos;,\n\n  render: function() {\n    return img(this.props);\n  },\n\n  componentDidMount: function() {\n    var node = this.getDOMNode();\n    ReactEventEmitter.trapBubbledEvent(\n      EventConstants.topLevelTypes.topLoad,\n      &apos;load&apos;,\n      node\n    );\n    ReactEventEmitter.trapBubbledEvent(\n      EventConstants.topLevelTypes.topError,\n      &apos;error&apos;,\n      node\n    );\n  }\n});\n\nmodule.exports = ReactDOMImg;\n\n},{&quot;./EventConstants&quot;:14,&quot;./ReactCompositeComponent&quot;:29,&quot;./ReactDOM&quot;:32,&quot;./ReactEventEmitter&quot;:48}],38:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactDOMInput\n */\n\n&quot;use strict&quot;;\n\nvar AutoFocusMixin = require(&quot;./AutoFocusMixin&quot;);\nvar DOMPropertyOperations = require(&quot;./DOMPropertyOperations&quot;);\nvar LinkedValueUtils = require(&quot;./LinkedValueUtils&quot;);\nvar ReactCompositeComponent = require(&quot;./ReactCompositeComponent&quot;);\nvar ReactDOM = require(&quot;./ReactDOM&quot;);\nvar ReactMount = require(&quot;./ReactMount&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\nvar merge = require(&quot;./merge&quot;);\n\n// Store a reference to the &lt;input&gt; `ReactDOMComponent`.\nvar input = ReactDOM.input;\n\nvar instancesByReactID = {};\n\n/**\n * Implements an &lt;input&gt; native component that allows setting these optional\n * props: `checked`, `value`, `defaultChecked`, and `defaultValue`.\n *\n * If `checked` or `value` are not supplied (or null/undefined), user actions\n * that affect the checked state or value will trigger updates to the element.\n *\n * If they are supplied (and not null/undefined), the rendered element will not\n * trigger updates to the element. Instead, the props must change in order for\n * the rendered element to be updated.\n *\n * The rendered element will be initialized as unchecked (or `defaultChecked`)\n * with an empty value (or `defaultValue`).\n *\n * @see http://www.w3.org/TR/2012/WD-html5-20121025/the-input-element.html\n */\nvar ReactDOMInput = ReactCompositeComponent.createClass({\n  displayName: &apos;ReactDOMInput&apos;,\n\n  mixins: [AutoFocusMixin, LinkedValueUtils.Mixin],\n\n  getInitialState: function() {\n    var defaultValue = this.props.defaultValue;\n    return {\n      checked: this.props.defaultChecked || false,\n      value: defaultValue != null ? defaultValue : null\n    };\n  },\n\n  shouldComponentUpdate: function() {\n    // Defer any updates to this component during the `onChange` handler.\n    return !this._isChanging;\n  },\n\n  render: function() {\n    // Clone `this.props` so we don&apos;t mutate the input.\n    var props = merge(this.props);\n\n    props.defaultChecked = null;\n    props.defaultValue = null;\n\n    var value = LinkedValueUtils.getValue(this);\n    props.value = value != null ? value : this.state.value;\n\n    var checked = LinkedValueUtils.getChecked(this);\n    props.checked = checked != null ? checked : this.state.checked;\n\n    props.onChange = this._handleChange;\n\n    return input(props, this.props.children);\n  },\n\n  componentDidMount: function() {\n    var id = ReactMount.getID(this.getDOMNode());\n    instancesByReactID[id] = this;\n  },\n\n  componentWillUnmount: function() {\n    var rootNode = this.getDOMNode();\n    var id = ReactMount.getID(rootNode);\n    delete instancesByReactID[id];\n  },\n\n  componentDidUpdate: function(prevProps, prevState, prevContext) {\n    var rootNode = this.getDOMNode();\n    if (this.props.checked != null) {\n      DOMPropertyOperations.setValueForProperty(\n        rootNode,\n        &apos;checked&apos;,\n        this.props.checked || false\n      );\n    }\n\n    var value = LinkedValueUtils.getValue(this);\n    if (value != null) {\n      // Cast `value` to a string to ensure the value is set correctly. While\n      // browsers typically do this as necessary, jsdom doesn&apos;t.\n      DOMPropertyOperations.setValueForProperty(rootNode, &apos;value&apos;, &apos;&apos; + value);\n    }\n  },\n\n  _handleChange: function(event) {\n    var returnValue;\n    var onChange = LinkedValueUtils.getOnChange(this);\n    if (onChange) {\n      this._isChanging = true;\n      returnValue = onChange.call(this, event);\n      this._isChanging = false;\n    }\n    this.setState({\n      checked: event.target.checked,\n      value: event.target.value\n    });\n\n    var name = this.props.name;\n    if (this.props.type === &apos;radio&apos; &amp;&amp; name != null) {\n      var rootNode = this.getDOMNode();\n      var queryRoot = rootNode;\n\n      while (queryRoot.parentNode) {\n        queryRoot = queryRoot.parentNode;\n      }\n\n      // If `rootNode.form` was non-null, then we could try `form.elements`,\n      // but that sometimes behaves strangely in IE8. We could also try using\n      // `form.getElementsByName`, but that will only return direct children\n      // and won&apos;t include inputs that use the HTML5 `form=` attribute. Since\n      // the input might not even be in a form, let&apos;s just use the global\n      // `querySelectorAll` to ensure we don&apos;t miss anything.\n      var group = queryRoot.querySelectorAll(\n        &apos;input[name=&apos; + JSON.stringify(&apos;&apos; + name) + &apos;][type=&quot;radio&quot;]&apos;);\n\n      for (var i = 0, groupLen = group.length; i &lt; groupLen; i++) {\n        var otherNode = group[i];\n        if (otherNode === rootNode ||\n            otherNode.form !== rootNode.form) {\n          continue;\n        }\n        var otherID = ReactMount.getID(otherNode);\n        (&quot;production&quot; !== &quot;development&quot; ? invariant(\n          otherID,\n          &apos;ReactDOMInput: Mixing React and non-React radio inputs with the &apos; +\n          &apos;same `name` is not supported.&apos;\n        ) : invariant(otherID));\n        var otherInstance = instancesByReactID[otherID];\n        (&quot;production&quot; !== &quot;development&quot; ? invariant(\n          otherInstance,\n          &apos;ReactDOMInput: Unknown radio button ID %s.&apos;,\n          otherID\n        ) : invariant(otherInstance));\n        // In some cases, this will actually change the `checked` state value.\n        // In other cases, there&apos;s no change but this forces a reconcile upon\n        // which componentDidUpdate will reset the DOM property to whatever it\n        // should be.\n        otherInstance.setState({\n          checked: false\n        });\n      }\n    }\n\n    return returnValue;\n  }\n\n});\n\nmodule.exports = ReactDOMInput;\n\n},{&quot;./AutoFocusMixin&quot;:1,&quot;./DOMPropertyOperations&quot;:9,&quot;./LinkedValueUtils&quot;:21,&quot;./ReactCompositeComponent&quot;:29,&quot;./ReactDOM&quot;:32,&quot;./ReactMount&quot;:55,&quot;./invariant&quot;:108,&quot;./merge&quot;:117}],39:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactDOMOption\n */\n\n&quot;use strict&quot;;\n\nvar ReactCompositeComponent = require(&quot;./ReactCompositeComponent&quot;);\nvar ReactDOM = require(&quot;./ReactDOM&quot;);\n\n// Store a reference to the &lt;option&gt; `ReactDOMComponent`.\nvar option = ReactDOM.option;\n\n/**\n * Implements an &lt;option&gt; native component that warns when `selected` is set.\n */\nvar ReactDOMOption = ReactCompositeComponent.createClass({\n  displayName: &apos;ReactDOMOption&apos;,\n\n  componentWillMount: function() {\n    // TODO (yungsters): Remove support for `selected` in &lt;option&gt;.\n    if (this.props.selected != null) {\n      if (&quot;production&quot; !== &quot;development&quot;) {\n        console.warn(\n          &apos;Use the `defaultValue` or `value` props on &lt;select&gt; instead of &apos; +\n          &apos;setting `selected` on &lt;option&gt;.&apos;\n        );\n      }\n    }\n  },\n\n  render: function() {\n    return option(this.props, this.props.children);\n  }\n\n});\n\nmodule.exports = ReactDOMOption;\n\n},{&quot;./ReactCompositeComponent&quot;:29,&quot;./ReactDOM&quot;:32}],40:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactDOMSelect\n */\n\n&quot;use strict&quot;;\n\nvar AutoFocusMixin = require(&quot;./AutoFocusMixin&quot;);\nvar LinkedValueUtils = require(&quot;./LinkedValueUtils&quot;);\nvar ReactCompositeComponent = require(&quot;./ReactCompositeComponent&quot;);\nvar ReactDOM = require(&quot;./ReactDOM&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\nvar merge = require(&quot;./merge&quot;);\n\n// Store a reference to the &lt;select&gt; `ReactDOMComponent`.\nvar select = ReactDOM.select;\n\n/**\n * Validation function for `value` and `defaultValue`.\n * @private\n */\nfunction selectValueType(props, propName, componentName) {\n  if (props[propName] == null) {\n    return;\n  }\n  if (props.multiple) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      Array.isArray(props[propName]),\n      &apos;The `%s` prop supplied to &lt;select&gt; must be an array if `multiple` is &apos; +\n      &apos;true.&apos;,\n      propName\n    ) : invariant(Array.isArray(props[propName])));\n  } else {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      !Array.isArray(props[propName]),\n      &apos;The `%s` prop supplied to &lt;select&gt; must be a scalar value if &apos; +\n      &apos;`multiple` is false.&apos;,\n      propName\n    ) : invariant(!Array.isArray(props[propName])));\n  }\n}\n\n/**\n * If `value` is supplied, updates &lt;option&gt; elements on mount and update.\n * @param {ReactComponent} component Instance of ReactDOMSelect\n * @param {?*} propValue For uncontrolled components, null/undefined. For\n * controlled components, a string (or with `multiple`, a list of strings).\n * @private\n */\nfunction updateOptions(component, propValue) {\n  var multiple = component.props.multiple;\n  var value = propValue != null ? propValue : component.state.value;\n  var options = component.getDOMNode().options;\n  var selectedValue, i, l;\n  if (multiple) {\n    selectedValue = {};\n    for (i = 0, l = value.length; i &lt; l; ++i) {\n      selectedValue[&apos;&apos; + value[i]] = true;\n    }\n  } else {\n    selectedValue = &apos;&apos; + value;\n  }\n  for (i = 0, l = options.length; i &lt; l; i++) {\n    var selected = multiple ?\n      selectedValue.hasOwnProperty(options[i].value) :\n      options[i].value === selectedValue;\n\n    if (selected !== options[i].selected) {\n      options[i].selected = selected;\n    }\n  }\n}\n\n/**\n * Implements a &lt;select&gt; native component that allows optionally setting the\n * props `value` and `defaultValue`. If `multiple` is false, the prop must be a\n * string. If `multiple` is true, the prop must be an array of strings.\n *\n * If `value` is not supplied (or null/undefined), user actions that change the\n * selected option will trigger updates to the rendered options.\n *\n * If it is supplied (and not null/undefined), the rendered options will not\n * update in response to user actions. Instead, the `value` prop must change in\n * order for the rendered options to update.\n *\n * If `defaultValue` is provided, any options with the supplied values will be\n * selected.\n */\nvar ReactDOMSelect = ReactCompositeComponent.createClass({\n  displayName: &apos;ReactDOMSelect&apos;,\n\n  mixins: [AutoFocusMixin, LinkedValueUtils.Mixin],\n\n  propTypes: {\n    defaultValue: selectValueType,\n    value: selectValueType\n  },\n\n  getInitialState: function() {\n    return {value: this.props.defaultValue || (this.props.multiple ? [] : &apos;&apos;)};\n  },\n\n  componentWillReceiveProps: function(nextProps) {\n    if (!this.props.multiple &amp;&amp; nextProps.multiple) {\n      this.setState({value: [this.state.value]});\n    } else if (this.props.multiple &amp;&amp; !nextProps.multiple) {\n      this.setState({value: this.state.value[0]});\n    }\n  },\n\n  shouldComponentUpdate: function() {\n    // Defer any updates to this component during the `onChange` handler.\n    return !this._isChanging;\n  },\n\n  render: function() {\n    // Clone `this.props` so we don&apos;t mutate the input.\n    var props = merge(this.props);\n\n    props.onChange = this._handleChange;\n    props.value = null;\n\n    return select(props, this.props.children);\n  },\n\n  componentDidMount: function() {\n    updateOptions(this, LinkedValueUtils.getValue(this));\n  },\n\n  componentDidUpdate: function() {\n    var value = LinkedValueUtils.getValue(this);\n    if (value != null) {\n      updateOptions(this, value);\n    }\n  },\n\n  _handleChange: function(event) {\n    var returnValue;\n    var onChange = LinkedValueUtils.getOnChange(this);\n    if (onChange) {\n      this._isChanging = true;\n      returnValue = onChange.call(this, event);\n      this._isChanging = false;\n    }\n\n    var selectedValue;\n    if (this.props.multiple) {\n      selectedValue = [];\n      var options = event.target.options;\n      for (var i = 0, l = options.length; i &lt; l; i++) {\n        if (options[i].selected) {\n          selectedValue.push(options[i].value);\n        }\n      }\n    } else {\n      selectedValue = event.target.value;\n    }\n\n    this.setState({value: selectedValue});\n    return returnValue;\n  }\n\n});\n\nmodule.exports = ReactDOMSelect;\n\n},{&quot;./AutoFocusMixin&quot;:1,&quot;./LinkedValueUtils&quot;:21,&quot;./ReactCompositeComponent&quot;:29,&quot;./ReactDOM&quot;:32,&quot;./invariant&quot;:108,&quot;./merge&quot;:117}],41:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactDOMSelection\n */\n\n&quot;use strict&quot;;\n\nvar getNodeForCharacterOffset = require(&quot;./getNodeForCharacterOffset&quot;);\nvar getTextContentAccessor = require(&quot;./getTextContentAccessor&quot;);\n\n/**\n * Get the appropriate anchor and focus node/offset pairs for IE.\n *\n * The catch here is that IE&apos;s selection API doesn&apos;t provide information\n * about whether the selection is forward or backward, so we have to\n * behave as though it&apos;s always forward.\n *\n * IE text differs from modern selection in that it behaves as though\n * block elements end with a new line. This means character offsets will\n * differ between the two APIs.\n *\n * @param {DOMElement} node\n * @return {object}\n */\nfunction getIEOffsets(node) {\n  var selection = document.selection;\n  var selectedRange = selection.createRange();\n  var selectedLength = selectedRange.text.length;\n\n  // Duplicate selection so we can move range without breaking user selection.\n  var fromStart = selectedRange.duplicate();\n  fromStart.moveToElementText(node);\n  fromStart.setEndPoint(&apos;EndToStart&apos;, selectedRange);\n\n  var startOffset = fromStart.text.length;\n  var endOffset = startOffset + selectedLength;\n\n  return {\n    start: startOffset,\n    end: endOffset\n  };\n}\n\n/**\n * @param {DOMElement} node\n * @return {?object}\n */\nfunction getModernOffsets(node) {\n  var selection = window.getSelection();\n\n  if (selection.rangeCount === 0) {\n    return null;\n  }\n\n  var anchorNode = selection.anchorNode;\n  var anchorOffset = selection.anchorOffset;\n  var focusNode = selection.focusNode;\n  var focusOffset = selection.focusOffset;\n\n  var currentRange = selection.getRangeAt(0);\n  var rangeLength = currentRange.toString().length;\n\n  var tempRange = currentRange.cloneRange();\n  tempRange.selectNodeContents(node);\n  tempRange.setEnd(currentRange.startContainer, currentRange.startOffset);\n\n  var start = tempRange.toString().length;\n  var end = start + rangeLength;\n\n  // Detect whether the selection is backward.\n  var detectionRange = document.createRange();\n  detectionRange.setStart(anchorNode, anchorOffset);\n  detectionRange.setEnd(focusNode, focusOffset);\n  var isBackward = detectionRange.collapsed;\n  detectionRange.detach();\n\n  return {\n    start: isBackward ? end : start,\n    end: isBackward ? start : end\n  };\n}\n\n/**\n * @param {DOMElement|DOMTextNode} node\n * @param {object} offsets\n */\nfunction setIEOffsets(node, offsets) {\n  var range = document.selection.createRange().duplicate();\n  var start, end;\n\n  if (typeof offsets.end === &apos;undefined&apos;) {\n    start = offsets.start;\n    end = start;\n  } else if (offsets.start &gt; offsets.end) {\n    start = offsets.end;\n    end = offsets.start;\n  } else {\n    start = offsets.start;\n    end = offsets.end;\n  }\n\n  range.moveToElementText(node);\n  range.moveStart(&apos;character&apos;, start);\n  range.setEndPoint(&apos;EndToStart&apos;, range);\n  range.moveEnd(&apos;character&apos;, end - start);\n  range.select();\n}\n\n/**\n * In modern non-IE browsers, we can support both forward and backward\n * selections.\n *\n * Note: IE10+ supports the Selection object, but it does not support\n * the `extend` method, which means that even in modern IE, it&apos;s not possible\n * to programatically create a backward selection. Thus, for all IE\n * versions, we use the old IE API to create our selections.\n *\n * @param {DOMElement|DOMTextNode} node\n * @param {object} offsets\n */\nfunction setModernOffsets(node, offsets) {\n  var selection = window.getSelection();\n\n  var length = node[getTextContentAccessor()].length;\n  var start = Math.min(offsets.start, length);\n  var end = typeof offsets.end === &apos;undefined&apos; ?\n            start : Math.min(offsets.end, length);\n\n  // IE 11 uses modern selection, but doesn&apos;t support the extend method.\n  // Flip backward selections, so we can set with a single range.\n  if (!selection.extend &amp;&amp; start &gt; end) {\n    var temp = end;\n    end = start;\n    start = temp;\n  }\n\n  var startMarker = getNodeForCharacterOffset(node, start);\n  var endMarker = getNodeForCharacterOffset(node, end);\n\n  if (startMarker &amp;&amp; endMarker) {\n    var range = document.createRange();\n    range.setStart(startMarker.node, startMarker.offset);\n    selection.removeAllRanges();\n\n    if (start &gt; end) {\n      selection.addRange(range);\n      selection.extend(endMarker.node, endMarker.offset);\n    } else {\n      range.setEnd(endMarker.node, endMarker.offset);\n      selection.addRange(range);\n    }\n\n    range.detach();\n  }\n}\n\nvar ReactDOMSelection = {\n  /**\n   * @param {DOMElement} node\n   */\n  getOffsets: function(node) {\n    var getOffsets = document.selection ? getIEOffsets : getModernOffsets;\n    return getOffsets(node);\n  },\n\n  /**\n   * @param {DOMElement|DOMTextNode} node\n   * @param {object} offsets\n   */\n  setOffsets: function(node, offsets) {\n    var setOffsets = document.selection ? setIEOffsets : setModernOffsets;\n    setOffsets(node, offsets);\n  }\n};\n\nmodule.exports = ReactDOMSelection;\n\n},{&quot;./getNodeForCharacterOffset&quot;:103,&quot;./getTextContentAccessor&quot;:105}],42:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactDOMTextarea\n */\n\n&quot;use strict&quot;;\n\nvar AutoFocusMixin = require(&quot;./AutoFocusMixin&quot;);\nvar DOMPropertyOperations = require(&quot;./DOMPropertyOperations&quot;);\nvar LinkedValueUtils = require(&quot;./LinkedValueUtils&quot;);\nvar ReactCompositeComponent = require(&quot;./ReactCompositeComponent&quot;);\nvar ReactDOM = require(&quot;./ReactDOM&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\nvar merge = require(&quot;./merge&quot;);\n\n// Store a reference to the &lt;textarea&gt; `ReactDOMComponent`.\nvar textarea = ReactDOM.textarea;\n\n/**\n * Implements a &lt;textarea&gt; native component that allows setting `value`, and\n * `defaultValue`. This differs from the traditional DOM API because value is\n * usually set as PCDATA children.\n *\n * If `value` is not supplied (or null/undefined), user actions that affect the\n * value will trigger updates to the element.\n *\n * If `value` is supplied (and not null/undefined), the rendered element will\n * not trigger updates to the element. Instead, the `value` prop must change in\n * order for the rendered element to be updated.\n *\n * The rendered element will be initialized with an empty value, the prop\n * `defaultValue` if specified, or the children content (deprecated).\n */\nvar ReactDOMTextarea = ReactCompositeComponent.createClass({\n  displayName: &apos;ReactDOMTextarea&apos;,\n\n  mixins: [AutoFocusMixin, LinkedValueUtils.Mixin],\n\n  getInitialState: function() {\n    var defaultValue = this.props.defaultValue;\n    // TODO (yungsters): Remove support for children content in &lt;textarea&gt;.\n    var children = this.props.children;\n    if (children != null) {\n      if (&quot;production&quot; !== &quot;development&quot;) {\n        console.warn(\n          &apos;Use the `defaultValue` or `value` props instead of setting &apos; +\n          &apos;children on &lt;textarea&gt;.&apos;\n        );\n      }\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        defaultValue == null,\n        &apos;If you supply `defaultValue` on a &lt;textarea&gt;, do not pass children.&apos;\n      ) : invariant(defaultValue == null));\n      if (Array.isArray(children)) {\n        (&quot;production&quot; !== &quot;development&quot; ? invariant(\n          children.length &lt;= 1,\n          &apos;&lt;textarea&gt; can only have at most one child.&apos;\n        ) : invariant(children.length &lt;= 1));\n        children = children[0];\n      }\n\n      defaultValue = &apos;&apos; + children;\n    }\n    if (defaultValue == null) {\n      defaultValue = &apos;&apos;;\n    }\n    var value = LinkedValueUtils.getValue(this);\n    return {\n      // We save the initial value so that `ReactDOMComponent` doesn&apos;t update\n      // `textContent` (unnecessary since we update value).\n      // The initial value can be a boolean or object so that&apos;s why it&apos;s\n      // forced to be a string.\n      initialValue: &apos;&apos; + (value != null ? value : defaultValue),\n      value: defaultValue\n    };\n  },\n\n  shouldComponentUpdate: function() {\n    // Defer any updates to this component during the `onChange` handler.\n    return !this._isChanging;\n  },\n\n  render: function() {\n    // Clone `this.props` so we don&apos;t mutate the input.\n    var props = merge(this.props);\n    var value = LinkedValueUtils.getValue(this);\n\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      props.dangerouslySetInnerHTML == null,\n      &apos;`dangerouslySetInnerHTML` does not make sense on &lt;textarea&gt;.&apos;\n    ) : invariant(props.dangerouslySetInnerHTML == null));\n\n    props.defaultValue = null;\n    props.value = value != null ? value : this.state.value;\n    props.onChange = this._handleChange;\n\n    // Always set children to the same thing. In IE9, the selection range will\n    // get reset if `textContent` is mutated.\n    return textarea(props, this.state.initialValue);\n  },\n\n  componentDidUpdate: function(prevProps, prevState, prevContext) {\n    var value = LinkedValueUtils.getValue(this);\n    if (value != null) {\n      var rootNode = this.getDOMNode();\n      // Cast `value` to a string to ensure the value is set correctly. While\n      // browsers typically do this as necessary, jsdom doesn&apos;t.\n      DOMPropertyOperations.setValueForProperty(rootNode, &apos;value&apos;, &apos;&apos; + value);\n    }\n  },\n\n  _handleChange: function(event) {\n    var returnValue;\n    var onChange = LinkedValueUtils.getOnChange(this);\n    if (onChange) {\n      this._isChanging = true;\n      returnValue = onChange.call(this, event);\n      this._isChanging = false;\n    }\n    this.setState({value: event.target.value});\n    return returnValue;\n  }\n\n});\n\nmodule.exports = ReactDOMTextarea;\n\n},{&quot;./AutoFocusMixin&quot;:1,&quot;./DOMPropertyOperations&quot;:9,&quot;./LinkedValueUtils&quot;:21,&quot;./ReactCompositeComponent&quot;:29,&quot;./ReactDOM&quot;:32,&quot;./invariant&quot;:108,&quot;./merge&quot;:117}],43:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactDefaultBatchingStrategy\n */\n\n&quot;use strict&quot;;\n\nvar ReactUpdates = require(&quot;./ReactUpdates&quot;);\nvar Transaction = require(&quot;./Transaction&quot;);\n\nvar emptyFunction = require(&quot;./emptyFunction&quot;);\nvar mixInto = require(&quot;./mixInto&quot;);\n\nvar RESET_BATCHED_UPDATES = {\n  initialize: emptyFunction,\n  close: function() {\n    ReactDefaultBatchingStrategy.isBatchingUpdates = false;\n  }\n};\n\nvar FLUSH_BATCHED_UPDATES = {\n  initialize: emptyFunction,\n  close: ReactUpdates.flushBatchedUpdates.bind(ReactUpdates)\n};\n\nvar TRANSACTION_WRAPPERS = [FLUSH_BATCHED_UPDATES, RESET_BATCHED_UPDATES];\n\nfunction ReactDefaultBatchingStrategyTransaction() {\n  this.reinitializeTransaction();\n}\n\nmixInto(ReactDefaultBatchingStrategyTransaction, Transaction.Mixin);\nmixInto(ReactDefaultBatchingStrategyTransaction, {\n  getTransactionWrappers: function() {\n    return TRANSACTION_WRAPPERS;\n  }\n});\n\nvar transaction = new ReactDefaultBatchingStrategyTransaction();\n\nvar ReactDefaultBatchingStrategy = {\n  isBatchingUpdates: false,\n\n  /**\n   * Call the provided function in a context within which calls to `setState`\n   * and friends are batched such that components aren&apos;t updated unnecessarily.\n   */\n  batchedUpdates: function(callback, param) {\n    var alreadyBatchingUpdates = ReactDefaultBatchingStrategy.isBatchingUpdates;\n\n    ReactDefaultBatchingStrategy.isBatchingUpdates = true;\n\n    // The code is written this way to avoid extra allocations\n    if (alreadyBatchingUpdates) {\n      callback(param);\n    } else {\n      transaction.perform(callback, null, param);\n    }\n  }\n};\n\nmodule.exports = ReactDefaultBatchingStrategy;\n\n},{&quot;./ReactUpdates&quot;:70,&quot;./Transaction&quot;:84,&quot;./emptyFunction&quot;:95,&quot;./mixInto&quot;:120}],44:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactDefaultInjection\n */\n\n&quot;use strict&quot;;\n\nvar ReactInjection = require(&quot;./ReactInjection&quot;);\n\nvar ExecutionEnvironment = require(&quot;./ExecutionEnvironment&quot;);\n\nvar DefaultDOMPropertyConfig = require(&quot;./DefaultDOMPropertyConfig&quot;);\n\nvar ChangeEventPlugin = require(&quot;./ChangeEventPlugin&quot;);\nvar ClientReactRootIndex = require(&quot;./ClientReactRootIndex&quot;);\nvar CompositionEventPlugin = require(&quot;./CompositionEventPlugin&quot;);\nvar DefaultEventPluginOrder = require(&quot;./DefaultEventPluginOrder&quot;);\nvar EnterLeaveEventPlugin = require(&quot;./EnterLeaveEventPlugin&quot;);\nvar MobileSafariClickEventPlugin = require(&quot;./MobileSafariClickEventPlugin&quot;);\nvar ReactEventTopLevelCallback = require(&quot;./ReactEventTopLevelCallback&quot;);\nvar ReactDOM = require(&quot;./ReactDOM&quot;);\nvar ReactDOMButton = require(&quot;./ReactDOMButton&quot;);\nvar ReactDOMForm = require(&quot;./ReactDOMForm&quot;);\nvar ReactDOMImg = require(&quot;./ReactDOMImg&quot;);\nvar ReactDOMInput = require(&quot;./ReactDOMInput&quot;);\nvar ReactDOMOption = require(&quot;./ReactDOMOption&quot;);\nvar ReactDOMSelect = require(&quot;./ReactDOMSelect&quot;);\nvar ReactDOMTextarea = require(&quot;./ReactDOMTextarea&quot;);\nvar ReactInstanceHandles = require(&quot;./ReactInstanceHandles&quot;);\nvar ReactMount = require(&quot;./ReactMount&quot;);\nvar SelectEventPlugin = require(&quot;./SelectEventPlugin&quot;);\nvar ServerReactRootIndex = require(&quot;./ServerReactRootIndex&quot;);\nvar SimpleEventPlugin = require(&quot;./SimpleEventPlugin&quot;);\n\nvar ReactDefaultBatchingStrategy = require(&quot;./ReactDefaultBatchingStrategy&quot;);\n\nvar createFullPageComponent = require(&quot;./createFullPageComponent&quot;);\n\nfunction inject() {\n  ReactInjection.EventEmitter.injectTopLevelCallbackCreator(\n    ReactEventTopLevelCallback\n  );\n\n  /**\n   * Inject modules for resolving DOM hierarchy and plugin ordering.\n   */\n  ReactInjection.EventPluginHub.injectEventPluginOrder(DefaultEventPluginOrder);\n  ReactInjection.EventPluginHub.injectInstanceHandle(ReactInstanceHandles);\n  ReactInjection.EventPluginHub.injectMount(ReactMount);\n\n  /**\n   * Some important event plugins included by default (without having to require\n   * them).\n   */\n  ReactInjection.EventPluginHub.injectEventPluginsByName({\n    SimpleEventPlugin: SimpleEventPlugin,\n    EnterLeaveEventPlugin: EnterLeaveEventPlugin,\n    ChangeEventPlugin: ChangeEventPlugin,\n    CompositionEventPlugin: CompositionEventPlugin,\n    MobileSafariClickEventPlugin: MobileSafariClickEventPlugin,\n    SelectEventPlugin: SelectEventPlugin\n  });\n\n  ReactInjection.DOM.injectComponentClasses({\n    button: ReactDOMButton,\n    form: ReactDOMForm,\n    img: ReactDOMImg,\n    input: ReactDOMInput,\n    option: ReactDOMOption,\n    select: ReactDOMSelect,\n    textarea: ReactDOMTextarea,\n\n    html: createFullPageComponent(ReactDOM.html),\n    head: createFullPageComponent(ReactDOM.head),\n    title: createFullPageComponent(ReactDOM.title),\n    body: createFullPageComponent(ReactDOM.body)\n  });\n\n  ReactInjection.DOMProperty.injectDOMPropertyConfig(DefaultDOMPropertyConfig);\n\n  ReactInjection.Updates.injectBatchingStrategy(\n    ReactDefaultBatchingStrategy\n  );\n\n  ReactInjection.RootIndex.injectCreateReactRootIndex(\n    ExecutionEnvironment.canUseDOM ?\n      ClientReactRootIndex.createReactRootIndex :\n      ServerReactRootIndex.createReactRootIndex\n  );\n\n  if (&quot;production&quot; !== &quot;development&quot;) {\n    var url = (ExecutionEnvironment.canUseDOM &amp;&amp; window.location.href) || &apos;&apos;;\n    if ((/[?&amp;]react_perf\\b/).test(url)) {\n      var ReactDefaultPerf = require(&quot;./ReactDefaultPerf&quot;);\n      ReactDefaultPerf.start();\n    }\n  }\n}\n\nmodule.exports = {\n  inject: inject\n};\n\n},{&quot;./ChangeEventPlugin&quot;:4,&quot;./ClientReactRootIndex&quot;:5,&quot;./CompositionEventPlugin&quot;:6,&quot;./DefaultDOMPropertyConfig&quot;:11,&quot;./DefaultEventPluginOrder&quot;:12,&quot;./EnterLeaveEventPlugin&quot;:13,&quot;./ExecutionEnvironment&quot;:20,&quot;./MobileSafariClickEventPlugin&quot;:22,&quot;./ReactDOM&quot;:32,&quot;./ReactDOMButton&quot;:33,&quot;./ReactDOMForm&quot;:35,&quot;./ReactDOMImg&quot;:37,&quot;./ReactDOMInput&quot;:38,&quot;./ReactDOMOption&quot;:39,&quot;./ReactDOMSelect&quot;:40,&quot;./ReactDOMTextarea&quot;:42,&quot;./ReactDefaultBatchingStrategy&quot;:43,&quot;./ReactDefaultPerf&quot;:45,&quot;./ReactEventTopLevelCallback&quot;:50,&quot;./ReactInjection&quot;:51,&quot;./ReactInstanceHandles&quot;:53,&quot;./ReactMount&quot;:55,&quot;./SelectEventPlugin&quot;:71,&quot;./ServerReactRootIndex&quot;:72,&quot;./SimpleEventPlugin&quot;:73,&quot;./createFullPageComponent&quot;:91}],45:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactDefaultPerf\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar DOMProperty = require(&quot;./DOMProperty&quot;);\nvar ReactDefaultPerfAnalysis = require(&quot;./ReactDefaultPerfAnalysis&quot;);\nvar ReactMount = require(&quot;./ReactMount&quot;);\nvar ReactPerf = require(&quot;./ReactPerf&quot;);\n\nvar performanceNow = require(&quot;./performanceNow&quot;);\n\nfunction roundFloat(val) {\n  return Math.floor(val * 100) / 100;\n}\n\nvar ReactDefaultPerf = {\n  _allMeasurements: [], // last item in the list is the current one\n  _injected: false,\n\n  start: function() {\n    if (!ReactDefaultPerf._injected) {\n      ReactPerf.injection.injectMeasure(ReactDefaultPerf.measure);\n    }\n\n    ReactDefaultPerf._allMeasurements.length = 0;\n    ReactPerf.enableMeasure = true;\n  },\n\n  stop: function() {\n    ReactPerf.enableMeasure = false;\n  },\n\n  getLastMeasurements: function() {\n    return ReactDefaultPerf._allMeasurements;\n  },\n\n  printExclusive: function(measurements) {\n    measurements = measurements || ReactDefaultPerf._allMeasurements;\n    var summary = ReactDefaultPerfAnalysis.getExclusiveSummary(measurements);\n    console.table(summary.map(function(item) {\n      return {\n        &apos;Component class name&apos;: item.componentName,\n        &apos;Total inclusive time (ms)&apos;: roundFloat(item.inclusive),\n        &apos;Total exclusive time (ms)&apos;: roundFloat(item.exclusive),\n        &apos;Exclusive time per instance (ms)&apos;: roundFloat(item.exclusive / item.count),\n        &apos;Instances&apos;: item.count\n      };\n    }));\n    console.log(\n      &apos;Total time:&apos;,\n      ReactDefaultPerfAnalysis.getTotalTime(measurements).toFixed(2) + &apos; ms&apos;\n    );\n  },\n\n  printInclusive: function(measurements) {\n    measurements = measurements || ReactDefaultPerf._allMeasurements;\n    var summary = ReactDefaultPerfAnalysis.getInclusiveSummary(measurements);\n    console.table(summary.map(function(item) {\n      return {\n        &apos;Owner &gt; component&apos;: item.componentName,\n        &apos;Inclusive time (ms)&apos;: roundFloat(item.time),\n        &apos;Instances&apos;: item.count\n      };\n    }));\n    console.log(\n      &apos;Total time:&apos;,\n      ReactDefaultPerfAnalysis.getTotalTime(measurements).toFixed(2) + &apos; ms&apos;\n    );\n  },\n\n  printWasted: function(measurements) {\n    measurements = measurements || ReactDefaultPerf._allMeasurements;\n    var summary = ReactDefaultPerfAnalysis.getInclusiveSummary(\n      measurements,\n      true\n    );\n    console.table(summary.map(function(item) {\n      return {\n        &apos;Owner &gt; component&apos;: item.componentName,\n        &apos;Wasted time (ms)&apos;: item.time,\n        &apos;Instances&apos;: item.count\n      };\n    }));\n    console.log(\n      &apos;Total time:&apos;,\n      ReactDefaultPerfAnalysis.getTotalTime(measurements).toFixed(2) + &apos; ms&apos;\n    );\n  },\n\n  printDOM: function(measurements) {\n    measurements = measurements || ReactDefaultPerf._allMeasurements;\n    var summary = ReactDefaultPerfAnalysis.getDOMSummary(measurements);\n    console.table(summary.map(function(item) {\n      var result = {};\n      result[DOMProperty.ID_ATTRIBUTE_NAME] = item.id;\n      result[&apos;type&apos;] = item.type;\n      result[&apos;args&apos;] = JSON.stringify(item.args);\n      return result;\n    }));\n    console.log(\n      &apos;Total time:&apos;,\n      ReactDefaultPerfAnalysis.getTotalTime(measurements).toFixed(2) + &apos; ms&apos;\n    );\n  },\n\n  _recordWrite: function(id, fnName, totalTime, args) {\n    // TODO: totalTime isn&apos;t that useful since it doesn&apos;t count paints/reflows\n    var writes =\n      ReactDefaultPerf\n        ._allMeasurements[ReactDefaultPerf._allMeasurements.length - 1]\n        .writes;\n    writes[id] = writes[id] || [];\n    writes[id].push({\n      type: fnName,\n      time: totalTime,\n      args: args\n    });\n  },\n\n  measure: function(moduleName, fnName, func) {\n    return function() {var args=Array.prototype.slice.call(arguments,0);\n      var totalTime;\n      var rv;\n      var start;\n\n      if (fnName === &apos;_renderNewRootComponent&apos; ||\n          fnName === &apos;flushBatchedUpdates&apos;) {\n        // A &quot;measurement&quot; is a set of metrics recorded for each flush. We want\n        // to group the metrics for a given flush together so we can look at the\n        // components that rendered and the DOM operations that actually\n        // happened to determine the amount of &quot;wasted work&quot; performed.\n        ReactDefaultPerf._allMeasurements.push({\n          exclusive: {},\n          inclusive: {},\n          counts: {},\n          writes: {},\n          displayNames: {},\n          totalTime: 0\n        });\n        start = performanceNow();\n        rv = func.apply(this, args);\n        ReactDefaultPerf._allMeasurements[\n          ReactDefaultPerf._allMeasurements.length - 1\n        ].totalTime = performanceNow() - start;\n        return rv;\n      } else if (moduleName === &apos;ReactDOMIDOperations&apos; ||\n        moduleName === &apos;ReactComponentBrowserEnvironment&apos;) {\n        start = performanceNow();\n        rv = func.apply(this, args);\n        totalTime = performanceNow() - start;\n\n        if (fnName === &apos;mountImageIntoNode&apos;) {\n          var mountID = ReactMount.getID(args[1]);\n          ReactDefaultPerf._recordWrite(mountID, fnName, totalTime, args[0]);\n        } else if (fnName === &apos;dangerouslyProcessChildrenUpdates&apos;) {\n          // special format\n          args[0].forEach(function(update) {\n            var writeArgs = {};\n            if (update.fromIndex !== null) {\n              writeArgs.fromIndex = update.fromIndex;\n            }\n            if (update.toIndex !== null) {\n              writeArgs.toIndex = update.toIndex;\n            }\n            if (update.textContent !== null) {\n              writeArgs.textContent = update.textContent;\n            }\n            if (update.markupIndex !== null) {\n              writeArgs.markup = args[1][update.markupIndex];\n            }\n            ReactDefaultPerf._recordWrite(\n              update.parentID,\n              update.type,\n              totalTime,\n              writeArgs\n            );\n          });\n        } else {\n          // basic format\n          ReactDefaultPerf._recordWrite(\n            args[0],\n            fnName,\n            totalTime,\n            Array.prototype.slice.call(args, 1)\n          );\n        }\n        return rv;\n      } else if (moduleName === &apos;ReactCompositeComponent&apos; &amp;&amp; (\n        fnName === &apos;mountComponent&apos; ||\n        fnName === &apos;updateComponent&apos; || // TODO: receiveComponent()?\n        fnName === &apos;_renderValidatedComponent&apos;)) {\n\n        var rootNodeID = fnName === &apos;mountComponent&apos; ?\n          args[0] :\n          this._rootNodeID;\n        var isRender = fnName === &apos;_renderValidatedComponent&apos;;\n        var entry = ReactDefaultPerf._allMeasurements[\n          ReactDefaultPerf._allMeasurements.length - 1\n        ];\n\n        if (isRender) {\n          entry.counts[rootNodeID] = entry.counts[rootNodeID] || 0;\n          entry.counts[rootNodeID] += 1;\n        }\n\n        start = performanceNow();\n        rv = func.apply(this, args);\n        totalTime = performanceNow() - start;\n\n        var typeOfLog = isRender ? entry.exclusive : entry.inclusive;\n        typeOfLog[rootNodeID] = typeOfLog[rootNodeID] || 0;\n        typeOfLog[rootNodeID] += totalTime;\n\n        entry.displayNames[rootNodeID] = {\n          current: this.constructor.displayName,\n          owner: this._owner ? this._owner.constructor.displayName : &apos;&lt;root&gt;&apos;\n        };\n\n        return rv;\n      } else {\n        return func.apply(this, args);\n      }\n    };\n  }\n};\n\nmodule.exports = ReactDefaultPerf;\n\n},{&quot;./DOMProperty&quot;:8,&quot;./ReactDefaultPerfAnalysis&quot;:46,&quot;./ReactMount&quot;:55,&quot;./ReactPerf&quot;:60,&quot;./performanceNow&quot;:124}],46:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactDefaultPerfAnalysis\n */\n\nvar merge = require(&quot;./merge&quot;);\n\n// Don&apos;t try to save users less than 1.2ms (a number I made up)\nvar DONT_CARE_THRESHOLD = 1.2;\nvar DOM_OPERATION_TYPES = {\n  &apos;mountImageIntoNode&apos;: &apos;set innerHTML&apos;,\n  INSERT_MARKUP: &apos;set innerHTML&apos;,\n  MOVE_EXISTING: &apos;move&apos;,\n  REMOVE_NODE: &apos;remove&apos;,\n  TEXT_CONTENT: &apos;set textContent&apos;,\n  &apos;updatePropertyByID&apos;: &apos;update attribute&apos;,\n  &apos;deletePropertyByID&apos;: &apos;delete attribute&apos;,\n  &apos;updateStylesByID&apos;: &apos;update styles&apos;,\n  &apos;updateInnerHTMLByID&apos;: &apos;set innerHTML&apos;,\n  &apos;dangerouslyReplaceNodeWithMarkupByID&apos;: &apos;replace&apos;\n};\n\nfunction getTotalTime(measurements) {\n  // TODO: return number of DOM ops? could be misleading.\n  // TODO: measure dropped frames after reconcile?\n  // TODO: log total time of each reconcile and the top-level component\n  // class that triggered it.\n  var totalTime = 0;\n  for (var i = 0; i &lt; measurements.length; i++) {\n    var measurement = measurements[i];\n    totalTime += measurement.totalTime;\n  }\n  return totalTime;\n}\n\nfunction getDOMSummary(measurements) {\n  var items = [];\n  for (var i = 0; i &lt; measurements.length; i++) {\n    var measurement = measurements[i];\n    var id;\n\n    for (id in measurement.writes) {\n      measurement.writes[id].forEach(function(write) {\n        items.push({\n          id: id,\n          type: DOM_OPERATION_TYPES[write.type] || write.type,\n          args: write.args\n        });\n      });\n    }\n  }\n  return items;\n}\n\nfunction getExclusiveSummary(measurements) {\n  var candidates = {};\n  var displayName;\n\n  for (var i = 0; i &lt; measurements.length; i++) {\n    var measurement = measurements[i];\n    var allIDs = merge(measurement.exclusive, measurement.inclusive);\n\n    for (var id in allIDs) {\n      displayName = measurement.displayNames[id].current;\n\n      candidates[displayName] = candidates[displayName] || {\n        componentName: displayName,\n        inclusive: 0,\n        exclusive: 0,\n        count: 0\n      };\n      if (measurement.exclusive[id]) {\n        candidates[displayName].exclusive += measurement.exclusive[id];\n      }\n      if (measurement.inclusive[id]) {\n        candidates[displayName].inclusive += measurement.inclusive[id];\n      }\n      if (measurement.counts[id]) {\n        candidates[displayName].count += measurement.counts[id];\n      }\n    }\n  }\n\n  // Now make a sorted array with the results.\n  var arr = [];\n  for (displayName in candidates) {\n    if (candidates[displayName].exclusive &gt;= DONT_CARE_THRESHOLD) {\n      arr.push(candidates[displayName]);\n    }\n  }\n\n  arr.sort(function(a, b) {\n    return b.exclusive - a.exclusive;\n  });\n\n  return arr;\n}\n\nfunction getInclusiveSummary(measurements, onlyClean) {\n  var candidates = {};\n  var inclusiveKey;\n\n  for (var i = 0; i &lt; measurements.length; i++) {\n    var measurement = measurements[i];\n    var allIDs = merge(measurement.exclusive, measurement.inclusive);\n    var cleanComponents;\n\n    if (onlyClean) {\n      cleanComponents = getUnchangedComponents(measurement);\n    }\n\n    for (var id in allIDs) {\n      if (onlyClean &amp;&amp; !cleanComponents[id]) {\n        continue;\n      }\n\n      var displayName = measurement.displayNames[id];\n\n      // Inclusive time is not useful for many components without knowing where\n      // they are instantiated. So we aggregate inclusive time with both the\n      // owner and current displayName as the key.\n      inclusiveKey = displayName.owner + &apos; &gt; &apos; + displayName.current;\n\n      candidates[inclusiveKey] = candidates[inclusiveKey] || {\n        componentName: inclusiveKey,\n        time: 0,\n        count: 0\n      };\n\n      if (measurement.inclusive[id]) {\n        candidates[inclusiveKey].time += measurement.inclusive[id];\n      }\n      if (measurement.counts[id]) {\n        candidates[inclusiveKey].count += measurement.counts[id];\n      }\n    }\n  }\n\n  // Now make a sorted array with the results.\n  var arr = [];\n  for (inclusiveKey in candidates) {\n    if (candidates[inclusiveKey].time &gt;= DONT_CARE_THRESHOLD) {\n      arr.push(candidates[inclusiveKey]);\n    }\n  }\n\n  arr.sort(function(a, b) {\n    return b.time - a.time;\n  });\n\n  return arr;\n}\n\nfunction getUnchangedComponents(measurement) {\n  // For a given reconcile, look at which components did not actually\n  // render anything to the DOM and return a mapping of their ID to\n  // the amount of time it took to render the entire subtree.\n  var cleanComponents = {};\n  var dirtyLeafIDs = Object.keys(measurement.writes);\n  var allIDs = merge(measurement.exclusive, measurement.inclusive);\n\n  for (var id in allIDs) {\n    var isDirty = false;\n    // For each component that rendered, see if a component that triggerd\n    // a DOM op is in its subtree.\n    for (var i = 0; i &lt; dirtyLeafIDs.length; i++) {\n      if (dirtyLeafIDs[i].indexOf(id) === 0) {\n        isDirty = true;\n        break;\n      }\n    }\n    if (!isDirty &amp;&amp; measurement.counts[id] &gt; 0) {\n      cleanComponents[id] = true;\n    }\n  }\n  return cleanComponents;\n}\n\nvar ReactDefaultPerfAnalysis = {\n  getExclusiveSummary: getExclusiveSummary,\n  getInclusiveSummary: getInclusiveSummary,\n  getDOMSummary: getDOMSummary,\n  getTotalTime: getTotalTime\n};\n\nmodule.exports = ReactDefaultPerfAnalysis;\n\n},{&quot;./merge&quot;:117}],47:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactErrorUtils\n * @typechecks\n */\n\n&quot;use strict&quot;;\n\nvar ReactErrorUtils = {\n  /**\n   * Creates a guarded version of a function. This is supposed to make debugging\n   * of event handlers easier. To aid debugging with the browser&apos;s debugger,\n   * this currently simply returns the original function.\n   *\n   * @param {function} func Function to be executed\n   * @param {string} name The name of the guard\n   * @return {function}\n   */\n  guard: function(func, name) {\n    return func;\n  }\n};\n\nmodule.exports = ReactErrorUtils;\n\n},{}],48:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactEventEmitter\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar EventConstants = require(&quot;./EventConstants&quot;);\nvar EventListener = require(&quot;./EventListener&quot;);\nvar EventPluginHub = require(&quot;./EventPluginHub&quot;);\nvar EventPluginRegistry = require(&quot;./EventPluginRegistry&quot;);\nvar ExecutionEnvironment = require(&quot;./ExecutionEnvironment&quot;);\nvar ReactEventEmitterMixin = require(&quot;./ReactEventEmitterMixin&quot;);\nvar ViewportMetrics = require(&quot;./ViewportMetrics&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\nvar isEventSupported = require(&quot;./isEventSupported&quot;);\nvar merge = require(&quot;./merge&quot;);\n\n/**\n * Summary of `ReactEventEmitter` event handling:\n *\n *  - Top-level delegation is used to trap native browser events. We normalize\n *    and de-duplicate events to account for browser quirks.\n *\n *  - Forward these native events (with the associated top-level type used to\n *    trap it) to `EventPluginHub`, which in turn will ask plugins if they want\n *    to extract any synthetic events.\n *\n *  - The `EventPluginHub` will then process each event by annotating them with\n *    &quot;dispatches&quot;, a sequence of listeners and IDs that care about that event.\n *\n *  - The `EventPluginHub` then dispatches the events.\n *\n * Overview of React and the event system:\n *\n *                   .\n * +------------+    .\n * |    DOM     |    .\n * +------------+    .                         +-----------+\n *       +           .               +--------+|SimpleEvent|\n *       |           .               |         |Plugin     |\n * +-----|------+    .               v         +-----------+\n * |     |      |    .    +--------------+                    +------------+\n * |     +-----------.---&gt;|EventPluginHub|                    |    Event   |\n * |            |    .    |              |     +-----------+  | Propagators|\n * | ReactEvent |    .    |              |     |TapEvent   |  |------------|\n * |  Emitter   |    .    |              |&lt;---+|Plugin     |  |other plugin|\n * |            |    .    |              |     +-----------+  |  utilities |\n * |     +-----------.---&gt;|              |                    +------------+\n * |     |      |    .    +--------------+\n * +-----|------+    .                ^        +-----------+\n *       |           .                |        |Enter/Leave|\n *       +           .                +-------+|Plugin     |\n * +-------------+   .                         +-----------+\n * | application |   .\n * |-------------|   .\n * |             |   .\n * |             |   .\n * +-------------+   .\n *                   .\n *    React Core     .  General Purpose Event Plugin System\n */\n\nvar alreadyListeningTo = {};\nvar isMonitoringScrollValue = false;\nvar reactTopListenersCounter = 0;\n\n// For events like &apos;submit&apos; which don&apos;t consistently bubble (which we trap at a\n// lower node than `document`), binding at `document` would cause duplicate\n// events so we don&apos;t include them here\nvar topEventMapping = {\n  topBlur: &apos;blur&apos;,\n  topChange: &apos;change&apos;,\n  topClick: &apos;click&apos;,\n  topCompositionEnd: &apos;compositionend&apos;,\n  topCompositionStart: &apos;compositionstart&apos;,\n  topCompositionUpdate: &apos;compositionupdate&apos;,\n  topContextMenu: &apos;contextmenu&apos;,\n  topCopy: &apos;copy&apos;,\n  topCut: &apos;cut&apos;,\n  topDoubleClick: &apos;dblclick&apos;,\n  topDrag: &apos;drag&apos;,\n  topDragEnd: &apos;dragend&apos;,\n  topDragEnter: &apos;dragenter&apos;,\n  topDragExit: &apos;dragexit&apos;,\n  topDragLeave: &apos;dragleave&apos;,\n  topDragOver: &apos;dragover&apos;,\n  topDragStart: &apos;dragstart&apos;,\n  topDrop: &apos;drop&apos;,\n  topFocus: &apos;focus&apos;,\n  topInput: &apos;input&apos;,\n  topKeyDown: &apos;keydown&apos;,\n  topKeyPress: &apos;keypress&apos;,\n  topKeyUp: &apos;keyup&apos;,\n  topMouseDown: &apos;mousedown&apos;,\n  topMouseMove: &apos;mousemove&apos;,\n  topMouseOut: &apos;mouseout&apos;,\n  topMouseOver: &apos;mouseover&apos;,\n  topMouseUp: &apos;mouseup&apos;,\n  topPaste: &apos;paste&apos;,\n  topScroll: &apos;scroll&apos;,\n  topSelectionChange: &apos;selectionchange&apos;,\n  topTouchCancel: &apos;touchcancel&apos;,\n  topTouchEnd: &apos;touchend&apos;,\n  topTouchMove: &apos;touchmove&apos;,\n  topTouchStart: &apos;touchstart&apos;,\n  topWheel: &apos;wheel&apos;\n};\n\n/**\n * To ensure no conflicts with other potential React instances on the page\n */\nvar topListenersIDKey = &quot;_reactListenersID&quot; + String(Math.random()).slice(2);\n\nfunction getListeningForDocument(mountAt) {\n  if (mountAt[topListenersIDKey] == null) {\n    mountAt[topListenersIDKey] = reactTopListenersCounter++;\n    alreadyListeningTo[mountAt[topListenersIDKey]] = {};\n  }\n  return alreadyListeningTo[mountAt[topListenersIDKey]];\n}\n\n/**\n * Traps top-level events by using event bubbling.\n *\n * @param {string} topLevelType Record from `EventConstants`.\n * @param {string} handlerBaseName Event name (e.g. &quot;click&quot;).\n * @param {DOMEventTarget} element Element on which to attach listener.\n * @internal\n */\nfunction trapBubbledEvent(topLevelType, handlerBaseName, element) {\n  EventListener.listen(\n    element,\n    handlerBaseName,\n    ReactEventEmitter.TopLevelCallbackCreator.createTopLevelCallback(\n      topLevelType\n    )\n  );\n}\n\n/**\n * Traps a top-level event by using event capturing.\n *\n * @param {string} topLevelType Record from `EventConstants`.\n * @param {string} handlerBaseName Event name (e.g. &quot;click&quot;).\n * @param {DOMEventTarget} element Element on which to attach listener.\n * @internal\n */\nfunction trapCapturedEvent(topLevelType, handlerBaseName, element) {\n  EventListener.capture(\n    element,\n    handlerBaseName,\n    ReactEventEmitter.TopLevelCallbackCreator.createTopLevelCallback(\n      topLevelType\n    )\n  );\n}\n\n/**\n * `ReactEventEmitter` is used to attach top-level event listeners. For example:\n *\n *   ReactEventEmitter.putListener(&apos;myID&apos;, &apos;onClick&apos;, myFunction);\n *\n * This would allocate a &quot;registration&quot; of `(&apos;onClick&apos;, myFunction)` on &apos;myID&apos;.\n *\n * @internal\n */\nvar ReactEventEmitter = merge(ReactEventEmitterMixin, {\n\n  /**\n   * React references `ReactEventTopLevelCallback` using this property in order\n   * to allow dependency injection.\n   */\n  TopLevelCallbackCreator: null,\n\n  injection: {\n    /**\n     * @param {function} TopLevelCallbackCreator\n     */\n    injectTopLevelCallbackCreator: function(TopLevelCallbackCreator) {\n      ReactEventEmitter.TopLevelCallbackCreator = TopLevelCallbackCreator;\n    }\n  },\n\n  /**\n   * Sets whether or not any created callbacks should be enabled.\n   *\n   * @param {boolean} enabled True if callbacks should be enabled.\n   */\n  setEnabled: function(enabled) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      ExecutionEnvironment.canUseDOM,\n      &apos;setEnabled(...): Cannot toggle event listening in a Worker thread. &apos; +\n      &apos;This is likely a bug in the framework. Please report immediately.&apos;\n    ) : invariant(ExecutionEnvironment.canUseDOM));\n    if (ReactEventEmitter.TopLevelCallbackCreator) {\n      ReactEventEmitter.TopLevelCallbackCreator.setEnabled(enabled);\n    }\n  },\n\n  /**\n   * @return {boolean} True if callbacks are enabled.\n   */\n  isEnabled: function() {\n    return !!(\n      ReactEventEmitter.TopLevelCallbackCreator &amp;&amp;\n      ReactEventEmitter.TopLevelCallbackCreator.isEnabled()\n    );\n  },\n\n  /**\n   * We listen for bubbled touch events on the document object.\n   *\n   * Firefox v8.01 (and possibly others) exhibited strange behavior when\n   * mounting `onmousemove` events at some node that was not the document\n   * element. The symptoms were that if your mouse is not moving over something\n   * contained within that mount point (for example on the background) the\n   * top-level listeners for `onmousemove` won&apos;t be called. However, if you\n   * register the `mousemove` on the document object, then it will of course\n   * catch all `mousemove`s. This along with iOS quirks, justifies restricting\n   * top-level listeners to the document object only, at least for these\n   * movement types of events and possibly all events.\n   *\n   * @see http://www.quirksmode.org/blog/archives/2010/09/click_event_del.html\n   *\n   * Also, `keyup`/`keypress`/`keydown` do not bubble to the window on IE, but\n   * they bubble to document.\n   *\n   * @param {string} registrationName Name of listener (e.g. `onClick`).\n   * @param {DOMDocument} contentDocument Document which owns the container\n   */\n  listenTo: function(registrationName, contentDocument) {\n    var mountAt = contentDocument;\n    var isListening = getListeningForDocument(mountAt);\n    var dependencies = EventPluginRegistry.\n      registrationNameDependencies[registrationName];\n\n    var topLevelTypes = EventConstants.topLevelTypes;\n    for (var i = 0, l = dependencies.length; i &lt; l; i++) {\n      var dependency = dependencies[i];\n      if (!isListening[dependency]) {\n        var topLevelType = topLevelTypes[dependency];\n\n        if (topLevelType === topLevelTypes.topWheel) {\n          if (isEventSupported(&apos;wheel&apos;)) {\n            trapBubbledEvent(topLevelTypes.topWheel, &apos;wheel&apos;, mountAt);\n          } else if (isEventSupported(&apos;mousewheel&apos;)) {\n            trapBubbledEvent(topLevelTypes.topWheel, &apos;mousewheel&apos;, mountAt);\n          } else {\n            // Firefox needs to capture a different mouse scroll event.\n            // @see http://www.quirksmode.org/dom/events/tests/scroll.html\n            trapBubbledEvent(\n              topLevelTypes.topWheel,\n              &apos;DOMMouseScroll&apos;,\n              mountAt);\n          }\n        } else if (topLevelType === topLevelTypes.topScroll) {\n\n          if (isEventSupported(&apos;scroll&apos;, true)) {\n            trapCapturedEvent(topLevelTypes.topScroll, &apos;scroll&apos;, mountAt);\n          } else {\n            trapBubbledEvent(topLevelTypes.topScroll, &apos;scroll&apos;, window);\n          }\n        } else if (topLevelType === topLevelTypes.topFocus ||\n            topLevelType === topLevelTypes.topBlur) {\n\n          if (isEventSupported(&apos;focus&apos;, true)) {\n            trapCapturedEvent(topLevelTypes.topFocus, &apos;focus&apos;, mountAt);\n            trapCapturedEvent(topLevelTypes.topBlur, &apos;blur&apos;, mountAt);\n          } else if (isEventSupported(&apos;focusin&apos;)) {\n            // IE has `focusin` and `focusout` events which bubble.\n            // @see http://www.quirksmode.org/blog/archives/2008/04/delegating_the.html\n            trapBubbledEvent(topLevelTypes.topFocus, &apos;focusin&apos;, mountAt);\n            trapBubbledEvent(topLevelTypes.topBlur, &apos;focusout&apos;, mountAt);\n          }\n\n          // to make sure blur and focus event listeners are only attached once\n          isListening[topLevelTypes.topBlur] = true;\n          isListening[topLevelTypes.topFocus] = true;\n        } else if (topEventMapping[dependency]) {\n          trapBubbledEvent(topLevelType, topEventMapping[dependency], mountAt);\n        }\n\n        isListening[dependency] = true;\n      }\n    }\n  },\n\n  /**\n   * Listens to window scroll and resize events. We cache scroll values so that\n   * application code can access them without triggering reflows.\n   *\n   * NOTE: Scroll events do not bubble.\n   *\n   * @see http://www.quirksmode.org/dom/events/scroll.html\n   */\n  ensureScrollValueMonitoring: function(){\n    if (!isMonitoringScrollValue) {\n      var refresh = ViewportMetrics.refreshScrollValues;\n      EventListener.listen(window, &apos;scroll&apos;, refresh);\n      EventListener.listen(window, &apos;resize&apos;, refresh);\n      isMonitoringScrollValue = true;\n    }\n  },\n\n  eventNameDispatchConfigs: EventPluginHub.eventNameDispatchConfigs,\n\n  registrationNameModules: EventPluginHub.registrationNameModules,\n\n  putListener: EventPluginHub.putListener,\n\n  getListener: EventPluginHub.getListener,\n\n  deleteListener: EventPluginHub.deleteListener,\n\n  deleteAllListeners: EventPluginHub.deleteAllListeners,\n\n  trapBubbledEvent: trapBubbledEvent,\n\n  trapCapturedEvent: trapCapturedEvent\n\n});\n\nmodule.exports = ReactEventEmitter;\n\n},{&quot;./EventConstants&quot;:14,&quot;./EventListener&quot;:15,&quot;./EventPluginHub&quot;:16,&quot;./EventPluginRegistry&quot;:17,&quot;./ExecutionEnvironment&quot;:20,&quot;./ReactEventEmitterMixin&quot;:49,&quot;./ViewportMetrics&quot;:85,&quot;./invariant&quot;:108,&quot;./isEventSupported&quot;:109,&quot;./merge&quot;:117}],49:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactEventEmitterMixin\n */\n\n&quot;use strict&quot;;\n\nvar EventPluginHub = require(&quot;./EventPluginHub&quot;);\nvar ReactUpdates = require(&quot;./ReactUpdates&quot;);\n\nfunction runEventQueueInBatch(events) {\n  EventPluginHub.enqueueEvents(events);\n  EventPluginHub.processEventQueue();\n}\n\nvar ReactEventEmitterMixin = {\n\n  /**\n   * Streams a fired top-level event to `EventPluginHub` where plugins have the\n   * opportunity to create `ReactEvent`s to be dispatched.\n   *\n   * @param {string} topLevelType Record from `EventConstants`.\n   * @param {object} topLevelTarget The listening component root node.\n   * @param {string} topLevelTargetID ID of `topLevelTarget`.\n   * @param {object} nativeEvent Native environment event.\n   */\n  handleTopLevel: function(\n      topLevelType,\n      topLevelTarget,\n      topLevelTargetID,\n      nativeEvent) {\n    var events = EventPluginHub.extractEvents(\n      topLevelType,\n      topLevelTarget,\n      topLevelTargetID,\n      nativeEvent\n    );\n\n    // Event queue being processed in the same cycle allows `preventDefault`.\n    ReactUpdates.batchedUpdates(runEventQueueInBatch, events);\n  }\n};\n\nmodule.exports = ReactEventEmitterMixin;\n\n},{&quot;./EventPluginHub&quot;:16,&quot;./ReactUpdates&quot;:70}],50:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactEventTopLevelCallback\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar PooledClass = require(&quot;./PooledClass&quot;);\nvar ReactEventEmitter = require(&quot;./ReactEventEmitter&quot;);\nvar ReactInstanceHandles = require(&quot;./ReactInstanceHandles&quot;);\nvar ReactMount = require(&quot;./ReactMount&quot;);\n\nvar getEventTarget = require(&quot;./getEventTarget&quot;);\nvar mixInto = require(&quot;./mixInto&quot;);\n\n/**\n * @type {boolean}\n * @private\n */\nvar _topLevelListenersEnabled = true;\n\n/**\n * Finds the parent React component of `node`.\n *\n * @param {*} node\n * @return {?DOMEventTarget} Parent container, or `null` if the specified node\n *                           is not nested.\n */\nfunction findParent(node) {\n  // TODO: It may be a good idea to cache this to prevent unnecessary DOM\n  // traversal, but caching is difficult to do correctly without using a\n  // mutation observer to listen for all DOM changes.\n  var nodeID = ReactMount.getID(node);\n  var rootID = ReactInstanceHandles.getReactRootIDFromNodeID(nodeID);\n  var container = ReactMount.findReactContainerForID(rootID);\n  var parent = ReactMount.getFirstReactDOM(container);\n  return parent;\n}\n\n/**\n * Calls ReactEventEmitter.handleTopLevel for each node stored in bookKeeping&apos;s\n * ancestor list. Separated from createTopLevelCallback to avoid try/finally\n * deoptimization.\n *\n * @param {string} topLevelType\n * @param {DOMEvent} nativeEvent\n * @param {TopLevelCallbackBookKeeping} bookKeeping\n */\nfunction handleTopLevelImpl(topLevelType, nativeEvent, bookKeeping) {\n  var topLevelTarget = ReactMount.getFirstReactDOM(\n    getEventTarget(nativeEvent)\n  ) || window;\n\n  // Loop through the hierarchy, in case there&apos;s any nested components.\n  // It&apos;s important that we build the array of ancestors before calling any\n  // event handlers, because event handlers can modify the DOM, leading to\n  // inconsistencies with ReactMount&apos;s node cache. See #1105.\n  var ancestor = topLevelTarget;\n  while (ancestor) {\n    bookKeeping.ancestors.push(ancestor);\n    ancestor = findParent(ancestor);\n  }\n\n  for (var i = 0, l = bookKeeping.ancestors.length; i &lt; l; i++) {\n    topLevelTarget = bookKeeping.ancestors[i];\n    var topLevelTargetID = ReactMount.getID(topLevelTarget) || &apos;&apos;;\n    ReactEventEmitter.handleTopLevel(\n      topLevelType,\n      topLevelTarget,\n      topLevelTargetID,\n      nativeEvent\n    );\n  }\n}\n\n// Used to store ancestor hierarchy in top level callback\nfunction TopLevelCallbackBookKeeping() {\n  this.ancestors = [];\n}\nmixInto(TopLevelCallbackBookKeeping, {\n  destructor: function() {\n    this.ancestors.length = 0;\n  }\n});\nPooledClass.addPoolingTo(TopLevelCallbackBookKeeping);\n\n/**\n * Top-level callback creator used to implement event handling using delegation.\n * This is used via dependency injection.\n */\nvar ReactEventTopLevelCallback = {\n\n  /**\n   * Sets whether or not any created callbacks should be enabled.\n   *\n   * @param {boolean} enabled True if callbacks should be enabled.\n   */\n  setEnabled: function(enabled) {\n    _topLevelListenersEnabled = !!enabled;\n  },\n\n  /**\n   * @return {boolean} True if callbacks are enabled.\n   */\n  isEnabled: function() {\n    return _topLevelListenersEnabled;\n  },\n\n  /**\n   * Creates a callback for the supplied `topLevelType` that could be added as\n   * a listener to the document. The callback computes a `topLevelTarget` which\n   * should be the root node of a mounted React component where the listener\n   * is attached.\n   *\n   * @param {string} topLevelType Record from `EventConstants`.\n   * @return {function} Callback for handling top-level events.\n   */\n  createTopLevelCallback: function(topLevelType) {\n    return function(nativeEvent) {\n      if (!_topLevelListenersEnabled) {\n        return;\n      }\n\n      var bookKeeping = TopLevelCallbackBookKeeping.getPooled();\n      try {\n        handleTopLevelImpl(topLevelType, nativeEvent, bookKeeping);\n      } finally {\n        TopLevelCallbackBookKeeping.release(bookKeeping);\n      }\n    };\n  }\n\n};\n\nmodule.exports = ReactEventTopLevelCallback;\n\n},{&quot;./PooledClass&quot;:23,&quot;./ReactEventEmitter&quot;:48,&quot;./ReactInstanceHandles&quot;:53,&quot;./ReactMount&quot;:55,&quot;./getEventTarget&quot;:101,&quot;./mixInto&quot;:120}],51:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactInjection\n */\n\n&quot;use strict&quot;;\n\nvar DOMProperty = require(&quot;./DOMProperty&quot;);\nvar EventPluginHub = require(&quot;./EventPluginHub&quot;);\nvar ReactDOM = require(&quot;./ReactDOM&quot;);\nvar ReactEventEmitter = require(&quot;./ReactEventEmitter&quot;);\nvar ReactPerf = require(&quot;./ReactPerf&quot;);\nvar ReactRootIndex = require(&quot;./ReactRootIndex&quot;);\nvar ReactUpdates = require(&quot;./ReactUpdates&quot;);\n\nvar ReactInjection = {\n  DOMProperty: DOMProperty.injection,\n  EventPluginHub: EventPluginHub.injection,\n  DOM: ReactDOM.injection,\n  EventEmitter: ReactEventEmitter.injection,\n  Perf: ReactPerf.injection,\n  RootIndex: ReactRootIndex.injection,\n  Updates: ReactUpdates.injection\n};\n\nmodule.exports = ReactInjection;\n\n},{&quot;./DOMProperty&quot;:8,&quot;./EventPluginHub&quot;:16,&quot;./ReactDOM&quot;:32,&quot;./ReactEventEmitter&quot;:48,&quot;./ReactPerf&quot;:60,&quot;./ReactRootIndex&quot;:67,&quot;./ReactUpdates&quot;:70}],52:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactInputSelection\n */\n\n&quot;use strict&quot;;\n\nvar ReactDOMSelection = require(&quot;./ReactDOMSelection&quot;);\n\nvar containsNode = require(&quot;./containsNode&quot;);\nvar getActiveElement = require(&quot;./getActiveElement&quot;);\n\nfunction isInDocument(node) {\n  return containsNode(document.documentElement, node);\n}\n\n/**\n * @ReactInputSelection: React input selection module. Based on Selection.js,\n * but modified to be suitable for react and has a couple of bug fixes (doesn&apos;t\n * assume buttons have range selections allowed).\n * Input selection module for React.\n */\nvar ReactInputSelection = {\n\n  hasSelectionCapabilities: function(elem) {\n    return elem &amp;&amp; (\n      (elem.nodeName === &apos;INPUT&apos; &amp;&amp; elem.type === &apos;text&apos;) ||\n      elem.nodeName === &apos;TEXTAREA&apos; ||\n      elem.contentEditable === &apos;true&apos;\n    );\n  },\n\n  getSelectionInformation: function() {\n    var focusedElem = getActiveElement();\n    return {\n      focusedElem: focusedElem,\n      selectionRange:\n          ReactInputSelection.hasSelectionCapabilities(focusedElem) ?\n          ReactInputSelection.getSelection(focusedElem) :\n          null\n    };\n  },\n\n  /**\n   * @restoreSelection: If any selection information was potentially lost,\n   * restore it. This is useful when performing operations that could remove dom\n   * nodes and place them back in, resulting in focus being lost.\n   */\n  restoreSelection: function(priorSelectionInformation) {\n    var curFocusedElem = getActiveElement();\n    var priorFocusedElem = priorSelectionInformation.focusedElem;\n    var priorSelectionRange = priorSelectionInformation.selectionRange;\n    if (curFocusedElem !== priorFocusedElem &amp;&amp;\n        isInDocument(priorFocusedElem)) {\n      if (ReactInputSelection.hasSelectionCapabilities(priorFocusedElem)) {\n        ReactInputSelection.setSelection(\n          priorFocusedElem,\n          priorSelectionRange\n        );\n      }\n      priorFocusedElem.focus();\n    }\n  },\n\n  /**\n   * @getSelection: Gets the selection bounds of a focused textarea, input or\n   * contentEditable node.\n   * -@input: Look up selection bounds of this input\n   * -@return {start: selectionStart, end: selectionEnd}\n   */\n  getSelection: function(input) {\n    var selection;\n\n    if (&apos;selectionStart&apos; in input) {\n      // Modern browser with input or textarea.\n      selection = {\n        start: input.selectionStart,\n        end: input.selectionEnd\n      };\n    } else if (document.selection &amp;&amp; input.nodeName === &apos;INPUT&apos;) {\n      // IE8 input.\n      var range = document.selection.createRange();\n      // There can only be one selection per document in IE, so it must\n      // be in our element.\n      if (range.parentElement() === input) {\n        selection = {\n          start: -range.moveStart(&apos;character&apos;, -input.value.length),\n          end: -range.moveEnd(&apos;character&apos;, -input.value.length)\n        };\n      }\n    } else {\n      // Content editable or old IE textarea.\n      selection = ReactDOMSelection.getOffsets(input);\n    }\n\n    return selection || {start: 0, end: 0};\n  },\n\n  /**\n   * @setSelection: Sets the selection bounds of a textarea or input and focuses\n   * the input.\n   * -@input     Set selection bounds of this input or textarea\n   * -@offsets   Object of same form that is returned from get*\n   */\n  setSelection: function(input, offsets) {\n    var start = offsets.start;\n    var end = offsets.end;\n    if (typeof end === &apos;undefined&apos;) {\n      end = start;\n    }\n\n    if (&apos;selectionStart&apos; in input) {\n      input.selectionStart = start;\n      input.selectionEnd = Math.min(end, input.value.length);\n    } else if (document.selection &amp;&amp; input.nodeName === &apos;INPUT&apos;) {\n      var range = input.createTextRange();\n      range.collapse(true);\n      range.moveStart(&apos;character&apos;, start);\n      range.moveEnd(&apos;character&apos;, end - start);\n      range.select();\n    } else {\n      ReactDOMSelection.setOffsets(input, offsets);\n    }\n  }\n};\n\nmodule.exports = ReactInputSelection;\n\n},{&quot;./ReactDOMSelection&quot;:41,&quot;./containsNode&quot;:88,&quot;./getActiveElement&quot;:99}],53:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactInstanceHandles\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar ReactRootIndex = require(&quot;./ReactRootIndex&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\n\nvar SEPARATOR = &apos;.&apos;;\nvar SEPARATOR_LENGTH = SEPARATOR.length;\n\n/**\n * Maximum depth of traversals before we consider the possibility of a bad ID.\n */\nvar MAX_TREE_DEPTH = 100;\n\n/**\n * Creates a DOM ID prefix to use when mounting React components.\n *\n * @param {number} index A unique integer\n * @return {string} React root ID.\n * @internal\n */\nfunction getReactRootIDString(index) {\n  return SEPARATOR + index.toString(36);\n}\n\n/**\n * Checks if a character in the supplied ID is a separator or the end.\n *\n * @param {string} id A React DOM ID.\n * @param {number} index Index of the character to check.\n * @return {boolean} True if the character is a separator or end of the ID.\n * @private\n */\nfunction isBoundary(id, index) {\n  return id.charAt(index) === SEPARATOR || index === id.length;\n}\n\n/**\n * Checks if the supplied string is a valid React DOM ID.\n *\n * @param {string} id A React DOM ID, maybe.\n * @return {boolean} True if the string is a valid React DOM ID.\n * @private\n */\nfunction isValidID(id) {\n  return id === &apos;&apos; || (\n    id.charAt(0) === SEPARATOR &amp;&amp; id.charAt(id.length - 1) !== SEPARATOR\n  );\n}\n\n/**\n * Checks if the first ID is an ancestor of or equal to the second ID.\n *\n * @param {string} ancestorID\n * @param {string} descendantID\n * @return {boolean} True if `ancestorID` is an ancestor of `descendantID`.\n * @internal\n */\nfunction isAncestorIDOf(ancestorID, descendantID) {\n  return (\n    descendantID.indexOf(ancestorID) === 0 &amp;&amp;\n    isBoundary(descendantID, ancestorID.length)\n  );\n}\n\n/**\n * Gets the parent ID of the supplied React DOM ID, `id`.\n *\n * @param {string} id ID of a component.\n * @return {string} ID of the parent, or an empty string.\n * @private\n */\nfunction getParentID(id) {\n  return id ? id.substr(0, id.lastIndexOf(SEPARATOR)) : &apos;&apos;;\n}\n\n/**\n * Gets the next DOM ID on the tree path from the supplied `ancestorID` to the\n * supplied `destinationID`. If they are equal, the ID is returned.\n *\n * @param {string} ancestorID ID of an ancestor node of `destinationID`.\n * @param {string} destinationID ID of the destination node.\n * @return {string} Next ID on the path from `ancestorID` to `destinationID`.\n * @private\n */\nfunction getNextDescendantID(ancestorID, destinationID) {\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    isValidID(ancestorID) &amp;&amp; isValidID(destinationID),\n    &apos;getNextDescendantID(%s, %s): Received an invalid React DOM ID.&apos;,\n    ancestorID,\n    destinationID\n  ) : invariant(isValidID(ancestorID) &amp;&amp; isValidID(destinationID)));\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    isAncestorIDOf(ancestorID, destinationID),\n    &apos;getNextDescendantID(...): React has made an invalid assumption about &apos; +\n    &apos;the DOM hierarchy. Expected `%s` to be an ancestor of `%s`.&apos;,\n    ancestorID,\n    destinationID\n  ) : invariant(isAncestorIDOf(ancestorID, destinationID)));\n  if (ancestorID === destinationID) {\n    return ancestorID;\n  }\n  // Skip over the ancestor and the immediate separator. Traverse until we hit\n  // another separator or we reach the end of `destinationID`.\n  var start = ancestorID.length + SEPARATOR_LENGTH;\n  for (var i = start; i &lt; destinationID.length; i++) {\n    if (isBoundary(destinationID, i)) {\n      break;\n    }\n  }\n  return destinationID.substr(0, i);\n}\n\n/**\n * Gets the nearest common ancestor ID of two IDs.\n *\n * Using this ID scheme, the nearest common ancestor ID is the longest common\n * prefix of the two IDs that immediately preceded a &quot;marker&quot; in both strings.\n *\n * @param {string} oneID\n * @param {string} twoID\n * @return {string} Nearest common ancestor ID, or the empty string if none.\n * @private\n */\nfunction getFirstCommonAncestorID(oneID, twoID) {\n  var minLength = Math.min(oneID.length, twoID.length);\n  if (minLength === 0) {\n    return &apos;&apos;;\n  }\n  var lastCommonMarkerIndex = 0;\n  // Use `&lt;=` to traverse until the &quot;EOL&quot; of the shorter string.\n  for (var i = 0; i &lt;= minLength; i++) {\n    if (isBoundary(oneID, i) &amp;&amp; isBoundary(twoID, i)) {\n      lastCommonMarkerIndex = i;\n    } else if (oneID.charAt(i) !== twoID.charAt(i)) {\n      break;\n    }\n  }\n  var longestCommonID = oneID.substr(0, lastCommonMarkerIndex);\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    isValidID(longestCommonID),\n    &apos;getFirstCommonAncestorID(%s, %s): Expected a valid React DOM ID: %s&apos;,\n    oneID,\n    twoID,\n    longestCommonID\n  ) : invariant(isValidID(longestCommonID)));\n  return longestCommonID;\n}\n\n/**\n * Traverses the parent path between two IDs (either up or down). The IDs must\n * not be the same, and there must exist a parent path between them. If the\n * callback returns `false`, traversal is stopped.\n *\n * @param {?string} start ID at which to start traversal.\n * @param {?string} stop ID at which to end traversal.\n * @param {function} cb Callback to invoke each ID with.\n * @param {?boolean} skipFirst Whether or not to skip the first node.\n * @param {?boolean} skipLast Whether or not to skip the last node.\n * @private\n */\nfunction traverseParentPath(start, stop, cb, arg, skipFirst, skipLast) {\n  start = start || &apos;&apos;;\n  stop = stop || &apos;&apos;;\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    start !== stop,\n    &apos;traverseParentPath(...): Cannot traverse from and to the same ID, `%s`.&apos;,\n    start\n  ) : invariant(start !== stop));\n  var traverseUp = isAncestorIDOf(stop, start);\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    traverseUp || isAncestorIDOf(start, stop),\n    &apos;traverseParentPath(%s, %s, ...): Cannot traverse from two IDs that do &apos; +\n    &apos;not have a parent path.&apos;,\n    start,\n    stop\n  ) : invariant(traverseUp || isAncestorIDOf(start, stop)));\n  // Traverse from `start` to `stop` one depth at a time.\n  var depth = 0;\n  var traverse = traverseUp ? getParentID : getNextDescendantID;\n  for (var id = start; /* until break */; id = traverse(id, stop)) {\n    var ret;\n    if ((!skipFirst || id !== start) &amp;&amp; (!skipLast || id !== stop)) {\n      ret = cb(id, traverseUp, arg);\n    }\n    if (ret === false || id === stop) {\n      // Only break //after// visiting `stop`.\n      break;\n    }\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      depth++ &lt; MAX_TREE_DEPTH,\n      &apos;traverseParentPath(%s, %s, ...): Detected an infinite loop while &apos; +\n      &apos;traversing the React DOM ID tree. This may be due to malformed IDs: %s&apos;,\n      start, stop\n    ) : invariant(depth++ &lt; MAX_TREE_DEPTH));\n  }\n}\n\n/**\n * Manages the IDs assigned to DOM representations of React components. This\n * uses a specific scheme in order to traverse the DOM efficiently (e.g. in\n * order to simulate events).\n *\n * @internal\n */\nvar ReactInstanceHandles = {\n\n  /**\n   * Constructs a React root ID\n   * @return {string} A React root ID.\n   */\n  createReactRootID: function() {\n    return getReactRootIDString(ReactRootIndex.createReactRootIndex());\n  },\n\n  /**\n   * Constructs a React ID by joining a root ID with a name.\n   *\n   * @param {string} rootID Root ID of a parent component.\n   * @param {string} name A component&apos;s name (as flattened children).\n   * @return {string} A React ID.\n   * @internal\n   */\n  createReactID: function(rootID, name) {\n    return rootID + name;\n  },\n\n  /**\n   * Gets the DOM ID of the React component that is the root of the tree that\n   * contains the React component with the supplied DOM ID.\n   *\n   * @param {string} id DOM ID of a React component.\n   * @return {?string} DOM ID of the React component that is the root.\n   * @internal\n   */\n  getReactRootIDFromNodeID: function(id) {\n    if (id &amp;&amp; id.charAt(0) === SEPARATOR &amp;&amp; id.length &gt; 1) {\n      var index = id.indexOf(SEPARATOR, 1);\n      return index &gt; -1 ? id.substr(0, index) : id;\n    }\n    return null;\n  },\n\n  /**\n   * Traverses the ID hierarchy and invokes the supplied `cb` on any IDs that\n   * should would receive a `mouseEnter` or `mouseLeave` event.\n   *\n   * NOTE: Does not invoke the callback on the nearest common ancestor because\n   * nothing &quot;entered&quot; or &quot;left&quot; that element.\n   *\n   * @param {string} leaveID ID being left.\n   * @param {string} enterID ID being entered.\n   * @param {function} cb Callback to invoke on each entered/left ID.\n   * @param {*} upArg Argument to invoke the callback with on left IDs.\n   * @param {*} downArg Argument to invoke the callback with on entered IDs.\n   * @internal\n   */\n  traverseEnterLeave: function(leaveID, enterID, cb, upArg, downArg) {\n    var ancestorID = getFirstCommonAncestorID(leaveID, enterID);\n    if (ancestorID !== leaveID) {\n      traverseParentPath(leaveID, ancestorID, cb, upArg, false, true);\n    }\n    if (ancestorID !== enterID) {\n      traverseParentPath(ancestorID, enterID, cb, downArg, true, false);\n    }\n  },\n\n  /**\n   * Simulates the traversal of a two-phase, capture/bubble event dispatch.\n   *\n   * NOTE: This traversal happens on IDs without touching the DOM.\n   *\n   * @param {string} targetID ID of the target node.\n   * @param {function} cb Callback to invoke.\n   * @param {*} arg Argument to invoke the callback with.\n   * @internal\n   */\n  traverseTwoPhase: function(targetID, cb, arg) {\n    if (targetID) {\n      traverseParentPath(&apos;&apos;, targetID, cb, arg, true, false);\n      traverseParentPath(targetID, &apos;&apos;, cb, arg, false, true);\n    }\n  },\n\n  /**\n   * Traverse a node ID, calling the supplied `cb` for each ancestor ID. For\n   * example, passing `.0.$row-0.1` would result in `cb` getting called\n   * with `.0`, `.0.$row-0`, and `.0.$row-0.1`.\n   *\n   * NOTE: This traversal happens on IDs without touching the DOM.\n   *\n   * @param {string} targetID ID of the target node.\n   * @param {function} cb Callback to invoke.\n   * @param {*} arg Argument to invoke the callback with.\n   * @internal\n   */\n  traverseAncestors: function(targetID, cb, arg) {\n    traverseParentPath(&apos;&apos;, targetID, cb, arg, true, false);\n  },\n\n  /**\n   * Exposed for unit testing.\n   * @private\n   */\n  _getFirstCommonAncestorID: getFirstCommonAncestorID,\n\n  /**\n   * Exposed for unit testing.\n   * @private\n   */\n  _getNextDescendantID: getNextDescendantID,\n\n  isAncestorIDOf: isAncestorIDOf,\n\n  SEPARATOR: SEPARATOR\n\n};\n\nmodule.exports = ReactInstanceHandles;\n\n},{&quot;./ReactRootIndex&quot;:67,&quot;./invariant&quot;:108}],54:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactMarkupChecksum\n */\n\n&quot;use strict&quot;;\n\nvar adler32 = require(&quot;./adler32&quot;);\n\nvar ReactMarkupChecksum = {\n  CHECKSUM_ATTR_NAME: &apos;data-react-checksum&apos;,\n\n  /**\n   * @param {string} markup Markup string\n   * @return {string} Markup string with checksum attribute attached\n   */\n  addChecksumToMarkup: function(markup) {\n    var checksum = adler32(markup);\n    return markup.replace(\n      &apos;&gt;&apos;,\n      &apos; &apos; + ReactMarkupChecksum.CHECKSUM_ATTR_NAME + &apos;=&quot;&apos; + checksum + &apos;&quot;&gt;&apos;\n    );\n  },\n\n  /**\n   * @param {string} markup to use\n   * @param {DOMElement} element root React element\n   * @returns {boolean} whether or not the markup is the same\n   */\n  canReuseMarkup: function(markup, element) {\n    var existingChecksum = element.getAttribute(\n      ReactMarkupChecksum.CHECKSUM_ATTR_NAME\n    );\n    existingChecksum = existingChecksum &amp;&amp; parseInt(existingChecksum, 10);\n    var markupChecksum = adler32(markup);\n    return markupChecksum === existingChecksum;\n  }\n};\n\nmodule.exports = ReactMarkupChecksum;\n\n},{&quot;./adler32&quot;:87}],55:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactMount\n */\n\n&quot;use strict&quot;;\n\nvar DOMProperty = require(&quot;./DOMProperty&quot;);\nvar ReactEventEmitter = require(&quot;./ReactEventEmitter&quot;);\nvar ReactInstanceHandles = require(&quot;./ReactInstanceHandles&quot;);\nvar ReactPerf = require(&quot;./ReactPerf&quot;);\n\nvar containsNode = require(&quot;./containsNode&quot;);\nvar getReactRootElementInContainer = require(&quot;./getReactRootElementInContainer&quot;);\nvar invariant = require(&quot;./invariant&quot;);\nvar shouldUpdateReactComponent = require(&quot;./shouldUpdateReactComponent&quot;);\n\nvar SEPARATOR = ReactInstanceHandles.SEPARATOR;\n\nvar ATTR_NAME = DOMProperty.ID_ATTRIBUTE_NAME;\nvar nodeCache = {};\n\nvar ELEMENT_NODE_TYPE = 1;\nvar DOC_NODE_TYPE = 9;\n\n/** Mapping from reactRootID to React component instance. */\nvar instancesByReactRootID = {};\n\n/** Mapping from reactRootID to `container` nodes. */\nvar containersByReactRootID = {};\n\nif (&quot;production&quot; !== &quot;development&quot;) {\n  /** __DEV__-only mapping from reactRootID to root elements. */\n  var rootElementsByReactRootID = {};\n}\n\n// Used to store breadth-first search state in findComponentRoot.\nvar findComponentRootReusableArray = [];\n\n/**\n * @param {DOMElement} container DOM element that may contain a React component.\n * @return {?string} A &quot;reactRoot&quot; ID, if a React component is rendered.\n */\nfunction getReactRootID(container) {\n  var rootElement = getReactRootElementInContainer(container);\n  return rootElement &amp;&amp; ReactMount.getID(rootElement);\n}\n\n/**\n * Accessing node[ATTR_NAME] or calling getAttribute(ATTR_NAME) on a form\n * element can return its control whose name or ID equals ATTR_NAME. All\n * DOM nodes support `getAttributeNode` but this can also get called on\n * other objects so just return &apos;&apos; if we&apos;re given something other than a\n * DOM node (such as window).\n *\n * @param {?DOMElement|DOMWindow|DOMDocument|DOMTextNode} node DOM node.\n * @return {string} ID of the supplied `domNode`.\n */\nfunction getID(node) {\n  var id = internalGetID(node);\n  if (id) {\n    if (nodeCache.hasOwnProperty(id)) {\n      var cached = nodeCache[id];\n      if (cached !== node) {\n        (&quot;production&quot; !== &quot;development&quot; ? invariant(\n          !isValid(cached, id),\n          &apos;ReactMount: Two valid but unequal nodes with the same `%s`: %s&apos;,\n          ATTR_NAME, id\n        ) : invariant(!isValid(cached, id)));\n\n        nodeCache[id] = node;\n      }\n    } else {\n      nodeCache[id] = node;\n    }\n  }\n\n  return id;\n}\n\nfunction internalGetID(node) {\n  // If node is something like a window, document, or text node, none of\n  // which support attributes or a .getAttribute method, gracefully return\n  // the empty string, as if the attribute were missing.\n  return node &amp;&amp; node.getAttribute &amp;&amp; node.getAttribute(ATTR_NAME) || &apos;&apos;;\n}\n\n/**\n * Sets the React-specific ID of the given node.\n *\n * @param {DOMElement} node The DOM node whose ID will be set.\n * @param {string} id The value of the ID attribute.\n */\nfunction setID(node, id) {\n  var oldID = internalGetID(node);\n  if (oldID !== id) {\n    delete nodeCache[oldID];\n  }\n  node.setAttribute(ATTR_NAME, id);\n  nodeCache[id] = node;\n}\n\n/**\n * Finds the node with the supplied React-generated DOM ID.\n *\n * @param {string} id A React-generated DOM ID.\n * @return {DOMElement} DOM node with the suppled `id`.\n * @internal\n */\nfunction getNode(id) {\n  if (!nodeCache.hasOwnProperty(id) || !isValid(nodeCache[id], id)) {\n    nodeCache[id] = ReactMount.findReactNodeByID(id);\n  }\n  return nodeCache[id];\n}\n\n/**\n * A node is &quot;valid&quot; if it is contained by a currently mounted container.\n *\n * This means that the node does not have to be contained by a document in\n * order to be considered valid.\n *\n * @param {?DOMElement} node The candidate DOM node.\n * @param {string} id The expected ID of the node.\n * @return {boolean} Whether the node is contained by a mounted container.\n */\nfunction isValid(node, id) {\n  if (node) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      internalGetID(node) === id,\n      &apos;ReactMount: Unexpected modification of `%s`&apos;,\n      ATTR_NAME\n    ) : invariant(internalGetID(node) === id));\n\n    var container = ReactMount.findReactContainerForID(id);\n    if (container &amp;&amp; containsNode(container, node)) {\n      return true;\n    }\n  }\n\n  return false;\n}\n\n/**\n * Causes the cache to forget about one React-specific ID.\n *\n * @param {string} id The ID to forget.\n */\nfunction purgeID(id) {\n  delete nodeCache[id];\n}\n\nvar deepestNodeSoFar = null;\nfunction findDeepestCachedAncestorImpl(ancestorID) {\n  var ancestor = nodeCache[ancestorID];\n  if (ancestor &amp;&amp; isValid(ancestor, ancestorID)) {\n    deepestNodeSoFar = ancestor;\n  } else {\n    // This node isn&apos;t populated in the cache, so presumably none of its\n    // descendants are. Break out of the loop.\n    return false;\n  }\n}\n\n/**\n * Return the deepest cached node whose ID is a prefix of `targetID`.\n */\nfunction findDeepestCachedAncestor(targetID) {\n  deepestNodeSoFar = null;\n  ReactInstanceHandles.traverseAncestors(\n    targetID,\n    findDeepestCachedAncestorImpl\n  );\n\n  var foundNode = deepestNodeSoFar;\n  deepestNodeSoFar = null;\n  return foundNode;\n}\n\n/**\n * Mounting is the process of initializing a React component by creatings its\n * representative DOM elements and inserting them into a supplied `container`.\n * Any prior content inside `container` is destroyed in the process.\n *\n *   ReactMount.renderComponent(\n *     component,\n *     document.getElementById(&apos;container&apos;)\n *   );\n *\n *   &lt;div id=&quot;container&quot;&gt;                   &lt;-- Supplied `container`.\n *     &lt;div data-reactid=&quot;.3&quot;&gt;              &lt;-- Rendered reactRoot of React\n *       // ...                                 component.\n *     &lt;/div&gt;\n *   &lt;/div&gt;\n *\n * Inside of `container`, the first element rendered is the &quot;reactRoot&quot;.\n */\nvar ReactMount = {\n  /** Time spent generating markup. */\n  totalInstantiationTime: 0,\n\n  /** Time spent inserting markup into the DOM. */\n  totalInjectionTime: 0,\n\n  /** Whether support for touch events should be initialized. */\n  useTouchEvents: false,\n\n  /** Exposed for debugging purposes **/\n  _instancesByReactRootID: instancesByReactRootID,\n\n  /**\n   * This is a hook provided to support rendering React components while\n   * ensuring that the apparent scroll position of its `container` does not\n   * change.\n   *\n   * @param {DOMElement} container The `container` being rendered into.\n   * @param {function} renderCallback This must be called once to do the render.\n   */\n  scrollMonitor: function(container, renderCallback) {\n    renderCallback();\n  },\n\n  /**\n   * Take a component that&apos;s already mounted into the DOM and replace its props\n   * @param {ReactComponent} prevComponent component instance already in the DOM\n   * @param {ReactComponent} nextComponent component instance to render\n   * @param {DOMElement} container container to render into\n   * @param {?function} callback function triggered on completion\n   */\n  _updateRootComponent: function(\n      prevComponent,\n      nextComponent,\n      container,\n      callback) {\n    var nextProps = nextComponent.props;\n    ReactMount.scrollMonitor(container, function() {\n      prevComponent.replaceProps(nextProps, callback);\n    });\n\n    if (&quot;production&quot; !== &quot;development&quot;) {\n      // Record the root element in case it later gets transplanted.\n      rootElementsByReactRootID[getReactRootID(container)] =\n        getReactRootElementInContainer(container);\n    }\n\n    return prevComponent;\n  },\n\n  /**\n   * Register a component into the instance map and starts scroll value\n   * monitoring\n   * @param {ReactComponent} nextComponent component instance to render\n   * @param {DOMElement} container container to render into\n   * @return {string} reactRoot ID prefix\n   */\n  _registerComponent: function(nextComponent, container) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      container &amp;&amp; (\n        container.nodeType === ELEMENT_NODE_TYPE ||\n        container.nodeType === DOC_NODE_TYPE\n      ),\n      &apos;_registerComponent(...): Target container is not a DOM element.&apos;\n    ) : invariant(container &amp;&amp; (\n      container.nodeType === ELEMENT_NODE_TYPE ||\n      container.nodeType === DOC_NODE_TYPE\n    )));\n\n    ReactEventEmitter.ensureScrollValueMonitoring();\n\n    var reactRootID = ReactMount.registerContainer(container);\n    instancesByReactRootID[reactRootID] = nextComponent;\n    return reactRootID;\n  },\n\n  /**\n   * Render a new component into the DOM.\n   * @param {ReactComponent} nextComponent component instance to render\n   * @param {DOMElement} container container to render into\n   * @param {boolean} shouldReuseMarkup if we should skip the markup insertion\n   * @return {ReactComponent} nextComponent\n   */\n  _renderNewRootComponent: ReactPerf.measure(\n    &apos;ReactMount&apos;,\n    &apos;_renderNewRootComponent&apos;,\n    function(\n        nextComponent,\n        container,\n        shouldReuseMarkup) {\n      var reactRootID = ReactMount._registerComponent(nextComponent, container);\n      nextComponent.mountComponentIntoNode(\n        reactRootID,\n        container,\n        shouldReuseMarkup\n      );\n\n      if (&quot;production&quot; !== &quot;development&quot;) {\n        // Record the root element in case it later gets transplanted.\n        rootElementsByReactRootID[reactRootID] =\n          getReactRootElementInContainer(container);\n      }\n\n      return nextComponent;\n    }\n  ),\n\n  /**\n   * Renders a React component into the DOM in the supplied `container`.\n   *\n   * If the React component was previously rendered into `container`, this will\n   * perform an update on it and only mutate the DOM as necessary to reflect the\n   * latest React component.\n   *\n   * @param {ReactComponent} nextComponent Component instance to render.\n   * @param {DOMElement} container DOM element to render into.\n   * @param {?function} callback function triggered on completion\n   * @return {ReactComponent} Component instance rendered in `container`.\n   */\n  renderComponent: function(nextComponent, container, callback) {\n    var prevComponent = instancesByReactRootID[getReactRootID(container)];\n\n    if (prevComponent) {\n      if (shouldUpdateReactComponent(prevComponent, nextComponent)) {\n        return ReactMount._updateRootComponent(\n          prevComponent,\n          nextComponent,\n          container,\n          callback\n        );\n      } else {\n        ReactMount.unmountComponentAtNode(container);\n      }\n    }\n\n    var reactRootElement = getReactRootElementInContainer(container);\n    var containerHasReactMarkup =\n      reactRootElement &amp;&amp; ReactMount.isRenderedByReact(reactRootElement);\n\n    var shouldReuseMarkup = containerHasReactMarkup &amp;&amp; !prevComponent;\n\n    var component = ReactMount._renderNewRootComponent(\n      nextComponent,\n      container,\n      shouldReuseMarkup\n    );\n    callback &amp;&amp; callback.call(component);\n    return component;\n  },\n\n  /**\n   * Constructs a component instance of `constructor` with `initialProps` and\n   * renders it into the supplied `container`.\n   *\n   * @param {function} constructor React component constructor.\n   * @param {?object} props Initial props of the component instance.\n   * @param {DOMElement} container DOM element to render into.\n   * @return {ReactComponent} Component instance rendered in `container`.\n   */\n  constructAndRenderComponent: function(constructor, props, container) {\n    return ReactMount.renderComponent(constructor(props), container);\n  },\n\n  /**\n   * Constructs a component instance of `constructor` with `initialProps` and\n   * renders it into a container node identified by supplied `id`.\n   *\n   * @param {function} componentConstructor React component constructor\n   * @param {?object} props Initial props of the component instance.\n   * @param {string} id ID of the DOM element to render into.\n   * @return {ReactComponent} Component instance rendered in the container node.\n   */\n  constructAndRenderComponentByID: function(constructor, props, id) {\n    var domNode = document.getElementById(id);\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      domNode,\n      &apos;Tried to get element with id of &quot;%s&quot; but it is not present on the page.&apos;,\n      id\n    ) : invariant(domNode));\n    return ReactMount.constructAndRenderComponent(constructor, props, domNode);\n  },\n\n  /**\n   * Registers a container node into which React components will be rendered.\n   * This also creates the &quot;reactRoot&quot; ID that will be assigned to the element\n   * rendered within.\n   *\n   * @param {DOMElement} container DOM element to register as a container.\n   * @return {string} The &quot;reactRoot&quot; ID of elements rendered within.\n   */\n  registerContainer: function(container) {\n    var reactRootID = getReactRootID(container);\n    if (reactRootID) {\n      // If one exists, make sure it is a valid &quot;reactRoot&quot; ID.\n      reactRootID = ReactInstanceHandles.getReactRootIDFromNodeID(reactRootID);\n    }\n    if (!reactRootID) {\n      // No valid &quot;reactRoot&quot; ID found, create one.\n      reactRootID = ReactInstanceHandles.createReactRootID();\n    }\n    containersByReactRootID[reactRootID] = container;\n    return reactRootID;\n  },\n\n  /**\n   * Unmounts and destroys the React component rendered in the `container`.\n   *\n   * @param {DOMElement} container DOM element containing a React component.\n   * @return {boolean} True if a component was found in and unmounted from\n   *                   `container`\n   */\n  unmountComponentAtNode: function(container) {\n    var reactRootID = getReactRootID(container);\n    var component = instancesByReactRootID[reactRootID];\n    if (!component) {\n      return false;\n    }\n    ReactMount.unmountComponentFromNode(component, container);\n    delete instancesByReactRootID[reactRootID];\n    delete containersByReactRootID[reactRootID];\n    if (&quot;production&quot; !== &quot;development&quot;) {\n      delete rootElementsByReactRootID[reactRootID];\n    }\n    return true;\n  },\n\n  /**\n   * Unmounts a component and removes it from the DOM.\n   *\n   * @param {ReactComponent} instance React component instance.\n   * @param {DOMElement} container DOM element to unmount from.\n   * @final\n   * @internal\n   * @see {ReactMount.unmountComponentAtNode}\n   */\n  unmountComponentFromNode: function(instance, container) {\n    instance.unmountComponent();\n\n    if (container.nodeType === DOC_NODE_TYPE) {\n      container = container.documentElement;\n    }\n\n    // http://jsperf.com/emptying-a-node\n    while (container.lastChild) {\n      container.removeChild(container.lastChild);\n    }\n  },\n\n  /**\n   * Finds the container DOM element that contains React component to which the\n   * supplied DOM `id` belongs.\n   *\n   * @param {string} id The ID of an element rendered by a React component.\n   * @return {?DOMElement} DOM element that contains the `id`.\n   */\n  findReactContainerForID: function(id) {\n    var reactRootID = ReactInstanceHandles.getReactRootIDFromNodeID(id);\n    var container = containersByReactRootID[reactRootID];\n\n    if (&quot;production&quot; !== &quot;development&quot;) {\n      var rootElement = rootElementsByReactRootID[reactRootID];\n      if (rootElement &amp;&amp; rootElement.parentNode !== container) {\n        (&quot;production&quot; !== &quot;development&quot; ? invariant(\n          // Call internalGetID here because getID calls isValid which calls\n          // findReactContainerForID (this function).\n          internalGetID(rootElement) === reactRootID,\n          &apos;ReactMount: Root element ID differed from reactRootID.&apos;\n        ) : invariant(// Call internalGetID here because getID calls isValid which calls\n        // findReactContainerForID (this function).\n        internalGetID(rootElement) === reactRootID));\n\n        var containerChild = container.firstChild;\n        if (containerChild &amp;&amp;\n            reactRootID === internalGetID(containerChild)) {\n          // If the container has a new child with the same ID as the old\n          // root element, then rootElementsByReactRootID[reactRootID] is\n          // just stale and needs to be updated. The case that deserves a\n          // warning is when the container is empty.\n          rootElementsByReactRootID[reactRootID] = containerChild;\n        } else {\n          console.warn(\n            &apos;ReactMount: Root element has been removed from its original &apos; +\n            &apos;container. New container:&apos;, rootElement.parentNode\n          );\n        }\n      }\n    }\n\n    return container;\n  },\n\n  /**\n   * Finds an element rendered by React with the supplied ID.\n   *\n   * @param {string} id ID of a DOM node in the React component.\n   * @return {DOMElement} Root DOM node of the React component.\n   */\n  findReactNodeByID: function(id) {\n    var reactRoot = ReactMount.findReactContainerForID(id);\n    return ReactMount.findComponentRoot(reactRoot, id);\n  },\n\n  /**\n   * True if the supplied `node` is rendered by React.\n   *\n   * @param {*} node DOM Element to check.\n   * @return {boolean} True if the DOM Element appears to be rendered by React.\n   * @internal\n   */\n  isRenderedByReact: function(node) {\n    if (node.nodeType !== 1) {\n      // Not a DOMElement, therefore not a React component\n      return false;\n    }\n    var id = ReactMount.getID(node);\n    return id ? id.charAt(0) === SEPARATOR : false;\n  },\n\n  /**\n   * Traverses up the ancestors of the supplied node to find a node that is a\n   * DOM representation of a React component.\n   *\n   * @param {*} node\n   * @return {?DOMEventTarget}\n   * @internal\n   */\n  getFirstReactDOM: function(node) {\n    var current = node;\n    while (current &amp;&amp; current.parentNode !== current) {\n      if (ReactMount.isRenderedByReact(current)) {\n        return current;\n      }\n      current = current.parentNode;\n    }\n    return null;\n  },\n\n  /**\n   * Finds a node with the supplied `targetID` inside of the supplied\n   * `ancestorNode`.  Exploits the ID naming scheme to perform the search\n   * quickly.\n   *\n   * @param {DOMEventTarget} ancestorNode Search from this root.\n   * @pararm {string} targetID ID of the DOM representation of the component.\n   * @return {DOMEventTarget} DOM node with the supplied `targetID`.\n   * @internal\n   */\n  findComponentRoot: function(ancestorNode, targetID) {\n    var firstChildren = findComponentRootReusableArray;\n    var childIndex = 0;\n\n    var deepestAncestor = findDeepestCachedAncestor(targetID) || ancestorNode;\n\n    firstChildren[0] = deepestAncestor.firstChild;\n    firstChildren.length = 1;\n\n    while (childIndex &lt; firstChildren.length) {\n      var child = firstChildren[childIndex++];\n      var targetChild;\n\n      while (child) {\n        var childID = ReactMount.getID(child);\n        if (childID) {\n          // Even if we find the node we&apos;re looking for, we finish looping\n          // through its siblings to ensure they&apos;re cached so that we don&apos;t have\n          // to revisit this node again. Otherwise, we make n^2 calls to getID\n          // when visiting the many children of a single node in order.\n\n          if (targetID === childID) {\n            targetChild = child;\n          } else if (ReactInstanceHandles.isAncestorIDOf(childID, targetID)) {\n            // If we find a child whose ID is an ancestor of the given ID,\n            // then we can be sure that we only want to search the subtree\n            // rooted at this child, so we can throw out the rest of the\n            // search state.\n            firstChildren.length = childIndex = 0;\n            firstChildren.push(child.firstChild);\n          }\n\n        } else {\n          // If this child had no ID, then there&apos;s a chance that it was\n          // injected automatically by the browser, as when a `&lt;table&gt;`\n          // element sprouts an extra `&lt;tbody&gt;` child as a side effect of\n          // `.innerHTML` parsing. Optimistically continue down this\n          // branch, but not before examining the other siblings.\n          firstChildren.push(child.firstChild);\n        }\n\n        child = child.nextSibling;\n      }\n\n      if (targetChild) {\n        // Emptying firstChildren/findComponentRootReusableArray is\n        // not necessary for correctness, but it helps the GC reclaim\n        // any nodes that were left at the end of the search.\n        firstChildren.length = 0;\n\n        return targetChild;\n      }\n    }\n\n    firstChildren.length = 0;\n\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      false,\n      &apos;findComponentRoot(..., %s): Unable to find element. This probably &apos; +\n      &apos;means the DOM was unexpectedly mutated (e.g., by the browser). &apos; +\n      &apos;Try inspecting the child nodes of the element with React ID `%s`.&apos;,\n      targetID,\n      ReactMount.getID(ancestorNode)\n    ) : invariant(false));\n  },\n\n\n  /**\n   * React ID utilities.\n   */\n\n  getReactRootID: getReactRootID,\n\n  getID: getID,\n\n  setID: setID,\n\n  getNode: getNode,\n\n  purgeID: purgeID\n};\n\nmodule.exports = ReactMount;\n\n},{&quot;./DOMProperty&quot;:8,&quot;./ReactEventEmitter&quot;:48,&quot;./ReactInstanceHandles&quot;:53,&quot;./ReactPerf&quot;:60,&quot;./containsNode&quot;:88,&quot;./getReactRootElementInContainer&quot;:104,&quot;./invariant&quot;:108,&quot;./shouldUpdateReactComponent&quot;:126}],56:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactMountReady\n */\n\n&quot;use strict&quot;;\n\nvar PooledClass = require(&quot;./PooledClass&quot;);\n\nvar mixInto = require(&quot;./mixInto&quot;);\n\n/**\n * A specialized pseudo-event module to help keep track of components waiting to\n * be notified when their DOM representations are available for use.\n *\n * This implements `PooledClass`, so you should never need to instantiate this.\n * Instead, use `ReactMountReady.getPooled()`.\n *\n * @param {?array&lt;function&gt;} initialCollection\n * @class ReactMountReady\n * @implements PooledClass\n * @internal\n */\nfunction ReactMountReady(initialCollection) {\n  this._queue = initialCollection || null;\n}\n\nmixInto(ReactMountReady, {\n\n  /**\n   * Enqueues a callback to be invoked when `notifyAll` is invoked. This is used\n   * to enqueue calls to `componentDidMount` and `componentDidUpdate`.\n   *\n   * @param {ReactComponent} component Component being rendered.\n   * @param {function(DOMElement)} callback Invoked when `notifyAll` is invoked.\n   * @internal\n   */\n  enqueue: function(component, callback) {\n    this._queue = this._queue || [];\n    this._queue.push({component: component, callback: callback});\n  },\n\n  /**\n   * Invokes all enqueued callbacks and clears the queue. This is invoked after\n   * the DOM representation of a component has been created or updated.\n   *\n   * @internal\n   */\n  notifyAll: function() {\n    var queue = this._queue;\n    if (queue) {\n      this._queue = null;\n      for (var i = 0, l = queue.length; i &lt; l; i++) {\n        var component = queue[i].component;\n        var callback = queue[i].callback;\n        callback.call(component);\n      }\n      queue.length = 0;\n    }\n  },\n\n  /**\n   * Resets the internal queue.\n   *\n   * @internal\n   */\n  reset: function() {\n    this._queue = null;\n  },\n\n  /**\n   * `PooledClass` looks for this.\n   */\n  destructor: function() {\n    this.reset();\n  }\n\n});\n\nPooledClass.addPoolingTo(ReactMountReady);\n\nmodule.exports = ReactMountReady;\n\n},{&quot;./PooledClass&quot;:23,&quot;./mixInto&quot;:120}],57:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactMultiChild\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar ReactComponent = require(&quot;./ReactComponent&quot;);\nvar ReactMultiChildUpdateTypes = require(&quot;./ReactMultiChildUpdateTypes&quot;);\n\nvar flattenChildren = require(&quot;./flattenChildren&quot;);\nvar shouldUpdateReactComponent = require(&quot;./shouldUpdateReactComponent&quot;);\n\n/**\n * Updating children of a component may trigger recursive updates. The depth is\n * used to batch recursive updates to render markup more efficiently.\n *\n * @type {number}\n * @private\n */\nvar updateDepth = 0;\n\n/**\n * Queue of update configuration objects.\n *\n * Each object has a `type` property that is in `ReactMultiChildUpdateTypes`.\n *\n * @type {array&lt;object&gt;}\n * @private\n */\nvar updateQueue = [];\n\n/**\n * Queue of markup to be rendered.\n *\n * @type {array&lt;string&gt;}\n * @private\n */\nvar markupQueue = [];\n\n/**\n * Enqueues markup to be rendered and inserted at a supplied index.\n *\n * @param {string} parentID ID of the parent component.\n * @param {string} markup Markup that renders into an element.\n * @param {number} toIndex Destination index.\n * @private\n */\nfunction enqueueMarkup(parentID, markup, toIndex) {\n  // NOTE: Null values reduce hidden classes.\n  updateQueue.push({\n    parentID: parentID,\n    parentNode: null,\n    type: ReactMultiChildUpdateTypes.INSERT_MARKUP,\n    markupIndex: markupQueue.push(markup) - 1,\n    textContent: null,\n    fromIndex: null,\n    toIndex: toIndex\n  });\n}\n\n/**\n * Enqueues moving an existing element to another index.\n *\n * @param {string} parentID ID of the parent component.\n * @param {number} fromIndex Source index of the existing element.\n * @param {number} toIndex Destination index of the element.\n * @private\n */\nfunction enqueueMove(parentID, fromIndex, toIndex) {\n  // NOTE: Null values reduce hidden classes.\n  updateQueue.push({\n    parentID: parentID,\n    parentNode: null,\n    type: ReactMultiChildUpdateTypes.MOVE_EXISTING,\n    markupIndex: null,\n    textContent: null,\n    fromIndex: fromIndex,\n    toIndex: toIndex\n  });\n}\n\n/**\n * Enqueues removing an element at an index.\n *\n * @param {string} parentID ID of the parent component.\n * @param {number} fromIndex Index of the element to remove.\n * @private\n */\nfunction enqueueRemove(parentID, fromIndex) {\n  // NOTE: Null values reduce hidden classes.\n  updateQueue.push({\n    parentID: parentID,\n    parentNode: null,\n    type: ReactMultiChildUpdateTypes.REMOVE_NODE,\n    markupIndex: null,\n    textContent: null,\n    fromIndex: fromIndex,\n    toIndex: null\n  });\n}\n\n/**\n * Enqueues setting the text content.\n *\n * @param {string} parentID ID of the parent component.\n * @param {string} textContent Text content to set.\n * @private\n */\nfunction enqueueTextContent(parentID, textContent) {\n  // NOTE: Null values reduce hidden classes.\n  updateQueue.push({\n    parentID: parentID,\n    parentNode: null,\n    type: ReactMultiChildUpdateTypes.TEXT_CONTENT,\n    markupIndex: null,\n    textContent: textContent,\n    fromIndex: null,\n    toIndex: null\n  });\n}\n\n/**\n * Processes any enqueued updates.\n *\n * @private\n */\nfunction processQueue() {\n  if (updateQueue.length) {\n    ReactComponent.BackendIDOperations.dangerouslyProcessChildrenUpdates(\n      updateQueue,\n      markupQueue\n    );\n    clearQueue();\n  }\n}\n\n/**\n * Clears any enqueued updates.\n *\n * @private\n */\nfunction clearQueue() {\n  updateQueue.length = 0;\n  markupQueue.length = 0;\n}\n\n/**\n * ReactMultiChild are capable of reconciling multiple children.\n *\n * @class ReactMultiChild\n * @internal\n */\nvar ReactMultiChild = {\n\n  /**\n   * Provides common functionality for components that must reconcile multiple\n   * children. This is used by `ReactDOMComponent` to mount, update, and\n   * unmount child components.\n   *\n   * @lends {ReactMultiChild.prototype}\n   */\n  Mixin: {\n\n    /**\n     * Generates a &quot;mount image&quot; for each of the supplied children. In the case\n     * of `ReactDOMComponent`, a mount image is a string of markup.\n     *\n     * @param {?object} nestedChildren Nested child maps.\n     * @return {array} An array of mounted representations.\n     * @internal\n     */\n    mountChildren: function(nestedChildren, transaction) {\n      var children = flattenChildren(nestedChildren);\n      var mountImages = [];\n      var index = 0;\n      this._renderedChildren = children;\n      for (var name in children) {\n        var child = children[name];\n        if (children.hasOwnProperty(name)) {\n          // Inlined for performance, see `ReactInstanceHandles.createReactID`.\n          var rootID = this._rootNodeID + name;\n          var mountImage = child.mountComponent(\n            rootID,\n            transaction,\n            this._mountDepth + 1\n          );\n          child._mountIndex = index;\n          mountImages.push(mountImage);\n          index++;\n        }\n      }\n      return mountImages;\n    },\n\n    /**\n     * Replaces any rendered children with a text content string.\n     *\n     * @param {string} nextContent String of content.\n     * @internal\n     */\n    updateTextContent: function(nextContent) {\n      updateDepth++;\n      var errorThrown = true;\n      try {\n        var prevChildren = this._renderedChildren;\n        // Remove any rendered children.\n        for (var name in prevChildren) {\n          if (prevChildren.hasOwnProperty(name)) {\n            this._unmountChildByName(prevChildren[name], name);\n          }\n        }\n        // Set new text content.\n        this.setTextContent(nextContent);\n        errorThrown = false;\n      } finally {\n        updateDepth--;\n        if (!updateDepth) {\n          errorThrown ? clearQueue() : processQueue();\n        }\n      }\n    },\n\n    /**\n     * Updates the rendered children with new children.\n     *\n     * @param {?object} nextNestedChildren Nested child maps.\n     * @param {ReactReconcileTransaction} transaction\n     * @internal\n     */\n    updateChildren: function(nextNestedChildren, transaction) {\n      updateDepth++;\n      var errorThrown = true;\n      try {\n        this._updateChildren(nextNestedChildren, transaction);\n        errorThrown = false;\n      } finally {\n        updateDepth--;\n        if (!updateDepth) {\n          errorThrown ? clearQueue() : processQueue();\n        }\n      }\n    },\n\n    /**\n     * Improve performance by isolating this hot code path from the try/catch\n     * block in `updateChildren`.\n     *\n     * @param {?object} nextNestedChildren Nested child maps.\n     * @param {ReactReconcileTransaction} transaction\n     * @final\n     * @protected\n     */\n    _updateChildren: function(nextNestedChildren, transaction) {\n      var nextChildren = flattenChildren(nextNestedChildren);\n      var prevChildren = this._renderedChildren;\n      if (!nextChildren &amp;&amp; !prevChildren) {\n        return;\n      }\n      var name;\n      // `nextIndex` will increment for each child in `nextChildren`, but\n      // `lastIndex` will be the last index visited in `prevChildren`.\n      var lastIndex = 0;\n      var nextIndex = 0;\n      for (name in nextChildren) {\n        if (!nextChildren.hasOwnProperty(name)) {\n          continue;\n        }\n        var prevChild = prevChildren &amp;&amp; prevChildren[name];\n        var nextChild = nextChildren[name];\n        if (shouldUpdateReactComponent(prevChild, nextChild)) {\n          this.moveChild(prevChild, nextIndex, lastIndex);\n          lastIndex = Math.max(prevChild._mountIndex, lastIndex);\n          prevChild.receiveComponent(nextChild, transaction);\n          prevChild._mountIndex = nextIndex;\n        } else {\n          if (prevChild) {\n            // Update `lastIndex` before `_mountIndex` gets unset by unmounting.\n            lastIndex = Math.max(prevChild._mountIndex, lastIndex);\n            this._unmountChildByName(prevChild, name);\n          }\n          this._mountChildByNameAtIndex(\n            nextChild, name, nextIndex, transaction\n          );\n        }\n        nextIndex++;\n      }\n      // Remove children that are no longer present.\n      for (name in prevChildren) {\n        if (prevChildren.hasOwnProperty(name) &amp;&amp;\n            !(nextChildren &amp;&amp; nextChildren[name])) {\n          this._unmountChildByName(prevChildren[name], name);\n        }\n      }\n    },\n\n    /**\n     * Unmounts all rendered children. This should be used to clean up children\n     * when this component is unmounted.\n     *\n     * @internal\n     */\n    unmountChildren: function() {\n      var renderedChildren = this._renderedChildren;\n      for (var name in renderedChildren) {\n        var renderedChild = renderedChildren[name];\n        // TODO: When is this not true?\n        if (renderedChild.unmountComponent) {\n          renderedChild.unmountComponent();\n        }\n      }\n      this._renderedChildren = null;\n    },\n\n    /**\n     * Moves a child component to the supplied index.\n     *\n     * @param {ReactComponent} child Component to move.\n     * @param {number} toIndex Destination index of the element.\n     * @param {number} lastIndex Last index visited of the siblings of `child`.\n     * @protected\n     */\n    moveChild: function(child, toIndex, lastIndex) {\n      // If the index of `child` is less than `lastIndex`, then it needs to\n      // be moved. Otherwise, we do not need to move it because a child will be\n      // inserted or moved before `child`.\n      if (child._mountIndex &lt; lastIndex) {\n        enqueueMove(this._rootNodeID, child._mountIndex, toIndex);\n      }\n    },\n\n    /**\n     * Creates a child component.\n     *\n     * @param {ReactComponent} child Component to create.\n     * @param {string} mountImage Markup to insert.\n     * @protected\n     */\n    createChild: function(child, mountImage) {\n      enqueueMarkup(this._rootNodeID, mountImage, child._mountIndex);\n    },\n\n    /**\n     * Removes a child component.\n     *\n     * @param {ReactComponent} child Child to remove.\n     * @protected\n     */\n    removeChild: function(child) {\n      enqueueRemove(this._rootNodeID, child._mountIndex);\n    },\n\n    /**\n     * Sets this text content string.\n     *\n     * @param {string} textContent Text content to set.\n     * @protected\n     */\n    setTextContent: function(textContent) {\n      enqueueTextContent(this._rootNodeID, textContent);\n    },\n\n    /**\n     * Mounts a child with the supplied name.\n     *\n     * NOTE: This is part of `updateChildren` and is here for readability.\n     *\n     * @param {ReactComponent} child Component to mount.\n     * @param {string} name Name of the child.\n     * @param {number} index Index at which to insert the child.\n     * @param {ReactReconcileTransaction} transaction\n     * @private\n     */\n    _mountChildByNameAtIndex: function(child, name, index, transaction) {\n      // Inlined for performance, see `ReactInstanceHandles.createReactID`.\n      var rootID = this._rootNodeID + name;\n      var mountImage = child.mountComponent(\n        rootID,\n        transaction,\n        this._mountDepth + 1\n      );\n      child._mountIndex = index;\n      this.createChild(child, mountImage);\n      this._renderedChildren = this._renderedChildren || {};\n      this._renderedChildren[name] = child;\n    },\n\n    /**\n     * Unmounts a rendered child by name.\n     *\n     * NOTE: This is part of `updateChildren` and is here for readability.\n     *\n     * @param {ReactComponent} child Component to unmount.\n     * @param {string} name Name of the child in `this._renderedChildren`.\n     * @private\n     */\n    _unmountChildByName: function(child, name) {\n      // TODO: When is this not true?\n      if (ReactComponent.isValidComponent(child)) {\n        this.removeChild(child);\n        child._mountIndex = null;\n        child.unmountComponent();\n        delete this._renderedChildren[name];\n      }\n    }\n\n  }\n\n};\n\nmodule.exports = ReactMultiChild;\n\n},{&quot;./ReactComponent&quot;:26,&quot;./ReactMultiChildUpdateTypes&quot;:58,&quot;./flattenChildren&quot;:97,&quot;./shouldUpdateReactComponent&quot;:126}],58:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactMultiChildUpdateTypes\n */\n\n&quot;use strict&quot;;\n\nvar keyMirror = require(&quot;./keyMirror&quot;);\n\n/**\n * When a component&apos;s children are updated, a series of update configuration\n * objects are created in order to batch and serialize the required changes.\n *\n * Enumerates all the possible types of update configurations.\n *\n * @internal\n */\nvar ReactMultiChildUpdateTypes = keyMirror({\n  INSERT_MARKUP: null,\n  MOVE_EXISTING: null,\n  REMOVE_NODE: null,\n  TEXT_CONTENT: null\n});\n\nmodule.exports = ReactMultiChildUpdateTypes;\n\n},{&quot;./keyMirror&quot;:114}],59:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactOwner\n */\n\n&quot;use strict&quot;;\n\nvar invariant = require(&quot;./invariant&quot;);\n\n/**\n * ReactOwners are capable of storing references to owned components.\n *\n * All components are capable of //being// referenced by owner components, but\n * only ReactOwner components are capable of //referencing// owned components.\n * The named reference is known as a &quot;ref&quot;.\n *\n * Refs are available when mounted and updated during reconciliation.\n *\n *   var MyComponent = React.createClass({\n *     render: function() {\n *       return (\n *         &lt;div onClick={this.handleClick}&gt;\n *           &lt;CustomComponent ref=&quot;custom&quot; /&gt;\n *         &lt;/div&gt;\n *       );\n *     },\n *     handleClick: function() {\n *       this.refs.custom.handleClick();\n *     },\n *     componentDidMount: function() {\n *       this.refs.custom.initialize();\n *     }\n *   });\n *\n * Refs should rarely be used. When refs are used, they should only be done to\n * control data that is not handled by React&apos;s data flow.\n *\n * @class ReactOwner\n */\nvar ReactOwner = {\n\n  /**\n   * @param {?object} object\n   * @return {boolean} True if `object` is a valid owner.\n   * @final\n   */\n  isValidOwner: function(object) {\n    return !!(\n      object &amp;&amp;\n      typeof object.attachRef === &apos;function&apos; &amp;&amp;\n      typeof object.detachRef === &apos;function&apos;\n    );\n  },\n\n  /**\n   * Adds a component by ref to an owner component.\n   *\n   * @param {ReactComponent} component Component to reference.\n   * @param {string} ref Name by which to refer to the component.\n   * @param {ReactOwner} owner Component on which to record the ref.\n   * @final\n   * @internal\n   */\n  addComponentAsRefTo: function(component, ref, owner) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      ReactOwner.isValidOwner(owner),\n      &apos;addComponentAsRefTo(...): Only a ReactOwner can have refs. This &apos; +\n      &apos;usually means that you\\&apos;re trying to add a ref to a component that &apos; +\n      &apos;doesn\\&apos;t have an owner (that is, was not created inside of another &apos; +\n      &apos;component\\&apos;s `render` method). Try rendering this component inside of &apos; +\n      &apos;a new top-level component which will hold the ref.&apos;\n    ) : invariant(ReactOwner.isValidOwner(owner)));\n    owner.attachRef(ref, component);\n  },\n\n  /**\n   * Removes a component by ref from an owner component.\n   *\n   * @param {ReactComponent} component Component to dereference.\n   * @param {string} ref Name of the ref to remove.\n   * @param {ReactOwner} owner Component on which the ref is recorded.\n   * @final\n   * @internal\n   */\n  removeComponentAsRefFrom: function(component, ref, owner) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      ReactOwner.isValidOwner(owner),\n      &apos;removeComponentAsRefFrom(...): Only a ReactOwner can have refs. This &apos; +\n      &apos;usually means that you\\&apos;re trying to remove a ref to a component that &apos; +\n      &apos;doesn\\&apos;t have an owner (that is, was not created inside of another &apos; +\n      &apos;component\\&apos;s `render` method). Try rendering this component inside of &apos; +\n      &apos;a new top-level component which will hold the ref.&apos;\n    ) : invariant(ReactOwner.isValidOwner(owner)));\n    // Check that `component` is still the current ref because we do not want to\n    // detach the ref if another component stole it.\n    if (owner.refs[ref] === component) {\n      owner.detachRef(ref);\n    }\n  },\n\n  /**\n   * A ReactComponent must mix this in to have refs.\n   *\n   * @lends {ReactOwner.prototype}\n   */\n  Mixin: {\n\n    /**\n     * Lazily allocates the refs object and stores `component` as `ref`.\n     *\n     * @param {string} ref Reference name.\n     * @param {component} component Component to store as `ref`.\n     * @final\n     * @private\n     */\n    attachRef: function(ref, component) {\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        component.isOwnedBy(this),\n        &apos;attachRef(%s, ...): Only a component\\&apos;s owner can store a ref to it.&apos;,\n        ref\n      ) : invariant(component.isOwnedBy(this)));\n      var refs = this.refs || (this.refs = {});\n      refs[ref] = component;\n    },\n\n    /**\n     * Detaches a reference name.\n     *\n     * @param {string} ref Name to dereference.\n     * @final\n     * @private\n     */\n    detachRef: function(ref) {\n      delete this.refs[ref];\n    }\n\n  }\n\n};\n\nmodule.exports = ReactOwner;\n\n},{&quot;./invariant&quot;:108}],60:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactPerf\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\n/**\n * ReactPerf is a general AOP system designed to measure performance. This\n * module only has the hooks: see ReactDefaultPerf for the analysis tool.\n */\nvar ReactPerf = {\n  /**\n   * Boolean to enable/disable measurement. Set to false by default to prevent\n   * accidental logging and perf loss.\n   */\n  enableMeasure: false,\n\n  /**\n   * Holds onto the measure function in use. By default, don&apos;t measure\n   * anything, but we&apos;ll override this if we inject a measure function.\n   */\n  storedMeasure: _noMeasure,\n\n  /**\n   * Use this to wrap methods you want to measure. Zero overhead in production.\n   *\n   * @param {string} objName\n   * @param {string} fnName\n   * @param {function} func\n   * @return {function}\n   */\n  measure: function(objName, fnName, func) {\n    if (&quot;production&quot; !== &quot;development&quot;) {\n      var measuredFunc = null;\n      return function() {\n        if (ReactPerf.enableMeasure) {\n          if (!measuredFunc) {\n            measuredFunc = ReactPerf.storedMeasure(objName, fnName, func);\n          }\n          return measuredFunc.apply(this, arguments);\n        }\n        return func.apply(this, arguments);\n      };\n    }\n    return func;\n  },\n\n  injection: {\n    /**\n     * @param {function} measure\n     */\n    injectMeasure: function(measure) {\n      ReactPerf.storedMeasure = measure;\n    }\n  }\n};\n\n/**\n * Simply passes through the measured function, without measuring it.\n *\n * @param {string} objName\n * @param {string} fnName\n * @param {function} func\n * @return {function}\n */\nfunction _noMeasure(objName, fnName, func) {\n  return func;\n}\n\nmodule.exports = ReactPerf;\n\n},{}],61:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactPropTransferer\n */\n\n&quot;use strict&quot;;\n\nvar emptyFunction = require(&quot;./emptyFunction&quot;);\nvar invariant = require(&quot;./invariant&quot;);\nvar joinClasses = require(&quot;./joinClasses&quot;);\nvar merge = require(&quot;./merge&quot;);\n\n/**\n * Creates a transfer strategy that will merge prop values using the supplied\n * `mergeStrategy`. If a prop was previously unset, this just sets it.\n *\n * @param {function} mergeStrategy\n * @return {function}\n */\nfunction createTransferStrategy(mergeStrategy) {\n  return function(props, key, value) {\n    if (!props.hasOwnProperty(key)) {\n      props[key] = value;\n    } else {\n      props[key] = mergeStrategy(props[key], value);\n    }\n  };\n}\n\n/**\n * Transfer strategies dictate how props are transferred by `transferPropsTo`.\n * NOTE: if you add any more exceptions to this list you should be sure to\n * update `cloneWithProps()` accordingly.\n */\nvar TransferStrategies = {\n  /**\n   * Never transfer `children`.\n   */\n  children: emptyFunction,\n  /**\n   * Transfer the `className` prop by merging them.\n   */\n  className: createTransferStrategy(joinClasses),\n  /**\n   * Never transfer the `key` prop.\n   */\n  key: emptyFunction,\n  /**\n   * Never transfer the `ref` prop.\n   */\n  ref: emptyFunction,\n  /**\n   * Transfer the `style` prop (which is an object) by merging them.\n   */\n  style: createTransferStrategy(merge)\n};\n\n/**\n * ReactPropTransferer are capable of transferring props to another component\n * using a `transferPropsTo` method.\n *\n * @class ReactPropTransferer\n */\nvar ReactPropTransferer = {\n\n  TransferStrategies: TransferStrategies,\n\n  /**\n   * Merge two props objects using TransferStrategies.\n   *\n   * @param {object} oldProps original props (they take precedence)\n   * @param {object} newProps new props to merge in\n   * @return {object} a new object containing both sets of props merged.\n   */\n  mergeProps: function(oldProps, newProps) {\n    var props = merge(oldProps);\n\n    for (var thisKey in newProps) {\n      if (!newProps.hasOwnProperty(thisKey)) {\n        continue;\n      }\n\n      var transferStrategy = TransferStrategies[thisKey];\n\n      if (transferStrategy) {\n        transferStrategy(props, thisKey, newProps[thisKey]);\n      } else if (!props.hasOwnProperty(thisKey)) {\n        props[thisKey] = newProps[thisKey];\n      }\n    }\n\n    return props;\n  },\n\n  /**\n   * @lends {ReactPropTransferer.prototype}\n   */\n  Mixin: {\n\n    /**\n     * Transfer props from this component to a target component.\n     *\n     * Props that do not have an explicit transfer strategy will be transferred\n     * only if the target component does not already have the prop set.\n     *\n     * This is usually used to pass down props to a returned root component.\n     *\n     * @param {ReactComponent} component Component receiving the properties.\n     * @return {ReactComponent} The supplied `component`.\n     * @final\n     * @protected\n     */\n    transferPropsTo: function(component) {\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        component._owner === this,\n        &apos;%s: You can\\&apos;t call transferPropsTo() on a component that you &apos; +\n        &apos;don\\&apos;t own, %s. This usually means you are calling &apos; +\n        &apos;transferPropsTo() on a component passed in as props or children.&apos;,\n        this.constructor.displayName,\n        component.constructor.displayName\n      ) : invariant(component._owner === this));\n\n      component.props = ReactPropTransferer.mergeProps(\n        component.props,\n        this.props\n      );\n\n      return component;\n    }\n\n  }\n};\n\nmodule.exports = ReactPropTransferer;\n\n},{&quot;./emptyFunction&quot;:95,&quot;./invariant&quot;:108,&quot;./joinClasses&quot;:113,&quot;./merge&quot;:117}],62:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactPropTypeLocationNames\n */\n\n&quot;use strict&quot;;\n\nvar ReactPropTypeLocationNames = {};\n\nif (&quot;production&quot; !== &quot;development&quot;) {\n  ReactPropTypeLocationNames = {\n    prop: &apos;prop&apos;,\n    context: &apos;context&apos;,\n    childContext: &apos;child context&apos;\n  };\n}\n\nmodule.exports = ReactPropTypeLocationNames;\n\n},{}],63:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactPropTypeLocations\n */\n\n&quot;use strict&quot;;\n\nvar keyMirror = require(&quot;./keyMirror&quot;);\n\nvar ReactPropTypeLocations = keyMirror({\n  prop: null,\n  context: null,\n  childContext: null\n});\n\nmodule.exports = ReactPropTypeLocations;\n\n},{&quot;./keyMirror&quot;:114}],64:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactPropTypes\n */\n\n&quot;use strict&quot;;\n\nvar ReactComponent = require(&quot;./ReactComponent&quot;);\nvar ReactPropTypeLocationNames = require(&quot;./ReactPropTypeLocationNames&quot;);\n\nvar warning = require(&quot;./warning&quot;);\nvar createObjectFrom = require(&quot;./createObjectFrom&quot;);\n\n/**\n * Collection of methods that allow declaration and validation of props that are\n * supplied to React components. Example usage:\n *\n *   var Props = require(&apos;ReactPropTypes&apos;);\n *   var MyArticle = React.createClass({\n *     propTypes: {\n *       // An optional string prop named &quot;description&quot;.\n *       description: Props.string,\n *\n *       // A required enum prop named &quot;category&quot;.\n *       category: Props.oneOf([&apos;News&apos;,&apos;Photos&apos;]).isRequired,\n *\n *       // A prop named &quot;dialog&quot; that requires an instance of Dialog.\n *       dialog: Props.instanceOf(Dialog).isRequired\n *     },\n *     render: function() { ... }\n *   });\n *\n * A more formal specification of how these methods are used:\n *\n *   type := array|bool|func|object|number|string|oneOf([...])|instanceOf(...)\n *   decl := ReactPropTypes.{type}(.isRequired)?\n *\n * Each and every declaration produces a function with the same signature. This\n * allows the creation of custom validation functions. For example:\n *\n *   var Props = require(&apos;ReactPropTypes&apos;);\n *   var MyLink = React.createClass({\n *     propTypes: {\n *       // An optional string or URI prop named &quot;href&quot;.\n *       href: function(props, propName, componentName) {\n *         var propValue = props[propName];\n *         warning(\n *           propValue == null ||\n *           typeof propValue === &apos;string&apos; ||\n *           propValue instanceof URI,\n *           &apos;Invalid `%s` supplied to `%s`, expected string or URI.&apos;,\n *           propName,\n *           componentName\n *         );\n *       }\n *     },\n *     render: function() { ... }\n *   });\n *\n * @internal\n */\nvar Props = {\n\n  array: createPrimitiveTypeChecker(&apos;array&apos;),\n  bool: createPrimitiveTypeChecker(&apos;boolean&apos;),\n  func: createPrimitiveTypeChecker(&apos;function&apos;),\n  number: createPrimitiveTypeChecker(&apos;number&apos;),\n  object: createPrimitiveTypeChecker(&apos;object&apos;),\n  string: createPrimitiveTypeChecker(&apos;string&apos;),\n\n  shape: createShapeTypeChecker,\n  oneOf: createEnumTypeChecker,\n  oneOfType: createUnionTypeChecker,\n  arrayOf: createArrayOfTypeChecker,\n\n  instanceOf: createInstanceTypeChecker,\n\n  renderable: createRenderableTypeChecker(),\n\n  component: createComponentTypeChecker(),\n\n  any: createAnyTypeChecker()\n};\n\nvar ANONYMOUS = &apos;&lt;&lt;anonymous&gt;&gt;&apos;;\n\nfunction isRenderable(propValue) {\n  switch(typeof propValue) {\n    case &apos;number&apos;:\n    case &apos;string&apos;:\n      return true;\n    case &apos;object&apos;:\n      if (Array.isArray(propValue)) {\n        return propValue.every(isRenderable);\n      }\n      if (ReactComponent.isValidComponent(propValue)) {\n        return true;\n      }\n      for (var k in propValue) {\n        if (!isRenderable(propValue[k])) {\n          return false;\n        }\n      }\n      return true;\n    default:\n      return false;\n  }\n}\n\n// Equivalent of typeof but with special handling for arrays\nfunction getPropType(propValue) {\n  var propType = typeof propValue;\n  if (propType === &apos;object&apos; &amp;&amp; Array.isArray(propValue)) {\n    return &apos;array&apos;;\n  }\n  return propType;\n}\n\nfunction createAnyTypeChecker() {\n  function validateAnyType(\n    shouldWarn, propValue, propName, componentName, location\n  ) {\n    return true; // is always valid\n  }\n  return createChainableTypeChecker(validateAnyType);\n}\n\nfunction createPrimitiveTypeChecker(expectedType) {\n  function validatePrimitiveType(\n    shouldWarn, propValue, propName, componentName, location\n  ) {\n    var propType = getPropType(propValue);\n    var isValid = propType === expectedType;\n    if (shouldWarn) {\n      (&quot;production&quot; !== &quot;development&quot; ? warning(\n        isValid,\n        &apos;Invalid %s `%s` of type `%s` supplied to `%s`, expected `%s`.&apos;,\n        ReactPropTypeLocationNames[location],\n        propName,\n        propType,\n        componentName,\n        expectedType\n      ) : null);\n    }\n    return isValid;\n  }\n  return createChainableTypeChecker(validatePrimitiveType);\n}\n\nfunction createEnumTypeChecker(expectedValues) {\n  var expectedEnum = createObjectFrom(expectedValues);\n  function validateEnumType(\n    shouldWarn, propValue, propName, componentName, location\n  ) {\n    var isValid = expectedEnum[propValue];\n    if (shouldWarn) {\n      (&quot;production&quot; !== &quot;development&quot; ? warning(\n        isValid,\n        &apos;Invalid %s `%s` supplied to `%s`, expected one of %s.&apos;,\n        ReactPropTypeLocationNames[location],\n        propName,\n        componentName,\n        JSON.stringify(Object.keys(expectedEnum))\n      ) : null);\n    }\n    return isValid;\n  }\n  return createChainableTypeChecker(validateEnumType);\n}\n\nfunction createShapeTypeChecker(shapeTypes) {\n  function validateShapeType(\n    shouldWarn, propValue, propName, componentName, location\n  ) {\n    var propType = getPropType(propValue);\n    var isValid = propType === &apos;object&apos;;\n    if (isValid) {\n      for (var key in shapeTypes) {\n        var checker = shapeTypes[key];\n        if (checker &amp;&amp; !checker(propValue, key, componentName, location)) {\n          return false;\n        }\n      }\n    }\n    if (shouldWarn) {\n      (&quot;production&quot; !== &quot;development&quot; ? warning(\n        isValid,\n        &apos;Invalid %s `%s` of type `%s` supplied to `%s`, expected `object`.&apos;,\n        ReactPropTypeLocationNames[location],\n        propName,\n        propType,\n        componentName\n      ) : null);\n    }\n    return isValid;\n  }\n  return createChainableTypeChecker(validateShapeType);\n}\n\nfunction createInstanceTypeChecker(expectedClass) {\n  function validateInstanceType(\n    shouldWarn, propValue, propName, componentName, location\n  ) {\n    var isValid = propValue instanceof expectedClass;\n    if (shouldWarn) {\n      (&quot;production&quot; !== &quot;development&quot; ? warning(\n        isValid,\n        &apos;Invalid %s `%s` supplied to `%s`, expected instance of `%s`.&apos;,\n        ReactPropTypeLocationNames[location],\n        propName,\n        componentName,\n        expectedClass.name || ANONYMOUS\n      ) : null);\n    }\n    return isValid;\n  }\n  return createChainableTypeChecker(validateInstanceType);\n}\n\nfunction createArrayOfTypeChecker(propTypeChecker) {\n  function validateArrayType(\n    shouldWarn, propValue, propName, componentName, location\n  ) {\n    var isValid = Array.isArray(propValue);\n    if (isValid) {\n      for (var i = 0; i &lt; propValue.length; i++) {\n        if (!propTypeChecker(propValue, i, componentName, location)) {\n          return false;\n        }\n      }\n    }\n    if (shouldWarn) {\n      (&quot;production&quot; !== &quot;development&quot; ? warning(\n        isValid,\n        &apos;Invalid %s `%s` supplied to `%s`, expected an array.&apos;,\n        ReactPropTypeLocationNames[location],\n        propName,\n        componentName\n      ) : null);\n    }\n    return isValid;\n  }\n  return createChainableTypeChecker(validateArrayType);\n}\n\nfunction createRenderableTypeChecker() {\n  function validateRenderableType(\n    shouldWarn, propValue, propName, componentName, location\n  ) {\n    var isValid = isRenderable(propValue);\n    if (shouldWarn) {\n      (&quot;production&quot; !== &quot;development&quot; ? warning(\n        isValid,\n        &apos;Invalid %s `%s` supplied to `%s`, expected a renderable prop.&apos;,\n        ReactPropTypeLocationNames[location],\n        propName,\n        componentName\n      ) : null);\n    }\n    return isValid;\n  }\n  return createChainableTypeChecker(validateRenderableType);\n}\n\nfunction createComponentTypeChecker() {\n  function validateComponentType(\n    shouldWarn, propValue, propName, componentName, location\n  ) {\n    var isValid = ReactComponent.isValidComponent(propValue);\n    if (shouldWarn) {\n      (&quot;production&quot; !== &quot;development&quot; ? warning(\n        isValid,\n        &apos;Invalid %s `%s` supplied to `%s`, expected a React component.&apos;,\n        ReactPropTypeLocationNames[location],\n        propName,\n        componentName\n      ) : null);\n    }\n    return isValid;\n  }\n  return createChainableTypeChecker(validateComponentType);\n}\n\nfunction createUnionTypeChecker(arrayOfValidators) {\n  return function(props, propName, componentName, location) {\n    var isValid = false;\n    for (var ii = 0; ii &lt; arrayOfValidators.length; ii++) {\n      var validate = arrayOfValidators[ii];\n      if (typeof validate.weak === &apos;function&apos;) {\n        validate = validate.weak;\n      }\n      if (validate(props, propName, componentName, location)) {\n        isValid = true;\n        break;\n      }\n    }\n    (&quot;production&quot; !== &quot;development&quot; ? warning(\n      isValid,\n      &apos;Invalid %s `%s` supplied to `%s`.&apos;,\n      ReactPropTypeLocationNames[location],\n      propName,\n      componentName || ANONYMOUS\n    ) : null);\n    return isValid;\n  };\n}\n\nfunction createChainableTypeChecker(validate) {\n  function checkType(\n    isRequired, shouldWarn, props, propName, componentName, location\n  ) {\n    var propValue = props[propName];\n    if (propValue != null) {\n      // Only validate if there is a value to check.\n      return validate(\n        shouldWarn,\n        propValue,\n        propName,\n        componentName || ANONYMOUS,\n        location\n      );\n    } else {\n      var isValid = !isRequired;\n      if (shouldWarn) {\n        (&quot;production&quot; !== &quot;development&quot; ? warning(\n          isValid,\n          &apos;Required %s `%s` was not specified in `%s`.&apos;,\n          ReactPropTypeLocationNames[location],\n          propName,\n          componentName || ANONYMOUS\n        ) : null);\n      }\n      return isValid;\n    }\n  }\n\n  var checker = checkType.bind(null, false, true);\n  checker.weak = checkType.bind(null, false, false);\n  checker.isRequired = checkType.bind(null, true, true);\n  checker.weak.isRequired = checkType.bind(null, true, false);\n  checker.isRequired.weak = checker.weak.isRequired;\n\n  return checker;\n}\n\nmodule.exports = Props;\n\n},{&quot;./ReactComponent&quot;:26,&quot;./ReactPropTypeLocationNames&quot;:62,&quot;./createObjectFrom&quot;:93,&quot;./warning&quot;:129}],65:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactPutListenerQueue\n */\n\n&quot;use strict&quot;;\n\nvar PooledClass = require(&quot;./PooledClass&quot;);\nvar ReactEventEmitter = require(&quot;./ReactEventEmitter&quot;);\n\nvar mixInto = require(&quot;./mixInto&quot;);\n\nfunction ReactPutListenerQueue() {\n  this.listenersToPut = [];\n}\n\nmixInto(ReactPutListenerQueue, {\n  enqueuePutListener: function(rootNodeID, propKey, propValue) {\n    this.listenersToPut.push({\n      rootNodeID: rootNodeID,\n      propKey: propKey,\n      propValue: propValue\n    });\n  },\n\n  putListeners: function() {\n    for (var i = 0; i &lt; this.listenersToPut.length; i++) {\n      var listenerToPut = this.listenersToPut[i];\n      ReactEventEmitter.putListener(\n        listenerToPut.rootNodeID,\n        listenerToPut.propKey,\n        listenerToPut.propValue\n      );\n    }\n  },\n\n  reset: function() {\n    this.listenersToPut.length = 0;\n  },\n\n  destructor: function() {\n    this.reset();\n  }\n});\n\nPooledClass.addPoolingTo(ReactPutListenerQueue);\n\nmodule.exports = ReactPutListenerQueue;\n\n},{&quot;./PooledClass&quot;:23,&quot;./ReactEventEmitter&quot;:48,&quot;./mixInto&quot;:120}],66:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactReconcileTransaction\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar ExecutionEnvironment = require(&quot;./ExecutionEnvironment&quot;);\nvar PooledClass = require(&quot;./PooledClass&quot;);\nvar ReactEventEmitter = require(&quot;./ReactEventEmitter&quot;);\nvar ReactInputSelection = require(&quot;./ReactInputSelection&quot;);\nvar ReactMountReady = require(&quot;./ReactMountReady&quot;);\nvar ReactPutListenerQueue = require(&quot;./ReactPutListenerQueue&quot;);\nvar Transaction = require(&quot;./Transaction&quot;);\n\nvar mixInto = require(&quot;./mixInto&quot;);\n\n/**\n * Ensures that, when possible, the selection range (currently selected text\n * input) is not disturbed by performing the transaction.\n */\nvar SELECTION_RESTORATION = {\n  /**\n   * @return {Selection} Selection information.\n   */\n  initialize: ReactInputSelection.getSelectionInformation,\n  /**\n   * @param {Selection} sel Selection information returned from `initialize`.\n   */\n  close: ReactInputSelection.restoreSelection\n};\n\n/**\n * Suppresses events (blur/focus) that could be inadvertently dispatched due to\n * high level DOM manipulations (like temporarily removing a text input from the\n * DOM).\n */\nvar EVENT_SUPPRESSION = {\n  /**\n   * @return {boolean} The enabled status of `ReactEventEmitter` before the\n   * reconciliation.\n   */\n  initialize: function() {\n    var currentlyEnabled = ReactEventEmitter.isEnabled();\n    ReactEventEmitter.setEnabled(false);\n    return currentlyEnabled;\n  },\n\n  /**\n   * @param {boolean} previouslyEnabled Enabled status of `ReactEventEmitter`\n   *   before the reconciliation occured. `close` restores the previous value.\n   */\n  close: function(previouslyEnabled) {\n    ReactEventEmitter.setEnabled(previouslyEnabled);\n  }\n};\n\n/**\n * Provides a `ReactMountReady` queue for collecting `onDOMReady` callbacks\n * during the performing of the transaction.\n */\nvar ON_DOM_READY_QUEUEING = {\n  /**\n   * Initializes the internal `onDOMReady` queue.\n   */\n  initialize: function() {\n    this.reactMountReady.reset();\n  },\n\n  /**\n   * After DOM is flushed, invoke all registered `onDOMReady` callbacks.\n   */\n  close: function() {\n    this.reactMountReady.notifyAll();\n  }\n};\n\nvar PUT_LISTENER_QUEUEING = {\n  initialize: function() {\n    this.putListenerQueue.reset();\n  },\n\n  close: function() {\n    this.putListenerQueue.putListeners();\n  }\n};\n\n/**\n * Executed within the scope of the `Transaction` instance. Consider these as\n * being member methods, but with an implied ordering while being isolated from\n * each other.\n */\nvar TRANSACTION_WRAPPERS = [\n  PUT_LISTENER_QUEUEING,\n  SELECTION_RESTORATION,\n  EVENT_SUPPRESSION,\n  ON_DOM_READY_QUEUEING\n];\n\n/**\n * Currently:\n * - The order that these are listed in the transaction is critical:\n * - Suppresses events.\n * - Restores selection range.\n *\n * Future:\n * - Restore document/overflow scroll positions that were unintentionally\n *   modified via DOM insertions above the top viewport boundary.\n * - Implement/integrate with customized constraint based layout system and keep\n *   track of which dimensions must be remeasured.\n *\n * @class ReactReconcileTransaction\n */\nfunction ReactReconcileTransaction() {\n  this.reinitializeTransaction();\n  this.reactMountReady = ReactMountReady.getPooled(null);\n  this.putListenerQueue = ReactPutListenerQueue.getPooled();\n}\n\nvar Mixin = {\n  /**\n   * @see Transaction\n   * @abstract\n   * @final\n   * @return {array&lt;object&gt;} List of operation wrap proceedures.\n   *   TODO: convert to array&lt;TransactionWrapper&gt;\n   */\n  getTransactionWrappers: function() {\n    if (ExecutionEnvironment.canUseDOM) {\n      return TRANSACTION_WRAPPERS;\n    } else {\n      return [];\n    }\n  },\n\n  /**\n   * @return {object} The queue to collect `onDOMReady` callbacks with.\n   *   TODO: convert to ReactMountReady\n   */\n  getReactMountReady: function() {\n    return this.reactMountReady;\n  },\n\n  getPutListenerQueue: function() {\n    return this.putListenerQueue;\n  },\n\n  /**\n   * `PooledClass` looks for this, and will invoke this before allowing this\n   * instance to be resused.\n   */\n  destructor: function() {\n    ReactMountReady.release(this.reactMountReady);\n    this.reactMountReady = null;\n\n    ReactPutListenerQueue.release(this.putListenerQueue);\n    this.putListenerQueue = null;\n  }\n};\n\n\nmixInto(ReactReconcileTransaction, Transaction.Mixin);\nmixInto(ReactReconcileTransaction, Mixin);\n\nPooledClass.addPoolingTo(ReactReconcileTransaction);\n\nmodule.exports = ReactReconcileTransaction;\n\n},{&quot;./ExecutionEnvironment&quot;:20,&quot;./PooledClass&quot;:23,&quot;./ReactEventEmitter&quot;:48,&quot;./ReactInputSelection&quot;:52,&quot;./ReactMountReady&quot;:56,&quot;./ReactPutListenerQueue&quot;:65,&quot;./Transaction&quot;:84,&quot;./mixInto&quot;:120}],67:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactRootIndex\n * @typechecks\n */\n\n&quot;use strict&quot;;\n\nvar ReactRootIndexInjection = {\n  /**\n   * @param {function} _createReactRootIndex\n   */\n  injectCreateReactRootIndex: function(_createReactRootIndex) {\n    ReactRootIndex.createReactRootIndex = _createReactRootIndex;\n  }\n};\n\nvar ReactRootIndex = {\n  createReactRootIndex: null,\n  injection: ReactRootIndexInjection\n};\n\nmodule.exports = ReactRootIndex;\n\n},{}],68:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @typechecks static-only\n * @providesModule ReactServerRendering\n */\n&quot;use strict&quot;;\n\nvar ReactComponent = require(&quot;./ReactComponent&quot;);\nvar ReactInstanceHandles = require(&quot;./ReactInstanceHandles&quot;);\nvar ReactMarkupChecksum = require(&quot;./ReactMarkupChecksum&quot;);\nvar ReactReconcileTransaction = require(&quot;./ReactReconcileTransaction&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\n\n/**\n * @param {ReactComponent} component\n * @return {string} the markup\n */\nfunction renderComponentToString(component) {\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    ReactComponent.isValidComponent(component),\n    &apos;renderComponentToString(): You must pass a valid ReactComponent.&apos;\n  ) : invariant(ReactComponent.isValidComponent(component)));\n\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    !(arguments.length === 2 &amp;&amp; typeof arguments[1] === &apos;function&apos;),\n    &apos;renderComponentToString(): This function became synchronous and now &apos; +\n    &apos;returns the generated markup. Please remove the second parameter.&apos;\n  ) : invariant(!(arguments.length === 2 &amp;&amp; typeof arguments[1] === &apos;function&apos;)));\n\n  var id = ReactInstanceHandles.createReactRootID();\n  var transaction = ReactReconcileTransaction.getPooled();\n  transaction.reinitializeTransaction();\n  try {\n    return transaction.perform(function() {\n      var markup = component.mountComponent(id, transaction, 0);\n      return ReactMarkupChecksum.addChecksumToMarkup(markup);\n    }, null);\n  } finally {\n    ReactReconcileTransaction.release(transaction);\n  }\n}\n\nmodule.exports = {\n  renderComponentToString: renderComponentToString\n};\n\n},{&quot;./ReactComponent&quot;:26,&quot;./ReactInstanceHandles&quot;:53,&quot;./ReactMarkupChecksum&quot;:54,&quot;./ReactReconcileTransaction&quot;:66,&quot;./invariant&quot;:108}],69:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactTextComponent\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar DOMPropertyOperations = require(&quot;./DOMPropertyOperations&quot;);\nvar ReactComponent = require(&quot;./ReactComponent&quot;);\n\nvar escapeTextForBrowser = require(&quot;./escapeTextForBrowser&quot;);\nvar mixInto = require(&quot;./mixInto&quot;);\n\n/**\n * Text nodes violate a couple assumptions that React makes about components:\n *\n *  - When mounting text into the DOM, adjacent text nodes are merged.\n *  - Text nodes cannot be assigned a React root ID.\n *\n * This component is used to wrap strings in elements so that they can undergo\n * the same reconciliation that is applied to elements.\n *\n * TODO: Investigate representing React components in the DOM with text nodes.\n *\n * @class ReactTextComponent\n * @extends ReactComponent\n * @internal\n */\nvar ReactTextComponent = function(initialText) {\n  this.construct({text: initialText});\n};\n\nmixInto(ReactTextComponent, ReactComponent.Mixin);\nmixInto(ReactTextComponent, {\n\n  /**\n   * Creates the markup for this text node. This node is not intended to have\n   * any features besides containing text content.\n   *\n   * @param {string} rootID DOM ID of the root node.\n   * @param {ReactReconcileTransaction} transaction\n   * @param {number} mountDepth number of components in the owner hierarchy\n   * @return {string} Markup for this text node.\n   * @internal\n   */\n  mountComponent: function(rootID, transaction, mountDepth) {\n    ReactComponent.Mixin.mountComponent.call(\n      this,\n      rootID,\n      transaction,\n      mountDepth\n    );\n    return (\n      &apos;&lt;span &apos; + DOMPropertyOperations.createMarkupForID(rootID) + &apos;&gt;&apos; +\n        escapeTextForBrowser(this.props.text) +\n      &apos;&lt;/span&gt;&apos;\n    );\n  },\n\n  /**\n   * Updates this component by updating the text content.\n   *\n   * @param {object} nextComponent Contains the next text content.\n   * @param {ReactReconcileTransaction} transaction\n   * @internal\n   */\n  receiveComponent: function(nextComponent, transaction) {\n    var nextProps = nextComponent.props;\n    if (nextProps.text !== this.props.text) {\n      this.props.text = nextProps.text;\n      ReactComponent.BackendIDOperations.updateTextContentByID(\n        this._rootNodeID,\n        nextProps.text\n      );\n    }\n  }\n\n});\n\n// Expose the constructor on itself and the prototype for consistency with other\n// descriptors.\nReactTextComponent.type = ReactTextComponent;\nReactTextComponent.prototype.type = ReactTextComponent;\n\nmodule.exports = ReactTextComponent;\n\n},{&quot;./DOMPropertyOperations&quot;:9,&quot;./ReactComponent&quot;:26,&quot;./escapeTextForBrowser&quot;:96,&quot;./mixInto&quot;:120}],70:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ReactUpdates\n */\n\n&quot;use strict&quot;;\n\nvar ReactPerf = require(&quot;./ReactPerf&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\n\nvar dirtyComponents = [];\n\nvar batchingStrategy = null;\n\nfunction ensureBatchingStrategy() {\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(batchingStrategy, &apos;ReactUpdates: must inject a batching strategy&apos;) : invariant(batchingStrategy));\n}\n\nfunction batchedUpdates(callback, param) {\n  ensureBatchingStrategy();\n  batchingStrategy.batchedUpdates(callback, param);\n}\n\n/**\n * Array comparator for ReactComponents by owner depth\n *\n * @param {ReactComponent} c1 first component you&apos;re comparing\n * @param {ReactComponent} c2 second component you&apos;re comparing\n * @return {number} Return value usable by Array.prototype.sort().\n */\nfunction mountDepthComparator(c1, c2) {\n  return c1._mountDepth - c2._mountDepth;\n}\n\nfunction runBatchedUpdates() {\n  // Since reconciling a component higher in the owner hierarchy usually (not\n  // always -- see shouldComponentUpdate()) will reconcile children, reconcile\n  // them before their children by sorting the array.\n\n  dirtyComponents.sort(mountDepthComparator);\n\n  for (var i = 0; i &lt; dirtyComponents.length; i++) {\n    // If a component is unmounted before pending changes apply, ignore them\n    // TODO: Queue unmounts in the same list to avoid this happening at all\n    var component = dirtyComponents[i];\n    if (component.isMounted()) {\n      // If performUpdateIfNecessary happens to enqueue any new updates, we\n      // shouldn&apos;t execute the callbacks until the next render happens, so\n      // stash the callbacks first\n      var callbacks = component._pendingCallbacks;\n      component._pendingCallbacks = null;\n      component.performUpdateIfNecessary();\n      if (callbacks) {\n        for (var j = 0; j &lt; callbacks.length; j++) {\n          callbacks[j].call(component);\n        }\n      }\n    }\n  }\n}\n\nfunction clearDirtyComponents() {\n  dirtyComponents.length = 0;\n}\n\nvar flushBatchedUpdates = ReactPerf.measure(\n  &apos;ReactUpdates&apos;,\n  &apos;flushBatchedUpdates&apos;,\n  function() {\n    // Run these in separate functions so the JIT can optimize\n    try {\n      runBatchedUpdates();\n    } finally {\n      clearDirtyComponents();\n    }\n  }\n);\n\n/**\n * Mark a component as needing a rerender, adding an optional callback to a\n * list of functions which will be executed once the rerender occurs.\n */\nfunction enqueueUpdate(component, callback) {\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    !callback || typeof callback === &quot;function&quot;,\n    &apos;enqueueUpdate(...): You called `setProps`, `replaceProps`, &apos; +\n    &apos;`setState`, `replaceState`, or `forceUpdate` with a callback that &apos; +\n    &apos;isn\\&apos;t callable.&apos;\n  ) : invariant(!callback || typeof callback === &quot;function&quot;));\n  ensureBatchingStrategy();\n\n  if (!batchingStrategy.isBatchingUpdates) {\n    component.performUpdateIfNecessary();\n    callback &amp;&amp; callback.call(component);\n    return;\n  }\n\n  dirtyComponents.push(component);\n\n  if (callback) {\n    if (component._pendingCallbacks) {\n      component._pendingCallbacks.push(callback);\n    } else {\n      component._pendingCallbacks = [callback];\n    }\n  }\n}\n\nvar ReactUpdatesInjection = {\n  injectBatchingStrategy: function(_batchingStrategy) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      _batchingStrategy,\n      &apos;ReactUpdates: must provide a batching strategy&apos;\n    ) : invariant(_batchingStrategy));\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      typeof _batchingStrategy.batchedUpdates === &apos;function&apos;,\n      &apos;ReactUpdates: must provide a batchedUpdates() function&apos;\n    ) : invariant(typeof _batchingStrategy.batchedUpdates === &apos;function&apos;));\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      typeof _batchingStrategy.isBatchingUpdates === &apos;boolean&apos;,\n      &apos;ReactUpdates: must provide an isBatchingUpdates boolean attribute&apos;\n    ) : invariant(typeof _batchingStrategy.isBatchingUpdates === &apos;boolean&apos;));\n    batchingStrategy = _batchingStrategy;\n  }\n};\n\nvar ReactUpdates = {\n  batchedUpdates: batchedUpdates,\n  enqueueUpdate: enqueueUpdate,\n  flushBatchedUpdates: flushBatchedUpdates,\n  injection: ReactUpdatesInjection\n};\n\nmodule.exports = ReactUpdates;\n\n},{&quot;./ReactPerf&quot;:60,&quot;./invariant&quot;:108}],71:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule SelectEventPlugin\n */\n\n&quot;use strict&quot;;\n\nvar EventConstants = require(&quot;./EventConstants&quot;);\nvar EventPropagators = require(&quot;./EventPropagators&quot;);\nvar ReactInputSelection = require(&quot;./ReactInputSelection&quot;);\nvar SyntheticEvent = require(&quot;./SyntheticEvent&quot;);\n\nvar getActiveElement = require(&quot;./getActiveElement&quot;);\nvar isTextInputElement = require(&quot;./isTextInputElement&quot;);\nvar keyOf = require(&quot;./keyOf&quot;);\nvar shallowEqual = require(&quot;./shallowEqual&quot;);\n\nvar topLevelTypes = EventConstants.topLevelTypes;\n\nvar eventTypes = {\n  select: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onSelect: null}),\n      captured: keyOf({onSelectCapture: null})\n    },\n    dependencies: [\n      topLevelTypes.topBlur,\n      topLevelTypes.topContextMenu,\n      topLevelTypes.topFocus,\n      topLevelTypes.topKeyDown,\n      topLevelTypes.topMouseDown,\n      topLevelTypes.topMouseUp,\n      topLevelTypes.topSelectionChange\n    ]\n  }\n};\n\nvar activeElement = null;\nvar activeElementID = null;\nvar lastSelection = null;\nvar mouseDown = false;\n\n/**\n * Get an object which is a unique representation of the current selection.\n *\n * The return value will not be consistent across nodes or browsers, but\n * two identical selections on the same node will return identical objects.\n *\n * @param {DOMElement} node\n * @param {object}\n */\nfunction getSelection(node) {\n  if (&apos;selectionStart&apos; in node &amp;&amp;\n      ReactInputSelection.hasSelectionCapabilities(node)) {\n    return {\n      start: node.selectionStart,\n      end: node.selectionEnd\n    };\n  } else if (document.selection) {\n    var range = document.selection.createRange();\n    return {\n      parentElement: range.parentElement(),\n      text: range.text,\n      top: range.boundingTop,\n      left: range.boundingLeft\n    };\n  } else {\n    var selection = window.getSelection();\n    return {\n      anchorNode: selection.anchorNode,\n      anchorOffset: selection.anchorOffset,\n      focusNode: selection.focusNode,\n      focusOffset: selection.focusOffset\n    };\n  }\n}\n\n/**\n * Poll selection to see whether it&apos;s changed.\n *\n * @param {object} nativeEvent\n * @return {?SyntheticEvent}\n */\nfunction constructSelectEvent(nativeEvent) {\n  // Ensure we have the right element, and that the user is not dragging a\n  // selection (this matches native `select` event behavior). In HTML5, select\n  // fires only on input and textarea thus if there&apos;s no focused element we\n  // won&apos;t dispatch.\n  if (mouseDown ||\n      activeElement == null ||\n      activeElement != getActiveElement()) {\n    return;\n  }\n\n  // Only fire when selection has actually changed.\n  var currentSelection = getSelection(activeElement);\n  if (!lastSelection || !shallowEqual(lastSelection, currentSelection)) {\n    lastSelection = currentSelection;\n\n    var syntheticEvent = SyntheticEvent.getPooled(\n      eventTypes.select,\n      activeElementID,\n      nativeEvent\n    );\n\n    syntheticEvent.type = &apos;select&apos;;\n    syntheticEvent.target = activeElement;\n\n    EventPropagators.accumulateTwoPhaseDispatches(syntheticEvent);\n\n    return syntheticEvent;\n  }\n}\n\n/**\n * This plugin creates an `onSelect` event that normalizes select events\n * across form elements.\n *\n * Supported elements are:\n * - input (see `isTextInputElement`)\n * - textarea\n * - contentEditable\n *\n * This differs from native browser implementations in the following ways:\n * - Fires on contentEditable fields as well as inputs.\n * - Fires for collapsed selection.\n * - Fires after user input.\n */\nvar SelectEventPlugin = {\n\n  eventTypes: eventTypes,\n\n  /**\n   * @param {string} topLevelType Record from `EventConstants`.\n   * @param {DOMEventTarget} topLevelTarget The listening component root node.\n   * @param {string} topLevelTargetID ID of `topLevelTarget`.\n   * @param {object} nativeEvent Native browser event.\n   * @return {*} An accumulation of synthetic events.\n   * @see {EventPluginHub.extractEvents}\n   */\n  extractEvents: function(\n      topLevelType,\n      topLevelTarget,\n      topLevelTargetID,\n      nativeEvent) {\n\n    switch (topLevelType) {\n      // Track the input node that has focus.\n      case topLevelTypes.topFocus:\n        if (isTextInputElement(topLevelTarget) ||\n            topLevelTarget.contentEditable === &apos;true&apos;) {\n          activeElement = topLevelTarget;\n          activeElementID = topLevelTargetID;\n          lastSelection = null;\n        }\n        break;\n      case topLevelTypes.topBlur:\n        activeElement = null;\n        activeElementID = null;\n        lastSelection = null;\n        break;\n\n      // Don&apos;t fire the event while the user is dragging. This matches the\n      // semantics of the native select event.\n      case topLevelTypes.topMouseDown:\n        mouseDown = true;\n        break;\n      case topLevelTypes.topContextMenu:\n      case topLevelTypes.topMouseUp:\n        mouseDown = false;\n        return constructSelectEvent(nativeEvent);\n\n      // Chrome and IE fire non-standard event when selection is changed (and\n      // sometimes when it hasn&apos;t).\n      // Firefox doesn&apos;t support selectionchange, so check selection status\n      // after each key entry. The selection changes after keydown and before\n      // keyup, but we check on keydown as well in the case of holding down a\n      // key, when multiple keydown events are fired but only one keyup is.\n      case topLevelTypes.topSelectionChange:\n      case topLevelTypes.topKeyDown:\n      case topLevelTypes.topKeyUp:\n        return constructSelectEvent(nativeEvent);\n    }\n  }\n};\n\nmodule.exports = SelectEventPlugin;\n\n},{&quot;./EventConstants&quot;:14,&quot;./EventPropagators&quot;:19,&quot;./ReactInputSelection&quot;:52,&quot;./SyntheticEvent&quot;:77,&quot;./getActiveElement&quot;:99,&quot;./isTextInputElement&quot;:111,&quot;./keyOf&quot;:115,&quot;./shallowEqual&quot;:125}],72:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ServerReactRootIndex\n * @typechecks\n */\n\n&quot;use strict&quot;;\n\n/**\n * Size of the reactRoot ID space. We generate random numbers for React root\n * IDs and if there&apos;s a collision the events and DOM update system will\n * get confused. In the future we need a way to generate GUIDs but for\n * now this will work on a smaller scale.\n */\nvar GLOBAL_MOUNT_POINT_MAX = Math.pow(2, 53);\n\nvar ServerReactRootIndex = {\n  createReactRootIndex: function() {\n    return Math.ceil(Math.random() * GLOBAL_MOUNT_POINT_MAX);\n  }\n};\n\nmodule.exports = ServerReactRootIndex;\n\n},{}],73:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule SimpleEventPlugin\n */\n\n&quot;use strict&quot;;\n\nvar EventConstants = require(&quot;./EventConstants&quot;);\nvar EventPluginUtils = require(&quot;./EventPluginUtils&quot;);\nvar EventPropagators = require(&quot;./EventPropagators&quot;);\nvar SyntheticClipboardEvent = require(&quot;./SyntheticClipboardEvent&quot;);\nvar SyntheticEvent = require(&quot;./SyntheticEvent&quot;);\nvar SyntheticFocusEvent = require(&quot;./SyntheticFocusEvent&quot;);\nvar SyntheticKeyboardEvent = require(&quot;./SyntheticKeyboardEvent&quot;);\nvar SyntheticMouseEvent = require(&quot;./SyntheticMouseEvent&quot;);\nvar SyntheticDragEvent = require(&quot;./SyntheticDragEvent&quot;);\nvar SyntheticTouchEvent = require(&quot;./SyntheticTouchEvent&quot;);\nvar SyntheticUIEvent = require(&quot;./SyntheticUIEvent&quot;);\nvar SyntheticWheelEvent = require(&quot;./SyntheticWheelEvent&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\nvar keyOf = require(&quot;./keyOf&quot;);\n\nvar topLevelTypes = EventConstants.topLevelTypes;\n\nvar eventTypes = {\n  blur: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onBlur: true}),\n      captured: keyOf({onBlurCapture: true})\n    }\n  },\n  click: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onClick: true}),\n      captured: keyOf({onClickCapture: true})\n    }\n  },\n  contextMenu: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onContextMenu: true}),\n      captured: keyOf({onContextMenuCapture: true})\n    }\n  },\n  copy: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onCopy: true}),\n      captured: keyOf({onCopyCapture: true})\n    }\n  },\n  cut: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onCut: true}),\n      captured: keyOf({onCutCapture: true})\n    }\n  },\n  doubleClick: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onDoubleClick: true}),\n      captured: keyOf({onDoubleClickCapture: true})\n    }\n  },\n  drag: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onDrag: true}),\n      captured: keyOf({onDragCapture: true})\n    }\n  },\n  dragEnd: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onDragEnd: true}),\n      captured: keyOf({onDragEndCapture: true})\n    }\n  },\n  dragEnter: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onDragEnter: true}),\n      captured: keyOf({onDragEnterCapture: true})\n    }\n  },\n  dragExit: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onDragExit: true}),\n      captured: keyOf({onDragExitCapture: true})\n    }\n  },\n  dragLeave: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onDragLeave: true}),\n      captured: keyOf({onDragLeaveCapture: true})\n    }\n  },\n  dragOver: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onDragOver: true}),\n      captured: keyOf({onDragOverCapture: true})\n    }\n  },\n  dragStart: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onDragStart: true}),\n      captured: keyOf({onDragStartCapture: true})\n    }\n  },\n  drop: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onDrop: true}),\n      captured: keyOf({onDropCapture: true})\n    }\n  },\n  focus: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onFocus: true}),\n      captured: keyOf({onFocusCapture: true})\n    }\n  },\n  input: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onInput: true}),\n      captured: keyOf({onInputCapture: true})\n    }\n  },\n  keyDown: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onKeyDown: true}),\n      captured: keyOf({onKeyDownCapture: true})\n    }\n  },\n  keyPress: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onKeyPress: true}),\n      captured: keyOf({onKeyPressCapture: true})\n    }\n  },\n  keyUp: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onKeyUp: true}),\n      captured: keyOf({onKeyUpCapture: true})\n    }\n  },\n  load: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onLoad: true}),\n      captured: keyOf({onLoadCapture: true})\n    }\n  },\n  error: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onError: true}),\n      captured: keyOf({onErrorCapture: true})\n    }\n  },\n  // Note: We do not allow listening to mouseOver events. Instead, use the\n  // onMouseEnter/onMouseLeave created by `EnterLeaveEventPlugin`.\n  mouseDown: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onMouseDown: true}),\n      captured: keyOf({onMouseDownCapture: true})\n    }\n  },\n  mouseMove: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onMouseMove: true}),\n      captured: keyOf({onMouseMoveCapture: true})\n    }\n  },\n  mouseOut: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onMouseOut: true}),\n      captured: keyOf({onMouseOutCapture: true})\n    }\n  },\n  mouseOver: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onMouseOver: true}),\n      captured: keyOf({onMouseOverCapture: true})\n    }\n  },\n  mouseUp: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onMouseUp: true}),\n      captured: keyOf({onMouseUpCapture: true})\n    }\n  },\n  paste: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onPaste: true}),\n      captured: keyOf({onPasteCapture: true})\n    }\n  },\n  reset: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onReset: true}),\n      captured: keyOf({onResetCapture: true})\n    }\n  },\n  scroll: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onScroll: true}),\n      captured: keyOf({onScrollCapture: true})\n    }\n  },\n  submit: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onSubmit: true}),\n      captured: keyOf({onSubmitCapture: true})\n    }\n  },\n  touchCancel: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onTouchCancel: true}),\n      captured: keyOf({onTouchCancelCapture: true})\n    }\n  },\n  touchEnd: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onTouchEnd: true}),\n      captured: keyOf({onTouchEndCapture: true})\n    }\n  },\n  touchMove: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onTouchMove: true}),\n      captured: keyOf({onTouchMoveCapture: true})\n    }\n  },\n  touchStart: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onTouchStart: true}),\n      captured: keyOf({onTouchStartCapture: true})\n    }\n  },\n  wheel: {\n    phasedRegistrationNames: {\n      bubbled: keyOf({onWheel: true}),\n      captured: keyOf({onWheelCapture: true})\n    }\n  }\n};\n\nvar topLevelEventsToDispatchConfig = {\n  topBlur:        eventTypes.blur,\n  topClick:       eventTypes.click,\n  topContextMenu: eventTypes.contextMenu,\n  topCopy:        eventTypes.copy,\n  topCut:         eventTypes.cut,\n  topDoubleClick: eventTypes.doubleClick,\n  topDrag:        eventTypes.drag,\n  topDragEnd:     eventTypes.dragEnd,\n  topDragEnter:   eventTypes.dragEnter,\n  topDragExit:    eventTypes.dragExit,\n  topDragLeave:   eventTypes.dragLeave,\n  topDragOver:    eventTypes.dragOver,\n  topDragStart:   eventTypes.dragStart,\n  topDrop:        eventTypes.drop,\n  topError:       eventTypes.error,\n  topFocus:       eventTypes.focus,\n  topInput:       eventTypes.input,\n  topKeyDown:     eventTypes.keyDown,\n  topKeyPress:    eventTypes.keyPress,\n  topKeyUp:       eventTypes.keyUp,\n  topLoad:        eventTypes.load,\n  topMouseDown:   eventTypes.mouseDown,\n  topMouseMove:   eventTypes.mouseMove,\n  topMouseOut:    eventTypes.mouseOut,\n  topMouseOver:   eventTypes.mouseOver,\n  topMouseUp:     eventTypes.mouseUp,\n  topPaste:       eventTypes.paste,\n  topReset:       eventTypes.reset,\n  topScroll:      eventTypes.scroll,\n  topSubmit:      eventTypes.submit,\n  topTouchCancel: eventTypes.touchCancel,\n  topTouchEnd:    eventTypes.touchEnd,\n  topTouchMove:   eventTypes.touchMove,\n  topTouchStart:  eventTypes.touchStart,\n  topWheel:       eventTypes.wheel\n};\n\nfor (var topLevelType in topLevelEventsToDispatchConfig) {\n  topLevelEventsToDispatchConfig[topLevelType].dependencies = [topLevelType];\n}\n\nvar SimpleEventPlugin = {\n\n  eventTypes: eventTypes,\n\n  /**\n   * Same as the default implementation, except cancels the event when return\n   * value is false.\n   *\n   * @param {object} Event to be dispatched.\n   * @param {function} Application-level callback.\n   * @param {string} domID DOM ID to pass to the callback.\n   */\n  executeDispatch: function(event, listener, domID) {\n    var returnValue = EventPluginUtils.executeDispatch(event, listener, domID);\n    if (returnValue === false) {\n      event.stopPropagation();\n      event.preventDefault();\n    }\n  },\n\n  /**\n   * @param {string} topLevelType Record from `EventConstants`.\n   * @param {DOMEventTarget} topLevelTarget The listening component root node.\n   * @param {string} topLevelTargetID ID of `topLevelTarget`.\n   * @param {object} nativeEvent Native browser event.\n   * @return {*} An accumulation of synthetic events.\n   * @see {EventPluginHub.extractEvents}\n   */\n  extractEvents: function(\n      topLevelType,\n      topLevelTarget,\n      topLevelTargetID,\n      nativeEvent) {\n    var dispatchConfig = topLevelEventsToDispatchConfig[topLevelType];\n    if (!dispatchConfig) {\n      return null;\n    }\n    var EventConstructor;\n    switch (topLevelType) {\n      case topLevelTypes.topInput:\n      case topLevelTypes.topLoad:\n      case topLevelTypes.topError:\n      case topLevelTypes.topReset:\n      case topLevelTypes.topSubmit:\n        // HTML Events\n        // @see http://www.w3.org/TR/html5/index.html#events-0\n        EventConstructor = SyntheticEvent;\n        break;\n      case topLevelTypes.topKeyDown:\n      case topLevelTypes.topKeyPress:\n      case topLevelTypes.topKeyUp:\n        EventConstructor = SyntheticKeyboardEvent;\n        break;\n      case topLevelTypes.topBlur:\n      case topLevelTypes.topFocus:\n        EventConstructor = SyntheticFocusEvent;\n        break;\n      case topLevelTypes.topClick:\n        // Firefox creates a click event on right mouse clicks. This removes the\n        // unwanted click events.\n        if (nativeEvent.button === 2) {\n          return null;\n        }\n        /* falls through */\n      case topLevelTypes.topContextMenu:\n      case topLevelTypes.topDoubleClick:\n      case topLevelTypes.topMouseDown:\n      case topLevelTypes.topMouseMove:\n      case topLevelTypes.topMouseOut:\n      case topLevelTypes.topMouseOver:\n      case topLevelTypes.topMouseUp:\n        EventConstructor = SyntheticMouseEvent;\n        break;\n      case topLevelTypes.topDrag:\n      case topLevelTypes.topDragEnd:\n      case topLevelTypes.topDragEnter:\n      case topLevelTypes.topDragExit:\n      case topLevelTypes.topDragLeave:\n      case topLevelTypes.topDragOver:\n      case topLevelTypes.topDragStart:\n      case topLevelTypes.topDrop:\n        EventConstructor = SyntheticDragEvent;\n        break;\n      case topLevelTypes.topTouchCancel:\n      case topLevelTypes.topTouchEnd:\n      case topLevelTypes.topTouchMove:\n      case topLevelTypes.topTouchStart:\n        EventConstructor = SyntheticTouchEvent;\n        break;\n      case topLevelTypes.topScroll:\n        EventConstructor = SyntheticUIEvent;\n        break;\n      case topLevelTypes.topWheel:\n        EventConstructor = SyntheticWheelEvent;\n        break;\n      case topLevelTypes.topCopy:\n      case topLevelTypes.topCut:\n      case topLevelTypes.topPaste:\n        EventConstructor = SyntheticClipboardEvent;\n        break;\n    }\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      EventConstructor,\n      &apos;SimpleEventPlugin: Unhandled event type, `%s`.&apos;,\n      topLevelType\n    ) : invariant(EventConstructor));\n    var event = EventConstructor.getPooled(\n      dispatchConfig,\n      topLevelTargetID,\n      nativeEvent\n    );\n    EventPropagators.accumulateTwoPhaseDispatches(event);\n    return event;\n  }\n\n};\n\nmodule.exports = SimpleEventPlugin;\n\n},{&quot;./EventConstants&quot;:14,&quot;./EventPluginUtils&quot;:18,&quot;./EventPropagators&quot;:19,&quot;./SyntheticClipboardEvent&quot;:74,&quot;./SyntheticDragEvent&quot;:76,&quot;./SyntheticEvent&quot;:77,&quot;./SyntheticFocusEvent&quot;:78,&quot;./SyntheticKeyboardEvent&quot;:79,&quot;./SyntheticMouseEvent&quot;:80,&quot;./SyntheticTouchEvent&quot;:81,&quot;./SyntheticUIEvent&quot;:82,&quot;./SyntheticWheelEvent&quot;:83,&quot;./invariant&quot;:108,&quot;./keyOf&quot;:115}],74:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule SyntheticClipboardEvent\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar SyntheticEvent = require(&quot;./SyntheticEvent&quot;);\n\n/**\n * @interface Event\n * @see http://www.w3.org/TR/clipboard-apis/\n */\nvar ClipboardEventInterface = {\n  clipboardData: function(event) {\n    return (\n      &apos;clipboardData&apos; in event ?\n        event.clipboardData :\n        window.clipboardData\n    );\n  }\n};\n\n/**\n * @param {object} dispatchConfig Configuration used to dispatch this event.\n * @param {string} dispatchMarker Marker identifying the event target.\n * @param {object} nativeEvent Native browser event.\n * @extends {SyntheticUIEvent}\n */\nfunction SyntheticClipboardEvent(dispatchConfig, dispatchMarker, nativeEvent) {\n  SyntheticEvent.call(this, dispatchConfig, dispatchMarker, nativeEvent);\n}\n\nSyntheticEvent.augmentClass(SyntheticClipboardEvent, ClipboardEventInterface);\n\nmodule.exports = SyntheticClipboardEvent;\n\n\n},{&quot;./SyntheticEvent&quot;:77}],75:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule SyntheticCompositionEvent\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar SyntheticEvent = require(&quot;./SyntheticEvent&quot;);\n\n/**\n * @interface Event\n * @see http://www.w3.org/TR/DOM-Level-3-Events/#events-compositionevents\n */\nvar CompositionEventInterface = {\n  data: null\n};\n\n/**\n * @param {object} dispatchConfig Configuration used to dispatch this event.\n * @param {string} dispatchMarker Marker identifying the event target.\n * @param {object} nativeEvent Native browser event.\n * @extends {SyntheticUIEvent}\n */\nfunction SyntheticCompositionEvent(\n  dispatchConfig,\n  dispatchMarker,\n  nativeEvent) {\n  SyntheticEvent.call(this, dispatchConfig, dispatchMarker, nativeEvent);\n}\n\nSyntheticEvent.augmentClass(\n  SyntheticCompositionEvent,\n  CompositionEventInterface\n);\n\nmodule.exports = SyntheticCompositionEvent;\n\n\n},{&quot;./SyntheticEvent&quot;:77}],76:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule SyntheticDragEvent\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar SyntheticMouseEvent = require(&quot;./SyntheticMouseEvent&quot;);\n\n/**\n * @interface DragEvent\n * @see http://www.w3.org/TR/DOM-Level-3-Events/\n */\nvar DragEventInterface = {\n  dataTransfer: null\n};\n\n/**\n * @param {object} dispatchConfig Configuration used to dispatch this event.\n * @param {string} dispatchMarker Marker identifying the event target.\n * @param {object} nativeEvent Native browser event.\n * @extends {SyntheticUIEvent}\n */\nfunction SyntheticDragEvent(dispatchConfig, dispatchMarker, nativeEvent) {\n  SyntheticMouseEvent.call(this, dispatchConfig, dispatchMarker, nativeEvent);\n}\n\nSyntheticMouseEvent.augmentClass(SyntheticDragEvent, DragEventInterface);\n\nmodule.exports = SyntheticDragEvent;\n\n},{&quot;./SyntheticMouseEvent&quot;:80}],77:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule SyntheticEvent\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar PooledClass = require(&quot;./PooledClass&quot;);\n\nvar emptyFunction = require(&quot;./emptyFunction&quot;);\nvar getEventTarget = require(&quot;./getEventTarget&quot;);\nvar merge = require(&quot;./merge&quot;);\nvar mergeInto = require(&quot;./mergeInto&quot;);\n\n/**\n * @interface Event\n * @see http://www.w3.org/TR/DOM-Level-3-Events/\n */\nvar EventInterface = {\n  type: null,\n  target: getEventTarget,\n  // currentTarget is set when dispatching; no use in copying it here\n  currentTarget: emptyFunction.thatReturnsNull,\n  eventPhase: null,\n  bubbles: null,\n  cancelable: null,\n  timeStamp: function(event) {\n    return event.timeStamp || Date.now();\n  },\n  defaultPrevented: null,\n  isTrusted: null\n};\n\n/**\n * Synthetic events are dispatched by event plugins, typically in response to a\n * top-level event delegation handler.\n *\n * These systems should generally use pooling to reduce the frequency of garbage\n * collection. The system should check `isPersistent` to determine whether the\n * event should be released into the pool after being dispatched. Users that\n * need a persisted event should invoke `persist`.\n *\n * Synthetic events (and subclasses) implement the DOM Level 3 Events API by\n * normalizing browser quirks. Subclasses do not necessarily have to implement a\n * DOM interface; custom application-specific events can also subclass this.\n *\n * @param {object} dispatchConfig Configuration used to dispatch this event.\n * @param {string} dispatchMarker Marker identifying the event target.\n * @param {object} nativeEvent Native browser event.\n */\nfunction SyntheticEvent(dispatchConfig, dispatchMarker, nativeEvent) {\n  this.dispatchConfig = dispatchConfig;\n  this.dispatchMarker = dispatchMarker;\n  this.nativeEvent = nativeEvent;\n\n  var Interface = this.constructor.Interface;\n  for (var propName in Interface) {\n    if (!Interface.hasOwnProperty(propName)) {\n      continue;\n    }\n    var normalize = Interface[propName];\n    if (normalize) {\n      this[propName] = normalize(nativeEvent);\n    } else {\n      this[propName] = nativeEvent[propName];\n    }\n  }\n\n  var defaultPrevented = nativeEvent.defaultPrevented != null ?\n    nativeEvent.defaultPrevented :\n    nativeEvent.returnValue === false;\n  if (defaultPrevented) {\n    this.isDefaultPrevented = emptyFunction.thatReturnsTrue;\n  } else {\n    this.isDefaultPrevented = emptyFunction.thatReturnsFalse;\n  }\n  this.isPropagationStopped = emptyFunction.thatReturnsFalse;\n}\n\nmergeInto(SyntheticEvent.prototype, {\n\n  preventDefault: function() {\n    this.defaultPrevented = true;\n    var event = this.nativeEvent;\n    event.preventDefault ? event.preventDefault() : event.returnValue = false;\n    this.isDefaultPrevented = emptyFunction.thatReturnsTrue;\n  },\n\n  stopPropagation: function() {\n    var event = this.nativeEvent;\n    event.stopPropagation ? event.stopPropagation() : event.cancelBubble = true;\n    this.isPropagationStopped = emptyFunction.thatReturnsTrue;\n  },\n\n  /**\n   * We release all dispatched `SyntheticEvent`s after each event loop, adding\n   * them back into the pool. This allows a way to hold onto a reference that\n   * won&apos;t be added back into the pool.\n   */\n  persist: function() {\n    this.isPersistent = emptyFunction.thatReturnsTrue;\n  },\n\n  /**\n   * Checks if this event should be released back into the pool.\n   *\n   * @return {boolean} True if this should not be released, false otherwise.\n   */\n  isPersistent: emptyFunction.thatReturnsFalse,\n\n  /**\n   * `PooledClass` looks for `destructor` on each instance it releases.\n   */\n  destructor: function() {\n    var Interface = this.constructor.Interface;\n    for (var propName in Interface) {\n      this[propName] = null;\n    }\n    this.dispatchConfig = null;\n    this.dispatchMarker = null;\n    this.nativeEvent = null;\n  }\n\n});\n\nSyntheticEvent.Interface = EventInterface;\n\n/**\n * Helper to reduce boilerplate when creating subclasses.\n *\n * @param {function} Class\n * @param {?object} Interface\n */\nSyntheticEvent.augmentClass = function(Class, Interface) {\n  var Super = this;\n\n  var prototype = Object.create(Super.prototype);\n  mergeInto(prototype, Class.prototype);\n  Class.prototype = prototype;\n  Class.prototype.constructor = Class;\n\n  Class.Interface = merge(Super.Interface, Interface);\n  Class.augmentClass = Super.augmentClass;\n\n  PooledClass.addPoolingTo(Class, PooledClass.threeArgumentPooler);\n};\n\nPooledClass.addPoolingTo(SyntheticEvent, PooledClass.threeArgumentPooler);\n\nmodule.exports = SyntheticEvent;\n\n},{&quot;./PooledClass&quot;:23,&quot;./emptyFunction&quot;:95,&quot;./getEventTarget&quot;:101,&quot;./merge&quot;:117,&quot;./mergeInto&quot;:119}],78:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule SyntheticFocusEvent\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar SyntheticUIEvent = require(&quot;./SyntheticUIEvent&quot;);\n\n/**\n * @interface FocusEvent\n * @see http://www.w3.org/TR/DOM-Level-3-Events/\n */\nvar FocusEventInterface = {\n  relatedTarget: null\n};\n\n/**\n * @param {object} dispatchConfig Configuration used to dispatch this event.\n * @param {string} dispatchMarker Marker identifying the event target.\n * @param {object} nativeEvent Native browser event.\n * @extends {SyntheticUIEvent}\n */\nfunction SyntheticFocusEvent(dispatchConfig, dispatchMarker, nativeEvent) {\n  SyntheticUIEvent.call(this, dispatchConfig, dispatchMarker, nativeEvent);\n}\n\nSyntheticUIEvent.augmentClass(SyntheticFocusEvent, FocusEventInterface);\n\nmodule.exports = SyntheticFocusEvent;\n\n},{&quot;./SyntheticUIEvent&quot;:82}],79:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule SyntheticKeyboardEvent\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar SyntheticUIEvent = require(&quot;./SyntheticUIEvent&quot;);\n\nvar getEventKey = require(&quot;./getEventKey&quot;);\n\n/**\n * @interface KeyboardEvent\n * @see http://www.w3.org/TR/DOM-Level-3-Events/\n */\nvar KeyboardEventInterface = {\n  key: getEventKey,\n  location: null,\n  ctrlKey: null,\n  shiftKey: null,\n  altKey: null,\n  metaKey: null,\n  repeat: null,\n  locale: null,\n  // Legacy Interface\n  &apos;char&apos;: null,\n  charCode: null,\n  keyCode: null,\n  which: null\n};\n\n/**\n * @param {object} dispatchConfig Configuration used to dispatch this event.\n * @param {string} dispatchMarker Marker identifying the event target.\n * @param {object} nativeEvent Native browser event.\n * @extends {SyntheticUIEvent}\n */\nfunction SyntheticKeyboardEvent(dispatchConfig, dispatchMarker, nativeEvent) {\n  SyntheticUIEvent.call(this, dispatchConfig, dispatchMarker, nativeEvent);\n}\n\nSyntheticUIEvent.augmentClass(SyntheticKeyboardEvent, KeyboardEventInterface);\n\nmodule.exports = SyntheticKeyboardEvent;\n\n},{&quot;./SyntheticUIEvent&quot;:82,&quot;./getEventKey&quot;:100}],80:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule SyntheticMouseEvent\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar SyntheticUIEvent = require(&quot;./SyntheticUIEvent&quot;);\nvar ViewportMetrics = require(&quot;./ViewportMetrics&quot;);\n\n/**\n * @interface MouseEvent\n * @see http://www.w3.org/TR/DOM-Level-3-Events/\n */\nvar MouseEventInterface = {\n  screenX: null,\n  screenY: null,\n  clientX: null,\n  clientY: null,\n  ctrlKey: null,\n  shiftKey: null,\n  altKey: null,\n  metaKey: null,\n  button: function(event) {\n    // Webkit, Firefox, IE9+\n    // which:  1 2 3\n    // button: 0 1 2 (standard)\n    var button = event.button;\n    if (&apos;which&apos; in event) {\n      return button;\n    }\n    // IE&lt;9\n    // which:  undefined\n    // button: 0 0 0\n    // button: 1 4 2 (onmouseup)\n    return button === 2 ? 2 : button === 4 ? 1 : 0;\n  },\n  buttons: null,\n  relatedTarget: function(event) {\n    return event.relatedTarget || (\n      event.fromElement === event.srcElement ?\n        event.toElement :\n        event.fromElement\n    );\n  },\n  // &quot;Proprietary&quot; Interface.\n  pageX: function(event) {\n    return &apos;pageX&apos; in event ?\n      event.pageX :\n      event.clientX + ViewportMetrics.currentScrollLeft;\n  },\n  pageY: function(event) {\n    return &apos;pageY&apos; in event ?\n      event.pageY :\n      event.clientY + ViewportMetrics.currentScrollTop;\n  }\n};\n\n/**\n * @param {object} dispatchConfig Configuration used to dispatch this event.\n * @param {string} dispatchMarker Marker identifying the event target.\n * @param {object} nativeEvent Native browser event.\n * @extends {SyntheticUIEvent}\n */\nfunction SyntheticMouseEvent(dispatchConfig, dispatchMarker, nativeEvent) {\n  SyntheticUIEvent.call(this, dispatchConfig, dispatchMarker, nativeEvent);\n}\n\nSyntheticUIEvent.augmentClass(SyntheticMouseEvent, MouseEventInterface);\n\nmodule.exports = SyntheticMouseEvent;\n\n},{&quot;./SyntheticUIEvent&quot;:82,&quot;./ViewportMetrics&quot;:85}],81:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule SyntheticTouchEvent\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar SyntheticUIEvent = require(&quot;./SyntheticUIEvent&quot;);\n\n/**\n * @interface TouchEvent\n * @see http://www.w3.org/TR/touch-events/\n */\nvar TouchEventInterface = {\n  touches: null,\n  targetTouches: null,\n  changedTouches: null,\n  altKey: null,\n  metaKey: null,\n  ctrlKey: null,\n  shiftKey: null\n};\n\n/**\n * @param {object} dispatchConfig Configuration used to dispatch this event.\n * @param {string} dispatchMarker Marker identifying the event target.\n * @param {object} nativeEvent Native browser event.\n * @extends {SyntheticUIEvent}\n */\nfunction SyntheticTouchEvent(dispatchConfig, dispatchMarker, nativeEvent) {\n  SyntheticUIEvent.call(this, dispatchConfig, dispatchMarker, nativeEvent);\n}\n\nSyntheticUIEvent.augmentClass(SyntheticTouchEvent, TouchEventInterface);\n\nmodule.exports = SyntheticTouchEvent;\n\n},{&quot;./SyntheticUIEvent&quot;:82}],82:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule SyntheticUIEvent\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar SyntheticEvent = require(&quot;./SyntheticEvent&quot;);\n\n/**\n * @interface UIEvent\n * @see http://www.w3.org/TR/DOM-Level-3-Events/\n */\nvar UIEventInterface = {\n  view: null,\n  detail: null\n};\n\n/**\n * @param {object} dispatchConfig Configuration used to dispatch this event.\n * @param {string} dispatchMarker Marker identifying the event target.\n * @param {object} nativeEvent Native browser event.\n * @extends {SyntheticEvent}\n */\nfunction SyntheticUIEvent(dispatchConfig, dispatchMarker, nativeEvent) {\n  SyntheticEvent.call(this, dispatchConfig, dispatchMarker, nativeEvent);\n}\n\nSyntheticEvent.augmentClass(SyntheticUIEvent, UIEventInterface);\n\nmodule.exports = SyntheticUIEvent;\n\n},{&quot;./SyntheticEvent&quot;:77}],83:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule SyntheticWheelEvent\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar SyntheticMouseEvent = require(&quot;./SyntheticMouseEvent&quot;);\n\n/**\n * @interface WheelEvent\n * @see http://www.w3.org/TR/DOM-Level-3-Events/\n */\nvar WheelEventInterface = {\n  deltaX: function(event) {\n    return (\n      &apos;deltaX&apos; in event ? event.deltaX :\n      // Fallback to `wheelDeltaX` for Webkit and normalize (right is positive).\n      &apos;wheelDeltaX&apos; in event ? -event.wheelDeltaX : 0\n    );\n  },\n  deltaY: function(event) {\n    return (\n      &apos;deltaY&apos; in event ? event.deltaY :\n      // Fallback to `wheelDeltaY` for Webkit and normalize (down is positive).\n      &apos;wheelDeltaY&apos; in event ? -event.wheelDeltaY :\n      // Fallback to `wheelDelta` for IE&lt;9 and normalize (down is positive).\n      &apos;wheelDelta&apos; in event ? -event.wheelDelta : 0\n    );\n  },\n  deltaZ: null,\n\n  // Browsers without &quot;deltaMode&quot; is reporting in raw wheel delta where one\n  // notch on the scroll is always +/- 120, roughly equivalent to pixels.\n  // A good approximation of DOM_DELTA_LINE (1) is 5% of viewport size or\n  // ~40 pixels, for DOM_DELTA_SCREEN (2) it is 87.5% of viewport size.\n  deltaMode: null\n};\n\n/**\n * @param {object} dispatchConfig Configuration used to dispatch this event.\n * @param {string} dispatchMarker Marker identifying the event target.\n * @param {object} nativeEvent Native browser event.\n * @extends {SyntheticMouseEvent}\n */\nfunction SyntheticWheelEvent(dispatchConfig, dispatchMarker, nativeEvent) {\n  SyntheticMouseEvent.call(this, dispatchConfig, dispatchMarker, nativeEvent);\n}\n\nSyntheticMouseEvent.augmentClass(SyntheticWheelEvent, WheelEventInterface);\n\nmodule.exports = SyntheticWheelEvent;\n\n},{&quot;./SyntheticMouseEvent&quot;:80}],84:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule Transaction\n */\n\n&quot;use strict&quot;;\n\nvar invariant = require(&quot;./invariant&quot;);\n\n/**\n * `Transaction` creates a black box that is able to wrap any method such that\n * certain invariants are maintained before and after the method is invoked\n * (Even if an exception is thrown while invoking the wrapped method). Whoever\n * instantiates a transaction can provide enforcers of the invariants at\n * creation time. The `Transaction` class itself will supply one additional\n * automatic invariant for you - the invariant that any transaction instance\n * should not be run while it is already being run. You would typically create a\n * single instance of a `Transaction` for reuse multiple times, that potentially\n * is used to wrap several different methods. Wrappers are extremely simple -\n * they only require implementing two methods.\n *\n * &lt;pre&gt;\n *                       wrappers (injected at creation time)\n *                                      +        +\n *                                      |        |\n *                    +-----------------|--------|--------------+\n *                    |                 v        |              |\n *                    |      +---------------+   |              |\n *                    |   +--|    wrapper1   |---|----+         |\n *                    |   |  +---------------+   v    |         |\n *                    |   |          +-------------+  |         |\n *                    |   |     +----|   wrapper2  |--------+   |\n *                    |   |     |    +-------------+  |     |   |\n *                    |   |     |                     |     |   |\n *                    |   v     v                     v     v   | wrapper\n *                    | +---+ +---+   +---------+   +---+ +---+ | invariants\n * perform(anyMethod) | |   | |   |   |         |   |   | |   | | maintained\n * +-----------------&gt;|-|---|-|---|--&gt;|anyMethod|---|---|-|---|-|--------&gt;\n *                    | |   | |   |   |         |   |   | |   | |\n *                    | |   | |   |   |         |   |   | |   | |\n *                    | |   | |   |   |         |   |   | |   | |\n *                    | +---+ +---+   +---------+   +---+ +---+ |\n *                    |  initialize                    close    |\n *                    +-----------------------------------------+\n * &lt;/pre&gt;\n *\n * Bonus:\n * - Reports timing metrics by method name and wrapper index.\n *\n * Use cases:\n * - Preserving the input selection ranges before/after reconciliation.\n *   Restoring selection even in the event of an unexpected error.\n * - Deactivating events while rearranging the DOM, preventing blurs/focuses,\n *   while guaranteeing that afterwards, the event system is reactivated.\n * - Flushing a queue of collected DOM mutations to the main UI thread after a\n *   reconciliation takes place in a worker thread.\n * - Invoking any collected `componentDidUpdate` callbacks after rendering new\n *   content.\n * - (Future use case): Wrapping particular flushes of the `ReactWorker` queue\n *   to preserve the `scrollTop` (an automatic scroll aware DOM).\n * - (Future use case): Layout calculations before and after DOM upates.\n *\n * Transactional plugin API:\n * - A module that has an `initialize` method that returns any precomputation.\n * - and a `close` method that accepts the precomputation. `close` is invoked\n *   when the wrapped process is completed, or has failed.\n *\n * @param {Array&lt;TransactionalWrapper&gt;} transactionWrapper Wrapper modules\n * that implement `initialize` and `close`.\n * @return {Transaction} Single transaction for reuse in thread.\n *\n * @class Transaction\n */\nvar Mixin = {\n  /**\n   * Sets up this instance so that it is prepared for collecting metrics. Does\n   * so such that this setup method may be used on an instance that is already\n   * initialized, in a way that does not consume additional memory upon reuse.\n   * That can be useful if you decide to make your subclass of this mixin a\n   * &quot;PooledClass&quot;.\n   */\n  reinitializeTransaction: function() {\n    this.transactionWrappers = this.getTransactionWrappers();\n    if (!this.wrapperInitData) {\n      this.wrapperInitData = [];\n    } else {\n      this.wrapperInitData.length = 0;\n    }\n    if (!this.timingMetrics) {\n      this.timingMetrics = {};\n    }\n    this.timingMetrics.methodInvocationTime = 0;\n    if (!this.timingMetrics.wrapperInitTimes) {\n      this.timingMetrics.wrapperInitTimes = [];\n    } else {\n      this.timingMetrics.wrapperInitTimes.length = 0;\n    }\n    if (!this.timingMetrics.wrapperCloseTimes) {\n      this.timingMetrics.wrapperCloseTimes = [];\n    } else {\n      this.timingMetrics.wrapperCloseTimes.length = 0;\n    }\n    this._isInTransaction = false;\n  },\n\n  _isInTransaction: false,\n\n  /**\n   * @abstract\n   * @return {Array&lt;TransactionWrapper&gt;} Array of transaction wrappers.\n   */\n  getTransactionWrappers: null,\n\n  isInTransaction: function() {\n    return !!this._isInTransaction;\n  },\n\n  /**\n   * Executes the function within a safety window. Use this for the top level\n   * methods that result in large amounts of computation/mutations that would\n   * need to be safety checked.\n   *\n   * @param {function} method Member of scope to call.\n   * @param {Object} scope Scope to invoke from.\n   * @param {Object?=} args... Arguments to pass to the method (optional).\n   *                           Helps prevent need to bind in many cases.\n   * @return Return value from `method`.\n   */\n  perform: function(method, scope, a, b, c, d, e, f) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      !this.isInTransaction(),\n      &apos;Transaction.perform(...): Cannot initialize a transaction when there &apos; +\n      &apos;is already an outstanding transaction.&apos;\n    ) : invariant(!this.isInTransaction()));\n    var memberStart = Date.now();\n    var errorThrown;\n    var ret;\n    try {\n      this._isInTransaction = true;\n      // Catching errors makes debugging more difficult, so we start with\n      // errorThrown set to true before setting it to false after calling\n      // close -- if it&apos;s still set to true in the finally block, it means\n      // one of these calls threw.\n      errorThrown = true;\n      this.initializeAll(0);\n      ret = method.call(scope, a, b, c, d, e, f);\n      errorThrown = false;\n    } finally {\n      var memberEnd = Date.now();\n      this.methodInvocationTime += (memberEnd - memberStart);\n      try {\n        if (errorThrown) {\n          // If `method` throws, prefer to show that stack trace over any thrown\n          // by invoking `closeAll`.\n          try {\n            this.closeAll(0);\n          } catch (err) {\n          }\n        } else {\n          // Since `method` didn&apos;t throw, we don&apos;t want to silence the exception\n          // here.\n          this.closeAll(0);\n        }\n      } finally {\n        this._isInTransaction = false;\n      }\n    }\n    return ret;\n  },\n\n  initializeAll: function(startIndex) {\n    var transactionWrappers = this.transactionWrappers;\n    var wrapperInitTimes = this.timingMetrics.wrapperInitTimes;\n    for (var i = startIndex; i &lt; transactionWrappers.length; i++) {\n      var initStart = Date.now();\n      var wrapper = transactionWrappers[i];\n      try {\n        // Catching errors makes debugging more difficult, so we start with the\n        // OBSERVED_ERROR state before overwriting it with the real return value\n        // of initialize -- if it&apos;s still set to OBSERVED_ERROR in the finally\n        // block, it means wrapper.initialize threw.\n        this.wrapperInitData[i] = Transaction.OBSERVED_ERROR;\n        this.wrapperInitData[i] = wrapper.initialize ?\n          wrapper.initialize.call(this) :\n          null;\n      } finally {\n        var curInitTime = wrapperInitTimes[i];\n        var initEnd = Date.now();\n        wrapperInitTimes[i] = (curInitTime || 0) + (initEnd - initStart);\n\n        if (this.wrapperInitData[i] === Transaction.OBSERVED_ERROR) {\n          // The initializer for wrapper i threw an error; initialize the\n          // remaining wrappers but silence any exceptions from them to ensure\n          // that the first error is the one to bubble up.\n          try {\n            this.initializeAll(i + 1);\n          } catch (err) {\n          }\n        }\n      }\n    }\n  },\n\n  /**\n   * Invokes each of `this.transactionWrappers.close[i]` functions, passing into\n   * them the respective return values of `this.transactionWrappers.init[i]`\n   * (`close`rs that correspond to initializers that failed will not be\n   * invoked).\n   */\n  closeAll: function(startIndex) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      this.isInTransaction(),\n      &apos;Transaction.closeAll(): Cannot close transaction when none are open.&apos;\n    ) : invariant(this.isInTransaction()));\n    var transactionWrappers = this.transactionWrappers;\n    var wrapperCloseTimes = this.timingMetrics.wrapperCloseTimes;\n    for (var i = startIndex; i &lt; transactionWrappers.length; i++) {\n      var wrapper = transactionWrappers[i];\n      var closeStart = Date.now();\n      var initData = this.wrapperInitData[i];\n      var errorThrown;\n      try {\n        // Catching errors makes debugging more difficult, so we start with\n        // errorThrown set to true before setting it to false after calling\n        // close -- if it&apos;s still set to true in the finally block, it means\n        // wrapper.close threw.\n        errorThrown = true;\n        if (initData !== Transaction.OBSERVED_ERROR) {\n          wrapper.close &amp;&amp; wrapper.close.call(this, initData);\n        }\n        errorThrown = false;\n      } finally {\n        var closeEnd = Date.now();\n        var curCloseTime = wrapperCloseTimes[i];\n        wrapperCloseTimes[i] = (curCloseTime || 0) + (closeEnd - closeStart);\n\n        if (errorThrown) {\n          // The closer for wrapper i threw an error; close the remaining\n          // wrappers but silence any exceptions from them to ensure that the\n          // first error is the one to bubble up.\n          try {\n            this.closeAll(i + 1);\n          } catch (e) {\n          }\n        }\n      }\n    }\n    this.wrapperInitData.length = 0;\n  }\n};\n\nvar Transaction = {\n\n  Mixin: Mixin,\n\n  /**\n   * Token to look for to determine if an error occured.\n   */\n  OBSERVED_ERROR: {}\n\n};\n\nmodule.exports = Transaction;\n\n},{&quot;./invariant&quot;:108}],85:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule ViewportMetrics\n */\n\n&quot;use strict&quot;;\n\nvar getUnboundedScrollPosition = require(&quot;./getUnboundedScrollPosition&quot;);\n\nvar ViewportMetrics = {\n\n  currentScrollLeft: 0,\n\n  currentScrollTop: 0,\n\n  refreshScrollValues: function() {\n    var scrollPosition = getUnboundedScrollPosition(window);\n    ViewportMetrics.currentScrollLeft = scrollPosition.x;\n    ViewportMetrics.currentScrollTop = scrollPosition.y;\n  }\n\n};\n\nmodule.exports = ViewportMetrics;\n\n},{&quot;./getUnboundedScrollPosition&quot;:106}],86:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule accumulate\n */\n\n&quot;use strict&quot;;\n\nvar invariant = require(&quot;./invariant&quot;);\n\n/**\n * Accumulates items that must not be null or undefined.\n *\n * This is used to conserve memory by avoiding array allocations.\n *\n * @return {*|array&lt;*&gt;} An accumulation of items.\n */\nfunction accumulate(current, next) {\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    next != null,\n    &apos;accumulate(...): Accumulated items must be not be null or undefined.&apos;\n  ) : invariant(next != null));\n  if (current == null) {\n    return next;\n  } else {\n    // Both are not empty. Warning: Never call x.concat(y) when you are not\n    // certain that x is an Array (x could be a string with concat method).\n    var currentIsArray = Array.isArray(current);\n    var nextIsArray = Array.isArray(next);\n    if (currentIsArray) {\n      return current.concat(next);\n    } else {\n      if (nextIsArray) {\n        return [current].concat(next);\n      } else {\n        return [current, next];\n      }\n    }\n  }\n}\n\nmodule.exports = accumulate;\n\n},{&quot;./invariant&quot;:108}],87:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule adler32\n */\n\n/* jslint bitwise:true */\n\n&quot;use strict&quot;;\n\nvar MOD = 65521;\n\n// This is a clean-room implementation of adler32 designed for detecting\n// if markup is not what we expect it to be. It does not need to be\n// cryptographically strong, only reasonable good at detecting if markup\n// generated on the server is different than that on the client.\nfunction adler32(data) {\n  var a = 1;\n  var b = 0;\n  for (var i = 0; i &lt; data.length; i++) {\n    a = (a + data.charCodeAt(i)) % MOD;\n    b = (b + a) % MOD;\n  }\n  return a | (b &lt;&lt; 16);\n}\n\nmodule.exports = adler32;\n\n},{}],88:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule containsNode\n * @typechecks\n */\n\nvar isTextNode = require(&quot;./isTextNode&quot;);\n\n/*jslint bitwise:true */\n\n/**\n * Checks if a given DOM node contains or is another DOM node.\n *\n * @param {?DOMNode} outerNode Outer DOM node.\n * @param {?DOMNode} innerNode Inner DOM node.\n * @return {boolean} True if `outerNode` contains or is `innerNode`.\n */\nfunction containsNode(outerNode, innerNode) {\n  if (!outerNode || !innerNode) {\n    return false;\n  } else if (outerNode === innerNode) {\n    return true;\n  } else if (isTextNode(outerNode)) {\n    return false;\n  } else if (isTextNode(innerNode)) {\n    return containsNode(outerNode, innerNode.parentNode);\n  } else if (outerNode.contains) {\n    return outerNode.contains(innerNode);\n  } else if (outerNode.compareDocumentPosition) {\n    return !!(outerNode.compareDocumentPosition(innerNode) &amp; 16);\n  } else {\n    return false;\n  }\n}\n\nmodule.exports = containsNode;\n\n},{&quot;./isTextNode&quot;:112}],89:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule copyProperties\n */\n\n/**\n * Copy properties from one or more objects (up to 5) into the first object.\n * This is a shallow copy. It mutates the first object and also returns it.\n *\n * NOTE: `arguments` has a very significant performance penalty, which is why\n * we don&apos;t support unlimited arguments.\n */\nfunction copyProperties(obj, a, b, c, d, e, f) {\n  obj = obj || {};\n\n  if (&quot;production&quot; !== &quot;development&quot;) {\n    if (f) {\n      throw new Error(&apos;Too many arguments passed to copyProperties&apos;);\n    }\n  }\n\n  var args = [a, b, c, d, e];\n  var ii = 0, v;\n  while (args[ii]) {\n    v = args[ii++];\n    for (var k in v) {\n      obj[k] = v[k];\n    }\n\n    // IE ignores toString in object iteration.. See:\n    // webreflection.blogspot.com/2007/07/quick-fix-internet-explorer-and.html\n    if (v.hasOwnProperty &amp;&amp; v.hasOwnProperty(&apos;toString&apos;) &amp;&amp;\n        (typeof v.toString != &apos;undefined&apos;) &amp;&amp; (obj.toString !== v.toString)) {\n      obj.toString = v.toString;\n    }\n  }\n\n  return obj;\n}\n\nmodule.exports = copyProperties;\n\n},{}],90:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule createArrayFrom\n * @typechecks\n */\n\nvar toArray = require(&quot;./toArray&quot;);\n\n/**\n * Perform a heuristic test to determine if an object is &quot;array-like&quot;.\n *\n *   A monk asked Joshu, a Zen master, &quot;Has a dog Buddha nature?&quot;\n *   Joshu replied: &quot;Mu.&quot;\n *\n * This function determines if its argument has &quot;array nature&quot;: it returns\n * true if the argument is an actual array, an `arguments&apos; object, or an\n * HTMLCollection (e.g. node.childNodes or node.getElementsByTagName()).\n *\n * It will return false for other array-like objects like Filelist.\n *\n * @param {*} obj\n * @return {boolean}\n */\nfunction hasArrayNature(obj) {\n  return (\n    // not null/false\n    !!obj &amp;&amp;\n    // arrays are objects, NodeLists are functions in Safari\n    (typeof obj == &apos;object&apos; || typeof obj == &apos;function&apos;) &amp;&amp;\n    // quacks like an array\n    (&apos;length&apos; in obj) &amp;&amp;\n    // not window\n    !(&apos;setInterval&apos; in obj) &amp;&amp;\n    // no DOM node should be considered an array-like\n    // a &apos;select&apos; element has &apos;length&apos; and &apos;item&apos; properties on IE8\n    (typeof obj.nodeType != &apos;number&apos;) &amp;&amp;\n    (\n      // a real array\n      (// HTMLCollection/NodeList\n      (Array.isArray(obj) ||\n      // arguments\n      (&apos;callee&apos; in obj) || &apos;item&apos; in obj))\n    )\n  );\n}\n\n/**\n * Ensure that the argument is an array by wrapping it in an array if it is not.\n * Creates a copy of the argument if it is already an array.\n *\n * This is mostly useful idiomatically:\n *\n *   var createArrayFrom = require(&apos;createArrayFrom&apos;);\n *\n *   function takesOneOrMoreThings(things) {\n *     things = createArrayFrom(things);\n *     ...\n *   }\n *\n * This allows you to treat `things&apos; as an array, but accept scalars in the API.\n *\n * If you need to convert an array-like object, like `arguments`, into an array\n * use toArray instead.\n *\n * @param {*} obj\n * @return {array}\n */\nfunction createArrayFrom(obj) {\n  if (!hasArrayNature(obj)) {\n    return [obj];\n  } else if (Array.isArray(obj)) {\n    return obj.slice();\n  } else {\n    return toArray(obj);\n  }\n}\n\nmodule.exports = createArrayFrom;\n\n},{&quot;./toArray&quot;:127}],91:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule createFullPageComponent\n * @typechecks\n */\n\n&quot;use strict&quot;;\n\n// Defeat circular references by requiring this directly.\nvar ReactCompositeComponent = require(&quot;./ReactCompositeComponent&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\n\n/**\n * Create a component that will throw an exception when unmounted.\n *\n * Components like &lt;html&gt; &lt;head&gt; and &lt;body&gt; can&apos;t be removed or added\n * easily in a cross-browser way, however it&apos;s valuable to be able to\n * take advantage of React&apos;s reconciliation for styling and &lt;title&gt;\n * management. So we just document it and throw in dangerous cases.\n *\n * @param {function} componentClass convenience constructor to wrap\n * @return {function} convenience constructor of new component\n */\nfunction createFullPageComponent(componentClass) {\n  var FullPageComponent = ReactCompositeComponent.createClass({\n    displayName: &apos;ReactFullPageComponent&apos; + (\n      componentClass.componentConstructor.displayName || &apos;&apos;\n    ),\n\n    componentWillUnmount: function() {\n      (&quot;production&quot; !== &quot;development&quot; ? invariant(\n        false,\n        &apos;%s tried to unmount. Because of cross-browser quirks it is &apos; +\n        &apos;impossible to unmount some top-level components (eg &lt;html&gt;, &lt;head&gt;, &apos; +\n        &apos;and &lt;body&gt;) reliably and efficiently. To fix this, have a single &apos; +\n        &apos;top-level component that never unmounts render these elements.&apos;,\n        this.constructor.displayName\n      ) : invariant(false));\n    },\n\n    render: function() {\n      return this.transferPropsTo(componentClass(null, this.props.children));\n    }\n  });\n\n  return FullPageComponent;\n}\n\nmodule.exports = createFullPageComponent;\n\n},{&quot;./ReactCompositeComponent&quot;:29,&quot;./invariant&quot;:108}],92:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule createNodesFromMarkup\n * @typechecks\n */\n\n/*jslint evil: true, sub: true */\n\nvar ExecutionEnvironment = require(&quot;./ExecutionEnvironment&quot;);\n\nvar createArrayFrom = require(&quot;./createArrayFrom&quot;);\nvar getMarkupWrap = require(&quot;./getMarkupWrap&quot;);\nvar invariant = require(&quot;./invariant&quot;);\n\n/**\n * Dummy container used to render all markup.\n */\nvar dummyNode =\n  ExecutionEnvironment.canUseDOM ? document.createElement(&apos;div&apos;) : null;\n\n/**\n * Pattern used by `getNodeName`.\n */\nvar nodeNamePattern = /^\\s*&lt;(\\w+)/;\n\n/**\n * Extracts the `nodeName` of the first element in a string of markup.\n *\n * @param {string} markup String of markup.\n * @return {?string} Node name of the supplied markup.\n */\nfunction getNodeName(markup) {\n  var nodeNameMatch = markup.match(nodeNamePattern);\n  return nodeNameMatch &amp;&amp; nodeNameMatch[1].toLowerCase();\n}\n\n/**\n * Creates an array containing the nodes rendered from the supplied markup. The\n * optionally supplied `handleScript` function will be invoked once for each\n * &lt;script&gt; element that is rendered. If no `handleScript` function is supplied,\n * an exception is thrown if any &lt;script&gt; elements are rendered.\n *\n * @param {string} markup A string of valid HTML markup.\n * @param {?function} handleScript Invoked once for each rendered &lt;script&gt;.\n * @return {array&lt;DOMElement|DOMTextNode&gt;} An array of rendered nodes.\n */\nfunction createNodesFromMarkup(markup, handleScript) {\n  var node = dummyNode;\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(!!dummyNode, &apos;createNodesFromMarkup dummy not initialized&apos;) : invariant(!!dummyNode));\n  var nodeName = getNodeName(markup);\n\n  var wrap = nodeName &amp;&amp; getMarkupWrap(nodeName);\n  if (wrap) {\n    node.innerHTML = wrap[1] + markup + wrap[2];\n\n    var wrapDepth = wrap[0];\n    while (wrapDepth--) {\n      node = node.lastChild;\n    }\n  } else {\n    node.innerHTML = markup;\n  }\n\n  var scripts = node.getElementsByTagName(&apos;script&apos;);\n  if (scripts.length) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      handleScript,\n      &apos;createNodesFromMarkup(...): Unexpected &lt;script&gt; element rendered.&apos;\n    ) : invariant(handleScript));\n    createArrayFrom(scripts).forEach(handleScript);\n  }\n\n  var nodes = createArrayFrom(node.childNodes);\n  while (node.lastChild) {\n    node.removeChild(node.lastChild);\n  }\n  return nodes;\n}\n\nmodule.exports = createNodesFromMarkup;\n\n},{&quot;./ExecutionEnvironment&quot;:20,&quot;./createArrayFrom&quot;:90,&quot;./getMarkupWrap&quot;:102,&quot;./invariant&quot;:108}],93:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule createObjectFrom\n */\n\n/**\n * Construct an object from an array of keys\n * and optionally specified value or list of values.\n *\n *  &gt;&gt;&gt; createObjectFrom([&apos;a&apos;,&apos;b&apos;,&apos;c&apos;]);\n *  {a: true, b: true, c: true}\n *\n *  &gt;&gt;&gt; createObjectFrom([&apos;a&apos;,&apos;b&apos;,&apos;c&apos;], false);\n *  {a: false, b: false, c: false}\n *\n *  &gt;&gt;&gt; createObjectFrom([&apos;a&apos;,&apos;b&apos;,&apos;c&apos;], &apos;monkey&apos;);\n *  {c:&apos;monkey&apos;, b:&apos;monkey&apos; c:&apos;monkey&apos;}\n *\n *  &gt;&gt;&gt; createObjectFrom([&apos;a&apos;,&apos;b&apos;,&apos;c&apos;], [1,2,3]);\n *  {a: 1, b: 2, c: 3}\n *\n *  &gt;&gt;&gt; createObjectFrom([&apos;women&apos;, &apos;men&apos;], [true, false]);\n *  {women: true, men: false}\n *\n * @param   Array   list of keys\n * @param   mixed   optional value or value array.  defaults true.\n * @returns object\n */\nfunction createObjectFrom(keys, values /* = true */) {\n  if (&quot;production&quot; !== &quot;development&quot;) {\n    if (!Array.isArray(keys)) {\n      throw new TypeError(&apos;Must pass an array of keys.&apos;);\n    }\n  }\n\n  var object = {};\n  var isArray = Array.isArray(values);\n  if (typeof values == &apos;undefined&apos;) {\n    values = true;\n  }\n\n  for (var ii = keys.length; ii--;) {\n    object[keys[ii]] = isArray ? values[ii] : values;\n  }\n  return object;\n}\n\nmodule.exports = createObjectFrom;\n\n},{}],94:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule dangerousStyleValue\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar CSSProperty = require(&quot;./CSSProperty&quot;);\n\n/**\n * Convert a value into the proper css writable value. The `styleName` name\n * name should be logical (no hyphens), as specified\n * in `CSSProperty.isUnitlessNumber`.\n *\n * @param {string} styleName CSS property name such as `topMargin`.\n * @param {*} value CSS property value such as `10px`.\n * @return {string} Normalized style value with dimensions applied.\n */\nfunction dangerousStyleValue(styleName, value) {\n  // Note that we&apos;ve removed escapeTextForBrowser() calls here since the\n  // whole string will be escaped when the attribute is injected into\n  // the markup. If you provide unsafe user data here they can inject\n  // arbitrary CSS which may be problematic (I couldn&apos;t repro this):\n  // https://www.owasp.org/index.php/XSS_Filter_Evasion_Cheat_Sheet\n  // http://www.thespanner.co.uk/2007/11/26/ultimate-xss-css-injection/\n  // This is not an XSS hole but instead a potential CSS injection issue\n  // which has lead to a greater discussion about how we&apos;re going to\n  // trust URLs moving forward. See #2115901\n\n  var isEmpty = value == null || typeof value === &apos;boolean&apos; || value === &apos;&apos;;\n  if (isEmpty) {\n    return &apos;&apos;;\n  }\n\n  var isNonNumeric = isNaN(value);\n  if (isNonNumeric || value === 0 || CSSProperty.isUnitlessNumber[styleName]) {\n    return &apos;&apos; + value; // cast to string\n  }\n\n  return value + &apos;px&apos;;\n}\n\nmodule.exports = dangerousStyleValue;\n\n},{&quot;./CSSProperty&quot;:2}],95:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule emptyFunction\n */\n\nvar copyProperties = require(&quot;./copyProperties&quot;);\n\nfunction makeEmptyFunction(arg) {\n  return function() {\n    return arg;\n  };\n}\n\n/**\n * This function accepts and discards inputs; it has no side effects. This is\n * primarily useful idiomatically for overridable function endpoints which\n * always need to be callable, since JS lacks a null-call idiom ala Cocoa.\n */\nfunction emptyFunction() {}\n\ncopyProperties(emptyFunction, {\n  thatReturns: makeEmptyFunction,\n  thatReturnsFalse: makeEmptyFunction(false),\n  thatReturnsTrue: makeEmptyFunction(true),\n  thatReturnsNull: makeEmptyFunction(null),\n  thatReturnsThis: function() { return this; },\n  thatReturnsArgument: function(arg) { return arg; }\n});\n\nmodule.exports = emptyFunction;\n\n},{&quot;./copyProperties&quot;:89}],96:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule escapeTextForBrowser\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar ESCAPE_LOOKUP = {\n  &quot;&amp;&quot;: &quot;&amp;amp;&quot;,\n  &quot;&gt;&quot;: &quot;&amp;gt;&quot;,\n  &quot;&lt;&quot;: &quot;&amp;lt;&quot;,\n  &quot;\\&quot;&quot;: &quot;&amp;quot;&quot;,\n  &quot;&apos;&quot;: &quot;&amp;#x27;&quot;,\n  &quot;/&quot;: &quot;&amp;#x2f;&quot;\n};\n\nvar ESCAPE_REGEX = /[&amp;&gt;&lt;&quot;&apos;\\/]/g;\n\nfunction escaper(match) {\n  return ESCAPE_LOOKUP[match];\n}\n\n/**\n * Escapes text to prevent scripting attacks.\n *\n * @param {*} text Text value to escape.\n * @return {string} An escaped string.\n */\nfunction escapeTextForBrowser(text) {\n  return (&apos;&apos; + text).replace(ESCAPE_REGEX, escaper);\n}\n\nmodule.exports = escapeTextForBrowser;\n\n},{}],97:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule flattenChildren\n */\n\n&quot;use strict&quot;;\n\nvar invariant = require(&quot;./invariant&quot;);\nvar traverseAllChildren = require(&quot;./traverseAllChildren&quot;);\n\n/**\n * @param {function} traverseContext Context passed through traversal.\n * @param {?ReactComponent} child React child component.\n * @param {!string} name String name of key path to child.\n */\nfunction flattenSingleChildIntoContext(traverseContext, child, name) {\n  // We found a component instance.\n  var result = traverseContext;\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    !result.hasOwnProperty(name),\n    &apos;flattenChildren(...): Encountered two children with the same key, `%s`. &apos; +\n    &apos;Children keys must be unique.&apos;,\n    name\n  ) : invariant(!result.hasOwnProperty(name)));\n  if (child != null) {\n    result[name] = child;\n  }\n}\n\n/**\n * Flattens children that are typically specified as `props.children`. Any null\n * children will not be included in the resulting object.\n * @return {!object} flattened children keyed by name.\n */\nfunction flattenChildren(children) {\n  if (children == null) {\n    return children;\n  }\n  var result = {};\n  traverseAllChildren(children, flattenSingleChildIntoContext, result);\n  return result;\n}\n\nmodule.exports = flattenChildren;\n\n},{&quot;./invariant&quot;:108,&quot;./traverseAllChildren&quot;:128}],98:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule forEachAccumulated\n */\n\n&quot;use strict&quot;;\n\n/**\n * @param {array} an &quot;accumulation&quot; of items which is either an Array or\n * a single item. Useful when paired with the `accumulate` module. This is a\n * simple utility that allows us to reason about a collection of items, but\n * handling the case when there is exactly one item (and we do not need to\n * allocate an array).\n */\nvar forEachAccumulated = function(arr, cb, scope) {\n  if (Array.isArray(arr)) {\n    arr.forEach(cb, scope);\n  } else if (arr) {\n    cb.call(scope, arr);\n  }\n};\n\nmodule.exports = forEachAccumulated;\n\n},{}],99:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule getActiveElement\n * @typechecks\n */\n\n/**\n * Same as document.activeElement but wraps in a try-catch block. In IE it is\n * not safe to call document.activeElement if there is nothing focused.\n *\n * The activeElement will be null only if the document body is not yet defined.\n */\nfunction getActiveElement() /*?DOMElement*/ {\n  try {\n    return document.activeElement || document.body;\n  } catch (e) {\n    return document.body;\n  }\n}\n\nmodule.exports = getActiveElement;\n\n},{}],100:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule getEventKey\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\n/**\n * Normalization of deprecated HTML5 &quot;key&quot; values\n * @see https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent#Key_names\n */\nvar normalizeKey = {\n  &apos;Esc&apos;: &apos;Escape&apos;,\n  &apos;Spacebar&apos;: &apos; &apos;,\n  &apos;Left&apos;: &apos;ArrowLeft&apos;,\n  &apos;Up&apos;: &apos;ArrowUp&apos;,\n  &apos;Right&apos;: &apos;ArrowRight&apos;,\n  &apos;Down&apos;: &apos;ArrowDown&apos;,\n  &apos;Del&apos;: &apos;Delete&apos;,\n  &apos;Win&apos;: &apos;OS&apos;,\n  &apos;Menu&apos;: &apos;ContextMenu&apos;,\n  &apos;Apps&apos;: &apos;ContextMenu&apos;,\n  &apos;Scroll&apos;: &apos;ScrollLock&apos;,\n  &apos;MozPrintableKey&apos;: &apos;Unidentified&apos;\n};\n\n/**\n * Translation from legacy &quot;which/keyCode&quot; to HTML5 &quot;key&quot;\n * Only special keys supported, all others depend on keyboard layout or browser\n * @see https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent#Key_names\n */\nvar translateToKey = {\n  8: &apos;Backspace&apos;,\n  9: &apos;Tab&apos;,\n  12: &apos;Clear&apos;,\n  13: &apos;Enter&apos;,\n  16: &apos;Shift&apos;,\n  17: &apos;Control&apos;,\n  18: &apos;Alt&apos;,\n  19: &apos;Pause&apos;,\n  20: &apos;CapsLock&apos;,\n  27: &apos;Escape&apos;,\n  32: &apos; &apos;,\n  33: &apos;PageUp&apos;,\n  34: &apos;PageDown&apos;,\n  35: &apos;End&apos;,\n  36: &apos;Home&apos;,\n  37: &apos;ArrowLeft&apos;,\n  38: &apos;ArrowUp&apos;,\n  39: &apos;ArrowRight&apos;,\n  40: &apos;ArrowDown&apos;,\n  45: &apos;Insert&apos;,\n  46: &apos;Delete&apos;,\n  112: &apos;F1&apos;, 113: &apos;F2&apos;, 114: &apos;F3&apos;, 115: &apos;F4&apos;, 116: &apos;F5&apos;, 117: &apos;F6&apos;,\n  118: &apos;F7&apos;, 119: &apos;F8&apos;, 120: &apos;F9&apos;, 121: &apos;F10&apos;, 122: &apos;F11&apos;, 123: &apos;F12&apos;,\n  144: &apos;NumLock&apos;,\n  145: &apos;ScrollLock&apos;,\n  224: &apos;Meta&apos;\n};\n\n/**\n * @param {object} nativeEvent Native browser event.\n * @return {string} Normalized `key` property.\n */\nfunction getEventKey(nativeEvent) {\n  return &apos;key&apos; in nativeEvent ?\n    normalizeKey[nativeEvent.key] || nativeEvent.key :\n    translateToKey[nativeEvent.which || nativeEvent.keyCode] || &apos;Unidentified&apos;;\n}\n\nmodule.exports = getEventKey;\n\n},{}],101:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule getEventTarget\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\n/**\n * Gets the target node from a native browser event by accounting for\n * inconsistencies in browser DOM APIs.\n *\n * @param {object} nativeEvent Native browser event.\n * @return {DOMEventTarget} Target node.\n */\nfunction getEventTarget(nativeEvent) {\n  var target = nativeEvent.target || nativeEvent.srcElement || window;\n  // Safari may fire events on text nodes (Node.TEXT_NODE is 3).\n  // @see http://www.quirksmode.org/js/events_properties.html\n  return target.nodeType === 3 ? target.parentNode : target;\n}\n\nmodule.exports = getEventTarget;\n\n},{}],102:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule getMarkupWrap\n */\n\nvar ExecutionEnvironment = require(&quot;./ExecutionEnvironment&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\n\n/**\n * Dummy container used to detect which wraps are necessary.\n */\nvar dummyNode =\n  ExecutionEnvironment.canUseDOM ? document.createElement(&apos;div&apos;) : null;\n\n/**\n * Some browsers cannot use `innerHTML` to render certain elements standalone,\n * so we wrap them, render the wrapped nodes, then extract the desired node.\n *\n * In IE8, certain elements cannot render alone, so wrap all elements (&apos;*&apos;).\n */\nvar shouldWrap = {\n  // Force wrapping for SVG elements because if they get created inside a &lt;div&gt;,\n  // they will be initialized in the wrong namespace (and will not display).\n  &apos;circle&apos;: true,\n  &apos;defs&apos;: true,\n  &apos;g&apos;: true,\n  &apos;line&apos;: true,\n  &apos;linearGradient&apos;: true,\n  &apos;path&apos;: true,\n  &apos;polygon&apos;: true,\n  &apos;polyline&apos;: true,\n  &apos;radialGradient&apos;: true,\n  &apos;rect&apos;: true,\n  &apos;stop&apos;: true,\n  &apos;text&apos;: true\n};\n\nvar selectWrap = [1, &apos;&lt;select multiple=&quot;true&quot;&gt;&apos;, &apos;&lt;/select&gt;&apos;];\nvar tableWrap = [1, &apos;&lt;table&gt;&apos;, &apos;&lt;/table&gt;&apos;];\nvar trWrap = [3, &apos;&lt;table&gt;&lt;tbody&gt;&lt;tr&gt;&apos;, &apos;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&apos;];\n\nvar svgWrap = [1, &apos;&lt;svg&gt;&apos;, &apos;&lt;/svg&gt;&apos;];\n\nvar markupWrap = {\n  &apos;*&apos;: [1, &apos;?&lt;div&gt;&apos;, &apos;&lt;/div&gt;&apos;],\n\n  &apos;area&apos;: [1, &apos;&lt;map&gt;&apos;, &apos;&lt;/map&gt;&apos;],\n  &apos;col&apos;: [2, &apos;&lt;table&gt;&lt;tbody&gt;&lt;/tbody&gt;&lt;colgroup&gt;&apos;, &apos;&lt;/colgroup&gt;&lt;/table&gt;&apos;],\n  &apos;legend&apos;: [1, &apos;&lt;fieldset&gt;&apos;, &apos;&lt;/fieldset&gt;&apos;],\n  &apos;param&apos;: [1, &apos;&lt;object&gt;&apos;, &apos;&lt;/object&gt;&apos;],\n  &apos;tr&apos;: [2, &apos;&lt;table&gt;&lt;tbody&gt;&apos;, &apos;&lt;/tbody&gt;&lt;/table&gt;&apos;],\n\n  &apos;optgroup&apos;: selectWrap,\n  &apos;option&apos;: selectWrap,\n\n  &apos;caption&apos;: tableWrap,\n  &apos;colgroup&apos;: tableWrap,\n  &apos;tbody&apos;: tableWrap,\n  &apos;tfoot&apos;: tableWrap,\n  &apos;thead&apos;: tableWrap,\n\n  &apos;td&apos;: trWrap,\n  &apos;th&apos;: trWrap,\n\n  &apos;circle&apos;: svgWrap,\n  &apos;defs&apos;: svgWrap,\n  &apos;g&apos;: svgWrap,\n  &apos;line&apos;: svgWrap,\n  &apos;linearGradient&apos;: svgWrap,\n  &apos;path&apos;: svgWrap,\n  &apos;polygon&apos;: svgWrap,\n  &apos;polyline&apos;: svgWrap,\n  &apos;radialGradient&apos;: svgWrap,\n  &apos;rect&apos;: svgWrap,\n  &apos;stop&apos;: svgWrap,\n  &apos;text&apos;: svgWrap\n};\n\n/**\n * Gets the markup wrap configuration for the supplied `nodeName`.\n *\n * NOTE: This lazily detects which wraps are necessary for the current browser.\n *\n * @param {string} nodeName Lowercase `nodeName`.\n * @return {?array} Markup wrap configuration, if applicable.\n */\nfunction getMarkupWrap(nodeName) {\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(!!dummyNode, &apos;Markup wrapping node not initialized&apos;) : invariant(!!dummyNode));\n  if (!markupWrap.hasOwnProperty(nodeName)) {\n    nodeName = &apos;*&apos;;\n  }\n  if (!shouldWrap.hasOwnProperty(nodeName)) {\n    if (nodeName === &apos;*&apos;) {\n      dummyNode.innerHTML = &apos;&lt;link /&gt;&apos;;\n    } else {\n      dummyNode.innerHTML = &apos;&lt;&apos; + nodeName + &apos;&gt;&lt;/&apos; + nodeName + &apos;&gt;&apos;;\n    }\n    shouldWrap[nodeName] = !dummyNode.firstChild;\n  }\n  return shouldWrap[nodeName] ? markupWrap[nodeName] : null;\n}\n\n\nmodule.exports = getMarkupWrap;\n\n},{&quot;./ExecutionEnvironment&quot;:20,&quot;./invariant&quot;:108}],103:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule getNodeForCharacterOffset\n */\n\n&quot;use strict&quot;;\n\n/**\n * Given any node return the first leaf node without children.\n *\n * @param {DOMElement|DOMTextNode} node\n * @return {DOMElement|DOMTextNode}\n */\nfunction getLeafNode(node) {\n  while (node &amp;&amp; node.firstChild) {\n    node = node.firstChild;\n  }\n  return node;\n}\n\n/**\n * Get the next sibling within a container. This will walk up the\n * DOM if a node&apos;s siblings have been exhausted.\n *\n * @param {DOMElement|DOMTextNode} node\n * @return {?DOMElement|DOMTextNode}\n */\nfunction getSiblingNode(node) {\n  while (node) {\n    if (node.nextSibling) {\n      return node.nextSibling;\n    }\n    node = node.parentNode;\n  }\n}\n\n/**\n * Get object describing the nodes which contain characters at offset.\n *\n * @param {DOMElement|DOMTextNode} root\n * @param {number} offset\n * @return {?object}\n */\nfunction getNodeForCharacterOffset(root, offset) {\n  var node = getLeafNode(root);\n  var nodeStart = 0;\n  var nodeEnd = 0;\n\n  while (node) {\n    if (node.nodeType == 3) {\n      nodeEnd = nodeStart + node.textContent.length;\n\n      if (nodeStart &lt;= offset &amp;&amp; nodeEnd &gt;= offset) {\n        return {\n          node: node,\n          offset: offset - nodeStart\n        };\n      }\n\n      nodeStart = nodeEnd;\n    }\n\n    node = getLeafNode(getSiblingNode(node));\n  }\n}\n\nmodule.exports = getNodeForCharacterOffset;\n\n},{}],104:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule getReactRootElementInContainer\n */\n\n&quot;use strict&quot;;\n\nvar DOC_NODE_TYPE = 9;\n\n/**\n * @param {DOMElement|DOMDocument} container DOM element that may contain\n *                                           a React component\n * @return {?*} DOM element that may have the reactRoot ID, or null.\n */\nfunction getReactRootElementInContainer(container) {\n  if (!container) {\n    return null;\n  }\n\n  if (container.nodeType === DOC_NODE_TYPE) {\n    return container.documentElement;\n  } else {\n    return container.firstChild;\n  }\n}\n\nmodule.exports = getReactRootElementInContainer;\n\n},{}],105:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule getTextContentAccessor\n */\n\n&quot;use strict&quot;;\n\nvar ExecutionEnvironment = require(&quot;./ExecutionEnvironment&quot;);\n\nvar contentKey = null;\n\n/**\n * Gets the key used to access text content on a DOM node.\n *\n * @return {?string} Key used to access text content.\n * @internal\n */\nfunction getTextContentAccessor() {\n  if (!contentKey &amp;&amp; ExecutionEnvironment.canUseDOM) {\n    // Prefer textContent to innerText because many browsers support both but\n    // SVG &lt;text&gt; elements don&apos;t support innerText even when &lt;div&gt; does.\n    contentKey = &apos;textContent&apos; in document.createElement(&apos;div&apos;) ?\n      &apos;textContent&apos; :\n      &apos;innerText&apos;;\n  }\n  return contentKey;\n}\n\nmodule.exports = getTextContentAccessor;\n\n},{&quot;./ExecutionEnvironment&quot;:20}],106:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule getUnboundedScrollPosition\n * @typechecks\n */\n\n&quot;use strict&quot;;\n\n/**\n * Gets the scroll position of the supplied element or window.\n *\n * The return values are unbounded, unlike `getScrollPosition`. This means they\n * may be negative or exceed the element boundaries (which is possible using\n * inertial scrolling).\n *\n * @param {DOMWindow|DOMElement} scrollable\n * @return {object} Map with `x` and `y` keys.\n */\nfunction getUnboundedScrollPosition(scrollable) {\n  if (scrollable === window) {\n    return {\n      x: window.pageXOffset || document.documentElement.scrollLeft,\n      y: window.pageYOffset || document.documentElement.scrollTop\n    };\n  }\n  return {\n    x: scrollable.scrollLeft,\n    y: scrollable.scrollTop\n  };\n}\n\nmodule.exports = getUnboundedScrollPosition;\n\n},{}],107:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule hyphenate\n * @typechecks\n */\n\nvar _uppercasePattern = /([A-Z])/g;\n\n/**\n * Hyphenates a camelcased string, for example:\n *\n *   &gt; hyphenate(&apos;backgroundColor&apos;)\n *   &lt; &quot;background-color&quot;\n *\n * @param {string} string\n * @return {string}\n */\nfunction hyphenate(string) {\n  return string.replace(_uppercasePattern, &apos;-$1&apos;).toLowerCase();\n}\n\nmodule.exports = hyphenate;\n\n},{}],108:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule invariant\n */\n\n&quot;use strict&quot;;\n\n/**\n * Use invariant() to assert state which your program assumes to be true.\n *\n * Provide sprintf-style format (only %s is supported) and arguments\n * to provide information about what broke and what you were\n * expecting.\n *\n * The invariant message will be stripped in production, but the invariant\n * will remain to ensure logic does not differ in production.\n */\n\nvar invariant = function(condition) {\n  if (!condition) {\n    var error = new Error(\n      &apos;Minified exception occured; use the non-minified dev environment for &apos; +\n      &apos;the full error message and additional helpful warnings.&apos;\n    );\n    error.framesToPop = 1;\n    throw error;\n  }\n};\n\nif (&quot;production&quot; !== &quot;development&quot;) {\n  invariant = function(condition, format, a, b, c, d, e, f) {\n    if (format === undefined) {\n      throw new Error(&apos;invariant requires an error message argument&apos;);\n    }\n\n    if (!condition) {\n      var args = [a, b, c, d, e, f];\n      var argIndex = 0;\n      var error = new Error(\n        &apos;Invariant Violation: &apos; +\n        format.replace(/%s/g, function() { return args[argIndex++]; })\n      );\n      error.framesToPop = 1; // we don&apos;t care about invariant&apos;s own frame\n      throw error;\n    }\n  };\n}\n\nmodule.exports = invariant;\n\n},{}],109:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule isEventSupported\n */\n\n&quot;use strict&quot;;\n\nvar ExecutionEnvironment = require(&quot;./ExecutionEnvironment&quot;);\n\nvar useHasFeature;\nif (ExecutionEnvironment.canUseDOM) {\n  useHasFeature =\n    document.implementation &amp;&amp;\n    document.implementation.hasFeature &amp;&amp;\n    // always returns true in newer browsers as per the standard.\n    // @see http://dom.spec.whatwg.org/#dom-domimplementation-hasfeature\n    document.implementation.hasFeature(&apos;&apos;, &apos;&apos;) !== true;\n}\n\n/**\n * Checks if an event is supported in the current execution environment.\n *\n * NOTE: This will not work correctly for non-generic events such as `change`,\n * `reset`, `load`, `error`, and `select`.\n *\n * Borrows from Modernizr.\n *\n * @param {string} eventNameSuffix Event name, e.g. &quot;click&quot;.\n * @param {?boolean} capture Check if the capture phase is supported.\n * @return {boolean} True if the event is supported.\n * @internal\n * @license Modernizr 3.0.0pre (Custom Build) | MIT\n */\nfunction isEventSupported(eventNameSuffix, capture) {\n  if (!ExecutionEnvironment.canUseDOM ||\n      capture &amp;&amp; !(&apos;addEventListener&apos; in document)) {\n    return false;\n  }\n\n  var eventName = &apos;on&apos; + eventNameSuffix;\n  var isSupported = eventName in document;\n\n  if (!isSupported) {\n    var element = document.createElement(&apos;div&apos;);\n    element.setAttribute(eventName, &apos;return;&apos;);\n    isSupported = typeof element[eventName] === &apos;function&apos;;\n  }\n\n  if (!isSupported &amp;&amp; useHasFeature &amp;&amp; eventNameSuffix === &apos;wheel&apos;) {\n    // This is the only way to test support for the `wheel` event in IE9+.\n    isSupported = document.implementation.hasFeature(&apos;Events.wheel&apos;, &apos;3.0&apos;);\n  }\n\n  return isSupported;\n}\n\nmodule.exports = isEventSupported;\n\n},{&quot;./ExecutionEnvironment&quot;:20}],110:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule isNode\n * @typechecks\n */\n\n/**\n * @param {*} object The object to check.\n * @return {boolean} Whether or not the object is a DOM node.\n */\nfunction isNode(object) {\n  return !!(object &amp;&amp; (\n    typeof Node !== &apos;undefined&apos; ? object instanceof Node :\n      typeof object === &apos;object&apos; &amp;&amp;\n      typeof object.nodeType === &apos;number&apos; &amp;&amp;\n      typeof object.nodeName === &apos;string&apos;\n  ));\n}\n\nmodule.exports = isNode;\n\n},{}],111:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule isTextInputElement\n */\n\n&quot;use strict&quot;;\n\n/**\n * @see http://www.whatwg.org/specs/web-apps/current-work/multipage/the-input-element.html#input-type-attr-summary\n */\nvar supportedInputTypes = {\n  &apos;color&apos;: true,\n  &apos;date&apos;: true,\n  &apos;datetime&apos;: true,\n  &apos;datetime-local&apos;: true,\n  &apos;email&apos;: true,\n  &apos;month&apos;: true,\n  &apos;number&apos;: true,\n  &apos;password&apos;: true,\n  &apos;range&apos;: true,\n  &apos;search&apos;: true,\n  &apos;tel&apos;: true,\n  &apos;text&apos;: true,\n  &apos;time&apos;: true,\n  &apos;url&apos;: true,\n  &apos;week&apos;: true\n};\n\nfunction isTextInputElement(elem) {\n  return elem &amp;&amp; (\n    (elem.nodeName === &apos;INPUT&apos; &amp;&amp; supportedInputTypes[elem.type]) ||\n    elem.nodeName === &apos;TEXTAREA&apos;\n  );\n}\n\nmodule.exports = isTextInputElement;\n\n},{}],112:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule isTextNode\n * @typechecks\n */\n\nvar isNode = require(&quot;./isNode&quot;);\n\n/**\n * @param {*} object The object to check.\n * @return {boolean} Whether or not the object is a DOM text node.\n */\nfunction isTextNode(object) {\n  return isNode(object) &amp;&amp; object.nodeType == 3;\n}\n\nmodule.exports = isTextNode;\n\n},{&quot;./isNode&quot;:110}],113:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule joinClasses\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\n/**\n * Combines multiple className strings into one.\n * http://jsperf.com/joinclasses-args-vs-array\n *\n * @param {...?string} classes\n * @return {string}\n */\nfunction joinClasses(className/*, ... */) {\n  if (!className) {\n    className = &apos;&apos;;\n  }\n  var nextClass;\n  var argLength = arguments.length;\n  if (argLength &gt; 1) {\n    for (var ii = 1; ii &lt; argLength; ii++) {\n      nextClass = arguments[ii];\n      nextClass &amp;&amp; (className += &apos; &apos; + nextClass);\n    }\n  }\n  return className;\n}\n\nmodule.exports = joinClasses;\n\n},{}],114:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule keyMirror\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar invariant = require(&quot;./invariant&quot;);\n\n/**\n * Constructs an enumeration with keys equal to their value.\n *\n * For example:\n *\n *   var COLORS = keyMirror({blue: null, red: null});\n *   var myColor = COLORS.blue;\n *   var isColorValid = !!COLORS[myColor];\n *\n * The last line could not be performed if the values of the generated enum were\n * not equal to their keys.\n *\n *   Input:  {key1: val1, key2: val2}\n *   Output: {key1: key1, key2: key2}\n *\n * @param {object} obj\n * @return {object}\n */\nvar keyMirror = function(obj) {\n  var ret = {};\n  var key;\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    obj instanceof Object &amp;&amp; !Array.isArray(obj),\n    &apos;keyMirror(...): Argument must be an object.&apos;\n  ) : invariant(obj instanceof Object &amp;&amp; !Array.isArray(obj)));\n  for (key in obj) {\n    if (!obj.hasOwnProperty(key)) {\n      continue;\n    }\n    ret[key] = key;\n  }\n  return ret;\n};\n\nmodule.exports = keyMirror;\n\n},{&quot;./invariant&quot;:108}],115:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule keyOf\n */\n\n/**\n * Allows extraction of a minified key. Let&apos;s the build system minify keys\n * without loosing the ability to dynamically use key strings as values\n * themselves. Pass in an object with a single key/val pair and it will return\n * you the string key of that single record. Suppose you want to grab the\n * value for a key &apos;className&apos; inside of an object. Key/val minification may\n * have aliased that key to be &apos;xa12&apos;. keyOf({className: null}) will return\n * &apos;xa12&apos; in that case. Resolve keys you want to use once at startup time, then\n * reuse those resolutions.\n */\nvar keyOf = function(oneKeyObj) {\n  var key;\n  for (key in oneKeyObj) {\n    if (!oneKeyObj.hasOwnProperty(key)) {\n      continue;\n    }\n    return key;\n  }\n  return null;\n};\n\n\nmodule.exports = keyOf;\n\n},{}],116:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule memoizeStringOnly\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\n/**\n * Memoizes the return value of a function that accepts one string argument.\n *\n * @param {function} callback\n * @return {function}\n */\nfunction memoizeStringOnly(callback) {\n  var cache = {};\n  return function(string) {\n    if (cache.hasOwnProperty(string)) {\n      return cache[string];\n    } else {\n      return cache[string] = callback.call(this, string);\n    }\n  };\n}\n\nmodule.exports = memoizeStringOnly;\n\n},{}],117:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule merge\n */\n\n&quot;use strict&quot;;\n\nvar mergeInto = require(&quot;./mergeInto&quot;);\n\n/**\n * Shallow merges two structures into a return value, without mutating either.\n *\n * @param {?object} one Optional object with properties to merge from.\n * @param {?object} two Optional object with properties to merge from.\n * @return {object} The shallow extension of one by two.\n */\nvar merge = function(one, two) {\n  var result = {};\n  mergeInto(result, one);\n  mergeInto(result, two);\n  return result;\n};\n\nmodule.exports = merge;\n\n},{&quot;./mergeInto&quot;:119}],118:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule mergeHelpers\n *\n * requiresPolyfills: Array.isArray\n */\n\n&quot;use strict&quot;;\n\nvar invariant = require(&quot;./invariant&quot;);\nvar keyMirror = require(&quot;./keyMirror&quot;);\n\n/**\n * Maximum number of levels to traverse. Will catch circular structures.\n * @const\n */\nvar MAX_MERGE_DEPTH = 36;\n\n/**\n * We won&apos;t worry about edge cases like new String(&apos;x&apos;) or new Boolean(true).\n * Functions are considered terminals, and arrays are not.\n * @param {*} o The item/object/value to test.\n * @return {boolean} true iff the argument is a terminal.\n */\nvar isTerminal = function(o) {\n  return typeof o !== &apos;object&apos; || o === null;\n};\n\nvar mergeHelpers = {\n\n  MAX_MERGE_DEPTH: MAX_MERGE_DEPTH,\n\n  isTerminal: isTerminal,\n\n  /**\n   * Converts null/undefined values into empty object.\n   *\n   * @param {?Object=} arg Argument to be normalized (nullable optional)\n   * @return {!Object}\n   */\n  normalizeMergeArg: function(arg) {\n    return arg === undefined || arg === null ? {} : arg;\n  },\n\n  /**\n   * If merging Arrays, a merge strategy *must* be supplied. If not, it is\n   * likely the caller&apos;s fault. If this function is ever called with anything\n   * but `one` and `two` being `Array`s, it is the fault of the merge utilities.\n   *\n   * @param {*} one Array to merge into.\n   * @param {*} two Array to merge from.\n   */\n  checkMergeArrayArgs: function(one, two) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      Array.isArray(one) &amp;&amp; Array.isArray(two),\n      &apos;Tried to merge arrays, instead got %s and %s.&apos;,\n      one,\n      two\n    ) : invariant(Array.isArray(one) &amp;&amp; Array.isArray(two)));\n  },\n\n  /**\n   * @param {*} one Object to merge into.\n   * @param {*} two Object to merge from.\n   */\n  checkMergeObjectArgs: function(one, two) {\n    mergeHelpers.checkMergeObjectArg(one);\n    mergeHelpers.checkMergeObjectArg(two);\n  },\n\n  /**\n   * @param {*} arg\n   */\n  checkMergeObjectArg: function(arg) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      !isTerminal(arg) &amp;&amp; !Array.isArray(arg),\n      &apos;Tried to merge an object, instead got %s.&apos;,\n      arg\n    ) : invariant(!isTerminal(arg) &amp;&amp; !Array.isArray(arg)));\n  },\n\n  /**\n   * Checks that a merge was not given a circular object or an object that had\n   * too great of depth.\n   *\n   * @param {number} Level of recursion to validate against maximum.\n   */\n  checkMergeLevel: function(level) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      level &lt; MAX_MERGE_DEPTH,\n      &apos;Maximum deep merge depth exceeded. You may be attempting to merge &apos; +\n      &apos;circular structures in an unsupported way.&apos;\n    ) : invariant(level &lt; MAX_MERGE_DEPTH));\n  },\n\n  /**\n   * Checks that the supplied merge strategy is valid.\n   *\n   * @param {string} Array merge strategy.\n   */\n  checkArrayStrategy: function(strategy) {\n    (&quot;production&quot; !== &quot;development&quot; ? invariant(\n      strategy === undefined || strategy in mergeHelpers.ArrayStrategies,\n      &apos;You must provide an array strategy to deep merge functions to &apos; +\n      &apos;instruct the deep merge how to resolve merging two arrays.&apos;\n    ) : invariant(strategy === undefined || strategy in mergeHelpers.ArrayStrategies));\n  },\n\n  /**\n   * Set of possible behaviors of merge algorithms when encountering two Arrays\n   * that must be merged together.\n   * - `clobber`: The left `Array` is ignored.\n   * - `indexByIndex`: The result is achieved by recursively deep merging at\n   *   each index. (not yet supported.)\n   */\n  ArrayStrategies: keyMirror({\n    Clobber: true,\n    IndexByIndex: true\n  })\n\n};\n\nmodule.exports = mergeHelpers;\n\n},{&quot;./invariant&quot;:108,&quot;./keyMirror&quot;:114}],119:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule mergeInto\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar mergeHelpers = require(&quot;./mergeHelpers&quot;);\n\nvar checkMergeObjectArg = mergeHelpers.checkMergeObjectArg;\n\n/**\n * Shallow merges two structures by mutating the first parameter.\n *\n * @param {object} one Object to be merged into.\n * @param {?object} two Optional object with properties to merge from.\n */\nfunction mergeInto(one, two) {\n  checkMergeObjectArg(one);\n  if (two != null) {\n    checkMergeObjectArg(two);\n    for (var key in two) {\n      if (!two.hasOwnProperty(key)) {\n        continue;\n      }\n      one[key] = two[key];\n    }\n  }\n}\n\nmodule.exports = mergeInto;\n\n},{&quot;./mergeHelpers&quot;:118}],120:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule mixInto\n */\n\n&quot;use strict&quot;;\n\n/**\n * Simply copies properties to the prototype.\n */\nvar mixInto = function(constructor, methodBag) {\n  var methodName;\n  for (methodName in methodBag) {\n    if (!methodBag.hasOwnProperty(methodName)) {\n      continue;\n    }\n    constructor.prototype[methodName] = methodBag[methodName];\n  }\n};\n\nmodule.exports = mixInto;\n\n},{}],121:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule objMap\n */\n\n&quot;use strict&quot;;\n\n/**\n * For each key/value pair, invokes callback func and constructs a resulting\n * object which contains, for every key in obj, values that are the result of\n * of invoking the function:\n *\n *   func(value, key, iteration)\n *\n * @param {?object} obj Object to map keys over\n * @param {function} func Invoked for each key/val pair.\n * @param {?*} context\n * @return {?object} Result of mapping or null if obj is falsey\n */\nfunction objMap(obj, func, context) {\n  if (!obj) {\n    return null;\n  }\n  var i = 0;\n  var ret = {};\n  for (var key in obj) {\n    if (obj.hasOwnProperty(key)) {\n      ret[key] = func.call(context, obj[key], key, i++);\n    }\n  }\n  return ret;\n}\n\nmodule.exports = objMap;\n\n},{}],122:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule objMapKeyVal\n */\n\n&quot;use strict&quot;;\n\n/**\n * Behaves the same as `objMap` but invokes func with the key first, and value\n * second. Use `objMap` unless you need this special case.\n * Invokes func as:\n *\n *   func(key, value, iteration)\n *\n * @param {?object} obj Object to map keys over\n * @param {!function} func Invoked for each key/val pair.\n * @param {?*} context\n * @return {?object} Result of mapping or null if obj is falsey\n */\nfunction objMapKeyVal(obj, func, context) {\n  if (!obj) {\n    return null;\n  }\n  var i = 0;\n  var ret = {};\n  for (var key in obj) {\n    if (obj.hasOwnProperty(key)) {\n      ret[key] = func.call(context, key, obj[key], i++);\n    }\n  }\n  return ret;\n}\n\nmodule.exports = objMapKeyVal;\n\n},{}],123:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule onlyChild\n */\n&quot;use strict&quot;;\n\nvar ReactComponent = require(&quot;./ReactComponent&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\n\n/**\n * Returns the first child in a collection of children and verifies that there\n * is only one child in the collection. The current implementation of this\n * function assumes that a single child gets passed without a wrapper, but the\n * purpose of this helper function is to abstract away the particular structure\n * of children.\n *\n * @param {?object} children Child collection structure.\n * @return {ReactComponent} The first and only `ReactComponent` contained in the\n * structure.\n */\nfunction onlyChild(children) {\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    ReactComponent.isValidComponent(children),\n    &apos;onlyChild must be passed a children with exactly one child.&apos;\n  ) : invariant(ReactComponent.isValidComponent(children)));\n  return children;\n}\n\nmodule.exports = onlyChild;\n\n},{&quot;./ReactComponent&quot;:26,&quot;./invariant&quot;:108}],124:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule performanceNow\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\nvar ExecutionEnvironment = require(&quot;./ExecutionEnvironment&quot;);\n\n/**\n * Detect if we can use window.performance.now() and gracefully\n * fallback to Date.now() if it doesn&apos;t exist.\n * We need to support Firefox &lt; 15 for now due to Facebook&apos;s webdriver\n * infrastructure.\n */\nvar performance = null;\n\nif (ExecutionEnvironment.canUseDOM) {\n  performance = window.performance || window.webkitPerformance;\n}\n\nif (!performance || !performance.now) {\n  performance = Date;\n}\n\nvar performanceNow = performance.now.bind(performance);\n\nmodule.exports = performanceNow;\n\n},{&quot;./ExecutionEnvironment&quot;:20}],125:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule shallowEqual\n */\n\n&quot;use strict&quot;;\n\n/**\n * Performs equality by iterating through keys on an object and returning\n * false when any key has values which are not strictly equal between\n * objA and objB. Returns true when the values of all keys are strictly equal.\n *\n * @return {boolean}\n */\nfunction shallowEqual(objA, objB) {\n  if (objA === objB) {\n    return true;\n  }\n  var key;\n  // Test for A&apos;s keys different from B.\n  for (key in objA) {\n    if (objA.hasOwnProperty(key) &amp;&amp;\n        (!objB.hasOwnProperty(key) || objA[key] !== objB[key])) {\n      return false;\n    }\n  }\n  // Test for B&apos;a keys missing from A.\n  for (key in objB) {\n    if (objB.hasOwnProperty(key) &amp;&amp; !objA.hasOwnProperty(key)) {\n      return false;\n    }\n  }\n  return true;\n}\n\nmodule.exports = shallowEqual;\n\n},{}],126:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule shouldUpdateReactComponent\n * @typechecks static-only\n */\n\n&quot;use strict&quot;;\n\n/**\n * Given a `prevComponent` and `nextComponent`, determines if `prevComponent`\n * should be updated as opposed to being destroyed or replaced.\n *\n * @param {?object} prevComponent\n * @param {?object} nextComponent\n * @return {boolean} True if `prevComponent` should be updated.\n * @protected\n */\nfunction shouldUpdateReactComponent(prevComponent, nextComponent) {\n  // TODO: Remove warning after a release.\n  if (prevComponent &amp;&amp; nextComponent &amp;&amp;\n      prevComponent.constructor === nextComponent.constructor &amp;&amp; (\n        (prevComponent.props &amp;&amp; prevComponent.props.key) ===\n        (nextComponent.props &amp;&amp; nextComponent.props.key)\n      )) {\n    if (prevComponent._owner === nextComponent._owner) {\n      return true;\n    } else {\n      if (&quot;production&quot; !== &quot;development&quot;) {\n        if (prevComponent.state) {\n          console.warn(\n            &apos;A recent change to React has been found to impact your code. &apos; +\n            &apos;A mounted component will now be unmounted and replaced by a &apos; +\n            &apos;component (of the same class) if their owners are different. &apos; +\n            &apos;Previously, ownership was not considered when updating.&apos;,\n            prevComponent,\n            nextComponent\n          );\n        }\n      }\n    }\n  }\n  return false;\n}\n\nmodule.exports = shouldUpdateReactComponent;\n\n},{}],127:[function(require,module,exports){\n/**\n * Copyright 2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule toArray\n * @typechecks\n */\n\nvar invariant = require(&quot;./invariant&quot;);\n\n/**\n * Convert array-like objects to arrays.\n *\n * This API assumes the caller knows the contents of the data type. For less\n * well defined inputs use createArrayFrom.\n *\n * @param {object|function} obj\n * @return {array}\n */\nfunction toArray(obj) {\n  var length = obj.length;\n\n  // Some browse builtin objects can report typeof &apos;function&apos; (e.g. NodeList in\n  // old versions of Safari).\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    !Array.isArray(obj) &amp;&amp;\n    (typeof obj === &apos;object&apos; || typeof obj === &apos;function&apos;),\n    &apos;toArray: Array-like object expected&apos;\n  ) : invariant(!Array.isArray(obj) &amp;&amp;\n  (typeof obj === &apos;object&apos; || typeof obj === &apos;function&apos;)));\n\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    typeof length === &apos;number&apos;,\n    &apos;toArray: Object needs a length property&apos;\n  ) : invariant(typeof length === &apos;number&apos;));\n\n  (&quot;production&quot; !== &quot;development&quot; ? invariant(\n    length === 0 ||\n    (length - 1) in obj,\n    &apos;toArray: Object should have keys for indices&apos;\n  ) : invariant(length === 0 ||\n  (length - 1) in obj));\n\n  // Old IE doesn&apos;t give collections access to hasOwnProperty. Assume inputs\n  // without method will throw during the slice call and skip straight to the\n  // fallback.\n  if (obj.hasOwnProperty) {\n    try {\n      return Array.prototype.slice.call(obj);\n    } catch (e) {\n      // IE &lt; 9 does not support Array#slice on collections objects\n    }\n  }\n\n  // Fall back to copying key by key. This assumes all keys have a value,\n  // so will not preserve sparsely populated inputs.\n  var ret = Array(length);\n  for (var ii = 0; ii &lt; length; ii++) {\n    ret[ii] = obj[ii];\n  }\n  return ret;\n}\n\nmodule.exports = toArray;\n\n},{&quot;./invariant&quot;:108}],128:[function(require,module,exports){\n/**\n * Copyright 2013-2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule traverseAllChildren\n */\n\n&quot;use strict&quot;;\n\nvar ReactInstanceHandles = require(&quot;./ReactInstanceHandles&quot;);\nvar ReactTextComponent = require(&quot;./ReactTextComponent&quot;);\n\nvar invariant = require(&quot;./invariant&quot;);\n\nvar SEPARATOR = ReactInstanceHandles.SEPARATOR;\nvar SUBSEPARATOR = &apos;:&apos;;\n\n/**\n * TODO: Test that:\n * 1. `mapChildren` transforms strings and numbers into `ReactTextComponent`.\n * 2. it(&apos;should fail when supplied duplicate key&apos;, function() {\n * 3. That a single child and an array with one item have the same key pattern.\n * });\n */\n\nvar userProvidedKeyEscaperLookup = {\n  &apos;=&apos;: &apos;=0&apos;,\n  &apos;.&apos;: &apos;=1&apos;,\n  &apos;:&apos;: &apos;=2&apos;\n};\n\nvar userProvidedKeyEscapeRegex = /[=.:]/g;\n\nfunction userProvidedKeyEscaper(match) {\n  return userProvidedKeyEscaperLookup[match];\n}\n\n/**\n * Generate a key string that identifies a component within a set.\n *\n * @param {*} component A component that could contain a manual key.\n * @param {number} index Index that is used if a manual key is not provided.\n * @return {string}\n */\nfunction getComponentKey(component, index) {\n  if (component &amp;&amp; component.props &amp;&amp; component.props.key != null) {\n    // Explicit key\n    return wrapUserProvidedKey(component.props.key);\n  }\n  // Implicit key determined by the index in the set\n  return index.toString(36);\n}\n\n/**\n * Escape a component key so that it is safe to use in a reactid.\n *\n * @param {*} key Component key to be escaped.\n * @return {string} An escaped string.\n */\nfunction escapeUserProvidedKey(text) {\n  return (&apos;&apos; + text).replace(\n    userProvidedKeyEscapeRegex,\n    userProvidedKeyEscaper\n  );\n}\n\n/**\n * Wrap a `key` value explicitly provided by the user to distinguish it from\n * implicitly-generated keys generated by a component&apos;s index in its parent.\n *\n * @param {string} key Value of a user-provided `key` attribute\n * @return {string}\n */\nfunction wrapUserProvidedKey(key) {\n  return &apos;$&apos; + escapeUserProvidedKey(key);\n}\n\n/**\n * @param {?*} children Children tree container.\n * @param {!string} nameSoFar Name of the key path so far.\n * @param {!number} indexSoFar Number of children encountered until this point.\n * @param {!function} callback Callback to invoke with each child found.\n * @param {?*} traverseContext Used to pass information throughout the traversal\n * process.\n * @return {!number} The number of children in this subtree.\n */\nvar traverseAllChildrenImpl =\n  function(children, nameSoFar, indexSoFar, callback, traverseContext) {\n    var subtreeCount = 0;  // Count of children found in the current subtree.\n    if (Array.isArray(children)) {\n      for (var i = 0; i &lt; children.length; i++) {\n        var child = children[i];\n        var nextName = (\n          nameSoFar +\n          (nameSoFar ? SUBSEPARATOR : SEPARATOR) +\n          getComponentKey(child, i)\n        );\n        var nextIndex = indexSoFar + subtreeCount;\n        subtreeCount += traverseAllChildrenImpl(\n          child,\n          nextName,\n          nextIndex,\n          callback,\n          traverseContext\n        );\n      }\n    } else {\n      var type = typeof children;\n      var isOnlyChild = nameSoFar === &apos;&apos;;\n      // If it&apos;s the only child, treat the name as if it was wrapped in an array\n      // so that it&apos;s consistent if the number of children grows\n      var storageName =\n        isOnlyChild ? SEPARATOR + getComponentKey(children, 0) : nameSoFar;\n      if (children == null || type === &apos;boolean&apos;) {\n        // All of the above are perceived as null.\n        callback(traverseContext, null, storageName, indexSoFar);\n        subtreeCount = 1;\n      } else if (children.mountComponentIntoNode) {\n        callback(traverseContext, children, storageName, indexSoFar);\n        subtreeCount = 1;\n      } else {\n        if (type === &apos;object&apos;) {\n          (&quot;production&quot; !== &quot;development&quot; ? invariant(\n            !children || children.nodeType !== 1,\n            &apos;traverseAllChildren(...): Encountered an invalid child; DOM &apos; +\n            &apos;elements are not valid children of React components.&apos;\n          ) : invariant(!children || children.nodeType !== 1));\n          for (var key in children) {\n            if (children.hasOwnProperty(key)) {\n              subtreeCount += traverseAllChildrenImpl(\n                children[key],\n                (\n                  nameSoFar + (nameSoFar ? SUBSEPARATOR : SEPARATOR) +\n                  wrapUserProvidedKey(key) + SUBSEPARATOR +\n                  getComponentKey(children[key], 0)\n                ),\n                indexSoFar + subtreeCount,\n                callback,\n                traverseContext\n              );\n            }\n          }\n        } else if (type === &apos;string&apos;) {\n          var normalizedText = new ReactTextComponent(children);\n          callback(traverseContext, normalizedText, storageName, indexSoFar);\n          subtreeCount += 1;\n        } else if (type === &apos;number&apos;) {\n          var normalizedNumber = new ReactTextComponent(&apos;&apos; + children);\n          callback(traverseContext, normalizedNumber, storageName, indexSoFar);\n          subtreeCount += 1;\n        }\n      }\n    }\n    return subtreeCount;\n  };\n\n/**\n * Traverses children that are typically specified as `props.children`, but\n * might also be specified through attributes:\n *\n * - `traverseAllChildren(this.props.children, ...)`\n * - `traverseAllChildren(this.props.leftPanelChildren, ...)`\n *\n * The `traverseContext` is an optional argument that is passed through the\n * entire traversal. It can be used to store accumulations or anything else that\n * the callback might find relevant.\n *\n * @param {?*} children Children tree object.\n * @param {!function} callback To invoke upon traversing each child.\n * @param {?*} traverseContext Context for traversal.\n */\nfunction traverseAllChildren(children, callback, traverseContext) {\n  if (children !== null &amp;&amp; children !== undefined) {\n    traverseAllChildrenImpl(children, &apos;&apos;, 0, callback, traverseContext);\n  }\n}\n\nmodule.exports = traverseAllChildren;\n\n},{&quot;./ReactInstanceHandles&quot;:53,&quot;./ReactTextComponent&quot;:69,&quot;./invariant&quot;:108}],129:[function(require,module,exports){\n/**\n * Copyright 2014 Facebook, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the &quot;License&quot;);\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * @providesModule warning\n */\n\n&quot;use strict&quot;;\n\nvar emptyFunction = require(&quot;./emptyFunction&quot;);\n\n/**\n * Similar to invariant but only logs a warning if the condition is not met.\n * This can be used to log issues in development environments in critical\n * paths. Removing the logging code for production environments will keep the\n * same logic and follow the same code paths.\n */\n\nvar warning = emptyFunction;\n\nif (&quot;production&quot; !== &quot;development&quot;) {\n  warning = function(condition, format ) {var args=Array.prototype.slice.call(arguments,2);\n    if (format === undefined) {\n      throw new Error(\n        &apos;`warning(condition, format, ...args)` requires a warning &apos; +\n        &apos;message argument&apos;\n      );\n    }\n\n    if (!condition) {\n      var argIndex = 0;\n      console.warn(&apos;Warning: &apos; + format.replace(/%s/g, function()  {return args[argIndex++];}));\n    }\n  };\n}\n\nmodule.exports = warning;\n\n},{&quot;./emptyFunction&quot;:95}]},{},[24])\n(24)\n});if(typeof Math.imul == &quot;undefined&quot; || (Math.imul(0xffffffff,5) == 0)) {\n    Math.imul = function (a, b) {\n        var ah  = (a &gt;&gt;&gt; 16) &amp; 0xffff;\n        var al = a &amp; 0xffff;\n        var bh  = (b &gt;&gt;&gt; 16) &amp; 0xffff;\n        var bl = b &amp; 0xffff;\n        // the shift by 0 fixes the sign on the high part\n        // the final |0 converts the unsigned value into a signed value\n        return ((al * bl) + (((ah * bl + al * bh) &lt;&lt; 16) &gt;&gt;&gt; 0)|0);\n    }\n}\n\nvar h,aa=this;\nfunction q(a){var b=typeof a;if(&quot;object&quot;==b)if(a){if(a instanceof Array)return&quot;array&quot;;if(a instanceof Object)return b;var c=Object.prototype.toString.call(a);if(&quot;[object Window]&quot;==c)return&quot;object&quot;;if(&quot;[object Array]&quot;==c||&quot;number&quot;==typeof a.length&amp;&amp;&quot;undefined&quot;!=typeof a.splice&amp;&amp;&quot;undefined&quot;!=typeof a.propertyIsEnumerable&amp;&amp;!a.propertyIsEnumerable(&quot;splice&quot;))return&quot;array&quot;;if(&quot;[object Function]&quot;==c||&quot;undefined&quot;!=typeof a.call&amp;&amp;&quot;undefined&quot;!=typeof a.propertyIsEnumerable&amp;&amp;!a.propertyIsEnumerable(&quot;call&quot;))return&quot;function&quot;}else return&quot;null&quot;;else if(&quot;function&quot;==\nb&amp;&amp;&quot;undefined&quot;==typeof a.call)return&quot;object&quot;;return b}var ba=&quot;closure_uid_&quot;+(1E9*Math.random()&gt;&gt;&gt;0),da=0;function ea(a,b){return a&lt;b?-1:a&gt;b?1:0};function fa(a,b){for(var c in a)b.call(void 0,a[c],c,a)};function ga(a,b){null!=a&amp;&amp;this.append.apply(this,arguments)}ga.prototype.Ua=&quot;&quot;;ga.prototype.append=function(a,b,c){this.Ua+=a;if(null!=b)for(var d=1;d&lt;arguments.length;d++)this.Ua+=arguments[d];return this};ga.prototype.toString=function(){return this.Ua};var ha=null;function ja(){return new s(null,5,[ka,!0,la,!0,na,!1,oa,!1,pa,null],null)}function v(a){return null!=a&amp;&amp;!1!==a}function sa(a){return v(a)?!1:!0}function w(a,b){return a[q(null==b?null:b)]?!0:a._?!0:!1}function ta(a){return null==a?null:a.constructor}function x(a,b){var c=ta(b),c=v(v(c)?c.eb:c)?c.cb:q(b);return Error([&quot;No protocol method &quot;,a,&quot; defined for type &quot;,c,&quot;: &quot;,b].join(&quot;&quot;))}function ua(a){var b=a.cb;return v(b)?b:&quot;&quot;+y.e(a)}\nfunction wa(a){for(var b=a.length,c=Array(b),d=0;;)if(d&lt;b)c[d]=a[d],d+=1;else break;return c}var xa={},ya={};function Aa(a){if(a?a.ea:a)return a.ea(a);var b;b=Aa[q(null==a?null:a)];if(!b&amp;&amp;(b=Aa._,!b))throw x(&quot;ICloneable.-clone&quot;,a);return b.call(null,a)}var Ba={};function Ca(a){if(a?a.S:a)return a.S(a);var b;b=Ca[q(null==a?null:a)];if(!b&amp;&amp;(b=Ca._,!b))throw x(&quot;ICounted.-count&quot;,a);return b.call(null,a)}\nfunction Da(a){if(a?a.T:a)return a.T(a);var b;b=Da[q(null==a?null:a)];if(!b&amp;&amp;(b=Da._,!b))throw x(&quot;IEmptyableCollection.-empty&quot;,a);return b.call(null,a)}var Ea={};function Ga(a,b){if(a?a.R:a)return a.R(a,b);var c;c=Ga[q(null==a?null:a)];if(!c&amp;&amp;(c=Ga._,!c))throw x(&quot;ICollection.-conj&quot;,a);return c.call(null,a,b)}\nvar Ha={},z=function(){function a(a,b,c){if(a?a.da:a)return a.da(a,b,c);var g;g=z[q(null==a?null:a)];if(!g&amp;&amp;(g=z._,!g))throw x(&quot;IIndexed.-nth&quot;,a);return g.call(null,a,b,c)}function b(a,b){if(a?a.N:a)return a.N(a,b);var c;c=z[q(null==a?null:a)];if(!c&amp;&amp;(c=z._,!c))throw x(&quot;IIndexed.-nth&quot;,a);return c.call(null,a,b)}var c=null,c=function(d,c,f){switch(arguments.length){case 2:return b.call(this,d,c);case 3:return a.call(this,d,c,f)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};c.c=b;c.f=a;return c}(),\nIa={};function B(a){if(a?a.X:a)return a.X(a);var b;b=B[q(null==a?null:a)];if(!b&amp;&amp;(b=B._,!b))throw x(&quot;ISeq.-first&quot;,a);return b.call(null,a)}function Ja(a){if(a?a.ca:a)return a.ca(a);var b;b=Ja[q(null==a?null:a)];if(!b&amp;&amp;(b=Ja._,!b))throw x(&quot;ISeq.-rest&quot;,a);return b.call(null,a)}\nvar Ka={},Ma={},C=function(){function a(a,b,c){if(a?a.D:a)return a.D(a,b,c);var g;g=C[q(null==a?null:a)];if(!g&amp;&amp;(g=C._,!g))throw x(&quot;ILookup.-lookup&quot;,a);return g.call(null,a,b,c)}function b(a,b){if(a?a.C:a)return a.C(a,b);var c;c=C[q(null==a?null:a)];if(!c&amp;&amp;(c=C._,!c))throw x(&quot;ILookup.-lookup&quot;,a);return c.call(null,a,b)}var c=null,c=function(d,c,f){switch(arguments.length){case 2:return b.call(this,d,c);case 3:return a.call(this,d,c,f)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};c.c=b;c.f=a;\nreturn c}();function Na(a,b){if(a?a.Za:a)return a.Za(a,b);var c;c=Na[q(null==a?null:a)];if(!c&amp;&amp;(c=Na._,!c))throw x(&quot;IAssociative.-contains-key?&quot;,a);return c.call(null,a,b)}function Pa(a,b,c){if(a?a.Oa:a)return a.Oa(a,b,c);var d;d=Pa[q(null==a?null:a)];if(!d&amp;&amp;(d=Pa._,!d))throw x(&quot;IAssociative.-assoc&quot;,a);return d.call(null,a,b,c)}var Qa={};function Ra(a,b){if(a?a.mb:a)return a.mb(a,b);var c;c=Ra[q(null==a?null:a)];if(!c&amp;&amp;(c=Ra._,!c))throw x(&quot;IMap.-dissoc&quot;,a);return c.call(null,a,b)}var Sa={};\nfunction Ta(a){if(a?a.yb:a)return a.yb();var b;b=Ta[q(null==a?null:a)];if(!b&amp;&amp;(b=Ta._,!b))throw x(&quot;IMapEntry.-key&quot;,a);return b.call(null,a)}function Va(a){if(a?a.Kb:a)return a.Kb();var b;b=Va[q(null==a?null:a)];if(!b&amp;&amp;(b=Va._,!b))throw x(&quot;IMapEntry.-val&quot;,a);return b.call(null,a)}var Wa={};function Xa(a,b){if(a?a.Mb:a)return a.Mb(0,b);var c;c=Xa[q(null==a?null:a)];if(!c&amp;&amp;(c=Xa._,!c))throw x(&quot;ISet.-disjoin&quot;,a);return c.call(null,a,b)}var Ya={};\nfunction Za(a,b,c){if(a?a.zb:a)return a.zb(a,b,c);var d;d=Za[q(null==a?null:a)];if(!d&amp;&amp;(d=Za._,!d))throw x(&quot;IVector.-assoc-n&quot;,a);return d.call(null,a,b,c)}function ab(a){if(a?a.Pa:a)return a.Pa(a);var b;b=ab[q(null==a?null:a)];if(!b&amp;&amp;(b=ab._,!b))throw x(&quot;IDeref.-deref&quot;,a);return b.call(null,a)}var bb={};function cb(a){if(a?a.J:a)return a.J(a);var b;b=cb[q(null==a?null:a)];if(!b&amp;&amp;(b=cb._,!b))throw x(&quot;IMeta.-meta&quot;,a);return b.call(null,a)}var db={};\nfunction eb(a,b){if(a?a.K:a)return a.K(a,b);var c;c=eb[q(null==a?null:a)];if(!c&amp;&amp;(c=eb._,!c))throw x(&quot;IWithMeta.-with-meta&quot;,a);return c.call(null,a,b)}\nvar fb={},gb=function(){function a(a,b,c){if(a?a.aa:a)return a.aa(a,b,c);var g;g=gb[q(null==a?null:a)];if(!g&amp;&amp;(g=gb._,!g))throw x(&quot;IReduce.-reduce&quot;,a);return g.call(null,a,b,c)}function b(a,b){if(a?a.$:a)return a.$(a,b);var c;c=gb[q(null==a?null:a)];if(!c&amp;&amp;(c=gb._,!c))throw x(&quot;IReduce.-reduce&quot;,a);return c.call(null,a,b)}var c=null,c=function(d,c,f){switch(arguments.length){case 2:return b.call(this,d,c);case 3:return a.call(this,d,c,f)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};c.c=b;c.f=a;\nreturn c}();function ib(a,b){if(a?a.G:a)return a.G(a,b);var c;c=ib[q(null==a?null:a)];if(!c&amp;&amp;(c=ib._,!c))throw x(&quot;IEquiv.-equiv&quot;,a);return c.call(null,a,b)}function jb(a){if(a?a.I:a)return a.I(a);var b;b=jb[q(null==a?null:a)];if(!b&amp;&amp;(b=jb._,!b))throw x(&quot;IHash.-hash&quot;,a);return b.call(null,a)}var kb={};function lb(a){if(a?a.O:a)return a.O(a);var b;b=lb[q(null==a?null:a)];if(!b&amp;&amp;(b=lb._,!b))throw x(&quot;ISeqable.-seq&quot;,a);return b.call(null,a)}var mb={};\nfunction D(a,b){if(a?a.Rb:a)return a.Rb(0,b);var c;c=D[q(null==a?null:a)];if(!c&amp;&amp;(c=D._,!c))throw x(&quot;IWriter.-write&quot;,a);return c.call(null,a,b)}var nb={};function ob(a,b,c){if(a?a.H:a)return a.H(a,b,c);var d;d=ob[q(null==a?null:a)];if(!d&amp;&amp;(d=ob._,!d))throw x(&quot;IPrintWithWriter.-pr-writer&quot;,a);return d.call(null,a,b,c)}function pb(a,b,c){if(a?a.Pb:a)return a.Pb(0,b,c);var d;d=pb[q(null==a?null:a)];if(!d&amp;&amp;(d=pb._,!d))throw x(&quot;IWatchable.-notify-watches&quot;,a);return d.call(null,a,b,c)}\nfunction qb(a,b,c){if(a?a.Ob:a)return a.Ob(0,b,c);var d;d=qb[q(null==a?null:a)];if(!d&amp;&amp;(d=qb._,!d))throw x(&quot;IWatchable.-add-watch&quot;,a);return d.call(null,a,b,c)}function rb(a,b){if(a?a.Qb:a)return a.Qb(0,b);var c;c=rb[q(null==a?null:a)];if(!c&amp;&amp;(c=rb._,!c))throw x(&quot;IWatchable.-remove-watch&quot;,a);return c.call(null,a,b)}function sb(a){if(a?a.$a:a)return a.$a(a);var b;b=sb[q(null==a?null:a)];if(!b&amp;&amp;(b=sb._,!b))throw x(&quot;IEditableCollection.-as-transient&quot;,a);return b.call(null,a)}\nfunction tb(a,b){if(a?a.Qa:a)return a.Qa(a,b);var c;c=tb[q(null==a?null:a)];if(!c&amp;&amp;(c=tb._,!c))throw x(&quot;ITransientCollection.-conj!&quot;,a);return c.call(null,a,b)}function ub(a){if(a?a.Ra:a)return a.Ra(a);var b;b=ub[q(null==a?null:a)];if(!b&amp;&amp;(b=ub._,!b))throw x(&quot;ITransientCollection.-persistent!&quot;,a);return b.call(null,a)}function wb(a,b,c){if(a?a.bb:a)return a.bb(a,b,c);var d;d=wb[q(null==a?null:a)];if(!d&amp;&amp;(d=wb._,!d))throw x(&quot;ITransientAssociative.-assoc!&quot;,a);return d.call(null,a,b,c)}\nfunction xb(a,b,c){if(a?a.Nb:a)return a.Nb(0,b,c);var d;d=xb[q(null==a?null:a)];if(!d&amp;&amp;(d=xb._,!d))throw x(&quot;ITransientVector.-assoc-n!&quot;,a);return d.call(null,a,b,c)}function yb(a){if(a?a.Hb:a)return a.Hb();var b;b=yb[q(null==a?null:a)];if(!b&amp;&amp;(b=yb._,!b))throw x(&quot;IChunk.-drop-first&quot;,a);return b.call(null,a)}function zb(a){if(a?a.wb:a)return a.wb(a);var b;b=zb[q(null==a?null:a)];if(!b&amp;&amp;(b=zb._,!b))throw x(&quot;IChunkedSeq.-chunked-first&quot;,a);return b.call(null,a)}\nfunction Ab(a){if(a?a.xb:a)return a.xb(a);var b;b=Ab[q(null==a?null:a)];if(!b&amp;&amp;(b=Ab._,!b))throw x(&quot;IChunkedSeq.-chunked-rest&quot;,a);return b.call(null,a)}function Bb(a){if(a?a.vb:a)return a.vb(a);var b;b=Bb[q(null==a?null:a)];if(!b&amp;&amp;(b=Bb._,!b))throw x(&quot;IChunkedNext.-chunked-next&quot;,a);return b.call(null,a)}var Cb={};function Db(a,b){if(a?a.xc:a)return a.xc(a,b);var c;c=Db[q(null==a?null:a)];if(!c&amp;&amp;(c=Db._,!c))throw x(&quot;IReset.-reset!&quot;,a);return c.call(null,a,b)}\nvar Eb=function(){function a(a,b,d,c,e){if(a?a.Bc:a)return a.Bc(a,b,d,c,e);var n;n=Eb[q(null==a?null:a)];if(!n&amp;&amp;(n=Eb._,!n))throw x(&quot;ISwap.-swap!&quot;,a);return n.call(null,a,b,d,c,e)}function b(a,b,d,c){if(a?a.Ac:a)return a.Ac(a,b,d,c);var e;e=Eb[q(null==a?null:a)];if(!e&amp;&amp;(e=Eb._,!e))throw x(&quot;ISwap.-swap!&quot;,a);return e.call(null,a,b,d,c)}function c(a,b,d){if(a?a.zc:a)return a.zc(a,b,d);var c;c=Eb[q(null==a?null:a)];if(!c&amp;&amp;(c=Eb._,!c))throw x(&quot;ISwap.-swap!&quot;,a);return c.call(null,a,b,d)}function d(a,b){if(a?\na.yc:a)return a.yc(a,b);var c;c=Eb[q(null==a?null:a)];if(!c&amp;&amp;(c=Eb._,!c))throw x(&quot;ISwap.-swap!&quot;,a);return c.call(null,a,b)}var e=null,e=function(e,g,k,l,m){switch(arguments.length){case 2:return d.call(this,e,g);case 3:return c.call(this,e,g,k);case 4:return b.call(this,e,g,k,l);case 5:return a.call(this,e,g,k,l,m)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};e.c=d;e.f=c;e.n=b;e.M=a;return e}();function Fb(a){this.bd=a;this.w=0;this.l=1073741824}Fb.prototype.Rb=function(a,b){return this.bd.append(b)};\nfunction Gb(a){var b=new ga;a.H(null,new Fb(b),ja());return&quot;&quot;+y.e(b)}var Hb=&quot;undefined&quot;!==typeof Math.imul&amp;&amp;0!==(Math.imul.c?Math.imul.c(4294967295,5):Math.imul.call(null,4294967295,5))?function(a,b){return Math.imul.c?Math.imul.c(a,b):Math.imul.call(null,a,b)}:function(a,b){var c=a&amp;65535,d=b&amp;65535;return c*d+((a&gt;&gt;&gt;16&amp;65535)*d+c*(b&gt;&gt;&gt;16&amp;65535)&lt;&lt;16&gt;&gt;&gt;0)|0};function Kb(a){a=Hb(a,3432918353);return Hb(a&lt;&lt;15|a&gt;&gt;&gt;-15,461845907)}function Lb(a,b){var c=a^b;return Hb(c&lt;&lt;13|c&gt;&gt;&gt;-13,5)+3864292196}\nfunction Mb(a,b){var c=a^b,c=Hb(c^c&gt;&gt;&gt;16,2246822507),c=Hb(c^c&gt;&gt;&gt;13,3266489909);return c^c&gt;&gt;&gt;16}var Nb={},Ob=0;function Pb(a){255&lt;Ob&amp;&amp;(Nb={},Ob=0);var b=Nb[a];if(&quot;number&quot;!==typeof b){a:if(null!=a)if(b=a.length,0&lt;b){for(var c=0,d=0;;)if(c&lt;b)var e=c+1,d=Hb(31,d)+a.charCodeAt(c),c=e;else{b=d;break a}b=void 0}else b=0;else b=0;Nb[a]=b;Ob+=1}return a=b}\nfunction Qb(a){a&amp;&amp;(a.l&amp;4194304||a.kd)?a=a.I(null):&quot;number&quot;===typeof a?a=(Math.floor.e?Math.floor.e(a):Math.floor.call(null,a))%2147483647:!0===a?a=1:!1===a?a=0:&quot;string&quot;===typeof a?(a=Pb(a),0!==a&amp;&amp;(a=Kb(a),a=Lb(0,a),a=Mb(a,4))):a=null==a?0:jb(a);return a}\nfunction Rb(a){var b;b=a.name;var c;a:{c=1;for(var d=0;;)if(c&lt;b.length){var e=c+2,d=Lb(d,Kb(b.charCodeAt(c-1)|b.charCodeAt(c)&lt;&lt;16));c=e}else{c=d;break a}c=void 0}c=1===(b.length&amp;1)?c^Kb(b.charCodeAt(b.length-1)):c;b=Mb(c,Hb(2,b.length));a=Pb(a.ka);return b^a+2654435769+(b&lt;&lt;6)+(b&gt;&gt;2)}\nfunction Sb(a,b){if(v(E.c?E.c(a,b):E.call(null,a,b)))return 0;var c=sa(a.ka);if(v(c?b.ka:c))return-1;if(v(a.ka)){if(sa(b.ka))return 1;c=Tb.c?Tb.c(a.ka,b.ka):Tb.call(null,a.ka,b.ka);return 0===c?Tb.c?Tb.c(a.name,b.name):Tb.call(null,a.name,b.name):c}return Tb.c?Tb.c(a.name,b.name):Tb.call(null,a.name,b.name)}function F(a,b,c,d,e){this.ka=a;this.name=b;this.Na=c;this.Ta=d;this.la=e;this.l=2154168321;this.w=4096}h=F.prototype;h.H=function(a,b){return D(b,this.Na)};\nh.I=function(){var a=this.Ta;return null!=a?a:this.Ta=a=Rb(this)};h.K=function(a,b){return new F(this.ka,this.name,this.Na,this.Ta,b)};h.J=function(){return this.la};h.call=function(){var a=null,a=function(a,c,d){switch(arguments.length){case 2:return C.f(c,this,null);case 3:return C.f(c,this,d)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};a.c=function(a,c){return C.f(c,this,null)};a.f=function(a,c,d){return C.f(c,this,d)};return a}();h.apply=function(a,b){return this.call.apply(this,[this].concat(wa(b)))};\nh.e=function(a){return C.f(a,this,null)};h.c=function(a,b){return C.f(a,this,b)};h.G=function(a,b){return b instanceof F?this.Na===b.Na:!1};h.toString=function(){return this.Na};\nvar Ub=function(){function a(a,b){var c=null!=a?&quot;&quot;+y.e(a)+&quot;/&quot;+y.e(b):b;return new F(a,b,c,null,null)}function b(a){return a instanceof F?a:c.c(null,a)}var c=null,c=function(c,e){switch(arguments.length){case 1:return b.call(this,c);case 2:return a.call(this,c,e)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};c.e=b;c.c=a;return c}();\nfunction I(a){if(null==a)return null;if(a&amp;&amp;(a.l&amp;8388608||a.md))return a.O(null);if(a instanceof Array||&quot;string&quot;===typeof a)return 0===a.length?null:new Vb(a,0);if(w(kb,a))return lb(a);throw Error(&quot;&quot;+y.e(a)+&quot; is not ISeqable&quot;);}function K(a){if(null==a)return null;if(a&amp;&amp;(a.l&amp;64||a.ab))return a.X(null);a=I(a);return null==a?null:B(a)}function L(a){return null!=a?a&amp;&amp;(a.l&amp;64||a.ab)?a.ca(null):(a=I(a))?Ja(a):M:M}function N(a){return null==a?null:a&amp;&amp;(a.l&amp;128||a.Lb)?a.fa(null):I(L(a))}\nvar E=function(){function a(a,b){return null==a?null==b:a===b||ib(a,b)}var b=null,c=function(){function a(b,d,k){var l=null;2&lt;arguments.length&amp;&amp;(l=P(Array.prototype.slice.call(arguments,2),0));return c.call(this,b,d,l)}function c(a,d,e){for(;;)if(b.c(a,d))if(N(e))a=d,d=K(e),e=N(e);else return b.c(d,K(e));else return!1}a.A=2;a.o=function(a){var b=K(a);a=N(a);var d=K(a);a=L(a);return c(b,d,a)};a.k=c;return a}(),b=function(b,e,f){switch(arguments.length){case 1:return!0;case 2:return a.call(this,b,e);\ndefault:return c.k(b,e,P(arguments,2))}throw Error(&quot;Invalid arity: &quot;+arguments.length);};b.A=2;b.o=c.o;b.e=function(){return!0};b.c=a;b.k=c.k;return b}();function Wb(a,b){var c=Kb(a),c=Lb(0,c);return Mb(c,b)}function Yb(a){var b=0,c=1;for(a=I(a);;)if(null!=a)b+=1,c=Hb(31,c)+Qb(K(a))|0,a=N(a);else return Wb(c,b)}function Zb(a){var b=0,c=0;for(a=I(a);;)if(null!=a)b+=1,c=c+Qb(K(a))|0,a=N(a);else return Wb(c,b)}Ba[&quot;null&quot;]=!0;Ca[&quot;null&quot;]=function(){return 0};Date.prototype.rc=!0;\nDate.prototype.G=function(a,b){return b instanceof Date&amp;&amp;this.toString()===b.toString()};ib.number=function(a,b){return a===b};bb[&quot;function&quot;]=!0;cb[&quot;function&quot;]=function(){return null};xa[&quot;function&quot;]=!0;jb._=function(a){return a[ba]||(a[ba]=++da)};function $b(a){return a+1}function ac(a){this.W=a;this.w=0;this.l=32768}ac.prototype.Pa=function(){return this.W};function bc(a){return a instanceof ac}function Q(a){return ab(a)}\nvar cc=function(){function a(a,b,c,d){for(var l=Ca(a);;)if(d&lt;l){c=b.c?b.c(c,z.c(a,d)):b.call(null,c,z.c(a,d));if(bc(c))return ab(c);d+=1}else return c}function b(a,b,c){for(var d=Ca(a),l=0;;)if(l&lt;d){c=b.c?b.c(c,z.c(a,l)):b.call(null,c,z.c(a,l));if(bc(c))return ab(c);l+=1}else return c}function c(a,b){var c=Ca(a);if(0===c)return b.v?b.v():b.call(null);for(var d=z.c(a,0),l=1;;)if(l&lt;c){d=b.c?b.c(d,z.c(a,l)):b.call(null,d,z.c(a,l));if(bc(d))return ab(d);l+=1}else return d}var d=null,d=function(d,f,g,\nk){switch(arguments.length){case 2:return c.call(this,d,f);case 3:return b.call(this,d,f,g);case 4:return a.call(this,d,f,g,k)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};d.c=c;d.f=b;d.n=a;return d}(),dc=function(){function a(a,b,c,d){for(var l=a.length;;)if(d&lt;l){c=b.c?b.c(c,a[d]):b.call(null,c,a[d]);if(bc(c))return ab(c);d+=1}else return c}function b(a,b,c){for(var d=a.length,l=0;;)if(l&lt;d){c=b.c?b.c(c,a[l]):b.call(null,c,a[l]);if(bc(c))return ab(c);l+=1}else return c}function c(a,b){var c=\na.length;if(0===a.length)return b.v?b.v():b.call(null);for(var d=a[0],l=1;;)if(l&lt;c){d=b.c?b.c(d,a[l]):b.call(null,d,a[l]);if(bc(d))return ab(d);l+=1}else return d}var d=null,d=function(d,f,g,k){switch(arguments.length){case 2:return c.call(this,d,f);case 3:return b.call(this,d,f,g);case 4:return a.call(this,d,f,g,k)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};d.c=c;d.f=b;d.n=a;return d}();function ec(a){return a?a.l&amp;2||a.nc?!0:a.l?!1:w(Ba,a):w(Ba,a)}\nfunction fc(a){return a?a.l&amp;16||a.Ib?!0:a.l?!1:w(Ha,a):w(Ha,a)}function Vb(a,b){this.h=a;this.i=b;this.l=166199550;this.w=8192}h=Vb.prototype;h.toString=function(){return Gb(this)};h.N=function(a,b){var c=b+this.i;return c&lt;this.h.length?this.h[c]:null};h.da=function(a,b,c){a=b+this.i;return a&lt;this.h.length?this.h[a]:c};h.ea=function(){return new Vb(this.h,this.i)};h.fa=function(){return this.i+1&lt;this.h.length?new Vb(this.h,this.i+1):null};h.S=function(){return this.h.length-this.i};h.I=function(){return Yb(this)};\nh.G=function(a,b){return gc.c?gc.c(this,b):gc.call(null,this,b)};h.T=function(){return M};h.$=function(a,b){return dc.n(this.h,b,this.h[this.i],this.i+1)};h.aa=function(a,b,c){return dc.n(this.h,b,c,this.i)};h.X=function(){return this.h[this.i]};h.ca=function(){return this.i+1&lt;this.h.length?new Vb(this.h,this.i+1):M};h.O=function(){return this};h.R=function(a,b){return R.c?R.c(b,this):R.call(null,b,this)};\nvar hc=function(){function a(a,b){return b&lt;a.length?new Vb(a,b):null}function b(a){return c.c(a,0)}var c=null,c=function(c,e){switch(arguments.length){case 1:return b.call(this,c);case 2:return a.call(this,c,e)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};c.e=b;c.c=a;return c}(),P=function(){function a(a,b){return hc.c(a,b)}function b(a){return hc.c(a,0)}var c=null,c=function(c,e){switch(arguments.length){case 1:return b.call(this,c);case 2:return a.call(this,c,e)}throw Error(&quot;Invalid arity: &quot;+\narguments.length);};c.e=b;c.c=a;return c}();ib._=function(a,b){return a===b};\nvar jc=function(){function a(a,b){return null!=a?Ga(a,b):Ga(M,b)}var b=null,c=function(){function a(b,d,k){var l=null;2&lt;arguments.length&amp;&amp;(l=P(Array.prototype.slice.call(arguments,2),0));return c.call(this,b,d,l)}function c(a,d,e){for(;;)if(v(e))a=b.c(a,d),d=K(e),e=N(e);else return b.c(a,d)}a.A=2;a.o=function(a){var b=K(a);a=N(a);var d=K(a);a=L(a);return c(b,d,a)};a.k=c;return a}(),b=function(b,e,f){switch(arguments.length){case 0:return ic;case 1:return b;case 2:return a.call(this,b,e);default:return c.k(b,\ne,P(arguments,2))}throw Error(&quot;Invalid arity: &quot;+arguments.length);};b.A=2;b.o=c.o;b.v=function(){return ic};b.e=function(a){return a};b.c=a;b.k=c.k;return b}();function kc(a){return null==a?null:Da(a)}function S(a){if(null!=a)if(a&amp;&amp;(a.l&amp;2||a.nc))a=a.S(null);else if(a instanceof Array)a=a.length;else if(&quot;string&quot;===typeof a)a=a.length;else if(w(Ba,a))a=Ca(a);else a:{a=I(a);for(var b=0;;){if(ec(a)){a=b+Ca(a);break a}a=N(a);b+=1}a=void 0}else a=0;return a}\nvar lc=function(){function a(a,b,c){for(;;){if(null==a)return c;if(0===b)return I(a)?K(a):c;if(fc(a))return z.f(a,b,c);if(I(a))a=N(a),b-=1;else return c}}function b(a,b){for(;;){if(null==a)throw Error(&quot;Index out of bounds&quot;);if(0===b){if(I(a))return K(a);throw Error(&quot;Index out of bounds&quot;);}if(fc(a))return z.c(a,b);if(I(a)){var c=N(a),g=b-1;a=c;b=g}else throw Error(&quot;Index out of bounds&quot;);}}var c=null,c=function(c,e,f){switch(arguments.length){case 2:return b.call(this,c,e);case 3:return a.call(this,\nc,e,f)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};c.c=b;c.f=a;return c}(),T=function(){function a(a,b,c){if(&quot;number&quot;!==typeof b)throw Error(&quot;index argument to nth must be a number.&quot;);if(null==a)return c;if(a&amp;&amp;(a.l&amp;16||a.Ib))return a.da(null,b,c);if(a instanceof Array||&quot;string&quot;===typeof a)return b&lt;a.length?a[b]:c;if(w(Ha,a))return z.c(a,b);if(a?a.l&amp;64||a.ab||(a.l?0:w(Ia,a)):w(Ia,a))return lc.f(a,b,c);throw Error(&quot;nth not supported on this type &quot;+y.e(ua(ta(a))));}function b(a,b){if(&quot;number&quot;!==\ntypeof b)throw Error(&quot;index argument to nth must be a number&quot;);if(null==a)return a;if(a&amp;&amp;(a.l&amp;16||a.Ib))return a.N(null,b);if(a instanceof Array||&quot;string&quot;===typeof a)return b&lt;a.length?a[b]:null;if(w(Ha,a))return z.c(a,b);if(a?a.l&amp;64||a.ab||(a.l?0:w(Ia,a)):w(Ia,a))return lc.c(a,b);throw Error(&quot;nth not supported on this type &quot;+y.e(ua(ta(a))));}var c=null,c=function(c,e,f){switch(arguments.length){case 2:return b.call(this,c,e);case 3:return a.call(this,c,e,f)}throw Error(&quot;Invalid arity: &quot;+arguments.length);\n};c.c=b;c.f=a;return c}(),U=function(){function a(a,b,c){return null!=a?a&amp;&amp;(a.l&amp;256||a.Jb)?a.D(null,b,c):a instanceof Array?b&lt;a.length?a[b]:c:&quot;string&quot;===typeof a?b&lt;a.length?a[b]:c:w(Ma,a)?C.f(a,b,c):c:c}function b(a,b){return null==a?null:a&amp;&amp;(a.l&amp;256||a.Jb)?a.C(null,b):a instanceof Array?b&lt;a.length?a[b]:null:&quot;string&quot;===typeof a?b&lt;a.length?a[b]:null:w(Ma,a)?C.c(a,b):null}var c=null,c=function(c,e,f){switch(arguments.length){case 2:return b.call(this,c,e);case 3:return a.call(this,c,e,f)}throw Error(&quot;Invalid arity: &quot;+\narguments.length);};c.c=b;c.f=a;return c}(),nc=function(){function a(a,b,c){return null!=a?Pa(a,b,c):mc([b],[c])}var b=null,c=function(){function a(b,d,k,l){var m=null;3&lt;arguments.length&amp;&amp;(m=P(Array.prototype.slice.call(arguments,3),0));return c.call(this,b,d,k,m)}function c(a,d,e,l){for(;;)if(a=b.f(a,d,e),v(l))d=K(l),e=K(N(l)),l=N(N(l));else return a}a.A=3;a.o=function(a){var b=K(a);a=N(a);var d=K(a);a=N(a);var l=K(a);a=L(a);return c(b,d,l,a)};a.k=c;return a}(),b=function(b,e,f,g){switch(arguments.length){case 3:return a.call(this,\nb,e,f);default:return c.k(b,e,f,P(arguments,3))}throw Error(&quot;Invalid arity: &quot;+arguments.length);};b.A=3;b.o=c.o;b.f=a;b.k=c.k;return b}(),oc=function(){function a(a,b){return null==a?null:Ra(a,b)}var b=null,c=function(){function a(b,d,k){var l=null;2&lt;arguments.length&amp;&amp;(l=P(Array.prototype.slice.call(arguments,2),0));return c.call(this,b,d,l)}function c(a,d,e){for(;;){if(null==a)return null;a=b.c(a,d);if(v(e))d=K(e),e=N(e);else return a}}a.A=2;a.o=function(a){var b=K(a);a=N(a);var d=K(a);a=L(a);return c(b,\nd,a)};a.k=c;return a}(),b=function(b,e,f){switch(arguments.length){case 1:return b;case 2:return a.call(this,b,e);default:return c.k(b,e,P(arguments,2))}throw Error(&quot;Invalid arity: &quot;+arguments.length);};b.A=2;b.o=c.o;b.e=function(a){return a};b.c=a;b.k=c.k;return b}();function pc(a){var b=&quot;function&quot;==q(a);return b?b:a?v(v(null)?null:a.mc)?!0:a.Y?!1:w(xa,a):w(xa,a)}function qc(a,b){this.j=a;this.meta=b;this.w=0;this.l=393217}h=qc.prototype;\nh.call=function(){function a(a,b,c,d,e,f,g,k,l,m,n,p,r,t,u,G,A,J,O,H,V,ra){a=this;return sc.lb?sc.lb(a.j,b,c,d,e,f,g,k,l,m,n,p,r,t,u,G,A,J,O,H,V,ra):sc.call(null,a.j,b,c,d,e,f,g,k,l,m,n,p,r,t,u,G,A,J,O,H,V,ra)}function b(a,b,c,d,e,f,g,k,l,m,n,p,r,t,u,G,A,J,O,H,V){a=this;return a.j.Da?a.j.Da(b,c,d,e,f,g,k,l,m,n,p,r,t,u,G,A,J,O,H,V):a.j.call(null,b,c,d,e,f,g,k,l,m,n,p,r,t,u,G,A,J,O,H,V)}function c(a,b,c,d,e,f,g,k,l,m,n,p,r,t,u,G,A,J,O,H){a=this;return a.j.Ca?a.j.Ca(b,c,d,e,f,g,k,l,m,n,p,r,t,u,G,A,J,\nO,H):a.j.call(null,b,c,d,e,f,g,k,l,m,n,p,r,t,u,G,A,J,O,H)}function d(a,b,c,d,e,f,g,k,l,m,n,p,r,t,u,G,A,J,O){a=this;return a.j.Ba?a.j.Ba(b,c,d,e,f,g,k,l,m,n,p,r,t,u,G,A,J,O):a.j.call(null,b,c,d,e,f,g,k,l,m,n,p,r,t,u,G,A,J,O)}function e(a,b,c,d,e,f,g,k,l,m,n,p,r,t,u,G,A,J){a=this;return a.j.Aa?a.j.Aa(b,c,d,e,f,g,k,l,m,n,p,r,t,u,G,A,J):a.j.call(null,b,c,d,e,f,g,k,l,m,n,p,r,t,u,G,A,J)}function f(a,b,c,d,e,f,g,k,l,m,n,p,r,t,u,G,A){a=this;return a.j.za?a.j.za(b,c,d,e,f,g,k,l,m,n,p,r,t,u,G,A):a.j.call(null,\nb,c,d,e,f,g,k,l,m,n,p,r,t,u,G,A)}function g(a,b,c,d,e,f,g,k,l,m,n,p,r,t,u,G){a=this;return a.j.ya?a.j.ya(b,c,d,e,f,g,k,l,m,n,p,r,t,u,G):a.j.call(null,b,c,d,e,f,g,k,l,m,n,p,r,t,u,G)}function k(a,b,c,d,e,f,g,k,l,m,n,p,r,t,u){a=this;return a.j.xa?a.j.xa(b,c,d,e,f,g,k,l,m,n,p,r,t,u):a.j.call(null,b,c,d,e,f,g,k,l,m,n,p,r,t,u)}function l(a,b,c,d,e,f,g,k,l,m,n,p,r,t){a=this;return a.j.wa?a.j.wa(b,c,d,e,f,g,k,l,m,n,p,r,t):a.j.call(null,b,c,d,e,f,g,k,l,m,n,p,r,t)}function m(a,b,c,d,e,f,g,k,l,m,n,p,r){a=this;\nreturn a.j.va?a.j.va(b,c,d,e,f,g,k,l,m,n,p,r):a.j.call(null,b,c,d,e,f,g,k,l,m,n,p,r)}function n(a,b,c,d,e,f,g,k,l,m,n,p){a=this;return a.j.ua?a.j.ua(b,c,d,e,f,g,k,l,m,n,p):a.j.call(null,b,c,d,e,f,g,k,l,m,n,p)}function p(a,b,c,d,e,f,g,k,l,m,n){a=this;return a.j.ta?a.j.ta(b,c,d,e,f,g,k,l,m,n):a.j.call(null,b,c,d,e,f,g,k,l,m,n)}function r(a,b,c,d,e,f,g,k,l,m){a=this;return a.j.Fa?a.j.Fa(b,c,d,e,f,g,k,l,m):a.j.call(null,b,c,d,e,f,g,k,l,m)}function t(a,b,c,d,e,f,g,k,l){a=this;return a.j.Ea?a.j.Ea(b,c,\nd,e,f,g,k,l):a.j.call(null,b,c,d,e,f,g,k,l)}function u(a,b,c,d,e,f,g,k){a=this;return a.j.ia?a.j.ia(b,c,d,e,f,g,k):a.j.call(null,b,c,d,e,f,g,k)}function A(a,b,c,d,e,f,g){a=this;return a.j.Z?a.j.Z(b,c,d,e,f,g):a.j.call(null,b,c,d,e,f,g)}function G(a,b,c,d,e,f){a=this;return a.j.M?a.j.M(b,c,d,e,f):a.j.call(null,b,c,d,e,f)}function J(a,b,c,d,e){a=this;return a.j.n?a.j.n(b,c,d,e):a.j.call(null,b,c,d,e)}function O(a,b,c,d){a=this;return a.j.f?a.j.f(b,c,d):a.j.call(null,b,c,d)}function V(a,b,c){a=this;\nreturn a.j.c?a.j.c(b,c):a.j.call(null,b,c)}function ra(a,b){a=this;return a.j.e?a.j.e(b):a.j.call(null,b)}function Jb(a){a=this;return a.j.v?a.j.v():a.j.call(null)}var H=null,H=function(H,ca,ia,ma,qa,va,za,Fa,La,Oa,Ua,$a,hb,vb,Ib,Xb,rc,$c,Jd,Je,ng,Yh){switch(arguments.length){case 1:return Jb.call(this,H);case 2:return ra.call(this,H,ca);case 3:return V.call(this,H,ca,ia);case 4:return O.call(this,H,ca,ia,ma);case 5:return J.call(this,H,ca,ia,ma,qa);case 6:return G.call(this,H,ca,ia,ma,qa,va);case 7:return A.call(this,\nH,ca,ia,ma,qa,va,za);case 8:return u.call(this,H,ca,ia,ma,qa,va,za,Fa);case 9:return t.call(this,H,ca,ia,ma,qa,va,za,Fa,La);case 10:return r.call(this,H,ca,ia,ma,qa,va,za,Fa,La,Oa);case 11:return p.call(this,H,ca,ia,ma,qa,va,za,Fa,La,Oa,Ua);case 12:return n.call(this,H,ca,ia,ma,qa,va,za,Fa,La,Oa,Ua,$a);case 13:return m.call(this,H,ca,ia,ma,qa,va,za,Fa,La,Oa,Ua,$a,hb);case 14:return l.call(this,H,ca,ia,ma,qa,va,za,Fa,La,Oa,Ua,$a,hb,vb);case 15:return k.call(this,H,ca,ia,ma,qa,va,za,Fa,La,Oa,Ua,$a,\nhb,vb,Ib);case 16:return g.call(this,H,ca,ia,ma,qa,va,za,Fa,La,Oa,Ua,$a,hb,vb,Ib,Xb);case 17:return f.call(this,H,ca,ia,ma,qa,va,za,Fa,La,Oa,Ua,$a,hb,vb,Ib,Xb,rc);case 18:return e.call(this,H,ca,ia,ma,qa,va,za,Fa,La,Oa,Ua,$a,hb,vb,Ib,Xb,rc,$c);case 19:return d.call(this,H,ca,ia,ma,qa,va,za,Fa,La,Oa,Ua,$a,hb,vb,Ib,Xb,rc,$c,Jd);case 20:return c.call(this,H,ca,ia,ma,qa,va,za,Fa,La,Oa,Ua,$a,hb,vb,Ib,Xb,rc,$c,Jd,Je);case 21:return b.call(this,H,ca,ia,ma,qa,va,za,Fa,La,Oa,Ua,$a,hb,vb,Ib,Xb,rc,$c,Jd,Je,\nng);case 22:return a.call(this,H,ca,ia,ma,qa,va,za,Fa,La,Oa,Ua,$a,hb,vb,Ib,Xb,rc,$c,Jd,Je,ng,Yh)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};H.e=Jb;H.c=ra;H.f=V;H.n=O;H.M=J;H.Z=G;H.ia=A;H.Ea=u;H.Fa=t;H.ta=r;H.ua=p;H.va=n;H.wa=m;H.xa=l;H.ya=k;H.za=g;H.Aa=f;H.Ba=e;H.Ca=d;H.Da=c;H.sc=b;H.lb=a;return H}();h.apply=function(a,b){return this.call.apply(this,[this].concat(wa(b)))};h.v=function(){return this.j.v?this.j.v():this.j.call(null)};\nh.e=function(a){return this.j.e?this.j.e(a):this.j.call(null,a)};h.c=function(a,b){return this.j.c?this.j.c(a,b):this.j.call(null,a,b)};h.f=function(a,b,c){return this.j.f?this.j.f(a,b,c):this.j.call(null,a,b,c)};h.n=function(a,b,c,d){return this.j.n?this.j.n(a,b,c,d):this.j.call(null,a,b,c,d)};h.M=function(a,b,c,d,e){return this.j.M?this.j.M(a,b,c,d,e):this.j.call(null,a,b,c,d,e)};h.Z=function(a,b,c,d,e,f){return this.j.Z?this.j.Z(a,b,c,d,e,f):this.j.call(null,a,b,c,d,e,f)};\nh.ia=function(a,b,c,d,e,f,g){return this.j.ia?this.j.ia(a,b,c,d,e,f,g):this.j.call(null,a,b,c,d,e,f,g)};h.Ea=function(a,b,c,d,e,f,g,k){return this.j.Ea?this.j.Ea(a,b,c,d,e,f,g,k):this.j.call(null,a,b,c,d,e,f,g,k)};h.Fa=function(a,b,c,d,e,f,g,k,l){return this.j.Fa?this.j.Fa(a,b,c,d,e,f,g,k,l):this.j.call(null,a,b,c,d,e,f,g,k,l)};h.ta=function(a,b,c,d,e,f,g,k,l,m){return this.j.ta?this.j.ta(a,b,c,d,e,f,g,k,l,m):this.j.call(null,a,b,c,d,e,f,g,k,l,m)};\nh.ua=function(a,b,c,d,e,f,g,k,l,m,n){return this.j.ua?this.j.ua(a,b,c,d,e,f,g,k,l,m,n):this.j.call(null,a,b,c,d,e,f,g,k,l,m,n)};h.va=function(a,b,c,d,e,f,g,k,l,m,n,p){return this.j.va?this.j.va(a,b,c,d,e,f,g,k,l,m,n,p):this.j.call(null,a,b,c,d,e,f,g,k,l,m,n,p)};h.wa=function(a,b,c,d,e,f,g,k,l,m,n,p,r){return this.j.wa?this.j.wa(a,b,c,d,e,f,g,k,l,m,n,p,r):this.j.call(null,a,b,c,d,e,f,g,k,l,m,n,p,r)};\nh.xa=function(a,b,c,d,e,f,g,k,l,m,n,p,r,t){return this.j.xa?this.j.xa(a,b,c,d,e,f,g,k,l,m,n,p,r,t):this.j.call(null,a,b,c,d,e,f,g,k,l,m,n,p,r,t)};h.ya=function(a,b,c,d,e,f,g,k,l,m,n,p,r,t,u){return this.j.ya?this.j.ya(a,b,c,d,e,f,g,k,l,m,n,p,r,t,u):this.j.call(null,a,b,c,d,e,f,g,k,l,m,n,p,r,t,u)};h.za=function(a,b,c,d,e,f,g,k,l,m,n,p,r,t,u,A){return this.j.za?this.j.za(a,b,c,d,e,f,g,k,l,m,n,p,r,t,u,A):this.j.call(null,a,b,c,d,e,f,g,k,l,m,n,p,r,t,u,A)};\nh.Aa=function(a,b,c,d,e,f,g,k,l,m,n,p,r,t,u,A,G){return this.j.Aa?this.j.Aa(a,b,c,d,e,f,g,k,l,m,n,p,r,t,u,A,G):this.j.call(null,a,b,c,d,e,f,g,k,l,m,n,p,r,t,u,A,G)};h.Ba=function(a,b,c,d,e,f,g,k,l,m,n,p,r,t,u,A,G,J){return this.j.Ba?this.j.Ba(a,b,c,d,e,f,g,k,l,m,n,p,r,t,u,A,G,J):this.j.call(null,a,b,c,d,e,f,g,k,l,m,n,p,r,t,u,A,G,J)};\nh.Ca=function(a,b,c,d,e,f,g,k,l,m,n,p,r,t,u,A,G,J,O){return this.j.Ca?this.j.Ca(a,b,c,d,e,f,g,k,l,m,n,p,r,t,u,A,G,J,O):this.j.call(null,a,b,c,d,e,f,g,k,l,m,n,p,r,t,u,A,G,J,O)};h.Da=function(a,b,c,d,e,f,g,k,l,m,n,p,r,t,u,A,G,J,O,V){return this.j.Da?this.j.Da(a,b,c,d,e,f,g,k,l,m,n,p,r,t,u,A,G,J,O,V):this.j.call(null,a,b,c,d,e,f,g,k,l,m,n,p,r,t,u,A,G,J,O,V)};\nh.sc=function(a,b,c,d,e,f,g,k,l,m,n,p,r,t,u,A,G,J,O,V,ra){return sc.lb?sc.lb(this.j,a,b,c,d,e,f,g,k,l,m,n,p,r,t,u,A,G,J,O,V,ra):sc.call(null,this.j,a,b,c,d,e,f,g,k,l,m,n,p,r,t,u,A,G,J,O,V,ra)};h.mc=!0;h.K=function(a,b){return new qc(this.j,b)};h.J=function(){return this.meta};function tc(a,b){return pc(a)&amp;&amp;!(a?a.l&amp;262144||a.Cc||(a.l?0:w(db,a)):w(db,a))?new qc(a,b):null==a?null:eb(a,b)}function uc(a){var b=null!=a;return(b?a?a.l&amp;131072||a.uc||(a.l?0:w(bb,a)):w(bb,a):b)?cb(a):null}\nvar vc=function(){function a(a,b){return null==a?null:Xa(a,b)}var b=null,c=function(){function a(b,d,k){var l=null;2&lt;arguments.length&amp;&amp;(l=P(Array.prototype.slice.call(arguments,2),0));return c.call(this,b,d,l)}function c(a,d,e){for(;;){if(null==a)return null;a=b.c(a,d);if(v(e))d=K(e),e=N(e);else return a}}a.A=2;a.o=function(a){var b=K(a);a=N(a);var d=K(a);a=L(a);return c(b,d,a)};a.k=c;return a}(),b=function(b,e,f){switch(arguments.length){case 1:return b;case 2:return a.call(this,b,e);default:return c.k(b,\ne,P(arguments,2))}throw Error(&quot;Invalid arity: &quot;+arguments.length);};b.A=2;b.o=c.o;b.e=function(a){return a};b.c=a;b.k=c.k;return b}();function wc(a){return null==a||sa(I(a))}function xc(a){return null==a?!1:a?a.l&amp;4096||a.od?!0:a.l?!1:w(Wa,a):w(Wa,a)}function yc(a){return a?a.l&amp;16777216||a.nd?!0:a.l?!1:w(mb,a):w(mb,a)}function zc(a){return null==a?!1:a?a.l&amp;1024||a.ld?!0:a.l?!1:w(Qa,a):w(Qa,a)}function Ac(a){return a?a.l&amp;16384||a.pd?!0:a.l?!1:w(Ya,a):w(Ya,a)}\nfunction Bc(a){return a?a.w&amp;512||a.fd?!0:!1:!1}function Cc(a){var b=[];fa(a,function(a){return function(b,e){return a.push(e)}}(b));return b}function Dc(a,b,c,d,e){for(;0!==e;)c[d]=a[b],d+=1,e-=1,b+=1}var Ec={};function Fc(a){return null==a?!1:a?a.l&amp;64||a.ab?!0:a.l?!1:w(Ia,a):w(Ia,a)}function Gc(a){return v(a)?!0:!1}function Hc(a,b){return U.f(a,b,Ec)===Ec?!1:!0}\nfunction Tb(a,b){if(a===b)return 0;if(null==a)return-1;if(null==b)return 1;if(ta(a)===ta(b))return a&amp;&amp;(a.w&amp;2048||a.jb)?a.kb(null,b):a&gt;b?1:a&lt;b?-1:0;throw Error(&quot;compare on non-nil objects of different types&quot;);}\nvar Ic=function(){function a(a,b,c,g){for(;;){var k=Tb(T.c(a,g),T.c(b,g));if(0===k&amp;&amp;g+1&lt;c)g+=1;else return k}}function b(a,b){var f=S(a),g=S(b);return f&lt;g?-1:f&gt;g?1:c.n(a,b,f,0)}var c=null,c=function(c,e,f,g){switch(arguments.length){case 2:return b.call(this,c,e);case 4:return a.call(this,c,e,f,g)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};c.c=b;c.n=a;return c}(),Kc=function(){function a(a,b,c){for(c=I(c);;)if(c){b=a.c?a.c(b,K(c)):a.call(null,b,K(c));if(bc(b))return ab(b);c=N(c)}else return b}\nfunction b(a,b){var c=I(b);return c?Jc.f?Jc.f(a,K(c),N(c)):Jc.call(null,a,K(c),N(c)):a.v?a.v():a.call(null)}var c=null,c=function(c,e,f){switch(arguments.length){case 2:return b.call(this,c,e);case 3:return a.call(this,c,e,f)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};c.c=b;c.f=a;return c}(),Jc=function(){function a(a,b,c){return c&amp;&amp;(c.l&amp;524288||c.wc)?c.aa(null,a,b):c instanceof Array?dc.f(c,a,b):&quot;string&quot;===typeof c?dc.f(c,a,b):w(fb,c)?gb.f(c,a,b):Kc.f(a,b,c)}function b(a,b){return b&amp;&amp;(b.l&amp;\n524288||b.wc)?b.$(null,a):b instanceof Array?dc.c(b,a):&quot;string&quot;===typeof b?dc.c(b,a):w(fb,b)?gb.c(b,a):Kc.c(a,b)}var c=null,c=function(c,e,f){switch(arguments.length){case 2:return b.call(this,c,e);case 3:return a.call(this,c,e,f)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};c.c=b;c.f=a;return c}();\nfunction Lc(a){return function(){function b(b,c){return a.c?a.c(b,c):a.call(null,b,c)}function c(){return a.v?a.v():a.call(null)}var d=null,d=function(a,d){switch(arguments.length){case 0:return c.call(this);case 1:return a;case 2:return b.call(this,a,d)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};d.v=c;d.e=function(a){return a};d.c=b;return d}()}\nvar Mc=function(){function a(a,b,c,g){a=a.e?a.e(Lc(b)):a.call(null,Lc(b));c=Jc.f(a,c,g);c=a.e?a.e(bc(c)?ab(c):c):a.call(null,bc(c)?ab(c):c);return bc(c)?ab(c):c}function b(a,b,f){return c.n(a,b,b.v?b.v():b.call(null),f)}var c=null,c=function(c,e,f,g){switch(arguments.length){case 3:return b.call(this,c,e,f);case 4:return a.call(this,c,e,f,g)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};c.f=b;c.n=a;return c}();function Nc(a){return a-1}\nfunction Oc(a){a=(a-a%2)/2;return 0&lt;=a?Math.floor.e?Math.floor.e(a):Math.floor.call(null,a):Math.ceil.e?Math.ceil.e(a):Math.ceil.call(null,a)}function Pc(a){a-=a&gt;&gt;1&amp;1431655765;a=(a&amp;858993459)+(a&gt;&gt;2&amp;858993459);return 16843009*(a+(a&gt;&gt;4)&amp;252645135)&gt;&gt;24}function Qc(a){var b=1;for(a=I(a);;)if(a&amp;&amp;0&lt;b)b-=1,a=N(a);else return a}\nvar y=function(){function a(a){return null==a?&quot;&quot;:a.toString()}var b=null,c=function(){function a(b,d){var k=null;1&lt;arguments.length&amp;&amp;(k=P(Array.prototype.slice.call(arguments,1),0));return c.call(this,b,k)}function c(a,d){for(var e=new ga(b.e(a)),l=d;;)if(v(l))e=e.append(b.e(K(l))),l=N(l);else return e.toString()}a.A=1;a.o=function(a){var b=K(a);a=L(a);return c(b,a)};a.k=c;return a}(),b=function(b,e){switch(arguments.length){case 0:return&quot;&quot;;case 1:return a.call(this,b);default:return c.k(b,P(arguments,\n1))}throw Error(&quot;Invalid arity: &quot;+arguments.length);};b.A=1;b.o=c.o;b.v=function(){return&quot;&quot;};b.e=a;b.k=c.k;return b}(),Rc=function(){var a=null,a=function(a,c,d){switch(arguments.length){case 2:return a.substring(c);case 3:return a.substring(c,d)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};a.c=function(a,c){return a.substring(c)};a.f=function(a,c,d){return a.substring(c,d)};return a}();\nfunction gc(a,b){var c;if(yc(b))if(ec(a)&amp;&amp;ec(b)&amp;&amp;S(a)!==S(b))c=!1;else a:{c=I(a);for(var d=I(b);;){if(null==c){c=null==d;break a}if(null!=d&amp;&amp;E.c(K(c),K(d)))c=N(c),d=N(d);else{c=!1;break a}}c=void 0}else c=null;return Gc(c)}function Sc(a,b,c,d,e){this.meta=a;this.first=b;this.pa=c;this.count=d;this.t=e;this.l=65937646;this.w=8192}h=Sc.prototype;h.toString=function(){return Gb(this)};h.J=function(){return this.meta};h.ea=function(){return new Sc(this.meta,this.first,this.pa,this.count,this.t)};\nh.fa=function(){return 1===this.count?null:this.pa};h.S=function(){return this.count};h.I=function(){var a=this.t;return null!=a?a:this.t=a=Yb(this)};h.G=function(a,b){return gc(this,b)};h.T=function(){return M};h.$=function(a,b){return Kc.c(b,this)};h.aa=function(a,b,c){return Kc.f(b,c,this)};h.X=function(){return this.first};h.ca=function(){return 1===this.count?M:this.pa};h.O=function(){return this};h.K=function(a,b){return new Sc(b,this.first,this.pa,this.count,this.t)};\nh.R=function(a,b){return new Sc(this.meta,b,this,this.count+1,null)};function Tc(a){this.meta=a;this.l=65937614;this.w=8192}h=Tc.prototype;h.toString=function(){return Gb(this)};h.J=function(){return this.meta};h.ea=function(){return new Tc(this.meta)};h.fa=function(){return null};h.S=function(){return 0};h.I=function(){return 0};h.G=function(a,b){return gc(this,b)};h.T=function(){return this};h.$=function(a,b){return Kc.c(b,this)};h.aa=function(a,b,c){return Kc.f(b,c,this)};h.X=function(){return null};\nh.ca=function(){return M};h.O=function(){return null};h.K=function(a,b){return new Tc(b)};h.R=function(a,b){return new Sc(this.meta,b,null,1,null)};\nvar M=new Tc(null),Uc=function(){function a(a){var d=null;0&lt;arguments.length&amp;&amp;(d=P(Array.prototype.slice.call(arguments,0),0));return b.call(this,d)}function b(a){var b;if(a instanceof Vb&amp;&amp;0===a.i)b=a.h;else a:{for(b=[];;)if(null!=a)b.push(a.X(null)),a=a.fa(null);else break a;b=void 0}a=b.length;for(var e=M;;)if(0&lt;a){var f=a-1,e=e.R(null,b[a-1]);a=f}else return e}a.A=0;a.o=function(a){a=I(a);return b(a)};a.k=b;return a}();\nfunction Vc(a,b,c,d){this.meta=a;this.first=b;this.pa=c;this.t=d;this.l=65929452;this.w=8192}h=Vc.prototype;h.toString=function(){return Gb(this)};h.J=function(){return this.meta};h.ea=function(){return new Vc(this.meta,this.first,this.pa,this.t)};h.fa=function(){return null==this.pa?null:I(this.pa)};h.I=function(){var a=this.t;return null!=a?a:this.t=a=Yb(this)};h.G=function(a,b){return gc(this,b)};h.T=function(){return tc(M,this.meta)};h.$=function(a,b){return Kc.c(b,this)};\nh.aa=function(a,b,c){return Kc.f(b,c,this)};h.X=function(){return this.first};h.ca=function(){return null==this.pa?M:this.pa};h.O=function(){return this};h.K=function(a,b){return new Vc(b,this.first,this.pa,this.t)};h.R=function(a,b){return new Vc(null,b,this,this.t)};function R(a,b){var c=null==b;return(c?c:b&amp;&amp;(b.l&amp;64||b.ab))?new Vc(null,a,b,null):new Vc(null,a,I(b),null)}function W(a,b,c,d){this.ka=a;this.name=b;this.Ja=c;this.Ta=d;this.l=2153775105;this.w=4096}h=W.prototype;\nh.H=function(a,b){return D(b,&quot;:&quot;+y.e(this.Ja))};h.I=function(){var a=this.Ta;return null!=a?a:this.Ta=a=Rb(this)+2654435769|0};h.call=function(){var a=null,a=function(a,c,d){switch(arguments.length){case 2:return U.c(c,this);case 3:return U.f(c,this,d)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};a.c=function(a,c){return U.c(c,this)};a.f=function(a,c,d){return U.f(c,this,d)};return a}();h.apply=function(a,b){return this.call.apply(this,[this].concat(wa(b)))};h.e=function(a){return U.c(a,this)};\nh.c=function(a,b){return U.f(a,this,b)};h.G=function(a,b){return b instanceof W?this.Ja===b.Ja:!1};h.toString=function(){return&quot;:&quot;+y.e(this.Ja)};function Wc(a,b){return a===b?!0:a instanceof W&amp;&amp;b instanceof W?a.Ja===b.Ja:!1}\nvar Yc=function(){function a(a,b){return new W(a,b,&quot;&quot;+y.e(v(a)?&quot;&quot;+y.e(a)+&quot;/&quot;:null)+y.e(b),null)}function b(a){if(a instanceof W)return a;if(a instanceof F){var b;if(a&amp;&amp;(a.w&amp;4096||a.vc))b=a.ka;else throw Error(&quot;Doesn&apos;t support namespace: &quot;+y.e(a));return new W(b,Xc.e?Xc.e(a):Xc.call(null,a),a.Na,null)}return&quot;string&quot;===typeof a?(b=a.split(&quot;/&quot;),2===b.length?new W(b[0],b[1],a,null):new W(null,b[0],a,null)):null}var c=null,c=function(c,e){switch(arguments.length){case 1:return b.call(this,c);case 2:return a.call(this,\nc,e)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};c.e=b;c.c=a;return c}();function Zc(a,b,c,d){this.meta=a;this.Xa=b;this.s=c;this.t=d;this.w=0;this.l=32374988}h=Zc.prototype;h.toString=function(){return Gb(this)};function ad(a){null!=a.Xa&amp;&amp;(a.s=a.Xa.v?a.Xa.v():a.Xa.call(null),a.Xa=null);return a.s}h.J=function(){return this.meta};h.fa=function(){lb(this);return null==this.s?null:N(this.s)};h.I=function(){var a=this.t;return null!=a?a:this.t=a=Yb(this)};h.G=function(a,b){return gc(this,b)};\nh.T=function(){return tc(M,this.meta)};h.$=function(a,b){return Kc.c(b,this)};h.aa=function(a,b,c){return Kc.f(b,c,this)};h.X=function(){lb(this);return null==this.s?null:K(this.s)};h.ca=function(){lb(this);return null!=this.s?L(this.s):M};h.O=function(){ad(this);if(null==this.s)return null;for(var a=this.s;;)if(a instanceof Zc)a=ad(a);else return this.s=a,I(this.s)};h.K=function(a,b){return new Zc(b,this.Xa,this.s,this.t)};h.R=function(a,b){return R(b,this)};\nfunction bd(a,b){this.U=a;this.end=b;this.w=0;this.l=2}bd.prototype.S=function(){return this.end};bd.prototype.add=function(a){this.U[this.end]=a;return this.end+=1};bd.prototype.sa=function(){var a=new cd(this.U,0,this.end);this.U=null;return a};function cd(a,b,c){this.h=a;this.P=b;this.end=c;this.w=0;this.l=524306}h=cd.prototype;h.$=function(a,b){return dc.n(this.h,b,this.h[this.P],this.P+1)};h.aa=function(a,b,c){return dc.n(this.h,b,c,this.P)};\nh.Hb=function(){if(this.P===this.end)throw Error(&quot;-drop-first of empty chunk&quot;);return new cd(this.h,this.P+1,this.end)};h.N=function(a,b){return this.h[this.P+b]};h.da=function(a,b,c){return 0&lt;=b&amp;&amp;b&lt;this.end-this.P?this.h[this.P+b]:c};h.S=function(){return this.end-this.P};\nvar dd=function(){function a(a,b,c){return new cd(a,b,c)}function b(a,b){return new cd(a,b,a.length)}function c(a){return new cd(a,0,a.length)}var d=null,d=function(d,f,g){switch(arguments.length){case 1:return c.call(this,d);case 2:return b.call(this,d,f);case 3:return a.call(this,d,f,g)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};d.e=c;d.c=b;d.f=a;return d}();function ed(a,b,c,d){this.sa=a;this.ra=b;this.meta=c;this.t=d;this.l=31850732;this.w=1536}h=ed.prototype;h.toString=function(){return Gb(this)};\nh.J=function(){return this.meta};h.fa=function(){if(1&lt;Ca(this.sa))return new ed(yb(this.sa),this.ra,this.meta,null);var a=lb(this.ra);return null==a?null:a};h.I=function(){var a=this.t;return null!=a?a:this.t=a=Yb(this)};h.G=function(a,b){return gc(this,b)};h.T=function(){return tc(M,this.meta)};h.X=function(){return z.c(this.sa,0)};h.ca=function(){return 1&lt;Ca(this.sa)?new ed(yb(this.sa),this.ra,this.meta,null):null==this.ra?M:this.ra};h.O=function(){return this};h.wb=function(){return this.sa};\nh.xb=function(){return null==this.ra?M:this.ra};h.K=function(a,b){return new ed(this.sa,this.ra,b,this.t)};h.R=function(a,b){return R(b,this)};h.vb=function(){return null==this.ra?null:this.ra};function fd(a,b){return 0===Ca(a)?b:new ed(a,b,null,null)}function gd(a){for(var b=[];;)if(I(a))b.push(K(a)),a=N(a);else return b}function hd(a,b){if(ec(a))return S(a);for(var c=a,d=b,e=0;;)if(0&lt;d&amp;&amp;I(c))c=N(c),d-=1,e+=1;else return e}\nvar jd=function id(b){return null==b?null:null==N(b)?I(K(b)):R(K(b),id(N(b)))},kd=function(){function a(a,b){return new Zc(null,function(){var c=I(a);return c?Bc(c)?fd(zb(c),d.c(Ab(c),b)):R(K(c),d.c(L(c),b)):b},null,null)}function b(a){return new Zc(null,function(){return a},null,null)}function c(){return new Zc(null,function(){return null},null,null)}var d=null,e=function(){function a(c,d,e){var f=null;2&lt;arguments.length&amp;&amp;(f=P(Array.prototype.slice.call(arguments,2),0));return b.call(this,c,d,f)}\nfunction b(a,c,e){return function p(a,b){return new Zc(null,function(){var c=I(a);return c?Bc(c)?fd(zb(c),p(Ab(c),b)):R(K(c),p(L(c),b)):v(b)?p(K(b),N(b)):null},null,null)}(d.c(a,c),e)}a.A=2;a.o=function(a){var c=K(a);a=N(a);var d=K(a);a=L(a);return b(c,d,a)};a.k=b;return a}(),d=function(d,g,k){switch(arguments.length){case 0:return c.call(this);case 1:return b.call(this,d);case 2:return a.call(this,d,g);default:return e.k(d,g,P(arguments,2))}throw Error(&quot;Invalid arity: &quot;+arguments.length);};d.A=2;\nd.o=e.o;d.v=c;d.e=b;d.c=a;d.k=e.k;return d}(),ld=function(){function a(a,b,c,d){return R(a,R(b,R(c,d)))}function b(a,b,c){return R(a,R(b,c))}var c=null,d=function(){function a(c,d,e,m,n){var p=null;4&lt;arguments.length&amp;&amp;(p=P(Array.prototype.slice.call(arguments,4),0));return b.call(this,c,d,e,m,p)}function b(a,c,d,e,f){return R(a,R(c,R(d,R(e,jd(f)))))}a.A=4;a.o=function(a){var c=K(a);a=N(a);var d=K(a);a=N(a);var e=K(a);a=N(a);var n=K(a);a=L(a);return b(c,d,e,n,a)};a.k=b;return a}(),c=function(c,f,g,\nk,l){switch(arguments.length){case 1:return I(c);case 2:return R(c,f);case 3:return b.call(this,c,f,g);case 4:return a.call(this,c,f,g,k);default:return d.k(c,f,g,k,P(arguments,4))}throw Error(&quot;Invalid arity: &quot;+arguments.length);};c.A=4;c.o=d.o;c.e=function(a){return I(a)};c.c=function(a,b){return R(a,b)};c.f=b;c.n=a;c.k=d.k;return c}(),md=function(){function a(){return sb(ic)}var b=null,c=function(){function a(c,d,k){var l=null;2&lt;arguments.length&amp;&amp;(l=P(Array.prototype.slice.call(arguments,2),0));\nreturn b.call(this,c,d,l)}function b(a,c,d){for(;;)if(a=tb(a,c),v(d))c=K(d),d=N(d);else return a}a.A=2;a.o=function(a){var c=K(a);a=N(a);var d=K(a);a=L(a);return b(c,d,a)};a.k=b;return a}(),b=function(b,e,f){switch(arguments.length){case 0:return a.call(this);case 1:return b;case 2:return tb(b,e);default:return c.k(b,e,P(arguments,2))}throw Error(&quot;Invalid arity: &quot;+arguments.length);};b.A=2;b.o=c.o;b.v=a;b.e=function(a){return a};b.c=function(a,b){return tb(a,b)};b.k=c.k;return b}(),nd=function(){var a=\nnull,b=function(){function a(c,f,g,k){var l=null;3&lt;arguments.length&amp;&amp;(l=P(Array.prototype.slice.call(arguments,3),0));return b.call(this,c,f,g,l)}function b(a,c,d,k){for(;;)if(a=wb(a,c,d),v(k))c=K(k),d=K(N(k)),k=N(N(k));else return a}a.A=3;a.o=function(a){var c=K(a);a=N(a);var g=K(a);a=N(a);var k=K(a);a=L(a);return b(c,g,k,a)};a.k=b;return a}(),a=function(a,d,e,f){switch(arguments.length){case 3:return wb(a,d,e);default:return b.k(a,d,e,P(arguments,3))}throw Error(&quot;Invalid arity: &quot;+arguments.length);\n};a.A=3;a.o=b.o;a.f=function(a,b,e){return wb(a,b,e)};a.k=b.k;return a}();\nfunction od(a,b,c){var d=I(c);if(0===b)return a.v?a.v():a.call(null);c=B(d);var e=Ja(d);if(1===b)return a.e?a.e(c):a.e?a.e(c):a.call(null,c);var d=B(e),f=Ja(e);if(2===b)return a.c?a.c(c,d):a.c?a.c(c,d):a.call(null,c,d);var e=B(f),g=Ja(f);if(3===b)return a.f?a.f(c,d,e):a.f?a.f(c,d,e):a.call(null,c,d,e);var f=B(g),k=Ja(g);if(4===b)return a.n?a.n(c,d,e,f):a.n?a.n(c,d,e,f):a.call(null,c,d,e,f);var g=B(k),l=Ja(k);if(5===b)return a.M?a.M(c,d,e,f,g):a.M?a.M(c,d,e,f,g):a.call(null,c,d,e,f,g);var k=B(l),m=\nJa(l);if(6===b)return a.Z?a.Z(c,d,e,f,g,k):a.Z?a.Z(c,d,e,f,g,k):a.call(null,c,d,e,f,g,k);var l=B(m),n=Ja(m);if(7===b)return a.ia?a.ia(c,d,e,f,g,k,l):a.ia?a.ia(c,d,e,f,g,k,l):a.call(null,c,d,e,f,g,k,l);var m=B(n),p=Ja(n);if(8===b)return a.Ea?a.Ea(c,d,e,f,g,k,l,m):a.Ea?a.Ea(c,d,e,f,g,k,l,m):a.call(null,c,d,e,f,g,k,l,m);var n=B(p),r=Ja(p);if(9===b)return a.Fa?a.Fa(c,d,e,f,g,k,l,m,n):a.Fa?a.Fa(c,d,e,f,g,k,l,m,n):a.call(null,c,d,e,f,g,k,l,m,n);var p=B(r),t=Ja(r);if(10===b)return a.ta?a.ta(c,d,e,f,g,k,\nl,m,n,p):a.ta?a.ta(c,d,e,f,g,k,l,m,n,p):a.call(null,c,d,e,f,g,k,l,m,n,p);var r=B(t),u=Ja(t);if(11===b)return a.ua?a.ua(c,d,e,f,g,k,l,m,n,p,r):a.ua?a.ua(c,d,e,f,g,k,l,m,n,p,r):a.call(null,c,d,e,f,g,k,l,m,n,p,r);var t=B(u),A=Ja(u);if(12===b)return a.va?a.va(c,d,e,f,g,k,l,m,n,p,r,t):a.va?a.va(c,d,e,f,g,k,l,m,n,p,r,t):a.call(null,c,d,e,f,g,k,l,m,n,p,r,t);var u=B(A),G=Ja(A);if(13===b)return a.wa?a.wa(c,d,e,f,g,k,l,m,n,p,r,t,u):a.wa?a.wa(c,d,e,f,g,k,l,m,n,p,r,t,u):a.call(null,c,d,e,f,g,k,l,m,n,p,r,t,u);\nvar A=B(G),J=Ja(G);if(14===b)return a.xa?a.xa(c,d,e,f,g,k,l,m,n,p,r,t,u,A):a.xa?a.xa(c,d,e,f,g,k,l,m,n,p,r,t,u,A):a.call(null,c,d,e,f,g,k,l,m,n,p,r,t,u,A);var G=B(J),O=Ja(J);if(15===b)return a.ya?a.ya(c,d,e,f,g,k,l,m,n,p,r,t,u,A,G):a.ya?a.ya(c,d,e,f,g,k,l,m,n,p,r,t,u,A,G):a.call(null,c,d,e,f,g,k,l,m,n,p,r,t,u,A,G);var J=B(O),V=Ja(O);if(16===b)return a.za?a.za(c,d,e,f,g,k,l,m,n,p,r,t,u,A,G,J):a.za?a.za(c,d,e,f,g,k,l,m,n,p,r,t,u,A,G,J):a.call(null,c,d,e,f,g,k,l,m,n,p,r,t,u,A,G,J);var O=B(V),ra=Ja(V);\nif(17===b)return a.Aa?a.Aa(c,d,e,f,g,k,l,m,n,p,r,t,u,A,G,J,O):a.Aa?a.Aa(c,d,e,f,g,k,l,m,n,p,r,t,u,A,G,J,O):a.call(null,c,d,e,f,g,k,l,m,n,p,r,t,u,A,G,J,O);var V=B(ra),Jb=Ja(ra);if(18===b)return a.Ba?a.Ba(c,d,e,f,g,k,l,m,n,p,r,t,u,A,G,J,O,V):a.Ba?a.Ba(c,d,e,f,g,k,l,m,n,p,r,t,u,A,G,J,O,V):a.call(null,c,d,e,f,g,k,l,m,n,p,r,t,u,A,G,J,O,V);ra=B(Jb);Jb=Ja(Jb);if(19===b)return a.Ca?a.Ca(c,d,e,f,g,k,l,m,n,p,r,t,u,A,G,J,O,V,ra):a.Ca?a.Ca(c,d,e,f,g,k,l,m,n,p,r,t,u,A,G,J,O,V,ra):a.call(null,c,d,e,f,g,k,l,m,n,\np,r,t,u,A,G,J,O,V,ra);var H=B(Jb);Ja(Jb);if(20===b)return a.Da?a.Da(c,d,e,f,g,k,l,m,n,p,r,t,u,A,G,J,O,V,ra,H):a.Da?a.Da(c,d,e,f,g,k,l,m,n,p,r,t,u,A,G,J,O,V,ra,H):a.call(null,c,d,e,f,g,k,l,m,n,p,r,t,u,A,G,J,O,V,ra,H);throw Error(&quot;Only up to 20 arguments supported on functions&quot;);}\nvar sc=function(){function a(a,b,c,d,e){b=ld.n(b,c,d,e);c=a.A;return a.o?(d=hd(b,c+1),d&lt;=c?od(a,d,b):a.o(b)):a.apply(a,gd(b))}function b(a,b,c,d){b=ld.f(b,c,d);c=a.A;return a.o?(d=hd(b,c+1),d&lt;=c?od(a,d,b):a.o(b)):a.apply(a,gd(b))}function c(a,b,c){b=ld.c(b,c);c=a.A;if(a.o){var d=hd(b,c+1);return d&lt;=c?od(a,d,b):a.o(b)}return a.apply(a,gd(b))}function d(a,b){var c=a.A;if(a.o){var d=hd(b,c+1);return d&lt;=c?od(a,d,b):a.o(b)}return a.apply(a,gd(b))}var e=null,f=function(){function a(c,d,e,f,g,t){var u=null;\n5&lt;arguments.length&amp;&amp;(u=P(Array.prototype.slice.call(arguments,5),0));return b.call(this,c,d,e,f,g,u)}function b(a,c,d,e,f,g){c=R(c,R(d,R(e,R(f,jd(g)))));d=a.A;return a.o?(e=hd(c,d+1),e&lt;=d?od(a,e,c):a.o(c)):a.apply(a,gd(c))}a.A=5;a.o=function(a){var c=K(a);a=N(a);var d=K(a);a=N(a);var e=K(a);a=N(a);var f=K(a);a=N(a);var g=K(a);a=L(a);return b(c,d,e,f,g,a)};a.k=b;return a}(),e=function(e,k,l,m,n,p){switch(arguments.length){case 2:return d.call(this,e,k);case 3:return c.call(this,e,k,l);case 4:return b.call(this,\ne,k,l,m);case 5:return a.call(this,e,k,l,m,n);default:return f.k(e,k,l,m,n,P(arguments,5))}throw Error(&quot;Invalid arity: &quot;+arguments.length);};e.A=5;e.o=f.o;e.c=d;e.f=c;e.n=b;e.M=a;e.k=f.k;return e}(),pd=function(){function a(a,b){return!E.c(a,b)}var b=null,c=function(){function a(c,d,k){var l=null;2&lt;arguments.length&amp;&amp;(l=P(Array.prototype.slice.call(arguments,2),0));return b.call(this,c,d,l)}function b(a,c,d){return sa(sc.n(E,a,c,d))}a.A=2;a.o=function(a){var c=K(a);a=N(a);var d=K(a);a=L(a);return b(c,\nd,a)};a.k=b;return a}(),b=function(b,e,f){switch(arguments.length){case 1:return!1;case 2:return a.call(this,b,e);default:return c.k(b,e,P(arguments,2))}throw Error(&quot;Invalid arity: &quot;+arguments.length);};b.A=2;b.o=c.o;b.e=function(){return!1};b.c=a;b.k=c.k;return b}();function qd(a,b){for(;;){if(null==I(b))return!0;if(v(a.e?a.e(K(b)):a.call(null,K(b)))){var c=a,d=N(b);a=c;b=d}else return!1}}\nfunction rd(a){for(var b=sd;;)if(I(a)){var c=b.e?b.e(K(a)):b.call(null,K(a));if(v(c))return c;a=N(a)}else return null}function sd(a){return a}function td(a,b,c,d){this.state=a;this.meta=b;this.cd=c;this.Ya=d;this.l=6455296;this.w=16386}h=td.prototype;h.I=function(){return this[ba]||(this[ba]=++da)};\nh.Pb=function(a,b,c){a=I(this.Ya);for(var d=null,e=0,f=0;;)if(f&lt;e){var g=d.N(null,f),k=T.f(g,0,null),g=T.f(g,1,null);g.n?g.n(k,this,b,c):g.call(null,k,this,b,c);f+=1}else if(a=I(a))Bc(a)?(d=zb(a),a=Ab(a),k=d,e=S(d),d=k):(d=K(a),k=T.f(d,0,null),g=T.f(d,1,null),g.n?g.n(k,this,b,c):g.call(null,k,this,b,c),a=N(a),d=null,e=0),f=0;else return null};h.Ob=function(a,b,c){this.Ya=nc.f(this.Ya,b,c);return this};h.Qb=function(a,b){return this.Ya=oc.c(this.Ya,b)};h.J=function(){return this.meta};h.Pa=function(){return this.state};\nh.G=function(a,b){return this===b};\nvar X=function(){function a(a){return new td(a,null,null,null)}var b=null,c=function(){function a(c,d){var k=null;1&lt;arguments.length&amp;&amp;(k=P(Array.prototype.slice.call(arguments,1),0));return b.call(this,c,k)}function b(a,c){var d=Fc(c)?sc.c(ud,c):c,e=U.c(d,vd),d=U.c(d,na);return new td(a,d,e,null)}a.A=1;a.o=function(a){var c=K(a);a=L(a);return b(c,a)};a.k=b;return a}(),b=function(b,e){switch(arguments.length){case 1:return a.call(this,b);default:return c.k(b,P(arguments,1))}throw Error(&quot;Invalid arity: &quot;+\narguments.length);};b.A=1;b.o=c.o;b.e=a;b.k=c.k;return b}();\nfunction wd(a,b){if(a instanceof td){var c=a.cd;if(null!=c&amp;&amp;!v(c.e?c.e(b):c.call(null,b)))throw Error(&quot;Assert failed: Validator rejected reference state\\n&quot;+y.e(xd.e?xd.e(Uc(new F(null,&quot;validate&quot;,&quot;validate&quot;,1439230700,null),new F(null,&quot;new-value&quot;,&quot;new-value&quot;,-1567397401,null))):xd.call(null,Uc(new F(null,&quot;validate&quot;,&quot;validate&quot;,1439230700,null),new F(null,&quot;new-value&quot;,&quot;new-value&quot;,-1567397401,null)))));c=a.state;a.state=b;null!=a.Ya&amp;&amp;pb(a,c,b);return b}return Db(a,b)}\nvar yd=function(){function a(a,b,c,d){return a instanceof td?wd(a,b.f?b.f(a.state,c,d):b.call(null,a.state,c,d)):Eb.n(a,b,c,d)}function b(a,b,c){return a instanceof td?wd(a,b.c?b.c(a.state,c):b.call(null,a.state,c)):Eb.f(a,b,c)}function c(a,b){return a instanceof td?wd(a,b.e?b.e(a.state):b.call(null,a.state)):Eb.c(a,b)}var d=null,e=function(){function a(c,d,e,f,p){var r=null;4&lt;arguments.length&amp;&amp;(r=P(Array.prototype.slice.call(arguments,4),0));return b.call(this,c,d,e,f,r)}function b(a,c,d,e,f){return a instanceof\ntd?wd(a,sc.M(c,a.state,d,e,f)):Eb.M(a,c,d,e,f)}a.A=4;a.o=function(a){var c=K(a);a=N(a);var d=K(a);a=N(a);var e=K(a);a=N(a);var f=K(a);a=L(a);return b(c,d,e,f,a)};a.k=b;return a}(),d=function(d,g,k,l,m){switch(arguments.length){case 2:return c.call(this,d,g);case 3:return b.call(this,d,g,k);case 4:return a.call(this,d,g,k,l);default:return e.k(d,g,k,l,P(arguments,4))}throw Error(&quot;Invalid arity: &quot;+arguments.length);};d.A=4;d.o=e.o;d.c=c;d.f=b;d.n=a;d.k=e.k;return d}(),zd=function(){function a(a,b,c,\nd){return new Zc(null,function(){var f=I(b),p=I(c),r=I(d);return f&amp;&amp;p&amp;&amp;r?R(a.f?a.f(K(f),K(p),K(r)):a.call(null,K(f),K(p),K(r)),e.n(a,L(f),L(p),L(r))):null},null,null)}function b(a,b,c){return new Zc(null,function(){var d=I(b),f=I(c);return d&amp;&amp;f?R(a.c?a.c(K(d),K(f)):a.call(null,K(d),K(f)),e.f(a,L(d),L(f))):null},null,null)}function c(a,b){return new Zc(null,function(){var c=I(b);if(c){if(Bc(c)){for(var d=zb(c),f=S(d),p=new bd(Array(f),0),r=0;;)if(r&lt;f){var t=a.e?a.e(z.c(d,r)):a.call(null,z.c(d,r));\np.add(t);r+=1}else break;return fd(p.sa(),e.c(a,Ab(c)))}return R(a.e?a.e(K(c)):a.call(null,K(c)),e.c(a,L(c)))}return null},null,null)}function d(a){return function(b){return function(){function c(d,e){return b.c?b.c(d,a.e?a.e(e):a.call(null,e)):b.call(null,d,a.e?a.e(e):a.call(null,e))}function d(a){return b.e?b.e(a):b.call(null,a)}function e(){return b.v?b.v():b.call(null)}var f=null,r=function(){function c(a,b,e){var f=null;2&lt;arguments.length&amp;&amp;(f=P(Array.prototype.slice.call(arguments,2),0));return d.call(this,\na,b,f)}function d(c,e,f){return b.c?b.c(c,sc.f(a,e,f)):b.call(null,c,sc.f(a,e,f))}c.A=2;c.o=function(a){var b=K(a);a=N(a);var c=K(a);a=L(a);return d(b,c,a)};c.k=d;return c}(),f=function(a,b,f){switch(arguments.length){case 0:return e.call(this);case 1:return d.call(this,a);case 2:return c.call(this,a,b);default:return r.k(a,b,P(arguments,2))}throw Error(&quot;Invalid arity: &quot;+arguments.length);};f.A=2;f.o=r.o;f.v=e;f.e=d;f.c=c;f.k=r.k;return f}()}}var e=null,f=function(){function a(c,d,e,f,g){var t=null;\n4&lt;arguments.length&amp;&amp;(t=P(Array.prototype.slice.call(arguments,4),0));return b.call(this,c,d,e,f,t)}function b(a,c,d,f,g){var k=function A(a){return new Zc(null,function(){var b=e.c(I,a);return qd(sd,b)?R(e.c(K,b),A(e.c(L,b))):null},null,null)};return e.c(function(){return function(b){return sc.c(a,b)}}(k),k(jc.k(g,f,P([d,c],0))))}a.A=4;a.o=function(a){var c=K(a);a=N(a);var d=K(a);a=N(a);var e=K(a);a=N(a);var f=K(a);a=L(a);return b(c,d,e,f,a)};a.k=b;return a}(),e=function(e,k,l,m,n){switch(arguments.length){case 1:return d.call(this,\ne);case 2:return c.call(this,e,k);case 3:return b.call(this,e,k,l);case 4:return a.call(this,e,k,l,m);default:return f.k(e,k,l,m,P(arguments,4))}throw Error(&quot;Invalid arity: &quot;+arguments.length);};e.A=4;e.o=f.o;e.e=d;e.c=c;e.f=b;e.n=a;e.k=f.k;return e}(),Ad=function(){function a(a,b){return new Zc(null,function(){if(0&lt;a){var f=I(b);return f?R(K(f),c.c(a-1,L(f))):null}return null},null,null)}function b(a){return function(b){return function(a){return function(){function c(d,g){var k=ab(a),l=yd.c(a,Nc),\nk=0&lt;k?b.c?b.c(d,g):b.call(null,d,g):d;return 0&lt;l?k:new ac(k)}function d(a){return b.e?b.e(a):b.call(null,a)}function l(){return b.v?b.v():b.call(null)}var m=null,m=function(a,b){switch(arguments.length){case 0:return l.call(this);case 1:return d.call(this,a);case 2:return c.call(this,a,b)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};m.v=l;m.e=d;m.c=c;return m}()}(X.e(a))}}var c=null,c=function(c,e){switch(arguments.length){case 1:return b.call(this,c);case 2:return a.call(this,c,e)}throw Error(&quot;Invalid arity: &quot;+\narguments.length);};c.e=b;c.c=a;return c}(),Bd=function(){function a(a,b){return new Zc(null,function(c){return function(){return c(a,b)}}(function(a,b){for(;;){var c=I(b);if(0&lt;a&amp;&amp;c){var d=a-1,c=L(c);a=d;b=c}else return c}}),null,null)}function b(a){return function(b){return function(a){return function(){function c(d,g){var k=ab(a);yd.c(a,Nc);return 0&lt;k?d:b.c?b.c(d,g):b.call(null,d,g)}function d(a){return b.e?b.e(a):b.call(null,a)}function l(){return b.v?b.v():b.call(null)}var m=null,m=function(a,\nb){switch(arguments.length){case 0:return l.call(this);case 1:return d.call(this,a);case 2:return c.call(this,a,b)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};m.v=l;m.e=d;m.c=c;return m}()}(X.e(a))}}var c=null,c=function(c,e){switch(arguments.length){case 1:return b.call(this,c);case 2:return a.call(this,c,e)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};c.e=b;c.c=a;return c}(),Cd=function(){function a(a,b){return Ad.c(a,c.e(b))}function b(a){return new Zc(null,function(){return R(a,c.e(a))},\nnull,null)}var c=null,c=function(c,e){switch(arguments.length){case 1:return b.call(this,c);case 2:return a.call(this,c,e)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};c.e=b;c.c=a;return c}(),Dd=function(){function a(a,c){return new Zc(null,function(){var f=I(a),g=I(c);return f&amp;&amp;g?R(K(f),R(K(g),b.c(L(f),L(g)))):null},null,null)}var b=null,c=function(){function a(b,d,k){var l=null;2&lt;arguments.length&amp;&amp;(l=P(Array.prototype.slice.call(arguments,2),0));return c.call(this,b,d,l)}function c(a,d,e){return new Zc(null,\nfunction(){var c=zd.c(I,jc.k(e,d,P([a],0)));return qd(sd,c)?kd.c(zd.c(K,c),sc.c(b,zd.c(L,c))):null},null,null)}a.A=2;a.o=function(a){var b=K(a);a=N(a);var d=K(a);a=L(a);return c(b,d,a)};a.k=c;return a}(),b=function(b,e,f){switch(arguments.length){case 2:return a.call(this,b,e);default:return c.k(b,e,P(arguments,2))}throw Error(&quot;Invalid arity: &quot;+arguments.length);};b.A=2;b.o=c.o;b.c=a;b.k=c.k;return b}();function Ed(a){return Bd.c(1,Dd.c(Cd.e(&quot;, &quot;),a))}\nvar Fd=function(){function a(a,b,c){a&amp;&amp;(a.w&amp;4||a.oc)?(b=Mc.n(b,tb,sb(a),c),b=ub(b),a=tc(b,uc(a))):a=Mc.n(b,jc,a,c);return a}function b(a,b){var c;null!=a?a&amp;&amp;(a.w&amp;4||a.oc)?(c=Jc.f(tb,sb(a),b),c=ub(c),c=tc(c,uc(a))):c=Jc.f(Ga,a,b):c=Jc.f(jc,M,b);return c}var c=null,c=function(c,e,f){switch(arguments.length){case 2:return b.call(this,c,e);case 3:return a.call(this,c,e,f)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};c.c=b;c.f=a;return c}(),Gd=function(){function a(a,b,c){var g=Ec;for(b=I(b);;)if(b){var k=\na;if(k?k.l&amp;256||k.Jb||(k.l?0:w(Ma,k)):w(Ma,k)){a=U.f(a,K(b),g);if(g===a)return c;b=N(b)}else return c}else return a}function b(a,b){return c.f(a,b,null)}var c=null,c=function(c,e,f){switch(arguments.length){case 2:return b.call(this,c,e);case 3:return a.call(this,c,e,f)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};c.c=b;c.f=a;return c}(),Id=function Hd(b,c,d){var e=T.f(c,0,null);return(c=Qc(c))?nc.f(b,e,Hd(U.c(b,e),c,d)):nc.f(b,e,d)},Kd=function(){function a(a,b,c,d,f,p){var r=T.f(b,0,null);\nreturn(b=Qc(b))?nc.f(a,r,e.Z(U.c(a,r),b,c,d,f,p)):nc.f(a,r,c.n?c.n(U.c(a,r),d,f,p):c.call(null,U.c(a,r),d,f,p))}function b(a,b,c,d,f){var p=T.f(b,0,null);return(b=Qc(b))?nc.f(a,p,e.M(U.c(a,p),b,c,d,f)):nc.f(a,p,c.f?c.f(U.c(a,p),d,f):c.call(null,U.c(a,p),d,f))}function c(a,b,c,d){var f=T.f(b,0,null);return(b=Qc(b))?nc.f(a,f,e.n(U.c(a,f),b,c,d)):nc.f(a,f,c.c?c.c(U.c(a,f),d):c.call(null,U.c(a,f),d))}function d(a,b,c){var d=T.f(b,0,null);return(b=Qc(b))?nc.f(a,d,e.f(U.c(a,d),b,c)):nc.f(a,d,c.e?c.e(U.c(a,\nd)):c.call(null,U.c(a,d)))}var e=null,f=function(){function a(c,d,e,f,g,t,u){var A=null;6&lt;arguments.length&amp;&amp;(A=P(Array.prototype.slice.call(arguments,6),0));return b.call(this,c,d,e,f,g,t,A)}function b(a,c,d,f,g,k,u){var A=T.f(c,0,null);return(c=Qc(c))?nc.f(a,A,sc.k(e,U.c(a,A),c,d,f,P([g,k,u],0))):nc.f(a,A,sc.k(d,U.c(a,A),f,g,k,P([u],0)))}a.A=6;a.o=function(a){var c=K(a);a=N(a);var d=K(a);a=N(a);var e=K(a);a=N(a);var f=K(a);a=N(a);var g=K(a);a=N(a);var u=K(a);a=L(a);return b(c,d,e,f,g,u,a)};a.k=b;\nreturn a}(),e=function(e,k,l,m,n,p,r){switch(arguments.length){case 3:return d.call(this,e,k,l);case 4:return c.call(this,e,k,l,m);case 5:return b.call(this,e,k,l,m,n);case 6:return a.call(this,e,k,l,m,n,p);default:return f.k(e,k,l,m,n,p,P(arguments,6))}throw Error(&quot;Invalid arity: &quot;+arguments.length);};e.A=6;e.o=f.o;e.f=d;e.n=c;e.M=b;e.Z=a;e.k=f.k;return e}();function Ld(a,b){this.F=a;this.h=b}\nfunction Md(a){return new Ld(a,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null])}function Nd(a){a=a.m;return 32&gt;a?0:a-1&gt;&gt;&gt;5&lt;&lt;5}function Od(a,b,c){for(;;){if(0===b)return c;var d=Md(a);d.h[0]=c;c=d;b-=5}}var Qd=function Pd(b,c,d,e){var f=new Ld(d.F,wa(d.h)),g=b.m-1&gt;&gt;&gt;c&amp;31;5===c?f.h[g]=e:(d=d.h[g],b=null!=d?Pd(b,c-5,d,e):Od(null,c-5,e),f.h[g]=b);return f};\nfunction Rd(a,b){throw Error(&quot;No item &quot;+y.e(a)+&quot; in vector of length &quot;+y.e(b));}function Sd(a){var b=a.root;for(a=a.shift;;)if(0&lt;a)a-=5,b=b.h[0];else return b.h}function Td(a,b){if(b&gt;=Nd(a))return a.B;for(var c=a.root,d=a.shift;;)if(0&lt;d)var e=d-5,c=c.h[b&gt;&gt;&gt;d&amp;31],d=e;else return c.h}function Ud(a,b){return 0&lt;=b&amp;&amp;b&lt;a.m?Td(a,b):Rd(b,a.m)}var Wd=function Vd(b,c,d,e,f){var g=new Ld(d.F,wa(d.h));if(0===c)g.h[e&amp;31]=f;else{var k=e&gt;&gt;&gt;c&amp;31;b=Vd(b,c-5,d.h[k],e,f);g.h[k]=b}return g};\nfunction Xd(a,b,c,d,e,f){this.meta=a;this.m=b;this.shift=c;this.root=d;this.B=e;this.t=f;this.l=167668511;this.w=8196}h=Xd.prototype;h.toString=function(){return Gb(this)};h.C=function(a,b){return C.f(this,b,null)};h.D=function(a,b,c){return&quot;number&quot;===typeof b?z.f(this,b,c):c};h.N=function(a,b){return Ud(this,b)[b&amp;31]};h.da=function(a,b,c){return 0&lt;=b&amp;&amp;b&lt;this.m?Td(this,b)[b&amp;31]:c};\nh.zb=function(a,b,c){if(0&lt;=b&amp;&amp;b&lt;this.m)return Nd(this)&lt;=b?(a=wa(this.B),a[b&amp;31]=c,new Xd(this.meta,this.m,this.shift,this.root,a,null)):new Xd(this.meta,this.m,this.shift,Wd(this,this.shift,this.root,b,c),this.B,null);if(b===this.m)return Ga(this,c);throw Error(&quot;Index &quot;+y.e(b)+&quot; out of bounds  [0,&quot;+y.e(this.m)+&quot;]&quot;);};h.J=function(){return this.meta};h.ea=function(){return new Xd(this.meta,this.m,this.shift,this.root,this.B,this.t)};h.S=function(){return this.m};h.yb=function(){return z.c(this,0)};\nh.Kb=function(){return z.c(this,1)};h.I=function(){var a=this.t;return null!=a?a:this.t=a=Yb(this)};h.G=function(a,b){return gc(this,b)};h.$a=function(){return new Yd(this.m,this.shift,Zd.e?Zd.e(this.root):Zd.call(null,this.root),$d.e?$d.e(this.B):$d.call(null,this.B))};h.T=function(){return tc(ic,this.meta)};h.$=function(a,b){return cc.c(this,b)};h.aa=function(a,b,c){return cc.f(this,b,c)};\nh.Oa=function(a,b,c){if(&quot;number&quot;===typeof b)return Za(this,b,c);throw Error(&quot;Vector&apos;s key for assoc must be a number.&quot;);};h.O=function(){return 0===this.m?null:32&gt;=this.m?new Vb(this.B,0):ae.n?ae.n(this,Sd(this),0,0):ae.call(null,this,Sd(this),0,0)};h.K=function(a,b){return new Xd(b,this.m,this.shift,this.root,this.B,this.t)};\nh.R=function(a,b){if(32&gt;this.m-Nd(this)){for(var c=this.B.length,d=Array(c+1),e=0;;)if(e&lt;c)d[e]=this.B[e],e+=1;else break;d[c]=b;return new Xd(this.meta,this.m+1,this.shift,this.root,d,null)}c=(d=this.m&gt;&gt;&gt;5&gt;1&lt;&lt;this.shift)?this.shift+5:this.shift;d?(d=Md(null),d.h[0]=this.root,e=Od(null,this.shift,new Ld(null,this.B)),d.h[1]=e):d=Qd(this,this.shift,this.root,new Ld(null,this.B));return new Xd(this.meta,this.m+1,c,d,[b],null)};\nh.call=function(){var a=null,a=function(a,c,d){switch(arguments.length){case 2:return this.N(null,c);case 3:return this.da(null,c,d)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};a.c=function(a,c){return this.N(null,c)};a.f=function(a,c,d){return this.da(null,c,d)};return a}();h.apply=function(a,b){return this.call.apply(this,[this].concat(wa(b)))};h.e=function(a){return this.N(null,a)};h.c=function(a,b){return this.da(null,a,b)};\nvar be=new Ld(null,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]),ic=new Xd(null,0,5,be,[],0);function ce(a){return ub(Jc.f(tb,sb(ic),a))}function de(a,b,c,d,e,f){this.Q=a;this.node=b;this.i=c;this.P=d;this.meta=e;this.t=f;this.l=32243948;this.w=1536}h=de.prototype;h.toString=function(){return Gb(this)};\nh.fa=function(){if(this.P+1&lt;this.node.length){var a=ae.n?ae.n(this.Q,this.node,this.i,this.P+1):ae.call(null,this.Q,this.node,this.i,this.P+1);return null==a?null:a}return Bb(this)};h.I=function(){var a=this.t;return null!=a?a:this.t=a=Yb(this)};h.G=function(a,b){return gc(this,b)};h.T=function(){return tc(ic,this.meta)};h.$=function(a,b){return cc.c(ee.f?ee.f(this.Q,this.i+this.P,S(this.Q)):ee.call(null,this.Q,this.i+this.P,S(this.Q)),b)};\nh.aa=function(a,b,c){return cc.f(ee.f?ee.f(this.Q,this.i+this.P,S(this.Q)):ee.call(null,this.Q,this.i+this.P,S(this.Q)),b,c)};h.X=function(){return this.node[this.P]};h.ca=function(){if(this.P+1&lt;this.node.length){var a=ae.n?ae.n(this.Q,this.node,this.i,this.P+1):ae.call(null,this.Q,this.node,this.i,this.P+1);return null==a?M:a}return Ab(this)};h.O=function(){return this};h.wb=function(){return dd.c(this.node,this.P)};\nh.xb=function(){var a=this.i+this.node.length;return a&lt;Ca(this.Q)?ae.n?ae.n(this.Q,Td(this.Q,a),a,0):ae.call(null,this.Q,Td(this.Q,a),a,0):M};h.K=function(a,b){return ae.M?ae.M(this.Q,this.node,this.i,this.P,b):ae.call(null,this.Q,this.node,this.i,this.P,b)};h.R=function(a,b){return R(b,this)};h.vb=function(){var a=this.i+this.node.length;return a&lt;Ca(this.Q)?ae.n?ae.n(this.Q,Td(this.Q,a),a,0):ae.call(null,this.Q,Td(this.Q,a),a,0):null};\nvar ae=function(){function a(a,b,c,d,l){return new de(a,b,c,d,l,null)}function b(a,b,c,d){return new de(a,b,c,d,null,null)}function c(a,b,c){return new de(a,Ud(a,b),b,c,null,null)}var d=null,d=function(d,f,g,k,l){switch(arguments.length){case 3:return c.call(this,d,f,g);case 4:return b.call(this,d,f,g,k);case 5:return a.call(this,d,f,g,k,l)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};d.f=c;d.n=b;d.M=a;return d}();\nfunction fe(a,b,c,d,e){this.meta=a;this.qa=b;this.start=c;this.end=d;this.t=e;this.l=166617887;this.w=8192}h=fe.prototype;h.toString=function(){return Gb(this)};h.C=function(a,b){return C.f(this,b,null)};h.D=function(a,b,c){return&quot;number&quot;===typeof b?z.f(this,b,c):c};h.N=function(a,b){return 0&gt;b||this.end&lt;=this.start+b?Rd(b,this.end-this.start):z.c(this.qa,this.start+b)};h.da=function(a,b,c){return 0&gt;b||this.end&lt;=this.start+b?c:z.f(this.qa,this.start+b,c)};\nh.zb=function(a,b,c){var d=this,e=d.start+b;return ge.M?ge.M(d.meta,nc.f(d.qa,e,c),d.start,function(){var a=d.end,b=e+1;return a&gt;b?a:b}(),null):ge.call(null,d.meta,nc.f(d.qa,e,c),d.start,function(){var a=d.end,b=e+1;return a&gt;b?a:b}(),null)};h.J=function(){return this.meta};h.ea=function(){return new fe(this.meta,this.qa,this.start,this.end,this.t)};h.S=function(){return this.end-this.start};h.I=function(){var a=this.t;return null!=a?a:this.t=a=Yb(this)};h.G=function(a,b){return gc(this,b)};\nh.T=function(){return tc(ic,this.meta)};h.$=function(a,b){return cc.c(this,b)};h.aa=function(a,b,c){return cc.f(this,b,c)};h.Oa=function(a,b,c){if(&quot;number&quot;===typeof b)return Za(this,b,c);throw Error(&quot;Subvec&apos;s key for assoc must be a number.&quot;);};h.O=function(){var a=this;return function(b){return function d(e){return e===a.end?null:R(z.c(a.qa,e),new Zc(null,function(){return function(){return d(e+1)}}(b),null,null))}}(this)(a.start)};\nh.K=function(a,b){return ge.M?ge.M(b,this.qa,this.start,this.end,this.t):ge.call(null,b,this.qa,this.start,this.end,this.t)};h.R=function(a,b){return ge.M?ge.M(this.meta,Za(this.qa,this.end,b),this.start,this.end+1,null):ge.call(null,this.meta,Za(this.qa,this.end,b),this.start,this.end+1,null)};\nh.call=function(){var a=null,a=function(a,c,d){switch(arguments.length){case 2:return this.N(null,c);case 3:return this.da(null,c,d)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};a.c=function(a,c){return this.N(null,c)};a.f=function(a,c,d){return this.da(null,c,d)};return a}();h.apply=function(a,b){return this.call.apply(this,[this].concat(wa(b)))};h.e=function(a){return this.N(null,a)};h.c=function(a,b){return this.da(null,a,b)};\nfunction ge(a,b,c,d,e){for(;;)if(b instanceof fe)c=b.start+c,d=b.start+d,b=b.qa;else{var f=S(b);if(0&gt;c||0&gt;d||c&gt;f||d&gt;f)throw Error(&quot;Index out of bounds&quot;);return new fe(a,b,c,d,e)}}var ee=function(){function a(a,b,c){return ge(null,a,b,c,null)}function b(a,b){return c.f(a,b,S(a))}var c=null,c=function(c,e,f){switch(arguments.length){case 2:return b.call(this,c,e);case 3:return a.call(this,c,e,f)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};c.c=b;c.f=a;return c}();\nfunction he(a,b){return a===b.F?b:new Ld(a,wa(b.h))}function Zd(a){return new Ld({},wa(a.h))}function $d(a){var b=[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];Dc(a,0,b,0,a.length);return b}var je=function ie(b,c,d,e){d=he(b.root.F,d);var f=b.m-1&gt;&gt;&gt;c&amp;31;if(5===c)b=e;else{var g=d.h[f];b=null!=g?ie(b,c-5,g,e):Od(b.root.F,c-5,e)}d.h[f]=b;return d};\nfunction Yd(a,b,c,d){this.m=a;this.shift=b;this.root=c;this.B=d;this.l=275;this.w=88}h=Yd.prototype;h.call=function(){var a=null,a=function(a,c,d){switch(arguments.length){case 2:return this.C(null,c);case 3:return this.D(null,c,d)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};a.c=function(a,c){return this.C(null,c)};a.f=function(a,c,d){return this.D(null,c,d)};return a}();h.apply=function(a,b){return this.call.apply(this,[this].concat(wa(b)))};h.e=function(a){return this.C(null,a)};\nh.c=function(a,b){return this.D(null,a,b)};h.C=function(a,b){return C.f(this,b,null)};h.D=function(a,b,c){return&quot;number&quot;===typeof b?z.f(this,b,c):c};h.N=function(a,b){if(this.root.F)return Ud(this,b)[b&amp;31];throw Error(&quot;nth after persistent!&quot;);};h.da=function(a,b,c){return 0&lt;=b&amp;&amp;b&lt;this.m?z.c(this,b):c};h.S=function(){if(this.root.F)return this.m;throw Error(&quot;count after persistent!&quot;);};\nh.Nb=function(a,b,c){var d=this;if(d.root.F){if(0&lt;=b&amp;&amp;b&lt;d.m)return Nd(this)&lt;=b?d.B[b&amp;31]=c:(a=function(){return function f(a,k){var l=he(d.root.F,k);if(0===a)l.h[b&amp;31]=c;else{var m=b&gt;&gt;&gt;a&amp;31,n=f(a-5,l.h[m]);l.h[m]=n}return l}}(this).call(null,d.shift,d.root),d.root=a),this;if(b===d.m)return tb(this,c);throw Error(&quot;Index &quot;+y.e(b)+&quot; out of bounds for TransientVector of length&quot;+y.e(d.m));}throw Error(&quot;assoc! after persistent!&quot;);};\nh.bb=function(a,b,c){if(&quot;number&quot;===typeof b)return xb(this,b,c);throw Error(&quot;TransientVector&apos;s key for assoc! must be a number.&quot;);};\nh.Qa=function(a,b){if(this.root.F){if(32&gt;this.m-Nd(this))this.B[this.m&amp;31]=b;else{var c=new Ld(this.root.F,this.B),d=[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];d[0]=b;this.B=d;if(this.m&gt;&gt;&gt;5&gt;1&lt;&lt;this.shift){var d=[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null],e=this.shift+\n5;d[0]=this.root;d[1]=Od(this.root.F,this.shift,c);this.root=new Ld(this.root.F,d);this.shift=e}else this.root=je(this,this.shift,this.root,c)}this.m+=1;return this}throw Error(&quot;conj! after persistent!&quot;);};h.Ra=function(){if(this.root.F){this.root.F=null;var a=this.m-Nd(this),b=Array(a);Dc(this.B,0,b,0,a);return new Xd(null,this.m,this.shift,this.root,b,null)}throw Error(&quot;persistent! called twice&quot;);};function ke(a,b,c,d){this.meta=a;this.ja=b;this.Ha=c;this.t=d;this.w=0;this.l=31850572}h=ke.prototype;\nh.toString=function(){return Gb(this)};h.J=function(){return this.meta};h.I=function(){var a=this.t;return null!=a?a:this.t=a=Yb(this)};h.G=function(a,b){return gc(this,b)};h.T=function(){return tc(M,this.meta)};h.X=function(){return K(this.ja)};h.ca=function(){var a=N(this.ja);return a?new ke(this.meta,a,this.Ha,null):null==this.Ha?Da(this):new ke(this.meta,this.Ha,null,null)};h.O=function(){return this};h.K=function(a,b){return new ke(b,this.ja,this.Ha,this.t)};h.R=function(a,b){return R(b,this)};\nfunction le(a,b,c,d,e){this.meta=a;this.count=b;this.ja=c;this.Ha=d;this.t=e;this.l=31858766;this.w=8192}h=le.prototype;h.toString=function(){return Gb(this)};h.J=function(){return this.meta};h.ea=function(){return new le(this.meta,this.count,this.ja,this.Ha,this.t)};h.S=function(){return this.count};h.I=function(){var a=this.t;return null!=a?a:this.t=a=Yb(this)};h.G=function(a,b){return gc(this,b)};h.T=function(){return me};h.X=function(){return K(this.ja)};h.ca=function(){return L(I(this))};\nh.O=function(){var a=I(this.Ha),b=this.ja;return v(v(b)?b:a)?new ke(null,this.ja,I(a),null):null};h.K=function(a,b){return new le(b,this.count,this.ja,this.Ha,this.t)};h.R=function(a,b){var c;v(this.ja)?(c=this.Ha,c=new le(this.meta,this.count+1,this.ja,jc.c(v(c)?c:ic,b),null)):c=new le(this.meta,this.count+1,jc.c(this.ja,b),ic,null);return c};var me=new le(null,0,null,ic,0);function ne(){this.w=0;this.l=2097152}ne.prototype.G=function(){return!1};var oe=new ne;\nfunction pe(a,b){return Gc(zc(b)?S(a)===S(b)?qd(sd,zd.c(function(a){return E.c(U.f(b,K(a),oe),K(N(a)))},a)):null:null)}\nfunction qe(a,b){var c=a.h;if(b instanceof W)a:{for(var d=c.length,e=b.Ja,f=0;;){if(d&lt;=f){c=-1;break a}var g=c[f];if(g instanceof W&amp;&amp;e===g.Ja){c=f;break a}f+=2}c=void 0}else if(&quot;string&quot;==typeof b||&quot;number&quot;===typeof b)a:{d=c.length;for(e=0;;){if(d&lt;=e){c=-1;break a}if(b===c[e]){c=e;break a}e+=2}c=void 0}else if(b instanceof F)a:{d=c.length;e=b.Na;for(f=0;;){if(d&lt;=f){c=-1;break a}g=c[f];if(g instanceof F&amp;&amp;e===g.Na){c=f;break a}f+=2}c=void 0}else if(null==b)a:{d=c.length;for(e=0;;){if(d&lt;=e){c=-1;break a}if(null==\nc[e]){c=e;break a}e+=2}c=void 0}else a:{d=c.length;for(e=0;;){if(d&lt;=e){c=-1;break a}if(E.c(b,c[e])){c=e;break a}e+=2}c=void 0}return c}function re(a,b,c){this.h=a;this.i=b;this.la=c;this.w=0;this.l=32374990}h=re.prototype;h.toString=function(){return Gb(this)};h.J=function(){return this.la};h.fa=function(){return this.i&lt;this.h.length-2?new re(this.h,this.i+2,this.la):null};h.S=function(){return(this.h.length-this.i)/2};h.I=function(){return Yb(this)};h.G=function(a,b){return gc(this,b)};\nh.T=function(){return tc(M,this.la)};h.$=function(a,b){return Kc.c(b,this)};h.aa=function(a,b,c){return Kc.f(b,c,this)};h.X=function(){return new Xd(null,2,5,be,[this.h[this.i],this.h[this.i+1]],null)};h.ca=function(){return this.i&lt;this.h.length-2?new re(this.h,this.i+2,this.la):M};h.O=function(){return this};h.K=function(a,b){return new re(this.h,this.i,b)};h.R=function(a,b){return R(b,this)};function s(a,b,c,d){this.meta=a;this.m=b;this.h=c;this.t=d;this.l=16647951;this.w=8196}h=s.prototype;\nh.toString=function(){return Gb(this)};h.C=function(a,b){return C.f(this,b,null)};h.D=function(a,b,c){a=qe(this,b);return-1===a?c:this.h[a+1]};h.J=function(){return this.meta};h.ea=function(){return new s(this.meta,this.m,this.h,this.t)};h.S=function(){return this.m};h.I=function(){var a=this.t;return null!=a?a:this.t=a=Zb(this)};h.G=function(a,b){return pe(this,b)};h.$a=function(){return new se({},this.h.length,wa(this.h))};h.T=function(){return eb(te,this.meta)};\nh.$=function(a,b){return Kc.c(b,this)};h.aa=function(a,b,c){return Kc.f(b,c,this)};h.mb=function(a,b){if(0&lt;=qe(this,b)){var c=this.h.length,d=c-2;if(0===d)return Da(this);for(var d=Array(d),e=0,f=0;;){if(e&gt;=c)return new s(this.meta,this.m-1,d,null);E.c(b,this.h[e])||(d[f]=this.h[e],d[f+1]=this.h[e+1],f+=2);e+=2}}else return this};\nh.Oa=function(a,b,c){a=qe(this,b);if(-1===a){if(this.m&lt;ue){a=this.h;for(var d=a.length,e=Array(d+2),f=0;;)if(f&lt;d)e[f]=a[f],f+=1;else break;e[d]=b;e[d+1]=c;return new s(this.meta,this.m+1,e,null)}return eb(Pa(Fd.c(ve,this),b,c),this.meta)}if(c===this.h[a+1])return this;b=wa(this.h);b[a+1]=c;return new s(this.meta,this.m,b,null)};h.Za=function(a,b){return-1!==qe(this,b)};h.O=function(){var a=this.h;return 0&lt;=a.length-2?new re(a,0,null):null};h.K=function(a,b){return new s(b,this.m,this.h,this.t)};\nh.R=function(a,b){if(Ac(b))return Pa(this,z.c(b,0),z.c(b,1));for(var c=this,d=I(b);;){if(null==d)return c;var e=K(d);if(Ac(e))c=Pa(c,z.c(e,0),z.c(e,1)),d=N(d);else throw Error(&quot;conj on a map takes map entries or seqables of map entries&quot;);}};\nh.call=function(){var a=null,a=function(a,c,d){switch(arguments.length){case 2:return this.C(null,c);case 3:return this.D(null,c,d)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};a.c=function(a,c){return this.C(null,c)};a.f=function(a,c,d){return this.D(null,c,d)};return a}();h.apply=function(a,b){return this.call.apply(this,[this].concat(wa(b)))};h.e=function(a){return this.C(null,a)};h.c=function(a,b){return this.D(null,a,b)};var te=new s(null,0,[],null),ue=8;\nfunction we(a){for(var b=a.length,c=0,d=sb(te);;)if(c&lt;b)var e=c+2,d=wb(d,a[c],a[c+1]),c=e;else return ub(d)}function se(a,b,c){this.Va=a;this.Sa=b;this.h=c;this.w=56;this.l=258}h=se.prototype;h.bb=function(a,b,c){if(v(this.Va)){a=qe(this,b);if(-1===a)return this.Sa+2&lt;=2*ue?(this.Sa+=2,this.h.push(b),this.h.push(c),this):nd.f(xe.c?xe.c(this.Sa,this.h):xe.call(null,this.Sa,this.h),b,c);c!==this.h[a+1]&amp;&amp;(this.h[a+1]=c);return this}throw Error(&quot;assoc! after persistent!&quot;);};\nh.Qa=function(a,b){if(v(this.Va)){if(b?b.l&amp;2048||b.tc||(b.l?0:w(Sa,b)):w(Sa,b))return wb(this,ye.e?ye.e(b):ye.call(null,b),ze.e?ze.e(b):ze.call(null,b));for(var c=I(b),d=this;;){var e=K(c);if(v(e))c=N(c),d=wb(d,ye.e?ye.e(e):ye.call(null,e),ze.e?ze.e(e):ze.call(null,e));else return d}}else throw Error(&quot;conj! after persistent!&quot;);};h.Ra=function(){if(v(this.Va))return this.Va=!1,new s(null,Oc(this.Sa),this.h,null);throw Error(&quot;persistent! called twice&quot;);};h.C=function(a,b){return C.f(this,b,null)};\nh.D=function(a,b,c){if(v(this.Va))return a=qe(this,b),-1===a?c:this.h[a+1];throw Error(&quot;lookup after persistent!&quot;);};h.S=function(){if(v(this.Va))return Oc(this.Sa);throw Error(&quot;count after persistent!&quot;);};function xe(a,b){for(var c=sb(ve),d=0;;)if(d&lt;a)c=nd.f(c,b[d],b[d+1]),d+=2;else return c}function Ae(){this.W=!1}function Be(a,b){return a===b?!0:Wc(a,b)?!0:E.c(a,b)}\nvar Ce=function(){function a(a,b,c,g,k){a=wa(a);a[b]=c;a[g]=k;return a}function b(a,b,c){a=wa(a);a[b]=c;return a}var c=null,c=function(c,e,f,g,k){switch(arguments.length){case 3:return b.call(this,c,e,f);case 5:return a.call(this,c,e,f,g,k)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};c.f=b;c.M=a;return c}();function De(a,b){var c=Array(a.length-2);Dc(a,0,c,0,2*b);Dc(a,2*(b+1),c,2*b,c.length-2*b);return c}\nvar Ee=function(){function a(a,b,c,g,k,l){a=a.Wa(b);a.h[c]=g;a.h[k]=l;return a}function b(a,b,c,g){a=a.Wa(b);a.h[c]=g;return a}var c=null,c=function(c,e,f,g,k,l){switch(arguments.length){case 4:return b.call(this,c,e,f,g);case 6:return a.call(this,c,e,f,g,k,l)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};c.n=b;c.Z=a;return c}();function Fe(a,b,c){this.F=a;this.L=b;this.h=c}h=Fe.prototype;\nh.Wa=function(a){if(a===this.F)return this;var b=Pc(this.L),c=Array(0&gt;b?4:2*(b+1));Dc(this.h,0,c,0,2*b);return new Fe(a,this.L,c)};h.fb=function(){return Ge.e?Ge.e(this.h):Ge.call(null,this.h)};h.La=function(a,b,c,d){var e=1&lt;&lt;(b&gt;&gt;&gt;a&amp;31);if(0===(this.L&amp;e))return d;var f=Pc(this.L&amp;e-1),e=this.h[2*f],f=this.h[2*f+1];return null==e?f.La(a+5,b,c,d):Be(c,e)?f:d};\nh.na=function(a,b,c,d,e,f){var g=1&lt;&lt;(c&gt;&gt;&gt;b&amp;31),k=Pc(this.L&amp;g-1);if(0===(this.L&amp;g)){var l=Pc(this.L);if(2*l&lt;this.h.length){a=this.Wa(a);b=a.h;f.W=!0;a:for(c=2*(l-k),f=2*k+(c-1),l=2*(k+1)+(c-1);;){if(0===c)break a;b[l]=b[f];l-=1;c-=1;f-=1}b[2*k]=d;b[2*k+1]=e;a.L|=g;return a}if(16&lt;=l){k=[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];k[c&gt;&gt;&gt;b&amp;31]=He.na(a,b+5,c,d,e,f);for(e=d=0;;)if(32&gt;d)0!==\n(this.L&gt;&gt;&gt;d&amp;1)&amp;&amp;(k[d]=null!=this.h[e]?He.na(a,b+5,Qb(this.h[e]),this.h[e],this.h[e+1],f):this.h[e+1],e+=2),d+=1;else break;return new Ie(a,l+1,k)}b=Array(2*(l+4));Dc(this.h,0,b,0,2*k);b[2*k]=d;b[2*k+1]=e;Dc(this.h,2*k,b,2*(k+1),2*(l-k));f.W=!0;a=this.Wa(a);a.h=b;a.L|=g;return a}l=this.h[2*k];g=this.h[2*k+1];if(null==l)return l=g.na(a,b+5,c,d,e,f),l===g?this:Ee.n(this,a,2*k+1,l);if(Be(d,l))return e===g?this:Ee.n(this,a,2*k+1,e);f.W=!0;return Ee.Z(this,a,2*k,null,2*k+1,Ke.ia?Ke.ia(a,b+5,l,g,c,d,e):\nKe.call(null,a,b+5,l,g,c,d,e))};\nh.ma=function(a,b,c,d,e){var f=1&lt;&lt;(b&gt;&gt;&gt;a&amp;31),g=Pc(this.L&amp;f-1);if(0===(this.L&amp;f)){var k=Pc(this.L);if(16&lt;=k){g=[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];g[b&gt;&gt;&gt;a&amp;31]=He.ma(a+5,b,c,d,e);for(d=c=0;;)if(32&gt;c)0!==(this.L&gt;&gt;&gt;c&amp;1)&amp;&amp;(g[c]=null!=this.h[d]?He.ma(a+5,Qb(this.h[d]),this.h[d],this.h[d+1],e):this.h[d+1],d+=2),c+=1;else break;return new Ie(null,k+1,g)}a=Array(2*(k+1));Dc(this.h,\n0,a,0,2*g);a[2*g]=c;a[2*g+1]=d;Dc(this.h,2*g,a,2*(g+1),2*(k-g));e.W=!0;return new Fe(null,this.L|f,a)}k=this.h[2*g];f=this.h[2*g+1];if(null==k)return k=f.ma(a+5,b,c,d,e),k===f?this:new Fe(null,this.L,Ce.f(this.h,2*g+1,k));if(Be(c,k))return d===f?this:new Fe(null,this.L,Ce.f(this.h,2*g+1,d));e.W=!0;return new Fe(null,this.L,Ce.M(this.h,2*g,null,2*g+1,Ke.Z?Ke.Z(a+5,k,f,b,c,d):Ke.call(null,a+5,k,f,b,c,d)))};\nh.gb=function(a,b,c){var d=1&lt;&lt;(b&gt;&gt;&gt;a&amp;31);if(0===(this.L&amp;d))return this;var e=Pc(this.L&amp;d-1),f=this.h[2*e],g=this.h[2*e+1];return null==f?(a=g.gb(a+5,b,c),a===g?this:null!=a?new Fe(null,this.L,Ce.f(this.h,2*e+1,a)):this.L===d?null:new Fe(null,this.L^d,De(this.h,e))):Be(c,f)?new Fe(null,this.L^d,De(this.h,e)):this};var He=new Fe(null,0,[]);function Ie(a,b,c){this.F=a;this.m=b;this.h=c}h=Ie.prototype;h.Wa=function(a){return a===this.F?this:new Ie(a,this.m,wa(this.h))};\nh.fb=function(){return Le.e?Le.e(this.h):Le.call(null,this.h)};h.La=function(a,b,c,d){var e=this.h[b&gt;&gt;&gt;a&amp;31];return null!=e?e.La(a+5,b,c,d):d};h.na=function(a,b,c,d,e,f){var g=c&gt;&gt;&gt;b&amp;31,k=this.h[g];if(null==k)return a=Ee.n(this,a,g,He.na(a,b+5,c,d,e,f)),a.m+=1,a;b=k.na(a,b+5,c,d,e,f);return b===k?this:Ee.n(this,a,g,b)};\nh.ma=function(a,b,c,d,e){var f=b&gt;&gt;&gt;a&amp;31,g=this.h[f];if(null==g)return new Ie(null,this.m+1,Ce.f(this.h,f,He.ma(a+5,b,c,d,e)));a=g.ma(a+5,b,c,d,e);return a===g?this:new Ie(null,this.m,Ce.f(this.h,f,a))};\nh.gb=function(a,b,c){var d=b&gt;&gt;&gt;a&amp;31,e=this.h[d];if(null!=e){a=e.gb(a+5,b,c);if(a===e)d=this;else if(null==a)if(8&gt;=this.m)a:{e=this.h;a=2*(this.m-1);b=Array(a);c=0;for(var f=1,g=0;;)if(c&lt;a)c!==d&amp;&amp;null!=e[c]&amp;&amp;(b[f]=e[c],f+=2,g|=1&lt;&lt;c),c+=1;else{d=new Fe(null,g,b);break a}d=void 0}else d=new Ie(null,this.m-1,Ce.f(this.h,d,a));else d=new Ie(null,this.m,Ce.f(this.h,d,a));return d}return this};function Me(a,b,c){b*=2;for(var d=0;;)if(d&lt;b){if(Be(c,a[d]))return d;d+=2}else return-1}\nfunction Ne(a,b,c,d){this.F=a;this.Ga=b;this.m=c;this.h=d}h=Ne.prototype;h.Wa=function(a){if(a===this.F)return this;var b=Array(2*(this.m+1));Dc(this.h,0,b,0,2*this.m);return new Ne(a,this.Ga,this.m,b)};h.fb=function(){return Ge.e?Ge.e(this.h):Ge.call(null,this.h)};h.La=function(a,b,c,d){a=Me(this.h,this.m,c);return 0&gt;a?d:Be(c,this.h[a])?this.h[a+1]:d};\nh.na=function(a,b,c,d,e,f){if(c===this.Ga){b=Me(this.h,this.m,d);if(-1===b){if(this.h.length&gt;2*this.m)return a=Ee.Z(this,a,2*this.m,d,2*this.m+1,e),f.W=!0,a.m+=1,a;c=this.h.length;b=Array(c+2);Dc(this.h,0,b,0,c);b[c]=d;b[c+1]=e;f.W=!0;f=this.m+1;a===this.F?(this.h=b,this.m=f,a=this):a=new Ne(this.F,this.Ga,f,b);return a}return this.h[b+1]===e?this:Ee.n(this,a,b+1,e)}return(new Fe(a,1&lt;&lt;(this.Ga&gt;&gt;&gt;b&amp;31),[null,this,null,null])).na(a,b,c,d,e,f)};\nh.ma=function(a,b,c,d,e){return b===this.Ga?(a=Me(this.h,this.m,c),-1===a?(a=2*this.m,b=Array(a+2),Dc(this.h,0,b,0,a),b[a]=c,b[a+1]=d,e.W=!0,new Ne(null,this.Ga,this.m+1,b)):E.c(this.h[a],d)?this:new Ne(null,this.Ga,this.m,Ce.f(this.h,a+1,d))):(new Fe(null,1&lt;&lt;(this.Ga&gt;&gt;&gt;a&amp;31),[null,this])).ma(a,b,c,d,e)};h.gb=function(a,b,c){a=Me(this.h,this.m,c);return-1===a?this:1===this.m?null:new Ne(null,this.Ga,this.m-1,De(this.h,Oc(a)))};\nvar Ke=function(){function a(a,b,c,g,k,l,m){var n=Qb(c);if(n===k)return new Ne(null,n,2,[c,g,l,m]);var p=new Ae;return He.na(a,b,n,c,g,p).na(a,b,k,l,m,p)}function b(a,b,c,g,k,l){var m=Qb(b);if(m===g)return new Ne(null,m,2,[b,c,k,l]);var n=new Ae;return He.ma(a,m,b,c,n).ma(a,g,k,l,n)}var c=null,c=function(c,e,f,g,k,l,m){switch(arguments.length){case 6:return b.call(this,c,e,f,g,k,l);case 7:return a.call(this,c,e,f,g,k,l,m)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};c.Z=b;c.ia=a;return c}();\nfunction Oe(a,b,c,d,e){this.meta=a;this.oa=b;this.i=c;this.s=d;this.t=e;this.w=0;this.l=32374860}h=Oe.prototype;h.toString=function(){return Gb(this)};h.J=function(){return this.meta};h.I=function(){var a=this.t;return null!=a?a:this.t=a=Yb(this)};h.G=function(a,b){return gc(this,b)};h.T=function(){return tc(M,this.meta)};h.$=function(a,b){return Kc.c(b,this)};h.aa=function(a,b,c){return Kc.f(b,c,this)};\nh.X=function(){return null==this.s?new Xd(null,2,5,be,[this.oa[this.i],this.oa[this.i+1]],null):K(this.s)};h.ca=function(){return null==this.s?Ge.f?Ge.f(this.oa,this.i+2,null):Ge.call(null,this.oa,this.i+2,null):Ge.f?Ge.f(this.oa,this.i,N(this.s)):Ge.call(null,this.oa,this.i,N(this.s))};h.O=function(){return this};h.K=function(a,b){return new Oe(b,this.oa,this.i,this.s,this.t)};h.R=function(a,b){return R(b,this)};\nvar Ge=function(){function a(a,b,c){if(null==c)for(c=a.length;;)if(b&lt;c){if(null!=a[b])return new Oe(null,a,b,null,null);var g=a[b+1];if(v(g)&amp;&amp;(g=g.fb(),v(g)))return new Oe(null,a,b+2,g,null);b+=2}else return null;else return new Oe(null,a,b,c,null)}function b(a){return c.f(a,0,null)}var c=null,c=function(c,e,f){switch(arguments.length){case 1:return b.call(this,c);case 3:return a.call(this,c,e,f)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};c.e=b;c.f=a;return c}();\nfunction Pe(a,b,c,d,e){this.meta=a;this.oa=b;this.i=c;this.s=d;this.t=e;this.w=0;this.l=32374860}h=Pe.prototype;h.toString=function(){return Gb(this)};h.J=function(){return this.meta};h.I=function(){var a=this.t;return null!=a?a:this.t=a=Yb(this)};h.G=function(a,b){return gc(this,b)};h.T=function(){return tc(M,this.meta)};h.$=function(a,b){return Kc.c(b,this)};h.aa=function(a,b,c){return Kc.f(b,c,this)};h.X=function(){return K(this.s)};\nh.ca=function(){return Le.n?Le.n(null,this.oa,this.i,N(this.s)):Le.call(null,null,this.oa,this.i,N(this.s))};h.O=function(){return this};h.K=function(a,b){return new Pe(b,this.oa,this.i,this.s,this.t)};h.R=function(a,b){return R(b,this)};\nvar Le=function(){function a(a,b,c,g){if(null==g)for(g=b.length;;)if(c&lt;g){var k=b[c];if(v(k)&amp;&amp;(k=k.fb(),v(k)))return new Pe(a,b,c+1,k,null);c+=1}else return null;else return new Pe(a,b,c,g,null)}function b(a){return c.n(null,a,0,null)}var c=null,c=function(c,e,f,g){switch(arguments.length){case 1:return b.call(this,c);case 4:return a.call(this,c,e,f,g)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};c.e=b;c.n=a;return c}();\nfunction Qe(a,b,c,d,e,f){this.meta=a;this.m=b;this.root=c;this.ba=d;this.ga=e;this.t=f;this.l=16123663;this.w=8196}h=Qe.prototype;h.toString=function(){return Gb(this)};h.C=function(a,b){return C.f(this,b,null)};h.D=function(a,b,c){return null==b?this.ba?this.ga:c:null==this.root?c:this.root.La(0,Qb(b),b,c)};h.J=function(){return this.meta};h.ea=function(){return new Qe(this.meta,this.m,this.root,this.ba,this.ga,this.t)};h.S=function(){return this.m};\nh.I=function(){var a=this.t;return null!=a?a:this.t=a=Zb(this)};h.G=function(a,b){return pe(this,b)};h.$a=function(){return new Re({},this.root,this.m,this.ba,this.ga)};h.T=function(){return eb(ve,this.meta)};h.mb=function(a,b){if(null==b)return this.ba?new Qe(this.meta,this.m-1,this.root,!1,null,null):this;if(null==this.root)return this;var c=this.root.gb(0,Qb(b),b);return c===this.root?this:new Qe(this.meta,this.m-1,c,this.ba,this.ga,null)};\nh.Oa=function(a,b,c){if(null==b)return this.ba&amp;&amp;c===this.ga?this:new Qe(this.meta,this.ba?this.m:this.m+1,this.root,!0,c,null);a=new Ae;b=(null==this.root?He:this.root).ma(0,Qb(b),b,c,a);return b===this.root?this:new Qe(this.meta,a.W?this.m+1:this.m,b,this.ba,this.ga,null)};h.Za=function(a,b){return null==b?this.ba:null==this.root?!1:this.root.La(0,Qb(b),b,Ec)!==Ec};h.O=function(){if(0&lt;this.m){var a=null!=this.root?this.root.fb():null;return this.ba?R(new Xd(null,2,5,be,[null,this.ga],null),a):a}return null};\nh.K=function(a,b){return new Qe(b,this.m,this.root,this.ba,this.ga,this.t)};h.R=function(a,b){if(Ac(b))return Pa(this,z.c(b,0),z.c(b,1));for(var c=this,d=I(b);;){if(null==d)return c;var e=K(d);if(Ac(e))c=Pa(c,z.c(e,0),z.c(e,1)),d=N(d);else throw Error(&quot;conj on a map takes map entries or seqables of map entries&quot;);}};\nh.call=function(){var a=null,a=function(a,c,d){switch(arguments.length){case 2:return this.C(null,c);case 3:return this.D(null,c,d)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};a.c=function(a,c){return this.C(null,c)};a.f=function(a,c,d){return this.D(null,c,d)};return a}();h.apply=function(a,b){return this.call.apply(this,[this].concat(wa(b)))};h.e=function(a){return this.C(null,a)};h.c=function(a,b){return this.D(null,a,b)};var ve=new Qe(null,0,null,!1,null,0);\nfunction mc(a,b){for(var c=a.length,d=0,e=sb(ve);;)if(d&lt;c)var f=d+1,e=e.bb(null,a[d],b[d]),d=f;else return ub(e)}function Re(a,b,c,d,e){this.F=a;this.root=b;this.count=c;this.ba=d;this.ga=e;this.w=56;this.l=258}h=Re.prototype;h.bb=function(a,b,c){return Se(this,b,c)};\nh.Qa=function(a,b){var c;a:{if(this.F){if(b?b.l&amp;2048||b.tc||(b.l?0:w(Sa,b)):w(Sa,b)){c=Se(this,ye.e?ye.e(b):ye.call(null,b),ze.e?ze.e(b):ze.call(null,b));break a}c=I(b);for(var d=this;;){var e=K(c);if(v(e))c=N(c),d=Se(d,ye.e?ye.e(e):ye.call(null,e),ze.e?ze.e(e):ze.call(null,e));else{c=d;break a}}}else throw Error(&quot;conj! after persistent&quot;);c=void 0}return c};\nh.Ra=function(){var a;if(this.F)this.F=null,a=new Qe(null,this.count,this.root,this.ba,this.ga,null);else throw Error(&quot;persistent! called twice&quot;);return a};h.C=function(a,b){return null==b?this.ba?this.ga:null:null==this.root?null:this.root.La(0,Qb(b),b)};h.D=function(a,b,c){return null==b?this.ba?this.ga:c:null==this.root?c:this.root.La(0,Qb(b),b,c)};h.S=function(){if(this.F)return this.count;throw Error(&quot;count after persistent!&quot;);};\nfunction Se(a,b,c){if(a.F){if(null==b)a.ga!==c&amp;&amp;(a.ga=c),a.ba||(a.count+=1,a.ba=!0);else{var d=new Ae;b=(null==a.root?He:a.root).na(a.F,0,Qb(b),b,c,d);b!==a.root&amp;&amp;(a.root=b);d.W&amp;&amp;(a.count+=1)}return a}throw Error(&quot;assoc! after persistent!&quot;);}\nvar ud=function(){function a(a){var d=null;0&lt;arguments.length&amp;&amp;(d=P(Array.prototype.slice.call(arguments,0),0));return b.call(this,d)}function b(a){a=I(a);for(var b=sb(ve);;)if(a){var e=N(N(a)),b=nd.f(b,K(a),K(N(a)));a=e}else return ub(b)}a.A=0;a.o=function(a){a=I(a);return b(a)};a.k=b;return a}();function Te(a,b){this.Ma=a;this.la=b;this.w=0;this.l=32374988}h=Te.prototype;h.toString=function(){return Gb(this)};h.J=function(){return this.la};\nh.fa=function(){var a=this.Ma,a=(a?a.l&amp;128||a.Lb||(a.l?0:w(Ka,a)):w(Ka,a))?this.Ma.fa(null):N(this.Ma);return null==a?null:new Te(a,this.la)};h.I=function(){return Yb(this)};h.G=function(a,b){return gc(this,b)};h.T=function(){return tc(M,this.la)};h.$=function(a,b){return Kc.c(b,this)};h.aa=function(a,b,c){return Kc.f(b,c,this)};h.X=function(){return this.Ma.X(null).yb()};\nh.ca=function(){var a=this.Ma,a=(a?a.l&amp;128||a.Lb||(a.l?0:w(Ka,a)):w(Ka,a))?this.Ma.fa(null):N(this.Ma);return null!=a?new Te(a,this.la):M};h.O=function(){return this};h.K=function(a,b){return new Te(this.Ma,b)};h.R=function(a,b){return R(b,this)};function Ue(a){return(a=I(a))?new Te(a,null):null}function ye(a){return Ta(a)}function ze(a){return Va(a)}\nvar Ve=function(){function a(a){var d=null;0&lt;arguments.length&amp;&amp;(d=P(Array.prototype.slice.call(arguments,0),0));return b.call(this,d)}function b(a){return v(rd(a))?Jc.c(function(a,b){return jc.c(v(a)?a:te,b)},a):null}a.A=0;a.o=function(a){a=I(a);return b(a)};a.k=b;return a}();function We(a,b,c){this.meta=a;this.Ka=b;this.t=c;this.l=15077647;this.w=8196}h=We.prototype;h.toString=function(){return Gb(this)};h.C=function(a,b){return C.f(this,b,null)};h.D=function(a,b,c){return Na(this.Ka,b)?b:c};\nh.J=function(){return this.meta};h.ea=function(){return new We(this.meta,this.Ka,this.t)};h.S=function(){return Ca(this.Ka)};h.I=function(){var a=this.t;return null!=a?a:this.t=a=Zb(this)};h.G=function(a,b){return xc(b)&amp;&amp;S(this)===S(b)&amp;&amp;qd(function(a){return function(b){return Hc(a,b)}}(this),b)};h.$a=function(){return new Xe(sb(this.Ka))};h.T=function(){return tc(Ye,this.meta)};h.Mb=function(a,b){return new We(this.meta,Ra(this.Ka,b),null)};h.O=function(){return Ue(this.Ka)};\nh.K=function(a,b){return new We(b,this.Ka,this.t)};h.R=function(a,b){return new We(this.meta,nc.f(this.Ka,b,null),null)};h.call=function(){var a=null,a=function(a,c,d){switch(arguments.length){case 2:return this.C(null,c);case 3:return this.D(null,c,d)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};a.c=function(a,c){return this.C(null,c)};a.f=function(a,c,d){return this.D(null,c,d)};return a}();h.apply=function(a,b){return this.call.apply(this,[this].concat(wa(b)))};\nh.e=function(a){return this.C(null,a)};h.c=function(a,b){return this.D(null,a,b)};var Ye=new We(null,te,0);function Xe(a){this.Ia=a;this.l=259;this.w=136}h=Xe.prototype;h.call=function(){function a(a,b,c){return C.f(this.Ia,b,Ec)===Ec?c:b}function b(a,b){return C.f(this.Ia,b,Ec)===Ec?null:b}var c=null,c=function(c,e,f){switch(arguments.length){case 2:return b.call(this,c,e);case 3:return a.call(this,c,e,f)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};c.c=b;c.f=a;return c}();\nh.apply=function(a,b){return this.call.apply(this,[this].concat(wa(b)))};h.e=function(a){return C.f(this.Ia,a,Ec)===Ec?null:a};h.c=function(a,b){return C.f(this.Ia,a,Ec)===Ec?b:a};h.C=function(a,b){return C.f(this,b,null)};h.D=function(a,b,c){return C.f(this.Ia,b,Ec)===Ec?c:b};h.S=function(){return S(this.Ia)};h.Qa=function(a,b){this.Ia=nd.f(this.Ia,b,null);return this};h.Ra=function(){return new We(null,ub(this.Ia),null)};\nfunction Xc(a){if(a&amp;&amp;(a.w&amp;4096||a.vc))return a.name;if(&quot;string&quot;===typeof a)return a;throw Error(&quot;Doesn&apos;t support name: &quot;+y.e(a));}function Ze(a,b,c,d,e){this.meta=a;this.start=b;this.end=c;this.step=d;this.t=e;this.l=32375006;this.w=8192}h=Ze.prototype;h.toString=function(){return Gb(this)};h.N=function(a,b){if(b&lt;Ca(this))return this.start+b*this.step;if(this.start&gt;this.end&amp;&amp;0===this.step)return this.start;throw Error(&quot;Index out of bounds&quot;);};\nh.da=function(a,b,c){return b&lt;Ca(this)?this.start+b*this.step:this.start&gt;this.end&amp;&amp;0===this.step?this.start:c};h.J=function(){return this.meta};h.ea=function(){return new Ze(this.meta,this.start,this.end,this.step,this.t)};h.fa=function(){return 0&lt;this.step?this.start+this.step&lt;this.end?new Ze(this.meta,this.start+this.step,this.end,this.step,null):null:this.start+this.step&gt;this.end?new Ze(this.meta,this.start+this.step,this.end,this.step,null):null};\nh.S=function(){return sa(lb(this))?0:Math.ceil.e?Math.ceil.e((this.end-this.start)/this.step):Math.ceil.call(null,(this.end-this.start)/this.step)};h.I=function(){var a=this.t;return null!=a?a:this.t=a=Yb(this)};h.G=function(a,b){return gc(this,b)};h.T=function(){return tc(M,this.meta)};h.$=function(a,b){return cc.c(this,b)};h.aa=function(a,b,c){return cc.f(this,b,c)};h.X=function(){return null==lb(this)?null:this.start};\nh.ca=function(){return null!=lb(this)?new Ze(this.meta,this.start+this.step,this.end,this.step,null):M};h.O=function(){return 0&lt;this.step?this.start&lt;this.end?this:null:this.start&gt;this.end?this:null};h.K=function(a,b){return new Ze(b,this.start,this.end,this.step,this.t)};h.R=function(a,b){return R(b,this)};\nvar $e=function(){function a(a,b,c){return new Ze(null,a,b,c,null)}function b(a,b){return e.f(a,b,1)}function c(a){return e.f(0,a,1)}function d(){return e.f(0,Number.MAX_VALUE,1)}var e=null,e=function(e,g,k){switch(arguments.length){case 0:return d.call(this);case 1:return c.call(this,e);case 2:return b.call(this,e,g);case 3:return a.call(this,e,g,k)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};e.v=d;e.e=c;e.c=b;e.f=a;return e}();\nfunction af(a,b){if(&quot;string&quot;===typeof b){var c=a.exec(b);return E.c(K(c),b)?1===S(c)?K(c):ce(c):null}throw new TypeError(&quot;re-matches must match against a string.&quot;);}function bf(a){var b;b=/^(?:\\(\\?([idmsux]*)\\))?(.*)/;if(&quot;string&quot;===typeof a)a=b.exec(a),b=null==a?null:1===S(a)?K(a):ce(a);else throw new TypeError(&quot;re-find must match against a string.&quot;);T.f(b,0,null);a=T.f(b,1,null);b=T.f(b,2,null);return new RegExp(b,a)}\nfunction cf(a,b,c,d,e,f,g){var k=ha;try{ha=null==ha?null:ha-1;if(null!=ha&amp;&amp;0&gt;ha)return D(a,&quot;#&quot;);D(a,c);I(g)&amp;&amp;(b.f?b.f(K(g),a,f):b.call(null,K(g),a,f));for(var l=N(g),m=pa.e(f)-1;;)if(!l||null!=m&amp;&amp;0===m){I(l)&amp;&amp;0===m&amp;&amp;(D(a,d),D(a,&quot;...&quot;));break}else{D(a,d);b.f?b.f(K(l),a,f):b.call(null,K(l),a,f);var n=N(l);c=m-1;l=n;m=c}return D(a,e)}finally{ha=k}}\nvar df=function(){function a(a,d){var e=null;1&lt;arguments.length&amp;&amp;(e=P(Array.prototype.slice.call(arguments,1),0));return b.call(this,a,e)}function b(a,b){for(var e=I(b),f=null,g=0,k=0;;)if(k&lt;g){var l=f.N(null,k);D(a,l);k+=1}else if(e=I(e))f=e,Bc(f)?(e=zb(f),g=Ab(f),f=e,l=S(e),e=g,g=l):(l=K(f),D(a,l),e=N(f),f=null,g=0),k=0;else return null}a.A=1;a.o=function(a){var d=K(a);a=L(a);return b(d,a)};a.k=b;return a}(),ef={&apos;&quot;&apos;:&apos;\\\\&quot;&apos;,&quot;\\\\&quot;:&quot;\\\\\\\\&quot;,&quot;\\b&quot;:&quot;\\\\b&quot;,&quot;\\f&quot;:&quot;\\\\f&quot;,&quot;\\n&quot;:&quot;\\\\n&quot;,&quot;\\r&quot;:&quot;\\\\r&quot;,&quot;\\t&quot;:&quot;\\\\t&quot;};\nfunction ff(a){return&apos;&quot;&apos;+y.e(a.replace(RegExp(&apos;[\\\\\\\\&quot;\\b\\f\\n\\r\\t]&apos;,&quot;g&quot;),function(a){return ef[a]}))+&apos;&quot;&apos;}\nvar jf=function gf(b,c,d){if(null==b)return D(c,&quot;nil&quot;);if(void 0===b)return D(c,&quot;#\\x3cundefined\\x3e&quot;);v(function(){var c=U.c(d,na);return v(c)?(c=b?b.l&amp;131072||b.uc?!0:b.l?!1:w(bb,b):w(bb,b))?uc(b):c:c}())&amp;&amp;(D(c,&quot;^&quot;),gf(uc(b),c,d),D(c,&quot; &quot;));if(null==b)return D(c,&quot;nil&quot;);if(b.eb)return b.pb(b,c,d);if(b&amp;&amp;(b.l&amp;2147483648||b.V))return b.H(null,c,d);if(ta(b)===Boolean||&quot;number&quot;===typeof b)return D(c,&quot;&quot;+y.e(b));if(null!=b&amp;&amp;b.constructor===Object)return D(c,&quot;#js &quot;),hf.n?hf.n(zd.c(function(c){return new Xd(null,\n2,5,be,[Yc.e(c),b[c]],null)},Cc(b)),gf,c,d):hf.call(null,zd.c(function(c){return new Xd(null,2,5,be,[Yc.e(c),b[c]],null)},Cc(b)),gf,c,d);if(b instanceof Array)return cf(c,gf,&quot;#js [&quot;,&quot; &quot;,&quot;]&quot;,d,b);if(&quot;string&quot;==typeof b)return v(la.e(d))?D(c,ff(b)):D(c,b);if(pc(b))return df.k(c,P([&quot;#\\x3c&quot;,&quot;&quot;+y.e(b),&quot;\\x3e&quot;],0));if(b instanceof Date){var e=function(b,c){for(var d=&quot;&quot;+y.e(b);;)if(S(d)&lt;c)d=&quot;0&quot;+y.e(d);else return d};return df.k(c,P([&apos;#inst &quot;&apos;,&quot;&quot;+y.e(b.getUTCFullYear()),&quot;-&quot;,e(b.getUTCMonth()+1,2),&quot;-&quot;,e(b.getUTCDate(),\n2),&quot;T&quot;,e(b.getUTCHours(),2),&quot;:&quot;,e(b.getUTCMinutes(),2),&quot;:&quot;,e(b.getUTCSeconds(),2),&quot;.&quot;,e(b.getUTCMilliseconds(),3),&quot;-&quot;,&apos;00:00&quot;&apos;],0))}return b instanceof RegExp?df.k(c,P([&apos;#&quot;&apos;,b.source,&apos;&quot;&apos;],0)):(b?b.l&amp;2147483648||b.V||(b.l?0:w(nb,b)):w(nb,b))?ob(b,c,d):df.k(c,P([&quot;#\\x3c&quot;,&quot;&quot;+y.e(b),&quot;\\x3e&quot;],0))};\nfunction kf(a,b){var c=new ga;a:{var d=new Fb(c);jf(K(a),d,b);for(var e=I(N(a)),f=null,g=0,k=0;;)if(k&lt;g){var l=f.N(null,k);D(d,&quot; &quot;);jf(l,d,b);k+=1}else if(e=I(e))f=e,Bc(f)?(e=zb(f),g=Ab(f),f=e,l=S(e),e=g,g=l):(l=K(f),D(d,&quot; &quot;),jf(l,d,b),e=N(f),f=null,g=0),k=0;else break a}return c}\nvar xd=function(){function a(a){var d=null;0&lt;arguments.length&amp;&amp;(d=P(Array.prototype.slice.call(arguments,0),0));return b.call(this,d)}function b(a){var b=ja();return wc(a)?&quot;&quot;:&quot;&quot;+y.e(kf(a,b))}a.A=0;a.o=function(a){a=I(a);return b(a)};a.k=b;return a}();function hf(a,b,c,d){return cf(c,function(a,c,d){b.f?b.f(Ta(a),c,d):b.call(null,Ta(a),c,d);D(c,&quot; &quot;);return b.f?b.f(Va(a),c,d):b.call(null,Va(a),c,d)},&quot;{&quot;,&quot;, &quot;,&quot;}&quot;,d,I(a))}Vb.prototype.V=!0;Vb.prototype.H=function(a,b,c){return cf(b,jf,&quot;(&quot;,&quot; &quot;,&quot;)&quot;,c,this)};\nZc.prototype.V=!0;Zc.prototype.H=function(a,b,c){return cf(b,jf,&quot;(&quot;,&quot; &quot;,&quot;)&quot;,c,this)};Oe.prototype.V=!0;Oe.prototype.H=function(a,b,c){return cf(b,jf,&quot;(&quot;,&quot; &quot;,&quot;)&quot;,c,this)};re.prototype.V=!0;re.prototype.H=function(a,b,c){return cf(b,jf,&quot;(&quot;,&quot; &quot;,&quot;)&quot;,c,this)};de.prototype.V=!0;de.prototype.H=function(a,b,c){return cf(b,jf,&quot;(&quot;,&quot; &quot;,&quot;)&quot;,c,this)};Vc.prototype.V=!0;Vc.prototype.H=function(a,b,c){return cf(b,jf,&quot;(&quot;,&quot; &quot;,&quot;)&quot;,c,this)};Qe.prototype.V=!0;Qe.prototype.H=function(a,b,c){return hf(this,jf,b,c)};\nPe.prototype.V=!0;Pe.prototype.H=function(a,b,c){return cf(b,jf,&quot;(&quot;,&quot; &quot;,&quot;)&quot;,c,this)};fe.prototype.V=!0;fe.prototype.H=function(a,b,c){return cf(b,jf,&quot;[&quot;,&quot; &quot;,&quot;]&quot;,c,this)};We.prototype.V=!0;We.prototype.H=function(a,b,c){return cf(b,jf,&quot;#{&quot;,&quot; &quot;,&quot;}&quot;,c,this)};ed.prototype.V=!0;ed.prototype.H=function(a,b,c){return cf(b,jf,&quot;(&quot;,&quot; &quot;,&quot;)&quot;,c,this)};td.prototype.V=!0;td.prototype.H=function(a,b,c){D(b,&quot;#\\x3cAtom: &quot;);jf(this.state,b,c);return D(b,&quot;\\x3e&quot;)};Xd.prototype.V=!0;\nXd.prototype.H=function(a,b,c){return cf(b,jf,&quot;[&quot;,&quot; &quot;,&quot;]&quot;,c,this)};ke.prototype.V=!0;ke.prototype.H=function(a,b,c){return cf(b,jf,&quot;(&quot;,&quot; &quot;,&quot;)&quot;,c,this)};Tc.prototype.V=!0;Tc.prototype.H=function(a,b){return D(b,&quot;()&quot;)};le.prototype.V=!0;le.prototype.H=function(a,b,c){return cf(b,jf,&quot;#queue [&quot;,&quot; &quot;,&quot;]&quot;,c,I(this))};s.prototype.V=!0;s.prototype.H=function(a,b,c){return hf(this,jf,b,c)};Ze.prototype.V=!0;Ze.prototype.H=function(a,b,c){return cf(b,jf,&quot;(&quot;,&quot; &quot;,&quot;)&quot;,c,this)};Te.prototype.V=!0;\nTe.prototype.H=function(a,b,c){return cf(b,jf,&quot;(&quot;,&quot; &quot;,&quot;)&quot;,c,this)};Sc.prototype.V=!0;Sc.prototype.H=function(a,b,c){return cf(b,jf,&quot;(&quot;,&quot; &quot;,&quot;)&quot;,c,this)};Xd.prototype.jb=!0;Xd.prototype.kb=function(a,b){return Ic.c(this,b)};fe.prototype.jb=!0;fe.prototype.kb=function(a,b){return Ic.c(this,b)};W.prototype.jb=!0;W.prototype.kb=function(a,b){return Sb(this,b)};F.prototype.jb=!0;F.prototype.kb=function(a,b){return Sb(this,b)};function lf(a,b,c){qb(a,b,c)}\nvar mf=null,nf=function(){function a(a){null==mf&amp;&amp;(mf=X.e?X.e(0):X.call(null,0));return Ub.e(&quot;&quot;+y.e(a)+y.e(yd.c(mf,$b)))}function b(){return c.e(&quot;G__&quot;)}var c=null,c=function(c){switch(arguments.length){case 0:return b.call(this);case 1:return a.call(this,c)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};c.v=b;c.e=a;return c}(),of={};function pf(a){if(a?a.qc:a)return a.qc(a);var b;b=pf[q(null==a?null:a)];if(!b&amp;&amp;(b=pf._,!b))throw x(&quot;IEncodeJS.-clj-\\x3ejs&quot;,a);return b.call(null,a)}\nfunction qf(a){return(a?v(v(null)?null:a.pc)||(a.Y?0:w(of,a)):w(of,a))?pf(a):&quot;string&quot;===typeof a||&quot;number&quot;===typeof a||a instanceof W||a instanceof F?rf.e?rf.e(a):rf.call(null,a):xd.k(P([a],0))}\nvar rf=function sf(b){if(null==b)return null;if(b?v(v(null)?null:b.pc)||(b.Y?0:w(of,b)):w(of,b))return pf(b);if(b instanceof W)return Xc(b);if(b instanceof F)return&quot;&quot;+y.e(b);if(zc(b)){var c={};b=I(b);for(var d=null,e=0,f=0;;)if(f&lt;e){var g=d.N(null,f),k=T.f(g,0,null),g=T.f(g,1,null);c[qf(k)]=sf(g);f+=1}else if(b=I(b))Bc(b)?(e=zb(b),b=Ab(b),d=e,e=S(e)):(e=K(b),d=T.f(e,0,null),e=T.f(e,1,null),c[qf(d)]=sf(e),b=N(b),d=null,e=0),f=0;else break;return c}if(null==b?0:b?b.l&amp;8||b.hd||(b.l?0:w(Ea,b)):w(Ea,b)){c=\n[];b=I(zd.c(sf,b));d=null;for(f=e=0;;)if(f&lt;e)k=d.N(null,f),c.push(k),f+=1;else if(b=I(b))d=b,Bc(d)?(b=zb(d),f=Ab(d),d=b,e=S(b),b=f):(b=K(d),c.push(b),b=N(d),d=null,e=0),f=0;else break;return c}return b};function tf(a){this.ub=a;this.w=0;this.l=2153775104}tf.prototype.I=function(){for(var a=xd.k(P([this],0)),b=0,c=0;c&lt;a.length;++c)b=31*b+a.charCodeAt(c),b%=4294967296;return b};tf.prototype.H=function(a,b){return D(b,&apos;#uuid &quot;&apos;+y.e(this.ub)+&apos;&quot;&apos;)};\ntf.prototype.G=function(a,b){return b instanceof tf&amp;&amp;this.ub===b.ub};tf.prototype.toString=function(){return this.ub};var uf=new W(null,&quot;old-state&quot;,&quot;old-state&quot;,1039580704),vf=new W(null,&quot;path&quot;,&quot;path&quot;,-188191168),wf=new W(null,&quot;open&quot;,&quot;open&quot;,-1763596448),xf=new W(null,&quot;remote&quot;,&quot;remote&quot;,-1593576576),yf=new W(null,&quot;new-value&quot;,&quot;new-value&quot;,1087038368),zf=new W(null,&quot;descriptor&quot;,&quot;descriptor&quot;,76122018),Af=new W(null,&quot;componentDidUpdate&quot;,&quot;componentDidUpdate&quot;,-1983477981),Bf=new W(null,&quot;fn&quot;,&quot;fn&quot;,-1175266204),Cf=new W(null,&quot;new-state&quot;,&quot;new-state&quot;,-490349212),Df=new W(null,&quot;instrument&quot;,&quot;instrument&quot;,-960698844),na=new W(null,\n&quot;meta&quot;,&quot;meta&quot;,1499536964),Ef=new W(null,&quot;react-key&quot;,&quot;react-key&quot;,1337881348),Ff=new W(&quot;om.core&quot;,&quot;id&quot;,&quot;om.core/id&quot;,299074693),oa=new W(null,&quot;dup&quot;,&quot;dup&quot;,556298533),Gf=new W(null,&quot;key&quot;,&quot;key&quot;,-1516042587),vd=new W(null,&quot;validator&quot;,&quot;validator&quot;,-1966190681),Hf=new W(null,&quot;finally-block&quot;,&quot;finally-block&quot;,832982472),If=new W(null,&quot;value&quot;,&quot;value&quot;,305978217),Jf=new W(null,&quot;width&quot;,&quot;width&quot;,-384071477),Kf=new W(null,&quot;old-value&quot;,&quot;old-value&quot;,862546795),Lf=new W(&quot;om.core&quot;,&quot;pass&quot;,&quot;om.core/pass&quot;,-1453289268),Mf=new W(null,\n&quot;recur&quot;,&quot;recur&quot;,-437573268),Nf=new W(null,&quot;init-state&quot;,&quot;init-state&quot;,1450863212),Of=new W(null,&quot;catch-block&quot;,&quot;catch-block&quot;,1175212748),Pf=new W(null,&quot;state&quot;,&quot;state&quot;,-1988618099),ka=new W(null,&quot;flush-on-newline&quot;,&quot;flush-on-newline&quot;,-151457939),Qf=new W(null,&quot;env&quot;,&quot;env&quot;,-1815813235),Rf=new W(null,&quot;componentWillUnmount&quot;,&quot;componentWillUnmount&quot;,1573788814),Sf=new W(null,&quot;componentWillReceiveProps&quot;,&quot;componentWillReceiveProps&quot;,559988974),Tf=new W(null,&quot;close&quot;,&quot;close&quot;,1835149582),Uf=new W(null,&quot;shouldComponentUpdate&quot;,\n&quot;shouldComponentUpdate&quot;,1795750960),Vf=new W(null,&quot;style&quot;,&quot;style&quot;,-496642736),la=new W(null,&quot;readably&quot;,&quot;readably&quot;,1129599760),Wf=new W(null,&quot;render&quot;,&quot;render&quot;,-1408033454),Xf=new W(null,&quot;event&quot;,&quot;event&quot;,301435442),Yf=new W(null,&quot;out&quot;,&quot;out&quot;,-910545517),Zf=new W(null,&quot;status&quot;,&quot;status&quot;,-1997798413),pa=new W(null,&quot;print-length&quot;,&quot;print-length&quot;,1931866356),$f=new W(null,&quot;max&quot;,&quot;max&quot;,61366548),ag=new W(null,&quot;componentWillUpdate&quot;,&quot;componentWillUpdate&quot;,657390932),bg=new W(null,&quot;id&quot;,&quot;id&quot;,-1388402092),cg=new W(null,\n&quot;getInitialState&quot;,&quot;getInitialState&quot;,1541760916),dg=new W(null,&quot;catch-exception&quot;,&quot;catch-exception&quot;,-1997306795),eg=new W(null,&quot;opts&quot;,&quot;opts&quot;,155075701),fg=new W(null,&quot;prev&quot;,&quot;prev&quot;,-1597069226),gg=new W(null,&quot;continue-block&quot;,&quot;continue-block&quot;,-1852047850),hg=new W(&quot;om.core&quot;,&quot;index&quot;,&quot;om.core/index&quot;,-1724175434),ig=new W(null,&quot;shared&quot;,&quot;shared&quot;,-384145993),jg=new W(null,&quot;componentDidMount&quot;,&quot;componentDidMount&quot;,955710936),kg=new W(null,&quot;error&quot;,&quot;error&quot;,-978969032),lg=new W(null,&quot;origin&quot;,&quot;origin&quot;,1037372088),\nmg=new W(null,&quot;tag&quot;,&quot;tag&quot;,-1290361223),og=new W(null,&quot;target&quot;,&quot;target&quot;,253001721),pg=new W(null,&quot;getDisplayName&quot;,&quot;getDisplayName&quot;,1324429466),qg=new W(null,&quot;local&quot;,&quot;local&quot;,-1497766724),rg=new W(null,&quot;log&quot;,&quot;log&quot;,-1595516004),sg=new W(null,&quot;componentWillMount&quot;,&quot;componentWillMount&quot;,-285327619),tg=new W(&quot;om.core&quot;,&quot;defer&quot;,&quot;om.core/defer&quot;,-1038866178),ug=new W(null,&quot;tx-listen&quot;,&quot;tx-listen&quot;,119130367),vg=new W(null,&quot;in&quot;,&quot;in&quot;,-1531184865);var wg;function xg(a,b,c){if(a?a.Bb:a)return a.Bb(0,b,c);var d;d=xg[q(null==a?null:a)];if(!d&amp;&amp;(d=xg._,!d))throw x(&quot;WritePort.put!&quot;,a);return d.call(null,a,b,c)}function yg(a){if(a?a.ob:a)return a.ob();var b;b=yg[q(null==a?null:a)];if(!b&amp;&amp;(b=yg._,!b))throw x(&quot;Channel.close!&quot;,a);return b.call(null,a)}function zg(a){if(a?a.Dc:a)return a.closed;var b;b=zg[q(null==a?null:a)];if(!b&amp;&amp;(b=zg._,!b))throw x(&quot;Channel.closed?&quot;,a);return b.call(null,a)}\nfunction Ag(a){if(a?a.Tb:a)return!0;var b;b=Ag[q(null==a?null:a)];if(!b&amp;&amp;(b=Ag._,!b))throw x(&quot;Handler.active?&quot;,a);return b.call(null,a)}function Bg(a){if(a?a.nb:a)return a.nb(a);var b;b=Bg[q(null==a?null:a)];if(!b&amp;&amp;(b=Bg._,!b))throw x(&quot;Buffer.full?&quot;,a);return b.call(null,a)};function Cg(a,b,c,d,e){for(var f=0;;)if(f&lt;e)c[d+f]=a[b+f],f+=1;else break}function Dg(a,b,c,d){this.head=a;this.B=b;this.length=c;this.h=d}Dg.prototype.pop=function(){if(0===this.length)return null;var a=this.h[this.B];this.h[this.B]=null;this.B=(this.B+1)%this.h.length;this.length-=1;return a};Dg.prototype.unshift=function(a){this.h[this.head]=a;this.head=(this.head+1)%this.h.length;this.length+=1;return null};function Eg(a,b){a.length+1===a.h.length&amp;&amp;a.resize();a.unshift(b)}\nDg.prototype.resize=function(){var a=Array(2*this.h.length);return this.B&lt;this.head?(Cg(this.h,this.B,a,0,this.length),this.B=0,this.head=this.length,this.h=a):this.B&gt;this.head?(Cg(this.h,this.B,a,0,this.h.length-this.B),Cg(this.h,0,a,this.h.length-this.B,this.head),this.B=0,this.head=this.length,this.h=a):this.B===this.head?(this.head=this.B=0,this.h=a):null};function Fg(a,b){for(var c=a.length,d=0;;)if(d&lt;c){var e=a.pop();(b.e?b.e(e):b.call(null,e))&amp;&amp;a.unshift(e);d+=1}else break}\nfunction Gg(a){if(!(0&lt;a))throw Error(&quot;Assert failed: Can&apos;t create a ring buffer of size 0\\n&quot;+y.e(xd.k(P([Uc(new F(null,&quot;\\x3e&quot;,&quot;\\x3e&quot;,1085014381,null),new F(null,&quot;n&quot;,&quot;n&quot;,-2092305744,null),0)],0))));return new Dg(0,0,0,Array(a))}function Hg(a,b){this.U=a;this.Fb=b;this.w=0;this.l=2}Hg.prototype.S=function(){return this.U.length};Hg.prototype.nb=function(){return this.U.length===this.Fb};Hg.prototype.Sb=function(){return this.U.pop()};\nHg.prototype.Ab=function(a,b){if(!sa(Bg(this)))throw Error(&quot;Assert failed: Can&apos;t add to a full buffer\\n&quot;+y.e(xd.k(P([Uc(new F(null,&quot;not&quot;,&quot;not&quot;,1044554643,null),Uc(new F(&quot;impl&quot;,&quot;full?&quot;,&quot;impl/full?&quot;,-97582774,null),new F(null,&quot;this&quot;,&quot;this&quot;,1028897902,null)))],0))));return this.U.unshift(b)};function Ig(a,b){this.U=a;this.Fb=b;this.w=0;this.l=2}Ig.prototype.S=function(){return this.U.length};Ig.prototype.nb=function(){return!1};Ig.prototype.Sb=function(){return this.U.pop()};\nIg.prototype.Ab=function(a,b){return this.U.length===this.Fb?null:this.U.unshift(b)};var Jg=null,Kg=Gg(32),Lg=!1,Mg=!1;function Ng(){Lg=!0;Mg=!1;for(var a=0;;){var b=Kg.pop();if(null!=b&amp;&amp;(b.v?b.v():b.call(null),1024&gt;a)){a+=1;continue}break}Lg=!1;return 0&lt;Kg.length?Og.v?Og.v():Og.call(null):null}&quot;undefined&quot;!==typeof MessageChannel&amp;&amp;(Jg=new MessageChannel,Jg.port1.onmessage=function(){return Ng()});\nfunction Og(){var a=Mg;if(v(a?Lg:a))return null;Mg=!0;return&quot;undefined&quot;!==typeof MessageChannel?Jg.port2.postMessage(0):&quot;undefined&quot;!==typeof setImmediate?setImmediate(Ng):setTimeout(Ng,0)}function Pg(a){Eg(Kg,a);Og()};var Qg,Sg=function Rg(b){&quot;undefined&quot;===typeof Qg&amp;&amp;(Qg=function(b,d,e){this.W=b;this.lc=d;this.Jc=e;this.w=0;this.l=425984},Qg.eb=!0,Qg.cb=&quot;cljs.core.async.impl.channels/t26794&quot;,Qg.pb=function(b,d){return D(d,&quot;cljs.core.async.impl.channels/t26794&quot;)},Qg.prototype.Pa=function(){return this.W},Qg.prototype.J=function(){return this.Jc},Qg.prototype.K=function(b,d){return new Qg(this.W,this.lc,d)});return new Qg(b,Rg,null)};function Tg(a,b){this.Db=a;this.W=b}function Ug(a){return Ag(a.Db)}\nfunction Vg(a,b,c,d,e,f){this.ib=a;this.rb=b;this.hb=c;this.qb=d;this.U=e;this.closed=f}Vg.prototype.Dc=function(){return this.closed};Vg.prototype.ob=function(){if(!this.closed)for(this.closed=!0;;){var a=this.ib.pop();if(null!=a)Pg(function(a){return function(){return a.e?a.e(null):a.call(null,null)}}(a.ha,a,this));else break}return null};\nVg.prototype.Ec=function(a){if(null!=this.U&amp;&amp;0&lt;S(this.U)){for(var b=a.ha,c=Sg(this.U.Sb(null));;){var d=this.hb.pop();if(null!=d){var e=d.Db,f=d.W;Pg(function(a){return function(){return a.e?a.e(!0):a.call(null,!0)}}(e.ha,a.ha,e,f,d,b,c,this));this.U.Ab(null,f)}break}return c}for(;;){c=this.hb.pop();if(null!=c)return d=c.Db,e=c.W,f=d.ha,b=a.ha,Pg(function(a){return function(){return a.e?a.e(!0):a.call(null,!0)}}(f,b,d,e,c,this)),Sg(e);if(this.closed)return b=a.ha,Sg(null);64&lt;this.rb?(this.rb=0,Fg(this.ib,\nAg)):this.rb+=1;if(!(1024&gt;this.ib.length))throw Error(&quot;Assert failed: &quot;+y.e(&quot;No more than &quot;+y.e(1024)+&quot; pending takes are allowed on a single channel.&quot;)+&quot;\\n&quot;+y.e(xd.k(P([Uc(new F(null,&quot;\\x3c&quot;,&quot;\\x3c&quot;,993667236,null),Uc(new F(null,&quot;.-length&quot;,&quot;.-length&quot;,-280799999,null),new F(null,&quot;takes&quot;,&quot;takes&quot;,298247964,null)),new F(&quot;impl&quot;,&quot;MAX-QUEUE-SIZE&quot;,&quot;impl/MAX-QUEUE-SIZE&quot;,1508600732,null))],0))));Eg(this.ib,a);return null}};\nVg.prototype.Bb=function(a,b,c){if(null==b)throw Error(&quot;Assert failed: Can&apos;t put nil in on a channel\\n&quot;+y.e(xd.k(P([Uc(new F(null,&quot;not&quot;,&quot;not&quot;,1044554643,null),Uc(new F(null,&quot;nil?&quot;,&quot;nil?&quot;,1612038930,null),new F(null,&quot;val&quot;,&quot;val&quot;,1769233139,null)))],0))));if(a=this.closed)return Sg(!a);for(;;){var d=this.ib.pop();if(null!=d)c=c.ha,Pg(function(a){return function(){return a.e?a.e(b):a.call(null,b)}}(d.ha,c,d,a,this));else{if(null==this.U||this.U.nb(null)){64&lt;this.qb?(this.qb=0,Fg(this.hb,Ug)):this.qb+=\n1;if(!(1024&gt;this.hb.length))throw Error(&quot;Assert failed: &quot;+y.e(&quot;No more than &quot;+y.e(1024)+&quot; pending puts are allowed on a single channel. Consider using a windowed buffer.&quot;)+&quot;\\n&quot;+y.e(xd.k(P([Uc(new F(null,&quot;\\x3c&quot;,&quot;\\x3c&quot;,993667236,null),Uc(new F(null,&quot;.-length&quot;,&quot;.-length&quot;,-280799999,null),new F(null,&quot;puts&quot;,&quot;puts&quot;,-1883877054,null)),new F(&quot;impl&quot;,&quot;MAX-QUEUE-SIZE&quot;,&quot;impl/MAX-QUEUE-SIZE&quot;,1508600732,null))],0))));Eg(this.hb,new Tg(c,b));return null}c=c.ha;this.U.Ab(null,b)}return Sg(!0)}};var Wg,Yg=function Xg(b){&quot;undefined&quot;===typeof Wg&amp;&amp;(Wg=function(b,d,e){this.ha=b;this.Cb=d;this.Ic=e;this.w=0;this.l=393216},Wg.eb=!0,Wg.cb=&quot;cljs.core.async.impl.ioc-helpers/t26721&quot;,Wg.pb=function(b,d){return D(d,&quot;cljs.core.async.impl.ioc-helpers/t26721&quot;)},Wg.prototype.Tb=function(){return!0},Wg.prototype.J=function(){return this.Ic},Wg.prototype.K=function(b,d){return new Wg(this.ha,this.Cb,d)});return new Wg(b,Xg,null)};\nfunction Zg(a){try{return a[0].call(null,a)}catch(b){throw b instanceof Object&amp;&amp;a[6].ob(),b;}}function $g(a,b){var c=b.Ec(Yg(function(b){a[2]=b;a[1]=4;return Zg(a)}));return v(c)?(a[2]=Q.e?Q.e(c):Q.call(null,c),a[1]=4,Mf):null}function ah(a,b){var c=a[6];null!=b&amp;&amp;c.Bb(0,b,Yg(function(){return function(){return null}}(c)));c.ob();return c}\nfunction bh(a){for(;;){var b=a[4],c=Of.e(b),d=dg.e(b),e=a[5];if(v(function(){var a=e;return v(a)?sa(b):a}()))throw e;if(v(function(){var a=e;return v(a)?(a=c,v(a)?e instanceof d:a):a}())){a[1]=c;a[2]=e;a[5]=null;a[4]=nc.k(b,Of,null,P([dg,null],0));break}if(v(function(){var a=e;return v(a)?sa(c)&amp;&amp;sa(Hf.e(b)):a}()))a[4]=fg.e(b);else{if(v(function(){var a=e;return v(a)?(a=sa(c))?Hf.e(b):a:a}())){a[1]=Hf.e(b);a[4]=nc.f(b,Hf,null);break}if(v(function(){var a=sa(e);return a?Hf.e(b):a}())){a[1]=Hf.e(b);\na[4]=nc.f(b,Hf,null);break}if(sa(e)&amp;&amp;sa(Hf.e(b))){a[1]=gg.e(b);a[4]=fg.e(b);break}throw Error(&quot;No matching clause&quot;);}}};function ch(a,b,c){this.key=a;this.W=b;this.forward=c;this.w=0;this.l=2155872256}ch.prototype.H=function(a,b,c){return cf(b,jf,&quot;[&quot;,&quot; &quot;,&quot;]&quot;,c,this)};ch.prototype.O=function(){return Ga(Ga(M,this.W),this.key)};\n(function(){function a(a,b,c){c=Array(c+1);for(var g=0;;)if(g&lt;c.length)c[g]=null,g+=1;else break;return new ch(a,b,c)}function b(a){return c.f(null,null,a)}var c=null,c=function(c,e,f){switch(arguments.length){case 1:return b.call(this,c);case 3:return a.call(this,c,e,f)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};c.e=b;c.f=a;return c})().e(0);var eh=function dh(b){&quot;undefined&quot;===typeof wg&amp;&amp;(wg=function(b,d,e){this.ha=b;this.Cb=d;this.Hc=e;this.w=0;this.l=393216},wg.eb=!0,wg.cb=&quot;cljs.core.async/t24045&quot;,wg.pb=function(b,d){return D(d,&quot;cljs.core.async/t24045&quot;)},wg.prototype.Tb=function(){return!0},wg.prototype.J=function(){return this.Hc},wg.prototype.K=function(b,d){return new wg(this.ha,this.Cb,d)});return new wg(b,dh,null)},fh=function(){function a(a){a=E.c(a,0)?null:a;a=&quot;number&quot;===typeof a?new Hg(Gg(a),a):a;return new Vg(Gg(32),0,Gg(32),\n0,a,!1)}function b(){return c.e(null)}var c=null,c=function(c){switch(arguments.length){case 0:return b.call(this);case 1:return a.call(this,c)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};c.v=b;c.e=a;return c}(),gh=eh(function(){return null}),hh=function(){function a(a,b,c,d){a=xg(a,b,eh(c));return v(a)?(b=Q.e?Q.e(a):Q.call(null,a),v(d)?c.e?c.e(b):c.call(null,b):Pg(function(a){return function(){return c.e?c.e(a):c.call(null,a)}}(b,a,a)),b):!0}function b(a,b,c){return d.n(a,b,c,!0)}function c(a,\nb){var c=xg(a,b,gh);return v(c)?Q.e?Q.e(c):Q.call(null,c):!0}var d=null,d=function(d,f,g,k){switch(arguments.length){case 2:return c.call(this,d,f);case 3:return b.call(this,d,f,g);case 4:return a.call(this,d,f,g,k)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};d.c=c;d.f=b;d.n=a;return d}();function ih(a,b){React.createClass({render:function(){return this.transferPropsTo(a.e?a.e({children:this.props.children,onChange:this.onChange,value:this.state.value}):a.call(null,{children:this.props.children,onChange:this.onChange,value:this.state.value}))},componentWillReceiveProps:function(a){return this.setState({value:a.value})},onChange:function(a){var b=this.props.onChange;if(null==b)return null;b.e?b.e(a):b.call(null,a);return this.setState({value:a.target.value})},getInitialState:function(){return{value:this.props.value}},\ngetDisplayName:function(){return b}})}ih(React.DOM.input,&quot;input&quot;);ih(React.DOM.textarea,&quot;textarea&quot;);ih(React.DOM.option,&quot;option&quot;);function jh(){}jh.Fc=function(){return jh.Wb?jh.Wb:jh.Wb=new jh};jh.prototype.Kc=0;var Y=!1,kh=null,lh=null,mh=null,nh={};function oh(a){if(a?a.Oc:a)return a.Oc(a);var b;b=oh[q(null==a?null:a)];if(!b&amp;&amp;(b=oh._,!b))throw x(&quot;IDisplayName.display-name&quot;,a);return b.call(null,a)}var ph={};function qh(a){if(a?a.Pc:a)return a.Pc(a);var b;b=qh[q(null==a?null:a)];if(!b&amp;&amp;(b=qh._,!b))throw x(&quot;IInitState.init-state&quot;,a);return b.call(null,a)}var rh={};\nfunction sh(a,b,c){if(a?a.Uc:a)return a.Uc(a,b,c);var d;d=sh[q(null==a?null:a)];if(!d&amp;&amp;(d=sh._,!d))throw x(&quot;IShouldUpdate.should-update&quot;,a);return d.call(null,a,b,c)}var th={};function uh(a){if(a?a.Xc:a)return a.Xc(a);var b;b=uh[q(null==a?null:a)];if(!b&amp;&amp;(b=uh._,!b))throw x(&quot;IWillMount.will-mount&quot;,a);return b.call(null,a)}var vh={};function wh(a){if(a?a.Mc:a)return a.Mc(a);var b;b=wh[q(null==a?null:a)];if(!b&amp;&amp;(b=wh._,!b))throw x(&quot;IDidMount.did-mount&quot;,a);return b.call(null,a)}var xh={};\nfunction yh(a){if(a?a.Zc:a)return a.Zc(a);var b;b=yh[q(null==a?null:a)];if(!b&amp;&amp;(b=yh._,!b))throw x(&quot;IWillUnmount.will-unmount&quot;,a);return b.call(null,a)}var zh={};function Ah(a,b,c){if(a?a.$c:a)return a.$c(a,b,c);var d;d=Ah[q(null==a?null:a)];if(!d&amp;&amp;(d=Ah._,!d))throw x(&quot;IWillUpdate.will-update&quot;,a);return d.call(null,a,b,c)}var Bh={};function Ch(a,b,c){if(a?a.Nc:a)return a.Nc(a,b,c);var d;d=Ch[q(null==a?null:a)];if(!d&amp;&amp;(d=Ch._,!d))throw x(&quot;IDidUpdate.did-update&quot;,a);return d.call(null,a,b,c)}\nvar Dh={};function Eh(a,b){if(a?a.Yc:a)return a.Yc(a,b);var c;c=Eh[q(null==a?null:a)];if(!c&amp;&amp;(c=Eh._,!c))throw x(&quot;IWillReceiveProps.will-receive-props&quot;,a);return c.call(null,a,b)}var Fh={};function Gh(a){if(a?a.ec:a)return a.ec();var b;b=Gh[q(null==a?null:a)];if(!b&amp;&amp;(b=Gh._,!b))throw x(&quot;IRender.render&quot;,a);return b.call(null,a)}var Hh={};function Ih(a,b){if(a?a.Tc:a)return a.Tc(a,b);var c;c=Ih[q(null==a?null:a)];if(!c&amp;&amp;(c=Ih._,!c))throw x(&quot;IRenderState.render-state&quot;,a);return c.call(null,a,b)}\nvar Jh={};function Kh(a,b,c,d,e){if(a?a.Rc:a)return a.Rc(a,b,c,d,e);var f;f=Kh[q(null==a?null:a)];if(!f&amp;&amp;(f=Kh._,!f))throw x(&quot;IOmSwap.-om-swap!&quot;,a);return f.call(null,a,b,c,d,e)}\nvar Lh=function(){function a(a,b){if(a?a.$b:a)return a.$b(a,b);var c;c=Lh[q(null==a?null:a)];if(!c&amp;&amp;(c=Lh._,!c))throw x(&quot;IGetState.-get-state&quot;,a);return c.call(null,a,b)}function b(a){if(a?a.Zb:a)return a.Zb(a);var b;b=Lh[q(null==a?null:a)];if(!b&amp;&amp;(b=Lh._,!b))throw x(&quot;IGetState.-get-state&quot;,a);return b.call(null,a)}var c=null,c=function(c,e){switch(arguments.length){case 1:return b.call(this,c);case 2:return a.call(this,c,e)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};c.e=b;c.c=a;return c}(),\nMh=function(){function a(a,b){if(a?a.Yb:a)return a.Yb(a,b);var c;c=Mh[q(null==a?null:a)];if(!c&amp;&amp;(c=Mh._,!c))throw x(&quot;IGetRenderState.-get-render-state&quot;,a);return c.call(null,a,b)}function b(a){if(a?a.Xb:a)return a.Xb(a);var b;b=Mh[q(null==a?null:a)];if(!b&amp;&amp;(b=Mh._,!b))throw x(&quot;IGetRenderState.-get-render-state&quot;,a);return b.call(null,a)}var c=null,c=function(c,e){switch(arguments.length){case 1:return b.call(this,c);case 2:return a.call(this,c,e)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};c.e=\nb;c.c=a;return c}();function Nh(a){if(a?a.gc:a)return a.gc(a);var b;b=Nh[q(null==a?null:a)];if(!b&amp;&amp;(b=Nh._,!b))throw x(&quot;IRenderQueue.-get-queue&quot;,a);return b.call(null,a)}function Oh(a,b){if(a?a.hc:a)return a.hc(a,b);var c;c=Oh[q(null==a?null:a)];if(!c&amp;&amp;(c=Oh._,!c))throw x(&quot;IRenderQueue.-queue-render!&quot;,a);return c.call(null,a,b)}function Ph(a){if(a?a.fc:a)return a.fc(a);var b;b=Ph[q(null==a?null:a)];if(!b&amp;&amp;(b=Ph._,!b))throw x(&quot;IRenderQueue.-empty-queue!&quot;,a);return b.call(null,a)}\nfunction Qh(a){if(a?a.kc:a)return a.value;var b;b=Qh[q(null==a?null:a)];if(!b&amp;&amp;(b=Qh._,!b))throw x(&quot;IValue.-value&quot;,a);return b.call(null,a)}Qh._=function(a){return a};var Rh={};function Sh(a){if(a?a.sb:a)return a.sb(a);var b;b=Sh[q(null==a?null:a)];if(!b&amp;&amp;(b=Sh._,!b))throw x(&quot;ICursor.-path&quot;,a);return b.call(null,a)}function Th(a){if(a?a.tb:a)return a.tb(a);var b;b=Th[q(null==a?null:a)];if(!b&amp;&amp;(b=Th._,!b))throw x(&quot;ICursor.-state&quot;,a);return b.call(null,a)}\nvar Uh={},Vh=function(){function a(a,b,c){if(a?a.Wc:a)return a.Wc(a,b,c);var g;g=Vh[q(null==a?null:a)];if(!g&amp;&amp;(g=Vh._,!g))throw x(&quot;IToCursor.-to-cursor&quot;,a);return g.call(null,a,b,c)}function b(a,b){if(a?a.Vc:a)return a.Vc(a,b);var c;c=Vh[q(null==a?null:a)];if(!c&amp;&amp;(c=Vh._,!c))throw x(&quot;IToCursor.-to-cursor&quot;,a);return c.call(null,a,b)}var c=null,c=function(c,e,f){switch(arguments.length){case 2:return b.call(this,c,e);case 3:return a.call(this,c,e,f)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};\nc.c=b;c.f=a;return c}();function Wh(a,b,c,d){if(a?a.Lc:a)return a.Lc(a,b,c,d);var e;e=Wh[q(null==a?null:a)];if(!e&amp;&amp;(e=Wh._,!e))throw x(&quot;ICursorDerive.-derive&quot;,a);return e.call(null,a,b,c,d)}Wh._=function(a,b,c,d){return Xh.f?Xh.f(b,c,d):Xh.call(null,b,c,d)};function Zh(a){return Sh(a)}var $h={};function ai(a,b,c){if(a?a.ac:a)return a.ac(a,b,c);var d;d=ai[q(null==a?null:a)];if(!d&amp;&amp;(d=ai._,!d))throw x(&quot;INotify.-listen!&quot;,a);return d.call(null,a,b,c)}\nfunction bi(a,b){if(a?a.cc:a)return a.cc(a,b);var c;c=bi[q(null==a?null:a)];if(!c&amp;&amp;(c=bi._,!c))throw x(&quot;INotify.-unlisten!&quot;,a);return c.call(null,a,b)}function ci(a,b,c){if(a?a.bc:a)return a.bc(a,b,c);var d;d=ci[q(null==a?null:a)];if(!d&amp;&amp;(d=ci._,!d))throw x(&quot;INotify.-notify!&quot;,a);return d.call(null,a,b,c)}\nfunction di(a,b,c,d,e){var f=Q.e?Q.e(a):Q.call(null,a),g=Fd.c(Zh.e?Zh.e(b):Zh.call(null,b),c);c=(a?v(v(null)?null:a.xd)||(a.Y?0:w(Jh,a)):w(Jh,a))?Kh(a,b,c,d,e):wc(g)?yd.c(a,d):yd.n(a,Kd,g,d);if(E.c(c,tg))return null;a=new s(null,5,[vf,g,Kf,Gd.c(f,g),yf,Gd.c(Q.e?Q.e(a):Q.call(null,a),g),uf,f,Cf,Q.e?Q.e(a):Q.call(null,a)],null);return null!=e?ei.c?ei.c(b,nc.f(a,mg,e)):ei.call(null,b,nc.f(a,mg,e)):ei.c?ei.c(b,a):ei.call(null,b,a)}\nfunction fi(a){return a?v(v(null)?null:a.Gb)?!0:a.Y?!1:w(Rh,a):w(Rh,a)}function gi(a){var b=a.props.children;if(pc(b)){var c=a.props,d;a:{var e=Y;try{Y=!0;d=b.e?b.e(a):b.call(null,a);break a}finally{Y=e}d=void 0}a=c.children=d}else a=b;return a}function hi(a){return a.props.__om_cursor}\nvar ii=function(){function a(a,b){var c=yc(b)?b:new Xd(null,1,5,be,[b],null);return Lh.c(a,c)}function b(a){return Lh.e(a)}var c=null,c=function(c,e){switch(arguments.length){case 1:return b.call(this,c);case 2:return a.call(this,c,e)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};c.e=b;c.c=a;return c}(),ji=function(){function a(a,b){return yc(b)?wc(b)?c.e(a):Gd.c(c.e(a),b):U.c(c.e(a),b)}function b(a){return null==a?null:a.props.__om_shared}var c=null,c=function(c,e){switch(arguments.length){case 1:return b.call(this,\nc);case 2:return a.call(this,c,e)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};c.e=b;c.c=a;return c}();function ki(a){a=a.state;var b=a.__om_pending_state;return v(b)?(a.__om_prev_state=a.__om_state,a.__om_state=b,a.__om_pending_state=null,a):null}\nvar li=function(){function a(a,b){var c=v(b)?b:a.props,g=c.__om_state;if(v(g)){var k=a.state,l=k.__om_pending_state;k.__om_pending_state=Ve.k(P([v(l)?l:k.__om_state,g],0));return c.__om_state=null}return null}function b(a){return c.c(a,null)}var c=null,c=function(c,e){switch(arguments.length){case 1:return b.call(this,c);case 2:return a.call(this,c,e)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};c.e=b;c.c=a;return c}(),mi=mc([Af,Rf,Sf,Uf,Wf,ag,cg,jg,pg,sg],[function(a){var b=gi(this);if(b?v(v(null)?\nnull:b.rd)||(b.Y?0:w(Bh,b)):w(Bh,b)){var c=this.state,d=Y;try{Y=!0;var e=c.__om_prev_state;Ch(b,hi({props:a}),v(e)?e:c.__om_state)}finally{Y=d}}return this.state.__om_prev_state=null},function(){var a=gi(this);if(a?v(v(null)?null:a.Gd)||(a.Y?0:w(xh,a)):w(xh,a)){var b=Y;try{return Y=!0,yh(a)}finally{Y=b}}else return null},function(a){var b=gi(this);if(b?v(v(null)?null:b.Fd)||(b.Y?0:w(Dh,b)):w(Dh,b)){var c=Y;try{return Y=!0,Eh(b,hi({props:a}))}finally{Y=c}}else return null},function(a){var b=Y;try{Y=\n!0;var c=this.props,d=this.state,e=gi(this);li.c(this,a);if(e?v(v(null)?null:e.Cd)||(e.Y?0:w(rh,e)):w(rh,e))return sh(e,hi({props:a}),Lh.e(this));var f=c.__om_cursor,g=a.__om_cursor;return pd.c(Qh(f),Qh(g))?!0:fi(f)&amp;&amp;fi(g)&amp;&amp;pd.c(Sh(f),Sh(g))?!0:null!=d.__om_pending_state?!0:c.__om_index!==a.__om_index?!0:!1}finally{Y=b}},function(){var a=gi(this),b=this.props,c=Y;try{if(Y=!0,a?v(v(null)?null:a.dc)||(a.Y?0:w(Fh,a)):w(Fh,a)){var d=kh,e=mh,f=lh;try{return kh=this,mh=b.__om_app_state,lh=b.__om_instrument,\nGh(a)}finally{lh=f,mh=e,kh=d}}else if(a?v(v(null)?null:a.Sc)||(a.Y?0:w(Hh,a)):w(Hh,a)){d=kh;e=mh;f=lh;try{return kh=this,mh=b.__om_app_state,lh=b.__om_instrument,Ih(a,ii.e(this))}finally{lh=f,mh=e,kh=d}}else return a}finally{Y=c}},function(a){var b=gi(this);if(b?v(v(null)?null:b.Hd)||(b.Y?0:w(zh,b)):w(zh,b)){var c=Y;try{Y=!0,Ah(b,hi({props:a}),Lh.e(this))}finally{Y=c}}return ki(this)},function(){var a=gi(this),b=this.props,c=function(){var a=b.__om_init_state;return v(a)?a:te}(),d=Ff.e(c),c={__om_state:Ve.k(P([(a?\nv(v(null)?null:a.wd)||(a.Y?0:w(ph,a)):w(ph,a))?function(){var b=Y;try{return Y=!0,qh(a)}finally{Y=b}}():null,oc.c(c,Ff)],0)),__om_id:v(d)?d:&quot;:&quot;+(jh.Fc().Kc++).toString(36)};b.__om_init_state=null;return c},function(){var a=gi(this);if(a?v(v(null)?null:a.qd)||(a.Y?0:w(vh,a)):w(vh,a)){var b=Y;try{return Y=!0,wh(a)}finally{Y=b}}else return null},function(){var a=gi(this);if(a?v(v(null)?null:a.sd)||(a.Y?0:w(nh,a)):w(nh,a)){var b=Y;try{return Y=!0,oh(a)}finally{Y=b}}else return null},function(){li.e(this);\nvar a=gi(this);if(a?v(v(null)?null:a.Ed)||(a.Y?0:w(th,a)):w(th,a)){var b=Y;try{Y=!0,uh(a)}finally{Y=b}}return ki(this)}]),ni=function(a){a.vd=!0;a.Zb=function(){return function(){var a=this.state,c=a.__om_pending_state;return v(c)?c:a.__om_state}}(a);a.$b=function(){return function(a,c){return Gd.c(Lh.e(this),c)}}(a);a.ud=!0;a.Xb=function(){return function(){return this.state.__om_state}}(a);a.Yb=function(){return function(a,c){return Gd.c(Mh.e(this),c)}}(a);a.zd=!0;a.Ad=function(){return function(a,\nc,d){a=Y;try{Y=!0;var e=this.props.__om_app_state;this.state.__om_pending_state=c;c=null!=e;return v(c?d:c)?Oh(e,this):null}finally{Y=a}}}(a);a.Bd=function(){return function(a,c,d,e){a=Y;try{Y=!0;var f=this.props,g=this.state,k=Lh.e(this),l=f.__om_app_state;g.__om_pending_state=Id(k,c,d);c=null!=l;return v(c?e:c)?Oh(l,this):null}finally{Y=a}}}(a);return a}(rf(mi));function oi(a,b,c){this.value=a;this.state=b;this.path=c;this.l=2162591503;this.w=8192}h=oi.prototype;\nh.C=function(a,b){return C.f(this,b,null)};h.D=function(a,b,c){if(Y)return a=C.f(this.value,b,c),E.c(a,c)?c:Wh(this,a,this.state,jc.c(this.path,b));throw Error(&quot;Cannot manipulate cursor outside of render phase, only om.core/transact!, om.core/update!, and cljs.core/deref operations allowed&quot;);};h.H=function(a,b,c){if(Y)return ob(this.value,b,c);throw Error(&quot;Cannot manipulate cursor outside of render phase, only om.core/transact!, om.core/update!, and cljs.core/deref operations allowed&quot;);};h.Gb=!0;\nh.sb=function(){return this.path};h.tb=function(){return this.state};h.J=function(){if(Y)return uc(this.value);throw Error(&quot;Cannot manipulate cursor outside of render phase, only om.core/transact!, om.core/update!, and cljs.core/deref operations allowed&quot;);};h.ea=function(){return new oi(this.value,this.state,this.path)};\nh.S=function(){if(Y)return Ca(this.value);throw Error(&quot;Cannot manipulate cursor outside of render phase, only om.core/transact!, om.core/update!, and cljs.core/deref operations allowed&quot;);};h.I=function(){if(Y)return Qb(this.value);throw Error(&quot;Cannot manipulate cursor outside of render phase, only om.core/transact!, om.core/update!, and cljs.core/deref operations allowed&quot;);};\nh.G=function(a,b){if(Y)return fi(b)?E.c(this.value,Qh(b)):E.c(this.value,b);throw Error(&quot;Cannot manipulate cursor outside of render phase, only om.core/transact!, om.core/update!, and cljs.core/deref operations allowed&quot;);};h.kc=function(){return this.value};h.T=function(){if(Y)return new oi(kc(this.value),this.state,this.path);throw Error(&quot;Cannot manipulate cursor outside of render phase, only om.core/transact!, om.core/update!, and cljs.core/deref operations allowed&quot;);};\nh.mb=function(a,b){if(Y)return new oi(Ra(this.value,b),this.state,this.path);throw Error(&quot;Cannot manipulate cursor outside of render phase, only om.core/transact!, om.core/update!, and cljs.core/deref operations allowed&quot;);};h.ic=!0;h.jc=function(a,b,c,d){return di(this.state,this,b,c,d)};h.Za=function(a,b){if(Y)return Na(this.value,b);throw Error(&quot;Cannot manipulate cursor outside of render phase, only om.core/transact!, om.core/update!, and cljs.core/deref operations allowed&quot;);};\nh.Oa=function(a,b,c){if(Y)return new oi(Pa(this.value,b,c),this.state,this.path);throw Error(&quot;Cannot manipulate cursor outside of render phase, only om.core/transact!, om.core/update!, and cljs.core/deref operations allowed&quot;);};\nh.O=function(){var a=this;if(Y)return 0&lt;S(a.value)?zd.c(function(b){return function(c){var d=T.f(c,0,null);c=T.f(c,1,null);return new Xd(null,2,5,be,[d,Wh(b,c,a.state,jc.c(a.path,d))],null)}}(this),a.value):null;throw Error(&quot;Cannot manipulate cursor outside of render phase, only om.core/transact!, om.core/update!, and cljs.core/deref operations allowed&quot;);};\nh.K=function(a,b){if(Y)return new oi(tc(this.value,b),this.state,this.path);throw Error(&quot;Cannot manipulate cursor outside of render phase, only om.core/transact!, om.core/update!, and cljs.core/deref operations allowed&quot;);};h.R=function(a,b){if(Y)return new oi(Ga(this.value,b),this.state,this.path);throw Error(&quot;Cannot manipulate cursor outside of render phase, only om.core/transact!, om.core/update!, and cljs.core/deref operations allowed&quot;);};\nh.call=function(){var a=null,a=function(a,c,d){switch(arguments.length){case 2:return this.C(null,c);case 3:return this.D(null,c,d)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};a.c=function(a,c){return this.C(null,c)};a.f=function(a,c,d){return this.D(null,c,d)};return a}();h.apply=function(a,b){return this.call.apply(this,[this].concat(wa(b)))};h.e=function(a){return this.C(null,a)};h.c=function(a,b){return this.D(null,a,b)};\nh.Pa=function(){if(Y)throw Error(&quot;Cannot deref cursor during render phase: &quot;+y.e(this));return Gd.c(Q.e?Q.e(this.state):Q.call(null,this.state),this.path)};function pi(a,b,c){this.value=a;this.state=b;this.path=c;this.l=2179375903;this.w=8192}h=pi.prototype;h.C=function(a,b){if(Y)return z.f(this,b,null);throw Error(&quot;Cannot manipulate cursor outside of render phase, only om.core/transact!, om.core/update!, and cljs.core/deref operations allowed&quot;);};\nh.D=function(a,b,c){if(Y)return z.f(this,b,c);throw Error(&quot;Cannot manipulate cursor outside of render phase, only om.core/transact!, om.core/update!, and cljs.core/deref operations allowed&quot;);};h.N=function(a,b){if(Y)return Wh(this,z.c(this.value,b),this.state,jc.c(this.path,b));throw Error(&quot;Cannot manipulate cursor outside of render phase, only om.core/transact!, om.core/update!, and cljs.core/deref operations allowed&quot;);};\nh.da=function(a,b,c){if(Y)return b&lt;Ca(this.value)?Wh(this,z.c(this.value,b),this.state,jc.c(this.path,b)):c;throw Error(&quot;Cannot manipulate cursor outside of render phase, only om.core/transact!, om.core/update!, and cljs.core/deref operations allowed&quot;);};h.H=function(a,b,c){if(Y)return ob(this.value,b,c);throw Error(&quot;Cannot manipulate cursor outside of render phase, only om.core/transact!, om.core/update!, and cljs.core/deref operations allowed&quot;);};h.Gb=!0;h.sb=function(){return this.path};h.tb=function(){return this.state};\nh.J=function(){if(Y)return uc(this.value);throw Error(&quot;Cannot manipulate cursor outside of render phase, only om.core/transact!, om.core/update!, and cljs.core/deref operations allowed&quot;);};h.ea=function(){return new pi(this.value,this.state,this.path)};h.S=function(){if(Y)return Ca(this.value);throw Error(&quot;Cannot manipulate cursor outside of render phase, only om.core/transact!, om.core/update!, and cljs.core/deref operations allowed&quot;);};\nh.I=function(){if(Y)return Qb(this.value);throw Error(&quot;Cannot manipulate cursor outside of render phase, only om.core/transact!, om.core/update!, and cljs.core/deref operations allowed&quot;);};h.G=function(a,b){if(Y)return fi(b)?E.c(this.value,Qh(b)):E.c(this.value,b);throw Error(&quot;Cannot manipulate cursor outside of render phase, only om.core/transact!, om.core/update!, and cljs.core/deref operations allowed&quot;);};h.kc=function(){return this.value};\nh.T=function(){if(Y)return new pi(kc(this.value),this.state,this.path);throw Error(&quot;Cannot manipulate cursor outside of render phase, only om.core/transact!, om.core/update!, and cljs.core/deref operations allowed&quot;);};h.ic=!0;h.jc=function(a,b,c,d){return di(this.state,this,b,c,d)};h.Za=function(a,b){if(Y)return Na(this.value,b);throw Error(&quot;Cannot manipulate cursor outside of render phase, only om.core/transact!, om.core/update!, and cljs.core/deref operations allowed&quot;);};\nh.Oa=function(a,b,c){if(Y)return Wh(this,Za(this.value,b,c),this.state,this.path);throw Error(&quot;Cannot manipulate cursor outside of render phase, only om.core/transact!, om.core/update!, and cljs.core/deref operations allowed&quot;);};\nh.O=function(){var a=this;if(Y)return 0&lt;S(a.value)?zd.f(function(b){return function(c,d){return Wh(b,c,a.state,jc.c(a.path,d))}}(this),a.value,$e.v()):null;throw Error(&quot;Cannot manipulate cursor outside of render phase, only om.core/transact!, om.core/update!, and cljs.core/deref operations allowed&quot;);};\nh.K=function(a,b){if(Y)return new pi(tc(this.value,b),this.state,this.path);throw Error(&quot;Cannot manipulate cursor outside of render phase, only om.core/transact!, om.core/update!, and cljs.core/deref operations allowed&quot;);};h.R=function(a,b){if(Y)return new pi(Ga(this.value,b),this.state,this.path);throw Error(&quot;Cannot manipulate cursor outside of render phase, only om.core/transact!, om.core/update!, and cljs.core/deref operations allowed&quot;);};\nh.call=function(){var a=null,a=function(a,c,d){switch(arguments.length){case 2:return this.C(null,c);case 3:return this.D(null,c,d)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};a.c=function(a,c){return this.C(null,c)};a.f=function(a,c,d){return this.D(null,c,d)};return a}();h.apply=function(a,b){return this.call.apply(this,[this].concat(wa(b)))};h.e=function(a){return this.C(null,a)};h.c=function(a,b){return this.D(null,a,b)};\nh.Pa=function(){if(Y)throw Error(&quot;Cannot deref cursor during render phase: &quot;+y.e(this));return Gd.c(Q.e?Q.e(this.state):Q.call(null,this.state),this.path)};\nfunction qi(a,b,c){var d=Aa(a);d.rc=!0;d.G=function(){return function(b,c){if(Y)return fi(c)?E.c(a,Qh(c)):E.c(a,c);throw Error(&quot;Cannot manipulate cursor outside of render phase, only om.core/transact!, om.core/update!, and cljs.core/deref operations allowed&quot;);}}(d);d.ic=!0;d.jc=function(){return function(a,c,d,k){return di(b,this,c,d,k)}}(d);d.Gb=!0;d.sb=function(){return function(){return c}}(d);d.tb=function(){return function(){return b}}(d);d.jd=!0;d.Pa=function(){return function(){if(Y)throw Error(&quot;Cannot deref cursor during render phase: &quot;+\ny.e(this));return Gd.c(Q.e?Q.e(b):Q.call(null,b),c)}}(d);return d}\nvar Xh=function(){function a(a,b,c){return fi(a)?a:(a?v(v(null)?null:a.Dd)||(a.Y?0:w(Uh,a)):w(Uh,a))?Vh.f(a,b,c):fc(a)?new pi(a,b,c):zc(a)?new oi(a,b,c):(a?a.w&amp;8192||a.gd||(a.w?0:w(ya,a)):w(ya,a))?qi(a,b,c):a}function b(a,b){return d.f(a,b,ic)}function c(a){return d.f(a,null,ic)}var d=null,d=function(d,f,g){switch(arguments.length){case 1:return c.call(this,d);case 2:return b.call(this,d,f);case 3:return a.call(this,d,f,g)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};d.e=c;d.c=b;d.f=a;return d}();\nfunction ei(a,b){var c=Th(a);return ci(c,b,Xh.c(Q.e?Q.e(c):Q.call(null,c),c))}var ri=!1,si=X.e?X.e(Ye):X.call(null,Ye);function ti(){ri=!1;for(var a=I(Q.e?Q.e(si):Q.call(null,si)),b=null,c=0,d=0;;)if(d&lt;c){var e=b.N(null,d);e.v?e.v():e.call(null);d+=1}else if(a=I(a))b=a,Bc(b)?(a=zb(b),c=Ab(b),b=a,e=S(a),a=c,c=e):(e=K(b),e.v?e.v():e.call(null),a=N(b),b=null,c=0),d=0;else return null}var ui=X.e?X.e(te):X.call(null,te);\nfunction vi(a,b){var c=a?v(v(null)?null:a.dc)?!0:a.Y?!1:w(Fh,a):w(Fh,a);if(!(c?c:a?v(v(null)?null:a.Sc)||(a.Y?0:w(Hh,a)):w(Hh,a)))throw Error(&quot;Assert failed: &quot;+y.e(&quot;Invalid Om component fn, &quot;+y.e(b.name)+&quot; does not return valid instance&quot;)+&quot;\\n&quot;+y.e(xd.k(P([Uc(new F(null,&quot;or&quot;,&quot;or&quot;,1876275696,null),Uc(new F(null,&quot;satisfies?&quot;,&quot;satisfies?&quot;,-433227199,null),new F(null,&quot;IRender&quot;,&quot;IRender&quot;,590822196,null),new F(null,&quot;x&quot;,&quot;x&quot;,-555367584,null)),Uc(new F(null,&quot;satisfies?&quot;,&quot;satisfies?&quot;,-433227199,null),new F(null,\n&quot;IRenderState&quot;,&quot;IRenderState&quot;,-897673898,null),new F(null,&quot;x&quot;,&quot;x&quot;,-555367584,null)))],0))));}\nvar wi=function(){function a(a,b){null==a.om$descriptor&amp;&amp;(a.om$descriptor=React.createClass(v(b)?b:ni));return a.om$descriptor}function b(a){return c.c(a,null)}var c=null,c=function(c,e){switch(arguments.length){case 1:return b.call(this,c);case 2:return a.call(this,c,e)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};c.e=b;c.c=a;return c}(),xi=function(){function a(a,b,c){if(!qd(new We(null,new s(null,10,[zf,null,Bf,null,Df,null,Ef,null,Gf,null,Nf,null,Pf,null,eg,null,hg,null,ig,null],null),null),\nUe(c)))throw Error(&quot;Assert failed: &quot;+y.e(sc.n(y,&quot;build options contains invalid keys, only :key, :react-key, &quot;,&quot;:fn, :init-state, :state, and :opts allowed, given &quot;,Ed(Ue(c))))+&quot;\\n&quot;+y.e(xd.k(P([Uc(new F(null,&quot;valid?&quot;,&quot;valid?&quot;,1428119148,null),new F(null,&quot;m&quot;,&quot;m&quot;,-1021758608,null))],0))));if(null==c){var g=ji.e(kh),k=wi.e(a);return k.e?k.e({children:function(){return function(c){var f=Y;try{Y=!0;var g=a.c?a.c(b,c):a.call(null,b,c);vi(g,a);return g}finally{Y=f}}}(g,k),__om_instrument:lh,__om_app_state:mh,\n__om_shared:g,__om_cursor:b}):k.call(null,{children:function(){return function(c){var f=Y;try{Y=!0;var g=a.c?a.c(b,c):a.call(null,b,c);vi(g,a);return g}finally{Y=f}}}(g,k),__om_instrument:lh,__om_app_state:mh,__om_shared:g,__om_cursor:b})}var l=Fc(c)?sc.c(ud,c):c,m=U.c(l,eg),n=U.c(l,Nf),p=U.c(l,Pf),r=U.c(l,Gf),t=U.c(c,Bf),u=null!=t?function(){var a=hg.e(c);return v(a)?t.c?t.c(b,a):t.call(null,b,a):t.e?t.e(b):t.call(null,b)}():b,A=null!=r?U.c(u,r):U.c(c,Ef),g=function(){var a=ig.e(c);return v(a)?a:\nji.e(kh)}(),k=wi.c(a,zf.e(c));return k.e?k.e({__om_shared:g,__om_index:hg.e(c),__om_cursor:u,__om_app_state:mh,key:A,__om_init_state:n,children:null==m?function(b,c,e,f,g,k,l,m){return function(b){var c=Y;try{Y=!0;var e=a.c?a.c(m,b):a.call(null,m,b);vi(e,a);return e}finally{Y=c}}}(c,l,m,n,p,r,t,u,A,g,k):function(b,c,e,f,g,k,l,m){return function(b){var c=Y;try{Y=!0;var f=a.f?a.f(m,b,e):a.call(null,m,b,e);vi(f,a);return f}finally{Y=c}}}(c,l,m,n,p,r,t,u,A,g,k),__om_instrument:lh,__om_state:p}):k.call(null,\n{__om_shared:g,__om_index:hg.e(c),__om_cursor:u,__om_app_state:mh,key:A,__om_init_state:n,children:null==m?function(b,c,e,f,g,k,l,m){return function(b){var c=Y;try{Y=!0;var e=a.c?a.c(m,b):a.call(null,m,b);vi(e,a);return e}finally{Y=c}}}(c,l,m,n,p,r,t,u,A,g,k):function(b,c,e,f,g,k,l,m){return function(b){var c=Y;try{Y=!0;var f=a.f?a.f(m,b,e):a.call(null,m,b,e);vi(f,a);return f}finally{Y=c}}}(c,l,m,n,p,r,t,u,A,g,k),__om_instrument:lh,__om_state:p})}function b(a,b){return c.f(a,b,null)}var c=null,c=\nfunction(c,e,f){switch(arguments.length){case 2:return b.call(this,c,e);case 3:return a.call(this,c,e,f)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};c.c=b;c.f=a;return c}(),yi=function(){function a(a,b,c){if(null!=lh){var g;a:{var k=Y;try{Y=!0;g=lh.f?lh.f(a,b,c):lh.call(null,a,b,c);break a}finally{Y=k}g=void 0}return E.c(g,Lf)?xi.f(a,b,c):g}return xi.f(a,b,c)}function b(a,b){return c.f(a,b,null)}var c=null,c=function(c,e,f){switch(arguments.length){case 2:return b.call(this,c,e);case 3:return a.call(this,\nc,e,f)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};c.c=b;c.f=a;return c}();\nfunction zi(a,b,c){if(!(a?v(v(null)?null:a.Qc)||(a.Y?0:w($h,a)):w($h,a))){var d=X.e?X.e(te):X.call(null,te),e=X.e?X.e(Ye):X.call(null,Ye);a.yd=!0;a.gc=function(a,b,c){return function(){return Q.e?Q.e(c):Q.call(null,c)}}(a,d,e);a.hc=function(a,b,c){return function(a,b){if(Hc(Q.e?Q.e(c):Q.call(null,c),b))return null;yd.f(c,jc,b);return yd.c(this,sd)}}(a,d,e);a.fc=function(a,b,c){return function(){return yd.c(c,kc)}}(a,d,e);a.Qc=!0;a.ac=function(a,b){return function(a,c,d){null!=d&amp;&amp;yd.n(b,nc,c,d);return this}}(a,\nd,e);a.cc=function(a,b){return function(a,c){yd.f(b,oc,c);return this}}(a,d,e);a.bc=function(a,b){return function(a,c,d){a=I(Q.e?Q.e(b):Q.call(null,b));for(var e=null,f=0,r=0;;)if(r&lt;f){var t=e.N(null,r);T.f(t,0,null);t=T.f(t,1,null);t.c?t.c(c,d):t.call(null,c,d);r+=1}else if(a=I(a))Bc(a)?(f=zb(a),a=Ab(a),e=f,f=S(f)):(e=K(a),T.f(e,0,null),e=T.f(e,1,null),e.c?e.c(c,d):e.call(null,c,d),a=N(a),e=null,f=0),r=0;else break;return this}}(a,d,e)}return ai(a,b,c)}\nfunction Ai(){var a=Bi,b=Ci,c=new s(null,1,[og,document.getElementsByTagName(&quot;body&quot;).item(0)],null),d=Fc(c)?sc.c(ud,c):c,e=U.c(d,Df),f=U.c(d,vf),g=U.c(d,ug),k=U.c(d,og);if(null==k)throw Error(&quot;Assert failed: No target specified to om.core/root\\n&quot;+y.e(xd.k(P([Uc(new F(null,&quot;not&quot;,&quot;not&quot;,1044554643,null),Uc(new F(null,&quot;nil?&quot;,&quot;nil?&quot;,1612038930,null),new F(null,&quot;target&quot;,&quot;target&quot;,1893533248,null)))],0))));var l=Q.e?Q.e(ui):Q.call(null,ui);Hc(l,k)&amp;&amp;U.c(l,k).call(null);var l=nf.v(),b=(b?b.w&amp;16384||b.ed||(b.w?\n0:w(Cb,b)):w(Cb,b))?b:X.e?X.e(b):X.call(null,b),m=zi(b,l,g),n=oc.k(d,og,P([ug,vf],0)),p=function(b,c,d,e,f,g,k,l,m,n,p){return function ca(){yd.f(si,vc,ca);var b=Q.e?Q.e(d):Q.call(null,d),b=null==m?Xh.f(b,d,ic):Xh.f(Gd.c(b,m),d,m),c;a:{var f=lh,g=mh;try{lh=l;mh=d;c=yi.f(a,b,e);break a}finally{mh=g,lh=f}c=void 0}React.renderComponent(c,p);c=Nh(d);if(wc(c))return null;c=I(c);b=null;for(g=f=0;;)if(g&lt;f){var k=b.N(null,g);v(k.isMounted())&amp;&amp;k.forceUpdate();g+=1}else if(c=I(c))b=c,Bc(b)?(c=zb(b),g=Ab(b),\nb=c,f=S(c),c=g):(c=K(b),v(c.isMounted())&amp;&amp;c.forceUpdate(),c=N(b),b=null,f=0),g=0;else break;return Ph(d)}}(l,b,m,n,c,d,d,e,f,g,k);lf(m,l,function(a,b,c,d,e){return function(){Hc(Q.e?Q.e(si):Q.call(null,si),e)||yd.f(si,jc,e);if(v(ri))return null;ri=!0;return&quot;undefined&quot;!==typeof requestAnimationFrame?requestAnimationFrame(ti):setTimeout(ti,16)}}(l,b,m,n,p,c,d,d,e,f,g,k));yd.n(ui,nc,k,function(a,b,c,d,e,f,g,k,l,m,n,p){return function(){rb(c,a);bi(c,a);yd.f(ui,oc,p);return React.unmountComponentAtNode(p)}}(l,\nb,m,n,p,c,d,d,e,f,g,k));return p()};function Z(a){if(a?a.Ub:a)return a.Ub();var b;b=Z[q(null==a?null:a)];if(!b&amp;&amp;(b=Z._,!b))throw x(&quot;PushbackReader.read-char&quot;,a);return b.call(null,a)}function Di(a,b){if(a?a.Vb:a)return a.Vb(0,b);var c;c=Di[q(null==a?null:a)];if(!c&amp;&amp;(c=Di._,!c))throw x(&quot;PushbackReader.unread&quot;,a);return c.call(null,a,b)}function Ei(a,b,c){this.s=a;this.buffer=b;this.Eb=c}Ei.prototype.Ub=function(){return 0===this.buffer.length?(this.Eb+=1,this.s[this.Eb]):this.buffer.pop()};Ei.prototype.Vb=function(a,b){return this.buffer.push(b)};\nfunction Fi(a){var b=!/[^\\t\\n\\r ]/.test(a);return v(b)?b:&quot;,&quot;===a}var $=function(){function a(a,d){var e=null;1&lt;arguments.length&amp;&amp;(e=P(Array.prototype.slice.call(arguments,1),0));return b.call(this,0,e)}function b(a,b){throw Error(sc.c(y,b));}a.A=1;a.o=function(a){K(a);a=L(a);return b(0,a)};a.k=b;return a}();\nfunction Gi(a,b){for(var c=new ga(b),d=Z(a);;){var e;if(!(e=null==d||Fi(d))){e=d;var f=&quot;#&quot;!==e;e=f?(f=&quot;&apos;&quot;!==e)?(f=&quot;:&quot;!==e)?Hi.e?Hi.e(e):Hi.call(null,e):f:f:f}if(e)return Di(a,d),c.toString();c.append(d);d=Z(a)}}function Ii(a){for(;;){var b=Z(a);if(&quot;\\n&quot;===b||&quot;\\r&quot;===b||null==b)return a}}var Ji=bf(&quot;^([-+]?)(?:(0)|([1-9][0-9]*)|0[xX]([0-9A-Fa-f]+)|0([0-7]+)|([1-9][0-9]?)[rR]([0-9A-Za-z]+))(N)?$&quot;),Ki=bf(&quot;^([-+]?[0-9]+)/([0-9]+)$&quot;),Li=bf(&quot;^([-+]?[0-9]+(\\\\.[0-9]*)?([eE][-+]?[0-9]+)?)(M)?$&quot;),Mi=bf(&quot;^[:]?([^0-9/].*/)?([^0-9/][^/]*)$&quot;);\nfunction Ni(a,b){var c=a.exec(b);return null!=c&amp;&amp;c[0]===b?1===c.length?c[0]:c:null}var Oi=bf(&quot;^[0-9A-Fa-f]{2}$&quot;),Pi=bf(&quot;^[0-9A-Fa-f]{4}$&quot;);function Qi(a,b,c,d){return v(af(a,d))?d:$.k(b,P([&quot;Unexpected unicode escape \\\\&quot;,c,d],0))}function Ri(a){return String.fromCharCode(parseInt(a,16))}\nfunction Si(a){var b=Z(a),c=&quot;t&quot;===b?&quot;\\t&quot;:&quot;r&quot;===b?&quot;\\r&quot;:&quot;n&quot;===b?&quot;\\n&quot;:&quot;\\\\&quot;===b?&quot;\\\\&quot;:&apos;&quot;&apos;===b?&apos;&quot;&apos;:&quot;b&quot;===b?&quot;\\b&quot;:&quot;f&quot;===b?&quot;\\f&quot;:null;v(c)?a=c:&quot;x&quot;===b?(c=(new ga(Z(a),Z(a))).toString(),a=Ri(Qi(Oi,a,b,c))):&quot;u&quot;===b?(c=(new ga(Z(a),Z(a),Z(a),Z(a))).toString(),a=Ri(Qi(Pi,a,b,c))):a=/[^0-9]/.test(b)?$.k(a,P([&quot;Unexpected unicode escape \\\\&quot;,b],0)):String.fromCharCode(b);return a}\nfunction Ti(a,b){for(var c=sb(ic);;){var d;a:{d=Fi;for(var e=b,f=Z(e);;)if(v(d.e?d.e(f):d.call(null,f)))f=Z(e);else{d=f;break a}d=void 0}v(d)||$.k(b,P([&quot;EOF while reading&quot;],0));if(a===d)return ub(c);e=Hi.e?Hi.e(d):Hi.call(null,d);v(e)?d=e.c?e.c(b,d):e.call(null,b,d):(Di(b,d),d=Ui.n?Ui.n(b,!0,null,!0):Ui.call(null,b,!0,null));c=d===b?c:md.c(c,d)}}function Vi(a,b){return $.k(a,P([&quot;Reader for &quot;,b,&quot; not implemented yet&quot;],0))}\nfunction Wi(a,b){var c=Z(a),d=Xi.e?Xi.e(c):Xi.call(null,c);if(v(d))return d.c?d.c(a,b):d.call(null,a,b);d=Yi.c?Yi.c(a,c):Yi.call(null,a,c);return v(d)?d:$.k(a,P([&quot;No dispatch macro for &quot;,c],0))}function Zi(a,b){return $.k(a,P([&quot;Unmached delimiter &quot;,b],0))}function $i(a){return sc.c(Uc,Ti(&quot;)&quot;,a))}function aj(a){return Ti(&quot;]&quot;,a)}\nfunction bj(a){var b=Ti(&quot;}&quot;,a),c=S(b);if(&quot;number&quot;!==typeof c||isNaN(c)||Infinity===c||parseFloat(c)!==parseInt(c,10))throw Error(&quot;Argument must be an integer: &quot;+y.e(c));0!==(c&amp;1)&amp;&amp;$.k(a,P([&quot;Map literal must contain an even number of forms&quot;],0));return sc.c(ud,b)}function cj(a){for(var b=new ga,c=Z(a);;){if(null==c)return $.k(a,P([&quot;EOF while reading&quot;],0));if(&quot;\\\\&quot;===c)b.append(Si(a));else{if(&apos;&quot;&apos;===c)return b.toString();b.append(c)}c=Z(a)}}\nfunction dj(a){for(var b=new ga,c=Z(a);;){if(null==c)return $.k(a,P([&quot;EOF while reading&quot;],0));if(&quot;\\\\&quot;===c){b.append(c);var d=Z(a);if(null==d)return $.k(a,P([&quot;EOF while reading&quot;],0));var e=function(){var a=b;a.append(d);return a}(),f=Z(a)}else{if(&apos;&quot;&apos;===c)return b.toString();e=function(){var a=b;a.append(c);return a}();f=Z(a)}b=e;c=f}}\nfunction ej(a,b){var c=Gi(a,b);if(v(-1!=c.indexOf(&quot;/&quot;)))c=Ub.c(Rc.f(c,0,c.indexOf(&quot;/&quot;)),Rc.f(c,c.indexOf(&quot;/&quot;)+1,c.length));else var d=Ub.e(c),c=&quot;nil&quot;===c?null:&quot;true&quot;===c?!0:&quot;false&quot;===c?!1:d;return c}function fj(a){var b=Gi(a,Z(a)),c=Ni(Mi,b),b=c[0],d=c[1],c=c[2];return void 0!==d&amp;&amp;&quot;:/&quot;===d.substring(d.length-2,d.length)||&quot;:&quot;===c[c.length-1]||-1!==b.indexOf(&quot;::&quot;,1)?$.k(a,P([&quot;Invalid token: &quot;,b],0)):null!=d&amp;&amp;0&lt;d.length?Yc.c(d.substring(0,d.indexOf(&quot;/&quot;)),c):Yc.e(b)}\nfunction gj(a){return function(b){return Ga(Ga(M,Ui.n?Ui.n(b,!0,null,!0):Ui.call(null,b,!0,null)),a)}}function hj(){return function(a){return $.k(a,P([&quot;Unreadable form&quot;],0))}}\nfunction ij(a){var b;b=Ui.n?Ui.n(a,!0,null,!0):Ui.call(null,a,!0,null);b=b instanceof F?new s(null,1,[mg,b],null):&quot;string&quot;===typeof b?new s(null,1,[mg,b],null):b instanceof W?new we([b,!0]):b;zc(b)||$.k(a,P([&quot;Metadata must be Symbol,Keyword,String or Map&quot;],0));var c=Ui.n?Ui.n(a,!0,null,!0):Ui.call(null,a,!0,null);return(c?c.l&amp;262144||c.Cc||(c.l?0:w(db,c)):w(db,c))?tc(c,Ve.k(P([uc(c),b],0))):$.k(a,P([&quot;Metadata can only be applied to IWithMetas&quot;],0))}\nfunction jj(a){a:if(a=Ti(&quot;}&quot;,a),a=I(a),null==a)a=Ye;else if(a instanceof Vb&amp;&amp;0===a.i){a=a.h;b:{for(var b=0,c=sb(Ye);;)if(b&lt;a.length)var d=b+1,c=c.Qa(null,a[b]),b=d;else{a=c;break b}a=void 0}a=a.Ra(null)}else{for(d=sb(Ye);;)if(null!=a)b=a.fa(null),d=d.Qa(null,a.X(null)),a=b;else{a=d.Ra(null);break a}a=void 0}return a}function kj(a){return bf(dj(a))}function lj(a){Ui.n?Ui.n(a,!0,null,!0):Ui.call(null,a,!0,null);return a}\nfunction Hi(a){return&apos;&quot;&apos;===a?cj:&quot;:&quot;===a?fj:&quot;;&quot;===a?Ii:&quot;&apos;&quot;===a?gj(new F(null,&quot;quote&quot;,&quot;quote&quot;,1377916282,null)):&quot;@&quot;===a?gj(new F(null,&quot;deref&quot;,&quot;deref&quot;,1494944732,null)):&quot;^&quot;===a?ij:&quot;`&quot;===a?Vi:&quot;~&quot;===a?Vi:&quot;(&quot;===a?$i:&quot;)&quot;===a?Zi:&quot;[&quot;===a?aj:&quot;]&quot;===a?Zi:&quot;{&quot;===a?bj:&quot;}&quot;===a?Zi:&quot;\\\\&quot;===a?Z:&quot;#&quot;===a?Wi:null}function Xi(a){return&quot;{&quot;===a?jj:&quot;\\x3c&quot;===a?hj():&apos;&quot;&apos;===a?kj:&quot;!&quot;===a?Ii:&quot;_&quot;===a?lj:null}\nfunction Ui(a,b,c){for(;;){var d=Z(a);if(null==d)return v(b)?$.k(a,P([&quot;EOF while reading&quot;],0)):c;if(!Fi(d))if(&quot;;&quot;===d)a=Ii.c?Ii.c(a,d):Ii.call(null,a);else{var e=Hi(d);if(v(e))e=e.c?e.c(a,d):e.call(null,a,d);else{var e=a,f=void 0;!(f=!/[^0-9]/.test(d))&amp;&amp;(f=void 0,f=&quot;+&quot;===d||&quot;-&quot;===d)&amp;&amp;(f=Z(e),Di(e,f),f=!/[^0-9]/.test(f));if(f)a:{e=a;d=new ga(d);for(f=Z(e);;){var g;g=null==f;g||(g=(g=Fi(f))?g:Hi.e?Hi.e(f):Hi.call(null,f));if(v(g)){Di(e,f);f=d=d.toString();g=void 0;if(v(Ni(Ji,f)))if(f=Ni(Ji,f),null!=\nf[2])g=0;else{g=v(f[3])?[f[3],10]:v(f[4])?[f[4],16]:v(f[5])?[f[5],8]:v(f[6])?[f[7],parseInt(f[6],10)]:[null,null];var k=g[0];null==k?g=null:(g=parseInt(k,g[1]),g=&quot;-&quot;===f[1]?-g:g)}else g=void 0,v(Ni(Ki,f))?(f=Ni(Ki,f),g=parseInt(f[1],10)/parseInt(f[2],10)):g=v(Ni(Li,f))?parseFloat(f):null;f=g;e=v(f)?f:$.k(e,P([&quot;Invalid number format [&quot;,d,&quot;]&quot;],0));break a}d.append(f);f=Z(e)}e=void 0}else e=ej(a,d)}if(e!==a)return e}}}\nvar mj=function(a,b){return function(c,d){return U.c(v(d)?b:a,c)}}(new Xd(null,13,5,be,[null,31,28,31,30,31,30,31,31,30,31,30,31],null),new Xd(null,13,5,be,[null,31,29,31,30,31,30,31,31,30,31,30,31],null)),nj=/(\\d\\d\\d\\d)(?:-(\\d\\d)(?:-(\\d\\d)(?:[T](\\d\\d)(?::(\\d\\d)(?::(\\d\\d)(?:[.](\\d+))?)?)?)?)?)?(?:[Z]|([-+])(\\d\\d):(\\d\\d))?/;function oj(a){a=parseInt(a,10);return sa(isNaN(a))?a:null}\nfunction pj(a,b,c,d){a&lt;=b&amp;&amp;b&lt;=c||$.k(null,P([&quot;&quot;+y.e(d)+&quot; Failed:  &quot;+y.e(a)+&quot;\\x3c\\x3d&quot;+y.e(b)+&quot;\\x3c\\x3d&quot;+y.e(c)],0));return b}\nfunction qj(a){var b=af(nj,a);T.f(b,0,null);var c=T.f(b,1,null),d=T.f(b,2,null),e=T.f(b,3,null),f=T.f(b,4,null),g=T.f(b,5,null),k=T.f(b,6,null),l=T.f(b,7,null),m=T.f(b,8,null),n=T.f(b,9,null),p=T.f(b,10,null);if(sa(b))return $.k(null,P([&quot;Unrecognized date/time syntax: &quot;+y.e(a)],0));a=oj(c);var b=function(){var a=oj(d);return v(a)?a:1}(),c=function(){var a=oj(e);return v(a)?a:1}(),r=function(){var a=oj(f);return v(a)?a:0}(),t=function(){var a=oj(g);return v(a)?a:0}(),u=function(){var a=oj(k);return v(a)?\na:0}(),A=function(){var a;a:if(E.c(3,S(l)))a=l;else if(3&lt;S(l))a=Rc.f(l,0,3);else{for(a=new ga(l);;)if(3&gt;a.Ua.length)a=a.append(&quot;0&quot;);else{a=a.toString();break a}a=void 0}a=oj(a);return v(a)?a:0}(),m=(E.c(m,&quot;-&quot;)?-1:1)*(60*function(){var a=oj(n);return v(a)?a:0}()+function(){var a=oj(p);return v(a)?a:0}());return new Xd(null,8,5,be,[a,pj(1,b,12,&quot;timestamp month field must be in range 1..12&quot;),pj(1,c,mj.c?mj.c(b,0===(a%4+4)%4&amp;&amp;(0!==(a%100+100)%100||0===(a%400+400)%400)):mj.call(null,b,0===(a%4+4)%4&amp;&amp;(0!==\n(a%100+100)%100||0===(a%400+400)%400)),&quot;timestamp day field must be in range 1..last day in month&quot;),pj(0,r,23,&quot;timestamp hour field must be in range 0..23&quot;),pj(0,t,59,&quot;timestamp minute field must be in range 0..59&quot;),pj(0,u,E.c(t,59)?60:59,&quot;timestamp second field must be in range 0..60&quot;),pj(0,A,999,&quot;timestamp millisecond field must be in range 0..999&quot;),m],null)}\nfunction rj(a){var b;if(&quot;string&quot;===typeof a)if(b=qj(a),v(b)){a=T.f(b,0,null);var c=T.f(b,1,null),d=T.f(b,2,null),e=T.f(b,3,null),f=T.f(b,4,null),g=T.f(b,5,null),k=T.f(b,6,null);b=T.f(b,7,null);b=new Date(Date.UTC(a,c-1,d,e,f,g,k)-6E4*b)}else b=$.k(null,P([&quot;Unrecognized date/time syntax: &quot;+y.e(a)],0));else b=$.k(null,P([&quot;Instance literal expects a string for its timestamp.&quot;],0));return b}function sj(a){return Ac(a)?Fd.c(me,a):$.k(null,P([&quot;Queue literal expects a vector for its elements.&quot;],0))}\nfunction tj(a){if(Ac(a)){var b=[];a=I(a);for(var c=null,d=0,e=0;;)if(e&lt;d){var f=c.N(null,e);b.push(f);e+=1}else if(a=I(a))c=a,Bc(c)?(a=zb(c),e=Ab(c),c=a,d=S(a),a=e):(a=K(c),b.push(a),a=N(c),c=null,d=0),e=0;else break;return b}if(zc(a)){b={};a=I(a);c=null;for(e=d=0;;)if(e&lt;d){var g=c.N(null,e),f=T.f(g,0,null),g=T.f(g,1,null);b[Xc(f)]=g;e+=1}else if(a=I(a))Bc(a)?(d=zb(a),a=Ab(a),c=d,d=S(d)):(d=K(a),c=T.f(d,0,null),d=T.f(d,1,null),b[Xc(c)]=d,a=N(a),c=null,d=0),e=0;else break;return b}return $.k(null,\nP([&quot;JS literal expects a vector or map containing only string or unqualified keyword keys&quot;],0))}function uj(a){return&quot;string&quot;===typeof a?new tf(a):$.k(null,P([&quot;UUID literal expects a string as its representation.&quot;],0))}var vj=X.e?X.e(new s(null,4,[&quot;inst&quot;,rj,&quot;uuid&quot;,uj,&quot;queue&quot;,sj,&quot;js&quot;,tj],null)):X.call(null,new s(null,4,[&quot;inst&quot;,rj,&quot;uuid&quot;,uj,&quot;queue&quot;,sj,&quot;js&quot;,tj],null)),wj=X.e?X.e(null):X.call(null,null);\nfunction Yi(a,b){var c=ej(a,b),d=U.c(Q.e?Q.e(vj):Q.call(null,vj),&quot;&quot;+y.e(c)),e=Q.e?Q.e(wj):Q.call(null,wj);return v(d)?d.e?d.e(Ui(a,!0,null)):d.call(null,Ui(a,!0,null)):v(e)?e.c?e.c(c,Ui(a,!0,null)):e.call(null,c,Ui(a,!0,null)):$.k(a,P([&quot;Could not find tag parser for &quot;,&quot;&quot;+y.e(c),&quot; in &quot;,xd.k(P([Ue(Q.e?Q.e(vj):Q.call(null,vj))],0))],0))};var xj;a:{var yj=aa.navigator;if(yj){var zj=yj.userAgent;if(zj){xj=zj;break a}}xj=&quot;&quot;}function Aj(a){return-1!=xj.indexOf(a)};var Bj=Aj(&quot;Opera&quot;)||Aj(&quot;OPR&quot;),Cj=Aj(&quot;Trident&quot;)||Aj(&quot;MSIE&quot;),Dj=Aj(&quot;Gecko&quot;)&amp;&amp;-1==xj.toLowerCase().indexOf(&quot;webkit&quot;)&amp;&amp;!(Aj(&quot;Trident&quot;)||Aj(&quot;MSIE&quot;)),Ej=-1!=xj.toLowerCase().indexOf(&quot;webkit&quot;),Fj=function(){var a=&quot;&quot;,b;if(Bj&amp;&amp;aa.opera)return a=aa.opera.version,&quot;function&quot;==q(a)?a():a;Dj?b=/rv\\:([^\\);]+)(\\)|;)/:Cj?b=/\\b(?:MSIE|rv)[: ]([^\\);]+)(\\)|;)/:Ej&amp;&amp;(b=/WebKit\\/(\\S+)/);b&amp;&amp;(a=(a=b.exec(xj))?a[1]:&quot;&quot;);return Cj&amp;&amp;(b=(b=aa.document)?b.documentMode:void 0,b&gt;parseFloat(a))?String(b):a}(),Gj={};\nfunction Hj(a){var b;if(!(b=Gj[a])){b=0;for(var c=String(Fj).replace(/^[\\s\\xa0]+|[\\s\\xa0]+$/g,&quot;&quot;).split(&quot;.&quot;),d=String(a).replace(/^[\\s\\xa0]+|[\\s\\xa0]+$/g,&quot;&quot;).split(&quot;.&quot;),e=Math.max(c.length,d.length),f=0;0==b&amp;&amp;f&lt;e;f++){var g=c[f]||&quot;&quot;,k=d[f]||&quot;&quot;,l=RegExp(&quot;(\\\\d*)(\\\\D*)&quot;,&quot;g&quot;),m=RegExp(&quot;(\\\\d*)(\\\\D*)&quot;,&quot;g&quot;);do{var n=l.exec(g)||[&quot;&quot;,&quot;&quot;,&quot;&quot;],p=m.exec(k)||[&quot;&quot;,&quot;&quot;,&quot;&quot;];if(0==n[0].length&amp;&amp;0==p[0].length)break;b=ea(0==n[1].length?0:parseInt(n[1],10),0==p[1].length?0:parseInt(p[1],10))||ea(0==n[2].length,0==p[2].length)||\nea(n[2],p[2])}while(0==b)}b=Gj[a]=0&lt;=b}return b};Cj&amp;&amp;Hj(&quot;9&quot;);!Ej||Hj(&quot;528&quot;);Dj&amp;&amp;Hj(&quot;1.9b&quot;)||Cj&amp;&amp;Hj(&quot;8&quot;)||Bj&amp;&amp;Hj(&quot;9.5&quot;)||Ej&amp;&amp;Hj(&quot;528&quot;);Dj&amp;&amp;!Hj(&quot;8&quot;)||Cj&amp;&amp;Hj(&quot;9&quot;);var Ij=function(){function a(a,d){var e=null;1&lt;arguments.length&amp;&amp;(e=P(Array.prototype.slice.call(arguments,1),0));return b.call(this,a,e)}function b(a,b){var e=Fc(b)?sc.c(ud,b):b,f=U.f(e,rg,fh.e(new Ig(Gg(1024),1024))),g=U.f(e,Yf,fh.e(new Ig(Gg(1024),1024))),k=U.f(e,vg,fh.e(new Ig(Gg(1024),1024))),l=new WebSocket(a);l.onopen=function(a,b,c,d,e){return function(){return hh.c(e,new s(null,1,[Xf,wf],null))}}(l,l,b,e,f,g,k);l.onmessage=function(a,b,c,d,e,f,g){return function(a){return hh.c(g,Ui(new Ei(a.data,\n[],-1),!1,null))}}(l,l,b,e,f,g,k);l.onerror=function(a,b,c,d,e){return function(a){return hh.c(e,new s(null,2,[Xf,kg,Zf,a.data],null))}}(l,l,b,e,f,g,k);l.onclose=function(a,b,c,d,e,f,g){return function(){hh.c(e,new s(null,2,[Xf,Tf,lg,v(zg(f))?qg:xf],null));yg(g);yg(f);return yg(e)}}(l,l,b,e,f,g,k);var m=fh.e(1);Pg(function(a,b,c,d,e,f,g){return function(){var k=function(){return function(a){return function(){function b(c){for(;;){var d;a:{try{for(;;){var e=a(c);if(!Wc(e,Mf)){d=e;break a}}}catch(f){if(f instanceof\nObject){c[5]=f;bh(c);d=Mf;break a}throw f;}d=void 0}if(!Wc(d,Mf))return d}}function c(){var a=[null,null,null,null,null,null,null,null,null];a[0]=d;a[1]=1;return a}var d=null,d=function(a){switch(arguments.length){case 0:return c.call(this);case 1:return b.call(this,a)}throw Error(&quot;Invalid arity: &quot;+arguments.length);};d.v=c;d.e=b;return d}()}(function(a,b,c,d,e,f){return function(a){var c=a[1];return 7===c?(c=a,c[2]=a[2],c[1]=3,Mf):6===c?(c=b.close(),a[2]=c,a[1]=7,Mf):5===c?(c=xd.k(P([a[7]],0)),c=\nb.send(c),a[8]=c,a[2]=null,a[1]=2,Mf):4===c?(c=a[2],a[7]=c,a[1]=v(c)?5:6,Mf):3===c?(c=a[2],ah(a,c)):2===c?$g(a,f):1===c?(a[2]=null,a[1]=2,Mf):null}}(a,b,c,d,e,f,g),a,b,c,d,e,f,g)}(),l=function(){var b=k.v?k.v():k.call(null);b[6]=a;return b}();return Zg(l)}}(m,l,b,e,f,g,k));return new s(null,3,[vg,k,Yf,g,rg,f],null)}a.A=1;a.o=function(a){var d=K(a);a=L(a);return b(d,a)};a.k=b;return a}();var Jj=Ui(new Ei(marmoset_payload,[],-1),!1,null),Kj=bg.e(Jj),Lj=Qf.e(Jj),Mj=Ij(&quot;ws://&quot;+y.e(top.location.host)+&quot;/marmoset-ws/&quot;+y.e(&quot;&quot;+y.e(Kj)));function Nj(){(new MutationObserver(function(){return frameElement.height=document.documentElement.offsetHeight})).observe(document.body,{subtree:!0,characterData:!0,childList:!0,attributes:!0})};var Oj,Ci=X.e?X.e(If.e(Lj)):X.call(null,If.e(Lj)),Pj=fh.e(1);\nPg(function(a){return function(){var b=function(){return function(a){return function(){function b(c){for(;;){var e;a:{try{for(;;){var f=a(c);if(!Wc(f,Mf)){e=f;break a}}}catch(g){if(g instanceof Object){c[5]=g;bh(c);e=Mf;break a}throw g;}e=void 0}if(!Wc(e,Mf))return e}}function c(){var a=[null,null,null,null,null,null,null,null,null];a[0]=g;a[1]=1;return a}var g=null,g=function(a){switch(arguments.length){case 0:return c.call(this);case 1:return b.call(this,a)}throw Error(&quot;Invalid arity: &quot;+arguments.length);\n};g.v=c;g.e=b;return g}()}(function(){return function(a){var b=a[1];return 7===b?(b=a,b[2]=a[2],b[1]=3,Mf):6===b?(a[2]=null,a[1]=7,Mf):5===b?(b=a[7],b=wd.c?wd.c(Ci,b):wd.call(null,Ci,b),a[8]=b,a[2]=null,a[1]=2,Mf):4===b?(b=a[2],a[7]=b,a[1]=v(b)?5:6,Mf):3===b?(b=a[2],ah(a,b)):2===b?(b=vg.e(Mj),$g(a,b)):1===b?(a[2]=null,a[1]=2,Mf):null}}(a),a)}(),c=function(){var c=b.v?b.v():b.call(null);c[6]=a;return c}();return Zg(c)}}(Pj));\nvar Bi=function Qj(b,c){&quot;undefined&quot;===typeof Oj&amp;&amp;(Oj=function(b,c,f,g){this.owner=b;this.data=c;this.ad=f;this.Gc=g;this.w=0;this.l=393216},Oj.eb=!0,Oj.cb=&quot;foo/t22837&quot;,Oj.pb=function(b,c){return D(c,&quot;foo/t22837&quot;)},Oj.prototype.dc=!0,Oj.prototype.ec=function(){return React.DOM.progress(rf(new s(null,3,[If,this.data,$f,$f.e(Lj),Vf,new s(null,1,[Jf,&quot;100%&quot;],null)],null)))},Oj.prototype.J=function(){return this.Gc},Oj.prototype.K=function(b,c){return new Oj(this.owner,this.data,this.ad,c)});return new Oj(c,\nb,Qj,null)};window.onload=function(){Nj();return Ai()};\n//# sourceMappingURL=main.js.map&lt;/script&gt;&lt;/head&gt;&lt;body&gt;&lt;/body&gt;&lt;/html&gt;\" style=\"width: 100%; height: 10;\" vspace=\"0\"></iframe>"}
;; <=

;; @@
(def v (atom 0))
;; @@
;; =>
;;; {"type":"html","content":"<span class='clj-var'>#&#x27;marmoset.notebook/v</span>","value":"#'marmoset.notebook/v"}
;; <=

;; @@
;(mu/progress-view v 1000)
;; @@

;; @@
(doseq [i (range 1000)]
  (swap! v inc)
  (Thread/sleep 10))
;; @@
;; =>
;;; {"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"}
;; <=

;; @@
(require '[marmoset.core :as m]
         '[clojure.core.async :as async])
;; @@
